      subroutine Xlinkene(i,j,iltyp,ir,eij)
      implicit none
#ifdef MPI
      include "mpif.h"
#endif
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.XLINKS'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.LOCAL'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      double precision erij(3),dcosom1(3),dcosom2(3),gg(3)
      integer i,j,iltyp,k,l,nbi,ir
      double precision eij
      double precision dxi,dyi,dzi,dxj,dyj,dzj,xi,yi,zi,xj,yj,zj,rij,
     & rrij,dsci_inv,dscj_inv,cosom1,sinom1,cosom2,sinom2,cosom12,
     & cosphi,edij,dedij,et1ij,det1ij,det1t2ij,
     & et2ij,det2ij,ephiij,dephiij,usum,usumder,uprod,uprod1,diff,
     & cosaux,sinaux,ggk,ud(maxxlink),u(maxxlink),usumsqder,uprod2
      double precision mytschebyshev
#ifdef DEBUG
      write (iout,*) "Xlinkene",i,j,iltyp
#endif
      dxi=dc_norm(1,nres+i)
      dyi=dc_norm(2,nres+i)
      dzi=dc_norm(3,nres+i)
      dxj=dc_norm(1,nres+j)
      dyj=dc_norm(2,nres+j)
      dzj=dc_norm(3,nres+j)
      xi=c(1,i)+dc(1,nres+i)*rxlink(1,iltyp)
      yi=c(2,i)+dc(2,nres+i)*rxlink(1,iltyp)
      zi=c(3,i)+dc(3,nres+i)*rxlink(1,iltyp)
c      write (iout,*) xi,yi,zi
      xj=c(1,j)+dc(1,nres+j)*rxlink(2,iltyp)-xi
      yj=c(2,j)+dc(2,nres+j)*rxlink(2,iltyp)-yi
      zj=c(3,j)+dc(3,nres+j)*rxlink(2,iltyp)-zi
c      write (iout,*) xj+xi,yj+yi,zj+zi
      dsci_inv=vbld_inv(nres+i)!/rxlink(1,iltyp)
      dscj_inv=vbld_inv(nres+j)!/rxlink(2,iltyp)
      rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
      rij=dsqrt(rrij)
      erij(1)=xj*rij
      erij(2)=yj*rij
      erij(3)=zj*rij
      cosom1=dxi*erij(1)+dyi*erij(2)+dzi*erij(3)
      cosom2=dxj*erij(1)+dyj*erij(2)+dzj*erij(3)
      sinom1=dsqrt(1.0d0-cosom1*cosom1)
      sinom2=dsqrt(1.0d0-cosom2*cosom2)
      cosom12=dxi*dxj+dyi*dyj+dzi*dzj
      do k=1,3
        dcosom1(k)=rij*(dc_norm(k,nres+i)-cosom1*erij(k))
        dcosom2(k)=rij*(dc_norm(k,nres+j)-cosom2*erij(k))
      enddo
      rij=1.0d0/rij
      nbi=nbxlink(iltyp)
      if (nbi.eq.1) then
        diff=rij-dxlink(1,iltyp)
        dedij=aklink(1,iltyp)*diff
        edij=0.5d0*dedij*diff
      else
        do k=1,nbi
          diff=rij-dxlink(k,iltyp)
          ud(k)=aklink(k,iltyp)*diff
          u(k)=alink(k,iltyp)+0.5d0*ud(k)*diff
        enddo
        uprod=u(1)
        do k=2,nbi
          uprod=uprod*u(k)
        enddo
        usum=0.0d0
        usumsqder=0.0d0
        do k=1,nbi
          uprod1=1.0d0
          uprod2=1.0d0
          do l=1,nbi
            if (l.ne.k) then
              uprod1=uprod1*u(l)
              uprod2=uprod2*u(l)*u(l)
            endif
          enddo
          usum=usum+uprod1
          usumsqder=usumsqder+ud(k)*uprod2
        enddo
        edij=uprod/usum
        dedij=usumsqder/(usum*usum)
      endif
      et1ij=v0tlink(1,iltyp)
c      write (iout,*) "V0t1",v0tlink(1,iltyp)
      det1ij=0.0d0
      cosaux=1.0d0
      sinaux=1.0d0
      do k=1,ntxlink(1,iltyp)
       det1ij=det1ij-k*axlink(k,1,iltyp)*cosaux
     &              -k*bxlink(k,1,iltyp)*sinaux*cosom1/sinom1
        cosaux=-cosaux*cosom1
        sinaux=sinaux*sinom1
        et1ij=et1ij+axlink(k,1,iltyp)*cosaux+bxlink(k,1,iltyp)*sinaux
      enddo
      et2ij=v0tlink(2,iltyp)
c      write (iout,*) "V0t2",v0tlink(2,iltyp)
      det2ij=0.0d0
      cosaux=1.0d0
      sinaux=1.0d0
      do k=1,ntxlink(2,iltyp)
       det2ij=det2ij+k*axlink(k,2,iltyp)*cosaux
     &              -k*bxlink(k,2,iltyp)*sinaux*cosom2/sinom2
        cosaux=cosaux*cosom2
        sinaux=sinaux*sinom2
        et2ij=et2ij+axlink(k,2,iltyp)*cosaux+bxlink(k,2,iltyp)*sinaux
      enddo
      sinaux=sinom1*sinom2
      cosphi=cosom12-cosom1*cosom2
      ephiij=v0glink(iltyp)+
     &   mytschebyshev(1,ngxlink(iltyp),vglink(1,iltyp),cosphi,sinaux)
      call mygradtschebyshev(1,ngxlink(iltyp),vglink(1,iltyp),
     &   cosphi,sinaux,dephiij,det1t2ij)
c      edij=0.0d0
c      dedij=0.0d0
c      et1ij=0.0d0
c      et2ij=0.0d0
c      ephiij=0.0d0
c      det1ij=0.0d0
c      det2ij=0.0d0
c      dephiij=0.0d0
c      det1t2ij=0.0d0
      eij=edij+et1ij+et2ij+ephiij
#ifdef DEBUG
      write (iout,*) "rij",rij," cosom1",cosom1," cosom2",cosom2,
     &" sinom1",sinom1," sinom2",sinom2,
     &" theta1",180-rad2deg*dacos(cosom1),
     &" theta2",rad2deg*dacos(cosom2)," cosom12",cosom12,
     &" cosphi",cosphi,cosphi/(sinom1*sinom2),
     &" gamma",rad2deg*dacos(cosphi/(sinom1*sinom2))
      write (iout,*) "edij",edij," et1ij",et1ij," et2ij",et2ij,
     &  " ephiij",ephiij
#endif
      if (energy_dec) write(iout,'(a6,2i5,f8.3,3f8.2,5f10.3,i5)') 
     & "edisX",i,j,rij,180-rad2deg*dacos(cosom1),rad2deg*dacos(cosom2),
     & rad2deg*dacos(cosphi/(sinom1*sinom2)),edij,et1ij,et2ij,ephiij,
     & eij,ir
c      write (iout,*) "ded",dedij
      det1ij=det1ij-det1t2ij*sinom2*cosom1/sinom1-dephiij*cosom2
      det2ij=det2ij-det1t2ij*sinom1*cosom2/sinom2-dephiij*cosom1
      do k=1,3
        ggk=dedij*erij(k)+det1ij*dcosom1(k)+det2ij*dcosom2(k)
        ghpbx(k,i)=ghpbx(k,i)-ggk*rxlink(1,iltyp)
     &           +(dephiij*(dc_norm(k,nres+j)-cosom12*dc_norm(k,nres+i))
     &     +det1ij*(erij(k)-cosom1*dc_norm(k,nres+i)))
     &       *dsci_inv
        ghpbx(k,j)=ghpbx(k,j)+ggk*rxlink(2,iltyp)
     &           +(dephiij*(dc_norm(k,nres+i)-cosom12*dc_norm(k,nres+j))
     &     +det2ij*(erij(k)-cosom2*dc_norm(k,nres+j)))
     &       *dscj_inv
        ghpbc(k,i)=ghpbc(k,i)-ggk
        ghpbc(k,j)=ghpbc(k,j)+ggk
      enddo
      return
      end
c------------------------------------------------------------------------------
      double precision function mytschebyshev(m,n,x,y,yt)
      implicit none
      include "DIMENSIONS"
      integer i,m,n
      double precision x(n),y,yt,yy(0:maxvar),aux
c Tschebyshev polynomial in y multiplied by sin(t1)sin(t2) (yt). 
c Note that the first term is omitted
c m=0: the constant term is included
c m=1: the constant term is not included
      yy(0)=1.0d0
      yy(1)=y
      do i=2,n
        yy(i)=2*yy(1)*yy(i-1)-yy(i-2)*yt*yt
      enddo
      aux=0.0d0
      do i=m,n
        aux=aux+x(i)*yy(i)
      enddo
c      print *,(yy(i),i=1,n)
      mytschebyshev=aux
      return
      end
C--------------------------------------------------------------------------
      subroutine mygradtschebyshev(m,n,x,y,yt,fy,fyt)
      implicit none
      include "DIMENSIONS"
      integer i,m,n
      double precision x(n+1),y,yt,fy,fyt,yy(0:maxvar),yb(0:maxvar),
     & ybt(0:maxvar)
c Derivative of Tschebyshev polynomial in y multiplied by sin(t1)sin(t2) (yt). 
c Note that the first term is omitted
c m=0: the constant term is included
c m=1: the constant term is not included
      yy(0)=1.0d0
      yy(1)=y
      yb(0)=0.0d0
      yb(1)=1.0d0
      ybt(0)=0.0d0
      ybt(1)=0.0d0
      do i=2,n
        yy(i)=2*yy(1)*yy(i-1)-yy(i-2)*yt*yt
        yb(i)=2*yy(i-1)+2*yy(1)*yb(i-1)-yb(i-2)*yt*yt
        ybt(i)=2*yy(1)*ybt(i-1)-ybt(i-2)*yt*yt-2*yy(i-2)*yt
      enddo
      fy=0.0d0
      fyt=0.0d0
      do i=m,n
        fy=fy+x(i)*yb(i)
        fyt=fyt+x(i)*ybt(i)
      enddo
      return
      end 
