              subroutine store_parm(iparm)
C
C Store parameters of set IPARM
C valence angles and the side chains and energy parameters.
C
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'DIMENSIONS.FREE'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.FFIELD'
      include 'COMMON.NAMES'
      include 'COMMON.SBRIDGE'
      include 'COMMON.SCROT'
      include 'COMMON.SCCOR'
      include 'COMMON.ALLPARM'
      integer i,ii,j,k,l,m,mm,iparm,ichir1,ichir2,iblock,iii

c Store weights
      ww_all(1,iparm)=wsc
      ww_all(2,iparm)=wscp
      ww_all(3,iparm)=welec
      ww_all(4,iparm)=wcorr
      ww_all(5,iparm)=wcorr5
      ww_all(6,iparm)=wcorr6
      ww_all(7,iparm)=wel_loc
      ww_all(8,iparm)=wturn3
      ww_all(9,iparm)=wturn4
      ww_all(10,iparm)=wturn6
      ww_all(11,iparm)=wang
      ww_all(12,iparm)=wscloc
      ww_all(13,iparm)=wtor
      ww_all(14,iparm)=wtor_d
      ww_all(15,iparm)=wstrain
      ww_all(16,iparm)=wvdwpp
      ww_all(17,iparm)=wbond
      ww_all(19,iparm)=wsccor
      ww_all(22,iparm)=wliptran
      ww_all(26,iparm)=wsaxs
c Store bond parameters
      vbldp0_all(iparm)=vbldp0
      akp_all(iparm)=akp
      do i=1,ntyp
        nbondterm_all(i,iparm)=nbondterm(i)
        do j=1,nbondterm(i)
          vbldsc0_all(j,i,iparm)=vbldsc0(j,i)
          aksc_all(j,i,iparm)=aksc(j,i)
          abond0_all(j,i,iparm)=abond0(j,i)
        enddo
      enddo
c Store bond angle parameters
#ifdef CRYST_THETA
      do i=-ntyp,ntyp
        a0thet_all(i,iparm)=a0thet(i)
        do ichir1=-1,1
        do ichir2=-1,1
        do j=1,2
          athet_all(j,i,ichir1,ichir2,iparm)=athet(j,i,ichir1,ichir2)
          bthet_all(j,i,ichir1,ichir2,iparm)=bthet(j,i,ichir1,ichir2)
        enddo
        enddo
        enddo
        do j=0,3
          polthet_all(j,i,iparm)=polthet(j,i)
        enddo
        do j=1,3
          gthet_all(j,i,iparm)=gthet(j,i)
        enddo
        theta0_all(i,iparm)=theta0(i)
        sig0_all(i,iparm)=sig0(i)
        sigc0_all(i,iparm)=sigc0(i)
      enddo
#else
      nthetyp_all(iparm)=nthetyp
      ntheterm_all(iparm)=ntheterm
      ntheterm2_all(iparm)=ntheterm2
      ntheterm3_all(iparm)=ntheterm3
      nsingle_all(iparm)=nsingle
      ndouble_all(iparm)=ndouble
      nntheterm_all(iparm)=nntheterm
      do i=-ntyp,ntyp
        ithetyp_all(i,iparm)=ithetyp(i)
      enddo
      do iblock=1,2
      do i=-maxthetyp1,maxthetyp1
        do j=-maxthetyp1,maxthetyp1
          do k=-maxthetyp1,maxthetyp1
            aa0thet_all(i,j,k,iblock,iparm)=aa0thet(i,j,k,iblock)
            do l=1,ntheterm
              aathet_all(l,i,j,k,iblock,iparm)=aathet(l,i,j,k,iblock)
            enddo
            do l=1,ntheterm2
              do m=1,nsingle
                bbthet_all(m,l,i,j,k,iblock,iparm)=
     & bbthet(m,l,i,j,k,iblock)
                ccthet_all(m,l,i,j,k,iblock,iparm)=
     &ccthet(m,l,i,j,k,iblock)
                ddthet_all(m,l,i,j,k,iblock,iparm)=
     &ddthet(m,l,i,j,k,iblock)
                eethet_all(m,l,i,j,k,iblock,iparm)=
     &eethet(m,l,i,j,k,iblock)
              enddo
            enddo
            do l=1,ntheterm3
              do m=1,ndouble
                do mm=1,ndouble
                if (iblock.eq.1) then
                 ffthet_all1(mm,m,l,i,j,k,iparm)=
     &   ffthet(mm,m,l,i,j,k,iblock)
                 ggthet_all1(mm,m,l,i,j,k,iparm)=
     &ggthet(mm,m,l,i,j,k,iblock)
                  else
                 ffthet_all2(mm,m,l,i,j,k,iparm)=
     &   ffthet(mm,m,l,i,j,k,iblock)
                 ggthet_all2(mm,m,l,i,j,k,iparm)=
     &ggthet(mm,m,l,i,j,k,iblock)
                  endif
                enddo
              enddo
            enddo
          enddo
        enddo
      enddo
      enddo
#endif
#ifdef CRYST_SC
c Store the sidechain rotamer parameters
      do i=-ntyp,ntyp
       iii=iabs(i)
cc       write (iout,*) i,"storeparm1"
       if (i.eq.0) cycle
        nlob_all(iii,iparm)=nlob(iii)
        do j=1,nlob(iii)
          bsc_all(j,iii,iparm)=bsc(j,iii)
          do k=1,3
            censc_all(k,j,i,iparm)=censc(k,j,i)
          enddo
          do k=1,3
            do l=1,3
              gaussc_all(l,k,j,i,iparm)=gaussc(l,k,j,i)
            enddo
          enddo
        enddo
      enddo
#else
      do i=1,ntyp
        do j=1,65
          sc_parmin_all(j,i,iparm)=sc_parmin(j,i)
        enddo
      enddo
#ifdef SC_END
      nterm_scend_all(:,:,iparm)=nterm_scend(:,:)
      arotam_end_all(:,:,:,iparm)=arotam_end(:,:,:)
#endif
#endif
c Store the torsional parameters
      do iblock=1,2
      do i=-ntortyp+1,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          v0_all(i,j,iblock,iparm)=v0(i,j,iblock)
          nterm_all(i,j,iblock,iparm)=nterm(i,j,iblock)
          nlor_all(i,j,iblock,iparm)=nlor(i,j,iblock)
          do k=1,nterm(i,j,iblock)
            v1_all(k,i,j,iblock,iparm)=v1(k,i,j,iblock)
            v2_all(k,i,j,iblock,iparm)=v2(k,i,j,iblock)
          enddo
          do k=1,nlor(i,j,iblock)
            vlor1_all(k,i,j,iparm)=vlor1(k,i,j)
            vlor2_all(k,i,j,iparm)=vlor2(k,i,j)
            vlor3_all(k,i,j,iparm)=vlor3(k,i,j)
          enddo
        enddo
      enddo
      enddo  
c Store the double torsional parameters
      do iblock=1,2
      do i=-ntortyp+1,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          do k=-ntortyp+1,ntortyp-1
            ntermd1_all(i,j,k,iblock,iparm)=ntermd_1(i,j,k,iblock)
            ntermd2_all(i,j,k,iblock,iparm)=ntermd_2(i,j,k,iblock)
            do l=1,ntermd_1(i,j,k,iblock)
              v1c_all(1,l,i,j,k,iblock,iparm)=v1c(1,l,i,j,k,iblock)
              v1c_all(2,l,i,j,k,iblock,iparm)=v1c(2,l,i,j,k,iblock)
              v2c_all(1,l,i,j,k,iblock,iparm)=v2c(1,l,i,j,k,iblock)
              v2c_all(2,l,i,j,k,iblock,iparm)=v2c(2,l,i,j,k,iblock)
            enddo
            do l=1,ntermd_2(i,j,k,iblock)
              do m=1,ntermd_2(i,j,k,iblock)
                v2s_all(l,m,i,j,k,iblock,iparm)=v2s(l,m,i,j,k,iblock)
              enddo
            enddo
          enddo
        enddo
      enddo
      enddo
c Store parameters of the cumulants
#ifdef NEWCORR
      do i=-nloctyp+1,nloctyp-1
        do ii=1,3
        do j=1,2
          bnew1_all(ii,j,i,iparm)=bnew1(ii,j,i)
          bnew2_all(ii,j,i,iparm)=bnew2(ii,j,i)
        enddo
        enddo
        do j=1,2
          do k=1,3
            ccnew_all(k,j,i,iparm)=ccnew(k,j,i)
            ddnew_all(k,j,i,iparm)=ddnew(k,j,i)
          enddo
        enddo
        do ii=1,2
          do j=1,2
            do k=1,2
              eenew_all(k,j,ii,i,iparm)=eenew(k,j,ii,i)
            enddo
          enddo
        enddo 
        do ii=1,2
          e0new_all(ii,i,iparm)=e0new(ii,i)
        enddo
      enddo
#else
      do i=-nloctyp,nloctyp
        do j=1,5
          b_all(j,i,iparm)=b(j,i)
        enddo
        do j=1,2
          do k=1,2
            ccold_all(k,j,i,iparm)=ccold(k,j,i)
            ddold_all(k,j,i,iparm)=ddold(k,j,i)
            eeold_all(k,j,i,iparm)=eeold(k,j,i)
          enddo
        enddo
      enddo
#endif
c Store the parameters of electrostatic interactions
      do i=1,2
        do j=1,2
          app_all(j,i,iparm)=app(j,i)
          bpp_all(j,i,iparm)=bpp(j,i)
          ael6_all(j,i,iparm)=ael6(j,i)
          ael3_all(j,i,iparm)=ael3(j,i)
        enddo
      enddo
c Store sidechain parameters
      do i=1,ntyp
        do j=1,ntyp
          aa_aq_all(j,i,iparm)=aa_aq(j,i)
          bb_aq_all(j,i,iparm)=bb_aq(j,i)
          aa_lip_all(j,i,iparm)=aa_lip(j,i)
          bb_lip_all(j,i,iparm)=bb_lip(j,i)
          r0_all(j,i,iparm)=r0(j,i)
          sigma_all(j,i,iparm)=sigma(j,i)
          chi_all(j,i,iparm)=chi(j,i)
          augm_all(j,i,iparm)=augm(j,i)
          eps_all(j,i,iparm)=eps(j,i)
          epslip_all(j,i,iparm)=epslip(j,i)
        enddo
      enddo
      do i=1,ntyp
        chip_all(i,iparm)=chip(i)
        alp_all(i,iparm)=alp(i)
      enddo
c Store the SCp parameters
      do i=1,ntyp
        do j=1,2
          aad_all(i,j,iparm)=aad(i,j)
          bad_all(i,j,iparm)=bad(i,j)
        enddo
      enddo
c Store disulfide-bond parameters
      ebr_all(iparm)=ebr
      d0cm_all(iparm)=d0cm
      akcm_all(iparm)=akcm
      akth_all(iparm)=akth
      akct_all(iparm)=akct
      v1ss_all(iparm)=v1ss
      v2ss_all(iparm)=v2ss
      v3ss_all(iparm)=v3ss
c Store SC-backbone correlation parameters
      do i=-nsccortyp,nsccortyp
       do j=-nsccortyp,nsccortyp

      nterm_sccor_all(j,i,iparm)=nterm_sccor(j,i)
c      do i=1,20
c        do j=1,20
         do l=1,3
          do k=1,nterm_sccor(j,i)
            v1sccor_all(k,l,j,i,iparm)=v1sccor(k,l,j,i)
            v2sccor_all(k,l,j,i,iparm)=v2sccor(k,l,j,i)
           enddo
          enddo
        enddo
      enddo
      return
      end
c--------------------------------------------------------------------------
      subroutine restore_parm(iparm)
C
C Store parameters of set IPARM
C valence angles and the side chains and energy parameters.
C
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'DIMENSIONS.FREE'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.FFIELD'
      include 'COMMON.NAMES'
      include 'COMMON.SBRIDGE'
      include 'COMMON.SCROT'
      include 'COMMON.SCCOR'
      include 'COMMON.ALLPARM'
      integer i,ii,j,k,l,m,mm,iparm,ichir1,ichir2,iblock,iii

c Restore weights
      wsc=ww_all(1,iparm)
      wscp=ww_all(2,iparm)
      welec=ww_all(3,iparm)
      wcorr=ww_all(4,iparm)
      wcorr5=ww_all(5,iparm)
      wcorr6=ww_all(6,iparm)
      wel_loc=ww_all(7,iparm)
      wturn3=ww_all(8,iparm)
      wturn4=ww_all(9,iparm)
      wturn6=ww_all(10,iparm)
      wang=ww_all(11,iparm)
      wscloc=ww_all(12,iparm)
      wtor=ww_all(13,iparm)
      wtor_d=ww_all(14,iparm)
      wstrain=ww_all(15,iparm)
      wvdwpp=ww_all(16,iparm)
      wbond=ww_all(17,iparm)
      wsccor=ww_all(19,iparm)
      wliptran=ww_all(22,iparm)
      wsaxs=ww_all(26,iparm)
c Restore bond parameters
      vbldp0=vbldp0_all(iparm)
      akp=akp_all(iparm)
      do i=1,ntyp
        nbondterm(i)=nbondterm_all(i,iparm)
        do j=1,nbondterm(i)
          vbldsc0(j,i)=vbldsc0_all(j,i,iparm)
          aksc(j,i)=aksc_all(j,i,iparm)
          abond0(j,i)=abond0_all(j,i,iparm)
        enddo
      enddo
c Restore bond angle parameters
#ifdef CRYST_THETA
      do i=-ntyp,ntyp
        a0thet(i)=a0thet_all(i,iparm)
        do ichir1=-1,1
        do ichir2=-1,1
        do j=1,2
          athet(j,i,ichir1,ichir2)=athet_all(j,i,ichir1,ichir2,iparm)
          bthet(j,i,ichir1,ichir2)=bthet_all(j,i,ichir1,ichir2,iparm)
        enddo
        enddo
        enddo
        do j=0,3
          polthet(j,i)=polthet_all(j,i,iparm)
        enddo
        do j=1,3
          gthet(j,i)=gthet_all(j,i,iparm)
        enddo
        theta0(i)=theta0_all(i,iparm)
        sig0(i)=sig0_all(i,iparm)
        sigc0(i)=sigc0_all(i,iparm)
      enddo
#else
      nthetyp=nthetyp_all(iparm)
      ntheterm=ntheterm_all(iparm)
      ntheterm2=ntheterm2_all(iparm)
      ntheterm3=ntheterm3_all(iparm)
      nsingle=nsingle_all(iparm)
      ndouble=ndouble_all(iparm)
      nntheterm=nntheterm_all(iparm)
      do i=-ntyp,ntyp
        ithetyp(i)=ithetyp_all(i,iparm)
      enddo
      do iblock=1,2
      do i=-maxthetyp1,maxthetyp1
        do j=-maxthetyp1,maxthetyp1
          do k=-maxthetyp1,maxthetyp1
            aa0thet(i,j,k,iblock)=aa0thet_all(i,j,k,iblock,iparm)
            do l=1,ntheterm
              aathet(l,i,j,k,iblock)=aathet_all(l,i,j,k,iblock,iparm)
            enddo
            do l=1,ntheterm2
              do m=1,nsingle
                bbthet(m,l,i,j,k,iblock)=
     &bbthet_all(m,l,i,j,k,iblock,iparm)
                ccthet(m,l,i,j,k,iblock)=
     &ccthet_all(m,l,i,j,k,iblock,iparm)
                ddthet(m,l,i,j,k,iblock)=
     &ddthet_all(m,l,i,j,k,iblock,iparm)
                eethet(m,l,i,j,k,iblock)=
     &eethet_all(m,l,i,j,k,iblock,iparm)
              enddo
            enddo
            do l=1,ntheterm3
              do m=1,ndouble
                do mm=1,ndouble
                if (iblock.eq.1) then
                 ffthet(mm,m,l,i,j,k,iblock)=
     &ffthet_all1(mm,m,l,i,j,k,iparm)
                 ggthet(mm,m,l,i,j,k,iblock)=
     &ggthet_all1(mm,m,l,i,j,k,iparm)
                else
                 ffthet(mm,m,l,i,j,k,iblock)=
     &ffthet_all2(mm,m,l,i,j,k,iparm)
                 ggthet(mm,m,l,i,j,k,iblock)=
     &ggthet_all2(mm,m,l,i,j,k,iparm)
                endif
                enddo
              enddo
            enddo
          enddo
        enddo
      enddo
      enddo
#endif
c Restore the sidechain rotamer parameters
#ifdef CRYST_SC
      do i=-ntyp,ntyp
        if (i.eq.0) cycle
        iii=iabs(i)
        nlob(iii)=nlob_all(iii,iparm)
        do j=1,nlob(iii)
          bsc(j,iii)=bsc_all(j,iii,iparm)
          do k=1,3
            censc(k,j,i)=censc_all(k,j,i,iparm)
          enddo
          do k=1,3
            do l=1,3
              gaussc(l,k,j,i)=gaussc_all(l,k,j,i,iparm)
            enddo
          enddo
        enddo
      enddo
#else
      do i=1,ntyp
        do j=1,65
          sc_parmin(j,i)=sc_parmin_all(j,i,iparm)
        enddo
      enddo
#ifdef SC_END
      nterm_scend(:,:)=nterm_scend_all(:,:,iparm)
      arotam_end(:,:,:)=arotam_end_all(:,:,:,iparm)
#endif
#endif
c Restore the torsional parameters
      do iblock=1,2
      do i=-ntortyp+1,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          v0(i,j,iblock)=v0_all(i,j,iblock,iparm)
          nterm(i,j,iblock)=nterm_all(i,j,iblock,iparm)
          nlor(i,j,iblock)=nlor_all(i,j,iblock,iparm)
          do k=1,nterm(i,j,iblock)
            v1(k,i,j,iblock)=v1_all(k,i,j,iblock,iparm)
            v2(k,i,j,iblock)=v2_all(k,i,j,iblock,iparm)
          enddo
          do k=1,nlor(i,j,iblock)
            vlor1(k,i,j)=vlor1_all(k,i,j,iparm)
            vlor2(k,i,j)=vlor2_all(k,i,j,iparm)
            vlor3(k,i,j)=vlor3_all(k,i,j,iparm)
          enddo
        enddo
      enddo  
      enddo
c Restore the double torsional parameters
      do iblock=1,2
      do i=-ntortyp+1,ntortyp-1
        do j=-ntortyp+1,ntortyp-1
          do k=-ntortyp+1,ntortyp-1
            ntermd_1(i,j,k,iblock)=ntermd1_all(i,j,k,iblock,iparm)
            ntermd_2(i,j,k,iblock)=ntermd2_all(i,j,k,iblock,iparm)
            do l=1,ntermd_1(i,j,k,iblock)
              v1c(1,l,i,j,k,iblock)=v1c_all(1,l,i,j,k,iblock,iparm)
              v1c(2,l,i,j,k,iblock)=v1c_all(2,l,i,j,k,iblock,iparm)
              v2c(1,l,i,j,k,iblock)=v2c_all(1,l,i,j,k,iblock,iparm)
              v2c(2,l,i,j,k,iblock)=v2c_all(2,l,i,j,k,iblock,iparm)
            enddo
            do l=1,ntermd_2(i,j,k,iblock)
              do m=1,ntermd_2(i,j,k,iblock)
                v2s(l,m,i,j,k,iblock)=v2s_all(l,m,i,j,k,iblock,iparm)
              enddo
            enddo
          enddo
        enddo
      enddo
      enddo
c Restore parameters of the cumulants
#ifdef NEWCORR
      do i=-nloctyp+1,nloctyp-1
        do ii=1,3
        do j=1,2
          bnew1(ii,j,i)=bnew1_all(ii,j,i,iparm)
          bnew2(ii,j,i)=bnew2_all(ii,j,i,iparm)
        enddo
        enddo
        do j=1,2
          do k=1,3
            ccnew(k,j,i)=ccnew_all(k,j,i,iparm)
            ddnew(k,j,i)=ddnew_all(k,j,i,iparm)
          enddo
        enddo
        do ii=1,2
          do j=1,2
            do k=1,2
              eenew(k,j,ii,i)=eenew_all(k,j,ii,i,iparm)
            enddo
          enddo
        enddo 
        do ii=1,2
          e0new(ii,i)=e0new_all(ii,i,iparm)
        enddo
      enddo
#else
      do i=-nloctyp,nloctyp
        do j=1,5
          b(j,i)=b_all(j,i,iparm)
        enddo
        do j=1,2
          do k=1,2
            ccold(k,j,i)=ccold_all(k,j,i,iparm)
            ddold(k,j,i)=ddold_all(k,j,i,iparm)
            eeold(k,j,i)=eeold_all(k,j,i,iparm)
          enddo
        enddo
      enddo
#endif
c Restore the parameters of electrostatic interactions
      do i=1,2
        do j=1,2
          app(j,i)=app_all(j,i,iparm)
          bpp(j,i)=bpp_all(j,i,iparm)
          ael6(j,i)=ael6_all(j,i,iparm)
          ael3(j,i)=ael3_all(j,i,iparm)
        enddo
      enddo
c Restore sidechain parameters
      do i=1,ntyp
        do j=1,ntyp
          aa_aq(j,i)=aa_aq_all(j,i,iparm)
          bb_aq(j,i)=bb_aq_all(j,i,iparm)
          aa_lip(j,i)=aa_lip_all(j,i,iparm)
          bb_lip(j,i)=bb_lip_all(j,i,iparm)
          r0(j,i)=r0_all(j,i,iparm)
          sigma(j,i)=sigma_all(j,i,iparm)
          chi(j,i)=chi_all(j,i,iparm)
          augm(j,i)=augm_all(j,i,iparm)
          eps(j,i)=eps_all(j,i,iparm)
          epslip(j,i)=epslip_all(j,i,iparm)
        enddo
      enddo
      do i=1,ntyp
        chip(i)=chip_all(i,iparm)
        alp(i)=alp_all(i,iparm)
      enddo
c Restore the SCp parameters
      do i=1,ntyp
        do j=1,2
          aad(i,j)=aad_all(i,j,iparm)
          bad(i,j)=bad_all(i,j,iparm)
        enddo
      enddo
c Restore disulfide-bond parameters
      ebr=ebr_all(iparm)
      d0cm=d0cm_all(iparm)
      akcm=akcm_all(iparm)
      akth=akth_all(iparm)
      akct=akct_all(iparm)
      v1ss=v1ss_all(iparm)
      v2ss=v2ss_all(iparm)
      v3ss=v3ss_all(iparm)
c Restore SC-backbone correlation parameters
      do i=-nsccortyp,nsccortyp
       do j=-nsccortyp,nsccortyp

      nterm_sccor(j,i)=nterm_sccor_all(j,i,iparm)
        do l=1,3
           do k=1,nterm_sccor(j,i)
            v1sccor(k,l,j,i)=v1sccor_all(k,l,j,i,iparm)
            v2sccor(k,l,j,i)=v2sccor_all(k,l,j,i,iparm)
           enddo
          enddo
        enddo
      enddo
      return
      end
