      subroutine read_compar
C
C Read molecular data
C
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'DIMENSIONS.COMPAR'
      include 'DIMENSIONS.FREE'
      include 'COMMON.IOUNITS'
      include 'COMMON.TIME1'
      include 'COMMON.SBRIDGE'
      include 'COMMON.CONTROL'
      include 'COMMON.COMPAR'
      include 'COMMON.CHAIN'
      include 'COMMON.HEADER'
      include 'COMMON.GEO'
      include 'COMMON.FREE'
      character*320 controlcard,ucase
      character*64 wfile
      integer ilen
      external ilen
      integer i,j,k

      call card_concat(controlcard,.true.)
      pdbref=(index(controlcard,'PDBREF').gt.0)
      if (index(controlcard,"CASC").gt.0) then
        iz_sc=1
      else if (index(controlcard,"SCONLY").gt.0) then
        iz_sc=2
      else
        iz_sc=0
      endif
      call reada(controlcard,'CUTOFF_UP',rmscut_base_up,4.0d0)
      call reada(controlcard,'CUTOFF_LOW',rmscut_base_low,3.0d0)
      call reada(controlcard,'RMSUP_LIM',rmsup_lim,4.0d0)
      call reada(controlcard,'RMSUPUP_LIM',rmsupup_lim,7.5d0)
      verbose = index(controlcard,"VERBOSE").gt.0
      lgrp=index(controlcard,"STATIN").gt.0
      lgrp_out=index(controlcard,"STATOUT").gt.0
      merge_helices=index(controlcard,"DONT_MERGE_HELICES").eq.0
      binary = index(controlcard,"BINARY").gt.0
      rmscut_base_up=rmscut_base_up/50
      rmscut_base_low=rmscut_base_low/50
      call reada(controlcard,"FRAC_SEC",frac_sec,0.66666666d0)
      call readi(controlcard,'NLEVEL',nlevel,1)
      if (nlevel.lt.0) goto 121
c Read the data pertaining to elementary fragments (level 1)
      call readi(controlcard,'NFRAG',nfrag(1),0)
      write(iout,*)"nfrag(1)",nfrag(1)
      do j=1,nfrag(1)
        call card_concat(controlcard,.true.)
        write (iout,*) controlcard(:ilen(controlcard))
        call readi(controlcard,'NPIECE',npiece(j,1),0)
        call readi(controlcard,'N_SHIFT1',n_shift(1,j,1),0)
        call readi(controlcard,'N_SHIFT2',n_shift(2,j,1),0)
        call reada(controlcard,'ANGCUT',ang_cut(j),50.0d0)
        call reada(controlcard,'MAXANG',ang_cut1(j),360.0d0)
        call reada(controlcard,'FRAC_MIN',frac_min(j),0.666666d0)
        call reada(controlcard,'NC_FRAC',nc_fragm(j,1),0.5d0)
        call readi(controlcard,'NC_REQ',nc_req_setf(j,1),0)
        call readi(controlcard,'RMS',irms(j,1),0)
        call readi(controlcard,'LOCAL',iloc(j),1)
        call readi(controlcard,'ELCONT',ielecont(j,1),1)
        if (ielecont(j,1).eq.0) then
          call readi(controlcard,'SCCONT',isccont(j,1),1)
        endif
        ang_cut(j)=ang_cut(j)*deg2rad
        ang_cut1(j)=ang_cut1(j)*deg2rad
        do k=1,npiece(j,1)
          call card_concat(controlcard,.true.)
          call readi(controlcard,'IFRAG1',ifrag(1,k,j),0)
          call readi(controlcard,'IFRAG2',ifrag(2,k,j),0)
        enddo
        write(iout,*)"j",j," npiece",npiece(j,1)," ifrag",
     &    (ifrag(1,k,j),ifrag(2,k,j),
     &   k=1,npiece(j,1))," ang_cut",ang_cut(j)*rad2deg,
     &    " ang_cut1",ang_cut1(j)*rad2deg
        write(iout,*)"n_shift",n_shift(1,j,1),n_shift(2,j,1)
        write(iout,*)"nc_frac",nc_fragm(j,1)," nc_req",nc_req_setf(j,1)
        write(iout,*)"irms",irms(j,1)," ielecont",ielecont(j,1),
     &    " ilocal",iloc(j)," isccont",isccont(j,1)
      enddo
c Read data pertaning to higher levels
      do i=2,nlevel
        call card_concat(controlcard,.true.)
        call readi(controlcard,'NFRAG',NFRAG(i),0)
        write (iout,*) "i",i," nfrag",nfrag(i)
        do j=1,nfrag(i)
          call card_concat(controlcard,.true.)
          if (i.eq.2) then
            call readi(controlcard,'ELCONT',ielecont(j,i),0)
            if (ielecont(j,i).eq.0) then
              call readi(controlcard,'SCCONT',isccont(j,i),1)
            endif
            call readi(controlcard,'RMS',irms(j,i),0)
          else
            ielecont(j,i)=0
            isccont(j,i)=0
            irms(j,i)=1
          endif
          call readi(controlcard,'NPIECE',npiece(j,i),0)
          call readi(controlcard,'N_SHIFT1',n_shift(1,j,i),0)
          call readi(controlcard,'N_SHIFT2',n_shift(2,j,i),0)
          call multreadi(controlcard,'IPIECE',ipiece(1,j,i),
     &      npiece(j,i),0)
          call reada(controlcard,'NC_FRAC',nc_fragm(j,i),0.5d0)
          call readi(controlcard,'NC_REQ',nc_req_setf(j,i),0)
          write(iout,*) "j",j," npiece",npiece(j,i)," n_shift",
     &      n_shift(1,j,i),n_shift(2,j,i)," ielecont",ielecont(j,i),
     &      " isccont",isccont(j,i)," irms",irms(j,i)
          write(iout,*) "ipiece",(ipiece(k,j,i),k=1,npiece(j,i))
          write(iout,*)"n_shift",n_shift(1,j,i),n_shift(2,j,i)
          write(iout,*)"nc_frac",nc_fragm(j,i),
     &     " nc_req",nc_req_setf(j,i)
        enddo
      enddo
      if (binary) write (iout,*) "Classes written in binary format."
      return
  121 continue
      call reada(controlcard,'ANGCUT_HEL',angcut_hel,50.0d0)
      call reada(controlcard,'MAXANG_HEL',angcut1_hel,60.0d0)
      call reada(controlcard,'ANGCUT_BET',angcut_bet,90.0d0)
      call reada(controlcard,'MAXANG_BET',angcut1_bet,360.0d0)
      call reada(controlcard,'ANGCUT_STRAND',angcut_strand,90.0d0)
      call reada(controlcard,'MAXANG_STRAND',angcut1_strand,60.0d0)
      call reada(controlcard,'FRAC_MIN',frac_min_set,0.666666d0)
      call reada(controlcard,'NC_FRAC_HEL',ncfrac_hel,0.5d0)
      call readi(controlcard,'NC_REQ_HEL',ncreq_hel,0)
      call reada(controlcard,'NC_FRAC_BET',ncfrac_bet,0.5d0)
      call reada(controlcard,'NC_FRAC_PAIR',ncfrac_pair,0.3d0)
      call readi(controlcard,'NC_REQ_BET',ncreq_bet,0)
      call readi(controlcard,'NC_REQ_PAIR',ncreq_pair,0)
      call readi(controlcard,'NSHIFT_HEL',nshift_hel,3)
      call readi(controlcard,'NSHIFT_BET',nshift_bet,3)
      call readi(controlcard,'NSHIFT_STRAND',nshift_strand,3)
      call readi(controlcard,'NSHIFT_PAIR',nshift_pair,3)
      call readi(controlcard,'RMS_SINGLE',irms_single,0)
      call readi(controlcard,'CONT_SINGLE',icont_single,1)
      call readi(controlcard,'LOCAL_SINGLE',iloc_single,1)
      call readi(controlcard,'RMS_PAIR',irms_pair,0)
      call readi(controlcard,'CONT_PAIR',icont_pair,1)
      call readi(controlcard,'SPLIT_BET',isplit_bet,0)
      angcut_hel=angcut_hel*deg2rad
      angcut1_hel=angcut1_hel*deg2rad
      angcut_bet=angcut_bet*deg2rad
      angcut1_bet=angcut1_bet*deg2rad
      angcut_strand=angcut_strand*deg2rad
      angcut1_strand=angcut1_strand*deg2rad
      write (iout,*) "Automatic detection of structural elements"
      write (iout,*) 'NC_FRAC_HEL',ncfrac_hel,' NC_REQ_HEL',ncreq_hel,
     &               ' NC_FRAC_BET',ncfrac_bet,' NC_REQ_BET',ncreq_bet,
     &           ' RMS_SINGLE',irms_single,' CONT_SINGLE',icont_single,
     &           ' NC_FRAC_PAIR',ncfrac_pair,' NC_REQ_PAIR',ncreq_pair,
     &  ' RMS_PAIR',irms_pair,' CONT_PAIR',icont_pair,
     &  ' SPLIT_BET',isplit_bet
      write (iout,*) 'NSHIFT_HEL',nshift_hel,' NSHIFT_BET',nshift_bet,
     &  ' NSHIFT_STRAND',nshift_strand,' NSHIFT_PAIR',nshift_pair
      write (iout,*) 'ANGCUT_HEL',angcut_hel*rad2deg,
     &  ' MAXANG_HEL',angcut1_hel*rad2deg
      write (iout,*) 'ANGCUT_BET',angcut_bet*rad2deg,
     &               ' MAXANG_BET',angcut1_bet*rad2deg
      write (iout,*) 'ANGCUT_STRAND',angcut_strand*rad2deg,
     &               ' MAXANG_STRAND',angcut1_strand*rad2deg
      write (iout,*) 'FRAC_MIN',frac_min_set
      return
      end
