      subroutine openunits
#ifdef WIN
      use dfport
#endif
c      implicit real*8 (a-h,o-z)
      implicit none
      include 'DIMENSIONS'    
      include 'DIMENSIONS.ZSCOPT'
#ifdef MPI
      include 'mpif.h'
      include 'COMMON.MPI'
      integer MyRank
      character*3 liczba
#endif
      include 'COMMON.IOUNITS'
      integer lenpre,lenpot,ilen
      external ilen

#ifdef MPI
      MyRank=Me
#endif
      call mygetenv('PREFIX',prefix)
      call mygetenv('SCRATCHDIR',scratchdir)
      call mygetenv('POT',pot)
      lenpre=ilen(prefix)
      lenpot=ilen(pot)
      call mygetenv('POT',pot)
      entname=prefix(:lenpre)//'_'//pot(:lenpot)//'.entr'
C Get the names and open the input files
      open (1,file=prefix(:ilen(prefix))//'.inp',status='old')
C Get parameter filenames and open the parameter files.
      call mygetenv('BONDPAR',bondname)
c      open (ibond,file=bondname,status='old')
      call mygetenv('THETPAR',thetname)
c      open (ithep,file=thetname,status='old')
      call mygetenv('ROTPAR',rotname)
#ifdef SC_END
      call mygetenv('ROTPAR_END',rotname_end)
#endif
c      open (irotam,file=rotname,status='old')
      call mygetenv('TORPAR',torname)
c      open (itorp,file=torname,status='old')
      call mygetenv('TORDPAR',tordname)
c      open (itordp,file=tordname,status='old')
      call mygetenv('FOURIER',fouriername)
c      open (ifourier,file=fouriername,status='old')
      call mygetenv('SCCORPAR',sccorname)
c      open (isccor,file=sccorname,status='old')
      call mygetenv('ELEPAR',elename)
c      open (ielep,file=elename,status='old')
      call mygetenv('SIDEPAR',sidename)
c      open (isidep,file=sidename,status='old')
      call mygetenv('SIDEP',sidepname)
      open (isidep1,file=sidepname,status="old")
      call mygetenv('LIPTRANPAR',liptranname)
      open (iliptranpar,file=liptranname,status='old',action='read')
#ifndef OLDSCP
C
C 8/9/01 In the newest version SCp interaction constants are read from a file
C Use -DOLDSCP to use hard-coded constants instead.
C
      call mygetenv('SCPPAR',scpname)
      open (iscpp,file=scpname,status='old')
#endif
C
C 3/19/21 Read XLINK parameters.
C
      call mygetenv('XLINKPAR',xlinkname)
#if defined(WINIFL) || defined(WINPGI)
      open (ixlnk,file=xlinkname,status='old',readonly,shared)
#elif (defined CRAY)  || (defined AIX)
      open (ixlnk,file=xlinkname,status='old',action='read')
#elif (defined G77)
      open (ixlnk,file=xlinkname,status='old')
#else
      open (ixlnk,file=xlinkname,status='old',readonly)
#endif
C
C 1/15/20 Read NMR parameters EL.
C
      call mygetenv('NMRPAR',nmrname)
#if defined(WINIFL) || defined(WINPGI)
      open (inmr,file=nmrname,status='old',readonly,shared)
#elif (defined CRAY)  || (defined AIX)
      open (inmr,file=nmrname,status='old',action='read')
#elif (defined G77)
      open (inmr,file=nmrname,status='old')
#else
      open (inmr,file=nmrname,status='old',readonly)
#endif
#ifdef MPL
      if (MyID.eq.BossID) then
      MyRank = MyID/fgProcs
#endif
#ifdef MPI
      print *,'OpenUnits: processor',MyRank
      call numstr(MyRank,liczba)
      outname=prefix(:lenpre)//'.out_'//pot(:lenpot)//liczba
#else
      outname=prefix(:lenpre)//'.out_'//pot(:lenpot)
#endif
      open(iout,file=outname,status='unknown')
      write (iout,'(80(1h-))')
      write (iout,'(30x,a)') "FILE ASSIGNMENT"
      write (iout,'(80(1h-))')
      write (iout,*) "Input file                      : ",
     &  prefix(:ilen(prefix))//'.inp'
      write (iout,*) "Output file                     : ",
     &  outname(:ilen(outname))
      write (iout,*)
      write (iout,*) "Sidechain potential file        : ",
     &  sidename(:ilen(sidename))
#ifndef OLDSCP
      write (iout,*) "SCp potential file              : ",
     &  scpname(:ilen(scpname))
#endif  
      write (iout,*) "Electrostatic potential file    : ",
     &  elename(:ilen(elename))
      write (iout,*) "Cumulant coefficient file       : ",
     &  fouriername(:ilen(fouriername))
      write (iout,*) "Torsional parameter file        : ",
     &  torname(:ilen(torname))
      write (iout,*) "Double torsional parameter file : ",
     &  tordname(:ilen(tordname))
      write (iout,*) "Backbone-rotamer parameter file : ",
     &  sccorname(:ilen(sccorname))
      write (iout,*) "Bond & inertia constant file    : ",
     &  bondname(:ilen(bondname))
      write (iout,*) "Bending parameter file          : ",
     &  thetname(:ilen(thetname))
      write (iout,*) "Rotamer parameter file          : ",
     &  rotname(:ilen(rotname))
#ifdef SC_END
      write (iout,*) "Rotamer end SC parameter file   : ",
     &  rotname(:ilen(rotname_end))
#endif
      write (iout,*) "Lipid-transfer parameter file   : ",
     &  liptranname(:ilen(liptranname))
      write (iout,'(80(1h-))')
      write (iout,*)
      return
      end

