C EL for NMR restraints
      subroutine nmr_hpos(lprn)
C 
C Calculate positions of all protons for all residues.
C E. Lubecka, February 2020              
C
      implicit none
c      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.NMR'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
c      include 'COMMON.VAR'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.VECTORS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
c      include 'COMMON.CONTROL'
C 
C Calc H alpha positions

c      double precision vpCA(3),vnCA(3),vp2CA(3),vn2CA(3),
c     & NvpCA(3),NvnCA(3),thet(maxres),thet1(maxres),thet2(maxres),
c     & vx(3),vy(3),vz(3),dl_vpCA,dl_vnCA,gamma_(maxres),
c     & vxHA(3),vyHA(3),vzHA(3),dl_vp2CA,dl_vn2CA,
c     & vxHB(3),vyHB(3),vzHB(3),vxHN(3),vyHN(3),vzHN(3),
c     & vx1HN(3),vy1HN(3),vz1HN(3),vx2HN(3),vy2HN(3),vz2HN(3),
c     & Nvp2CA(3),Nvn2CA(3)
      logical lprn
      double precision v1(3),v2(3),ha_tmp(3),qb_tmp(3),dha_tmp(3),
     &  dqb_tmp(3),hn1theta(3),hn2theta(3)
      double precision hn1(3),hn2(3),y2,z2,Psum(3),dlPsum,PHN(3)
c      double precision vlen,a,scalxy,scalxz,scalyz
      double precision HAalphaGly,HAbLenGly,HAalphaPro,
     & HAa1P,HAa2P,HAa3P,HAa4P,HAa5P,HAa6P,HAbLenPro,HAalphaC,
     & HAa1,HAa2,HAa3,HAa4,HAa5,HAa6,HAbLen,
     & HBalphaC,HBa1,HBa2,HBa3,HBa4,HBa5,HBa6,HBbetaC,
     & HBb1,HBb2,HBb3,HBb4,HBb5,HBb6,HBc1,HBc2,HBc3,HBc4,
     & HBc5,HBc6,HBbLen,aalph,Calpha,Salpha,bet,Cbeta,Sbeta,
     & HNa1y,HNa2y,HNa3y,HNa1z,HNa2z,HNa3z,
     & HNb1y,HNb2y,HNb3y,HNb1z,HNb2z,HNb3z,HNdelta,HNepsil
c      double precision conv /.01745329252d0/,pi /3.141592654d0/
      integer i,j,k,l,ichain,ntypProt,innt,inct,iti
      double precision scalar
      double precision x_prime(3),y_prime(3),z_prime(3),cosfac,sinfac,
     & cosfac2,sinfac2,fac
      double precision ux(3),uy1(3),uz1(3),uy2(3),uz2(3),uxder(3,3,2),
     & uyder(3,3,2),uzder(3,3,2),dCder(3,3),
     & uy1der(3,3,2),uz1der(3,3,2),uy2der(3,3,2),uz2der(3,3,2),
     & vbld_inv_temp(2),aux,cosb,sinb,cosphi,sinphi,pom1,pom2,pom3,
     & dCalpha,dSalpha,dCbeta,dSbeta,dcosb,dsinb
      double precision dPHNtheta1(3),dPHNtheta2(3),dPHNgamma(3)
      double precision dXX_Ci1(3),dYY_Ci1(3),dZZ_Ci1(3),dXX_Ci(3),
     & dYY_Ci(3),dZZ_Ci(3),dXX_XYZ(3),dt_dCi(3),dt_dCi1(3),dhpos(3),
     & auxvec(3)
      double precision escloc,x_prime_safe(3),y_prime_safe(3),
     & z_prime_safe(3),uxder_num(3,3,2),
     & uyder_num(3,3,2),uzder_num(3,3,2)
      double precision tschebyshev,gradtschebyshev
      double precision aincr /1.0d-5/

c parameters
c ------------------------------------
C for H alpha
c for glycin
      HAalphaGly  = haGly_parm(1)
      HAbLenGly   = haGly_parm(2)
c for proline
      HAalphaPro  = haPro_parm(1)
      HAa1P       = haPro_parm(2)
      HAa2P       = haPro_parm(3)
      HAa3P       = haPro_parm(4)
      HAa4P       = haPro_parm(5)
      HAa5P       = haPro_parm(6)
      HAa6P       = haPro_parm(7)
      HAbLenPro   = haPro_parm(8)
c for others
      HAalphaC    = ha_parm(1)
      HAa1        = ha_parm(2)
      HAa2        = ha_parm(3)
      HAa3        = ha_parm(4)
      HAa4        = ha_parm(5)
      HAa5        = ha_parm(6)
      HAa6        = ha_parm(7)
      HAbLen      = ha_parm(8)
c      ha_parm(2)=0
c      ha_parm(3)=0
c      ha_parm(4)=0
c      ha_parm(5)=0
c      ha_parm(6)=0
c      ha_parm(7)=0
c ------------------------------------
C for H beta
      HBalphaC   = hb_parm(1)
      HBa1       = hb_parm(2)
      HBa2       = hb_parm(3)
      HBa3       = hb_parm(4)
      HBa4       = hb_parm(5)
      HBa5       = hb_parm(6)
      HBa6       = hb_parm(7)
      HBbetaC    = hb_parm(8)
      HBb1       = hb_parm(9)
      HBb2       = hb_parm(10)
      HBb3       = hb_parm(11)
      HBb4       = hb_parm(12)
      HBb5       = hb_parm(13)
      HBb6       = hb_parm(14)
      HBc1       = hb_parm(15)
      HBc2       = hb_parm(16)
      HBc3       = hb_parm(17)
      HBc4       = hb_parm(18)
      HBc5       = hb_parm(19)
      HBc6       = hb_parm(20)
      HBbLen     = hb_parm(21)
c      write (iout,*) "HBbLen",HBbLen
c ------------------------------------
C for HN
      HNa1y = hn_parm(1)
      HNa2y = hn_parm(2)
      HNa3y = hn_parm(3)
      HNa1z = hn_parm(4)
      HNa2z = hn_parm(5)
      HNa3z = hn_parm(6)
      HNb1y = hn_parm(7)
      HNb2y = hn_parm(8)
      HNb3y = hn_parm(9)
      HNb1z = hn_parm(10)
      HNb2z = hn_parm(11)
      HNb3z = hn_parm(12)
      HNdelta= hn_parm(13)
      HNepsil= hn_parm(14)
c      HNa1y=0.0d0
c      HNa2y=0.0d0
c      HNa3y=0.0d0
c      HNa1z=0.0d0
c      HNa2z=0.0d0
c      HNa3z=0.0d0
c      HNb1y=0.0d0
c      HNb2y=0.0d0
c      HNb3y=0.0d0
c      HNb1z=0.0d0
c      HNb2z=0.0d0
c      HNb3z=0.0d0
c      HNdelta=0.0d0
c ------------------------------------

c      write (iout,*) "itype inside",nnt,nct
      hpos=0.0d0
      dhpos_dc=0.0d0
      dhpos_gamma=0.0d0
      do i=nnt,nct-1
        if (itype(i).eq.ntyp1) cycle
        costtab(i+1) =dcos(theta(i+1))
        sinttab(i+1) =dsqrt(1-costtab(i+1)*costtab(i+1))
      enddo 
      do ichain=1,nchain
        innt=chain_border(1,ichain)
        inct=chain_border(2,ichain)
        do j=1,3
          hpos(j,innt,0)=C(j,innt)+HNdelta*dC_norm(j,innt)
          hpos(j,inct-1,0)=C(j,inct-1)+HNdelta*dC_norm(j,inct-1)
          hpos(j,innt,1)=C(j,innt)
          hpos(j,inct,1)=C(j,inct)
          hpos(j,innt,2)=C(j,innt)
          hpos(j,inct,2)=C(j,inct)
        enddo
c        if (innt.gt.1) then
c          do j=1,3
c            hpos(j,innt,0)=C(j,innt)
c          enddo
c        endif
        call dCnormderiv(innt,dhpos_dc(1,1,2,innt,0))
        call dCnormderiv(inct-1,dhpos_dc(1,1,2,inct-1,0))
        do j=1,3
          do k=1,3
            dhpos_dc(k,j,2,innt,0)=HNdelta*dhpos_dc(k,j,2,innt,0)
            dhpos_dc(k,j,2,inct-1,0)=HNdelta*dhpos_dc(k,j,2,inct-1,0)
          enddo
        enddo
      enddo
      do i=nnt+1,nct-1
c --------------------------------------------------------------
c HA local coordinate system
c --------------------------------------------------------------
        if (itype(i-1).gt.0 .and. itype(i-1).lt.ntyp1 .and.
     &      itype(i).gt.0 .and. itype(i).lt.ntyp1 .and.
     &      itype(i+1).gt.0 .and. itype(i+1).lt.ntyp1) then
c          thet(i)=alpha(i-1,i,i+1)
          call Halphabetaderiv(i,x_prime,y_prime,z_prime,
     &      uxder,uyder,uzder)
c          write (*,*) "x_prime, y_prime, z_prime i=",i
c          do j=1,3
c            write(*,'(i5,3f10.5)')j,x_prime(j),y_prime(j),z_prime(j)
c          enddo
c          write (*,*) "uxder,uyder,uzder"
c          do j=1,3
c            write(*,'(i5,3(3f10.5,2x,3f10.5,5x))')j,
c     &       ((uxder(j,k,l),k=1,3),l=1,2),((uyder(j,k,l),k=1,3),l=1,2),
c     &       ((uzder(j,k,l),k=1,3),l=1,2)
c          enddo
#ifdef DEBUG
          write (iout,*) "x_prime, y_prime, z_prime i=",i
          do j=1,3
            write(iout,'(i5,3f10.5)')j,x_prime(j),y_prime(j),z_prime(j)
          enddo
          write (iout,*) "costtab",costtab(i+1)," sinttab",sinttab(i+1)
          write (iout,*) "dc_dcitab"
          do j=1,3
           write (iout,'(i5,2f10.5)')j,dt_dCitab(j,1,i),dt_dCitab(j,2,i)
          enddo
          write (iout,*) "uxder,uyder,uzder"
          do j=1,3
            write(iout,'(i5,3(3f10.5,2x,3f10.5,5x))')j,
     &       ((uxder(j,k,l),k=1,3),l=1,2),((uyder(j,k,l),k=1,3),l=1,2),
     &       ((uzder(j,k,l),k=1,3),l=1,2)
          enddo
#endif
#ifdef DEBUG
C Checking the gradient
          do j=1,3
            x_prime_safe(j)=x_prime(j)
            y_prime_safe(j)=y_prime(j)
            z_prime_safe(j)=z_prime(j)
          enddo
          do j=1,3
            aux=dC(j,i-1)
            dC(j,i-1)=dC(j,i-1)+aincr
            call chainbuild_cart
            call vec_and_deriv
            call esc(escloc)
            call Halphabetaderiv(i,x_prime,y_prime,z_prime,
     &      uxder,uyder,uzder)
            do k=1,3
              uxder_num(k,j,1)=(x_prime(k)-x_prime_safe(k))/aincr
              uyder_num(k,j,1)=(y_prime(k)-y_prime_safe(k))/aincr
              uzder_num(k,j,1)=(z_prime(k)-z_prime_safe(k))/aincr
            enddo
            dC(j,i-1)=aux
            aux=dC(j,i)
            dC(j,i)=dC(j,i)+aincr
            call chainbuild_cart
            call vec_and_deriv
            call esc(escloc)
            call Halphabetaderiv(i,x_prime,y_prime,z_prime,
     &      uxder,uyder,uzder)
            do k=1,3
              uxder_num(k,j,2)=(x_prime(k)-x_prime_safe(k))/aincr
              uyder_num(k,j,2)=(y_prime(k)-y_prime_safe(k))/aincr
              uzder_num(k,j,2)=(z_prime(k)-z_prime_safe(k))/aincr
            enddo
            dC(j,i)=aux
            call chainbuild_cart
            call vec_and_deriv
            call esc(escloc)
            call Halphabetaderiv(i,x_prime,y_prime,z_prime,
     &      uxder,uyder,uzder)
          enddo
          write (iout,*) "numeric uxder,uyder,uzder"
          do j=1,3
          write(iout,'(i5,3(3f10.5,2x,3f10.5,5x))')j,
     &       ((uxder_num(j,k,l),k=1,3),l=1,2),
     &       ((uyder_num(j,k,l),k=1,3),l=1,2),
     &       ((uzder_num(j,k,l),k=1,3),l=1,2)
          enddo
#endif
c --------------------------------------------------------------
c HB local coordinate system
c --------------------------------------------------------------
C for H alpha
          ntypProt=1
c if GLY
          if (itype(i).eq.10) then

            Calpha=dcos(HAalphaGly*deg2rad)
            Salpha=dsin(HAalphaGly*deg2rad)
            ha_tmp(1)=HAbLenGly*Calpha
            ha_tmp(2)=0.0d0
            ha_tmp(3)=-HAbLenGly*Salpha
            dCalpha=0.0d0
            dSalpha=0.0d0
c if PRO
          else if (itype(i).eq.20) then

            Calpha=dcos(HAalphaPro*deg2rad)
     &          +tschebyshev(1,6,haPro_parm(2),costtab(i+1))
            dCalpha=gradtschebyshev(0,5,haPro_parm(2),costtab(i+1))
c            Calpha=dcos(HAalphaPro*deg2rad)+HAa1P*(dcos(theta(i+1)))+
c     &          HAa2P*(dcos(2*theta(i+1)))+HAa3P*(dcos(3*theta(i+1)))+
c     &          HAa4P*(dcos(4*theta(i+1)))+HAa5P*(dcos(5*theta(i+1)))+
c     &          HAa6P*(dcos(6*theta(i+1)))
            call cosbound(Calpha,dCalpha,Salpha,dSalpha)
            dSalpha=dSalpha*HAbLenPro
            dCalpha=dCalpha*HAbLenPro
c            if (Calpha.gt.1.0) then
c              Calpha=1.0d0
c              Salpha=0.0d0
c              dCalpha=0.0d0
c              dSalpha=0.0d0
c            else if (Calpha.lt.-1.0) then
c              Calpha=-1.0d0
c              Salpha= 0.0d0
c              dCalpha=0.0d0
c              dSalpha=0.0d0
c            else 
c            aalph=dacos(Calpha)
c            Salpha=dsin(aalph)
c              Salpha=dsqrt(1.0d0-Calpha*Calpha)
c              dSalpha=-Calpha/Salpha*dCalpha*HAbLenPro
c              dCalpha=dCalpha*HAbLenPro
c            endif
            ha_tmp(1)=HAbLenPro*Calpha
            ha_tmp(2)=0.0d0
            ha_tmp(3)=-HAbLenPro*Salpha
          else
            Calpha=dcos(HAalphaC*deg2rad)
     &          +tschebyshev(1,6,ha_parm(2),costtab(i+1))
            dCalpha=gradtschebyshev(0,5,ha_parm(2),costtab(i+1))
c            Calpha=dcos(HAalphaC*deg2rad)+HAa1*(dcos(theta(i+1)))+
c     &          HAa2*(dcos(2*theta(i+1)))+HAa3*(dcos(3*theta(i+1)))+
c     &          HAa4*(dcos(4*theta(i+1)))+HAa5*(dcos(5*theta(i+1)))+
c     &          HAa6*(dcos(6*theta(i+1)))
            call cosbound(Calpha,dCalpha,Salpha,dSalpha)
            dSalpha=dSalpha*HAbLen
            dCalpha=dCalpha*HAbLen
c            if (Calpha.gt.1.0) then
c              Calpha=1.0d0
c              Salpha=0.0d0
c              dCalpha=0.0d0
c              dSalpha=0.0d0
c            else if (Calpha.lt.-1.0) then
c              Calpha=-1.0d0
c              Salpha= 0.0d0
c              dCalpha=0.0d0
c              dSalpha=0.0d0
c            else 
cc            aalph=dacos(Calpha)
cc            Salpha=dsin(aalph)
c              Salpha=dsqrt(1.0d0-Calpha*Calpha)
c              dSalpha=-Calpha/Salpha*dCalpha*HAbLen
c              dCalpha=dCalpha*HAbLen
c            endif

c            aalph=dacos(Calpha)
c            Salpha=dsin(aalph)
c            Salpha=dsqrt(1.0d0-Calpha*Calpha)

            ha_tmp(1)=HAbLen*Calpha
            ha_tmp(2)=0.0d0
            ha_tmp(3)=-HAbLen*Salpha
          endif
c H alpha positions        
          do j=1,3
            dhpos(j)=x_prime(j)*ha_tmp(1)
     &        +y_prime(j)*ha_tmp(2)+z_prime(j)*ha_tmp(3)
          enddo
c          write (iout,*) "dHpos",(dhpos(j),j=1,3)
#ifdef DEBUG
          write (iout,*) "i",i," dXX-dZZ"
          do j=1,3
            write (iout,'(i5,3f10.5,5x,3f10.5)') j,
     &       dXX_Ci1(j),dYY_Ci1(j),dZZ_Ci1(j),
     &       dXX_Ci(j),dYY_Ci(j),dZZ_Ci(j)
          enddo
#endif
          do j=1,3
            hpos(j,i,ntypProt)=c(j,i)+dhpos(j)
c            hpos(j,i,ntypProt)=dhpos(j)
          enddo
c Derivatives of Haplha positions in dC(:,i-1) and dC(:,i)
          do j=1,2
            do k=1,3
              do l=1,3
                dhpos_dc(l,k,j,i,ntypProt)=ha_tmp(1)*uxder(l,k,j)+
     &          ha_tmp(2)*uyder(l,k,j)+ha_tmp(3)*uzder(l,k,j)+
     &          (x_prime(l)*dCalpha-z_prime(l)*dSalpha)*dt_dCitab(k,j,i)
              enddo
            enddo
          enddo
#ifdef DEBUG
          write (iout,'(2hHA,2i5,3f10.5)')
     &      i,itype(i),(hpos(j,i,ntypProt),j=1,3)
          write (iout,*) "Derivatives i",i
          do j=1,3
            write(iout,'(i5,3f10.5,5x,3f10.5,5x,3f10.3)') j,
     &       (dhpos_dc(j,k,1,i,ntypProt),k=1,3),
     &       (dhpos_dc(j,k,2,i,ntypProt),k=1,3)
c     &       (dhpos_dc(j,k,3,i,ntypProt),k=1,3)
          enddo
#endif
c --------------------------------------------------------------
C for H beta
c if not GLY calc HB
          if (itype(i).ne.10) then

            ntypProt=2
c
c cos alpha = cos alpha0 + a1 cos theta1 + a2 cos 2*theta1 + a3 cos 3*theta3
c
            Calpha=dcos(HBalphaC*deg2rad)+
     &         tschebyshev(1,6,hb_parm(2),costtab(i+1))
            dCalpha=gradtschebyshev(0,5,hb_parm(2),costtab(i+1))
c            Calpha=dcos(HBalphaC*deg2rad)+HBa1*(dcos(theta(i+1)))+
c     &          HBa2*(dcos(2*theta(i+1)))+HBa3*(dcos(3*theta(i+1)))+
c     &          HBa4*(dcos(4*theta(i+1)))+HBa5*(dcos(5*theta(i+1)))+
c     &          HBa6*(dcos(6*theta(i+1)))
            call cosbound(Calpha,dCalpha,Salpha,dSalpha)
c            if (Calpha.gt.1.0) then
c              Calpha=1.0d0
c              Salpha=0.0d0
c              dCalpha=0.0d0
c              dSalpha=0.0d0
c            else if (Calpha.lt.-1.0) then
c              Calpha=-1.0d0
c              Salpha= 0.0d0
c              dCalpha=0.0d0
c              dSalpha=0.0d0
c            else 
cc            aalph=dacos(Calpha)
cc            Salpha=dsin(aalph)
c              Salpha=dsqrt(1.0d0-Calpha*Calpha)
c              dSalpha=-Calpha/Salpha*dCalpha
c            endif

            if (HBbetaC.eq.0) then
              bet=90.0d0*deg2rad
              Cbeta=0.0d0
              Sbeta=1.0d0
              dCbeta=0.0d0
              dSbeta=0.0d0
            else
              sinb=dsin(HBbetaC*deg2rad)+
     &           tschebyshev(1,6,hb_parm(9),costtab(i+1))
              dsinb=gradtschebyshev(0,5,hb_parm(9),costtab(i+1))
              cosb=dcos(HBbetaC*deg2rad)+
     &           tschebyshev(1,6,hb_parm(15),costtab(i+1))
              dcosb=gradtschebyshev(0,5,hb_parm(15),costtab(i+1))
c              bet=datan2(dsin(HBbetaC*deg2rad)+HBb1*(dcos(theta(i+1)))+
c     &          HBb2*(dcos(2*theta(i+1)))+HBb3*(dcos(3*theta(i+1)))+
c     &          HBb4*(dcos(4*theta(i+1)))+HBb5*(dcos(5*theta(i+1)))+
c     &          HBb6*(dcos(6*theta(i+1))),dcos(HBbetaC*deg2rad) +
c     &          HBc1*(dcos(theta(i+1)))+HBc2*(dcos(2*theta(i+1)))+
c     &          HBc3*(dcos(3*theta(i+1)))+HBc4*(dcos(4*theta(i+1)))+
c     &          HBc5*(dcos(5*theta(i+1)))+HBc6*(dcos(6*theta(i+1))))
              aux=dsqrt(cosb*cosb+sinb*sinb)
              Cbeta=cosb/aux
              Sbeta=sinb/aux
              dCbeta=dcosb/aux-cosb*(cosb*dcosb+sinb*dsinb)/aux**3
              dSbeta=dsinb/aux-sinb*(cosb*dcosb+sinb*dsinb)/aux**3
            endif
c            Cbeta=0.0d0
c            Sbeta=1.0d0
c            dCbeta=0.0d0
c            dSbeta=0.0d0
c            Cbeta=dcos(bet)
c            if (Cbeta.gt.1.0) Cbeta=1.0d0
c            if (Cbeta.lt.-1.0) Cbeta=-1.0d0
c            Sbeta=dsin(bet)
c            if (Sbeta.gt.1.0) Sbeta=1.0d0
c            if (Sbeta.lt.-1.0) Sbeta=-1.0d0

            qb_tmp(1)=HBbLen*Sbeta*Calpha
            qb_tmp(2)=HBbLen*Cbeta
            qb_tmp(3)=HBbLen*Sbeta*Salpha
c            qb_tmp(1)=0.0d0
c            qb_tmp(2)=1.5d0
c            qb_tmp(3)=0.0d0
            do j=1,3
              dhpos(j)=x_prime(j)*qb_tmp(1)
     &          +y_prime(j)*qb_tmp(2)+z_prime(j)*qb_tmp(3)
            enddo
            do j=1,3
              hpos(j,i,ntypProt)=c(j,i)+dHpos(j)
c              hpos(j,i,ntypProt)=dhpos(j)
            enddo
            pom1=HBbLen*(dCalpha*Sbeta+dSbeta*Calpha)
            pom2=HBblen*dCbeta
            pom3=HBblen*(dSalpha*Sbeta+dSbeta*Salpha)
            do j=1,2
              do k=1,3
                do l=1,3
                  dhpos_dc(l,k,j,i,ntypProt)=qb_tmp(1)*uxder(l,k,j)+
     &              qb_tmp(2)*uyder(l,k,j)+qb_tmp(3)*uzder(l,k,j)+
     &             (x_prime(l)*pom1+y_prime(l)*pom2+z_prime(l)*pom3)
     &             *dt_dCitab(k,j,i)
                enddo
              enddo
            enddo
#ifdef DEBUG
            write (iout,'(2hHB,2i5,3f10.5)')
     &        i,itype(i),(hpos(j,i,ntypProt),j=1,3)
#endif
          endif
c end if for 1-25 amino-acids
        endif
      enddo

c --------------------------------------------------------------
c HN local coordinate system
c --------------------------------------------------------------
c      write (iout,*) "itype inside",nnt,nct
      do i=nnt+1,nct-2
c if not PRO
        if (itype(i-1).gt.0 .and. itype(i-1).lt.ntyp1 .and.
     &      itype(i).gt.0 .and. itype(i).lt.ntyp1 .and.
     &      itype(i+1).gt.0 .and. itype(i+1).lt.ntyp1 .and.
     &      itype(i+2).gt.0 .and. itype(i+2).lt.ntyp1 .and.
     &      itype(i+1).ne.20) then

c          call HNrefsysder(i,ux,uy1,uz1,uy2,uz2,uxder,uy1der,uz1der,
c     &      uy2der,uz2der)
c          write (iout,*) "uxHN, uyHN, uzHN i=",i
c          do j=1,3
c            write(iout,'(i5,3f10.5,5x,3f10.5)')j,ux(j),uy1(j),uz1(j),
c     &          ux(j),uy2(j),uz2(j)
c          enddo
c --------------------------------------------------------------
C for HN
          ntypProt=0

          hn1(2)=HNa1y+HNa2y*costtab(i+1)+HNa3y*costtab(i+1)**2
          hn1(3)=HNa1z+HNa2z*costtab(i+1)+HNa3z*costtab(i+1)**2
          hn2(2)=HNb1y+HNb2y*costtab(i+2)+HNb3y*costtab(i+2)**2
          hn2(3)=HNb1z+HNb2z*costtab(i+2)+HNb3z*costtab(i+2)**2
          fac=-costtab(i+1)/sinttab(i+1)
c          fac=0.0d0
          hn1theta(2)=fac*hn1(2)
     &      +sinttab(i+1)*(HNa2y+2*HNa3y*costtab(i+1))
          hn1theta(3)=fac*hn1(3)
     &      +sinttab(i+1)*(HNa2z+2*HNa3z*costtab(i+1))
          fac=-costtab(i+2)/sinttab(i+2)
c          fac=0.0d0
          hn2theta(2)=fac*hn2(2)
     &      +sinttab(i+2)*(HNb2y+2*HNb3y*costtab(i+2))
          hn2theta(3)=fac*hn2(3)
     &      +sinttab(i+2)*(HNb2z+2*HNb3z*costtab(i+2))
c          write (iout,*) "hn1theta",hn1theta," hn2theta",hn2theta
          hn1(2)=sinttab(i+1)*hn1(2)
          hn1(3)=sinttab(i+1)*hn1(3)
          hn2(2)=sinttab(i+2)*hn2(2)
          hn2(3)=sinttab(i+2)*hn2(3)
c
c          hn1(2)=dsin(theta(i+1))*(HNa1y + HNa2y*dcos(theta(i+1)) +
c     &                                 HNa3y*(dcos(theta(i+1)))**2)
c          hn1(3)=dsin(theta(i+1))*(HNa1z + HNa2z*dcos(theta(i+1)) +
c     &                                 HNa3z*(dcos(theta(i+1)))**2)
c
c          hn2(2)=dsin(theta(i+2))*(HNb1y + HNb2y*dcos(theta(i+2)) +
c     &                                 HNb3y*(dcos(theta(i+2)))**2)
c          hn2(3)=dsin(theta(i+2))*(HNb1z + HNb2z*dcos(theta(i+2)) +
c     &                                 HNb3z*(dcos(theta(i+2)))**2)
#ifdef HNNORM
          if (hn1(2).gt.1.0) hn1(2)=1.0d0
          if (hn1(2).lt.-1.0) hn1(2)=-1.0d0
          if (hn1(3).gt.1.0) hn1(3)=1.0d0
          if (hn1(3).lt.-1.0) hn1(3)=-1.0d0
          if (hn2(2).gt.1.0) hn2(2)=1.0d0
          if (hn2(2).lt.-1.0) hn2(2)=-1.0d0
          if (hn2(3).gt.1.0) hn2(3)=1.0d0
          if (hn2(3).lt.-1.0) hn2(3)=-1.0d0
#endif
          cosphi=dcos(phi(i+2))
          sinphi=dsin(phi(i+2))
          y2= hn1(2)*cosphi+hn1(3)*sinphi
          z2=-hn1(2)*sinphi+hn1(3)*cosphi
c          write (iout,*) "hn1",hn1," hn2",hn2
c          write (iout,*) "y2",y2," z2",z2 
          Psum(2)=-(hn2(2)+y2)
          Psum(3)=-(hn2(3)+z2)
c AL 8/18/2023: Added a small number to the square of dipole-moment norm to ensumre stability
          dlPsum=dsqrt(Psum(2)**2+Psum(3)**2+1.0d-3)
c          write (iout,*) "Psum",Psum(2),Psum(3),"dlPsum=",dlPsum

c sum of the HN1 and HN2 vectors in local coordinates
          PHN(1)=HNdelta
          PHN(2)=HNepsil*Psum(2)/dlPsum
          PHN(3)=HNepsil*Psum(3)/dlPsum
          pom1=-(hn1theta(2)*cosphi+hn1theta(3)*sinphi)
          pom2=-(-hn1theta(2)*sinphi+hn1theta(3)*cosphi)
          dPHNtheta1(2)=HNepsil*pom1/dlPsum-PHN(2)*(Psum(2)*pom1
     &      +Psum(3)*pom2)/dlPsum**2
          dPHNtheta1(3)=HNepsil*pom2/dlPsum-PHN(3)*(Psum(2)*pom1
     &      +Psum(3)*pom2)/dlPsum**2
          pom1=-(Psum(2)*hn2theta(2)+Psum(3)*hn2theta(3))/dlPsum**2
          dPHNtheta2(2)=-HNepsil*hn2theta(2)/dlPsum-PHN(2)*pom1
          dPHNtheta2(3)=-HNepsil*hn2theta(3)/dlPsum-PHN(3)*pom1
          pom1=-(-hn1(2)*sinphi+hn1(3)*cosphi)
          pom2=-(-hn1(2)*cosphi-hn1(3)*sinphi)
          dPHNgamma(2)=HNepsil*pom1/dlPsum-
     &      PHN(2)*(Psum(2)*pom1+Psum(3)*pom2)/dlPSum**2
          dPHNgamma(3)=HNepsil*pom2/dlPsum-
     &      PHN(3)*(Psum(2)*pom1+Psum(3)*pom2)/dlPSum**2
c          write (iout,*) "costtab",i,costtab(i+1)
c          write (iout,*) "costtab",i,dcos(theta(i+1))
          do j=1,3
            hpos(j,i,ntypProt)=PHN(1)*dc_norm(j,i)+PHN(2)*uy(j,i)+
     &                PHN(3)*uz(j,i)+c(j,i)
c            hpos(j,i,ntypProt)=dcos(theta(i+1))
c            hpos(j,i,ntypProt)=costtab(i+1)
          enddo
#ifdef DEBUG
          write (iout,*) "HNpos"
          write(iout,'(i5,3f10.5)')i,(hpos(j,i,ntypProt),j=1,3)
#endif
c Derivatives in virtual-bond vectors
          do k=1,3
            do l=1,3
              dCder(k,l)=-dC_norm(k,i)*dC_norm(l,i)
            enddo
            dCder(k,k)=1.0d0+dCder(k,k)
            do l=1,3
              dCder(k,l)=vbld_inv(i+1)*dCder(k,l)
            enddo
          enddo
          do k=1,3
            do l=1,3
              dhpos_dc(l,k,1,i,ntypProt)=(dPHNtheta1(2)*uy(l,i)+
     &          dPHNtheta1(3)*uz(l,i))*dt_dCitab(k,1,i)
              dhpos_dc(l,k,2,i,ntypProt)= PHN(1)*dCder(l,k)+
     &          PHN(2)*uygrad(l,k,1,i)+PHN(3)*uzgrad(l,k,1,i)+
     &          (dPHNtheta1(2)*uy(l,i)+dPHNtheta1(3)*uz(l,i))
     &          *dt_dCitab(k,2,i)+
     &          (dPHNtheta2(2)*uy(l,i)+dPHNtheta2(3)*uz(l,i))
     &          *dt_dCitab(k,1,i+1)
              dhpos_dc(l,k,3,i,ntypProt)=PHN(2)*uygrad(l,k,2,i)+
     &          PHN(3)*uzgrad(l,k,2,i)+
     &          (dPHNtheta2(2)*uy(l,i)+dPHNtheta2(3)*uz(l,i))
     &          *dt_dCitab(k,2,i+1)
            enddo
            dhpos_gamma(k,i,ntypProt)=(dPHNgamma(2)*uy(k,i)
     &         +dPHNgamma(3)*uz(k,i))
          enddo
        endif
      enddo
! The positions and derivatives of other protons. 
      do i=nnt,nct
        iti=itype(i)
        if (itype(i).eq.ntyp1) cycle
        do j=3,nproton(iti)
          do k=1,3
            hpos(k,i,j)=C(k,i)+protpos(j,iti)*dC(k,i+nres)
          enddo
        enddo
      enddo
      if (lprn) then
      do i=nnt,nct-1
          write (iout,'(a,i4,3f8.3)')
     &          "hpos HN",i,hpos(1,i,0),hpos(2,i,0),hpos(3,i,0)
      enddo
      do i=nnt,nct
          write (iout,'(a,i4,3f8.3)')
     &          "hpos HA",i,hpos(1,i,1),hpos(2,i,1),hpos(3,i,1)
      enddo
      do i=nnt,nct
          write (iout,'(a,i4,3f8.3)')
     &          "hpos HB",i,hpos(1,i,2),hpos(2,i,2),hpos(3,i,2)
      enddo
      call flush(iout)
      endif

      end
C
C------------------------------------------------------------------------------
C EL for NMR restraints
      subroutine hdist(i1,it1,i2,it2,dd,rvec)
c
c  Calculates the distance between protons.
c  Residue (i1) proton type (it1) and residue (i2) proton type (it2).
c
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.NMR'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      double precision dd,rvec(3)
      integer i1,it1,i2,it2
      integer j
      double precision d0 /2.5d0/,delta /1.0d0/
      double precision d_red,gd_red
c      write (iout,*) "hdist i1",i1," it1",it1," i2",i2," it2",it2
c      if (it1.le.2 .and. it2.le.2) then
c        write (iout,*) "it1.le.2 .and. it2.le.2"
        do j=1,3
          rvec(j)=hpos(j,i2,it2)-hpos(j,i1,it1)
        enddo
c        write (*,*) "hpos",i1,it1,hpos(:,i1,it1)
c        write (*,*) "hpos",i2,it2,hpos(:,i2,it2)
c      else if (it1.le.2 .and. it2.gt.2) then
c        write (iout,*) "it1.le.2 .and. it2.gt.2"
c        do j=1,3
c          rvec(j)=c(j,i2+nres)-hpos(j,i1,it1)
c        enddo
c      else if (it1.gt.2 .and. it2.le.2) then
c        write (iout,*) "it1.gt.2 .and. it2.le.2"
c        do j=1,3
c          rvec(j)=hpos(j,i2,it2)-c(j,i1+nres)
c        enddo
c      else if (it1.gt.2 .and. it2.gt.2) then
c        write (iout,*) "it1.gt.2 .and. it2.gt.2"
c        do j=1,3
c          rvec(j)=c(j,i2+nres)-c(j,i1+nres)
c        enddo
c      endif
      dd=dsqrt(rvec(1)*rvec(1)+rvec(2)*rvec(2)+rvec(3)*rvec(3))
      call red_dist(dd,d0,delta,d_red,gd_red)
c      write (iout,*) i1,i2,"dd",dd," d_red",d_red," gd_red",gd_red
      if (dd.le.d0) then
        rvec = 0.0d0
      else if (dd.lt.d0+delta) then
        rvec = gd_red*rvec
      endif
c      rvec=rvec/dd
      do j=1,3
        rvec(j)=rvec(j)/dd
      enddo
      dd = d_red
      return
      end
c---------------------------------------------------------------------------
      subroutine Halphabetaderiv(i,x_prime,y_prime,z_prime,
     &  uxder,uyder,uzder)
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.VAR'
      include 'COMMON.SCROT'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.FFIELD'
      include 'COMMON.CONTROL'
      include 'COMMON.VECTORS'
      integer i,j,k,l
      double precision cosfac,sinfac,cosfac2,sinfac2,
     & cfi1,cfi,sfi1,sfi
      double precision x_prime(3),y_prime(3),z_prime(3)
      double precision uxder(3,3,2),uyder(3,3,2),uzder(3,3,2)
c      double precision dt_dCi(3),dt_dCi1(3)
      double precision scalar
      cosfac2=0.5d0/(1.0d0+costtab(i+1))
      cosfac=dsqrt(cosfac2)
      sinfac2=0.5d0/(1.0d0-costtab(i+1))
      sinfac=dsqrt(sinfac2)
c      print *,"i",i," costtab",costtab(i+1)," cosfac",cosfac,
c     &  " sinfac",sinfac," vbld_inv",vbld_inv(i),vbld_inv(i+1)
      do j = 1,3
        x_prime(j) = (dc_norm(j,i) - dc_norm(j,i-1))*cosfac
        y_prime(j) = (dc_norm(j,i) + dc_norm(j,i-1))*sinfac
      enddo
      do j = 1,3
        z_prime(j) = -uz(j,i-1)*dsign(1.0d0,dfloat(itype(i)))
      enddo     
      uxder=0.0d0
      uyder=0.0d0
      uzder=0.0d0
      cfi1=vbld_inv(i)*cosfac
      sfi1=vbld_inv(i)*sinfac
      cfi=vbld_inv(i+1)*cosfac
      sfi=vbld_inv(i+1)*sinfac
c      if (itype(i).eq.10) then
      do k=1,3
        dt_dCitab(k,1,i)= -(dc_norm(k,i)+costtab(i+1)*dc_norm(k,i-1))*
     &     vbld_inv(i)
        dt_dCitab(k,2,i) = -(dc_norm(k,i-1)+costtab(i+1)*dc_norm(k,i))*
     &     vbld_inv(i+1)
      enddo
c      endif
      do k = 1,3
        uxder(k,k,1)=-1.0d0
        uxder(k,k,2)=1.0d0
        uyder(k,k,1)=1.0d0
        uyder(k,k,2)=1.0d0
        do l=1,3
          uxder(k,l,1)=(uxder(k,l,1)+dC_norm(k,i-1)*dC_norm(l,i-1))*cfi1
     &       -cosfac2*x_prime(k)*dt_dCitab(l,1,i)
          uxder(k,l,2)=(uxder(k,l,2)-dC_norm(k,i)*dC_norm(l,i))*cfi
     &       -cosfac2*x_prime(k)*dt_dCitab(l,2,i)
          uyder(k,l,1)=(uyder(k,l,1)-dC_norm(k,i-1)*dC_norm(l,i-1))*sfi1
     &       +sinfac2*y_prime(k)*dt_dCitab(l,1,i)
          uyder(k,l,2)=(uyder(k,l,2)-dC_norm(k,i)*dC_norm(l,i))*sfi
     &       +sinfac2*y_prime(k)*dt_dCitab(l,2,i)
        enddo
      enddo
      do k=1,3
        do l=1,3
          uzder(l,k,1)=-uzgrad(l,k,1,i-1)*dsign(1.0d0,dfloat(itype(i)))
          uzder(l,k,2)=-uzgrad(l,k,2,i-1)*dsign(1.0d0,dfloat(itype(i)))
        enddo
      enddo
      return
      end
c-----------------------------------------------------------------------
      subroutine cosbound(Calpha,dCalpha,Salpha,dSalpha)
      implicit none
      double precision Calpha,dCalpha,Salpha,dSalpha
      double precision Calphap
      double precision delta /1.0d-2/
      double precision x
      x = Calpha
      if (Calpha.gt.0.0d0) then
        call Gbounds(x,Calpha,Calphap,delta)
      else
        call Gbounds(-x,Calpha,Calphap,delta)
        Calpha=-Calpha
      endif
      dCalpha=Calphap*dCalpha
      Salpha=dsqrt(1.0d0-Calpha*Calpha)
      dSalpha=-Calpha/Salpha*dCalpha
      return
      end
c------------------------------------------------------------------------
      subroutine Gbounds(x,Calpha,Calphap,delta)
      implicit none
      double precision Calpha,Calphap,delta
      double precision x
      double precision F,Fp
      F(x)=0.5*x-0.46875*x**2+0.15625*x**4-0.03125*x**6+0.84375
      Fp(x)=0.5-2*0.46875*x+4*0.15625*x**3-6*0.03125*x**5
c      G(x,delta)=x<1-2*delta?x:x>=1-2*delta&&x<1?F((x-1+delta)/delta)*delta+1-2*delta:1-delta
c      print *,"x",x
      if (x.lt.1.0d0-2*delta) then
c        print *,"x<1-2*delta"
        Calpha=x
        Calphap=1.0d0
      else if (x.ge.1.0d0-2*delta .and. x.lt.1.0d0) then
c        print *,"1>x>=1-2*delta"
c        print *,"scaled x",(x-1.0d0+delta)/delta
        Calpha=F((x-1.0d0+delta)/delta)*delta+1.0d0-2*delta
        Calphap=Fp((x-1.0d0+delta)/delta)
      else
c        print *,"x>1"
        Calpha=1.0d0-delta
        Calphap=0.0d0
      endif
      return
      end
c--------------------------------------------------------------------------
      subroutine dCnormderiv(i,dCder)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.LOCAL'
      double precision dCder(3,3)
      integer i,k,l
      do k=1,3
        do l=1,3
          dCder(k,l)=-dC_norm(k,i)*dC_norm(l,i)
        enddo
        dCder(k,k)=1.0d0+dCder(k,k)
        do l=1,3
          dCder(k,l)=vbld_inv(i+1)*dCder(k,l)
        enddo
      enddo
      return
      end
c------------------------------------------------------------------------------
      subroutine red_dist(d,d0,delta,d_red,gd_red)
      implicit none
      double precision d,d0,delta,d_red,gd_red
      double precision x,x2
      if (d.le.d0) then
        d_red=d0
        gd_red=0.0d0
      else if (d.lt.d0+delta) then
        x = (d-d0)/delta
        x2 = x*x
        d_red = (-0.5d0*x2+1.5d0)*x2*delta+d0
        gd_red = (-2.0d0*x2+3.0d0)*x
      else
        d_red=d
        gd_red=1.0d0
      endif
      return
      end
