      subroutine mygetenv(string,var)
C
C Version 1.0
C
C This subroutine passes the environmental variables to FORTRAN program.
C If the flags -DMYGETENV and -DMPI are not for compilation, it calls the
C standard FORTRAN GETENV subroutine. If both flags are set, the subroutine
C reads the environmental variables from $HOME/.env
C
C Usage: As for the standard FORTRAN GETENV subroutine.
C 
C Purpose: some versions/installations of MPI do not transfer the environmental
C variables to slave processors, if these variables are set in the shell script
C from which mpirun is called.
C
C A.Liwo, 7/29/01
C
      implicit none
      character*(*) string,var
#if defined(MYGETENV) && defined(MPI) 
      include "DIMENSIONS.ZSCOPT"
      include "mpif.h"
      include "COMMON.MPI"
      character*360 ucase
      external ucase
      character*360 string1(360),karta
      character*240 home
      integer i,n,ilen
      external ilen
      call getenv("HOME",home)
      open(99,file=home(:ilen(home))//"/.env",status="OLD",err=112)
      do while (.true.)
        read (99,end=111,err=111,'(a)') karta
        do i=1,80
          string1(i)=" "
        enddo
        call split_string(karta,string1,80,n)
        if (ucase(string1(1)(:ilen(string1(1)))).eq."SETENV" .and.
     &   string1(2)(:ilen(string1(2))).eq.string(:ilen(string)) ) then
           var=string1(3)
           print *,"Processor",me,": ",var(:ilen(var)),
     &      " assigned to ",string(:ilen(string))
           close(99)
           return
        endif  
      enddo    
 111  print *,"Environment variable ",string(:ilen(string))," not set."
      close(99)
      return
 112  print *,"Error opening environment file!"
#else
      call getenv(string,var)
#endif
      return
      end     
