C
C------------------------------------------------------------------------------
C
      double precision function alpha(i1,i2,i3)
c
c  Calculates the planar angle between atoms (i1), (i2), and (i3).
c
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'COMMON.GEO'
      include 'COMMON.CHAIN'
      x12=c(1,i1)-c(1,i2)
      x23=c(1,i3)-c(1,i2)
      y12=c(2,i1)-c(2,i2)
      y23=c(2,i3)-c(2,i2)
      z12=c(3,i1)-c(3,i2)
      z23=c(3,i3)-c(3,i2)
      vnorm=dsqrt(x12*x12+y12*y12+z12*z12)
      wnorm=dsqrt(x23*x23+y23*y23+z23*z23)
      scalar=(x12*x23+y12*y23+z12*z23)/(vnorm*wnorm)
      alpha=arcos(scalar)
      return
      end
C
C------------------------------------------------------------------------------
C
      double precision function beta(i1,i2,i3,i4)
c
c  Calculates the dihedral angle between atoms (i1), (i2), (i3) and (i4)
c
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'COMMON.GEO'
      include 'COMMON.CHAIN'
      x12=c(1,i1)-c(1,i2)
      x23=c(1,i3)-c(1,i2)
      x34=c(1,i4)-c(1,i3)
      y12=c(2,i1)-c(2,i2)
      y23=c(2,i3)-c(2,i2)
      y34=c(2,i4)-c(2,i3)
      z12=c(3,i1)-c(3,i2)
      z23=c(3,i3)-c(3,i2)
      z34=c(3,i4)-c(3,i3)
cd    print '(2i3,3f10.5)',i1,i2,x12,y12,z12
cd    print '(2i3,3f10.5)',i2,i3,x23,y23,z23
cd    print '(2i3,3f10.5)',i3,i4,x34,y34,z34
      wx=-y23*z34+y34*z23
      wy=x23*z34-z23*x34
      wz=-x23*y34+y23*x34
      wnorm=dsqrt(wx*wx+wy*wy+wz*wz)
      vx=y12*z23-z12*y23
      vy=-x12*z23+z12*x23
      vz=x12*y23-y12*x23
      vnorm=dsqrt(vx*vx+vy*vy+vz*vz)
      if (vnorm.gt.1.0D-13 .and. wnorm.gt.1.0D-13) then
      scalar=(vx*wx+vy*wy+vz*wz)/(vnorm*wnorm)
      if (dabs(scalar).gt.1.0D0) 
     &scalar=0.99999999999999D0*scalar/dabs(scalar)
      angle=dacos(scalar)
cd    print '(2i4,10f7.3)',i2,i3,vx,vy,vz,wx,wy,wz,vnorm,wnorm,
cd   &scalar,angle
      else
      angle=pi
      endif 
c     if (angle.le.0.0D0) angle=pi+angle
      tx=vy*wz-vz*wy
      ty=-vx*wz+vz*wx
      tz=vx*wy-vy*wx
      scalar=tx*x23+ty*y23+tz*z23
      if (scalar.lt.0.0D0) angle=-angle
      beta=angle
      return
      end
C
C------------------------------------------------------------------------------
C
      double precision function dist(i1,i2)
c
c  Calculates the distance between atoms (i1) and (i2).
c
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'COMMON.GEO'
      include 'COMMON.CHAIN'
      x12=c(1,i1)-c(1,i2)
      y12=c(2,i1)-c(2,i2)
      z12=c(3,i1)-c(3,i2)
      dist=dsqrt(x12*x12+y12*y12+z12*z12)
      return
      end
C
