      subroutine int_from_cart1(lprn)
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'COMMON.IOUNITS'
      include 'COMMON.VAR'
      include 'COMMON.CHAIN'
      include 'COMMON.GEO'
      include 'COMMON.INTERACT'
      include 'COMMON.LOCAL'
      include 'COMMON.NAMES'
      integer i,j
      double precision dist,alpha,beta,dnorm1,dnorm2,be
      logical lprn 
      if (lprn) write (iout,'(/a)') 'Recalculated internal coordinates'
      vbld(nres+1)=0.0d0
      vbld(2*nres)=0.0d0
      vbld_inv(nres+1)=0.0d0
      vbld_inv(2*nres)=0.0d0
      do i=2,nres
        dnorm1=dist(i-1,i)
        dnorm2=dist(i,i+1)
        do j=1,3
          c(j,maxres2)=0.5D0*(2*c(j,i)+(c(j,i-1)-c(j,i))/dnorm1
     &     +(c(j,i+1)-c(j,i))/dnorm2)
        enddo
        be=0.0D0
        if (i.gt.2) phi(i+1)=beta(i-2,i-1,i,i+1)
        if (i.gt.2) tauangle(3,i+1)=beta(i+nres-1,i-1,i,i+nres)
        if (i.gt.2) tauangle(1,i+1)=beta(i-1+nres,i-1,i,i+1)
        if (i.gt.2) tauangle(2,i+1)=beta(i-2,i-1,i,i+nres)
        omeg(i)=beta(nres+i,i,maxres2,i+1)
        theta(i+1)=alpha(i-1,i,i+1)
        alph(i)=alpha(nres+i,i,maxres2)
        vbld(i)=dist(i-1,i)
        vbld_inv(i)=1.0d0/vbld(i)
        vbld(nres+i)=dist(nres+i,i)
        if (itype(i).ne.10) then
          vbld_inv(nres+i)=1.0d0/vbld(nres+i)
        else
          vbld_inv(nres+i)=0.0d0
        endif
      enddo   
      do i=1,nres-1
        do j=1,3
          dc(j,i)=c(j,i+1)-c(j,i)
          dc_norm(j,i)=dc(j,i)*vbld_inv(i+1)
        enddo
      enddo
      do i=1,nres
        do j=1,3
          dc(j,i+nres)=c(j,i+nres)-c(j,i)
          dc_norm(j,i+nres)=dc(j,i+nres)*vbld_inv(i+nres)
        enddo
      enddo
      if (lprn) then
      do i=2,nres
       write (iout,1212) restyp(itype(i)),i,vbld(i),
     &rad2deg*theta(i),rad2deg*phi(i),vbld(nres+i),
     &rad2deg*alph(i),rad2deg*omeg(i)
      enddo
      endif
 1212 format (a3,'(',i3,')',2(f15.10,2f10.2))
      return
      end
