      subroutine initialize
C 
C Define constants and zero out tables.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.FFIELD'
      include 'COMMON.SBRIDGE'
      include 'COMMON.MINIM' 
      include 'COMMON.DERIV'
      include "COMMON.WEIGHTS"
      include "COMMON.NAMES"
      include "COMMON.TIME1"
      include "COMMON.TORCNSTR"
C
C The following is just to define auxiliary variables used in angle conversion
C
      pi=4.0D0*datan(1.0D0)
      dwapi=2.0D0*pi
      dwapi3=dwapi/3.0D0
      pipol=0.5D0*pi
      deg2rad=pi/180.0D0
      rad2deg=1.0D0/deg2rad
      angmin=10.0D0*deg2rad
C
C Define I/O units.
C
      inp=    1
      iout=   2
      ipdbin= 3
      ipdb=   7
      imol2=  4
      igeom=  8
      intin=  9
      ithep= 11
      irotam=12
      irotam_end=43
      itorp= 13
      itordp= 23
      ielep= 14
      isidep=15 
      isidep1=22
      iscpp=25
      icbase=16
      ifourier=20
      istat= 17
      ientin=18
      ientout=19
      ibond=28
      isccor=29
C
C WHAM files
C
      ihist=30
      iweight=31
      izsc=32
      itube=45
c file with NMR parameters
      inmr=46
c file with Xlink parameters
      ixlnk=47
C Lipidic input file for parameters range 60-79
      iliptranpar=60
C
C Set default weights of the energy terms.
C
      wlong=1.0D0
      welec=1.0D0
      wtor =1.0D0
      wang =1.0D0
      wscloc=1.0D0
      wstrain=1.0D0
C
C Zero out tables.
C
      ndih_constr=0
      do i=1,maxres2
	do j=1,3
	  c(j,i)=0.0D0
	  dc(j,i)=0.0D0
        enddo
      enddo
      do i=1,maxres
	do j=1,3
	  xloc(j,i)=0.0D0
        enddo
      enddo
      do i=1,ntyp
	do j=1,ntyp
	  aa_lip(i,j)=0.0D0
	  bb_lip(i,j)=0.0D0
          aa_aq(i,j)=0.0D0
          bb_aq(i,j)=0.0D0
	  augm(i,j)=0.0D0
	  sigma(i,j)=0.0D0
	  r0(i,j)=0.0D0
	  chi(i,j)=0.0D0
        enddo
	do j=1,2
	  bad(i,j)=0.0D0
        enddo
	chip(i)=0.0D0
	alp(i)=0.0D0
	sigma0(i)=0.0D0
	sigii(i)=0.0D0
	rr0(i)=0.0D0
	a0thet(i)=0.0D0
        do j=1,2
         do ichir1=-1,1
          do ichir2=-1,1
          athet(j,i,ichir1,ichir2)=0.0D0
          bthet(j,i,ichir1,ichir2)=0.0D0
          enddo
         enddo
        enddo
	do j=0,3
	  polthet(j,i)=0.0D0
        enddo
	do j=1,3
	  gthet(j,i)=0.0D0
        enddo
	theta0(i)=0.0D0
	sig0(i)=0.0D0
	sigc0(i)=0.0D0
	do j=1,maxlob
	  bsc(j,i)=0.0D0
	  do k=1,3
	    censc(k,j,i)=0.0D0
          enddo
          do k=1,3
	    do l=1,3
	      gaussc(l,k,j,i)=0.0D0
            enddo
          enddo
	  nlob(i)=0
        enddo
      enddo
      nlob(ntyp1)=0
      dsc(ntyp1)=0.0D0
      do i=-maxtor,maxtor
        itortyp(i)=0
       do iblock=1,2
        do j=-maxtor,maxtor
          do k=1,maxterm
            v1(k,j,i,iblock)=0.0D0
            v2(k,j,i,iblock)=0.0D0
          enddo
        enddo
        enddo
      enddo
      do iblock=1,2
       do i=-maxtor,maxtor
        do j=-maxtor,maxtor
         do k=-maxtor,maxtor
          do l=1,maxtermd_1
            v1c(1,l,i,j,k,iblock)=0.0D0
            v1s(1,l,i,j,k,iblock)=0.0D0
            v1c(2,l,i,j,k,iblock)=0.0D0
            v1s(2,l,i,j,k,iblock)=0.0D0
          enddo !l
          do l=1,maxtermd_2
           do m=1,maxtermd_2
            v2c(m,l,i,j,k,iblock)=0.0D0
            v2s(m,l,i,j,k,iblock)=0.0D0
           enddo !m
          enddo !l
        enddo !k
       enddo !j
      enddo !i
      enddo !iblock
      do i=1,maxres
	itype(i)=0
	itel(i)=0
      enddo
C Initialize the bridge arrays
      ns=0
      nss=0 
      nhpb=0
      do i=1,max_cyst
	iss(i)=0
      enddo
      do i=1,maxdim_cont
	dhpb(i)=0.0D0
      enddo
      do i=1,maxres
	ihpb(i)=0
	jhpb(i)=0
        dyn_ss_mask(i)=.false.
      enddo
C
C Initialize timing.
C
      call set_timers
C
C Initialize variables used in minimization.
C   
c     maxfun=5000
c     maxit=2000
      maxfun=500
      maxit=200
      tolf=1.0D-2
      rtolf=5.0D-4
C 
C Initialize the variables responsible for the mode of gradient storage.
C
      nfl=0
      icg=1
      do i=1,14
        do j=1,14
          if (print_order(i).eq.j) then
            iw(print_order(i))=j
            goto 1121
          endif
        enddo
1121    continue
      enddo
      calc_grad=.false.
C Set timers and counters for the respective routines
      t_func = 0.0d0
      t_grad = 0.0d0
      t_fhel = 0.0d0
      t_fbet = 0.0d0
      t_ghel = 0.0d0
      t_gbet = 0.0d0
      t_viol = 0.0d0
      t_gviol = 0.0d0
      n_func = 0
      n_grad = 0
      n_fhel = 0
      n_fbet = 0
      n_ghel = 0
      n_gbet = 0
      n_viol = 0
      n_gviol = 0
      n_map = 0
#ifndef SPLITELE
      nprint_ene=nprint_ene-1
#endif
      return
      end
c-------------------------------------------------------------------------
      block data nazwy
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'COMMON.NAMES'
      include 'COMMON.WEIGHTS'
      include 'COMMON.FFIELD'
      include 'COMMON.SHIELD'
      data restyp /
     &'DD','DAU','DAI','DDB','DSM','DPR','DLY','DAR','DHI','DAS','DGL',
     & 'DSG','DGN','DSN','DTH',
     &'DYY','DAL','DTY','DTR','DVA','DLE','DIL','DPN','MED','DCY','ZER',
     &'CYS','MET','PHE','ILE','LEU','VAL','TRP','TYR','ALA','GLY','THR',
     &'SER','GLN','ASN','GLU','ASP','HIS','ARG','LYS','PRO','SME','DBZ',
     &'AIB','ABU','D'/
      data onelet /
     &'z','z','z','z','z','p','k','r','h','d','e','n','q','s','t','g',
     &'a','y','w','v','l','i','f','m','c','x',
     &'C','M','F','I','L','V','W','Y','A','G','T',
     &'S','Q','N','E','D','H','R','K','P','z','z','z','z','X'/
      data proton  /'HN','HA','HB','HG','HD','HE','HZ','HH',5*'H*'/
      data potname /'LJ','LJK','BP','GB','GBV'/
      data ename / 
     1   "ESC-SC",
     2   "ESC-p",
     3   "Ep-p(el)",
     4   "ECORR4 ",
     5   "ECORR5 ",
     6   "ECORR6 ",
     7   "ECORR3 ",
     8   "ETURN3 ",
     9   "ETURN4 ",
     @   "ETURN6 ",
     1   "Ebend",
     2   "ESCloc",
     3   "ETORS ",
     4   "ETORSD ",
     5   "Edist",
     6   "Epp(VDW)",
     7   "EVDW2_14",
     8   "Ebond",
     9   "ESCcor",
     @   "EDIHC",
     1   "EVDW_T",
     2   "ELIPTRAN",
     3   "EAFM",
     4   "ETHETC",
     5   "ESHIELD",
     6   "ESAXS",
     7   "EHOMO",
     8   "EDFADIS",
     9   "EDFATOR",
     @   "EDFANEI",
     1   "EDFABET",
     2   "ESS"/
      data wname /
!            1       2       3       4       5        6        7 
     &   "WSC   ","WSCP  ","WELEC","WCORR","WCORR5","WCORR6","WEL_LOC",
!            8       9      10      11      12       13       14
     &   "WTURN3","WTURN4","WTURN6","WANG","WSCLOC","WTOR  ","WTORD",
!           15      16      17      18      19       20       21
     &   "WHPB  ","WVDWPP","SCAL14","WBOND","WSCCOR","WDIHC","WSC_T",
!           22      23      24      25      26       27       28
     &   "WLT     ","WAFM","WTHETC","WSHIELD","WSAXS","WHOMO","WDFAD",
!           29      30      31   
     &   "WDFAT","WDFAN","WDFAB","WSS"/
      data ww0 /
     1  1.0d0,    ! WSC
     2  1.0d0,    ! WSCP
     3  1.0d0,    ! WELEC
     4  0.0d0,    ! WCORR
     5  0.0d0,    ! WCORR5
     6  0.0d0,    ! WCORR6
     7  1.0d0,    ! WEL_LOC
     8  1.0d0,    ! WTURN3
     9  1.0d0,    ! WTURN4
     @  0.0d0,    ! WTURN6
     1  1.0d0,    ! WANG
     2  1.0d0,    ! WSCLOC
     3  1.0d0,    ! WTOR
     4  1.0d0,    ! WTORD
     5  1.0d0,    ! WHPB
     6  1.0d0,    ! WVDWPP
     7  0.4d0,    ! WSCP14
     8  1.0d0,    ! WBOND
     9  1.0d0,    ! WSCCOR
     @  0.0d0,    ! WDIHC
     1  0.0d0,    ! WSC_T
     2  0.0d0,    ! WLIPTRAN
     3  0.0d0,    ! WAFM
     4  0.0d0,    ! WTHETC
     5  0.0d0,    ! WSHIELD
     6  0.0d0,    ! WSAXS
     7  0.0d0,    ! WHOMO
     8  0.0d0,    ! WDFADIS
     9  0.0d0,    ! WDFATOR
     @  0.0d0,    ! WDFANEI
     1  0.0d0,    ! WDFABET
     2  1.0d0     ! WSS
     &       /
#ifdef DFA
#if defined(SCP14) && defined(SPLITELE)
      data nprint_ene /32/
      data print_order/1,2,18,3,16,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,28,29,30,31,22,23,25,20,32/
#elif defined(SCP14)
      data nprint_ene /31/
      data print_order/1,2,18,3,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,28,29,30,31,22,23,25,20,32,0/
#elif defined(SPLITELE)
      data nprint_ene /31/
      data print_order/1,2,3,16,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,28,29,30,31,22,23,25,20,32,0/
#else
      data nprint_ene /32/
      data print_order/1,2,3,16,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,28,29,30,31,22,23,25,20,32,0/
#endif
#else
#if defined(SCP14) && defined(SPLITELE)
      data nprint_ene /28/
      data print_order/1,2,18,3,16,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,22,23,25,20,32,4*0/
#elif defined(SCP14)
      data nprint_ene /27/
      data print_order/1,2,18,3,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,22,23,25,20,32,5*0/
#elif defined(SPLITELE)
      data nprint_ene /27/
      data print_order/1,2,3,16,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,22,23,25,20,32,5*0/
#else
      data nprint_ene /27/
      data print_order/1,2,3,16,17,11,12,13,14,4,5,6,7,8,9,10,21,19,
     & 24,15,26,27,22,23,25,20,32,5*0/
#endif
#endif
      end 
c---------------------------------------------------------------------------
      subroutine init_int_table
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
#ifdef MPI
      include 'mpif.h'
#endif
#ifdef MP
      include 'COMMON.INFO'
#endif
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.LOCAL'
      include 'COMMON.SBRIDGE'
      include 'COMMON.IOUNITS'
      include "COMMON.TORCNSTR"
      logical scheck,lprint
      lprint=.true.
      do i=1,maxres
        nint_gr(i)=0
        nscp_gr(i)=0
        do j=1,maxint_gr
          istart(i,1)=0
          iend(i,1)=0
          ielstart(i)=0
          ielend(i)=0
          iscpstart(i,1)=0
          iscpend(i,1)=0    
        enddo
      enddo
      ind_scint=0
      ind_scint_old=0
cd    write (iout,*) 'ns=',ns,' nss=',nss,' ihpb,jhpb',
cd   &   (ihpb(i),jhpb(i),i=1,nss)
      do i=nnt,nct-1
        scheck=.false.
        if (dyn_ss) goto 10
        do ii=1,nss
          if (ihpb(ii).eq.i+nres) then
            scheck=.true.
            jj=jhpb(ii)-nres
            goto 10
          endif
        enddo
   10   continue
cd      write (iout,*) 'i=',i,' scheck=',scheck,' jj=',jj
        if (scheck) then
          if (jj.eq.i+1) then
            nint_gr(i)=1
            istart(i,1)=i+2
            iend(i,1)=nct
          else if (jj.eq.nct) then
            nint_gr(i)=1
            istart(i,1)=i+1
            iend(i,1)=nct-1
          else
            nint_gr(i)=2
            istart(i,1)=i+1
            iend(i,1)=jj-1
            istart(i,2)=jj+1
            iend(i,2)=nct
          endif
        else
          nint_gr(i)=1
          istart(i,1)=i+1
          iend(i,1)=nct
          ind_scint=int_scint+nct-i
        endif
      enddo
   12 continue
      iatsc_s=nnt
      iatsc_e=nct-1
      if (lprint) then
      write (iout,'(a)') 'Interaction array:'
      do i=iatsc_s,iatsc_e
        write (iout,'(i3,2(2x,2i3))') 
     & i,(istart(i,iint),iend(i,iint),iint=1,nint_gr(i))
      enddo
      endif
      ispp=2
      iatel_s=nnt
      iatel_e=nct-3
      do i=iatel_s,iatel_e
        ielstart(i)=i+4
        ielend(i)=nct-1
      enddo
      if (lprint) then
        write (iout,'(a)') 'Electrostatic interaction array:'
        do i=iatel_s,iatel_e
          write (iout,'(i3,2(2x,2i3))') i,ielstart(i),ielend(i)
        enddo
      endif ! lprint
c     iscp=3
      iscp=2
C Partition the SC-p interaction array
      iatscp_s=nnt
      iatscp_e=nct-1
      do i=nnt,nct-1
        if (i.lt.nnt+iscp) then
          nscp_gr(i)=1
          iscpstart(i,1)=i+iscp
          iscpend(i,1)=nct
        elseif (i.gt.nct-iscp) then
          nscp_gr(i)=1
          iscpstart(i,1)=nnt
          iscpend(i,1)=i-iscp
        else
          nscp_gr(i)=2
          iscpstart(i,1)=nnt
          iscpend(i,1)=i-iscp
          iscpstart(i,2)=i+iscp
          iscpend(i,2)=nct
        endif 
      enddo ! i
      if (lprint) then
        write (iout,'(a)') 'SC-p interaction array:'
        do i=iatscp_s,iatscp_e
          write (iout,'(i3,2(2x,2i3))') 
     &         i,(iscpstart(i,j),iscpend(i,j),j=1,nscp_gr(i))
        enddo
      endif ! lprint
C Partition local interactions
      loc_start=2
      loc_end=nres-1
      ithet_start=3
      ithet_end=nres
      iturn3_start=nnt
      iturn3_end=nct-3
      iturn4_start=nnt
      iturn4_end=nct-4
      iphi_start=nnt+3
      iphi_end=nct
      idihconstr_start=1
      idihconstr_end=ndih_constr
      ithetaconstr_start=1
      ithetaconstr_end=ntheta_constr
      itau_start=4
      itau_end=nres
      return
      end 
c---------------------------------------------------------------------------
      subroutine int_partition(int_index,lower_index,upper_index,atom,
     & at_start,at_end,first_atom,last_atom,int_gr,jat_start,jat_end,*)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      integer int_index,lower_index,upper_index,atom,at_start,at_end,
     & first_atom,last_atom,int_gr,jat_start,jat_end
      logical lprn
      lprn=.false.
      if (lprn) write (iout,*) 'int_index=',int_index
      int_index_old=int_index
      int_index=int_index+last_atom-first_atom+1
      if (lprn) 
     &   write (iout,*) 'int_index=',int_index,
     &               ' int_index_old',int_index_old,
     &               ' lower_index=',lower_index,
     &               ' upper_index=',upper_index,
     &               ' atom=',atom,' first_atom=',first_atom,
     &               ' last_atom=',last_atom
      if (int_index.ge.lower_index) then
        int_gr=int_gr+1
        if (at_start.eq.0) then
          at_start=atom
          jat_start=first_atom-1+lower_index-int_index_old
        else
          jat_start=first_atom
        endif
        if (lprn) write (iout,*) 'jat_start',jat_start
        if (int_index.ge.upper_index) then
          at_end=atom
          jat_end=first_atom-1+upper_index-int_index_old
          return1
        else
          jat_end=last_atom
        endif
        if (lprn) write (iout,*) 'jat_end',jat_end
      endif
      return
      end
c------------------------------------------------------------------------------
      subroutine hpb_partition
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      include 'COMMON.IOUNITS'
      link_start=1
      link_end=nhpb
      link_start_peak=1
      link_end_peak=npeak
      write (iout,*) 'HPB_PARTITION',
     &  ' nhpb',nhpb,' link_start=',link_start,
     &  ' link_end',link_end,' link_start_peak',link_start_peak,
     &  ' link_end_peak',link_end_peak
      return
      end
c------------------------------------------------------------------------------
      subroutine homology_partition
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'DIMENSIONS.FREE'
      include 'COMMON.SBRIDGE'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.HOMOLOGY'
      include 'COMMON.HOMRESTR'
      include 'COMMON.INTERACT'
cd      write(iout,*)"homology_partition: lim_odl=",lim_odl,
cd     &   " lim_dih",lim_dih
      link_start_homo=1
      link_end_homo=lim_odl
      idihconstr_start_homo=nnt+3
      idihconstr_end_homo=lim_dih+nnt-1+3
      write (iout,*)
     &  ' lim_odl',lim_odl,' link_start=',link_start_homo,
     &  ' link_end',link_end_homo,' lim_dih',lim_dih,
     &  ' idihconstr_start_homo',idihconstr_start_homo,
     &  ' idihconstr_end_homo',idihconstr_end_homo
      return
      end

