      subroutine contchain(count_aggr)
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.ZSCOPT'
      include 'DIMENSIONS.COMPAR'
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      include 'COMMON.LOCAL'
      include 'COMMON.CALC'
      include 'COMMON.CONTPAR'
      logical lprint
      double precision count_aggr(0:maxchain)
      integer nclust_chain,nmember(maxchain),
     &  clust_member(maxchain,maxchain),flag_chain(maxchain)
      integer ichain,jchain,ii,jj!,i,j
!      double precision xi,yi,zi,xj,yj,zj,rij
      double precision xi,yi,zi
      double precision u,v,a(3),b(3),dla,dlb
      double precision boxshift
      double precision cutoff2 /49.0d0/
      double precision sum_aggr,sum_clust
      double precision dist
      external dist
      double precision csc
      integer iti,itj
      nclust_chain=0 
      flag_chain(:nchain)=0
      count_aggr=0.0d0
      do ichain=1,nchain-1
        do ii=chain_border(1,ichain),chain_border(2,ichain)
          xi=c(1,ii+nres)
          yi=c(2,ii+nres)
          zi=c(3,ii+nres)
          call to_box(xi,yi,zi)
          do jchain=ichain+1,nchain
            do jj=chain_border(1,jchain),chain_border(2,jchain)
              iti=itype(ii)
              itj=itype(jj)
              xj=c(1,jj+nres)
              yj=c(2,jj+nres)
              zj=c(3,jj+nres)
              call to_box(xj,yj,zj)
              xj=boxshift(xj-xi,boxxsize)
              yj=boxshift(yj-yi,boxysize)
              zj=boxshift(zj-zi,boxzsize)
              dxi = dc_norm(1,nres+ii)
              dyi = dc_norm(2,nres+ii)
              dzi = dc_norm(3,nres+ii)
              dxj = dc_norm(1,nres+jj)
              dyj = dc_norm(2,nres+jj)
              dzj = dc_norm(3,nres+jj)
              do k=1,3
                a(k)=dc(k,nres+ii)
                b(k)=dc(k,nres+jj)
              enddo
c               write (iout,*) (a(k),k=1,3),(b(k),k=1,3)
              if (icomparfunc.eq.1) then
                call contfunc(csc,iti,itj)
              else if (icomparfunc.eq.2) then
                call scdist(csc,iti,itj)
              else if (icomparfunc.eq.3 .or. icomparfunc.eq.5) then
                csc = dist(nres+i,nres+j)
              else if (icomparfunc.eq.4) then
                call odlodc(c(1,i),c(1,j),a,b,u,v,dla,dlb,csc)
              else
                write (*,*) "Error - Unknown sidechain contact function"
             write (iout,*) "Error - Unknown sidechain contact function"
              endif 
              if (csc.lt.sc_cutoff(iti,itj)) then
!              rij=xj*xj+yj*yj+zj*zj
!              if (rij.lt.cutoff2) then
                flag_chain(ichain)=1
                flag_chain(jchain)=1
                call add_clust_chain(ichain,jchain,nclust_chain,
     &                   nmember,clust_member)
                goto 10
              endif
            enddo ! jj
   10       continue
          enddo ! jchain
        enddo ! ii
      enddo ! ichain
      count_aggr(1)=0
      do ichain=1,nchain
        if (flag_chain(ichain).eq.0) count_aggr(1)=count_aggr(1)+1.0d0
      enddo
#ifdef DEBUG
      write (iout,*) "flag",flag_chain(:nchain)
      write (iout,*) "nclust_chain",nclust_chain
      do i=1,nclust_chain
        write (iout,*) i," nmember",nmember(i)," members",
     &   clust_member(:nmember(i),i)
      enddo
#endif
      do i=1,nclust_chain
        count_aggr(nmember(i))=count_aggr(nmember(i))+1.0d0
      enddo 
#ifdef DEBUG
      write (iout,*) "count_aggr",count_aggr(:nchain)
#endif
      sum_aggr=0.0d0
      sum_clust=0.0d0
      do i=1,nchain
        sum_aggr=sum_aggr+i*count_aggr(i)
        sum_clust=sum_clust+count_aggr(i)
      enddo
#ifdef DEBUG
      write (iout,*) "sum_aggr",sum_aggr," sum_clust",sum_clust
#endif
      count_aggr(0)=sum_aggr/sum_clust
      return
      end
c----------------------------------------------------------------------------
      subroutine add_clust_chain(ichain,jchain,nclust_chain,nmember,
     &  clust_member)
      implicit none
      include "DIMENSIONS"
      integer ichain,jchain,nclust_chain,nmember(maxchain),
     &  clust_member(maxchain,maxchain)
      integer i,j,nmemi
      logical iflag,jflag
c      write (2,*) "add_clust nclust_chain",nclust_chain
      iflag=.false.
      jflag=.false.
      do i=1,nclust_chain
        nmemi=nmember(i)
        do j=1,nmemi
          if (ichain.eq.clust_member(j,i)) iflag=.true.
          if (jchain.eq.clust_member(j,i)) jflag=.true.
        enddo
        if (iflag.and.jflag) then
          return
        else if (iflag) then
          nmember(i)=nmember(i)+1
          clust_member(nmember(i),i)=jchain
          call merge_cluster(jchain,i,nclust_chain,nmember,clust_member)
          return
        else if (jflag) then
          nmember(i)=nmember(i)+1
          clust_member(nmember(i),i)=ichain
          call merge_cluster(ichain,i,nclust_chain,nmember,clust_member)
          return
        endif
      enddo
      nclust_chain=nclust_chain+1
      nmember(nclust_chain)=2
      clust_member(1,nclust_chain)=ichain
      clust_member(2,nclust_chain)=jchain
      return
      end
c----------------------------------------------------------------------------
      subroutine merge_cluster(ichain,iclust,nclust_chain,nmember,
     &  clust_member)
      implicit none
            include "DIMENSIONS"
      integer ichain,jchain,nclust_chain,nmember(maxchain),
     &  clust_member(maxchain,maxchain)
      integer i,j,iclust,nmemi
      logical in_clust
      i=iclust
c      write (2,*) "merge_clust: iclust",iclust," ichain",ichain
      do while (i.lt.nclust_chain)
        i=i+1
c        write (2,*) "i",i
        if (in_clust(ichain,nmember(i),clust_member(1,i))) then
c          write (2,*) "in_clust .true."
          do j=1,nmember(i)
c            write (2,*) "j",j," clust_member",clust_member(j,i)
            if (.not.in_clust(clust_member(j,i),nmember(iclust),
     &        clust_member(1,iclust))) then
c              write (2,*) ".not.in_clust"
              nmember(iclust)=nmember(iclust)+1
              clust_member(nmember(iclust),iclust)=clust_member(j,i)
            endif
          enddo
          nclust_chain=nclust_chain-1
          do j=i,nclust_chain
            clust_member(:nmember(j+1),j)
     &         =clust_member(:nmember(j+1),j+1)
            nmember(j)=nmember(j+1)
          enddo
        endif
      enddo
      return
      end
c----------------------------------------------------------------------------
      logical function in_clust(ichain,nmember,clust_member)
      implicit none
      integer ichain,nmember,clust_member(nmember)
      integer i
      do i=1,nmember
        if (ichain.eq.clust_member(i)) then
          in_clust=.true.
          return
        endif
      enddo
      in_clust=.false.
      return
      end
