      subroutine PMFread(*)
c Read the PMFs from wham
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.FREE'
      include 'COMMON.IOUNITS'
      include 'COMMON.FREE'
      include 'COMMON.PMF'
      integer i,iumb,iiset,j,t,nbin,iparm,nRmax
      double precision beta_h_temp,qtemp,htemp
      read(inp,*,err=10,end=10) delta_q
      write(iout,*) "delta_q",delta_q

      do iparm = 1, nparmset

      write(iout,*) "PMFread: iparm",iparm," nT",nT_h(iparm),
     &  " nR",nR(:nT_h(iparm),iparm)
c      print *,(beta_h(i),i=1,nT(iparm))
      do j=1,nT_h(iparm)
        do iumb=1,nR(j,iparm)
          read (inp,*,end=10,err=10) iiset,beta_h_temp,nbin
          write (iout,*) iiset,beta_h_temp,nbin
          if (iiset.ne.iumb) then
            write(iout,*) "Error: inconsistency in US windows",
     &         iiset,iumb 
            return1
          endif
          beta_h_temp=1.0d0/(0.001987*beta_h_temp)
          if (dabs(beta_h_temp-beta_h(j,iparm)).gt.1.0d-6) then
            write (iout,*) 
     &     "Error replica temperatures do not match PMF temperatures"
            write (iout,*) 1.0d0/(0.001987*beta_h_temp),
     &      1.0d0/(0.001987*beta_h(j,iparm))
            stop
          endif
          do i=1,nbin
            read (inp,*,end=10,err=10) qtemp,htemp
            t = int(qtemp/delta_q+1.0d-4)
            write (iout,*) qtemp,t,htemp
            if (i.eq.1) tmin(j,iumb,iparm)=t
            if (i.eq.nbin) tmax(j,iumb,iparm)=t
            PMFtab(t,j,iumb,iparm)=dlog(htemp)/beta_h_temp
          enddo ! i
        enddo ! iumb
      enddo ! j

      nRmax=nR(1,iparm)
      do i=2,nT_h(iparm)
        if (nR(i,iparm).gt.nRmax) nRmax=nR(i,iparm)
      enddo
      do iumb=1,nR(j,iparm)
        write (iout,*)"Input PMFs, restraint",iumb,
     &   " q0",q0(1,iumb,:nT_h(iparm),iparm)
        write (iout,'(5x,20f10.1)') (1.0d0/(0.001987*beta_h(j,iparm)),
     &   j=1,nT_h(iparm))
        do i=0,int(1.0/delta_q)
          write (iout,'(f5.2,$)') i*delta_q
          do j=1,nT_h(iparm)
            if (i.lt.tmin(j,iumb,iparm).or.i.gt.tmax(j,iumb,iparm)) then
              write (iout,'("    ------",$)')
            else
              write (iout,'(f10.3$)') PMFtab(i,j,iumb,iparm)
            endif
          enddo
          write (iout,*) 
        enddo ! i
      enddo ! iumb

      enddo ! iparm
      return
   10 return1
      end
c------------------------------------------------------------------------
      subroutine PMF_energy(q,irep,iset,iparm,ePMF,ePMF_q)
c Calculate the energy and derivative in q due to the biasing PMF
c Caution! Only ONE q is handled, no multi-D q-restraints available!
      implicit none
      include 'DIMENSIONS'
      include 'DIMENSIONS.FREE'
      include 'COMMON.IOUNITS'
      include 'COMMON.FREE'
      include 'COMMON.PMF'
      integer i,iqmin,iqmax,irep,iset,iparm
      double precision q,qmin,qmax,ePMF,ePMF_q
c Determine the location of the q
      iqmin=tmin(irep,iset,iparm)
      iqmax=tmax(irep,iset,iparm)
      qmin=iqmin*delta_q
      qmax=iqmax*delta_q
#ifdef DEBUG
      write (iout,*) "PMF_energy q",q," qmin",qmin," qmax",qmax,
     & " irep",irep," iset",iset
#endif
      if (q.le.qmin) then
        ePMF_q=(PMFtab(iqmin+1,irep,iset,iparm)-
     &     PMFtab(iqmin,irep,iset,iparm))/delta_q
        ePMF=PMFtab(iqmin,irep,iset,iparm)+ePMF_q*(q-qmin)
#ifdef DEBUG
       write (iout,*) "q<=qmin ePMF",ePMF," ePMF_q",ePMF_q
#endif
      else if (q.ge.qmax) then
        ePMF_q=(PMFtab(iqmax,irep,iset,iparm)-
     &      PMFtab(iqmax-1,irep,iset,iparm))/delta_q 
        ePMF=PMFtab(iqmax,irep,iset,iparm)+ePMF_q*(q-qmax)
#ifdef DEBUG
       write (iout,*) "q>=qmax ePMF",ePMF," ePMF_q",ePMF_q
#endif
      else
        do i=iqmin+1,iqmax
          qmax=i*delta_q
          if (q.ge.qmin .and. q.le.qmax) then
            ePMF_q=(PMFtab(i,irep,iset,iparm)-
     &       PMFtab(i-1,irep,iset,iparm))/delta_q
            ePMF=PMFtab(i-1,irep,iset,iparm)+ePMF_q*(q-qmin)
#ifdef DEBUG
       write (iout,*) "qmin<q<qmax bin",i," ePMF",ePMF," ePMF_q",ePMF_q
#endif
            exit
          endif
          qmin=qmax
        enddo
      endif
      return
      end  
