#define SCATTER
      subroutine readrst
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
      integer ierror
      include 'COMMON.SETUP'
#endif
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
#ifdef FIVEDIAG
       include 'COMMON.LAGRANGE.5diag'
#else
       include 'COMMON.LAGRANGE'
#endif
      integer i,j
      include 'COMMON.AVNLOC'
      include 'COMMON.RESTARTED'
      integer iorder /14/
      open(irest2,file=rest2name,status='unknown')
      if(atimeave_save.gt.0) then
        read(irest2,*) totT,EK,potE,totE,t_bath
        totTafm=totT
        do i=0,2*nres-1
         read(irest2,*) (d_t(j,i),j=1,3)
        enddo
        do i=0,2*nres-1
         read(irest2,*) (dc(j,i),j=1,3)
        enddo
        if(usampl) then
             read (irest2,*) iset
        endif

        read(irest2,*) nsteps(1:4),icalls(1:4),idiv_tau(1:4),ionce
        read(irest2,*) etimeave(1:3)
        read(irest2,*) tau_temp(1:4),scal_force(1:4)
#ifdef DEBUG
        write(iout,*)"readrst nsteps",nsteps(1:4),
     &  " icalls",icalls(1:4),"idiv_tau",idiv_tau," ionce",ionce,
     &  " atimeave",atimeave_save
        write (iout,*) "etimeave",etimeave
        write (iout,*) "tau_temp",tau_temp
        write (iout,*) "scal_force",scal_force
#endif
        do i=1,nhpb_peak
          read(irest2,*) dnmr_xave(1,i),
     &       dnmr_xave(2,i),dnmr_xave0(i)
        enddo
        do i=1,ndih_constr
          read(irest2,*) cosphi_xave(1,i),cosphi_xave(2,i),
     &       cosphi_xave0(i),sinphi_xave(1,i),sinphi_xave(2,i),  
     &       sinphi_xave0(i)
        enddo
        do i=1,ntheta_constr
          read(irest2,*) theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
        enddo
#ifdef DEBUG
        do i=1,nhpb_peak
          write (iout,'(i5,3(f16.9,1x))') i,dnmr_xave(:,i),dnmr_xave0(i)
        enddo
        do i=1,ndih_constr
          write (iout,'(i5,6(f16.9,1x))') i,
     &          cosphi_xave(1,i),cosphi_xave(2,i),cosphi_xave0(i),
     &          sinphi_xave(1,i),sinphi_xave(2,i),sinphi_xave0(i)
        enddo
        do i=1,ntheta_constr
          write (iout,'(i5,3(f16.9,1x))') i,
     &          theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
        enddo
#endif
#ifdef MPI
        if (nfgtasks.gt.1) then
C
C Broadcast & scatter the restart information for time-average calculations
C to slave processors
C
          call MPI_Bcast(iorder,1,MPI_INTEGER,king,FG_COMM,IERROR)
c          write (iout,*) "Calling nmr_ave_restart_Bscatter"
          call nmr_ave_restart_Bscatter
        endif
#endif
       else
        read(irest2,*) totT,EK,potE,totE,t_bath
        totTafm=totT
        do i=0,2*nres-1
         read(irest2,'(3e15.5)') (d_t(j,i),j=1,3)
        enddo
        do i=0,2*nres-1
         read(irest2,'(3e15.5)') (dc(j,i),j=1,3)
        enddo
        if(usampl) then
             read (irest2,*) iset
        endif
       endif
      close(irest2)
      return
      end
c------------------------------------------------------------------------------
      subroutine writerst
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
      integer ierror
      include 'COMMON.SETUP'
#endif
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
#ifdef FIVEDIAG
       include 'COMMON.LAGRANGE.5diag'
#else
       include 'COMMON.LAGRANGE'
#endif
      integer i,j
      include 'COMMON.AVNLOC'
      include 'COMMON.RESTARTED'
      integer iorder /13/
      open(irest2,file=rest2name,status='unknown')
      if (atimeave.gt.0) then
#ifdef MPI
C
C Gather the restart information for time-averaged calculations from slave 
C processors
C
        if (nfgtasks.gt.1) then
c           write (iout,*) "writerst: broadcast order"
c           call flush(iout)
           call MPI_Bcast(iorder,1,MPI_INTEGER,king,FG_COMM,IERROR)
c           write (iout,*) "writerst: calling nmr_ave_restart_gather"
c           call flush(iout)
           call nmr_ave_restart_gather
c           write (iout,*) "writerst: exit nmr_ave_restart_gather"
c           call flush(iout)
        endif
#endif
        write(irest2,*) totT,EK,potE,totE,t_bath
        do i=0,2*nres-1
          write (irest2,'(3e20.10)') (d_t(j,i),j=1,3)
        enddo
        do i=0,2*nres-1
          write (irest2,'(3e20.10)') (dc(j,i),j=1,3)
        enddo
        write(irest2,'(9i15,4i5)') nsteps(1:4),
     &   icalls(1:4),idiv_tau(1:4),ionce
        write(irest2,'(3e20.10)') potEcomp(15),
     &   potEcomp(19),potEcomp(24)
        write(irest2,'(8e20.10)') tau_temp(1:4),scal_force(1:4)
        do i=1,nhpb_peak
          write (irest2,'(3e20.10)') dnmr_xave(1,i),
     &    dnmr_xave(2,i), dnmr_xave0(i)
        enddo
        do i=1,ndih_constr
          write(irest2,'(6e20.10)')
     &      cosphi_xave(1,i),cosphi_xave(2,i),cosphi_xave0(i),
     &      sinphi_xave(1,i),sinphi_xave(2,i),sinphi_xave0(i)
        enddo
        do i=1,ntheta_constr
          write(irest2,'(3e20.10)')
     &      theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
        enddo
        close(irest2)
      else
        write(irest2,*) totT,EK,potE,totE,t_bath
        do i=0,2*nres-1
          write (irest2,'(3e20.10)') (d_t(j,i),j=1,3)
        enddo
        do i=0,2*nres-1
          write (irest2,'(3e20.10)') (dc(j,i),j=1,3)
        enddo
        close(irest2)
      endif
      return
      end
#ifdef MPI
c-----------------------------------------------------------------------
      subroutine write1rstave(i_index)
      implicit none
      include 'DIMENSIONS'
      include 'mpif.h'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
#ifdef FIVEDIAG
       include 'COMMON.LAGRANGE.5diag'
#else
       include 'COMMON.LAGRANGE'
#endif
      include 'COMMON.QRESTR'
      include 'COMMON.IOUNITS'
      include 'COMMON.REMD'
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.SBRIDGE'
      include 'COMMON.INTERACT'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
     
      real d_restart1(3,2*maxres*max_cg_procs),r_d(3,0:2*maxres-1),
     &     d_restart2(3,2*maxres*max_cg_procs)
      real t5_restart1(5)
c----------------------- ave restart --------------------------
      include 'COMMON.AVNLOC'
      include 'COMMON.RESTARTED'
      integer ave_restart(13)
      integer  ave_restart1(13,max_cg_procs)
      double precision ave_potEres1(3,max_cg_procs),
     & ave_taures1(4,max_cg_procs),ave_scalres1(4,max_cg_procs)
        
      real    dnmr_xave0_res(maxdim_nmr),dnmr_xave_res(2,maxdim_nmr),
     &        cosphi_xave0_res(maxres),
     &        cosphi_xave_res(2,maxres),
     &        sinphi_xave0_res(maxres),
     &        sinphi_xave_res(2,maxres),
     &        theta_xave0_res(maxres),
     &        theta_xave_res(2,maxres)
      real    dnmr_xave0_res1(maxdim_nmr*max_cg_procs),
     &        dnmr_xave_res1(2*maxdim_nmr*max_cg_procs),
     &        cosphi_xave0_res1(maxres*max_cg_procs),
     &        cosphi_xave_res1(2*maxres*max_cg_procs),
     &        sinphi_xave0_res1(maxres*max_cg_procs),
     &        sinphi_xave_res1(2*maxres*max_cg_procs),
     &        theta_xave0_res1(maxres*max_cg_procs),
     &        theta_xave_res1(2*maxres*max_cg_procs)
      
c--------------------------------------------------------------  
      integer iret,itmp
      integer*2 i_index(max_rep,max_remd_m,max_set,max_mult_set)
      common /przechowalnia/ d_restart1,d_restart2,
     & dnmr_xave0_res,dnmr_xave_res,cosphi_xave0_res,cosphi_xave_res,
     & sinphi_xave0_res,sinphi_xave_res,theta_xave0_res,theta_xave_res,
     &dnmr_xave0_res1,dnmr_xave_res1,cosphi_xave0_res1,cosphi_xave_res1,
     & sinphi_xave0_res1,sinphi_xave_res1,theta_xave0_res1,
     & theta_xave_res1
      integer i,j,il1,il,ixdrf
      integer ierr
      common /write1rstcommon/ r_d
      integer iorder /13/
C
C Gather the restart information for time-averaged calculations from slave 
C processors
C
       if (nfgtasks.gt.1) then
         call MPI_Bcast(iorder,1,MPI_INTEGER,king,FG_COMM,IERR)
         call nmr_ave_restart_gather
       endif
       t5_restart1(1)=totT
       t5_restart1(2)=EK
       t5_restart1(3)=potE
       t5_restart1(4)=t_bath
       t5_restart1(5)=Uconst
       
       call mpi_gather(t5_restart1,5,mpi_real,
     &      t_restart1,5,mpi_real,king,CG_COMM,ierr)


       do i=0,2*nres-1
         do j=1,3
           r_d(j,i)=d_t(j,i)
         enddo
       enddo

       call mpi_gather(r_d,3*2*nres,mpi_real,
     &           d_restart1,3*2*nres,mpi_real,king,
     &           CG_COMM,ierr)


       do i=0,2*nres-1
         do j=1,3
           r_d(j,i)=dc(j,i)
         enddo
       enddo
       call mpi_gather(r_d,3*2*nres,mpi_real,
     &           d_restart2,3*2*nres,mpi_real,king,
     &           CG_COMM,ierr)


!--------------------Time-averaged part ---------------------
       ave_restart(1)=nsteps(1)
       ave_restart(2)=nsteps(2)
       ave_restart(3)=nsteps(3)
       ave_restart(4)=nsteps(4)
       ave_restart(5)=icalls(1)
       ave_restart(6)=icalls(2)
       ave_restart(7)=icalls(3)
       ave_restart(8)=icalls(4)
       ave_restart(9)=idiv_tau(1)
       ave_restart(10)=idiv_tau(2)
       ave_restart(11)=idiv_tau(3)
       ave_restart(12)=idiv_tau(4)
       ave_restart(13)=ionce

       call mpi_gather(ave_restart,13,mpi_int,
     & ave_restart1,13,mpi_int,king,CG_COMM,ierr)

       etimeave(1)=potEcomp(15)
       etimeave(2)=potEcomp(19)
       etimeave(3)=potEcomp(24)
c       write(iout,*)"Uconst_cache",Uconst_cache(ntwx_cache),potEcomp(15)
#ifdef DEBUG
       write(iout,*)"write1rst Processor",me," nsteps",nsteps(1:4),
     &  " icalls",icalls(1:4),"idiv_tau",idiv_tau," ionce",ionce,
     &  " atimeave",atimeave_save
       write (iout,*) "etimeave",etimeave
       write (iout,*) "tau_temp",tau_temp
       write (iout,*) "scal_force",scal_force
       do i=1,nhpb_peak
         write (iout,'(i5,3(f16.9,1x))') i,dnmr_xave(:,i),dnmr_xave0(i)
       enddo
       do i=1,ndih_constr
         write (iout,'(i5,6(f16.9,1x))') i,
     &          cosphi_xave(1,i),cosphi_xave(2,i),cosphi_xave0(i),
     &          sinphi_xave(1,i),sinphi_xave(2,i),sinphi_xave0(i)
       enddo
       do i=1,ntheta_constr
         write (iout,'(i5,3(f16.9,1x))') i,
     &          theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
       enddo
#endif
       call mpi_gather(etimeave,3,mpi_double,
     & ave_potEres1,3,mpi_double,king,CG_COMM,ierr)

#ifdef DEBUG
      if(me.eq.king) then
       do il=1,nodes    
        write(iout,*)"ave_potEres1",ave_potEres1(:,il)
       enddo
      endif
#endif

       call mpi_gather(tau_temp,4,mpi_double,
     & ave_taures1,4,mpi_double,king,CG_COMM,ierr)

#ifdef DEBUG
      if(me.eq.king) then
       do il=1,nodes    
        write(iout,*)"ave_taures1",ave_taures1(:,il)
       enddo
      endif
#endif

       call mpi_gather(scal_force,4,mpi_double,
     & ave_scalres1,4,mpi_double,king,CG_COMM,ierr)

#ifdef DEBUG
      if(me.eq.king) then
       do il=1,nodes    
        write(iout,*)"ave_scalres1",ave_scalres1(:,il)
       enddo
      endif
#endif

      if (nhpb_peak.gt.0) then

      dnmr_xave_res(:,:nhpb_peak)=dnmr_xave(:,:nhpb_peak)
     
      call mpi_gather(dnmr_xave_res,2*nhpb_peak,mpi_real,
     &      dnmr_xave_res1,2*nhpb_peak,mpi_real,king,CG_COMM,ierr)

      dnmr_xave0_res(:nhpb_peak)=dnmr_xave0(:nhpb_peak)

      call mpi_gather(dnmr_xave0_res,nhpb_peak,mpi_real,
     &      dnmr_xave0_res1,nhpb_peak,mpi_real,king,CG_COMM,ierr)

      endif

      if (ndih_constr.gt.0) then

      cosphi_xave_res(:,:ndih_constr)=cosphi_xave(:,:ndih_constr)

      call mpi_gather(cosphi_xave_res,2*ndih_constr,mpi_real,
     &      cosphi_xave_res1,2*ndih_constr,mpi_real,king,CG_COMM,ierr)
     
      cosphi_xave0_res(:ndih_constr)=cosphi_xave0(:ndih_constr)

      call mpi_gather(cosphi_xave0_res,ndih_constr,mpi_real,
     &      cosphi_xave0_res1,ndih_constr,mpi_real,king,CG_COMM,ierr)

      sinphi_xave_res(:,:ndih_constr)=sinphi_xave(:,:ndih_constr)

      call mpi_gather(sinphi_xave_res,2*ndih_constr,mpi_real,
     &      sinphi_xave_res1,2*ndih_constr,mpi_real,king,CG_COMM,ierr)
     
      sinphi_xave0_res(:ndih_constr)=sinphi_xave0(:ndih_constr)

      call mpi_gather(sinphi_xave0_res,ndih_constr,mpi_real,
     &      sinphi_xave0_res1,ndih_constr,mpi_real,king,CG_COMM,ierr)

      endif

      if (ntheta_constr.gt.0) then

      theta_xave_res(:,:ntheta_constr)=theta_xave(:,:ntheta_constr)
     
      call mpi_gather(theta_xave_res,2*ntheta_constr,mpi_real,
     &      theta_xave_res1,2*ntheta_constr,mpi_real,king,CG_COMM,ierr)

      theta_xave0_res(:ntheta_constr)=theta_xave0(:ntheta_constr)

      call mpi_gather(theta_xave0_res,ntheta_constr,mpi_real,
     &      theta_xave0_res1,ntheta_constr,mpi_real,king,CG_COMM,ierr)

      endif

!------------------------------------------------------------


       if(me.eq.king) then
       
#ifdef AIX
         call xdrfopen_(ixdrf,mremd_rst_name, "w", iret)
         do i=0,nodes-1
          call xdrfint_(ixdrf, i2rep(i), iret)
         enddo
         do i=1,remd_m(1)
          call xdrfint_(ixdrf, ifirst(i), iret)
         enddo
         do il=1,nodes
              do i=0,nupa(0,il)
               call xdrfint_(ixdrf, nupa(i,il), iret)
              enddo

              do i=0,ndowna(0,il)
               call xdrfint_(ixdrf, ndowna(i,il), iret)
              enddo
         enddo

         do il=1,nodes
           do j=1,4
            call xdrffloat_(ixdrf, t_restart1(j,il), iret)
           enddo
         enddo

         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat_(ixdrf, d_restart1(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo
         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat_(ixdrf, d_restart2(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo

         if(usampl) then
           call xdrfint_(ixdrf, nset, iret)
           do i=1,nset
             call xdrfint_(ixdrf,mset(i), iret)
           enddo
           do i=0,nodes-1
             call xdrfint_(ixdrf,i2set(i), iret)
           enddo
           do il=1,nset
             do il1=1,mset(il)
               do i=1,nrep
                 do j=1,remd_m(i)
                   itmp=i_index(i,j,il,il1)
                   call xdrfint_(ixdrf,itmp, iret)
                 enddo
               enddo
             enddo
           enddo

         endif
         call xdrfclose_(ixdrf, iret)
#else
         call xdrfopen(ixdrf,mremd_rst_name, "w", iret)
         do i=0,nodes-1
          call xdrfint(ixdrf, i2rep(i), iret)
         enddo
         do i=1,remd_m(1)
          call xdrfint(ixdrf, ifirst(i), iret)
         enddo
         do il=1,nodes
              do i=0,nupa(0,il)
               call xdrfint(ixdrf, nupa(i,il), iret)
              enddo

              do i=0,ndowna(0,il)
               call xdrfint(ixdrf, ndowna(i,il), iret)
              enddo
         enddo

         do il=1,nodes
           do j=1,4
            call xdrffloat(ixdrf, t_restart1(j,il), iret)
           enddo
         enddo

         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat(ixdrf, d_restart1(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo
         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat(ixdrf, d_restart2(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo
!add information for restart in time-averaged case
        do il=1,nodes
           do j=1,13
            call xdrfint(ixdrf, ave_restart1(j,il), iret)
           enddo
         enddo 

        do il=1,nodes
            call xdrfdouble(ixdrf,ave_potEres1(1,il), iret)
            call xdrfdouble(ixdrf,ave_potEres1(2,il), iret)
            call xdrfdouble(ixdrf,ave_potEres1(3,il), iret)
c            write(iout,*),"write ave_potEres1",il,ave_potEres1(:,il)
            do j=1,4
              call xdrfdouble(ixdrf,ave_taures1(j,il), iret)
            enddo
c            write(iout,*),"write ave_taures1",il,ave_taures1(:,il)
            do j=1,4
              call xdrfdouble(ixdrf,ave_scalres1(j,il), iret)
            enddo
c            write(iout,*),"write ave_scalres1",il,ave_scalres1(:,il)
        enddo

        if (nhpb_peak.gt.0) then
 
        do il=0,nodes-1
          do i=1,2*npeak
            call xdrffloat(ixdrf,dnmr_xave_res1(i+2*nhpb_peak*il), 
     &          iret)
          enddo
        enddo
        do il=0,nodes-1
          do i=1,npeak
            call xdrffloat(ixdrf,dnmr_xave0_res1(i+nhpb_peak*il), iret)
          enddo
        enddo

        endif

        if (ndih_constr.gt.0) then

        do il=0,nodes-1
          do i=1,2*ndih_constr
            call xdrffloat(ixdrf,cosphi_xave_res1(i+2*ndih_constr*il),
     &         iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,ndih_constr
            call xdrffloat(ixdrf,cosphi_xave0_res1(i+ndih_constr*il),
     &         iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,2*ndih_constr
            call xdrffloat(ixdrf,sinphi_xave_res1(i+2*ndih_constr*il),
     &         iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,ndih_constr
            call xdrffloat(ixdrf,sinphi_xave0_res1(i+ndih_constr*il),
     &         iret)
          enddo
        enddo

        endif

        if (ntheta_constr.gt.0) then

        do il=0,nodes-1
          do i=1,2*ntheta_constr
            call xdrffloat(ixdrf,theta_xave_res1(i+2*ntheta_constr*il),
     &        iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,ntheta_constr
           call xdrffloat(ixdrf,theta_xave0_res1(i+ntheta_constr*il),
     &        iret)
          enddo
        enddo
       
        endif

!--------------------------------------------------------------------
        if(usampl) then
         call xdrfint(ixdrf, nset, iret)
         do i=1,nset
           call xdrfint(ixdrf,mset(i), iret)
         enddo
         do i=0,nodes-1
           call xdrfint(ixdrf,i2set(i), iret)
         enddo
         do il=1,nset
          do il1=1,mset(il)
           do i=1,nrep
            do j=1,remd_m(i)
              itmp=i_index(i,j,il,il1)
              call xdrfint(ixdrf,itmp, iret)
            enddo
           enddo
          enddo
         enddo
        endif
       call xdrfclose(ixdrf, iret)
#endif
      endif
      return
      end
!-------------------------------------------------------------------
      subroutine write1rst(i_index)
      implicit none
      include 'DIMENSIONS'
      include 'mpif.h'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
#ifdef FIVEDIAG
       include 'COMMON.LAGRANGE.5diag'
#else
       include 'COMMON.LAGRANGE'
#endif
      include 'COMMON.QRESTR'
      include 'COMMON.IOUNITS'
      include 'COMMON.REMD'
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.SBRIDGE'
      include 'COMMON.INTERACT'

      real d_restart1(3,2*maxres*max_cg_procs),r_d(3,0:2*maxres-1),
     &     d_restart2(3,2*maxres*max_cg_procs)
      real t5_restart1(5)
      integer iret,itmp
      integer*2 i_index(max_rep,max_remd_m,max_set,max_mult_set)
       common /przechowalnia/ d_restart1,d_restart2
      integer i,j,il1,il,ixdrf
      integer ierr
      common /write1rstcommon/ r_d

       t5_restart1(1)=totT
       t5_restart1(2)=EK
       t5_restart1(3)=potE
       t5_restart1(4)=t_bath
       t5_restart1(5)=Uconst

       call mpi_gather(t5_restart1,5,mpi_real,
     &      t_restart1,5,mpi_real,king,CG_COMM,ierr)


       do i=0,2*nres-1
         do j=1,3
           r_d(j,i)=d_t(j,i)
         enddo
       enddo
       call mpi_gather(r_d,3*2*nres,mpi_real,
     &           d_restart1,3*2*nres,mpi_real,king,
     &           CG_COMM,ierr)


       do i=0,2*nres-1
         do j=1,3
           r_d(j,i)=dc(j,i)
         enddo
       enddo
       call mpi_gather(r_d,3*2*nres,mpi_real,
     &           d_restart2,3*2*nres,mpi_real,king,
     &           CG_COMM,ierr)

       if(me.eq.king) then
#ifdef AIX
         call xdrfopen_(ixdrf,mremd_rst_name, "w", iret)
         do i=0,nodes-1
          call xdrfint_(ixdrf, i2rep(i), iret)
         enddo
         do i=1,remd_m(1)
          call xdrfint_(ixdrf, ifirst(i), iret)
         enddo
         do il=1,nodes
              do i=0,nupa(0,il)
               call xdrfint_(ixdrf, nupa(i,il), iret)
              enddo

              do i=0,ndowna(0,il)
               call xdrfint_(ixdrf, ndowna(i,il), iret)
              enddo
         enddo

         do il=1,nodes
           do j=1,4
            call xdrffloat_(ixdrf, t_restart1(j,il), iret)
           enddo
         enddo

         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat_(ixdrf, d_restart1(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo
         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat_(ixdrf, d_restart2(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo

         if(usampl) then
           call xdrfint_(ixdrf, nset, iret)
           do i=1,nset
             call xdrfint_(ixdrf,mset(i), iret)
           enddo
           do i=0,nodes-1
             call xdrfint_(ixdrf,i2set(i), iret)
           enddo
           do il=1,nset
             do il1=1,mset(il)
               do i=1,nrep
                 do j=1,remd_m(i)
                   itmp=i_index(i,j,il,il1)
                   call xdrfint_(ixdrf,itmp, iret)
                 enddo
               enddo
             enddo
           enddo

         endif
         call xdrfclose_(ixdrf, iret)
#else
         call xdrfopen(ixdrf,mremd_rst_name, "w", iret)
         do i=0,nodes-1
          call xdrfint(ixdrf, i2rep(i), iret)
         enddo
         do i=1,remd_m(1)
          call xdrfint(ixdrf, ifirst(i), iret)
         enddo
         do il=1,nodes
              do i=0,nupa(0,il)
               call xdrfint(ixdrf, nupa(i,il), iret)
              enddo

              do i=0,ndowna(0,il)
               call xdrfint(ixdrf, ndowna(i,il), iret)
              enddo
         enddo

         do il=1,nodes
           do j=1,4
            call xdrffloat(ixdrf, t_restart1(j,il), iret)
           enddo
         enddo

         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat(ixdrf, d_restart1(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo
         do il=0,nodes-1
           do i=1,2*nres
            do j=1,3
             call xdrffloat(ixdrf, d_restart2(j,i+2*nres*il), iret)
            enddo
           enddo
         enddo

!--------------------------------------------------------------------
             if(usampl) then
              call xdrfint(ixdrf, nset, iret)
              do i=1,nset
                call xdrfint(ixdrf,mset(i), iret)
              enddo
              do i=0,nodes-1
                call xdrfint(ixdrf,i2set(i), iret)
              enddo
              do il=1,nset
               do il1=1,mset(il)
                do i=1,nrep
                 do j=1,remd_m(i)
                   itmp=i_index(i,j,il,il1)
                   call xdrfint(ixdrf,itmp, iret)
                 enddo
                enddo
               enddo
              enddo

             endif
         call xdrfclose(ixdrf, iret)
#endif
       endif
      return
      end
C-------------------------------------------------------------------------------
      subroutine read1restartave(i_index)
      implicit none
      include 'DIMENSIONS'
      include 'mpif.h'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
#ifdef FIVEDIAG
       include 'COMMON.LAGRANGE.5diag'
#else
       include 'COMMON.LAGRANGE'
#endif
      include 'COMMON.QRESTR'
      include 'COMMON.IOUNITS'
      include 'COMMON.REMD'
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.SBRIDGE'
      include 'COMMON.INTERACT'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
      real d_restart1(3,2*maxres*max_cg_procs),r_d(3,0:2*maxres-1),
     &     d_restart2(3,2*maxres*max_cg_procs),t5_restart1(5)
      integer*2 i_index(max_rep,max_remd_m,max_set,max_mult_set)
c-----------------------------time-ave information--------------------------------------
      include 'COMMON.AVNLOC'
      include 'COMMON.RESTARTED'
      integer iorder /14/
      integer ave_restart(13)
      integer  ave_restart1(13,max_cg_procs)
      double precision ave_potEres(3),ave_potEres1(3,max_cg_procs),
     & ave_taures1(4,max_cg_procs),ave_scalres1(4,max_cg_procs)

      real    dnmr_xave0_res(maxdim_nmr),dnmr_xave_res(2,maxdim_nmr),
     &        cosphi_xave0_res(maxres),
     &        cosphi_xave_res(2,maxres),
     &        sinphi_xave0_res(maxres),
     &        sinphi_xave_res(2,maxres),
     &        theta_xave0_res(maxres),
     &        theta_xave_res(2,maxres)
      real    dnmr_xave0_res1(maxdim_nmr*max_cg_procs),
     &        dnmr_xave_res1(2*maxdim_nmr*max_cg_procs),
     &        cosphi_xave0_res1(maxres*max_cg_procs),
     &        cosphi_xave_res1(2*maxres*max_cg_procs),
     &        sinphi_xave0_res1(maxres*max_cg_procs),
     &        sinphi_xave_res1(2*maxres*max_cg_procs),
     &        theta_xave0_res1(maxres*max_cg_procs),
     &        theta_xave_res1(2*maxres*max_cg_procs)
c---------------------------------------------------------------------------------------
      common /przechowalnia/ d_restart1,d_restart2,
     & dnmr_xave0_res,dnmr_xave_res,cosphi_xave0_res,cosphi_xave_res,
     & sinphi_xave0_res,sinphi_xave_res,theta_xave0_res,theta_xave_res,
     &dnmr_xave0_res1,dnmr_xave_res1,cosphi_xave0_res1,cosphi_xave_res1,
     & sinphi_xave0_res1,sinphi_xave_res1,theta_xave0_res1,
     & theta_xave_res1
      integer i,j,il,il1,ixdrf,iret,itmp
      integer ierr
      common /read1restartcommon/ r_d
#ifdef DEBUG
      write (iout,*) "Processor",me," called read1restart"
#endif
      if (me.eq.king) then
        open(irest2,file=mremd_rst_name,status='unknown')
        read(irest2,*,err=334) i
        write(iout,*) "Reading old rst in ASCI format"
        close(irest2)
        call read1restart_old
        return
 334    continue
#ifdef AIX
        call xdrfopen_(ixdrf,mremd_rst_name, "r", iret)

        do i=0,nodes-1
          call xdrfint_(ixdrf, i2rep(i), iret)
        enddo
        do i=1,remd_m(1)
          call xdrfint_(ixdrf, ifirst(i), iret)
        enddo
        do il=1,nodes
          call xdrfint_(ixdrf, nupa(0,il), iret)
          do i=1,nupa(0,il)
            call xdrfint_(ixdrf, nupa(i,il), iret)
          enddo

          call xdrfint_(ixdrf, ndowna(0,il), iret)
          do i=1,ndowna(0,il)
            call xdrfint_(ixdrf, ndowna(i,il), iret)
          enddo
        enddo
        do il=1,nodes
          do j=1,4
            call xdrffloat_(ixdrf, t_restart1(j,il), iret)
          enddo
        enddo

#else
        call xdrfopen(ixdrf,mremd_rst_name, "r", iret)

        do i=0,nodes-1
          call xdrfint(ixdrf, i2rep(i), iret)
        enddo
        do i=1,remd_m(1)
          call xdrfint(ixdrf, ifirst(i), iret)
        enddo
        do il=1,nodes
          call xdrfint(ixdrf, nupa(0,il), iret)
          do i=1,nupa(0,il)
            call xdrfint(ixdrf, nupa(i,il), iret)
          enddo

          call xdrfint(ixdrf, ndowna(0,il), iret)
          do i=1,ndowna(0,il)
            call xdrfint(ixdrf, ndowna(i,il), iret)
          enddo
        enddo
        do il=1,nodes
          do j=1,4
            call xdrffloat(ixdrf, t_restart1(j,il), iret)
          enddo
        enddo

#endif

      endif
      call mpi_scatter(t_restart1,5,mpi_real,
     &        t5_restart1,5,mpi_real,king,CG_COMM,ierr)
      totT=t5_restart1(1)
      EK=t5_restart1(2)
      potE=t5_restart1(3)
      t_bath=t5_restart1(4)
      
      

      if (me.eq.king) then
        do il=0,nodes-1
          do i=1,2*nres
c            read(irest2,'(3e15.5)')
c     &           (d_restart1(j,i+2*nres*il),j=1,3)
            do j=1,3
#ifdef AIX
              call xdrffloat_(ixdrf, d_restart1(j,i+2*nres*il), iret)
#else
              call xdrffloat(ixdrf, d_restart1(j,i+2*nres*il), iret)
#endif
            enddo
          enddo
        enddo
      endif
      call mpi_scatter(d_restart1,3*2*nres,mpi_real,
     &        r_d,3*2*nres,mpi_real,king,CG_COMM,ierr)

      do i=0,2*nres-1
        do j=1,3
         d_t(j,i)=r_d(j,i)
        enddo
      enddo
      if (me.eq.king) then
        do il=0,nodes-1
          do i=1,2*nres
c            read(irest2,'(3e15.5)')
c     &            (d_restart1(j,i+2*nres*il),j=1,3)
            do j=1,3
#ifdef AIX
              call xdrffloat_(ixdrf, d_restart1(j,i+2*nres*il), iret)
#else
              call xdrffloat(ixdrf, d_restart1(j,i+2*nres*il), iret)
#endif
            enddo
          enddo
        enddo
      endif
      call mpi_scatter(d_restart1,3*2*nres,mpi_real,
     &       r_d,3*2*nres,mpi_real,king,CG_COMM,ierr)
      do i=0,2*nres-1
        do j=1,3
          dc(j,i)=r_d(j,i)
        enddo
      enddo
!--------------------------time-ave------------------------------------------
      if (me.eq.king) then
        do il=1,nodes
          do j=1,13
            call xdrffloat(ixdrf,ave_restart1(j,il), iret)
          enddo
        enddo
      endif

      call mpi_scatter(ave_restart1,13,mpi_int,
     &      ave_restart,13,mpi_int,king,CG_COMM,ierr)

      nsteps(1)= ave_restart(1)
      nsteps(2)= ave_restart(2)
      nsteps(3)= ave_restart(3)
      nsteps(4)= ave_restart(4)
      icalls(1)= ave_restart(5)
      icalls(2)= ave_restart(6)
      icalls(3)= ave_restart(7)
      icalls(4)= ave_restart(8)
      idiv_tau(1)=ave_restart(9)
      idiv_tau(2)=ave_restart(10)
      idiv_tau(3)=ave_restart(11)
      idiv_tau(4)=ave_restart(12)
      ionce    = ave_restart(13)
c      if(me.eq.king)then  
c       do i=1,nodes 
c        write(iout,*),"test read ave",i, nsteps(:),icalls(:),
c     &   idiv_tau(:),ionce
c       enddo
c      endif


      if (me.eq.king) then
        do il=1,nodes
          call xdrfdouble(ixdrf,ave_potEres1(1,il), iret)
          call xdrfdouble(ixdrf,ave_potEres1(2,il), iret)
          call xdrfdouble(ixdrf,ave_potEres1(3,il), iret)
c          write(iout,*),il,"eave before scat",ave_potEres1(:,il)
          do j=1,4
            call xdrfdouble(ixdrf,ave_taures1(j,il), iret)
          enddo
c          write(iout,*),il,"tauave before scat",ave_taures1(:,il)
          do j=1,4
            call xdrfdouble(ixdrf,ave_scalres1(j,il), iret)
          enddo
c          write(iout,*),il,"scalave before scat",ave_scalres1(:,il)
        enddo
      endif
     
      call mpi_scatter(ave_potEres1,3,mpi_double,
     &           etimeave,3,mpi_double,king,CG_COMM,ierr)
  
c      write(iout,*),"etimeave read ave",me,etimeave(:)

      call mpi_scatter(ave_taures1,4,mpi_double,
     &           tau_temp,4,mpi_double,king,CG_COMM,ierr)

c      write(iout,*),"tau_temp read",me,tau_temp(:)
  
      call mpi_scatter(ave_scalres1,4,mpi_double,
     &           scal_force,4,mpi_double,king,CG_COMM,ierr)
  
c      write(iout,*),"scal_force read",me,scal_force(:)

      if (me.eq.king) then

        if (nhpb_peak.gt.0) then
 
        do il=0,nodes-1
          do i=1,2*npeak
            call xdrffloat(ixdrf,dnmr_xave_res1(i+2*nhpb_peak*il), 
     &          iret)
          enddo
        enddo
        do il=0,nodes-1
          do i=1,npeak
            call xdrffloat(ixdrf,dnmr_xave0_res1(i+nhpb_peak*il), iret)
          enddo
        enddo

        endif

        if (ndih_constr.gt.0) then

        do il=0,nodes-1
          do i=1,2*ndih_constr
            call xdrffloat(ixdrf,cosphi_xave_res1(i+2*ndih_constr*il),
     &         iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,ndih_constr
            call xdrffloat(ixdrf,cosphi_xave0_res1(i+ndih_constr*il),
     &         iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,2*ndih_constr
            call xdrffloat(ixdrf,sinphi_xave_res1(i+2*ndih_constr*il),
     &         iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,ndih_constr
            call xdrffloat(ixdrf,sinphi_xave0_res1(i+ndih_constr*il),
     &         iret)
          enddo
        enddo

        endif

        if (ntheta_constr.gt.0) then

        do il=0,nodes-1
          do i=1,2*ntheta_constr
            call xdrffloat(ixdrf,theta_xave_res1(i+2*ntheta_constr*il),
     &        iret)
          enddo
        enddo

        do il=0,nodes-1
          do i=1,ntheta_constr
            call xdrffloat(ixdrf,theta_xave0_res1(i+ntheta_constr*il),
     &        iret)
          enddo
        enddo
       
        endif

      endif

      if (nhpb_peak.gt.0) then

      call mpi_scatter(dnmr_xave_res1,2*nhpb_peak,mpi_real,
     &      dnmr_xave_res,2*nhpb_peak,mpi_real,king,CG_COMM,ierr)

      dnmr_xave(:,:nhpb_peak)=dnmr_xave_res(:,:nhpb_peak)
     
      call mpi_scatter(dnmr_xave0_res1,nhpb_peak,mpi_real,
     &      dnmr_xave0_res,nhpb_peak,mpi_real,king,CG_COMM,ierr)

      dnmr_xave0(:nhpb_peak)=dnmr_xave0_res(:nhpb_peak)

      endif

      if (ndih_constr.gt.0) then

      call mpi_scatter(cosphi_xave_res1,2*ndih_constr,mpi_real,
     &      cosphi_xave_res,2*ndih_constr,mpi_real,king,CG_COMM,ierr)

      cosphi_xave(:,:ndih_constr)=cosphi_xave_res(:,:ndih_constr)
     
      call mpi_scatter(cosphi_xave0_res1,ndih_constr,mpi_real,
     &      cosphi_xave0_res,ndih_constr,mpi_real,king,CG_COMM,ierr)

      cosphi_xave0(:ndih_constr)=cosphi_xave0_res(:ndih_constr)

      call mpi_scatter(sinphi_xave_res1,2*ndih_constr,mpi_real,
     &      sinphi_xave_res,2*ndih_constr,mpi_real,king,CG_COMM,ierr)

      sinphi_xave(:,:ndih_constr)=sinphi_xave_res(:,:ndih_constr)
     
      call mpi_scatter(sinphi_xave0_res1,ndih_constr,mpi_real,
     &      sinphi_xave0_res,ndih_constr,mpi_real,king,CG_COMM,ierr)

      sinphi_xave0(:ndih_constr)=sinphi_xave0_res(:ndih_constr)

      endif

      if (ntheta_constr.gt.0) then

      call mpi_scatter(theta_xave_res1,2*ntheta_constr,mpi_real,
     &      theta_xave_res,2*ntheta_constr,mpi_real,king,CG_COMM,ierr)

      theta_xave(:,:ntheta_constr)=theta_xave_res(:,:ntheta_constr)
     
      call mpi_scatter(theta_xave0_res1,ntheta_constr,mpi_real,
     &      theta_xave0_res,ntheta_constr,mpi_real,king,CG_COMM,ierr)

      theta_xave0(:ntheta_constr)=theta_xave0_res(:ntheta_constr)

      endif
!----------------------------------------------------------------------------


      if (usampl) then
        if (me.eq.king) then
#ifdef AIX
          call xdrfint_(ixdrf, nset, iret)
          do i=1,nset
            call xdrfint_(ixdrf,mset(i), iret)
          enddo
#else
          call xdrfint(ixdrf, nset, iret)
          do i=1,nset
            call xdrfint(ixdrf,mset(i), iret)
          enddo
#endif
          do i=0,nodes-1
            call xdrfint(ixdrf,i2set(i), iret)
          enddo
          do il=1,nset
            do il1=1,mset(il)
              do i=1,nrep
                do j=1,remd_m(i)
                  call xdrfint(ixdrf,itmp, iret)
                  i_index(i,j,il,il1)=itmp
                enddo
              enddo
            enddo
          enddo
        endif
Corrected AL 8/19/2014: each processor needs whole iset array not only its
c own element
c              call mpi_scatter(i2set,1,mpi_integer,
c     &           iset,1,mpi_integer,king,
c     &           CG_COMM,ierr)
        call mpi_bcast(i2set(0),nodes,mpi_integer,king,CG_COMM,ierr)
        iset=i2set(me)

      endif

      if (nfgtasks.gt.1) then
C
C Broadcast & scatter the restart information for time-average calculations
C to slave processors
C
#ifdef DEBUG
        write (iout,*) "read1rst: Processor",me," broadcast iorder"
        call flush(iout)
#endif
        call MPI_Bcast(iorder,1,MPI_INTEGER,king,FG_COMM,IERR)
#ifdef DEBUG
        write (iout,*) "read1rst: Processor",me,
     &  " calling nmr_ave_restart_Bscatter"
        call flush(iout)
#endif
        call nmr_ave_restart_Bscatter
#ifdef DEBUG
        write (iout,*) "read1rst: Processor",me,
     &  " exit nmr_ave_restart_Bscatter"
        call flush(iout)
#endif
      endif
#ifdef DEBUG
      write(iout,*)"read1rst processor",me," nsteps",nsteps(1:4),
     &  " icalls",icalls(1:4),"idiv_tau",idiv_tau," ionce",ionce,
     &  " atimeave",atimeave_save
      write (iout,*) "etimeave",etimeave
      write (iout,*) "tau_temp",tau_temp
      write (iout,*) "scal_force",scal_force
      do i=1,nhpb_peak
        write (iout,'(i5,3(f16.9,1x))') i,dnmr_xave(:,i),dnmr_xave0(i)
      enddo
      do i=1,ndih_constr
        write (iout,'(i5,6(f16.9,1x))') i,
     &          cosphi_xave(1,i),cosphi_xave(2,i),cosphi_xave0(i),
     &          sinphi_xave(1,i),sinphi_xave(2,i),sinphi_xave0(i)
      enddo
      do i=1,ntheta_constr
        write (iout,'(i5,3(f16.9,1x))') i,
     &          theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
      enddo
#endif
      if (me.eq.king) close(irest2)
      return
      end
!-------------------------------------------------------------------------------
      subroutine read1restart(i_index)
      implicit none
      include 'DIMENSIONS'
      include 'mpif.h'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
#ifdef FIVEDIAG
       include 'COMMON.LAGRANGE.5diag'
#else
       include 'COMMON.LAGRANGE'
#endif
      include 'COMMON.QRESTR'
      include 'COMMON.IOUNITS'
      include 'COMMON.REMD'
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.SBRIDGE'
      include 'COMMON.INTERACT'
      real d_restart1(3,2*maxres*max_cg_procs),r_d(3,0:2*maxres-1),
     &                 t5_restart1(5)
      integer*2 i_index(max_rep,max_remd_m,max_set,max_mult_set)
      common /przechowalnia/ d_restart1
      integer i,j,il,il1,ixdrf,iret,itmp
      integer ierr
      common /read1restartcommon/ r_d
c      write (*,*) "Processor",me," called read1restart"
         if(me.eq.king)then
              open(irest2,file=mremd_rst_name,status='unknown')
              read(irest2,*,err=334) i
              write(iout,*) "Reading old rst in ASCI format"
              close(irest2)
               call read1restart_old
               return
 334          continue
#ifdef AIX
              call xdrfopen_(ixdrf,mremd_rst_name, "r", iret)

              do i=0,nodes-1
               call xdrfint_(ixdrf, i2rep(i), iret)
              enddo
              do i=1,remd_m(1)
               call xdrfint_(ixdrf, ifirst(i), iret)
              enddo
             do il=1,nodes
              call xdrfint_(ixdrf, nupa(0,il), iret)
              do i=1,nupa(0,il)
               call xdrfint_(ixdrf, nupa(i,il), iret)
              enddo

              call xdrfint_(ixdrf, ndowna(0,il), iret)
              do i=1,ndowna(0,il)
               call xdrfint_(ixdrf, ndowna(i,il), iret)
              enddo
             enddo
             do il=1,nodes
               do j=1,4
                call xdrffloat_(ixdrf, t_restart1(j,il), iret)
               enddo
             enddo
#else
              call xdrfopen(ixdrf,mremd_rst_name, "r", iret)

              do i=0,nodes-1
               call xdrfint(ixdrf, i2rep(i), iret)
              enddo
              do i=1,remd_m(1)
               call xdrfint(ixdrf, ifirst(i), iret)
              enddo
             do il=1,nodes
              call xdrfint(ixdrf, nupa(0,il), iret)
              do i=1,nupa(0,il)
               call xdrfint(ixdrf, nupa(i,il), iret)
              enddo

              call xdrfint(ixdrf, ndowna(0,il), iret)
              do i=1,ndowna(0,il)
               call xdrfint(ixdrf, ndowna(i,il), iret)
              enddo
             enddo
             do il=1,nodes
               do j=1,4
                call xdrffloat(ixdrf, t_restart1(j,il), iret)
               enddo
             enddo
#endif
         endif
         call mpi_scatter(t_restart1,5,mpi_real,
     &           t5_restart1,5,mpi_real,king,CG_COMM,ierr)
         totT=t5_restart1(1)
         EK=t5_restart1(2)
         potE=t5_restart1(3)
         t_bath=t5_restart1(4)

         if(me.eq.king)then
              do il=0,nodes-1
               do i=1,2*nres
c                read(irest2,'(3e15.5)')
c     &                (d_restart1(j,i+2*nres*il),j=1,3)
            do j=1,3
#ifdef AIX
             call xdrffloat_(ixdrf, d_restart1(j,i+2*nres*il), iret)
#else
             call xdrffloat(ixdrf, d_restart1(j,i+2*nres*il), iret)
#endif
            enddo
               enddo
              enddo
         endif
         call mpi_scatter(d_restart1,3*2*nres,mpi_real,
     &           r_d,3*2*nres,mpi_real,king,CG_COMM,ierr)

         do i=0,2*nres-1
           do j=1,3
            d_t(j,i)=r_d(j,i)
           enddo
         enddo
         if(me.eq.king)then
              do il=0,nodes-1
               do i=1,2*nres
c                read(irest2,'(3e15.5)')
c     &                (d_restart1(j,i+2*nres*il),j=1,3)
            do j=1,3
#ifdef AIX
             call xdrffloat_(ixdrf, d_restart1(j,i+2*nres*il), iret)
#else
             call xdrffloat(ixdrf, d_restart1(j,i+2*nres*il), iret)
#endif
            enddo
               enddo
              enddo
         endif
         call mpi_scatter(d_restart1,3*2*nres,mpi_real,
     &           r_d,3*2*nres,mpi_real,king,CG_COMM,ierr)
         do i=0,2*nres-1
           do j=1,3
            dc(j,i)=r_d(j,i)
           enddo
         enddo


           if(usampl) then
#ifdef AIX
             if(me.eq.king)then
              call xdrfint_(ixdrf, nset, iret)
#ifdef AIX
             call xdrffloat_(ixdrf, d_restart1(j,i+2*nres*il), iret)
#else
             call xdrffloat(ixdrf, d_restart1(j,i+2*nres*il), iret)
#endif
            enddo
               enddo
              enddo
         endif
         call mpi_scatter(d_restart1,3*2*nres,mpi_real,
     &           r_d,3*2*nres,mpi_real,king,CG_COMM,ierr)
         do i=0,2*nres-1
           do j=1,3
            dc(j,i)=r_d(j,i)
           enddo
         enddo


           if(usampl) then              do i=1,nset
                call xdrfint_(ixdrf,mset(i), iret)
              enddo
              do i=0,nodes-1
                call xdrfint_(ixdrf,i2set(i), iret)
              enddo
              do il=1,nset
               do il1=1,mset(il)
                do i=1,nrep
                 do j=1,remd_m(i)
                   call xdrfint_(ixdrf,itmp, iret)
                   i_index(i,j,il,il1)=itmp
                 enddo
                enddo
               enddo
              enddo
             endif
#else
             if(me.eq.king)then
              call xdrfint(ixdrf, nset, iret)
              do i=1,nset
                call xdrfint(ixdrf,mset(i), iret)
              enddo
              do i=0,nodes-1
                call xdrfint(ixdrf,i2set(i), iret)
              enddo
              do il=1,nset
               do il1=1,mset(il)
                do i=1,nrep
                 do j=1,remd_m(i)
                   call xdrfint(ixdrf,itmp, iret)
                   i_index(i,j,il,il1)=itmp
                 enddo
                enddo
               enddo
              enddo
             endif
#endif
Corrected AL 8/19/2014: each processor needs whole iset array not only its
c own element
c              call mpi_scatter(i2set,1,mpi_integer,
c     &           iset,1,mpi_integer,king,
c     &           CG_COMM,ierr)
              call mpi_bcast(i2set(0),nodes,mpi_integer,king,
     &         CG_COMM,ierr)
              iset=i2set(me)

           endif


        if(me.eq.king) close(irest2)
        return
        end
c-------------------------------------------------------------------------------
      subroutine read1restart_old
      implicit none
      include 'DIMENSIONS'
      include 'mpif.h'
      include 'COMMON.MD'
#ifdef FIVEDIAG
       include 'COMMON.LAGRANGE.5diag'
#else
       include 'COMMON.LAGRANGE'
#endif
      include 'COMMON.IOUNITS'
      include 'COMMON.REMD'
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.SBRIDGE'
      include 'COMMON.INTERACT'
      real d_restart1(3,2*maxres*max_cg_procs),r_d(3,0:2*maxres-1),
     &                 t5_restart1(5)
      common /przechowalnia/ d_restart1
      integer i,j,il,itmp
      integer ierr
      common /read1restartoldcommon/ r_d

         if(me.eq.king)then
             open(irest2,file=mremd_rst_name,status='unknown')
             read (irest2,*) (i2rep(i),i=0,nodes-1)
             read (irest2,*) (ifirst(i),i=1,remd_m(1))
             do il=1,nodes
              read (irest2,*) nupa(0,il),(nupa(i,il),i=1,nupa(0,il))
              read (irest2,*) ndowna(0,il),
     &                    (ndowna(i,il),i=1,ndowna(0,il))
             enddo
             do il=1,nodes
               read(irest2,*) (t_restart1(j,il),j=1,4)
             enddo
         endif
         call mpi_scatter(t_restart1,5,mpi_real,
     &           t5_restart1,5,mpi_real,king,CG_COMM,ierr)
         totT=t5_restart1(1)
         EK=t5_restart1(2)
         potE=t5_restart1(3)
         t_bath=t5_restart1(4)

         if(me.eq.king)then
              do il=0,nodes-1
               do i=1,2*nres
                read(irest2,'(3e15.5)')
     &                (d_restart1(j,i+2*nres*il),j=1,3)
               enddo
              enddo
         endif
         call mpi_scatter(d_restart1,3*2*nres,mpi_real,
     &           r_d,3*2*nres,mpi_real,king,CG_COMM,ierr)

         do i=0,2*nres-1
           do j=1,3
            d_t(j,i)=r_d(j,i)
           enddo
         enddo
         if(me.eq.king)then
              do il=0,nodes-1
               do i=1,2*nres
                read(irest2,'(3e15.5)')
     &                (d_restart1(j,i+2*nres*il),j=1,3)
               enddo
              enddo
         endif
         call mpi_scatter(d_restart1,3*2*nres,mpi_real,
     &           r_d,3*2*nres,mpi_real,king,CG_COMM,ierr)
         do i=0,2*nres-1
           do j=1,3
            dc(j,i)=r_d(j,i)
           enddo
         enddo
        if(me.eq.king) close(irest2)
        return
        end
c-------------------------------------------------------------------------------
      subroutine nmr_ave_restart_Bscatter
      implicit none
      include 'DIMENSIONS'
      include 'mpif.h'
      integer ierror
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
      include 'COMMON.AVNLOC'
      include 'COMMON.RESTARTED'
      integer i,istart,iend
#ifdef SCATTER
      double precision buffer(2*maxdim_nmr),buffer2(2,maxdim_nmr)
      equivalence (buffer(1),buffer2(1,1)) 
#endif
c      write (iout,*) "nmr_ave_restart_Bscatter"
C
C Broadcast & scatter the restart information for time-average calculations
C to slave processors
C
      call MPI_Bcast(nsteps,4,MPI_INTEGER,king,FG_COMM,IERROR)
      call MPI_Bcast(icalls,4,MPI_INTEGER,king,FG_COMM,IERROR)
      call MPI_Bcast(idiv_tau,4,MPI_INTEGER,king,FG_COMM,IERROR)
      call MPI_Bcast(ionce,1,MPI_INTEGER,king,FG_COMM,IERROR)
      call MPI_Bcast(etimeave,3,MPI_DOUBLE_PRECISION,king,FG_COMM,
     & IERROR)
      call MPI_Bcast(tau_temp,4,MPI_DOUBLE_PRECISION,king,FG_COMM,
     & IERROR)
      call MPI_Bcast(scal_force,4,MPI_DOUBLE_PRECISION,king,FG_COMM,
     & IERROR)
#ifdef DEBUG
      write(iout,*)"inside nmr_ave_restart nsteps",nsteps(1:4),
     &" icalls",icalls(1:4),"idiv_tau",idiv_tau," ionce",ionce,
     &" atimeave",atimeave_save
      write (iout,*) "etimeave",etimeave
      write (iout,*) "tau_temp",tau_temp
      write (iout,*) "scal_force",scal_force
#endif
#ifdef SCATTER
c
c Scatter average distance restart info
c
      if (nhpb_peak.gt.0) then
      call MPI_Scatterv(dnmr_xave(1,1),icount_nmrave(0),
     & idispls_nmrave(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_nmrave(fg_rank),MPI_DOUBLE_PRECISION,king,FG_COMM,
     & IERROR)
      istart=idispls_nmraveave(fg_rank)+1
      iend=idispls_nmraveave(fg_rank)+icount_nmraveave(fg_rank)
c      write(iout,*)"dnmr scatter: istart",istart," iend",iend
      dnmr_xave(:,istart:iend)=buffer2(:,:icount_nmrave(fg_rank))
      call MPI_Scatterv(dnmr_xave0(1),icount_nmraveave(0),
     & idispls_nmraveave(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_nmraveave(fg_rank),MPI_DOUBLE_PRECISION,king,FG_COMM,
     & IERROR)
      dnmr_xave0(istart:iend)=buffer(:icount_nmraveave(fg_rank))
      call MPI_Scatterv(dnmr_xaveave(1),icount_nmraveave(0),
     & idispls_nmraveave(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_nmraveave(fg_rank),MPI_DOUBLE_PRECISION,king,FG_COMM,
     & IERROR)
      dnmr_xaveave(istart:iend)=buffer(:icount_nmraveave(fg_rank))
      endif
c
c Scatter average dihedral restart info
c
      if (ndih_constr.gt.0) then
      istart=idispls_dihconstr0(fg_rank)+1
      iend=idispls_dihconstr0(fg_rank)+icount_dihconstr0(fg_rank)
      call MPI_Scatterv(cosphi_xave(1,1),icount_dihconstr(0),
     & idispls_dihconstr(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_dihconstr(fg_rank),MPI_DOUBLE_PRECISION,king,
     & FG_COMM,IERROR)
      cosphi_xave(:,istart:iend)=buffer2(:,:icount_dihconstr(fg_rank))
      call MPI_Scatterv(sinphi_xave(1,1),icount_dihconstr(0),
     & idispls_dihconstr(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_dihconstr(fg_rank),MPI_DOUBLE_PRECISION,king,
     & FG_COMM,IERROR)
      sinphi_xave(:,istart:iend)=buffer2(:,:icount_dihconstr(fg_rank))
      call MPI_Scatterv(cosphi_xave0(1),icount_dihconstr0(0),
     & idispls_dihconstr0(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_dihconstr0(fg_rank),MPI_DOUBLE_PRECISION,king,
     & FG_COMM,IERROR)
      cosphi_xave0(istart:iend)=buffer(:icount_dihconstr0(fg_rank))
      call MPI_Scatterv(sinphi_xave0(1),icount_dihconstr0(0),
     & idispls_dihconstr0(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_dihconstr0(fg_rank),MPI_DOUBLE_PRECISION,king,
     & FG_COMM,IERROR)
      sinphi_xave0(istart:iend)=buffer(:icount_dihconstr0(fg_rank))
      endif
c
c Scatter average angle restart info
c
      if (ntheta_constr.gt.0) then
      istart=idispls_thetaconstr0(fg_rank)+1
      iend=idispls_thetaconstr0(fg_rank)+icount_thetaconstr0(fg_rank)
      call MPI_Scatterv(theta_xave(1,1),icount_thetaconstr(0),
     & idispls_thetaconstr(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_thetaconstr(fg_rank),MPI_DOUBLE_PRECISION,king,
     & FG_COMM,IERROR)
      theta_xave(:,istart:iend)=buffer2(:,:icount_thetaconstr(fg_rank))
      call MPI_Scatterv(theta_xave0(1),icount_thetaconstr0(0),
     & idispls_thetaconstr0(0),MPI_DOUBLE_PRECISION,buffer(1),
     & icount_thetaconstr0(fg_rank),MPI_DOUBLE_PRECISION,king,
     & FG_COMM,IERROR)
      theta_xave0(istart:iend)=buffer(:icount_thetaconstr0(fg_rank))
      endif
#else
c
c Broadcast average distance restart info
c
      if (nhpb_peak.gt.0) then
      call MPI_Bcast(dnmr_xave(1,1),2*nhpb_peak,MPI_DOUBLE_PRECISION,
     &  king,FG_COMM,IERROR)
      dnmr_xave(:,:ipeak(1,link_start_peak)-1)=0.0d0
      dnmr_xave(:,ipeak(2,link_end_peak)+1:)=0.0d0
      call MPI_Bcast(dnmr_xave0(1),nhpb_peak,MPI_DOUBLE_PRECISION,
     &  king,FG_COMM,IERROR)
      dnmr_xave0(:ipeak(1,link_start_peak)-1)=0.0d0
      dnmr_xave0(ipeak(2,link_end_peak)+1:)=0.0d0
      call MPI_Bcast(dnmr_xaveave(1),nhpb_peak,MPI_DOUBLE_PRECISION,
     &  king,FG_COMM,IERROR)
      dnmr_xaveave(:ipeak(1,link_start_peak)-1)=0.0d0
      dnmr_xaveave(ipeak(2,link_end_peak)+1:)=0.0d0
      endif
c
c Broadcast average dihedral restart info
c
      if (ndih_constr.gt.0) then
      call MPI_Bcast(cosphi_xave(1,1),2*ndih_constr,
     &  king,MPI_DOUBLE_PRECISION,FG_COMM,IERROR)
      cosphi_xave(:,:idihconstr_start-1)=0.0d0
      cosphi_xave(:,idihconstr_end+1:)=0.0d0
      call MPI_Bcast(cosphi_xave0(1),ndih_constr,MPI_DOUBLE_PRECISION,
     &  king,FG_COMM,IERROR)
      cosphi_xave0(:idihconstr_start-1)=0.0d0
      cosphi_xave0(idihconstr_end+1:)=0.0d0
      call MPI_Bcast(sinphi_xave(1,1),2*ndih_constr,
     &  king,MPI_DOUBLE_PRECISION,FG_COMM,IERROR)
      sinphi_xave(:,:idihconstr_start-1)=0.0d0
      sinphi_xave(:,idihconstr_end+1:)=0.0d0
      call MPI_Bcast(sinphi_xave0(1),ndih_constr,MPI_DOUBLE_PRECISION,
     &  king,FG_COMM,IERROR)
      sinphi_xave0(:idihconstr_start-1)=0.0d0
      sinphi_xave0(idihconstr_end+1:)=0.0d0
      endif
c
c Scatter average angle restart info
c
      if (ntheta_constr.gt.0) then
      call MPI_Bcast(theta_xave(1,1),2*ntheta_constr,
     &  king,MPI_DOUBLE_PRECISION,FG_COMM,IERROR)
      theta_xave(:,:ithetaconstr_start-1)=0.0d0
      theta_xave(:,ithetaconstr_end+1:)=0.0d0
      call MPI_Bcast(theta_xave0(1),ntheta_constr,MPI_DOUBLE_PRECISION,
     &  king,FG_COMM,IERROR)
      theta_xave0(:ithetaconstr_start-1)=0.0d0
      theta_xave0(ithetaconstr_end+1:)=0.0d0
      endif
#endif
#ifdef DEBUG
      do i=1,nhpb_peak
        write (iout,'(i5,3(f16.9,1x))') i,dnmr_xave(:,i),dnmr_xave0(i)
      enddo
      do i=1,ndih_constr
        write (iout,'(i5,6(f16.9,1x))') i,
     &        cosphi_xave(1,i),cosphi_xave(2,i),cosphi_xave0(i),
     &        sinphi_xave(1,i),sinphi_xave(2,i),sinphi_xave0(i)
      enddo
      do i=1,ntheta_constr
        write (iout,'(i5,3(f16.9,1x))') i,
     &        theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
      enddo
#endif
      return
      end
c-------------------------------------------------------------------------------
      subroutine nmr_ave_restart_gather
      implicit none
      include 'DIMENSIONS'
      include 'mpif.h'
      integer ierror
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
c      double precision buffer(600),buffer2(2,300)
      double precision buffer(2*maxdim_nmr),buffer2(2,maxdim_nmr)
      equivalence (buffer(1),buffer2(1,1)) 
      integer i,istart,iend
C
C Gather the restart information for time-averaged calculations from slave 
C processors
C
#ifdef DEBUG
      write (iout,*) "Before gather/reduce"
c      if (me.eq.king .or. .not.out1file) then
        do i=1,nhpb_peak
          write (iout,'(i5,3(f16.9,1x))') i,dnmr_xave(:,i),dnmr_xave0(i)
        enddo
        do i=1,ndih_constr
          write (iout,'(i5,6(f16.9,1x))') i,
     &          cosphi_xave(1,i),cosphi_xave(2,i),cosphi_xave0(i),
     &          sinphi_xave(1,i),sinphi_xave(2,i),sinphi_xave0(i)
        enddo
        do i=1,ntheta_constr
          write (iout,'(i5,3(f16.9,1x))') i,
     &          theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
        enddo
c      endif
#endif
#ifdef SCATTER
c
c Gather average distance restart info
c
      if (nhpb_peak.gt.0) then
      istart=idispls_nmraveave(fg_rank)+1
      iend=idispls_nmraveave(fg_rank)+icount_nmraveave(fg_rank)
      buffer2(:,:icount_nmraveave(fg_rank))=dnmr_xave(:,istart:iend)
      call MPI_Gatherv(buffer2(1,1),icount_nmrave(fg_rank),
     & MPI_DOUBLE_PRECISION,dnmr_xave(1,1),icount_nmrave(0),
     & idispls_nmrave(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      buffer(:icount_nmraveave(fg_rank))=dnmr_xave0(istart:iend)
      call MPI_Gatherv(buffer(1),icount_nmraveave(fg_rank),
     & MPI_DOUBLE_PRECISION,dnmr_xave0(1),icount_nmraveave(0),
     & idispls_nmraveave(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      buffer(:icount_nmraveave(fg_rank))=dnmr_xaveave(istart:iend)
      call MPI_Gatherv(buffer(1),icount_nmraveave(fg_rank),
     & MPI_DOUBLE_PRECISION,dnmr_xaveave(1),icount_nmraveave(0),
     & idispls_nmraveave(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      endif
c
c Gather average dihedral restart info
c
      if (ndih_constr.gt.0) then
      istart=idispls_dihconstr0(fg_rank)+1
      iend=idispls_dihconstr0(fg_rank)+icount_dihconstr0(fg_rank)
      buffer2(:,:icount_dihconstr0(fg_rank))=cosphi_xave(:,istart:iend)
      call MPI_Gatherv(buffer2(1,1),icount_dihconstr(fg_rank),
     & MPI_DOUBLE_PRECISION,cosphi_xave(1,1),icount_dihconstr(0),
     & idispls_dihconstr(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      buffer2(:,:icount_dihconstr0(fg_rank))=sinphi_xave(:,istart:iend)
      call MPI_Gatherv(buffer2(1,1),icount_dihconstr(fg_rank),
     & MPI_DOUBLE_PRECISION,sinphi_xave(1,1),icount_dihconstr(0),
     & idispls_dihconstr(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      buffer(:icount_dihconstr0(fg_rank))=cosphi_xave0(istart:iend)
      call MPI_Gatherv(buffer(1),icount_dihconstr0(fg_rank),
     & MPI_DOUBLE_PRECISION,cosphi_xave0(1),icount_dihconstr0(0),
     & idispls_dihconstr0(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      buffer(:icount_dihconstr0(fg_rank))=sinphi_xave0(istart:iend)
      call MPI_Gatherv(buffer(1),icount_dihconstr0(fg_rank),
     & MPI_DOUBLE_PRECISION,sinphi_xave0(1),icount_dihconstr0(0),
     & idispls_dihconstr0(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      endif
c
c Gather average angle restart info
c
      if (ntheta_constr.gt.0) then
      istart=idispls_thetaconstr0(fg_rank)+1
      iend=idispls_thetaconstr0(fg_rank)+icount_thetaconstr0(fg_rank)
      buffer2(:,:icount_thetaconstr0(fg_rank))=theta_xave(:,istart:iend)
      call MPI_Gatherv(buffer2(1,1),icount_thetaconstr(fg_rank),
     & MPI_DOUBLE_PRECISION,theta_xave(1,1),icount_thetaconstr(0),
     & idispls_thetaconstr(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      buffer(:icount_thetaconstr0(fg_rank))=theta_xave0(istart:iend)
      call MPI_Gatherv(buffer(1),icount_thetaconstr0(fg_rank),
     & MPI_DOUBLE_PRECISION,theta_xave0(1),icount_thetaconstr0(0),
     & idispls_thetaconstr0(0),MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
      endif
#else
c
c Zero average distance restart info of other processors
c
      if (nhpb_peak.gt.0) then
c      write (iout,*) "link_start_peak",link_start_peak,
c     & "link_end_peak",link_end_peak
c      write (iout,*) "zero until",ipeak(1,link_start_peak)-1,
c     & " zero from",ipeak(2,link_end_peak)+1
c        do i=1,nhpb_peak
c          write (iout,'(i5,3(f16.9,1x))') i,dnmr_xave(:,i),dnmr_xave0(i)
c        enddo
      dnmr_xave(:,:ipeak(1,link_start_peak)-1)=0.0d0
      dnmr_xave(:,ipeak(2,link_end_peak)+1:)=0.0d0
      dnmr_xave0(:ipeak(1,link_start_peak)-1)=0.0d0
      dnmr_xave0(ipeak(2,link_end_peak)+1:)=0.0d0
      dnmr_xaveave(:ipeak(1,link_start_peak)-1)=0.0d0
      dnmr_xaveave(ipeak(2,link_end_peak)+1:)=0.0d0
      endif
c
c Zero average dihedral restart info of other processors
c
      if (ndih_constr.gt.0) then
      cosphi_xave(:,:idihconstr_start-1)=0.0d0
      cosphi_xave(:,idihconstr_end+1:)=0.0d0
      cosphi_xave0(:idihconstr_start-1)=0.0d0
      cosphi_xave0(idihconstr_end+1:)=0.0d0
      sinphi_xave(:,:idihconstr_start-1)=0.0d0
      sinphi_xave(:,idihconstr_end+1:)=0.0d0
      sinphi_xave0(:idihconstr_start-1)=0.0d0
      sinphi_xave0(idihconstr_end+1:)=0.0d0
      endif
c
c Zero average angle restart info of other processors
c
      if (ntheta_constr.gt.0) then
      theta_xave(:,:ithetaconstr_start-1)=0.0d0
      theta_xave(:,ithetaconstr_end+1:)=0.0d0
      theta_xave0(:ithetaconstr_start-1)=0.0d0
      theta_xave0(ithetaconstr_end+1:)=0.0d0
      endif
c
c Gather average distance restart info
c
      if (nhpb_peak.gt.0) then
c      write (iout,*) "Before reducing dnmr_xave"
      call MPI_Reduce(dnmr_xave(1,1),buffer(1),2*nhpb_peak,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) dnmr_xave(:,:nhpb_peak)=buffer2(:,:nhpb_peak)
c      write (iout,*) "Before reducing dnmr_xave0"
      call MPI_Reduce(dnmr_xave0(1),buffer(1),nhpb_peak,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) dnmr_xave0(:nhpb_peak)=buffer(:nhpb_peak)
c      write (iout,*) "Before reducing dnmr_xaveave"
      call MPI_Reduce(dnmr_xaveave(1),buffer(1),nhpb_peak,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) dnmr_xaveave(:nhpb_peak)=buffer(:nhpb_peak)
      endif
c
c Gather average dihedral restart info
c
      if (ndih_constr.gt.0) then
      call MPI_Reduce(cosphi_xave(1,1),buffer(1),2*ndih_constr,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) cosphi_xave(:,:ndih_constr)=
     &  buffer2(:,:ndih_constr)
      call MPI_Reduce(cosphi_xave0(1),buffer(1),ndih_constr,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) cosphi_xave0(:ndih_constr)=
     &  buffer(:ndih_constr)
      call MPI_Reduce(sinphi_xave(1,1),buffer(1),2*ndih_constr,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) sinphi_xave(:,:ndih_constr)=
     &  buffer2(:,:ndih_constr)
      call MPI_Reduce(sinphi_xave0(1),buffer(1),ndih_constr,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) sinphi_xave0(:ndih_constr)=
     &  buffer(:ndih_constr)
      endif
c
c Gather average angle restart info
c
      if (ntheta_constr.gt.0) then
      call MPI_Reduce(theta_xave(1,1),buffer(1),2*ntheta_constr,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) theta_xave(:,:ntheta_constr)=
     &  buffer2(:,:ntheta_constr)
      call MPI_Reduce(theta_xave0(1),buffer(1),ntheta_constr,
     &  MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERROR)
      if (fg_rank.eq.king) theta_xave0(:ntheta_constr)=
     &  buffer(:ntheta_constr)
      endif
#endif
#ifdef DEBUG
      write (iout,*) "After gather/reduce"
      if (me.eq.king .or. .not.out1file) then
        do i=1,nhpb_peak
          write (iout,'(i5,3(f16.9,1x))') i,dnmr_xave(:,i),dnmr_xave0(i)
        enddo
        do i=1,ndih_constr
          write (iout,'(i5,6(f16.9,1x))') i,
     &          cosphi_xave(1,i),cosphi_xave(2,i),cosphi_xave0(i),
     &          sinphi_xave(1,i),sinphi_xave(2,i),sinphi_xave0(i)
        enddo
        do i=1,ntheta_constr
          write (iout,'(i5,3(f16.9,1x))') i,
     &          theta_xave(1,i),theta_xave(2,i),theta_xave0(i)
        enddo
      endif
#endif
      return
      end
#endif
