      subroutine read_dist_constr
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.SETUP'
      include 'COMMON.CONTROL'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      integer i,j,k,ii,jj,itemp,link_type,iiend,jjend,kk,itypi,itypj
      integer nfrag_,npair_,ndist_,ifrag_(2,100),ipair_(2,1000)
      double precision wfrag_(100),wpair_(1000)
      double precision ddjk,dist,dist_cut,fordepthmax
      double precision fordepth_peak_,forcon_peak_,protdist_min,
     &  linpeak_lo,linpeak_up
      character*5000 controlcard
      character*3 att1,att2
      character*4 linkname
      logical normalize,next
      logical protcheck
      integer findxlink
      integer restr_type
      double precision scal_bfac
      integer nnpeak,npeak_prev
      double precision xlink(4,0:4) /
c           a          b       c     sigma
     &   0.0d0,0.0d0,0.0d0,0.0d0,                             ! default, no xlink potential
     &   0.00305218d0,9.46638d0,4.68901d0,4.74347d0,          ! ZL
     &   0.00214928d0,12.7517d0,0.00375009d0,6.13477d0,       ! ADH
     &   0.00184547d0,11.2678d0,0.00140292d0,7.00868d0,       ! PDH
     &   0.000161786d0,6.29273d0,4.40993d0,7.13956d0    /     ! DSS
c      print *, "WCHODZE" 
      integer ilen
      external ilen
      write (iout,*) "Calling read_dist_constr"
      do i=0,4
        xlink(2,i)=4*xlink(2,i)
      enddo
c      write (iout,*) "nres",nres," nstart_sup",nstart_sup," nsup",nsup
c      call flush(iout)
      restr_on_coord=.false.
      next=.true.

      npeak=0
      ipeak=0
      nhpb_peak=0
 
      DO WHILE (next)

      call card_concat(controlcard)
      next = index(controlcard,"NEXT").gt.0
      call readi(controlcard,"RESTR_TYPE",restr_type,constr_dist)
      write (iout,*) "restr_type",restr_type
      if (restr_type.eq.10) 
     &  call reada(controlcard,'WBOLTZD',wboltzd,0.591d0)
      if (restr_type.eq.12) then
        call reada(controlcard,'SCAL_PEAK',scal_peak,5.0d0)
        call reada(controlcard,'SLOPE_PEAK',slope_peak,0.0d0)
        call reada(controlcard,'FORDEPTH_PEAK',fordepth_peak_,2.0d0)
        call reada(controlcard,'FORCON_PEAK',forcon_peak_,1.0d0)
        call reada(controlcard,'PROTDIST_MIN',protdist_min,2.0d0)
        call reada(controlcard,'LINPEAK_LO',linpeak_lo,0.0d0)
        call reada(controlcard,'LINPEAK_UP',linpeak_up,2.0d0)
        write (iout,*) "SCAL_PEAK",scal_peak
        write (iout,*) "PEAK RESTRAINT SLOPE",slope_peak
        write (iout,*) "PEAK WELL DEPTH",fordepth_peak_
        write (iout,*) "PEAK WELL THICKNESS",forcon_peak_
        write (iout,*) "PROTDIST_MIN",protdist_min
        write (iout,*) "LINPEAK_LO",linpeak_lo
        write (iout,*) "LINPEAK_UP",linpeak_up
      else
        call reada(controlcard,'SLOPE',slope,0.0d0)
        write (iout,*) "RESTRAINT SLOPE",slope
      endif
      call readi(controlcard,"NFRAG",nfrag_,0)
      call readi(controlcard,"NPAIR",npair_,0)
      call readi(controlcard,"NDIST",ndist_,0)
      call reada(controlcard,'DIST_CUT',dist_cut,5.0d0)
      call reada(controlcard,'SCAL_BFAC',scal_bfac,1.0d0)
      call multreadi(controlcard,"IFRAG",ifrag_(1,1),2*nfrag_,0)
      call multreadi(controlcard,"IPAIR",ipair_(1,1),2*npair_,0)
      call multreada(controlcard,"WFRAG",wfrag_(1),nfrag_,0.0d0)
      call multreada(controlcard,"WPAIR",wpair_(1),npair_,0.0d0)
      normalize = index(controlcard,"NORMALIZE").gt.0
      if (restr_type.eq.10) write (iout,*) "WBOLTZD",wboltzd
      write (iout,*) "NFRAG",nfrag_," NPAIR",npair_," NDIST",ndist_
      write (iout,*) "IFRAG"
      do i=1,nfrag_
        write (iout,*) i,ifrag_(1,i),ifrag_(2,i),wfrag_(i)
      enddo
      write (iout,*) "IPAIR"
      do i=1,npair_
        write (iout,*) i,ipair_(1,i),ipair_(2,i),wpair_(i)
      enddo
      if (nfrag_.gt.0 .or. restr_type.eq.4 .or. restr_type.eq.5) 
     & write (iout,*) 
     &   "Distance restraints as generated from reference structure"
      do i=1,nfrag_
        if (ifrag_(1,i).lt.nstart_sup) ifrag_(1,i)=nstart_sup
        if (ifrag_(2,i).gt.nstart_sup+nsup-1)
     &    ifrag_(2,i)=nstart_sup+nsup-1
c        write (iout,*) i,ifrag_(1,i),ifrag_(2,i),wfrag_(i)
c        call flush(iout)
        if (wfrag_(i).eq.0.0d0) cycle
        do j=ifrag_(1,i),ifrag_(2,i)-1
          do k=j+1,ifrag_(2,i)
c            write (iout,*) "j",j," k",k
            ddjk=dist(j,k)
            if (restr_type.eq.1) then
              nhpb=nhpb+1
              irestr_type(nhpb)=1
              ihpb(nhpb)=j
              jhpb(nhpb)=k
              dhpb(nhpb)=ddjk
              forcon(nhpb)=wfrag_(i) 
            else if (constr_dist.eq.2) then
              if (ddjk.le.dist_cut) then
                nhpb=nhpb+1
                irestr_type(nhpb)=1
                ihpb(nhpb)=j
                jhpb(nhpb)=k
                dhpb(nhpb)=ddjk
                forcon(nhpb)=wfrag_(i) 
              endif
            else if (restr_type.eq.3) then
              nhpb=nhpb+1
              irestr_type(nhpb)=1
              ihpb(nhpb)=j
              jhpb(nhpb)=k
              dhpb(nhpb)=ddjk
              forcon(nhpb)=wfrag_(i)*dexp(-0.5d0*(ddjk/dist_cut)**2)
            endif
#ifdef MPI
            if (.not.out1file .or. me.eq.king) 
     &      write (iout,'(a,3i5,f8.2,1pe12.2)') "+dist.restr ",
     &       nhpb,ihpb(nhpb),jhpb(nhpb),dhpb(nhpb),forcon(nhpb)
#else
            write (iout,'(a,3i5,f8.2,1pe12.2)') "+dist.restr ",
     &       nhpb,ihpb(nhpb),jhpb(nhpb),dhpb(nhpb),forcon(nhpb)
#endif
          enddo
        enddo
      enddo
      do i=1,npair_
        if (wpair_(i).eq.0.0d0) cycle
        ii = ipair_(1,i)
        jj = ipair_(2,i)
        if (ii.gt.jj) then
          itemp=ii
          ii=jj
          jj=itemp
        endif
        do j=ifrag_(1,ii),ifrag_(2,ii)
          do k=ifrag_(1,jj),ifrag_(2,jj)
            ddjk=dist(j,k)
            if (restr_type.eq.1) then
              nhpb=nhpb+1
              irestr_type(nhpb)=1
              ihpb(nhpb)=j
              jhpb(nhpb)=k
              dhpb(nhpb)=ddjk
              forcon(nhpb)=wpair_(i) 
            else if (constr_dist.eq.2) then
              if (ddjk.le.dist_cut) then
                nhpb=nhpb+1
                irestr_type(nhpb)=1
                ihpb(nhpb)=j
                jhpb(nhpb)=k
                dhpb(nhpb)=ddjk
                forcon(nhpb)=wpair_(i) 
              endif
            else if (restr_type.eq.3) then
              nhpb=nhpb+1
              irestr_type(nhpb)=1
              ihpb(nhpb)=j
              jhpb(nhpb)=k
              dhpb(nhpb)=ddjk
              forcon(nhpb)=wpair_(i)*dexp(-0.5d0*(ddjk/dist_cut)**2)
            endif
#ifdef MPI
            if (.not.out1file .or. me.eq.king)
     &      write (iout,'(a,3i5,f8.2,1pe12.2)') "+dist.restr ",
     &       nhpb,ihpb(nhpb),jhpb(nhpb),dhpb(nhpb),forcon(nhpb)
#else
            write (iout,'(a,3i5,f8.2,1pe12.2)') "+dist.restr ",
     &       nhpb,ihpb(nhpb),jhpb(nhpb),dhpb(nhpb),forcon(nhpb)
#endif
          enddo
        enddo
      enddo 

c      print *,ndist_
      write (iout,*) "Distance restraints as read from input"
      npeak=0
      npeak_prev=0
      ii=0
      do i=1,ndist_
c       for NMR restraints
        if (restr_type.eq.12) then
c          read (inp,*) hpb_peak(1,nhpb_peak+1),hpb_peak(2,nhpb_peak+1),
c     &    npeak,hpb_peak(5,nhpb_peak+1),att1,att2
         read (inp,*) ihpb_peak(1,nhpb_peak+1),jhpb_peak(1,nhpb_peak+1),
     &    nnpeak,dhpb1_peak(nhpb_peak+1),att1,att2
c 6/12/2020 Adam: Remove restraints within same residue
         if (ihpb_peak(1,nhpb_peak+1).eq.jhpb_peak(1,nhpb_peak+1)) cycle
         ii=ii+1
         if (nnpeak.ne.npeak_prev) then
           npeak=npeak+1
           num_peak(npeak)=nnpeak
           npeak_prev=nnpeak
         endif
cc          write(iout,*) ihpb_peak(nhpb_peak+1),jhpb_peak(nhpb_peak+1),
cc     &    dhpb_peak(nhpb_peak+1),dhpb1_peak(nhpb_peak+1),
cc     &    ibecarb_peak(nhpb_peak+1),forcon_peak(nhpb_peak+1),
cc     &    fordepth_peak(nhpb_peak+1),npeak
c          dhpb_peak(nhpb_peak+1)=2.0d0
          if (dhpb1_peak(nhpb_peak+1).lt.0.0d0) then
            dhpb_peak(nhpb_peak+1)=-dhpb1_peak(nhpb_peak+1)
            dhpb1_peak(nhpb_peak+1)=50.0d0
            fordepth_peak(nhpb_peak+1)=fordepth_peak_
          else
            dhpb_peak(nhpb_peak+1)=protdist_min
            fordepth_peak(nhpb_peak+1)=fordepth_peak_
          endif
          forcon_peak(nhpb_peak+1)=forcon_peak_
          dhpb2_peak(nhpb_peak+1)=dhpb_peak(nhpb_peak+1)-linpeak_lo
          dhpb3_peak(nhpb_peak+1)=dhpb1_peak(nhpb_peak+1)+linpeak_up
c          forcon_peak(nhpb_peak+1)=1.0d0
c          fordepth_peak(nhpb_peak+1)=2.0d0
          ihpb_peak(2,nhpb_peak+1)=maxnmrType+1
          if (att1.eq.'H') ihpb_peak(2,nhpb_peak+1)=0
          if (att1.eq.'HA' .or. att1.eq.'QA' .or. att1.eq.'HA2' .or.
     &        att1.eq.'HA3') ihpb_peak(2,nhpb_peak+1)=1
          if (att1.eq.'HB1' .or. att1.eq.'HB2' .or. att1.eq.'HB3' .or.
     &        att1.eq.'QB' .or. att1.eq.'HB') ihpb_peak(2,nhpb_peak+1)=2
          if (att1.eq.'HG1' .or. att1.eq.'HG2' .or. att1.eq.'HG3' .or.
     &        att1.eq.'QG' .or. att1.eq.'HG') ihpb_peak(2,nhpb_peak+1)=3
          if (att1.eq.'HD1' .or. att1.eq.'HD2' .or. att1.eq.'HD3' .or.
     &        att1.eq.'QD' .or. att1.eq.'HD') ihpb_peak(2,nhpb_peak+1)=4
          if (att1.eq.'HE1' .or. att1.eq.'HE2' .or. att1.eq.'HE3' .or.
     &        att1.eq.'QE' .or. att1.eq.'HE') ihpb_peak(2,nhpb_peak+1)=5
          if (att1.eq.'HZ1' .or. att1.eq.'HZ2' .or. att1.eq.'HZ3' .or.
     &        att1.eq.'QZ' .or. att1.eq.'HZ') ihpb_peak(2,nhpb_peak+1)=6
          if (att1.eq.'HH1' .or. att1.eq.'HH2' .or. att1.eq.'HH3' .or.
     &        att1.eq.'QH' .or. att1.eq.'HH') ihpb_peak(2,nhpb_peak+1)=7

          jhpb_peak(2,nhpb_peak+1)=maxnmrType+1
          if (att2.eq.'H') jhpb_peak(2,nhpb_peak+1)=0
          if (att2.eq.'HA' .or. att2.eq.'QA' .or. att2.eq.'HA2' .or.
     &        att2.eq.'HA3') jhpb_peak(2,nhpb_peak+1)=1
          if (att2.eq.'HB1' .or. att2.eq.'HB2' .or. att2.eq.'HB3' .or.
     &        att2.eq.'QB' .or. att2.eq.'HB') jhpb_peak(2,nhpb_peak+1)=2
          if (att2.eq.'HG1' .or. att2.eq.'HG2' .or. att2.eq.'HG3' .or.
     &        att2.eq.'QG' .or. att2.eq.'HG') jhpb_peak(2,nhpb_peak+1)=3
          if (att2.eq.'HD1' .or. att2.eq.'HD2' .or. att2.eq.'HD3' .or.
     &        att2.eq.'QD' .or. att2.eq.'HD') jhpb_peak(2,nhpb_peak+1)=4
          if (att2.eq.'HE1' .or. att2.eq.'HE2' .or. att2.eq.'HE3' .or.
     &        att2.eq.'QE' .or. att2.eq.'HE') jhpb_peak(2,nhpb_peak+1)=5
          if (att2.eq.'HZ1' .or. att2.eq.'HZ2' .or. att2.eq.'HZ3' .or.
     &        att2.eq.'QZ' .or. att2.eq.'HZ') jhpb_peak(2,nhpb_peak+1)=6
          if (att2.eq.'HH1' .or. att2.eq.'HH2' .or. att2.eq.'HH3' .or.
     &        att2.eq.'QH' .or. att2.eq.'HH') jhpb_peak(2,nhpb_peak+1)=7

          if (ihpb_peak(1,nhpb_peak+1).le.0.0d0.or.
     &        jhpb_peak(1,nhpb_peak+1).le.0.0d0)cycle
c          if (forcon_peak(nhpb_peak+1).le.0.0d0.or.
c     &      fordepth_peak(nhpb_peak+1).le.0.0d0)cycle
          nhpb_peak=nhpb_peak+1
          irestr_type_peak(nhpb_peak)=12
          if (ipeak(1,npeak).eq.0) ipeak(1,npeak)=ii
          ipeak(2,npeak)=ii
          if (nnt.gt.1) then
            if (ihpb_peak(2,nhpb_peak).gt.0) 
     &         ihpb_peak(1,nhpb_peak)=ihpb_peak(1,nhpb_peak)+nnt-1
            if (jhpb_peak(2,nhpb_peak).gt.0) 
     &         jhpb_peak(1,nhpb_peak)=jhpb_peak(1,nhpb_peak)+nnt-1
          endif
          proton1(nhpb_peak)=att1
          proton2(nhpb_peak)=att2
#ifdef MPI
          if (.not.out1file .or. me.eq.king)
     &    write (iout,'(a,4i5,f5.1,2i5,2a5)') "+dist.restr ",
     &     nhpb_peak,ihpb_peak(1,nhpb_peak),jhpb_peak(1,nhpb_peak),
     &     npeak,dhpb1_peak(nhpb_peak),ihpb_peak(2,nhpb_peak),
     &     jhpb_peak(2,nhpb_peak),att1,att2
#else
          write (iout,'(a,4i5,f5.1,2i5,2a5)') "+dist.restr ",
     &     nhpb_peak,ihpb_peak(1,nhpb_peak),jhpb_peak(1,nhpb_peak),
     &     npeak,dhpb1_peak(nhpb_peak),ihpb_peak(2,nhpb_peak),
     &     jhpb_peak(2,nhpb_peak),att1,att2
#endif
          if (.not.protcheck(ihpb_peak(1,nhpb_peak),
     &         ihpb_peak(2,nhpb_peak)) ) stop 
          if (.not.protcheck(jhpb_peak(1,nhpb_peak),
     &         jhpb_peak(2,nhpb_peak)) ) stop 
c#ifdef MPI
c          if (.not.out1file .or. me.eq.king)
c     &    write (iout,'(a,5i5,2f8.2,2f10.5,i5)') "+dist.restr ",
c     &     nhpb_peak,ihpb_peak(nhpb_peak),jhpb_peak(nhpb_peak),
c     &     ibecarb_peak(nhpb_peak),npeak,dhpb_peak(nhpb_peak),
c     &     dhpb1_peak(nhpb_peak),forcon_peak(nhpb_peak),
c     &     fordepth_peak(nhpb_peak),irestr_type_peak(nhpb_peak)
c#else
c          write (iout,'(a,5i5,2f8.2,2f10.5,i5)') "+dist.restr ",
c     &     nhpb_peak,ihpb_peak(nhpb_peak),jhpb_peak(nhpb_peak),
c     &     ibecarb_peak(nhpb_peak),npeak,dhpb_peak(nhpb_peak),
c     &     dhpb1_peak(nhpb_peak),forcon_peak(nhpb_peak),
c     &     fordepth_peak(nhpb_peak),irestr_type_peak(nhpb_peak)
c#endif
c          if (ibecarb_peak(nhpb_peak).eq.3) then
c            jhpb_peak(nhpb_peak)=jhpb_peak(nhpb_peak)+nres
c          else if (ibecarb_peak(nhpb_peak).eq.2) then
c            ihpb_peak(nhpb_peak)=ihpb_peak(nhpb_peak)+nres
c          else if (ibecarb_peak(nhpb_peak).eq.1) then
c            ihpb_peak(nhpb_peak)=ihpb_peak(nhpb_peak)+nres
c            jhpb_peak(nhpb_peak)=jhpb_peak(nhpb_peak)+nres
c          endif

        else if (restr_type.eq.11) then
          read (inp,*) ihpb(nhpb+1),jhpb(nhpb+1),dhpb(nhpb+1),
     &     dhpb1(nhpb+1),ibecarb(nhpb+1),forcon(nhpb+1),fordepth(nhpb+1)
c        fordepth(nhpb+1)=fordepth(nhpb+1)/forcon(nhpb+1)
          if (forcon(nhpb+1).le.0.0d0.or.fordepth(nhpb+1).le.0.0d0)cycle
          nhpb=nhpb+1
          irestr_type(nhpb)=11
#ifdef MPI
          if (.not.out1file .or. me.eq.king)
     &    write (iout,'(a,4i5,2f8.2,2f10.5,i5)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),dhpb(nhpb),
     &     dhpb1(nhpb),forcon(nhpb),fordepth(nhpb),irestr_type(nhpb)
#else
          write (iout,'(a,4i5,2f8.2,2f10.5,i5)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),dhpb(nhpb),
     &     dhpb1(nhpb),forcon(nhpb),fordepth(nhpb),irestr_type(nhpb)
#endif
c          if (ibecarb(nhpb).gt.0) then
c            ihpb(nhpb)=ihpb(nhpb)+nres
c            jhpb(nhpb)=jhpb(nhpb)+nres
c          endif
         if (ibecarb(nhpb).eq.3) then
            ihpb(nhpb)=ihpb(nhpb)+nres
          else if (ibecarb(nhpb).eq.2) then
            ihpb(nhpb)=ihpb(nhpb)+nres
          else if (ibecarb(nhpb).eq.1) then
            ihpb(nhpb)=ihpb(nhpb)+nres
            jhpb(nhpb)=jhpb(nhpb)+nres
          endif
        else if (restr_type.eq.10) then
c Cross-lonk Markov-like potential
          call card_concat(controlcard)
          call readi(controlcard,"ILINK",ihpb(nhpb+1),0)
          call readi(controlcard,"JLINK",jhpb(nhpb+1),0)
          ibecarb(nhpb+1)=0
          if (index(controlcard,"BETA").gt.0) ibecarb(nhpb+1)=1
          if (ihpb(nhpb+1).eq.0 .or. jhpb(nhpb+1).eq.0) cycle
          if (index(controlcard,"ZL").gt.0) then
            link_type=1
          else if (index(controlcard,"ADH").gt.0) then
            link_type=2
          else if (index(controlcard,"PDH").gt.0) then
            link_type=3
          else if (index(controlcard,"DSS").gt.0) then
            link_type=4
          else
            link_type=0
          endif
          call reada(controlcard,"AXLINK",dhpb(nhpb+1),
     &       xlink(1,link_type))
          call reada(controlcard,"BXLINK",dhpb1(nhpb+1),
     &       xlink(2,link_type))
          call reada(controlcard,"CXLINK",fordepth(nhpb+1),
     &       xlink(3,link_type))
          call reada(controlcard,"SIGMA",forcon(nhpb+1),
     &       xlink(4,link_type))
          call reada(controlcard,"SCORE",xlscore(nhpb+1),1.0d0)
c          read (inp,*) ihpb(nhpb+1),jhpb(nhpb+1),ibecarb(nhpb+1),
c     &      dhpb(nhpb+1),dhpb1(nhpb+1),forcon(nhpb+1),fordepth(nhpb+1)
          if (forcon(nhpb+1).le.0.0d0 .or. 
     &       (dhpb(nhpb+1).eq.0 .and. dhpb1(nhpb+1).eq.0)) cycle
          nhpb=nhpb+1
          irestr_type(nhpb)=10
          if (ibecarb(nhpb).eq.3) then
            jhpb(nhpb)=jhpb(nhpb)+nres
          else if (ibecarb(nhpb).eq.2) then
            ihpb(nhpb)=ihpb(nhpb)+nres
          else if (ibecarb(nhpb).eq.1) then
            ihpb(nhpb)=ihpb(nhpb)+nres
            jhpb(nhpb)=jhpb(nhpb)+nres
          endif
#ifdef MPI
          if (.not.out1file .or. me.eq.king)
     &    write (iout,'(a,4i5,2f8.2,3f10.5,i5)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),dhpb(nhpb),
     &     dhpb1(nhpb),forcon(nhpb),fordepth(nhpb),xlscore(nhpb),
     &     irestr_type(nhpb)
#else
          write (iout,'(a,4i5,2f8.2,3f10.5,i5)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),dhpb(nhpb),
     &     dhpb1(nhpb),forcon(nhpb),fordepth(nhpb),xlscore(nhpb),
     &     irestr_type(nhpb)
#endif
        else if (restr_type.eq.13) then
c Cross-lonk Markov-like potential
          call card_concat(controlcard)
          write (iout,*) controlcard(:ilen(controlcard))
          call readi(controlcard,"ILINK",ihpb(nhpb+1),0)
          call readi(controlcard,"JLINK",jhpb(nhpb+1),0)
          call reads(controlcard,"BRIDGE",linkname," ")
          nhpb=nhpb+1
          irestr_type(nhpb)=13
          itypi=itype(ihpb(nhpb))
          itypj=itype(jhpb(nhpb))
          ibecarb(nhpb)=findxlink(iabs(itypi),iabs(itypj),linkname)
          write (iout,*) "link",itypi,itypj,ibecarb(nhpb),linkname
          if (ibecarb(nhpb).eq.0) then
            write (iout,'(a,2(1x,a4,i7),1x,a4)') 
     &      "ERROR! Wrong cross link ",
     &      restyp(itypi),ihpb(nhpb),restyp(itypj),jhpb(nhpb),linkname
            stop
          endif
#ifdef MPI
          if (.not.out1file .or. me.eq.king)
     &    write (iout,'(a,4i5,1x,a5,i5)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),linkname,
     &     irestr_type(nhpb)
#else
          write (iout,'(a,4i5,1x,a5,i5)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),linkname,
     &     irestr_type(nhpb)
#endif
        else
C        print *,"in else"
          read (inp,*) ihpb(nhpb+1),jhpb(nhpb+1),dhpb(nhpb+1),
     &     dhpb1(nhpb+1),ibecarb(nhpb+1),forcon(nhpb+1)
          if (forcon(nhpb+1).gt.0.0d0) then
          nhpb=nhpb+1
          if (dhpb1(nhpb).eq.0.0d0) then
            irestr_type(nhpb)=1
          else
            irestr_type(nhpb)=2
          endif
          if (ibecarb(nhpb).eq.3) then
            jhpb(nhpb)=jhpb(nhpb)+nres
          else if (ibecarb(nhpb).eq.2) then
            ihpb(nhpb)=ihpb(nhpb)+nres
          else if (ibecarb(nhpb).eq.1) then
            ihpb(nhpb)=ihpb(nhpb)+nres
            jhpb(nhpb)=jhpb(nhpb)+nres
          endif
          if (dhpb(nhpb).eq.0.0d0)
     &       dhpb(nhpb)=dist(ihpb(nhpb),jhpb(nhpb))
        endif
#ifdef MPI
          if (.not.out1file .or. me.eq.king)
     &    write (iout,'(a,4i5,f8.2,f10.1)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(i),dhpb(nhpb),forcon(nhpb)
#else
          write (iout,'(a,4i5,f8.2,f10.1)') "+dist.restr ",
     &     nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(i),dhpb(nhpb),forcon(nhpb)
#endif
        endif
C        read (inp,*) ihpb(nhpb+1),jhpb(nhpb+1),forcon(nhpb+1)
C        if (forcon(nhpb+1).gt.0.0d0) then
C          nhpb=nhpb+1
C          dhpb(nhpb)=dist(ihpb(nhpb),jhpb(nhpb))
      enddo

      if (restr_type.eq.4) then
        write (iout,*) "The BFAC array"
        do i=nnt,nct
          write (iout,'(i5,f10.5)') i,bfac(i)
        enddo
        do i=nnt,nct
          if (itype(i).eq.ntyp1) cycle
          do j=nnt,i-1
            if (itype(j).eq.ntyp1) cycle
            if (itype(i).eq.10) then 
              iiend=0
            else
              iiend=1
            endif
            if (itype(j).eq.10) then 
              jjend=0
            else
              jjend=1
            endif
            kk=0
            do ii=0,iiend
            do jj=0,jjend
            nhpb=nhpb+1
            irestr_type(nhpb)=1
            forcon(nhpb)=scal_bfac**2/(bfac(i)**2+bfac(j)**2)
            irestr_type(nhpb)=1
            ibecarb(nhpb)=kk
            if (ibecarb(nhpb).gt.0) ibecarb(nhpb)=4-ibecarb(nhpb)
            ihpb(nhpb)=i+nres*ii
            jhpb(nhpb)=j+nres*jj
            dhpb(nhpb)=dist(i+nres*ii,j+nres*jj)
#ifdef MPI
            if (.not.out1file .or. me.eq.king) then
            write (iout,'(a,4i5,2f8.2,3f10.5,i5)') "+dist.restr ",
     &       nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),dhpb(nhpb),
     &       dhpb1(nhpb),forcon(nhpb),fordepth(nhpb),xlscore(nhpb),
     &       irestr_type(nhpb)
            endif
#else
            write (iout,'(a,4i5,2f8.2,3f10.5,i5)') "+dist.restr ",
     &       nhpb,ihpb(nhpb),jhpb(nhpb),ibecarb(nhpb),dhpb(nhpb),
     &       dhpb1(nhpb),forcon(nhpb),fordepth(nhpb),xlscore(nhpb),
     &       irestr_type(nhpb)
#endif
            kk=kk+1
          enddo
          enddo
          enddo
        enddo
      endif

      if (restr_type.eq.5) then
        restr_on_coord=.true.
        do i=nnt,nct
          if (itype(i).eq.ntyp1) cycle
          bfac(i)=(scal_bfac/bfac(i))**2
        enddo
      endif

      ENDDO ! next

      fordepthmax=0.0d0
      if (normalize) then
        do i=nss+1,nhpb
          if (irestr_type(i).eq.11.and.fordepth(i).gt.fordepthmax) 
     &      fordepthmax=fordepth(i)
        enddo
        do i=nss+1,nhpb
          if (irestr_type(i).eq.11) fordepth(i)=fordepth(i)/fordepthmax
        enddo
      endif
      return
      end
c-------------------------------------------------------------------------------
      logical function protcheck(ires,iproton)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.NMR'
      include 'COMMON.INTERACT'
      integer ires,iproton
c      write (iout,*) "protcheck",ires,iproton
c      call flush(iout)
      if (itype(ires).eq.ntyp1) then
        write (iout,*) "Dummy residue",restyp(itype(ires)),ires,
     &    " does not have protons."
        protcheck=.false.
      else if (iproton.gt.nproton(iabs(itype(ires))) 
     &  .or. iproton.gt.2.and.protpos(iproton,iabs(itype(ires)))
     &    .eq.0.0d0) then
         write (iout,*) "Residue ",restyp(itype(ires)),ires,
     &   " does not have ",proton(iproton)
         write (*,*) "Residue ",restyp(itype(ires)),ires,
     &   " does not have ",proton(iproton)
        protcheck=.false.
      else
        protcheck=.true.
      endif
      return
      end
c-------------------------------------------------------------------------------
      integer function findxlink(itypi,itypj,linknam)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.XLINKS'
      integer itypi,itypj,k
      character*4 linknam
      do k=1,nxlinks
        if (itypi.eq.ixlink(1,k).and.itypj.eq.ixlink(2,k)
     &      .and.linknam.eq.namlink(k)) then
          findxlink=k 
          return
        endif
      enddo
      findxlink=0
      return
      end
