      subroutine place_coords_in_box
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      integer i,j
      double precision pos(3)

!$OMP PARALLEL DO DEFAULT(SHARED) PRIVATE(pos)
      do i=1,nres-1
        call to_box2(c(:,i),c_tobox(:,i))
        pos=0.5d0*(c(:,i)+c(:,i+1))
        call to_box2(pos,cp(:,i))
      enddo

      call to_box2(c(:,nres),c_tobox(:,nres))

!$OMP PARALLEL DO DEFAULT(SHARED)
      do i=1,nres
        call to_box2(c(:,nres+i),c_tobox(:,nres+i))
      enddo

#ifdef DEBUG
      write (iout,'(a)') "C and C_tobox"
      do i=1,nres
        write (iout,'(i5,3f10.5,5x,3f10.5)') i,(c(j,i),j=1,3),
     &         (c_tobox(j,i),j=1,3)
      enddo
#endif
      return
      end
