      subroutine make_SCSC_inter_list_RESPA
      implicit none
      include "DIMENSIONS"
#ifdef MPI
      include 'mpif.h'
      include "COMMON.SETUP"
#endif
      include "COMMON.CONTROL"
      include "COMMON.CHAIN"
      include "COMMON.INTERACT"
      include "COMMON.SPLITELE"
      include "COMMON.IOUNITS"
      double precision xi,yi,zi,xj,yj,zj,xj_safe,yj_safe,zj_safe,
     &  xj_temp,yj_temp,zj_temp
      double precision dist_init, dist_temp
      integer contlist_long(2,maxint_res*maxres),
     &  contlist_short(2,maxint_res*maxres)!,
!     &  contlistj_long(maxint_res*maxres),
!     &  contlistj_short(maxint_res*maxres)
      common /scscralocal/ contlist_long,contlist_short !OpenMP
!      integer :: newcontlisti(200*nres),newcontlistj(200*nres)
      integer i,j,itypi,itypj,subchap,xshift,yshift,zshift,iint,
     &  ilist_sc_long,g_ilist_sc_long,ilist_sc_short,g_ilist_sc_short
      integer displ(0:max_fg_procs),i_ilist_sc_long(0:max_fg_procs),
     & i_ilist_sc_short(0:max_fg_procs),ierr
      logical lprn /.false./
      double precision boxshift
      double precision d_scale,r_respa_buf
!            print *,"START make_SC"
#ifdef DEBUG
      write (iout,*) "make_SCSC_inter_list maxint_res",maxint_res
      write (iout,*) "iatsc_s",iatsc_s," iatsc_e",iatsc_e
#endif
      r_respa_buf=rlamb
      ilist_sc_long=0
      ilist_sc_short=0
      do i=iatsc_s,iatsc_e
        itypi=iabs(itype(i))
        if (itypi.eq.ntyp1) cycle
        xi=c_tobox(1,nres+i)
        yi=c_tobox(2,nres+i)
        zi=c_tobox(3,nres+i)
        do iint=1,nint_gr(i)
          do j=istart(i,iint),iend(i,iint)
            itypj=iabs(itype(j))
            if (itypj.eq.ntyp1) cycle
            xj=c_tobox(1,nres+j)
            yj=c_tobox(2,nres+j)
            zj=c_tobox(3,nres+j)
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dist_init=dsqrt(xj*xj+yj*yj+zj*zj)
! r_buff_list is a read value for a buffer
            if (dist_init.le.(r_cut_int+r_buff_list)) then
! Here the list is created
              d_scale=dist_init/sigmaii(itypi,itypj)
              if (d_scale.le.r_cut_respa+r_respa_buf) then
                ilist_sc_short=ilist_sc_short+1
                contlist_short(1,ilist_sc_short)=i
                contlist_short(2,ilist_sc_short)=j
              endif
              if (d_scale.gt.r_cut_respa-rlamb-r_respa_buf) then
                ilist_sc_long=ilist_sc_long+1
! this can be substituted by cantor and anti-cantor
                contlist_long(1,ilist_sc_long)=i
                contlist_long(2,ilist_sc_long)=j
              endif
            endif
          enddo
        enddo
      enddo
#ifdef MPI
#ifdef DEBUG
      write (iout,*) "before MPIREDUCE ilist_sc_long",ilist_sc_long
c      do i=1,ilist_sc_long
c      write (iout,*) i,contlist_long(1,i),contlist_long(2,i)
c      enddo
      write (iout,*) "before MPIREDUCE ilist_sc_short",ilist_sc_short
c      do i=1,ilist_sc_short
c      write (iout,*) i,contlist_short(1,i),contlist_short(2,i)
c      enddo
#endif
      if (nfgtasks.gt.1)then
        call MPI_Reduce(ilist_sc_long,g_ilist_sc_long,1,
     &                  MPI_INTEGER,MPI_SUM,king,FG_COMM,IERR)
        call MPI_Reduce(ilist_sc_short,g_ilist_sc_short,1,
     &                  MPI_INTEGER,MPI_SUM,king,FG_COMM,IERR)
c        write (iout,*) "SCSC after reduce ierr",ierr
        if (fg_rank.eq.0.and.(g_ilist_sc_long.gt.maxres*maxint_res .or.
     &      g_ilist_sc_short.gt.maxres*maxint_res)) then
          if ((me.eq.king.or.out1file).and.energy_dec) then
            write (iout,*) "Too many SCSC interactions",
     &      g_ilist_sc_long,g_ilist_sc_short,
     &       " only",maxres*maxint_res," allowed."
            write (iout,*) "Specify a smaller r_cut_int and resubmit"
            call flush(iout)
          endif
          write (*,*) "Processor:",me,": Too many SCSC interactions",
     &      g_ilist_sc_long+g_ilist_sc_short," only",
     &      maxres*maxint_res," allowed."
            write (*,*) "Specify a smaller r_cut_int and resubmit"
          call MPI_Abort(MPI_COMM_WORLD,ierr)
        endif
c        write(iout,*) "before bcast",g_ilist_sc_long
        call MPI_Gather(ilist_sc_long,1,MPI_INTEGER,
     &                  i_ilist_sc_long,1,MPI_INTEGER,king,FG_COMM,IERR)
c        write (iout,*) "SCSC after gather ierr",ierr
        displ(0)=0
        do i=1,nfgtasks-1,1
          displ(i)=i_ilist_sc_long(i-1)*2+displ(i-1)
        enddo
!        write(iout,*) "before gather",displ(0),displ(1)
        call MPI_Gatherv(contlist_long,ilist_sc_long*2,MPI_INTEGER,
     &             newcontlist_long,i_ilist_sc_long*2,displ,MPI_INTEGER,
     &             king,FG_COMM,IERR)
c        write (iout,*) "SCSC after gatherv ierr",ierr
!        call MPI_Gatherv(contlistj_long,ilist_sc_long,MPI_INTEGER,
!     &             newcontlistj_long,i_ilist_sc_long,displ,MPI_INTEGER,
!     &             king,FG_COMM,IERR)
        call MPI_Bcast(g_ilist_sc_long,1,MPI_INT,king,FG_COMM,IERR)
c        write (iout,*) "SCSC bcast reduce ierr",ierr
!        write(iout,*) "before bcast",g_ilist_sc_long
!        call MPI_Bcast(g_ilist_sc,1,MPI_INT,king,FG_COMM)
        call MPI_Bcast(newcontlist_long,g_ilist_sc_long*2,MPI_INT,king,
     &       FG_COMM,IERR)
c        write (iout,*) "SCSC bcast reduce ierr",ierr
!        call MPI_Bcast(newcontlistj_long,g_ilist_sc_long,MPI_INT,king,
!     &       FG_COMM,IERR)
c        write (iout,*) "SCSC after bcast ierr",ierr
!        write(iout,*) "before gather",displ(0),displ(1)
c        write(iout,*) "before bcast",g_ilist_sc_short
        call MPI_Gather(ilist_sc_short,1,MPI_INTEGER,
     &                i_ilist_sc_short,1,MPI_INTEGER,king,FG_COMM,IERR)
c        write (iout,*) "SCSC after gather ierr",ierr
        displ(0)=0
        do i=1,nfgtasks-1,1
          displ(i)=i_ilist_sc_short(i-1)*2+displ(i-1)
        enddo
!        write(iout,*) "before gather",displ(0),displ(1)
        call MPI_Gatherv(contlist_short,ilist_sc_short*2,MPI_INTEGER,
     &            newcontlist_short,i_ilist_sc_short*2,displ,
     &            MPI_INTEGER,
     &            king,FG_COMM,IERR)
c        write (iout,*) "SCSC after gatherv ierr",ierr
!        call MPI_Gatherv(contlistj_short,ilist_sc_short,MPI_INTEGER,
!     &           newcontlistj_short,i_ilist_sc_short,displ,MPI_INTEGER,
!     &           king,FG_COMM,IERR)
        call MPI_Bcast(g_ilist_sc_short,1,MPI_INT,king,FG_COMM,IERR)
c        write (iout,*) "SCSC bcast reduce ierr",ierr
!        write(iout,*) "before bcast",g_ilist_sc_short
!        call MPI_Bcast(g_ilist_sc,1,MPI_INT,king,FG_COMM)
        call MPI_Bcast(newcontlist_short,g_ilist_sc_short*2,
     &       MPI_INT,king,
     &       FG_COMM,IERR)
c        write (iout,*) "SCSC bcast reduce ierr",ierr
!        call MPI_Bcast(newcontlistj_short,g_ilist_sc_short,MPI_INT,king,
!     ^       FG_COMM,IERR)
c        write (iout,*) "SCSC after bcast ierr",ierr
        else
#endif
          g_ilist_sc_long=ilist_sc_long

          do i=1,ilist_sc_long
            newcontlist_long(1,i)=contlist_long(1,i)
            newcontlist_long(2,i)=contlist_long(2,i)
          enddo

          g_ilist_sc_short=ilist_sc_short

          do i=1,ilist_sc_short
            newcontlist_short(1,i)=contlist_short(1,i)
            newcontlist_short(2,i)=contlist_short(2,i)
          enddo
#ifdef MPI
        endif
#endif
#ifdef MPI
      if (fg_rank.eq.0 .and. (me.eq.king.or.out1file) .and. energy_dec)
     & write (iout,'(a30,2i10,a,2i4)')
     &  "Number of long- and short-range SC-SC interactions",
     &  g_ilist_sc_long,g_ilist_sc_short," per residue on average",
     &  g_ilist_sc_long/nres,g_ilist_sc_short/nres
#else
      if (energy_dec) write (iout,'(a30,2i10,a,2i4)')
     &  "Number of long- and short-range SC-SC interactions",
     &  g_ilist_sc_long,g_ilist_sc_short," per residue on average",
     &  g_ilist_sc_long/nres,g_ilist_sc_short/nres
#endif
#ifdef DEBUG
      write (iout,*)
     &  "make_SCSC_inter_list: g_ilist_sc_long after GATHERV",
     &  g_ilist_sc_long
      write (iout,*) "List of long-range SCSC interactions"
      do i=1,g_ilist_sc_long
      write (iout,*) i,newcontlist_long(1,i),newcontlist_long(2,i)
      enddo
      write (iout,*)
     &  "make_SCSC_inter_list: g_ilist_sc_short after GATHERV",
     &  g_ilist_sc_short
      write (iout,*) "List of short-range SCSC interactions"
      do i=1,g_ilist_sc_short
      write (iout,*) i,newcontlist_short(1,i),newcontlist_short(2,i)
      enddo
#endif
#ifdef MPI
      call int_bounds(g_ilist_sc_long,g_listscsc_start_long,
     & g_listscsc_end_long)
      call int_bounds(g_ilist_sc_short,g_listscsc_start_short,
     & g_listscsc_end_short)
#else
      g_listscsc_start_long=1
      g_listscsc_end_long=g_ilist_sc_long
      g_listscsc_start_short=1
      g_listscsc_end_short=g_ilist_sc_short
#endif
#ifdef DEBUG
      write (iout,*) "g_list_sc_start",g_listscsc_start_long,
     &  "g_list_sc_end",g_listscsc_end_long
      write (iout,*)"g_list_sc_start_short",g_listscsc_start_short,
     &  "g_list_sc_end_short",g_listscsc_end_short
#endif
      return
      end
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      subroutine make_SCp_inter_list_RESPA
      implicit none
      include "DIMENSIONS"
#ifdef MPI
      include 'mpif.h'
      include "COMMON.SETUP"
#endif
      include "COMMON.CONTROL"
      include "COMMON.CHAIN"
      include "COMMON.INTERACT"
      include "COMMON.SPLITELE"
      include "COMMON.IOUNITS"
      double precision xi,yi,zi,xj,yj,zj,xj_safe,yj_safe,zj_safe,
     &  xj_temp,yj_temp,zj_temp
      double precision dist_init, dist_temp
      integer contlistscp_long(2,2*maxint_res*maxres),
     & contlistscp_short(2,2*maxint_res*maxres)!,
!     & contlistscpj_long(2*maxint_res*maxres),
!     & contlistscpj_short(2*maxint_res*maxres)
      common /scpralocal/ contlistscp_long,contlistscp_short
!      integer :: newcontlistscpi(200*nres),newcontlistscpj(200*nres)
      integer i,j,iteli,itypj,subchap,xshift,yshift,zshift,iint,
     & ilist_scp_long,ilist_scp_short,g_ilist_scp_long,g_ilist_scp_short
      integer displ(0:max_fg_procs),i_ilist_scp_long(0:max_fg_procs),
     & i_ilist_scp_short(0:max_fg_procs),ierr
c      integer contlistscpi_f(2*maxint_res*maxres),
c     &  contlistscpj_f(2*maxint_res*maxres)
      double precision boxshift
      double precision d_scale,r_respa_buf
!            print *,"START make_SC"
#ifdef DEBUG
      write (iout,*) "make_SCp_inter_list maxint_res",maxint_res
#endif
      r_respa_buf=rlamb
      ilist_scp_long=0
      ilist_scp_short=0
      do i=iatscp_s,iatscp_e
        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1) cycle
        xi=cp(1,i)
        yi=cp(2,i)
        zi=cp(3,i)
        iteli=itel(i)
        do iint=1,nscp_gr(i)
          do j=iscpstart(i,iint),iscpend(i,iint)
            itypj=iabs(itype(j))
            if (itypj.eq.ntyp1) cycle
            xj=c_tobox(1,j)
            yj=c_tobox(2,j)
            zj=c_tobox(3,j)
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dist_init=dsqrt(xj*xj+yj*yj+zj*zj)
! r_buff_list is a read value for a buffer
            if (dist_init.le.(r_cut_int+r_buff_list)) then

              d_scale=dist_init/rscp(itypj,iteli)
              if (d_scale.le.r_cut_respa+r_respa_buf) then
! Here the list is created
                ilist_scp_short=ilist_scp_short+1
                contlistscp_short(1,ilist_scp_short)=i
                contlistscp_short(2,ilist_scp_short)=j
              endif
              if (d_scale.gt.r_cut_respa-rlamb-r_respa_buf) then
! this can be substituted by cantor and anti-cantor
                ilist_scp_long=ilist_scp_long+1
                contlistscp_long(1,ilist_scp_long)=i
                contlistscp_long(2,ilist_scp_long)=j
              endif
            endif
          enddo
        enddo
      enddo
#ifdef MPI
#ifdef DEBUG
      write (iout,*) "before MPIREDUCE",ilist_scp_long,ilist_scp_short
      write (iout,*) "Long-range scp interaction list"
      do i=1,ilist_scp_long
        write (iout,*) i,contlistscp_long(1,i),contlistscp_long(2,i)
      enddo
      write (iout,*) "Short-range scp interaction list"
      do i=1,ilist_scp_short
        write (iout,*) i,contlistscp_short(1,i),contlistscp_short(2,i)
      enddo
#endif
      if (nfgtasks.gt.1)then

        call MPI_Reduce(ilist_scp_long,g_ilist_scp_long,1,
     &    MPI_INTEGER,MPI_SUM,king,FG_COMM,IERR)
        call MPI_Reduce(ilist_scp_short,g_ilist_scp_short,1,
     &    MPI_INTEGER,MPI_SUM,king,FG_COMM,IERR)
c        write (iout,*) "SCp after reduce ierr",ierr
        if (fg_rank.eq.0.and.(g_ilist_scp_long.gt.
     &      2*maxres*maxint_res .or. g_ilist_scp_short.gt.
     &      2*maxres*maxint_res)) then
          if ((me.eq.king.or.out1file).and.energy_dec) then
            write (iout,*) "Too many SCp interactions",
     &      g_ilist_scp_long+g_ilist_scp_short," only",
     &      2*maxres*maxint_res," allowed."
            write (iout,*) "Specify a smaller r_cut_int and resubmit"
            call flush(iout)
          endif
          write (*,*) "Processor:",me,": Too many SCp interactions",
     &      g_ilist_scp_long+g_ilist_scp_short," only",
     &      2*maxres*maxint_res," allowed."
          write (*,*) "Specify a smaller r_cut_int and resubmit"
          call MPI_Abort(MPI_COMM_WORLD,ierr)
        endif
c        write(iout,*) "before bcast",g_ilist_sc
        call MPI_Gather(ilist_scp_long,1,MPI_INTEGER,
     &               i_ilist_scp_long,1,MPI_INTEGER,king,FG_COMM,IERR)
        call MPI_Gather(ilist_scp_short,1,MPI_INTEGER,
     &               i_ilist_scp_short,1,MPI_INTEGER,king,FG_COMM,IERR)
c        write (iout,*) "SCp after gather ierr",ierr
        displ(0)=0
        do i=1,nfgtasks-1,1
          displ(i)=i_ilist_scp_long(i-1)*2+displ(i-1)
        enddo
!        write(iout,*) "before gather",displ(0),displ(1)
        call MPI_Gatherv(contlistscp_long,ilist_scp_long*2,MPI_INTEGER,
     &         newcontlistscp_long,i_ilist_scp_long*2,displ,MPI_INTEGER,
     &         king,FG_COMM,IERR)
c        write (iout,*) "SCp after gatherv ierr",ierr
c        call MPI_Gatherv(contlistscpj_long,ilist_scp_long,MPI_INTEGER,
c     &         newcontlistscpj_long,i_ilist_scp_long,displ,MPI_INTEGER,
c     &         king,FG_COMM,IERR)
c        write (iout,*) "SCp after gatherv ierr",ierr
        call MPI_Bcast(g_ilist_scp_long,1,MPI_INT,king,FG_COMM,IERR)
c        write (iout,*) "SCp after bcast ierr",ierr
!        write(iout,*) "before bcast",g_ilist_sc
!        call MPI_Bcast(g_ilist_sc,1,MPI_INT,king,FG_COMM)
        call MPI_Bcast(newcontlistscp_long,g_ilist_scp_long*2,MPI_INT,
     &                   king,FG_COMM,IERR)
c        write (iout,*) "SCp after bcast ierr",ierr
c        call MPI_Bcast(newcontlistscpj_long,g_ilist_scp_long,MPI_INT,
c     &                   king,FG_COMM,IERR)
c        write (iout,*) "SCp bcast reduce ierr",ierr
!        call MPI_Bcast(g_ilist_sc,1,MPI_INT,king,FG_COMM)
        displ(0)=0
        do i=1,nfgtasks-1,1
          displ(i)=i_ilist_scp_short(i-1)*2+displ(i-1)
        enddo
!        write(iout,*) "before gather",displ(0),displ(1)
        call MPI_Gatherv(contlistscp_short,ilist_scp_short*2,
     &        MPI_INTEGER,
     &        newcontlistscp_short,i_ilist_scp_short*2,displ,
     &        MPI_INTEGER,
     &        king,FG_COMM,IERR)
c        write (iout,*) "SCp after gatherv ierr",ierr
c        call MPI_Gatherv(contlistscpj_short,ilist_scp_short,MPI_INTEGER,
c     &        newcontlistscpj_short,i_ilist_scp_short,displ,MPI_INTEGER,
c     &        king,FG_COMM,IERR)
c        write (iout,*) "SCp after gatherv ierr",ierr
        call MPI_Bcast(g_ilist_scp_short,1,MPI_INT,king,FG_COMM,IERR)
        call MPI_Bcast(newcontlistscp_short,g_ilist_scp_short*2,MPI_INT,
     &        king,FG_COMM,IERR)
c        write (iout,*) "SCp after bcast ierr",ierr
c        call MPI_Bcast(newcontlistscpj_short,g_ilist_scp_short,MPI_INT,
c     &        king,FG_COMM,IERR)
      else
#endif
        g_ilist_scp_long=ilist_scp_long

        do i=1,ilist_scp_long
          newcontlistscp_long(1,i)=contlistscp_long(1,i)
          newcontlistscp_long(2,i)=contlistscp_long(2,i)
        enddo
        g_ilist_scp_short=ilist_scp_short

        do i=1,ilist_scp_short
          newcontlistscp_short(1,i)=contlistscp_short(1,i)
          newcontlistscp_short(2,i)=contlistscp_short(2,i)
        enddo
#ifdef MPI
      endif
#endif
#ifdef MPI
      if (fg_rank.eq.0 .and. (me.eq.king.or.out1file) .and. energy_dec)
     &then
#endif
        if (energy_dec) write (iout,'(a30,i10,a,i4)')
     &  "Number of long-range SC-p interactions",
     &  g_ilist_scp_long," per residue on average",g_ilist_scp_long/nres
        if (energy_dec) write (iout,'(a30,i10,a,i4)')
     &  "Number of short-range SC-p interactions",
     &g_ilist_scp_short," per residue on average",g_ilist_scp_short/nres
#ifdef MPI
      endif
#endif
#ifdef DEBUG
      write (iout,*) "make_SCp_inter_list: after GATHERV long-range",
     &   g_ilist_scp_long
      do i=1,g_ilist_scp_long
        write (iout,*) i,newcontlistscp_long(1,i),
     &    newcontlistscp_long(2,i)
      enddo
      write (iout,*) "make_SCp_inter_list: after GATHERV short-range",
     &   g_ilist_scp_short
      do i=1,g_ilist_scp_short
        write (iout,*) i,newcontlistscp_short(1,i),
     &   newcontlistscp_short(2,i)
      enddo
#endif
#ifdef MPI
      call int_bounds(g_ilist_scp_long,g_listscp_start_long,
     &  g_listscp_end_long)
      call int_bounds(g_ilist_scp_short,g_listscp_start_short,
     &  g_listscp_end_short)
#else
      g_listscp_start_long=1
      g_listscp_end_long=g_ilist_scp_long
      g_listscp_start_short=1
      g_listscp_end_short=g_ilist_scp_short
#endif
#ifdef MPI
      if (fg_rank.eq.0 .and. (me.eq.king.or.out1file) .and. energy_dec)
     &then
#endif
        if (energy_dec)
     &  write (iout,*) "g_listscp_start",g_listscp_start_long,
     &  "g_listscp_end",g_listscp_end_long
        if (energy_dec)
     &  write (iout,*)"g_listscp_start_short",g_listscp_start_short,
     &  "g_listscp_end_short",g_listscp_end_short
#ifdef MPI
      endif
#endif
      return
      end
!-----------------------------------------------------------------------------
      subroutine make_pp_vdw_inter_list_RESPA
      implicit none
      include "DIMENSIONS"
#ifdef MPI
      include 'mpif.h'
      include "COMMON.SETUP"
#endif
      include "COMMON.CONTROL"
      include "COMMON.CHAIN"
      include "COMMON.INTERACT"
      include "COMMON.SPLITELE"
      include "COMMON.IOUNITS"
      double precision xi,yi,zi,xj,yj,zj,xj_safe,yj_safe,zj_safe,
     &  xj_temp,yj_temp,zj_temp
      double precision xmedj,ymedj,zmedj
      double precision dist_init, dist_temp,dxi,dyi,dzi,
     &  xmedi,ymedi,zmedi
      double precision dxj,dyj,dzj
      integer contlistpp_vdw_short(2,maxint_res*maxres)!,
c     & contlistpp_vdwj_short(maxint_res*maxres)
      common /ppvlocal/ contlistpp_vdw_short   !OMP
      integer i,j,itypi,itypj,subchap,xshift,yshift,zshift,iint,
     &  ilist_pp_vdw_short,g_ilist_pp_vdw_short
      integer displ(0:max_fg_procs),
     &  i_ilist_pp_vdw_short(0:max_fg_procs),ierr
!            print *,"START make_SC"
      double precision boxshift
      double precision d_scale,r_respa_buf
#ifdef DEBUG
      write (iout,*) "make_pp_vdw_inter_list"
#endif
      ilist_pp_vdw_short=0
      r_respa_buf=rlamb
      do i=iatel_s_vdw,iatel_e_vdw
        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1) cycle
        dxi=dc(1,i)
        dyi=dc(2,i)
        dzi=dc(3,i)
        xmedi=cp(1,i)
        ymedi=cp(2,i)
        zmedi=cp(3,i)
        do j=ielstart_vdw(i),ielend_vdw(i)
!          write (iout,*) i,j,itype(i),itype(j)
          if (itype(j).eq.ntyp1.or. itype(j+1).eq.ntyp1) cycle
! 1,j)
          dxj=dc(1,j)
          dyj=dc(2,j)
          dzj=dc(3,j)
          xj=cp(1,j)
          yj=cp(2,j)
          zj=cp(3,j)
          xj=boxshift(xj-xmedi,boxxsize)
          yj=boxshift(yj-ymedi,boxysize)
          zj=boxshift(zj-zmedi,boxzsize)
          dist_init=dsqrt(xj*xj+yj*yj+zj*zj)

          if (dist_init.le.(r_cut_int+r_buff_list)) then
            d_scale=dist_init/rpp(itel(i),itel(j))
            if (d_scale.le.r_cut_respa+r_respa_buf) then
! Here the list is created
              ilist_pp_vdw_short=ilist_pp_vdw_short+1
! this can be substituted by cantor and anti-cantor
              contlistpp_vdw_short(1,ilist_pp_vdw_short)=i
              contlistpp_vdw_short(2,ilist_pp_vdw_short)=j
            endif
          endif
        enddo
      enddo
!             enddo
#ifdef MPI
#ifdef DEBUG
      write (iout,*) "before MPIREDUCE longrange",ilist_pp_vdw_long
      do i=1,ilist_pp_vdw_long
        write (iout,*) i,contlistpp_vdw_long(1,i),contlistpp_vdw_long(2,i)
      enddo
      write (iout,*) "before MPIREDUCE shortrange",ilist_pp_vdw_short
      do i=1,ilist_pp_vdw_short
        write (iout,*) i,contlistpp_vdw_short(1,i),
     &    contlistpp_vdw_short(2,i)
      enddo
#endif
      if (nfgtasks.gt.1)then

        call MPI_Reduce(ilist_pp_vdw_short,g_ilist_pp_vdw_short,1,
     &    MPI_INTEGER,MPI_SUM,king,FG_COMM,IERR)
        if (fg_rank.eq.0.and.g_ilist_pp_vdw_short.gt.maxres*maxint_res)
     &  then
          if ((me.eq.king.or.out1file).and.energy_dec) then
            write (iout,*) "Too many pp VDW interactions",
     &      g_ilist_pp_vdw_short," only",maxres*maxint_res," allowed."
            write (iout,*) "Specify a smaller r_cut_int and resubmit"
            call flush(iout)
          endif
          write (*,*) "Processor:",me,": Too many pp VDW interactions",
     &      g_ilist_pp_vdw_short," only",maxres*maxint_res," allowed."
          write (8,*) "Specify a smaller r_cut_int and resubmit"
          call MPI_Abort(MPI_COMM_WORLD,ierr)
        endif
!        write(iout,*) "before bcast",g_ilist_sc
        call MPI_Gather(ilist_pp_vdw_short,1,MPI_INTEGER,
     &            i_ilist_pp_vdw_short,1,MPI_INTEGER,king,FG_COMM,IERR)
        displ(0)=0
        do i=1,nfgtasks-1,1
          displ(i)=i_ilist_pp_vdw_short(i-1)*2+displ(i-1)
        enddo
!        write(iout,*) "before gather",displ(0),displ(1)
        call MPI_Gatherv(contlistpp_vdw_short,ilist_pp_vdw_short*2,
     &    MPI_INTEGER,newcontlistpp_vdw_short,
     &    i_ilist_pp_vdw_short*2,displ,
     &    MPI_INTEGER,king,FG_COMM,IERR)
c        call MPI_Gatherv(contlistpp_vdwj_short,ilist_pp_vdw_short,
c     &  MPI_INTEGER,newcontlistpp_vdwj_short,i_ilist_pp_vdw_short,displ,
c     &  MPI_INTEGER,king,FG_COMM,IERR)
        call MPI_Bcast(g_ilist_pp_vdw_short,1,MPI_INT,king,FG_COMM,IERR)
!        write(iout,*) "before bcast",g_ilist_sc
!        call MPI_Bcast(g_ilist_sc,1,MPI_INT,king,FG_COMM)
        call MPI_Bcast(newcontlistpp_vdw_short,g_ilist_pp_vdw_short*2,
     &   MPI_INT,king,FG_COMM,IERR)
c        call MPI_Bcast(newcontlistpp_vdwj_short,g_ilist_pp_vdw_short,
c     &   MPI_INT,king,FG_COMM,IERR)
!        call MPI_Bcast(g_ilist_sc,1,MPI_INT,king,FG_COMM)
      else
#endif
        g_ilist_pp_vdw_short=ilist_pp_vdw_short

        do i=1,ilist_pp_vdw_short
          newcontlistpp_vdw_short(1,i)=contlistpp_vdw_short(1,i)
          newcontlistpp_vdw_short(2,i)=contlistpp_vdw_short(2,i)
        enddo
#ifdef MPI
      endif
#endif
#ifdef MPI
      if (fg_rank.eq.0 .and. (me.eq.king.or.out1file) .and. energy_dec)
     &then
#endif
      if (energy_dec)
     & write (iout,*) "Number of short-range p-p VDW interactions",
     & g_ilist_pp_vdw_short," per residue on average",
     & g_ilist_pp_vdw_short/nres
#ifdef MPI
      endif
#endif
#ifdef DEBUG
      write (iout,*) "Short-range pp_vdw"
      write (iout,*) "make_pp_vdw_inter_list: after GATHERV",
     &  g_ilist_pp_vdw_short
      do i=1,g_ilist_pp_vdw_short
        write (iout,*) i,newcontlistpp_vdwi_short(i),
     &     newcontlistpp_vdwj_short(i)
      enddo
#endif
#ifdef MPI
      call int_bounds(g_ilist_pp_vdw_short,g_listpp_vdw_start_short,
     &       g_listpp_vdw_end_short)
#else
      g_listpp_vdw_start_short=1
      g_listpp_vdw_end_short=g_ilist_pp_vdw_short
#endif
#ifdef MPI
      if (fg_rank.eq.0 .and. (me.eq.king.or.out1file) .and. energy_dec)
     &then
#endif
        if (energy_dec) write (iout,*)"g_listpp_vdw_start_short",
     &  g_listpp_vdw_start_short,
     &  "g_listpp_vdw_end_short",g_listpp_vdw_end_short
#ifdef MPI
      endif
#endif
      return
      end
