      subroutine loc_prep
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.VAR'
      include 'COMMON.SCROT'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.FFIELD'
      include 'COMMON.CONTROL'
      include 'COMMON.VECTORS'
      integer i
      double precision costhet1,costhet2,dc1dc3,uuz(3),uuz23(3),uuz13(3)
      double precision uzder(3,3,2)
      double precision scalar
c cosines and sines of backbone-virtual-bond angles and their derivatives
c in virtual-bond vectors
      costtab(nres+1)=0.0d0
      sinttab(nres+1)=1.0d0
!$OMP PARALLEL DO DEFAULT(SHARED)
!$OMP& PRIVATE(costhet1,costhet2,dc1dc3,uuz,uuz23,uuz13,uzder)
      do i=2,nres-1
        if (itype(i).eq.ntyp1) cycle
        costtab(i+1)=-scalar(dc_norm(1,i-1),dc_norm(1,i))
        sinttab(i+1)=dsqrt(1-costtab(i+1)*costtab(i+1))
        cost2tab(i+1)=dsqrt(0.5d0*(1.0d0+costtab(i+1)))
        sint2tab(i+1)=dsqrt(0.5d0*(1.0d0-costtab(i+1)))
        dcosttab(:,1,i+1)=-(dc_norm(:,i)+costtab(i+1)*dc_norm(:,i-1))
     &    *vbld_inv(i)
        dcosttab(:,2,i+1)=-(dc_norm(:,i-1)+costtab(i+1)*dc_norm(:,i))
     &    *vbld_inv(i+1)
c        write (iout,*) costtab(i+1),vbld_inv(i-1)
c        write (iout,*) dc_norm(:,i)
c        write (iout,*) dc_norm(:,i-1)
c        write (iout,*) "i",i+1,"dcosttab",dcosttab(:,1,i+1)
      enddo
#ifdef POZNIEJ
c Vectors perpendicular to the CA-CA-CA frames and their derivatives in 
c virtual-bond vectors. The vectors are not normalized by
c sin(theta) as opposed to previous implementation.
      do i=2,nres-1
        call vecpr(dc_norm(1,i-1),dc_norm(1,i),uz(1,i)
        uzder(1,1,1)= 0.0d0
        uzder(2,1,1)=-dc_norm(3,i+1)
        uzder(3,1,1)= dc_norm(2,i+1) 
        uzder(1,2,1)= dc_norm(3,i+1)
        uzder(2,2,1)= 0.0d0
        uzder(3,2,1)=-dc_norm(1,i+1)
        uzder(1,3,1)=-dc_norm(2,i+1)
        uzder(2,3,1)= dc_norm(1,i+1)
        uzder(3,3,1)= 0.0d0
        uzder(1,1,2)= 0.0d0
        uzder(2,1,2)= dc_norm(3,i)
        uzder(3,1,2)=-dc_norm(2,i) 
        uzder(1,2,2)=-dc_norm(3,i)
        uzder(2,2,2)= 0.0d0
        uzder(3,2,2)= dc_norm(1,i)
        uzder(1,3,2)= dc_norm(2,i)
        uzder(2,3,2)=-dc_norm(1,i)
        uzder(3,3,2)= 0.0d0
        call unormderiv(uz(1,i),uzder(1,1,1),vbld_inv(i),
     &    uzgrad(1,1,1,i))
        call unormderiv(uz(1,i),uzder(1,1,2),vbld_inv(i+1),
     &    uzgrad(1,1,2,i))
      enddo
c Vectors perpendicular to the CA-CA-CA frames and their derivatives in 
c virtual-bond vectors. The vectors are not normalized by
c sin(theta) as opposed to previous implementation.
      do i=1,nres-1
        uy(:,1,i)=dC_norm(:,i-1)+costtab(i+1)*dC_norm(:,i)
        uy(:,2,i)=dC_norm(:,i+1)+costtab(i+2)*dC_norm(:,i)
      enddo
      do i=1,nres-1
        do j=1,3
          do k=1,3
            uygrad(j,k,1,1,i)=-vbld_inv(i)*dC_norm(j,i)*dC_norm(k,i)
     &          -dcosttab(j,1,i+1)*dC_norm(k,i-1)
          enddo
          uy_grad(j,j,1,1,i)=uy_grad(j,j,1,1,i)+vbld_inv(i)
        enddo
        do j=1,3
          do k=1,3
            uygrad(j,k,2,1,i)=-vbld_inv(i+1)*costtab(i+1)*
     &         dC_norm(j,i)*dC_norm(k,i)-dcosttab(j,2,i+1)*dC_norm(k,i)
          enddo
          uy_grad(j,j,2,1,i)=uy_grad(j,j,2,1,i)+vbld_inv(i+1)
        enddo
        do j=1,3
          do k=1,3
            uygrad(j,k,1,2,i)=-vbld_inv(i+1)*costtab(i+2)*
     &        dC_norm(j,i)*dC_norm(k,i)-dcosttab(j,1,i+2)*dC_norm(k,i)
          enddo
          uy_grad(j,j,1,2,i)=uy_grad(j,j,1,2,i)+vbld_inv(i+1)
        enddo
        do j=1,3
          do k=1,3
            uygrad(j,k,2,2,i)=-vbld_inv(i+2)*dC_norm(j,i)*dC_norm(k,i)
     &          -dcosttab(j,1,i+2)*dC_norm(k,i+1)
          enddo
          uy_grad(j,j,2,2,i)=uy_grad(j,j,2,2,i)+vbld_inv(i+2)
        enddo
      enddo
#endif
c Now handle dihedrals
!$OMP PARALLEL DO DEFAULT(SHARED)
!$OMP& PRIVATE(costhet1,costhet2,dc1dc3,uuz,uuz23,uuz13,uzder)
      do i=nnt+3,nct
c cosine of the torsional angle multiplied by the sines of the adjacent
c planar angles
        if (itype(i-2).eq.ntyp1.or. itype(i-1).eq.ntyp1
     &      .or. itype(i).eq.ntyp1 .or. itype(i-3).eq.ntyp1) cycle
c        write (iout,*) 
c        write (iout,*) "i=",i
c        write (iout,*) costtab(i-1),costtab(i)
        costhet1=costtab(i-1)
        costhet2=costtab(i)
        dc1dc3=scalar(dc_norm(1,i-3),dc_norm(1,i-1))
c        write (iout,*) costhet1,costhet2,dc1dc3
        cphsth1sth2tab(i)=-dc1dc3+costhet1*costhet2
c sine of the torsional angle multiplied by the sines of the adjacent
c planar angles
        call vecpr(dc_norm(1,i-3),dc_norm(1,i-2),uuz(1))
        sphsth1sth2tab(i)=scalar(uuz(1),dc_norm(1,i-1))
c        write (iout,*) dc1dc3,costhet1,costhet2
c        write (iout,*) "cph sph",cphsth1sth2tab(i),sphsth1sth2tab(i)
c        write (iout,*) "cosphi",cphsth1sth2/sint1t2,dcos(phii),
c     &   " sinphi",sphsth1sth2/sint1t2,dsin(phii)
c derivatives of multiplied cosine in virtual-bond vectors
        dcgs1s2tab(:,1,i)=-(dc_norm(:,i-1)-dc1dc3*dc_norm(:,i-3))
     &     *vbld_inv(i-2)+costhet2*dcosttab(:,1,i-1)
        dcgs1s2tab(:,2,i)=+costhet2*dcosttab(:,2,i-1)
     &     +costhet1*dcosttab(:,1,i)
        dcgs1s2tab(:,3,i)=-(dc_norm(:,i-3)-dc1dc3*dc_norm(:,i-1))
     &     *vbld_inv(i)+costhet1*dcosttab(:,2,i)
c derivatives of multiplied sine in virtual-bond vectors
        call vecpr(dc_norm(1,i-2),dc_norm(1,i-1),uuz23(1))
        call vecpr(dc_norm(1,i-3),dc_norm(1,i-1),uuz13(1))
        dsgs1s2tab(:,1,i)=(uuz23(:)-sphsth1sth2tab(i)*dC_norm(:,i-3))
     &    *vbld_inv(i-2)
        dsgs1s2tab(:,2,i)=-(uuz13(:)+sphsth1sth2tab(i)*dC_norm(:,i-2))
     &    *vbld_inv(i-1)
        dsgs1s2tab(:,3,i)=(uuz(:)-sphsth1sth2tab(i)*dc_norm(:,i-1))
     &    *vbld_inv(i)
      enddo
      return
      end
