       subroutine kinetic_CASC(KE_total)
c----------------------------------------------------------------
c   Compute the kinetic energy of the system using the Calpha-SC
c   coordinate system
c-----------------------------------------------------------------
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.INTERACT'
      include 'COMMON.MD'
#ifdef FIVEDIAG
      include 'COMMON.LAGRANGE.5diag'
#else
      include 'COMMON.LAGRANGE'
#endif
      include 'COMMON.IOUNITS'
      double precision KE_total
     
      integer i,j,k,iti,ichain,innt,inct
      double precision KEt_p,KEt_sc,KEr_p,KEr_sc,incr(3),
     & mag1,mag2,v(3) 
#ifdef FIVEDIAG
      KEt_p=0.0d0
      KEt_sc=0.0d0
      KEr_p=0.0D0
      KEr_sc=0.0D0
c      write (iout,*) "ISC",(isc(itype(i)),i=1,nres)
c   The translational part for peptide virtual bonds      
      do ichain=1,nchain

      innt=chain_border(1,ichain)
      inct=chain_border(2,ichain)
c      write (iout,*) "Kinetic_CASC chain",ichain," innt",innt,
c     &  " inct",inct

      do i=innt,inct-1
c        write (iout,*) i,(d_t(j,i),j=1,3),(d_t(j,i+1),j=1,3) 
        do j=1,3
          v(j)=0.5d0*(d_t(j,i)+d_t(j,i+1))
        enddo
c        write (iout,*) "Kinetic trp i",i," v",(v(j),j=1,3)
        KEt_p=KEt_p+(v(1)*v(1)+v(2)*v(2)+v(3)*v(3))
      enddo
c      write(iout,*) 'KEt_p', KEt_p
c The translational part for the side chain virtual bond     
c Only now we can initialize incr with zeros. It must be equal
c to the velocities of the first Calpha.
      do i=innt,inct
        iti=iabs(itype(i))
        if (iti.eq.10) then
c          write (iout,*) i,iti,(d_t(j,i),j=1,3)
          do j=1,3
            v(j)=d_t(j,i)
          enddo  
        else
c          write (iout,*) i,iti,(d_t(j,nres+i),j=1,3)
          do j=1,3
            v(j)=d_t(j,nres+i)
          enddo
        endif
c        write (iout,*) "Kinetic trsc:",i,(incr(j),j=1,3)
c        write (iout,*) "i",i," msc",msc(iti)," v",(v(j),j=1,3)
        KEt_sc=KEt_sc+msc(iti)*(v(1)*v(1)+v(2)*v(2)+v(3)*v(3))
      enddo
c      goto 111
c      write(iout,*) 'KEt_sc', KEt_sc
c  The part due to stretching and rotation of the peptide groups
       do i=innt,inct-1
         do j=1,3
           incr(j)=d_t(j,i+1)-d_t(j,i)
         enddo
c         write (iout,*) i,(incr(j),j=1,3)
c         write (iout,*) "Kinetic rotp:",i,(incr(j),j=1,3)
         KEr_p=KEr_p+(incr(1)*incr(1)+incr(2)*incr(2)
     &     +incr(3)*incr(3))
       enddo  
c      goto 111
c       write(iout,*) 'KEr_p', KEr_p
c  The rotational part of the side chain virtual bond
       do i=innt,inct
         iti=iabs(itype(i))
         if (iti.ne.10) then
           do j=1,3
             incr(j)=d_t(j,nres+i)-d_t(j,i)
           enddo
c           write (iout,*) "Kinetic rotsc:",i,(incr(j),j=1,3)
           KEr_sc=KEr_sc+Isc(iti)*(incr(1)*incr(1)+incr(2)*incr(2)+
     &       incr(3)*incr(3))
         endif
       enddo

       enddo ! ichain
c The total kinetic energy	
  111  continue
c       write(iout,*) ' KEt_p',KEt_p,' KEt_sc',KEt_sc,' KEr_p',KEr_p,
c     &  ' KEr_sc', KEr_sc
       KE_total=0.5d0*(mp*KEt_p+KEt_sc+0.25d0*Ip*KEr_p+KEr_sc)
c       write (iout,*) "KE_total",KE_tota
#else
       write (iout,*) "Need to compile with -DFIVEDIAG to use this sub!"
       stop
#endif
       return
       end
