      subroutine etor_constr(edihcnstr)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.TORCNSTR'
      include 'COMMON.BOUNDS'
      include 'COMMON.CONTROL'
      include 'COMMON.NMR'
      include 'COMMON.MD'
      include 'COMMON.REMD'
      include 'COMMON.AVNLOC'
      include 'COMMON.RESTARTED'
      double precision cosphi_now,cosphi_ave,sinphi_now,sinphi_ave
      double precision edihcnstr
      integer i,j,itori
      double precision phii,gaudih_i,gauder_i,s,cos_i,dexpcos_i,
     &  scal_fac,dravdr_max,cosphii,sinphii,
     &  cosphii_ave,sinphii_ave,denom,dravdr,difi
      double precision scaltau,pinorm
      external scaltau,pinorm
      integer INCFLG

! 6/20/98 - dihedral angle constraints
      edihcnstr=0.0d0
c      do i=1,ndih_constr
      if (raw_psipred) then
        do i=idihconstr_start,idihconstr_end
          itori=idih_constr(i)
          phii=phi(itori)
          gaudih_i=vpsipred(1,i)
          gauder_i=0.0d0
          do j=1,2
            s = sdihed(j,i)
            cos_i=(1.0d0-dcos(phii-phibound(j,i)))/s**2
            dexpcos_i=dexp(-cos_i*cos_i)
            gaudih_i=gaudih_i+vpsipred(j+1,i)*dexpcos_i
            gauder_i=gauder_i-2*vpsipred(j+1,i)*dsin(phii-phibound(j,i))
     &            *cos_i*dexpcos_i/s**2
          enddo
          edihcnstr=edihcnstr-wdihc*dlog(gaudih_i)
          gloc(itori-3,icg)=gloc(itori-3,icg)-wdihc*gauder_i/gaudih_i
#ifdef ENERGY_DEC
          if (energy_dec)
     &     write (iout,'(2i5,f8.3,f8.5,2(f8.5,2f8.3),f10.5)')
     &     i,itori,phii*rad2deg,vpsipred(1,i),vpsipred(2,i),
     &     phibound(1,i)*rad2deg,sdihed(1,i)*rad2deg,vpsipred(3,i),
     &     phibound(2,i)*rad2deg,sdihed(2,i)*rad2deg,
     &     -wdihc*dlog(gaudih_i)
#endif
        enddo
      else if (atimeave.gt.0) then

      INCFLG=1
      call force_scale(3)
#ifdef DEBUG
      write (iout,*) "nsteps",nsteps(3),"tau_temp",tau_temp(3),
     &  " scaling",scal_force(3)
#endif
      dravdr_max=0.0d0

      do i=idihconstr_start,idihconstr_end
        itori=idih_constr(i)
        phii=phi(itori)
#ifdef DEBUG
        write (iout,*) "i",i," phii",phii
#endif
        cosphii=dcos(phii)
        sinphii=dsin(phii)
        if (restarted) then
c Calculate the averages from restart information
         call AVEINT(cosphi_xave(1,i),cosphi_xave0(i),cosphi_xaveave(i),
     &      cosphii,TAU,d_time0,NAVINT,-1,3,INCFLG,2,cosphii_ave,DENOM)
         call AVEINT(sinphi_xave(1,i),sinphi_xave0(i),sinphi_xaveave(i),
     &      sinphii,TAU,d_time0,NAVINT,-1,4,INCFLG,2,sinphii_ave,DENOM)
        else
c Update the averages
         call AVEINT(cosphi_xave(1,i),cosphi_xave0(i),cosphi_xaveave(i),
     &      cosphii,TAU,d_time0,NAVINT,-1,3,INCFLG,1,cosphii_ave,DENOM)
         call AVEINT(sinphi_xave(1,i),sinphi_xave0(i),sinphi_xaveave(i),
     &      sinphii,TAU,d_time0,NAVINT,-1,4,INCFLG,1,sinphii_ave,DENOM)
        endif
        INCFLG=0
c--------------Calcualte derivative factors of time-ave--------------
c----------F=∂E/∂x=(∂E/∂r̄)(∂r̄/∂r(t))(∂r(t)/∂x)
        if (icalls(3).lt.navint) then
          DRAVDR=1.0d0
        else if (ider_ave(3).eq.1) then
          DRAVDR=0.5d0
        else
          DRAVDR=0.5d0*NAVINT*d_time0/DENOM*
     &     (cosphii*cosphii_ave+sinphii*sinphii_ave)/
     &     (cosphii_ave*cosphii_ave+sinphii_ave*sinphii_ave)
          if (.not.nonscal_ave_grad)
     &    dravdr=dravdr*scal_force(3)
        endif
        phii=datan2(sinphii_ave,cosphii_ave)
        difi=pinorm(phii-phi0(i))
        if (difi.gt.drange(i)) then
          difi=difi-drange(i)
#ifdef SCALE_ERESTR
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4*scal_force(3)
#else
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4
#endif
          gloc(itori-3,icg)=gloc(itori-3,icg)+ftors(i)*difi**3*DRAVDR
        else if (difi.lt.-drange(i)) then
          difi=difi+drange(i)
#ifdef SCALE_ERESTR
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4*scal_force(3)
#else
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4
#endif
          gloc(itori-3,icg)=gloc(itori-3,icg)+ftors(i)*difi**3*DRAVDR
        else
          difi=0.0
        endif
#ifdef DEBUG
        write (iout,*) "etor_constr_ave",i,itori,phii,DRAVDR,
     &    cosphii_ave,sinphii_ave,phii,gloc(itori-3,icg)
        write (iout,*) "cosphii",cosphii," sinphii",sinphii,
     &    " cosphii_ave",cosphii_ave," sinphii_ave",sinphii_ave,
     &    " fac",(cosphii*cosphii_ave+sinphii*sinphii_ave)/
     &     (cosphii_ave*cosphii_ave+sinphii_ave*sinphii_ave)
#endif
      enddo

#ifdef REPAVE
      else if (ave_rep) then

c      write (iout,*) "gloc"
c      do i=1,nres
c        write (iout,*) i,gloc(i,icg)
c      enddo
      do i=idihconstr_start,idihconstr_end
        itori=idih_constr(i)
        phii=phi(itori)
#ifdef DEBUG
        write (iout,*) "i",i," phii",phii
#endif
        cosphii=dcos(phii)
        sinphii=dsin(phii)
        if (itime_rep.gt.n_exch_restr) then
          cosphii_ave=cosphi_repave(i)+myrep_weight*cosphii
          sinphii_ave=sinphi_repave(i)+myrep_weight*sinphii
#ifdef SCALE_ERESTR
          DRAVDR=(cosphii*cosphii_ave+sinphii*sinphii_ave)/
     &    (cosphii_ave*cosphii_ave+sinphii_ave*sinphii_ave)*myrep_weight
#else
          DRAVDR=(cosphii*cosphii_ave+sinphii*sinphii_ave)/
     &    (cosphii_ave*cosphii_ave+sinphii_ave*sinphii_ave)
#endif
          phii=datan2(sinphii_ave,cosphii_ave)
        else
          DRAVDR=1.0d0
        endif
        if (mod(itime_rep,n_exch_restr).eq.0) then
          cosphi_repave(i)=cosphii
          sinphi_repave(i)=sinphii
        endif
        difi=pinorm(phii-phi0(i))
        if (difi.gt.drange(i)) then
          difi=difi-drange(i)
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4
          gloc(itori-3,icg)=gloc(itori-3,icg)+ftors(i)*difi**3*DRAVDR
        else if (difi.lt.-drange(i)) then
          difi=difi+drange(i)
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4
          gloc(itori-3,icg)=gloc(itori-3,icg)+ftors(i)*difi**3*DRAVDR
        else
          difi=0.0
        endif
#ifdef DEBUG
        write (iout,*) "etor_constr_ave",i,itori,"gamma",phii*rad2deg,
     &    " phi0",phi0(i)*rad2deg," cosphii",cosphii," sinphii",sinphii,
     &    " cosphii_ave",cosphii_ave," sinphii_ave",sinphii_ave,
     &    " DRAVDR",DRAVDR," energy",0.25d0*ftors(i)*difi**4,
     &    " edihcnstr",edihcnstr," gloc",gloc(itori-3,icg)
#endif
      enddo
c      write (iout,*) "edihcnstr",edihcnstr
#endif
      else

      do i=idihconstr_start,idihconstr_end
        itori=idih_constr(i)
        phii=phi(itori)
        difi=pinorm(phii-phi0(i))
        if (difi.gt.drange(i)) then
          difi=difi-drange(i)
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4
          gloc(itori-3,icg)=gloc(itori-3,icg)+ftors(i)*difi**3
        else if (difi.lt.-drange(i)) then
          difi=difi+drange(i)
          edihcnstr=edihcnstr+0.25d0*ftors(i)*difi**4
          gloc(itori-3,icg)=gloc(itori-3,icg)+ftors(i)*difi**3
        else
          difi=0.0
        endif
c#define DEBUG
c#ifdef DEBUG
        if (energy_dec)
     &     write (iout,'(2i5,3f8.3,2e12.5)')
     &     i,itori,phii*rad2deg,phi0(i)*rad2deg,difi*rad2deg,
     &     0.25d0*ftors(i)*difi**4,edihcnstr
c#endif
c#undef DEBUG
      enddo

      endif

      return
      end

