C-----------------------------------------------------------------------
      double precision function sscalelip(r)
      implicit none
      double precision r,gamm
      include "COMMON.SPLITELE"
C      if(r.lt.r_cut-rlamb) then
C        sscale=1.0d0
C      else if(r.le.r_cut.and.r.ge.r_cut-rlamb) then
C        gamm=(r-(r_cut-rlamb))/rlamb
        sscalelip=1.0d0+r*r*(2*r-3.0d0)
C      else
C        sscale=0d0
C      endif
      return
      end
C-----------------------------------------------------------------------
      double precision function sscagradlip(r)
      implicit none
      double precision r,gamm
      include "COMMON.SPLITELE"
C     if(r.lt.r_cut-rlamb) then
C        sscagrad=0.0d0
C      else if(r.le.r_cut.and.r.ge.r_cut-rlamb) then
C        gamm=(r-(r_cut-rlamb))/rlamb
        sscagradlip=r*(6*r-6.0d0)
C      else
C        sscagrad=0.0d0
C      endif
      return
      end

C-----------------------------------------------------------------------
      double precision function sscale(r,r_cut)
      implicit none
      double precision r,r_cut,gamm
      include "COMMON.SPLITELE"
      if(r.lt.r_cut-rlamb) then
        sscale=1.0d0
      else if(r.le.r_cut.and.r.ge.r_cut-rlamb) then
        gamm=(r-(r_cut-rlamb))/rlamb
        sscale=1.0d0+gamm*gamm*(2*gamm-3.0d0)
      else
        sscale=0d0
      endif
      return
      end
C-----------------------------------------------------------------------
      double precision function sscagrad(r,r_cut)
      implicit none
      double precision r,r_cut,gamm
      include "COMMON.SPLITELE"
      if(r.lt.r_cut-rlamb) then
        sscagrad=0.0d0
      else if(r.le.r_cut.and.r.ge.r_cut-rlamb) then
        gamm=(r-(r_cut-rlamb))/rlamb
        sscagrad=gamm*(6*gamm-6.0d0)/rlamb
      else
        sscagrad=0.0d0
      endif
      return
      end
C-----------------------------------------------------------------------
      subroutine elj_long(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the LJ potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.TORSION'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include "COMMON.SPLITELE"
c      include 'COMMON.CONTACTS'
      double precision gg(3)
      double precision evdw,evdwij
      integer i,j,k,itypi,itypj,itypi1,num_conti,iint,ikont,jblock
      double precision xi,yi,zi,xj,yj,zj,rij,eps0ij,fac,e1,e2,rrij,
     & sigij,r0ij,rcut,sss1,sssgrad1,sqrij
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision boxshift
      double precision gg_lipi(3),gg_lipj(3)
c      write(iout,*)'Entering ELJ nnt=',nnt,' nct=',nct,' expon=',expon
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_long,g_listscsc_end_long
        i=newcontlisti_long(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
C
C Calculate SC interaction energy.
C
c        do iint=1,nint_gr(i)
cd        write (iout,*) 'i=',i,' iint=',iint,' istart=',istart(i,iint),
cd   &                  'iend=',iend(i,iint)
        do jblock=newcontlisti_long(2,ikont-1)+1,
     &    newcontlisti_long(2,ikont)
          do j=newcontlistj_long(1,jblock),newcontlistj_long(2,jblock)
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            rij=xj*xj+yj*yj+zj*zj
            sqrij=dsqrt(rrij)
            eps0ij=eps(itypi,itypj)
            sss1=sscale(sqrij,r_cut_int)
            if (sss1.eq.0.0d0) cycle
            sssgrad1=sscagrad(sqrij,r_cut_int)
            sssgrad=
     &        sscagrad(sqrij/sigma(itypi,itypj),r_cut_respa)
            sss=sscale(sqrij/sigma(itypi,itypj),r_cut_respa)
            if (sss.lt.1.0d0) then
              rrij=1.0D0/rij
              fac=rrij**expon2
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=e1+e2
              evdw=evdw+(1.0d0-sss)*sss1*evdwij/sqrij/expon
C 
C Calculate the components of the gradient in DC and X
C
              fac=-rrij*(e1+evdwij)*(1.0d0-sss)*sss1
     &            +evdwij*(-sss1*sssgrad/sigma(itypi,itypj)
     &            +(1.0d0-sss)*sssgrad1)/sqrij
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=(sss1*(1.0d0-sss)/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj))))/expon
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
              do k=1,3
                gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
                gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
                gvdwc(k,i)=gvdwc(k,i)-gg(k)+gg_lipi(k)
                gvdwc(k,j)=gvdwc(k,j)+gg(k)+gg_lipj(k)
              enddo
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! i
      do i=1,nct
        do j=1,3
          gvdwc(j,i)=expon*gvdwc(j,i)
          gvdwx(j,i)=expon*gvdwx(j,i)
        enddo
      enddo
C******************************************************************************
C
C                              N O T E !!!
C
C To save time, the factor of EXPON has been extracted from ALL components
C of GVDWC and GRADX. Remember to multiply them by this factor before further 
C use!
C
C******************************************************************************
      return
      end
C-----------------------------------------------------------------------
      subroutine elj_short(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the LJ potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.TORSION'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include "COMMON.SPLITELE"
c      include 'COMMON.CONTACTS'
      double precision gg(3)
      double precision evdw,evdwij
      integer i,j,k,itypi,itypj,itypi1,num_conti,iint,ikont,jblock
      double precision xi,yi,zi,xj,yj,zj,rij,eps0ij,fac,e1,e2,rrij,
     & sigij,r0ij,rcut,sqrij,sss1,sssgrad1
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision boxshift
      double precision gg_lipi(3),gg_lipj(3)
c      write(iout,*)'Entering ELJ nnt=',nnt,' nct=',nct,' expon=',expon
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_short,g_listscsc_end_short
        i=newcontlisti_short(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
C Change 12/1/95
            num_conti=0
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_short(2,ikont-1)+1,
     &    newcontlisti_short(2,ikont)
          do j=newcontlistj_short(1,jblock),newcontlistj_short(2,jblock)
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
C Change 12/1/95 to calculate four-body interactions
            rij=xj*xj+yj*yj+zj*zj
            sqrij=dsqrt(rij)
            sss=sscale(sqrij/sigma(itypi,itypj),r_cut_respa)
            if (sss.gt.0.0d0) then
              sssgrad=
     &          sscagrad(sqrij/sigma(itypi,itypj),r_cut_respa)
              rrij=1.0D0/rij
              eps0ij=eps(itypi,itypj)
              fac=rrij**expon2
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=e1+e2
              evdw=evdw+sss*evdwij
C 
C Calculate the components of the gradient in DC and X
C
              fac=-rrij*(e1+evdwij)*sss+evdwij*sssgrad/sqrij/expon
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=(sss/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj))))/expon
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
              do k=1,3
                gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
                gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
                gvdwc(k,i)=gvdwc(k,i)-gg(k)+gg_lipi(k)
                gvdwc(k,j)=gvdwc(k,j)+gg(k)+gg_lipj(k)
              enddo
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
      do i=1,nct
        do j=1,3
          gvdwc(j,i)=expon*gvdwc(j,i)
          gvdwx(j,i)=expon*gvdwx(j,i)
        enddo
      enddo
C******************************************************************************
C
C                              N O T E !!!
C
C To save time, the factor of EXPON has been extracted from ALL components
C of GVDWC and GRADX. Remember to multiply them by this factor before further 
C use!
C
C******************************************************************************
      return
      end
C-----------------------------------------------------------------------------
      subroutine eljk_long(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the LJK potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include "COMMON.SPLITELE"
      double precision gg(3)
      double precision evdw,evdwij
      integer i,j,k,itypi,itypj,itypi1,iint,ikont,jblock
      double precision xi,yi,zi,xj,yj,zj,rij,eps0ij,fac,e1,e2,rrij,
     & fac_augm,e_augm,r_inv_ij,r_shift_inv,sss1,sssgrad1
      logical scheck
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision boxshift
      double precision gg_lipi(3),gg_lipj(3)
c     print *,'Entering ELJK nnt=',nnt,' nct=',nct,' expon=',expon
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_long,g_listscsc_end_long
        i=newcontlisti_long(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_long(2,ikont-1)+1,
     &    newcontlisti_long(2,ikont)
          do j=newcontlistj_long(1,jblock),newcontlistj_long(2,jblock)
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            fac_augm=rrij**expon
            e_augm=augm(itypi,itypj)*fac_augm
            r_inv_ij=dsqrt(rrij)
            rij=1.0D0/r_inv_ij 
            sss1=sscale(rij,r_cut_int)
            if (sss1.eq.0.0d0) cycle
            sssgrad1=sscagrad(rij,r_cut_int)
            sss=sscale(rij/sigma(itypi,itypj),r_cut_respa)
            if (sss.lt.1.0d0) then
              sssgrad=
     &          sscagrad(rij/sigma(itypi,itypj),r_cut_respa)
              r_shift_inv=1.0D0/(rij+r0(itypi,itypj)-sigma(itypi,itypj))
              fac=r_shift_inv**expon
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=e_augm+e1+e2
cd            sigm=dabs(aa(itypi,itypj)/bb(itypi,itypj))**(1.0D0/6.0D0)
cd            epsi=bb(itypi,itypj)**2/aa(itypi,itypj)
cd            write (iout,'(2(a3,i3,2x),8(1pd12.4)/2(3(1pd12.4),5x)/)')
cd   &          restyp(itypi),i,restyp(itypj),j,aa(itypi,itypj),
cd   &          bb(itypi,itypj),augm(itypi,itypj),epsi,sigm,
cd   &          sigma(itypi,itypj),1.0D0/dsqrt(rrij),evdwij,
cd   &          (c(k,i),k=1,3),(c(k,j),k=1,3)
              evdw=evdw+(1.0d0-sss)*sss1*evdwij
C 
C Calculate the components of the gradient in DC and X
C
              fac=-2.0D0*rrij*e_augm-r_inv_ij*r_shift_inv*(e1+e1+e2)
              fac=fac*(1.0d0-sss)*sss1
     &          +evdwij*(-sss1*sssgrad/sigma(itypi,itypj)
     &          +(1.0d0-sss)*sssgrad1)*r_inv_ij/expon
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=(sss1*(1.0d0-sss)/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj))))/expon
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
              do k=1,3
                gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
                gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
                gvdwc(k,i)=gvdwc(k,i)-gg(k)+gg_lipi(k)
                gvdwc(k,j)=gvdwc(k,j)+gg(k)+gg_lipj(k)
              enddo
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
      do i=1,nct
        do j=1,3
          gvdwc(j,i)=expon*gvdwc(j,i)
          gvdwx(j,i)=expon*gvdwx(j,i)
        enddo
      enddo
      return
      end
C-----------------------------------------------------------------------------
      subroutine eljk_short(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the LJK potential of interaction.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include "COMMON.SPLITELE"
      double precision gg(3)
      double precision evdw,evdwij
      integer i,j,k,itypi,itypj,itypi1,iint,ikont,jblock
      double precision xi,yi,zi,xj,yj,zj,rij,eps0ij,fac,e1,e2,rrij,
     & fac_augm,e_augm,r_inv_ij,r_shift_inv,sss1,sssgrad1
      logical scheck
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision boxshift
      double precision gg_lipi(3),gg_lipj(3)
c     print *,'Entering ELJK nnt=',nnt,' nct=',nct,' expon=',expon
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_short,g_listscsc_end_short
        i=newcontlisti_short(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_short(2,ikont-1)+1,
     &    newcontlisti_short(2,ikont)
          do j=newcontlistj_short(1,jblock),newcontlistj_short(2,jblock)
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            fac_augm=rrij**expon
            e_augm=augm(itypi,itypj)*fac_augm
            r_inv_ij=dsqrt(rrij)
            rij=1.0D0/r_inv_ij 
            sss=sscale(rij/sigma(itypi,itypj),r_cut_respa)
            if (sss.gt.0.0d0) then
              r_shift_inv=1.0D0/(rij+r0(itypi,itypj)-sigma(itypi,itypj))
              fac=r_shift_inv**expon
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=e_augm+e1+e2
cd            sigm=dabs(aa(itypi,itypj)/bb(itypi,itypj))**(1.0D0/6.0D0)
cd            epsi=bb(itypi,itypj)**2/aa(itypi,itypj)
cd            write (iout,'(2(a3,i3,2x),8(1pd12.4)/2(3(1pd12.4),5x)/)')
cd   &          restyp(itypi),i,restyp(itypj),j,aa(itypi,itypj),
cd   &          bb(itypi,itypj),augm(itypi,itypj),epsi,sigm,
cd   &          sigma(itypi,itypj),1.0D0/dsqrt(rrij),evdwij,
cd   &          (c(k,i),k=1,3),(c(k,j),k=1,3)
              evdw=evdw+sss*evdwij
C 
C Calculate the components of the gradient in DC and X
C
              fac=-2.0D0*rrij*e_augm-r_inv_ij*r_shift_inv*(e1+e1+e2)
     &            +evdwij*sssgrad/sigma(itypi,itypj)*r_inv_ij/expon
              fac=fac*sss
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=(sss/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj))))/expon
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
              do k=1,3
                gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
                gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
                gvdwc(k,i)=gvdwc(k,i)-gg(k)+gg_lipi(k)
                gvdwc(k,j)=gvdwc(k,j)+gg(k)+gg_lipj(k)
              enddo
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
      do i=1,nct
        do j=1,3
          gvdwc(j,i)=expon*gvdwc(j,i)
          gvdwx(j,i)=expon*gvdwx(j,i)
        enddo
      enddo
      return
      end
C-----------------------------------------------------------------------------
      subroutine ebp_long(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Berne-Pechukas potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include "COMMON.SPLITELE"
      integer icall
      common /srutu/ icall
      double precision evdw
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,xi,yi,zi
      double precision sss1,sssgrad1
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision boxshift
c     double precision rrsave(maxdim)
      logical lprn
      evdw=0.0D0
c     print *,'Entering EBP nnt=',nnt,' nct=',nct,' expon=',expon
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c     if (icall.eq.0) then
c       lprn=.true.
c     else
        lprn=.false.
c     endif
      ind=0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_long,g_listscsc_end_long
        i=newcontlisti_long(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_long(2,ikont-1)+1,
     &    newcontlisti_long(2,ikont)
          do j=newcontlistj_long(1,jblock),newcontlistj_long(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dxj=dc_norm(1,nres+j)
            dyj=dc_norm(2,nres+j)
            dzj=dc_norm(3,nres+j)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            rij=dsqrt(rrij)
            sss1=sscale(1.0d0/rij,r_cut_int)
            if (sss1.eq.0.0d0) cycle
            sss=sscale(1.0d0/(rij*sigmaii(itypi,itypj)),r_cut_respa)
            if (sss.lt.1.0d0) then
              sssgrad=
     &          sscagrad(1.0d0/(rij*sigmaii(itypi,itypj)),r_cut_respa)
              sssgrad1=sscagrad(1.0d0/rij,r_cut_int)
C Calculate the angle-dependent terms of energy & contributions to derivatives.
              call sc_angular
C Calculate whole angle-dependent part of epsilon and contributions
C to its derivatives
              fac=(rrij*sigsq)**expon2
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=eps1*eps2rt*eps3rt*(e1+e2)
              eps2der=evdwij*eps3rt
              eps3der=evdwij*eps2rt
              evdwij=evdwij*eps2rt*eps3rt
              evdw=evdw+evdwij*(1.0d0-sss)*sss1
              if (lprn) then
              sigm=dabs(aa/bb)**(1.0D0/6.0D0)
              epsi=bb**2/aa
cd              write (iout,'(2(a3,i3,2x),15(0pf7.3))')
cd     &          restyp(itypi),i,restyp(itypj),j,
cd     &          epsi,sigm,chi1,chi2,chip1,chip2,
cd     &          eps1,eps2rt**2,eps3rt**2,1.0D0/dsqrt(sigsq),
cd     &          om1,om2,om12,1.0D0/dsqrt(rrij),
cd     &          evdwij
              endif
C Calculate gradient components.
              e1=e1*eps1*eps2rt**2*eps3rt**2
              fac=-expon*(e1+evdwij)
              sigder=fac/sigsq
              fac=(fac+evdwij*(sss1/(1.0d0-sss)*sssgrad/
     &            sigmaii(itypi,itypj)+(1.0d0-sss)/sss1*sssgrad1))*rij
C Calculate radial part of the gradient
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &          *(eps3rt*eps3rt)*sss1*(1.0d0-sss)/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
C Calculate the angular part of the gradient and sum add the contributions
C to the appropriate components of the Cartesian gradient.
              call sc_grad_scale((1.0d0-sss)*sss1)
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
c     stop
      return
      end
C-----------------------------------------------------------------------------
      subroutine ebp_short(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Berne-Pechukas potential of interaction.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include "COMMON.SPLITELE"
      integer icall
      common /srutu/ icall
      double precision evdw
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,xi,yi,zi
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision boxshift
c     double precision rrsave(maxdim)
      logical lprn
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c     print *,'Entering EBP nnt=',nnt,' nct=',nct,' expon=',expon
c     if (icall.eq.0) then
c       lprn=.true.
c     else
        lprn=.false.
c     endif
      ind=0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_short,g_listscsc_end_short
        i=newcontlisti_short(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_short(2,ikont-1)+1,
     &    newcontlisti_short(2,ikont)
          do j=newcontlistj_short(1,jblock),newcontlistj_short(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dxj=dc_norm(1,nres+j)
            dyj=dc_norm(2,nres+j)
            dzj=dc_norm(3,nres+j)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            rij=dsqrt(rrij)
            sss=sscale(1.0d0/(rij*sigmaii(itypi,itypj)),r_cut_respa)

            if (sss.gt.0.0d0) then

C Calculate the angle-dependent terms of energy & contributions to derivatives.
              call sc_angular
C Calculate whole angle-dependent part of epsilon and contributions
C to its derivatives
              fac=(rrij*sigsq)**expon2
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=eps1*eps2rt*eps3rt*(e1+e2)
              eps2der=evdwij*eps3rt
              eps3der=evdwij*eps2rt
              evdwij=evdwij*eps2rt*eps3rt
              evdw=evdw+evdwij*sss
              if (lprn) then
              sigm=dabs(aa/bb)**(1.0D0/6.0D0)
              epsi=bb**2/aa
cd              write (iout,'(2(a3,i3,2x),15(0pf7.3))')
cd     &          restyp(itypi),i,restyp(itypj),j,
cd     &          epsi,sigm,chi1,chi2,chip1,chip2,
cd     &          eps1,eps2rt**2,eps3rt**2,1.0D0/dsqrt(sigsq),
cd     &          om1,om2,om12,1.0D0/dsqrt(rrij),
cd     &          evdwij
              endif
C Calculate gradient components.
              e1=e1*eps1*eps2rt**2*eps3rt**2
              fac=-expon*(e1+evdwij)
              sigder=fac/sigsq
              fac=(fac+evdwij*sssgrad/sss/sigmaii(itypi,itypj))*rrij
C Calculate radial part of the gradient
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=(sss/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj))))/expon
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
              do k=1,3
                gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
                gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
                gvdwc(k,i)=gvdwc(k,i)-gg(k)+gg_lipi(k)
                gvdwc(k,j)=gvdwc(k,j)+gg(k)+gg_lipj(k)
              enddo
C Calculate the angular part of the gradient and sum add the contributions
C to the appropriate components of the Cartesian gradient.
              call sc_grad_scale(sss)
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
c     stop
      return
      end
C-----------------------------------------------------------------------------
      subroutine egb_long(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Gay-Berne potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.CONTROL'
      include "COMMON.SPLITELE"
      logical lprn
      integer xshift,yshift,zshift
      double precision evdw
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,xi,yi,zi
      double precision fracinbuf,sslipi,evdwij_przed_tri,sig0ij,
     & sslipj,ssgradlipj,ssgradlipi,
     & sig,rij_shift,faclip
      double precision dist,sscale,sscagrad,sscagradlip,sscalelip
      double precision subchap,sss1,sssgrad1
      double precision boxshift,rij1
      evdw=0.0D0
ccccc      energy_dec=.false.
c     print *,'Entering EGB nnt=',nnt,' nct=',nct,' expon=',expon
      gg_lipi=0.0d0
      gg_lipj=0.0d0
      lprn=.false.
c     if (icall.eq.0) lprn=.false.
      ind=0
c      do i=iatsc_s,iatsc_e
      if (energy_dec)
     & write(2,*) "g_listscsc_start_long,g_listscsc_end_long",
     & g_listscsc_start_long,g_listscsc_end_long
      do ikont=g_listscsc_start_long,g_listscsc_end_long
        i=newcontlisti_long(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
c SCs already placed in box
c        xi=c(1,nres+i)
c        yi=c(2,nres+i)
c        zi=c(3,nres+i)
c        call to_box(xi,yi,zi)
        xi=c_tobox(1,nres+i)
        yi=c_tobox(2,nres+i)
        zi=c_tobox(3,nres+i)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
c        write (iout,*) "i",i,dsc_inv(itypi),dsci_inv,1.0d0/vbld(i+nres)
c        write (iout,*) "dcnori",dxi*dxi+dyi*dyi+dzi*dzi
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_long(2,ikont-1)+1,
     &    newcontlisti_long(2,ikont)
          do j=newcontlistj_long(1,jblock),newcontlistj_long(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
c            write (iout,*) "j",j,dsc_inv(itypj),dscj_inv,
c     &       1.0d0/vbld(j+nres)
c            write (iout,*) "i",i," j", j," itype",itype(i),itype(j)
            sig0ij=sigma(itypi,itypj)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
c SCs already placed in box
c            xj=c(1,nres+j)
c            yj=c(2,nres+j)
c            zj=c(3,nres+j)
c            call to_box(xj,yj,zj)
            xj=c_tobox(1,nres+j)
            yj=c_tobox(2,nres+j)
            zj=c_tobox(3,nres+j)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dxj=dc_norm(1,nres+j)
            dyj=dc_norm(2,nres+j)
            dzj=dc_norm(3,nres+j)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            rij=dsqrt(rrij)
            rij1=1.0d0/rij
c            sss1=sscale(1.0d0/rij,r_cut_int)
            sss1=sscale(rij1,r_cut_int)
            if (sss1.eq.0.0d0) cycle
            rij1=rij1/sigmaii(itypi,itypj)
            sss=sscale(rij1,r_cut_respa)
c            sss=sscale(1.0d0/(rij*sigmaii(itypi,itypj)),r_cut_respa)
            if (sss.lt.1.0d0) then
C Calculate angle-dependent terms of energy and contributions to their
C derivatives.
              sssgrad=
     &         sscagrad((1.0d0/rij)/sigmaii(itypi,itypj),r_cut_respa)
              sssgrad1=sscagrad(1.0d0/rij,r_cut_int)
              call sc_angular
              sigsq=1.0D0/sigsq
              sig=sig0ij*dsqrt(sigsq)
              rij_shift=1.0D0/rij-sig+sig0ij
c for diagnostics; uncomment
c              rij_shift=1.2*sig0ij
C I hate to put IF's in the loops, but here don't have another choice!!!!
              if (rij_shift.le.0.0D0) then
                evdw=1.0D20
cd                write (iout,'(2(a3,i3,2x),17(0pf7.3))')
cd     &          restyp(itypi),i,restyp(itypj),j,
cd     &          rij_shift,1.0D0/rij,sig,sig0ij,sigsq,1-dsqrt(sigsq) 
                return
              endif
              sigder=-sig*sigsq
c---------------------------------------------------------------
              rij_shift=1.0D0/rij_shift 
              fac=rij_shift**expon
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=eps1*eps2rt*eps3rt*(e1+e2)
              eps2der=evdwij*eps3rt
              eps3der=evdwij*eps2rt
c              write (iout,*) "sigsq",sigsq," sig",sig," eps2rt",eps2rt,
c     &        " eps3rt",eps3rt," eps1",eps1," e1",e1," e2",e2
              evdwij=evdwij*eps2rt*eps3rt
              evdw=evdw+evdwij*(1.0d0-sss)*sss1
              if (lprn) then
              sigm=dabs(aa/bb)**(1.0D0/6.0D0)
              epsi=bb**2/aa
              write (iout,'(2(a3,i3,2x),17(0pf7.3))')
     &          restyp(itypi),i,restyp(itypj),j,
     &          epsi,sigm,chi1,chi2,chip1,chip2,
     &          eps1,eps2rt**2,eps3rt**2,sig,sig0ij,
     &          om1,om2,om12,1.0D0/rij,1.0D0/rij_shift,
     &          evdwij
              endif

              if (energy_dec) write (iout,'(a,2i5,5f10.5,e15.5)')
     &          'r sss evdw',i,j,1.0d0/rij,sss1,sss,sslipi,sslipj,evdwij

C Calculate gradient components.
              e1=e1*eps1*eps2rt**2*eps3rt**2
              fac=-expon*(e1+evdwij)*rij_shift
              sigder=fac*sigder
              fac=rij*fac
              fac=fac+evdwij*(-sss1*sssgrad/((1.0d0-sss)
     &            *sigmaii(itypi,itypj))+(1.0d0-sss)*sssgrad1/sss1)*rij
c              fac=0.0d0
C Calculate the radial part of the gradient
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &          *(eps3rt*eps3rt)*sss1*(1.0d0-sss)/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi

C Calculate angular part of the gradient.
              call sc_grad_scale((1.0d0-sss)*sss1)
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
c      write (iout,*) "Number of loop steps in EGB:",ind
cccc      energy_dec=.false.
      return
      end
C-----------------------------------------------------------------------------
      subroutine egb_short(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Gay-Berne potential of interaction.
C
      implicit none
#ifdef MPI
      include 'mpif.h'
#endif
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.CONTROL'
      include "COMMON.SPLITELE"
      include 'COMMON.TIME1'
      logical lprn
      double precision evdw
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,xi,yi,zi
      double precision fracinbuf,sslipi,evdwij_przed_tri,sig0ij,
     & sslipj,ssgradlipj,ssgradlipi,sig,rij_shift,faclip
      double precision dist,sscale,sscagrad,sscagradlip,sscalelip
      double precision boxshift
      double precision time01
      double precision x0,y0,r012,rij12,facx0,
     &  facx02,afacx0,bfacx0,abfacx0,Afac,BBfac,Afacsig,Bfacsig
c      time01=MPI_Wtime()
      evdw=0.0D0
ccccc      energy_dec=.false.
c     print *,'Entering EGB nnt=',nnt,' nct=',nct,' expon=',expon
      gg_lipi=0.0D0
      gg_lipj=0.0d0
      lprn=.false.
c     if (icall.eq.0) lprn=.false.
      ind=0
c      do i=iatsc_s,iatsc_e
      if (energy_dec)
     & write(2,*) "g_listscsc_start_short,g_listscsc_end_short",
     & g_listscsc_start_short,g_listscsc_end_short
      do ikont=g_listscsc_start_short,g_listscsc_end_short
        i=newcontlisti_short(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
c SCs already placed in box
c        xi=c(1,nres+i)
c        yi=c(2,nres+i)
c        zi=c(3,nres+i)
c        call to_box(xi,yi,zi)
        xi=c_tobox(1,nres+i)
        yi=c_tobox(2,nres+i)
        zi=c_tobox(3,nres+i)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
c        write (iout,*) "i",i,dsc_inv(itypi),dsci_inv,1.0d0/vbld(i+nres)
c        write (iout,*) "dcnori",dxi*dxi+dyi*dyi+dzi*dzi
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_short(2,ikont-1)+1,
     &    newcontlisti_short(2,ikont)
          do j=newcontlistj_short(1,jblock),newcontlistj_short(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
c            write (iout,*) "j",j,dsc_inv(itypj),dscj_inv,
c     &       1.0d0/vbld(j+nres)
c            write (iout,*) "i",i," j", j," itype",itype(i),itype(j)
            sig0ij=sigma(itypi,itypj)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
c SCs already placed in box
c            xj=c(1,nres+j)
c            yj=c(2,nres+j)
c            zj=c(3,nres+j)
c            call to_box(xj,yj,zj)
            xj=c_tobox(1,nres+j)
            yj=c_tobox(2,nres+j)
            zj=c_tobox(3,nres+j)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
c            write (iout,*) "aa bb",aa_lip(itypi,itypj),
c     &       bb_lip(itypi,itypj),aa_aq(itypi,itypj),
c     &       bb_aq(itypi,itypj),aa,bb
c            write (iout,*) (sslipi+sslipj)/2.0d0,
c     &        (2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dxj=dc_norm(1,nres+j)
            dyj=dc_norm(2,nres+j)
            dzj=dc_norm(3,nres+j)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            rij=dsqrt(rrij)
            sss=sscale(1.0d0/(rij*sigmaii(itypi,itypj)),r_cut_respa)
            if (sss.gt.0.0d0) then
          sssgrad=sscagrad((1.0d0/rij)/sigmaii(itypi,itypj),r_cut_respa)

C Calculate angle-dependent terms of energy and contributions to their
C derivatives.
              call sc_angular
              sigsq=1.0D0/sigsq
              sig=sig0ij*dsqrt(sigsq)
              rij_shift=1.0D0/rij-sig+sig0ij
c for diagnostics; uncomment
c              rij_shift=1.2*sig0ij
C I hate to put IF's in the loops, but here don't have another choice!!!!
c              if (rij_shift.le.0.0D0) then
              x0=alpha_GB*(sig-sig0ij)
              if (energy_dec) write (iout,*) i,j," x0",x0
              if (rij_shift.le.x0) then
c                sig=2.0d0*sig0ij
                sigder=-sig*sigsq
c                sigder=0.0d0
                fac=rij**expon
                rij12=fac*fac
c                rij12=1.0d0
                x0=alpha_GB*(sig-sig0ij)
                facx0=1.0d0/x0**expon
                facx02=facx0*facx0
                r012=((1.0d0+alpha_GB)*(sig-sig0ij))**(2*expon)
                afacx0=aa*facx02
                bfacx0=bb*facx0
                abfacx0=afacx0+0.5d0*bfacx0
                Afac=alpha_GB1*abfacx0
                Afacsig=0.5d0*alpha_GB1*bfacx0/(sig-sig0ij)
                BBfac=Afac-(afacx0+bfacx0)
c                BBfac=0.0d0
                Bfacsig=(-alpha_GB1*(abfacx0+afacx0)+
     &              (afacx0+afacx0+bfacx0))/(sig-sig0ij)
c                Bfacsig=0.0d0
                Afac=Afac*r012
                Afacsig=Afacsig*r012
                e1 = eps1*eps2rt*eps3rt*Afac*rij12
                e2 = -eps1*eps2rt*eps3rt*BBfac
                evdwij = e1+e2
                eps2der=evdwij*eps3rt
                eps3der=evdwij*eps2rt
c                eps2der=0.0d0
c                eps3der=0.0d0
c                eps1_om12=0.0d0
                evdwij=evdwij*eps2rt*eps3rt
c                Afacsig=0.d0
c                Bfacsig=0.0d0
                if (lprn) then
                  write (iout,*) "aa",aa," bb",bb," sig0ij",sig0ij
                  sigm=dabs(aa/bb)**(1.0D0/6.0D0)
                  epsi=bb**2/aa
                  write (iout,'(2(a3,i3,2x),18(0pf9.5))')
     &             restyp(itypi),i,restyp(itypj),j,
     &             epsi,sigm,chi1,chi2,chip1,chip2,
     &             eps1,eps2rt**2,eps3rt**2,sig,sig0ij,
     &             eps1*eps2rt**2*eps3rt**2,om1,om2,om12,
     &             1.0D0/rij,rij_shift,
     &             evdwij
                endif
                if (energy_dec) write (iout,'(a,2i5,4f10.5,e15.5)')
     &          'RE r sss evdw',i,j,1.0d0/rij,sss,sslipi,sslipj,evdwij
                evdw=evdw+evdwij*sss
C Calculate gradient components.
                e1=e1*eps2rt*eps3rt
                sigder=-expon*eps1*eps2rt*eps2rt*eps3rt*eps3rt
     &            *(Afacsig*rij12-Bfacsig)*sigder
                fac=-2.0d0*expon*e1*rij*rij
c              print '(2i4,6f8.4)',i,j,sss,sssgrad*
c     &        evdwij,fac,sigma(itypi,itypj),expon
                fac=fac+evdwij*sssgrad/sss*rij
c                fac=0.0d0
c                write (iout,*) "sigder",sigder," fac",fac," e1",e1,
c     &              " e2",e2," sss",sss," sssgrad",sssgrad,"esp123",
c     &              eps1*eps2rt**2*eps3rt**2
C Calculate the radial part of the gradient
                gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &          *(eps3rt*eps3rt)*sss/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
                gg_lipj(3)=ssgradlipj*gg_lipi(3)
                gg_lipi(3)=gg_lipi(3)*ssgradlipi
C              gg_lipi(3)=0.0d0
C              gg_lipj(3)=0.0d0
                gg(1)=xj*fac
                gg(2)=yj*fac
                gg(3)=zj*fac
c                evdw=1.0D20
cd                write (iout,'(2(a3,i3,2x),17(0pf7.3))')
cd     &          restyp(itypi),i,restyp(itypj),j,
cd     &          rij_shift,1.0D0/rij,sig,sig0ij,sigsq,1-dsqrt(sigsq) 
c                return
c              endif
              else
                sigder=-sig*sigsq
c---------------------------------------------------------------
                rij_shift=1.0D0/rij_shift 
                fac=rij_shift**expon
                faclip=fac
                e1=fac*fac*aa
                e2=fac*bb
                evdwij=eps1*eps2rt*eps3rt*(e1+e2)
                eps2der=evdwij*eps3rt
                eps3der=evdwij*eps2rt
c                write (iout,*) "sigsq",sigsq," sig",sig," eps2rt",eps2rt,
c     &        " eps3rt",eps3rt," eps1",eps1," e1",e1," e2",e2
                evdwij=evdwij*eps2rt*eps3rt
                evdw=evdw+evdwij*sss
                if (lprn) then
                sigm=dabs(aa/bb)**(1.0D0/6.0D0)
                epsi=bb**2/aa
                write (iout,'(2(a3,i3,2x),17(0pf7.3))')
     &            restyp(itypi),i,restyp(itypj),j,
     &            epsi,sigm,chi1,chi2,chip1,chip2,
     &            eps1,eps2rt**2,eps3rt**2,sig,sig0ij,
     &            om1,om2,om12,1.0D0/rij,1.0D0/rij_shift,
     &            evdwij
                endif

                if (energy_dec) write (iout,'(a,2i5,4f10.5,e15.5)')
     &          'r sss evdw',i,j,1.0d0/rij,sss,sslipi,sslipj,evdwij

C Calculate gradient components.
                e1=e1*eps1*eps2rt**2*eps3rt**2
                fac=-expon*(e1+evdwij)*rij_shift
                sigder=fac*sigder
                fac=rij*fac
                fac=fac+evdwij*sssgrad/(sss*sigmaii(itypi,itypj))*rij
c                fac=0.0d0
C Calculate the radial part of the gradient
                gg(1)=xj*fac
                gg(2)=yj*fac
                gg(3)=zj*fac
                gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &            *(eps3rt*eps3rt)*sss/2.0d0*(faclip*faclip*
     &             (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &            +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
                gg_lipj(3)=ssgradlipj*gg_lipi(3)
                gg_lipi(3)=gg_lipi(3)*ssgradlipi
c                write (iout,*) "gglip",i,j,gg_lipi,gg_lipj
              endif
C Calculate angular part of the gradient.
              call sc_grad_scale(sss)
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
c      time_evdw_short=time_evdw_short+MPI_Wtime()-time01
c      write (iout,*) "Number of loop steps in EGB:",ind
cccc      energy_dec=.false.
      return
      end
C-----------------------------------------------------------------------------
      subroutine egbv_long(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Gay-Berne-Vorobjev potential of interaction.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include "COMMON.SPLITELE"
      integer icall
      common /srutu/ icall
      logical lprn
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,r0ij,
     & xi,yi,zi,fac_augm,e_augm
      double precision fracinbuf,sslipi,evdwij_przed_tri,sig0ij,
     & sslipj,ssgradlipj,ssgradlipi,
     & sig,rij_shift,faclip
      double precision dist,sscale,sscagrad,sscagradlip,sscalelip
      double precision sss1,sssgrad1
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c     print *,'Entering EGB nnt=',nnt,' nct=',nct,' expon=',expon
      lprn=.false.
c     if (icall.eq.0) lprn=.true.
      ind=0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_long,g_listscsc_end_long
        i=newcontlisti_long(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_long(2,ikont-1)+1,
     &    newcontlisti_long(2,ikont)
          do j=newcontlistj_long(1,jblock),newcontlistj_long(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
            sig0ij=sigma(itypi,itypj)
            r0ij=r0(itypi,itypj)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &       +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &       +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dxj=dc_norm(1,nres+j)
            dyj=dc_norm(2,nres+j)
            dzj=dc_norm(3,nres+j)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            rij=dsqrt(rrij)

            sss1=sscale(1.0d0/rij,r_cut_int)
            if (sss1.eq.0.0d0) cycle

            if (sss.lt.1.0d0) then
              sssgrad=
     &         sscagrad((1.0d0/rij)/sigmaii(itypi,itypj),r_cut_respa)
              sssgrad1=sscagrad(1.0d0/rij,r_cut_int)

C Calculate angle-dependent terms of energy and contributions to their
C derivatives.
              call sc_angular
              sigsq=1.0D0/sigsq
              sig=sig0ij*dsqrt(sigsq)
              rij_shift=1.0D0/rij-sig+r0ij
C I hate to put IF's in the loops, but here don't have another choice!!!!
              if (rij_shift.le.0.0D0) then
                evdw=1.0D20
                return
              endif
              sigder=-sig*sigsq
c---------------------------------------------------------------
              rij_shift=1.0D0/rij_shift 
              fac=rij_shift**expon
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=eps1*eps2rt*eps3rt*(e1+e2)
              eps2der=evdwij*eps3rt
              eps3der=evdwij*eps2rt
              fac_augm=rrij**expon
              e_augm=augm(itypi,itypj)*fac_augm
              evdwij=evdwij*eps2rt*eps3rt
              evdw=evdw+(evdwij+e_augm)*sss1*(1.0d0-sss)
              if (lprn) then
              sigm=dabs(aa/bb)**(1.0D0/6.0D0)
              epsi=bb**2/aa
              write (iout,'(2(a3,i3,2x),17(0pf7.3))')
     &          restyp(itypi),i,restyp(itypj),j,
     &          epsi,sigm,sig,(augm(itypi,itypj)/epsi)**(1.0D0/12.0D0),
     &          chi1,chi2,chip1,chip2,
     &          eps1,eps2rt**2,eps3rt**2,
     &          om1,om2,om12,1.0D0/rij,1.0D0/rij_shift,
     &          evdwij+e_augm
              endif
C Calculate gradient components.
              e1=e1*eps1*eps2rt**2*eps3rt**2
              fac=-expon*(e1+evdwij)*rij_shift
              sigder=fac*sigder
              fac=rij*fac-2*expon*rrij*e_augm
              fac=fac+(evdwij+e_augm)*
     &           (-sss1*sssgrad/(1.0d0-sss)/sigmaii(itypi,itypj)
     &            +(1.0d0-sss)*sssgrad1/sss1)*rij
C Calculate the radial part of the gradient
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &          *(eps3rt*eps3rt)*sss1*(1.0d0-sss)/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
C Calculate angular part of the gradient.
              call sc_grad_scale((1.0d0-sss)*sss1)
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
      end
C-----------------------------------------------------------------------------
      subroutine egbv_short(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Gay-Berne-Vorobjev potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include "COMMON.SPLITELE"
      integer icall
      common /srutu/ icall
      logical lprn
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,r0ij,
     & xi,yi,zi,fac_augm,e_augm
      double precision evdw
      double precision fracinbuf,sslipi,evdwij_przed_tri,sig0ij,
     & sslipj,ssgradlipj,ssgradlipi,
     & sig,rij_shift,faclip
      double precision dist,sscale,sscagrad,sscagradlip,sscalelip
      double precision boxshift
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c     print *,'Entering EGB nnt=',nnt,' nct=',nct,' expon=',expon
      lprn=.false.
c     if (icall.eq.0) lprn=.true.
      ind=0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start_short,g_listscsc_end_short
        i=newcontlisti_short(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
C
C Calculate SC interaction energy.
C
        do jblock=newcontlisti_short(2,ikont-1)+1,
     &    newcontlisti_short(2,ikont)
          do j=newcontlistj_short(1,jblock),newcontlistj_short(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
            sig0ij=sigma(itypi,itypj)
            r0ij=r0(itypi,itypj)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &       +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &       +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dxj=dc_norm(1,nres+j)
            dyj=dc_norm(2,nres+j)
            dzj=dc_norm(3,nres+j)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            rij=dsqrt(rrij)

            sss=sscale(1.0d0/(rij*sigmaii(itypi,itypj)),r_cut_respa)

            if (sss.gt.0.0d0) then

C Calculate angle-dependent terms of energy and contributions to their
C derivatives.
              call sc_angular
              sigsq=1.0D0/sigsq
              sig=sig0ij*dsqrt(sigsq)
              rij_shift=1.0D0/rij-sig+r0ij
C I hate to put IF's in the loops, but here don't have another choice!!!!
              if (rij_shift.le.0.0D0) then
                evdw=1.0D20
                return
              endif
              sigder=-sig*sigsq
c---------------------------------------------------------------
              rij_shift=1.0D0/rij_shift 
              fac=rij_shift**expon
              faclip=fac
              e1=fac*fac*aa
              e2=fac*bb
              evdwij=eps1*eps2rt*eps3rt*(e1+e2)
              eps2der=evdwij*eps3rt
              eps3der=evdwij*eps2rt
              fac_augm=rrij**expon
              e_augm=augm(itypi,itypj)*fac_augm
              evdwij=evdwij*eps2rt*eps3rt
              evdw=evdw+(evdwij+e_augm)*sss
              if (lprn) then
              sigm=dabs(aa/bb)**(1.0D0/6.0D0)
              epsi=bb**2/aa
              write (iout,'(2(a3,i3,2x),17(0pf7.3))')
     &          restyp(itypi),i,restyp(itypj),j,
     &          epsi,sigm,sig,(augm(itypi,itypj)/epsi)**(1.0D0/12.0D0),
     &          chi1,chi2,chip1,chip2,
     &          eps1,eps2rt**2,eps3rt**2,
     &          om1,om2,om12,1.0D0/rij,1.0D0/rij_shift,
     &          evdwij+e_augm
              endif
C Calculate gradient components.
              e1=e1*eps1*eps2rt**2*eps3rt**2
              fac=-expon*(e1+evdwij)*rij_shift
              sigder=fac*sigder
              fac=rij*fac-2*expon*rrij*e_augm+
     &          (evdwij+e_augm)*sssgrad/sigmaii(itypi,itypj)/sss*rij
C Calculate the radial part of the gradient
              gg(1)=xj*fac
              gg(2)=yj*fac
              gg(3)=zj*fac
              gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &          *(eps3rt*eps3rt)*sss/2.0d0*(faclip*faclip*
     &           (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &          +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
              gg_lipj(3)=ssgradlipj*gg_lipi(3)
              gg_lipi(3)=gg_lipi(3)*ssgradlipi
C Calculate angular part of the gradient.
              call sc_grad_scale(sss)
            endif
          enddo      ! j
        enddo        ! iblock
      enddo          ! ikont
      end
C----------------------------------------------------------------------------
      subroutine sc_grad_scale(scalfac)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.CALC'
      include 'COMMON.IOUNITS'
      include "COMMON.SPLITELE"
      double precision dcosom1(3),dcosom2(3)
      double precision scalfac
      eom1=eps2der*eps2rt_om1-2.0D0*alf1*eps3der+sigder*sigsq_om1
      eom2=eps2der*eps2rt_om2+2.0D0*alf2*eps3der+sigder*sigsq_om2
      eom12=evdwij*eps1_om12+eps2der*eps2rt_om12
     &     -2.0D0*alf12*eps3der+sigder*sigsq_om12
c diagnostics only
c      eom1=0.0d0
c      eom2=0.0d0
c      eom12=evdwij*eps1_om12
c end diagnostics
c      write (iout,*) "eps2der",eps2der," eps3der",eps3der,
c     &  " sigder",sigder
c      write (iout,*) "eps1_om12",eps1_om12," eps2rt_om12",eps2rt_om12
c      write (iout,*) "eom1",eom1," eom2",eom2," eom12",eom12
      do k=1,3
        dcosom1(k)=rij*(dc_norm(k,nres+i)-om1*erij(k))
        dcosom2(k)=rij*(dc_norm(k,nres+j)-om2*erij(k))
      enddo
      do k=1,3
        gg(k)=(gg(k)+eom1*dcosom1(k)+eom2*dcosom2(k))*scalfac
      enddo 
c      write (iout,*) "gg",(gg(k),k=1,3)
      do k=1,3
        gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
     &            +(eom12*(dc_norm(k,nres+j)-om12*dc_norm(k,nres+i))
     &          +eom1*(erij(k)-om1*dc_norm(k,nres+i)))*dsci_inv*scalfac
        gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
     &            +(eom12*(dc_norm(k,nres+i)-om12*dc_norm(k,nres+j))
     &          +eom2*(erij(k)-om2*dc_norm(k,nres+j)))*dscj_inv*scalfac
c        write (iout,*)(eom12*(dc_norm(k,nres+j)-om12*dc_norm(k,nres+i))
c     &            +eom1*(erij(k)-om1*dc_norm(k,nres+i)))*dsci_inv
c        write (iout,*)(eom12*(dc_norm(k,nres+i)-om12*dc_norm(k,nres+j))
c     &            +eom2*(erij(k)-om2*dc_norm(k,nres+j)))*dscj_inv
      enddo
C 
C Calculate the components of the gradient in DC and X
C
c      write (iout,*) "scgrad gglip",i,j,gg_lipi,gg_lipj
      do l=1,3
        gvdwc(l,i)=gvdwc(l,i)-gg(l)+gg_lipi(l)
        gvdwc(l,j)=gvdwc(l,j)+gg(l)+gg_lipj(l)
      enddo
      return
      end
C--------------------------------------------------------------------------
      subroutine eelec_scale(ees,evdw1,eel_loc,eello_turn3,eello_turn4)
C
C This subroutine calculates the average interaction energy and its gradient
C in the virtual-bond vectors between non-adjacent peptide groups, based on 
C the potential described in Liwo et al., Protein Sci., 1993, 2, 1715. 
C The potential depends both on the distance of peptide-group centers and on 
C the orientation of the CA-CA virtual bonds.
C 
      implicit real*8 (a-h,o-z)
#ifdef MPI
      include 'mpif.h'
#else
      double precision tcpu
#endif
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.SETUP'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.CORRMAT'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      include 'COMMON.TIME1'
#ifdef SHIELD
      include 'COMMON.SHIELD'
#endif
      include 'COMMON.SPLITELE'
      include 'COMMON.LOCEL'
      include 'COMMON.LIPCALC'
      include 'COMMON.SCALESAVE'
      integer ikont,jblock
      dimension ggg(3),gggp(3),gggm(3),erij(3),dcosb(3),dcosg(3),
     &          erder(3,3),uryg(3,3),urzg(3,3),vryg(3,3),vrzg(3,3)
      double precision muij(4)
      integer*1 doturn(maxres)
      common /eelecscalecommon/doturn
c 4/26/02 - AL scaling factor for 1,4 repulsive VDW interactions
#ifdef MOMENT
      double precision scal_el /1.0d0/
#else
      double precision scal_el /0.5d0/
#endif
C 12/13/98 
C 13-go grudnia roku pamietnego... 
      logical tail_agg
c If the electrostatic contributions were calculated, just copy them
c      write (iout,*) "Calling eelec_scale last_split",last_split
      if (last_split) then
        evdw1=evdwpp_save
        ees=ees_save
        eel_loc=eel_loc_save
        eello_turn3=eello_turn3_save
        eello_turn4=eello_turn4_save
        gvdwpp(:,:nres)=gvdwpp_save(:,:nres)
        gelc(:,:nres)=gelc_save(:,:nres)
        gelc_long(:,:nres)=gelc_long_save(:,:nres)
        gel_loc(:,:nres)=gel_loc_save(:,:nres)
        gel_loc_long(:,:nres)=gel_loc_long_save(:,:nres)
        gcorr3_turn(:,:nres)=gcorr3_turn_save(:,:nres)
        gcorr4_turn(:,:nres)=gcorr4_turn_save(:,:nres)
        return
      endif
      if (icheckgrad.eq.1) then
        do i=1,nres-1
          fac=1.0d0/dsqrt(scalar(dc(1,i),dc(1,i)))
          do k=1,3
            dc_norm(k,i)=dc(k,i)*fac
          enddo
c          write (iout,*) 'i',i,' fac',fac
        enddo
      endif
      if (wel_loc.gt.0.0d0 .or. wcorr4.gt.0.0d0 .or. wcorr5.gt.0.0d0 
     &    .or. wcorr6.gt.0.0d0 .or. wturn3.gt.0.0d0 .or. 
     &    wturn4.gt.0.0d0 .or. wturn6.gt.0.0d0) then
c        call vec_and_deriv
#ifdef TIMING
#ifdef MPI
        time01=MPI_Wtime()
#else
        time01=tcpu()
#endif
#endif
        call set_matrices
#ifdef TIMING
#ifdef MPI
        time_mat=time_mat+MPI_Wtime()-time01
#else
        time_mat=time_mat+tcpu()-time01
#endif
#endif
      endif
cd      do i=1,nres-1
cd        write (iout,*) 'i=',i
cd        do k=1,3
cd        write (iout,'(i5,2f10.5)') k,uy(k,i),uz(k,i)
cd        enddo
cd        do k=1,3
cd          write (iout,'(f10.5,2x,3f10.5,2x,3f10.5)') 
cd     &     uz(k,i),(uzgrad(k,l,1,i),l=1,3),(uzgrad(k,l,2,i),l=1,3)
cd        enddo
cd      enddo
      t_eelecij=0.0d0
      ees=0.0D0
      evdw1=0.0D0
      eel_loc=0.0d0 
      eello_turn3=0.0d0
      eello_turn4=0.0d0
      ind=0
cd      print '(a)','Enter EELEC'
cd      write (iout,*) 'iatel_s=',iatel_s,' iatel_e=',iatel_e
c      do i=1,nres
c        gel_loc_loc(i)=0.0d0
c        gcorr_loc(i)=0.0d0
c      enddo
c
c
c 9/27/08 AL Split the interaction loop to ensure load balancing of turn terms
C
C Loop over i,i+2 and i,i+3 pairs of the peptide groups
C
      tail_agg=(wturn3.gt.0.0d0)
      doturn(1:nres)=0
      do i=iturn3_start,iturn3_end
        if (itype(i).eq.ntyp1.or. itype(i+1).eq.ntyp1
     &  .or. itype(i+2).eq.ntyp1 .or. itype(i+3).eq.ntyp1
C     &  .or. itype(i-1).eq.ntyp1
C     &  .or. itype(i+4).eq.ntyp1
     &   ) cycle
c        dxi=dc(1,i)
c        dyi=dc(2,i)
c        dzi=dc(3,i)
c        dx_normi=dc_norm(1,i)
c        dy_normi=dc_norm(2,i)
c        dz_normi=dc_norm(3,i)
c peptide groups already placed in box
c        xmedi=c(1,i)+0.5d0*dxi
c        ymedi=c(2,i)+0.5d0*dyi
c        zmedi=c(3,i)+0.5d0*dzi
c        call to_box(xmedi,ymedi,zmedi)
c        xmedi=cp(1,i)
c        ymedi=cp(2,i)
c        zmedi=cp(3,i)
c        call lipid_layer(xmedi,ymedi,zmedi,sslipi,ssgradlipi)
c        num_conti=0
c        call eelecij_scale(i,i+2,ees,evdw1,eel_loc,tail_agg)
c        if (tail_agg) call eturn3(i,eello_turn3)
        call eelecij_scale(i,i+2,ees,evdw1,eel_loc)
        if  (tail_agg) doturn(i)=or(doturn(i),1)
      enddo
      do i=iturn4_start,iturn4_end
        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1
     &    .or. itype(i+3).eq.ntyp1
     &    .or. itype(i+4).eq.ntyp1
C     &    .or. itype(i+5).eq.ntyp1
C     &    .or. itype(i-1).eq.ntyp1
     &    ) cycle
c        dxi=dc(1,i)
c        dyi=dc(2,i)
c        dzi=dc(3,i)
c        dx_normi=dc_norm(1,i)
c        dy_normi=dc_norm(2,i)
c        dz_normi=dc_norm(3,i)
c peptide groups already placed in box
c        xmedi=c(1,i)+0.5d0*dxi
c        ymedi=c(2,i)+0.5d0*dyi
c        zmedi=c(3,i)+0.5d0*dzi
c        call to_box(xmedi,ymedi,zmedi)
c        xmedi=cp(1,i)
c        ymedi=cp(2,i)
c        zmedi=cp(3,i)
c        call lipid_layer(xmedi,ymedi,zmedi,sslipi,ssgradlipi)
        tail_agg=(wturn4.gt.0.0d0 .and. itype(i+2).ne.ntyp1)
c        call eelecij_scale(i,i+3,ees,evdw1,eel_loc,tail_agg)
c        if (tail_agg) call eturn4(i,eello_turn4)
        call eelecij_scale(i,i+3,ees,evdw1,eel_loc)
        if (tail_agg) doturn(i)=or(doturn(i),2)
      enddo   ! i
      call calculate_turns(doturn,eello_turn3,eello_turn4)
c
c Loop over all pairs of interacting peptide groups except i,i+2 and i,i+3
c
c      do i=iatel_s,iatel_e
      if (energy_dec)
     & write(iout,*) "g_listpp_start,g_listpp_end",
     & g_listpp_start,g_listpp_end
      do ikont=g_listpp_start,g_listpp_end
        i=newcontlistppi(1,ikont)
c        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1
c     &) cycle
c        dxi=dc(1,i)
c        dyi=dc(2,i)
c        dzi=dc(3,i)
c        dx_normi=dc_norm(1,i)
c        dy_normi=dc_norm(2,i)
c        dz_normi=dc_norm(3,i)
c peptide groups already placed in box
c        xmedi=c(1,i)+0.5d0*dxi
c        ymedi=c(2,i)+0.5d0*dyi
c        zmedi=c(3,i)+0.5d0*dzi
c        call to_box(xmedi,ymedi,zmedi)
c        xmedi=cp(1,i)
c        ymedi=cp(2,i)
c        zmedi=cp(3,i)
c        call lipid_layer(xmedi,ymedi,zmedi,sslipi,ssgradlipi)
c        write (iout,*) 'i',i,' ielstart',ielstart(i),' ielend',ielend
        do jblock=newcontlistppi(2,ikont-1)+1,newcontlistppi(2,ikont)
        do j=newcontlistppj(1,jblock),newcontlistppj(2,jblock)
c        do j=ielstart(i),ielend(i)
c          if (itype(j).eq.ntyp1 .or. itype(j+1).eq.ntyp1
c     &) cycle
c          call eelecij_scale(i,j,ees,evdw1,eel_loc,tail_agg)
          call eelecij_scale(i,j,ees,evdw1,eel_loc)
        enddo ! j
        enddo ! jblock
      enddo   ! ikont
c      write (iout,*) "Number of loop steps in EELEC:",ind
cd      do i=1,nres
cd        write (iout,'(i3,3f10.5,5x,3f10.5)') 
cd     &     i,(gel_loc(k,i),k=1,3),gel_loc_loc(i)
cd      enddo
c 12/7/99 Adam eello_turn3 will be considered as a separate energy term
ccc      eel_loc=eel_loc+eello_turn3
cd      print *,"Processor",fg_rank," t_eelecij",t_eelecij
      return
      end
C-------------------------------------------------------------------------------
c      subroutine eelecij_scale(i,j,ees,evdw1,eel_loc,tail_agg)
      subroutine eelecij_scale(i,j,ees,evdw1,eel_loc)
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include "mpif.h"
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.CORRMAT'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      include 'COMMON.TIME1'
#ifdef SHIELD
      include 'COMMON.SHIELD'
#endif
      include 'COMMON.SPLITELE'
      include 'COMMON.LOCEL'
      include 'COMMON.LIPCALC'
      integer xshift,yshift,zshift
      double precision muimuj,muier,mujer,xyzj(3),auxvec(3)
      double precision ggg(3),gggp(3),gggm(3),erij(3),dcosb(3),dcosg(3)
      integer k,i,j,iteli,itelj,kkk,l,kkll,m,isubchap,ind,itypi,itypj
#ifdef SHIELD
      integer ilist,iresshield
      double precision rlocshield
#endif
      double precision ael6i,rrmij,rmij,r0ij,fcont,fprimcont,ees0tmp
      double precision ees,evdw1,eel_loc,aaa,bbb,ael3i
      double precision rij,r3ij,r6ij,cosa,cosb,cosg,fac,ev1,ev2,fac3,
     &  fac4,
     &  evdwij,el1,el2,eesij,facvdw,facel,fac1,ecosa,
     &  ecosb,ecosg,
     &  eel_loc_ij,cosa4,wij,cosbg1,cosbg2,
     &  ecosa1,ecosb1,ecosg1,ecosa2,ecosb2,ecosg2,ecosap,ecosbp,
     &  ecosgp,ecosam,ecosbm,ecosgm,ghalf,geel_loc_ij,geel_loc_ji
      double precision aux
      double precision sss1,sssgrad1
      double precision sscale,sscagrad
      double precision scalar
      double precision boxshift
      double precision faclipij2
c 4/26/02 - AL scaling factor for 1,4 repulsive VDW interactions
#ifdef MOMENT
      double precision scal_el /1.0d0/
#else
      double precision scal_el /0.5d0/
#endif
C 12/13/98 
C 13-go grudnia roku pamietnego... 
c          time00=MPI_Wtime()
cd      write (iout,*) "eelecij",i,j
C      print *,"WCHODZE2"
      call wrapvec(cp(:,j)-cp(:,i), xyzj)
      rij=scalar(xyzj,xyzj)
      if(rij.ge.r_cut_int_sq) return

      iteli=itel(i)
      itelj=itel(j)
      if (j.eq.i+2 .and. itelj.eq.2) iteli=2
      aaa=app(iteli,itelj)
      bbb=bpp(iteli,itelj)
      ael6i=ael6(iteli,itelj)
      ael3i=ael3(iteli,itelj) 
      call lipid_layer(cp(1,i),cp(2,i),cp(3,i),sslipi,ssgradlipi)
      call lipid_layer(cp(1,j),cp(2,j),cp(3,j),sslipj,ssgradlipj)
      faclipij=(sslipi+sslipj)/2.0d0*lipscale+1.0d0
      faclipij2=(sslipi+sslipj)/2.0d0*lipscale**2+1.0d0
      rrmij=1.0D0/rij
      rij=dsqrt(rij)
      rmij=1.0D0/rij
      r3ij=rrmij*rmij
      r6ij=r3ij*r3ij  
c For extracting the short-range part of Evdwpp
      sss1=sscale(rij,r_cut_int)
      sss=sscale(rij/rpp(iteli,itelj),r_cut_respa)
      sssgrad=sscagrad(rij/rpp(iteli,itelj),r_cut_respa)
      sssgrad1=sscagrad(rij,r_cut_int)
c      cosa=dx_normi*dx_normj+dy_normi*dy_normj+dz_normi*dz_normj
c      cosb=(xj*dx_normi+yj*dy_normi+zj*dz_normi)*rmij
c      cosg=(xj*dx_normj+yj*dy_normj+zj*dz_normj)*rmij
      cosa=scalar(dc_norm(:,i),dc_norm(:,j))
      cosb=scalar(xyzj,dc_norm(:,i))*rmij
      cosg=scalar(xyzj,dc_norm(:,j))*rmij
      fac=cosa-3.0D0*cosb*cosg
c 1/03/22 AL: don't compute short-range VDW pp energy
      evdwij=0.0d0
      facvdw=0.0d0
      if (sss.lt.1.0d0) then
        ev1=aaa*r6ij*r6ij !to move
c 4/26/02 - AL scaling down 1,4 repulsive VDW interactions ! to move
        if (j.eq.i+2) ev1=scal_el*ev1 ! to move
        ev2=bbb*r6ij ! to move
        evdwij=ev1+ev2 ! to move
        evdw1=evdw1+evdwij*(1.0d0-sss)*sss1*faclipij2 ! to move
        facvdw=-6*rrmij*(ev1+evdwij)*(1.0d0-sss)*sss1
      endif ! to move
      fac3=ael6i*r6ij
      fac4=ael3i*r3ij
#ifdef SHIELD
      if (shield_mode.eq.0) then
        fac_shield(i)=1.0
        fac_shield(j)=1.0
      endif
#endif
      el1=fac3*(4.0D0+fac*fac-3.0D0*(cosb*cosb+cosg*cosg))
      el2=fac4*fac       
#ifdef SHIELD
      el1=el1*fac_shield(i)**2*fac_shield(j)**2
      el2=el2*fac_shield(i)**2*fac_shield(j)**2
#endif
      eesij=el1+el2
C 12/26/95 - for the evaluation of multi-body H-bonding interactions
c      ees0ij=4.0D0+fac*fac-3.0D0*(cosb*cosb+cosg*cosg)
      ees=ees+eesij*sss1*faclipij2
cd          write(iout,'(2(2i3,2x),7(1pd12.4)/2(3(1pd12.4),5x)/)')
cd     &      iteli,i,itelj,j,aaa,bbb,ael6i,ael3i,
cd     &      1.0D0/dsqrt(rrmij),evdwij,eesij,
cd     &      xmedi,ymedi,zmedi,xj,yj,zj

#ifdef SHIELD
      if (energy_dec) then 
        write (iout,'(a6,2i5,0pf7.3,2i5,e11.3,5f10.5)')
     &  'evdw1',i,j,evdwij,iteli,itelj,aaa,sss,sss1,sssgrad,sssgrad1,rij
        write (iout,'(a6,2i5,0pf7.3,6f8.5)') 'ees',i,j,eesij,
     &  fac_shield(i),fac_shield(j),sslipi,sslipj,faclipij,faclipij2
      endif
#else
      if (energy_dec) then 
        write (iout,'(a6,2i5,0pf7.3,2i5,e11.3,5f10.5)')
     &  'evdw1',i,j,evdwij,iteli,itelj,aaa,sss,sss1,sssgrad,sssgrad1,rij
        write (iout,'(a6,2i5,0pf7.3,6f8.5)') 'ees',i,j,eesij,
     &  sslipi,sslipj,faclipij,faclipij2
      endif
#endif
C
C Calculate contributions to the Cartesian gradient.
C
      facel=-3*rrmij*(el1+eesij)*sss1
      fac1=fac
      call scalevec(xyzj,rmij,erij)
*
* Radial derivatives. First process both termini of the fragment (i,j)
*
c old      aux=(facel+sssgrad1*(1.0d0-sss)*eesij*rmij)*faclipij2
      aux=(facel+sssgrad1*eesij*rmij)*faclipij2
c     & *((sslipi+sslipj)/2.0d0*lipscale**2+1.0d0)
      call scalevec(xyzj,aux,ggg)
#ifdef SHIELD
      if ((fac_shield(i).gt.0).and.(fac_shield(j).gt.0).and.
     &  (shield_mode.gt.0)) then
C          print *,i,j     
        do ilist=1,ishield_list(i)
          iresshield=shield_list(ilist,i)
          do k=1,3
           rlocshield=grad_shield_side(k,ilist,i)*eesij*sss1
     &      /fac_shield(i)*2.0*sss1
           gshieldx(k,iresshield)=gshieldx(k,iresshield)+
     &              rlocshield
     &     +grad_shield_loc(k,ilist,i)*eesij*sss1/fac_shield(i)*2.0
     &      *sss1
            gshieldc(k,iresshield-1)=gshieldc(k,iresshield-1)+rlocshield
          enddo
        enddo
        do ilist=1,ishield_list(j)
          iresshield=shield_list(ilist,j)
          do k=1,3
           rlocshield=grad_shield_side(k,ilist,j)*eesij/fac_shield(j)
     &     *2.0*sss1
           gshieldx(k,iresshield)=gshieldx(k,iresshield)+
     &        rlocshield
     &        +grad_shield_loc(k,ilist,j)*eesij/fac_shield(j)*2.0*sss1
           gshieldc(k,iresshield-1)=gshieldc(k,iresshield-1)+rlocshield
          enddo
        enddo

        do k=1,3
           gshieldc(k,i)=gshieldc(k,i)+
     &             grad_shield(k,i)*eesij/fac_shield(i)*2.0*sss1
           gshieldc(k,j)=gshieldc(k,j)+
     &             grad_shield(k,j)*eesij/fac_shield(j)*2.0*sss1
           gshieldc(k,i-1)=gshieldc(k,i-1)+
     &             grad_shield(k,i)*eesij/fac_shield(i)*2.0*sss1
           gshieldc(k,j-1)=gshieldc(k,j-1)+
     &             grad_shield(k,j)*eesij/fac_shield(j)*2.0*sss1

        enddo
      endif
#endif
c          do k=1,3
c            ghalf=0.5D0*ggg(k)
c            gelc(k,i)=gelc(k,i)+ghalf
c            gelc(k,j)=gelc(k,j)+ghalf
c          enddo
c 9/28/08 AL Gradient compotents will be summed only at the end
      do k=1,3
        gelc_long(k,j)=gelc_long(k,j)+ggg(k)
        gelc_long(k,i)=gelc_long(k,i)-ggg(k)
      enddo
      gelc_long(3,j)=gelc_long(3,j)+
     &  ssgradlipj*eesij/2.0d0*lipscale**2*sss1
      gelc_long(3,i)=gelc_long(3,i)+
     &  ssgradlipi*eesij/2.0d0*lipscale**2*sss1
c      gelc_long(3,i)=gelc_long(3,i)+
c        ssgradlipi*eesij/2.0d0*lipscale**2*sss1
c
c 3/1/22 AL: exclude short-range vdw contributions to gradient.
c
      if (sss.lt.1.0d0) then

      facvdw=(facvdw+
     &(-sss1*sssgrad/rpp(iteli,itelj)+(1.0d0-sss)*sssgrad1)*rmij*evdwij)
     &   *faclipij2
      ggg(1)=facvdw*xyzj(1)
      ggg(2)=facvdw*xyzj(2)
      ggg(3)=facvdw*xyzj(3)
c 9/28/08 AL Gradient compotents will be summed only at the end
      do k=1,3
        gvdwpp(k,j)=gvdwpp(k,j)+ggg(k)
        gvdwpp(k,i)=gvdwpp(k,i)-ggg(k)
      enddo
!C Lipidic part for scaling weight
        gvdwpp(3,j)=gvdwpp(3,j)+
     &    sss1*(1.0d0-sss)*ssgradlipj*evdwij/2.0d0*lipscale**2
        gvdwpp(3,i)=gvdwpp(3,i)+
     &    sss1*(1.0d0-sss)*ssgradlipi*evdwij/2.0d0*lipscale**2

      endif
*
* Angular part
*          
      ecosa=2.0D0*fac3*fac1+fac4
      fac4=-3.0D0*fac4
      fac3=-6.0D0*fac3
      ecosb=(fac3*(fac1*cosg+cosb)+cosg*fac4)
      ecosg=(fac3*(fac1*cosb+cosg)+cosb*fac4)
      do k=1,3
        dcosb(k)=rmij*(dc_norm(k,i)-erij(k)*cosb)
        dcosg(k)=rmij*(dc_norm(k,j)-erij(k)*cosg)
      enddo
cd        print '(2i3,2(3(1pd14.5),3x))',i,j,(dcosb(k),k=1,3),
cd   &          (dcosg(k),k=1,3)
      do k=1,3
        ggg(k)=(ecosb*dcosb(k)+ecosg*dcosg(k))*sss1
     &  *faclipij2
#ifdef SHIELD
     &      *fac_shield(i)**2*fac_shield(j)**2
#endif
c     &  *((sslipi+sslipj)/2.0d0*lipscale**2+1.0d0)

      enddo
c          do k=1,3
c            ghalf=0.5D0*ggg(k)
c            gelc(k,i)=gelc(k,i)+ghalf
c     &               +(ecosa*(dc_norm(k,j)-cosa*dc_norm(k,i))
c     &               + ecosb*(erij(k)-cosb*dc_norm(k,i)))*vbld_inv(i+1)
c            gelc(k,j)=gelc(k,j)+ghalf
c     &               +(ecosa*(dc_norm(k,i)-cosa*dc_norm(k,j))
c     &               + ecosg*(erij(k)-cosg*dc_norm(k,j)))*vbld_inv(j+1)
c          enddo
cgrad          do k=i+1,j-1
cgrad            do l=1,3
cgrad              gelc(l,k)=gelc(l,k)+ggg(l)
cgrad            enddo
cgrad          enddo
      do k=1,3
        gelc(k,i)=gelc(k,i)
     &           +((ecosa*(dc_norm(k,j)-cosa*dc_norm(k,i))
     &           +ecosb*(erij(k)-cosb*dc_norm(k,i)))*vbld_inv(i+1))*sss1
     &       *faclipij2
#ifdef SHIELD
     &      *fac_shield(i)**2*fac_shield(j)**2
#endif
c     &       *((sslipi+sslipj)/2.0d0*lipscale**2+1.0d0)

        gelc(k,j)=gelc(k,j)
     &           +((ecosa*(dc_norm(k,i)-cosa*dc_norm(k,j))
     &           +ecosg*(erij(k)-cosg*dc_norm(k,j)))*vbld_inv(j+1))*sss1
     &       *faclipij2
#ifdef SHIELD
     &      *fac_shield(i)**2*fac_shield(j)**2
#endif
c     &       *((sslipi+sslipj)/2.0d0*lipscale**2+1.0d0)
        gelc_long(k,j)=gelc_long(k,j)+ggg(k)
        gelc_long(k,i)=gelc_long(k,i)-ggg(k)
      enddo
      IF (wel_loc.gt.0.0d0 .or. wturn3.gt.0.0d0 .and. j.eq.i+2
     &    .or. wturn4.gt.0.0d0 .and. j.eq.i+3) THEN
C
C 9/25/99 Mixed third-order local-electrostatic terms. The local-interaction 
C   energy of a peptide unit is assumed in the form of a second-order 
C   Fourier series in the angles lambda1 and lambda2 (see Nishikawa et al.
C   Macromolecules, 1974, 7, 797-806 for definition). This correlation terms
C   are computed for EVERY pair of non-contiguous peptide groups.
C
c 12/21/21 AL Formulas for derivatives changed to reduce the number of
C   operations and to eliminate explicit angles. This source code is now
C   good only for scale-consistent variant of UNRES. For previous
C   verions of UNRES use old source code.
        j1=j+1
        j2=j-1
        fac=dsqrt(-ael6i)*r3ij
        IF (wel_loc.gt.0.0d0) THEN
          muimuj=scalar(mu(1,i),mu(1,j))
          muier=scalar(mu(1,i),erij(1))
          mujer=scalar(mu(1,j),erij(1))
C Contribution to the local-electrostatic energy coming from the i-j
C pair
          eel_loc_ij=fac*(muimuj-3*muier*mujer)
#ifdef DEBUG
          write (iout,*) "ij",i,j," eel_loc_ij",eel_loc_ij,
     &     " wel_loc",wel_loc
#endif
#ifdef SHIELD
          if (shield_mode.eq.0) then 
            fac_shield(i)=1.0
            fac_shield(j)=1.0
            fsi=1.0
            fsj=1.0
            fsij=1.0
C          else
C            fac_shield(i)=0.4
C            fac_shield(j)=0.6
          endif
#endif
          eel_loc_ij=eel_loc_ij
     &    *sss1*faclipij
#ifdef SHIELD
     &    *fsij
#endif
c          if (energy_dec) write (iout,'(a6,2i5,0pf7.3)')
c     &            'eelloc',i,j,eel_loc_ij
C Now derivative over eel_loc
#ifdef SHIELD
          if ((fsi.gt.0).and.(fsj.gt.0).and.(shield_mode.gt.0)) then
C          print *,i,j     
            do ilist=1,ishield_list(i)
              iresshield=shield_list(ilist,i)
              do k=1,3
                rlocshield=grad_shield_side(k,ilist,i)*eel_loc_ij
     &                                          /fsi
C     &      *2.0
                gshieldx_ll(k,iresshield)=gshieldx_ll(k,iresshield)+
     &              rlocshield
     &             +grad_shield_loc(k,ilist,i)*eel_loc_ij/fsi
                gshieldc_ll(k,iresshield-1)=gshieldc_ll(k,iresshield-1)
     &           +rlocshield
              enddo
            enddo
            do ilist=1,ishield_list(j)
              iresshield=shield_list(ilist,j)
              do k=1,3
                rlocshield=grad_shield_side(k,ilist,j)*eel_loc_ij
     &                                       /fsj
C     &     *2.0
                gshieldx_ll(k,iresshield)=gshieldx_ll(k,iresshield)+
     &              rlocshield
     &             +grad_shield_loc(k,ilist,j)*eel_loc_ij/fsj
                gshieldc_ll(k,iresshield-1)=gshieldc_ll(k,iresshield-1)
     &             +rlocshield

              enddo
            enddo

            do k=1,3
              gshieldc_ll(k,i)=gshieldc_ll(k,i)+
     &              grad_shield(k,i)*eel_loc_ij/fsi
              gshieldc_ll(k,j)=gshieldc_ll(k,j)+
     &              grad_shield(k,j)*eel_loc_ij/fsj
              gshieldc_ll(k,i-1)=gshieldc_ll(k,i-1)+
     &              grad_shield(k,i)*eel_loc_ij/fsi
              gshieldc_ll(k,j-1)=gshieldc_ll(k,j-1)+
     &              grad_shield(k,j)*eel_loc_ij/fsj
            enddo
          endif !if(shield_mode.gt.0)
#endif

c          write (iout,*) 'i',i,' j',j,itype(i),itype(j),
c     &                     ' eel_loc_ij',eel_loc_ij
C          write(iout,*) 'muije=',i,j,muij(1),muij(2),muij(3),muij(4)
C Calculate patrial derivative for theta angle
          auxvec=fac*(mu(:,j)-3*mujer*erij)
     &         *sss1*faclipij
#ifdef SHIELD
     &         *fsij
#endif
c          write(iout,*) "auxvec j",auxvec
          do k=1,3
            do l=1,3
c              write (iout,*) "i",i," k",k," l",l
c              write (iout,*) "muder",muder(:,l,k,i)
c              write (iout,*) "auxvec",auxvec
c              write (iout,*) "g",scalar(muder(1,l,k,i),auxvec)
              gel_loc(l,i+k-2)=gel_loc(l,i+k-2)+
     &         scalar(muder(1,l,k,i),auxvec)
            enddo
          enddo
          auxvec=fac*(mu(:,i)-3*muier*erij)
     &         *sss1*faclipij
#ifdef SHIELD
     &         *fsij
#endif
c          write(iout,*) "auxvec j",auxvec
          do k=1,3
            do l=1,3
c              write (iout,*) "j",j," k",k," l",l
c              write (iout,*) "muder",muder(:,l,k,j)
c              write (iout,*) "auxvec",auxvec
c              write (iout,*) "g",scalar(muder(1,l,k,j),auxvec)
              gel_loc(l,j+k-2)=gel_loc(l,j+k-2)+
     &         scalar(muder(1,l,k,j),auxvec)
            enddo
          enddo
cd          write (iout,*) 'i',i,' j',j,' eel_loc_ij',eel_loc_ij

          if (energy_dec) write (iout,'(a6,2i5,0pf7.3)')
     &            'eelloc',i,j,eel_loc_ij
          eel_loc=eel_loc+eel_loc_ij
C------------------------------------to
C Derivatives of eelloc3 in peptide-group coordinates
          aux=eel_loc_ij/sss1*sssgrad1*rmij
          call scalevec(xyzj,aux,ggg)
          ggg=ggg-3*rmij*(eel_loc_ij*erij
     &       +fac*sss1*(muier*mu(:,j)+mujer*mu(:,i)-2*muier*mujer*erij))
     &       *faclipij
#ifdef SHIELD
     &       *fsij
#endif
c          write (iout,*) "ggg",ggg
          call offsetvecs(gel_loc_long(:,j),gel_loc_long(:,i),ggg)
               gel_loc_long(3,j)=gel_loc_long(3,j)+
     &      ssgradlipj*eel_loc_ij/2.0d0*lipscale/faclipij

          gel_loc_long(3,i)=gel_loc_long(3,i)+
     &      ssgradlipi*eel_loc_ij/2.0d0*lipscale/faclipij

        ENDIF !IF (wel_loc.gt.0.0d0)
C Calculate the quantites needed for eello3/eello4
c        if (tail_agg) then
c          call calculate_aggij(i,j,fac,rrmij,rmij,xyzj,erij)
c        endif
      ENDIF
c          t_eelecij=t_eelecij+MPI_Wtime()-time00
      return
      end
C-----------------------------------------------------------------------
      subroutine evdwpp_short(evdw1)
C
C Compute Evdwpp
C 
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
c      include 'COMMON.CONTACTS'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      include "COMMON.SPLITELE"
      double precision ggg(3)
      integer xshift,yshift,zshift
c 4/26/02 - AL scaling factor for 1,4 repulsive VDW interactions
#ifdef MOMENT
      double precision scal_el /1.0d0/
#else
      double precision scal_el /0.5d0/
#endif
c      write (iout,*) "evdwpp_short"
      integer i,j,k,iteli,itelj,num_conti,ind,isubchap
      double precision dxi,dyi,dzi,dxj,dyj,dzj,aaa,bbb
      double precision xj,yj,zj,rij,rrmij,r3ij,r6ij,evdw1,
     & dx_normi,dy_normi,dz_normi,xmedi,ymedi,zmedi,
     & dx_normj,dy_normj,dz_normj,rmij,ev1,ev2,evdwij,facvdw
      double precision sss_grad
      double precision sscale,sscagrad
      double precision sslipi,ssgradlipi,sslipj,ssgradlipj
      double precision boxshift
      integer ikont,jblock
      double precision faclipij2
      evdw1=0.0D0
C      print *,"WCHODZE"
c      write (iout,*) "iatel_s_vdw",iatel_s_vdw,
c     & " iatel_e_vdw",iatel_e_vdw
c      call flush(iout)
c      do i=iatel_s_vdw,iatel_e_vdw
      if (energy_dec)
     & write(iout,*) "g_listpp_vdw_start_short,g_listpp_vdw_end_short",
     & g_listpp_vdw_start_short,g_listpp_vdw_end_short
      do ikont=g_listpp_vdw_start_short,g_listpp_vdw_end_short
        i=newcontlistppi_vdw_short(1,ikont)
c        if (itype(i).eq.ntyp1.or. itype(i+1).eq.ntyp1) cycle
        dxi=dc(1,i)
        dyi=dc(2,i)
        dzi=dc(3,i)
        dx_normi=dc_norm(1,i)
        dy_normi=dc_norm(2,i)
        dz_normi=dc_norm(3,i)
c peptide groups already placed in box
c        xmedi=c(1,i)+0.5d0*dxi
c        ymedi=c(2,i)+0.5d0*dyi
c        zmedi=c(3,i)+0.5d0*dzi
c        call to_box(xmedi,ymedi,zmedi)
        xmedi=cp(1,i)
        ymedi=cp(2,i)
        zmedi=cp(3,i)
        call lipid_layer(xmedi,ymedi,zmedi,sslipi,ssgradlipi)
        num_conti=0
c        write (iout,*) 'i',i,' ielstart',ielstart_vdw(i),
c     &   ' ielend',ielend_vdw(i)
c        call flush(iout)
c        do j=ielstart_vdw(i),ielend_vdw(i)
        do jblock=newcontlistppi_vdw_short(2,ikont-1)+1,
     &     newcontlistppi_vdw_short(2,ikont)
        do j=newcontlistppj_vdw_short(1,jblock),
     &   newcontlistppj_vdw_short(2,jblock)
c          if (itype(j).eq.ntyp1 .or. itype(j+1).eq.ntyp1) cycle
          ind=ind+1
          iteli=itel(i)
          itelj=itel(j)
          if (j.eq.i+2 .and. itelj.eq.2) iteli=2
          aaa=app(iteli,itelj)
          bbb=bpp(iteli,itelj)
          dxj=dc(1,j)
          dyj=dc(2,j)
          dzj=dc(3,j)
          dx_normj=dc_norm(1,j)
          dy_normj=dc_norm(2,j)
          dz_normj=dc_norm(3,j)
c peptide groups already placed in box
c          xj=c(1,j)+0.5D0*dxj
c          yj=c(2,j)+0.5D0*dyj
c          zj=c(3,j)+0.5D0*dzj
c          call to_box(xj,yj,zj)
          xj=cp(1,j)
          yj=cp(2,j)
          zj=cp(3,j)
          call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
          faclipij2=(sslipi+sslipj)/2.0d0*lipscale**2+1.0d0
          xj=boxshift(xj-xmedi,boxxsize)
          yj=boxshift(yj-ymedi,boxysize)
          zj=boxshift(zj-zmedi,boxzsize)
          rij=xj*xj+yj*yj+zj*zj
          rrmij=1.0D0/rij
          rij=dsqrt(rij)
c            sss=sscale(rij/rpp(iteli,itelj))
c            sssgrad=sscagrad(rij/rpp(iteli,itelj))
          sss=sscale(rij/rpp(iteli,itelj),r_cut_respa)
          sssgrad=sscagrad(rij/rpp(iteli,itelj),r_cut_respa)
          if (sss.gt.0.0d0) then
            rmij=1.0D0/rij
            r3ij=rrmij*rmij
            r6ij=r3ij*r3ij  
            ev1=aaa*r6ij*r6ij
c 4/26/02 - AL scaling down 1,4 repulsive VDW interactions
            if (j.eq.i+2) ev1=scal_el*ev1
            ev2=bbb*r6ij
            evdwij=ev1+ev2
            if (energy_dec) then 
              write (iout,'(a6,2i5,0pf7.3,f7.3)') 'evdw1',i,j,evdwij,sss
            endif
            evdw1=evdw1+evdwij*sss*faclipij2
            if (energy_dec) write (iout,'(a10,2i5,0pf7.3)') 
     &        'evdw1_sum',i,j,evdw1
C
C Calculate contributions to the Cartesian gradient.
C
            facvdw=(-6*rrmij*(ev1+evdwij)*sss+sssgrad*rmij*evdwij/
     &         rpp(iteli,itelj))*faclipij2
            ggg(1)=facvdw*xj
            ggg(2)=facvdw*yj
            ggg(3)=facvdw*zj
C            ggg(1)=facvdw*xj
C            ggg(2)=facvdw*yj
C            ggg(3)=facvdw*zj
            do k=1,3
              gvdwpp(k,j)=gvdwpp(k,j)+ggg(k)
              gvdwpp(k,i)=gvdwpp(k,i)-ggg(k)
            enddo
!C Lipidic part for scaling weight
            gvdwpp(3,j)=gvdwpp(3,j)+
     &        sss*ssgradlipj*evdwij/2.0d0*lipscale**2
            gvdwpp(3,i)=gvdwpp(3,i)+
     &        sss*ssgradlipi*evdwij/2.0d0*lipscale**2
          endif
        enddo ! j
        enddo ! jblock
      enddo   ! ikont
      return
      end
C-----------------------------------------------------------------------------
      subroutine escp_long(evdw2,evdw2_14)
C
C This subroutine calculates the excluded-volume interaction energy between
C peptide-group centers and side chains and its gradient in virtual-bond and
C side-chain vectors.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include "COMMON.SPLITELE"
      logical lprint_short
      common /shortcheck/ lprint_short
      double precision ggg(3)
      integer i,iint,j,k,iteli,itypj,subchap
      double precision xi,yi,zi,xj,yj,zj,rrij,sss1,sssgrad1,
     & fac,e1,e2,rij
      double precision evdw2,evdw2_14,evdwij
      double precision sscale,sscagrad
      double precision boxshift
      integer ikont,jblock
      if (energy_dec) write (iout,*) "escp_long:",r_cut,rlamb
      evdw2=0.0D0
      evdw2_14=0.0d0
CD        print '(a)','Enter ESCP KURWA'
cd    write (iout,*) 'iatscp_s=',iatscp_s,' iatscp_e=',iatscp_e
c      if (lprint_short) 
c     &  write (iout,*) 'ESCP_LONG iatscp_s=',iatscp_s,
c     & ' iatscp_e=',iatscp_e
c      do i=iatscp_s,iatscp_e
      if (energy_dec)
     & write(iout,*)"g_listscp_start_long,g_listscp_end_long",
     & g_listscp_start_long,g_listscp_end_long
      do ikont=g_listscp_start_long,g_listscp_end_long
        i=newcontlistscpi_long(1,ikont)
c        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1) cycle
        iteli=itel(i)
c peptide groups already placed in box
c        xi=0.5D0*(c(1,i)+c(1,i+1))
c        yi=0.5D0*(c(2,i)+c(2,i+1))
c        zi=0.5D0*(c(3,i)+c(3,i+1))
c        call to_box(xi,yi,zi)
        xi=cp(1,i)
        yi=cp(2,i)
        zi=cp(3,i)

c        do iint=1,nscp_gr(i)

c        do j=iscpstart(i,iint),iscpend(i,iint)
        do jblock=newcontlistscpi_long(2,ikont-1)+1,
     &    newcontlistscpi_long(2,ikont)
        do j=newcontlistscpj_long(1,jblock),
     &    newcontlistscpj_long(2,jblock)
          itypj=iabs(itype(j))
c          if (itypj.eq.ntyp1) cycle
C Uncomment following three lines for SC-p interactions
c         xj=c_tobox(1,nres+j)
c         yj=c_tobox(2,nres+j)
c         zj=c_tobox(3,nres+j)
C Uncomment following three lines for Ca-p interactions
c Calphas already placed in box
c          xj=c(1,j)
c          yj=c(2,j)
c          zj=c(3,j)
c corrected by AL
c          call to_box(xj,yj,zj)
          xj=c_tobox(1,j)
          yj=c_tobox(2,j)
          zj=c_tobox(3,j)
          xj=boxshift(xj-xi,boxxsize)
          yj=boxshift(yj-yi,boxysize)
          zj=boxshift(zj-zi,boxzsize)

          rrij=1.0D0/(xj*xj+yj*yj+zj*zj)

          sss1=sscale(1.0d0/(dsqrt(rrij)),r_cut_int)
          if (sss1.eq.0) cycle
          sss=sscale(1.0d0/(dsqrt(rrij)*rscp(itypj,iteli)),r_cut_respa)
          sssgrad=
     &      sscagrad(1.0d0/(dsqrt(rrij)*rscp(itypj,iteli)),r_cut_respa)
          sssgrad1=sscagrad(1.0d0/dsqrt(rrij),r_cut_int)
          if (energy_dec) write (iout,*) "rrij",1.0d0/dsqrt(rrij),
     &     " rscp",rscp(itypj,iteli)," subchap",subchap," sss",sss
          if (sss.lt.1.0d0) then
            fac=rrij**expon2
            e1=fac*fac*aad(itypj,iteli)
            e2=fac*bad(itypj,iteli)
            if (iabs(j-i) .le. 2) then
              e1=scal14*e1
              e2=scal14*e2
              evdw2_14=evdw2_14+(e1+e2)*(1.0d0-sss)*sss1
            endif
            evdwij=e1+e2
            evdw2=evdw2+evdwij*(1.0d0-sss)*sss1
            if (energy_dec) write (iout,'(a6,2i5,2(0pf7.3))')
     &          'evdw2',i,j,sss,evdwij
C
C Calculate contributions to the gradient in the virtual-bond and SC vectors.
C
             
            fac=-(evdwij+e1)*rrij*(1.0d0-sss)*sss1
            fac=fac+evdwij*dsqrt(rrij)*(-sssgrad/rscp(itypj,iteli)
     &        +sssgrad1)/expon
            ggg(1)=xj*fac
            ggg(2)=yj*fac
            ggg(3)=zj*fac
C Uncomment following three lines for SC-p interactions
c           do k=1,3
c             gradx_scp(k,j)=gradx_scp(k,j)+ggg(k)
c           enddo
C Uncomment following line for SC-p interactions
c             gradx_scp(k,j)=gradx_scp(k,j)+ggg(k)
            do k=1,3
              gvdwc_scpp(k,i)=gvdwc_scpp(k,i)-ggg(k)
              gvdwc_scp(k,j)=gvdwc_scp(k,j)+ggg(k)
            enddo
          endif
        enddo ! j

        enddo ! jblock
      enddo ! ikont
      do i=1,nct
        do j=1,3
          gvdwc_scp(j,i)=expon*gvdwc_scp(j,i)
          gvdwc_scpp(j,i)=expon*gvdwc_scpp(j,i)
          gradx_scp(j,i)=expon*gradx_scp(j,i)
        enddo
      enddo
C******************************************************************************
C
C                              N O T E !!!
C
C To save time the factor EXPON has been extracted from ALL components
C of GVDWC and GRADX. Remember to multiply them by this factor before further 
C use!
C
C******************************************************************************
      return
      end
C-----------------------------------------------------------------------------
      subroutine escp_short(evdw2,evdw2_14)
C
C This subroutine calculates the excluded-volume interaction energy between
C peptide-group centers and side chains and its gradient in virtual-bond and
C side-chain vectors.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include "COMMON.SPLITELE"
      integer xshift,yshift,zshift
      logical lprint_short
      common /shortcheck/ lprint_short
      integer i,iint,j,k,iteli,itypj,subchap
      double precision xi,yi,zi,xj,yj,zj,rrij,sss1,sssgrad1,
     & fac,e1,e2,rij
      double precision evdw2,evdw2_14,evdwij
      double precision ggg(3)
      double precision sscale,sscagrad
      double precision boxshift
      integer ikont,jblock
      evdw2=0.0D0
      evdw2_14=0.0d0
cd    print '(a)','Enter ESCP'
c      if (lprint_short) 
c     &  write (iout,*) 'ESCP_SHORT iatscp_s=',iatscp_s,
c     & ' iatscp_e=',iatscp_e
c      if (energy_dec) write (iout,*) "escp_short:",r_cut_int,rlamb
      if (energy_dec)
     & write(iout,*) "g_listscp_start_short,g_listscp_end_short",
     & g_listscp_start_short,g_listscp_end_short
      do ikont=g_listscp_start_short,g_listscp_end_short
        i=newcontlistscpi_short(1,ikont)
c        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1) cycle
        iteli=itel(i)
c peptide groups already placed in box
c        xi=0.5D0*(c(1,i)+c(1,i+1))
c        yi=0.5D0*(c(2,i)+c(2,i+1))
c        zi=0.5D0*(c(3,i)+c(3,i+1))
c        call to_box(xi,yi,zi)
        xi=cp(1,i)
        yi=cp(2,i)
        zi=cp(3,i)

c        if (lprint_short) 
c     &    write (iout,*) "i",i," itype",itype(i),itype(i+1),
c     &     " nscp_gr",nscp_gr(i)   
c        do iint=1,nscp_gr(i)
c
c        do j=iscpstart(i,iint),iscpend(i,iint)
        do jblock=newcontlistscpi_short(2,ikont-1)+1,
     &    newcontlistscpi_short(2,ikont)
          do j=newcontlistscpj_short(1,jblock),
     &     newcontlistscpj_short(2,jblock)
          itypj=iabs(itype(j))
c        if (lprint_short)
c     &    write (iout,*) "j",j," itypj",itypj
c          if (itypj.eq.ntyp1) cycle
C Uncomment following three lines for SC-p interactions
c         xj=c_tobox(1,nres+j)
c         yj=c_tobox(2,nres+j)
c         zj=c_tobox(3,nres+j)
C Uncomment following three lines for Ca-p interactions
c Calphas already placed in box
c          xj=c(1,j)
c          yj=c(2,j)
c          zj=c(3,j)
c          call to_box(xj,yj,zj)
          xj=c_tobox(1,j)
          yj=c_tobox(2,j)
          zj=c_tobox(3,j)
          xj=boxshift(xj-xi,boxxsize)
          yj=boxshift(yj-yi,boxysize)
          zj=boxshift(zj-zi,boxzsize)
          rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
c          sss=sscale(1.0d0/(dsqrt(rrij)*rscp(itypj,iteli)))
c          sssgrad=sscagrad(1.0d0/(dsqrt(rrij)*rscp(itypj,iteli)))
          sss=sscale(1.0d0/(dsqrt(rrij)*rscp(itypj,iteli)),r_cut_respa)
          sssgrad=sscagrad(1.0d0/(dsqrt(rrij)*rscp(itypj,iteli)),
     &        r_cut_respa)
          if (energy_dec) write (iout,*) "rrij",1.0d0/dsqrt(rrij),
     &     " rscp",rscp(itypj,iteli)," subchap",subchap," sss",sss
c          if (lprint_short) write (iout,*) "rij",1.0/dsqrt(rrij),
c     &     " subchap",subchap," sss",sss
          if (sss.gt.0.0d0) then

            fac=rrij**expon2
            e1=fac*fac*aad(itypj,iteli)
            e2=fac*bad(itypj,iteli)
            if (iabs(j-i) .le. 2) then
              e1=scal14*e1
              e2=scal14*e2
              evdw2_14=evdw2_14+(e1+e2)*sss
            endif
            evdwij=e1+e2
            evdw2=evdw2+evdwij*sss
            if (energy_dec) write (iout,'(a6,2i5,2(0pf7.3))')
     &          'evdw2',i,j,sss,evdwij
C
C Calculate contributions to the gradient in the virtual-bond and SC vectors.
C
            fac=-(evdwij+e1)*rrij*sss
            fac=fac+evdwij*sssgrad*dsqrt(rrij)/rscp(itypj,iteli)/expon
            ggg(1)=xj*fac
            ggg(2)=yj*fac
            ggg(3)=zj*fac
C Uncomment following three lines for SC-p interactions
c           do k=1,3
c             gradx_scp(k,j)=gradx_scp(k,j)+ggg(k)
c           enddo
C Uncomment following line for SC-p interactions
c             gradx_scp(k,j)=gradx_scp(k,j)+ggg(k)
            do k=1,3
              gvdwc_scpp(k,i)=gvdwc_scpp(k,i)-ggg(k)
              gvdwc_scp(k,j)=gvdwc_scp(k,j)+ggg(k)
            enddo
          endif
        enddo ! j

        enddo ! jblock
      enddo ! ikont
      do i=1,nct
        do j=1,3
          gvdwc_scp(j,i)=expon*gvdwc_scp(j,i)
          gvdwc_scpp(j,i)=expon*gvdwc_scpp(j,i)
          gradx_scp(j,i)=expon*gradx_scp(j,i)
        enddo
      enddo
C******************************************************************************
C
C                              N O T E !!!
C
C To save time the factor EXPON has been extracted from ALL components
C of GVDWC and GRADX. Remember to multiply them by this factor before further 
C use!
C
C******************************************************************************
      return
      end
