      subroutine EELEC_WORK_FN(chunk,i,from,to,i_value,output,
     &                         th_data,scal_el)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.CORRMAT'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      include 'COMMON.TIME1'
      include 'COMMON.SPLITELE'
      include 'COMMON.SHIELD'
#ifdef SHIELD
      include 'COMMON.EELEC.SHIELD'
#else
      include 'COMMON.EELEC'
#endif
      include 'COMMON.LIPID'

      record /eelecij_work_chunk/ chunk
      record /eelecij_value_delta/ i_value
      record /eelecij_array_delta/ output
      record /eelec_thread_data/ th_data
      integer seq,from,to,i,j,idx
      integer iteli,eiteli,itelj
      integer k,ilist,iresshield
      double precision ggg(3),gggi(3),erij(3),dcosb(3),dcosg(3)
      double precision xyzj(3),gelc_long_dj(3),gelc_long_di(3)
      double precision ggg1(3),ggg3(3),ggg4(3),auxvec(3)
      double precision rrmij,rmij,scal_el
#ifdef SHIELD
      double precision fsi,fsj,fsij,rlocshield
#endif
      double precision aux,auxa,auxb,auxg,gamm,
     &  rij,r3ij,r6ij,cosa,cosb,cosg,fac,ev1,ev2,fac3,fac4,
     &  evdwij,el1,el2,eesij,facvdw,facel,fac1,ecosa,
     &  ecosb,ecosg,ury,urz,vry,vrz,facr,eel_loc_ij,
     &  eel_loc_ij_o,eel_loc_ij_1
      double precision muimuj,muier,mujer
      double precision geel_loc_delta
      double precision faclipij,faclipij2
      double precision dc_norm_i(3),dc_norm_j(3)
      double precision lipid_i_ss,lipid_i_ssgrad,fac_shield_i
      double precision lipid_j_ssgrad
      double precision d_gvdwppx,d_gvdwppy,d_gvdwppz
      double precision d_gelc_longx,d_gelc_longy,d_gelc_longz
      double precision d_gelc(3)
      double precision d_gel_loc_longx,d_gel_loc_longy,d_gel_loc_longz
      double precision d_auxvec(3)
      double precision d_ees,d_evdw1,d_eel_loc
      double precision scalar
      d_gvdwppx=0.0d0
      d_gvdwppy=0.0d0
      d_gvdwppz=0.0d0
      d_gelc_longx=0.0d0
      d_gelc_longy=0.0d0
      d_gelc_longz=0.0d0
      d_gelc=0.0d0
      d_gel_loc_longx=0.0d0
      d_gel_loc_longy=0.0d0
      d_gel_loc_longz=0.0d0
      d_auxvec=0.0d0
      d_ees=0.0d0
      d_evdw1=0.0d0
      d_eel_loc=0.0d0

      iteli=itel(i)

      dc_norm_i=dc_norm(:,i)
      lipid_i_ss=lipid_cache(i).ss
      lipid_i_ssgrad=lipid_cache(i).ssgrad
#ifdef SHIELD
      fac_shield_i=fac_shield(i)
#endif

!DIR$ LOOP COUNT(64)
!$OMP SIMD
!$OMP& REDUCTION(+:d_gvdwppx,d_gvdwppy,d_gvdwppz,d_gelc,
!$OMP&             d_gelc_longx,d_gelc_longy,d_gelc_longz,
!$OMP&             d_gel_loc_longx,d_gel_loc_longy,d_gel_loc_longz,
!$OMP&             d_auxvec,
!$OMP&             d_ees,d_evdw1,d_eel_loc)
!$OMP& PRIVATE(
#ifdef SHIELD
!$OMP&   fsi,fsj,fsij,rlocshield,ilist,iresshield,
#endif
!$OMP&   j,k,xyzj,erij,rij,rmij,rrmij,r3ij,r6ij,dc_norm_j,
!$OMP&   cosa,cosb,cosg,ev1,ev2,fac,fac1,fac3,fac4,
!$OMP&   ggg,gggi,ggg1,ggg3,ggg4,gelc_long_di,gelc_long_dj,
!$OMP&   evdwij,el1,el2,eesij,facvdw,facel,
!$OMP&   dcosb,dcosg,ecosa,ecosb,ecosg,ury,urz,vry,vrz,eel_loc_ij,
!$OMP&   faclipij,faclipij2,sss,sssgrad,gamm,aux,auxa,auxb,auxg,
!$OMP&   eiteli,itelj,muimuj,muier,mujer,auxvec,
!$OMP&   eel_loc_ij_o,geel_loc_delta
!$OMP& )
      do seq=from,to
        j=EELEC_MAP_J(seq)
        idx=EELEC_MAP_IDX(seq)
        xyzj(1)=chunk.x(idx)
        xyzj(2)=chunk.y(idx)
        xyzj(3)=chunk.z(idx)
        rij=chunk.r(idx)
#ifdef NAN_DETECT
        if (isnan(rij)) print *,"eelec_work: NaN in rij",
     &   idx,rij,xyzj(1),xyzj(2),xyzj(3)
#endif
        itelj=itel(j)
        eiteli=iteli
        if (j.eq.i+2 .and. itelj.eq.2) eiteli=2

        aux=(lipid_i_ss+chunk.lipid_j_ss(idx))*0.5d0
        faclipij=aux*lipscale+1.0d0
        faclipij2=aux*lipscale**2+1.0d0
C       if ((i+3).lt.j) then !this condition keeps for turn3 and turn4 not subject to PBC
c  174    continue

        rrmij=1.0D0/rij
        rij=dsqrt(rij)
        rmij=1.0D0/rij
        r3ij=rrmij*rmij
        r6ij=r3ij*r3ij  

C       sss=sscale(rij,r_cut_int); sssgrad=sscagrad(rij,r_cut_int)
        if(rij.lt.r_cut_int-rlamb) then
          sss=1.0d0
          sssgrad=0.0d0
        else
          gamm=(rij-(r_cut_int-rlamb))*irlamb
          sss=1.0d0+gamm*gamm*(2*gamm-3.0d0)
          sssgrad=gamm*(6*gamm-6.0d0)*irlamb
        endif
#ifdef NAN_DETECT
        if (isnan(sss)) print *,"eelec_work: NaN in sss",
     &    gamm,rij,r_cut_int,rlamb,irlamb,sss
#endif
        dc_norm_j(1)=dc_norm(1,j)
        dc_norm_j(2)=dc_norm(2,j)
        dc_norm_j(3)=dc_norm(3,j)

        cosa=scalar(dc_norm_i,dc_norm_j)
        cosb=scalar(xyzj,dc_norm_i)*rmij
        cosg=scalar(xyzj,dc_norm_j)*rmij
        fac=cosa-3.0D0*cosb*cosg
        ev1=th_data.aaa(itelj,eiteli)*r6ij*r6ij
c 4/26/02 - AL scaling down 1,4 repulsive VDW interactions
        !if (j.eq.i+2) ev1=scal_el*ev1
        ev1=scal_el*ev1
        ev2=th_data.bbb(itelj,eiteli)*r6ij
        fac3=th_data.ael6(itelj,eiteli)*r6ij
        fac4=th_data.ael3(itelj,eiteli)*r3ij
        evdwij=(ev1+ev2)
        el1=fac3*(4.0D0+fac*fac-3.0D0*(cosb*cosb+cosg*cosg))
        el2=fac4*fac       
C MARYSIA
C       eesij=(el1+el2)
C 12/26/95 - for the evaluation of multi-body H-bonding interactions

#ifdef SHIELD
        fsi=fac_shield_i
        !fsj=fac_shield(j)
        fsj=chunk.fac_shield_j(idx)
        fsij=fsi*fsj

        if (shield_mode.gt.0) then
C         fac_shield(i)=0.4
C         fac_shield(j)=0.6
C         fsi=0.4
C         fsj=0.6
C         fsij=fsi*fsj
          el1=el1*fsij*fsij
          el2=el2*fsij*fsij
          !eesij=(el1+el2)
        else
          !fac_shield(i)=1.0
          !fac_shield(j)=1.0
          fsi=1.0
          fsj=1.0
          fsij=1.0
          !eesij=(el1+el2)
        endif
#endif

        eesij=(el1+el2)

        aux=sss*faclipij2
        d_ees=d_ees+eesij*aux
        d_evdw1=d_evdw1+evdwij*aux

cd      write(iout,'(2(2i3,2x),7(1pd12.4)/2(3(1pd12.4),5x)/)')
cd     &  iteli,i,itelj,j,aaa,bbb,ael6i,ael3i,
cd     &  1.0D0/dsqrt(rrmij),evdwij,eesij,
cd     &  cp(1,i),cp(2,i),cp(3,i),xyzj(1),xyzj(2),xyzj(3)

#ifdef DEBUG
        if (energy_dec) then 
          write (iout,'(a6,2i5,0pf7.3,2i5,e11.3,3f10.5)') 
     &      'evdw1',i,j,evdwij,iteli,itelj,aaa,d_evdw1,sss,rij
          write (iout,'(a6,2i5,0pf7.3,6f8.5)') 'ees',i,j,eesij,
     &      fsi,fsj,lipid_i_ss,lipid_cache(j).ss,faclipij,
     &      faclipij2
        endif
#endif

C
C Calculate contributions to the Cartesian gradient.
C
#ifdef SPLITELE
        facvdw=-6*rrmij*(ev1+evdwij)*sss
        facel=-3*rrmij*(el1+eesij)
        fac1=fac
        erij=xyzj*rmij

*
* Radial derivatives. First process both termini of the fragment (i,j)
*

#ifdef SHIELD
        if ((fsi.gt.0).and.(fsj.gt.0).and.(shield_mode.gt.0)) then
C         print *,i,j     
          do ilist=1,ishield_list(i)
            iresshield=shield_list(ilist,i)
            do k=1,3
              rlocshield=grad_shield_side(k,ilist,i)*eesij/fsi
     &                  *2.0
              gshieldx(k,iresshield)=gshieldx(k,iresshield)
     &                     +rlocshield
     &                     +grad_shield_loc(k,ilist,i)*eesij/fsi*2.0
            gshieldc(k,iresshield-1)=gshieldc(k,iresshield-1)+rlocshield
C             gshieldc_loc(k,iresshield)=gshieldc_loc(k,iresshield)
C    &                 +grad_shield_loc(k,ilist,i)*eesij/fac_shield(i)
C             if (iresshield.gt.i) then
C               do ishi=i+1,iresshield-1
C                 gshieldc(k,ishi)=gshieldc(k,ishi)+rlocshield
C    &                 +grad_shield_loc(k,ilist,i)*eesij/fac_shield(i)
C
C               enddo
C             else
C               do ishi=iresshield,i
C                 gshieldc(k,ishi)=gshieldc(k,ishi)-rlocshield
C    &                 -grad_shield_loc(k,ilist,i)*eesij/fac_shield(i)
C
C               enddo
C             endif
            enddo
          enddo
          do ilist=1,ishield_list(j)
            iresshield=shield_list(ilist,j)
            do k=1,3
              rlocshield=grad_shield_side(k,ilist,j)*eesij/fsj
     &                  *2.0*sss
              gshieldx(k,iresshield)=gshieldx(k,iresshield)
     &                  +rlocshield
     &                  +grad_shield_loc(k,ilist,j)*eesij/fsj*2.0*sss
            gshieldc(k,iresshield-1)=gshieldc(k,iresshield-1)+rlocshield
            enddo
          enddo

          do k=1,3
            gshieldc(k,i)=gshieldc(k,i)+
     &               grad_shield(k,i)*eesij/fsi*2.0*sss
            gshieldc(k,j)=gshieldc(k,j)+
     &               grad_shield(k,j)*eesij/fsj*2.0*sss
            gshieldc(k,i-1)=gshieldc(k,i-1)+
     &               grad_shield(k,i)*eesij/fsi*2.0*sss
            gshieldc(k,j-1)=gshieldc(k,j-1)+
     &               grad_shield(k,j)*eesij/fsj*2.0*sss
          enddo
        endif !if(shield_mode.gt.0)
#endif
        lipid_j_ssgrad=chunk.lipid_j_ssgrad(idx)

        facvdw=(facvdw+sssgrad*rmij*evdwij)*faclipij2
        ggg=xyzj*facvdw
!C Lipidic part for scaling weight
        auxg=sss*0.5d0*lipscale**2
        aux=evdwij*auxg
        output.gvdwppx(j)=output.gvdwppx(j)+ggg(1)
        output.gvdwppy(j)=output.gvdwppy(j)+ggg(2)
        output.gvdwppz(j)=output.gvdwppz(j)+(ggg(3)+lipid_j_ssgrad*aux)
        d_gvdwppx=d_gvdwppx-ggg(1)
        d_gvdwppy=d_gvdwppy-ggg(2)
        d_gvdwppz=d_gvdwppz-(ggg(3)-lipid_i_ssgrad*aux)

        aux=(facel*sss+rmij*sssgrad*eesij)*faclipij2
        ggg=xyzj*aux
        eesij=eesij*auxg
#else
C-SPLITELE:C MARYSIA
C-SPLITELE:        facvdw=(ev1+evdwij)*faclipij2
C-SPLITELE:        facel=(el1+eesij)
C-SPLITELE:        fac1=fac
C-SPLITELE:        fac=-3*rrmij*(facvdw+facvdw+facel)*sss
C-SPLITELE:     &      +(evdwij+eesij)*sssgrad*rrmij
C-SPLITELE:        call scalevec(xyzj,rmij,erij)
C-SPLITELE:*
C-SPLITELE:* Radial derivatives. First process both termini of the fragment (i,j)
C-SPLITELE:* 
C-SPLITELE:        call scalevec(xyzj,fac,ggg)
C-SPLITELE:C       ggg=fac*xyzj+eesij*grad_shield(:,i)+eesij*grad_shield(:,j)
C-SPLITELE:c       do k=1,3
C-SPLITELE:c         ghalf=0.5D0*ggg(k)
C-SPLITELE:c         gelc(k,i)=gelc(k,i)+ghalf
C-SPLITELE:c         gelc(k,j)=gelc(k,j)+ghalf
C-SPLITELE:c       enddo
C-SPLITELE:c 9/28/08 AL Gradient compotents will be summed only at the end
C-SPLITELE:        do k=1,3
C-SPLITELE:          gelc_long(k,j)=gelc(k,j)+ggg(k)
C-SPLITELE:          gelc_long(k,i)=gelc(k,i)-ggg(k)
C-SPLITELE:        enddo
C-SPLITELE:        gelc_long_dj=0.0d0
C-SPLITELE:        gelc_long_di=0.0d0
C-SPLITELE:c 9/28/08 AL Gradient compotents will be summed only at the end
C-SPLITELE:        ggg(1)=facvdw*xyzj(1)+sssgrad*rmij*evdwij*xyzj(1)
C-SPLITELE:        ggg(2)=facvdw*xyzj(2)+sssgrad*rmij*evdwij*xyzj(2)
C-SPLITELE:        ggg(3)=facvdw*xyzj(3)+sssgrad*rmij*evdwij*xyzj(3)
C-SPLITELE:        do k=1,3
C-SPLITELE:          gvdwpp(k,j)=gvdwpp(k,j)+ggg(k)
C-SPLITELE:          gvdwpp(k,i)=gvdwpp(k,i)-ggg(k)
C-SPLITELE:        enddo
C-SPLITELE:        gvdwpp(3,j)=gvdwpp(3,j)+ 
C-SPLITELE:     &    sss*lipid_cache(j).ssgrad*evdwij/2.0d0*lipscale**2
C-SPLITELE:        gvdwpp(3,i)=gvdwpp(3,i)+ 
C-SPLITELE:     &    sss*lipid_cache(i).ssgrad*evdwij/2.0d0*lipscale**2
#endif
*
* Angular part
*          
        ecosa=2.0D0*fac3*fac1+fac4
        fac3=-6.0D0*fac3
        aux=-3.0d0*ecosa
        ecosb=aux*cosg+fac3*cosb
        ecosg=aux*cosb+fac3*cosg
        dcosb=dc_norm_i-erij*cosb
        dcosg=dc_norm_j-erij*cosg

cd      print '(2i3,2(3(1pd14.5),3x))',i,j,(dcosb(k),k=1,3),
cd   &        (dcosg(k),k=1,3)

        aux=sss*faclipij2
#ifdef SHIELD
           *(fsij*fsij)
#endif
        ecosa=ecosa*aux
        ecosb=ecosb*aux
        ecosg=ecosg*aux

        auxa=ecosa*cosa
        auxb=ecosb*cosb+auxa
        auxg=ecosg*cosg+auxa

        !ggg=(ecosb*dcosb+ecosg*dcosg)*rmij*aux
        gggi=(ecosb*rmij)*dcosb+(ecosg*rmij)*dcosg
!       ggg=rmij*(ecosb*dc_norm_i+ecosg*dc_norm_j       ! TO TEST
!    &            -(ecosg*cosg+ecosb*cosb)*erij)

        ggg=ggg+gggi

        output.gelc_longx(j)=output.gelc_longx(j)+ggg(1)
        output.gelc_longy(j)=output.gelc_longy(j)+ggg(2)
        output.gelc_longz(j)=output.gelc_longz(j)+ggg(3)
     &                      +lipid_j_ssgrad*eesij
        d_gelc_longx=d_gelc_longx-ggg(1)
        d_gelc_longy=d_gelc_longy-ggg(2)
        d_gelc_longz=d_gelc_longz-ggg(3)
     &                      +lipid_i_ssgrad*eesij

!       output(j).gelc=output(j).gelc
!    &    +aux*(vbld_inv(j+1)
!    &            *(ecosa*dc_norm_i+ecosg*erij-dc_norm_j*auxg))
!       d_gelc=d_gelc
!    &    +aux*(vbld_inv(i+1)
!    &            *(ecosa*dc_norm_j+ecosb*erij-dc_norm_i*auxb))
!       output(j).gelc=output(j).gelc
!    &    +ecosa*dc_norm_i+ecosg*erij-dc_norm_j*auxg
        output.gelcx(j)=output.gelcx(j)
     &    +ecosa*dc_norm_i(1)+ecosg*erij(1)-dc_norm_j(1)*auxg
        output.gelcy(j)=output.gelcy(j)
     &    +ecosa*dc_norm_i(2)+ecosg*erij(2)-dc_norm_j(2)*auxg
        output.gelcz(j)=output.gelcz(j)
     &    +ecosa*dc_norm_i(3)+ecosg*erij(3)-dc_norm_j(3)*auxg

        d_gelc=d_gelc+ecosa*dc_norm_j+ecosb*erij-dc_norm_i*auxb

C MARYSIA
!     IF (wel_loc.gt.0.0d0 .or. wturn3.gt.0.0d0 .and. j.eq.i+2
!    &    .or. wturn4.gt.0.0d0 .and. j.eq.i+3) THEN
#ifdef EELEC_WITH_WEL_LOC
C
C 9/25/99 Mixed third-order local-electrostatic terms. The local-interaction 
C   energy of a peptide unit is assumed in the form of a second-order 
C   Fourier series in the angles lambda1 and lambda2 (see Nishikawa et al.
C   Macromolecules, 1974, 7, 797-806 for definition). This correlation terms
C   are computed for EVERY pair of non-contiguous peptide groups.
C
C 12/21/21 AL Formulas for derivatives changed to reduce the number of
C   operations and to eliminate explicit angles. This source code is now
C   good only for scale-consistent variant of UNRES. For previous
C   verions of UNRES use old source code.

        fac=th_data.sqrt_ael6(itelj,eiteli)*r3ij
!       IF (wel_loc.gt.0.0d0) THEN
          muimuj=scalar(mu(:,i),mu(:,j))
          muier=scalar(mu(:,i),erij(:))
          mujer=scalar(mu(:,j),erij(:))
C Contribution to the local-electrostatic energy coming from the i-j pair
          eel_loc_ij_o=fac*(muimuj-3.0d0*muier*mujer)
          eel_loc_ij=eel_loc_ij_o
#ifdef DEBUG
          write (iout,*) "ij",i,j," eel_loc_ij",eel_loc_ij,
     &     " wel_loc",wel_loc
#endif
#ifdef SHIELD
          if (shield_mode.eq.0) then 
            !fac_shield(i)=1.0
            !fac_shield(j)=1.0
            fsi=1.0
            fsj=1.0
            fsij=1.0
C         else
C           fac_shield(i)=0.4
C           fac_shield(j)=0.6
          endif
#endif
          auxg=sss*faclipij
#ifdef SHIELD
              *fsij
#else
#endif
c AL 9/22/2022 The eel_loc_ij_1 factor introduced for better numerical stability
          eel_loc_ij_1 = eel_loc_ij*faclipij
          eel_loc_ij=eel_loc_ij*auxg

          d_eel_loc=d_eel_loc+eel_loc_ij

c         if (energy_dec) write (iout,'(a6,2i5,0pf7.3)')
c     &           'eelloc',i,j,eel_loc_ij
C Now derivative over eel_loc
#ifdef SHIELD
          if ((fsi.gt.0).and.(fsj.gt.0).and.(shield_mode.gt.0)) then
C           print *,i,j     

            do ilist=1,ishield_list(i)
              iresshield=shield_list(ilist,i)
              do k=1,3
                rlocshield=grad_shield_side(k,ilist,i)*eel_loc_ij
     &                                                /fsi
C    &                                                *2.0
                gshieldx_ll(k,iresshield)=gshieldx_ll(k,iresshield)
     &                        +rlocshield
     &                        +grad_shield_loc(k,ilist,i)*eel_loc_ij/fsi
                gshieldc_ll(k,iresshield-1)=gshieldc_ll(k,iresshield-1)
     &                        +rlocshield
              enddo
            enddo
            do ilist=1,ishield_list(j)
              iresshield=shield_list(ilist,j)
              do k=1,3
                rlocshield=grad_shield_side(k,ilist,j)*eel_loc_ij
     &                                                /fsj
C    &                                                *2.0
                gshieldx_ll(k,iresshield)=gshieldx_ll(k,iresshield)
     &                        +rlocshield
     &                        +grad_shield_loc(k,ilist,j)*eel_loc_ij/fsj
                gshieldc_ll(k,iresshield-1)=gshieldc_ll(k,iresshield-1)
     &                        +rlocshield

              enddo
            enddo

            do k=1,3
              gshieldc_ll(k,i)=gshieldc_ll(k,i)+
     &                grad_shield(k,i)*eel_loc_ij/fsi
              gshieldc_ll(k,j)=gshieldc_ll(k,j)+
     &                grad_shield(k,j)*eel_loc_ij/fsj
              gshieldc_ll(k,i-1)=gshieldc_ll(k,i-1)+
     &                grad_shield(k,i)*eel_loc_ij/fsi
              gshieldc_ll(k,j-1)=gshieldc_ll(k,j-1)+
     &                grad_shield(k,j)*eel_loc_ij/fsj
            enddo
          endif !if(shield_mode.gt.0)
#endif

c         write (iout,*) 'i',i,' j',j,itype(i),itype(j),
c    &                      ' eel_loc_ij',eel_loc_ij

C Calculate patrial derivative for theta angle
          auxvec=fac*(mu(:,j)-3.0d0*mujer*erij)
     &         *sss*faclipij
#ifdef SHIELD
     &         *fsij
#endif
c          write(iout,*) "auxvec j",auxvec
!         do k=1,3
!           do l=1,3
c              write (iout,*) "i",i," k",k," l",l
c              write (iout,*) "muder",muder(:,l,k,i)
c              write (iout,*) "auxvec",auxvec
c              write (iout,*) "g",scalar(muder(1,l,k,i),auxvec)
!             gel_loc(l,i+k-2)=gel_loc(l,i+k-2)+
!    &         scalar(muder(1,l,k,i),auxvec)
!           enddo
!         enddo
          d_auxvec=d_auxvec+auxvec

          auxvec=fac*(mu(:,i)-3.0*muier*erij)
     &         *sss*faclipij
#ifdef SHIELD
     &         *fsij
#endif
c          write(iout,*) "auxvec j",auxvec
!         do k=1,3
!           do l=1,3
c             write (iout,*) "j",j," k",k," l",l
c             write (iout,*) "muder",muder(:,l,k,j)
c             write (iout,*) "auxvec",auxvec
c             write (iout,*) "g",scalar(muder(1,l,k,j),auxvec)
!             gel_loc(l,j+k-2)=gel_loc(l,j+k-2)+
!   &           scalar(muder(1,l,k,j),auxvec)
!           enddo
!         enddo

          output.gel_locx(j)=output.gel_locx(j)+auxvec(1)
          output.gel_locy(j)=output.gel_locy(j)+auxvec(2)
          output.gel_locz(j)=output.gel_locz(j)+auxvec(3)

cd        write (iout,*) 'i',i,' j',j,' eel_loc_ij',eel_loc_ij

#ifdef DEBUG
          if (energy_dec) write (iout,'(a6,2i5,0pf7.3)')
     &            'eelloc',i,j,eel_loc_ij
#endif
C------------------------------------
C Derivatives of eelloc3 in peptide-group coordinates
c AL 2/22/2022 Changed for better numerical stability
c          aux=eel_loc_ij/sss*sssgrad*rmij
#ifdef NAN_DETECT
          if (isnan(sss)) print *,"eelec_work 1: NaN in sss"
#endif
          aux=eel_loc_ij_1*sssgrad*rmij
          ggg=xyzj*aux
          ggg=ggg-3.0d0*rmij*(eel_loc_ij*erij
     &        +fac*sss*(
     &          muier*mu(:,j)+mujer*mu(:,i)
     &          -2.0d0*muier*mujer*erij)
     &       )*faclipij
#ifdef SHIELD
     &       *fsij
#endif
#ifdef NAN_DETECT
          if (isnan(sss)) print *,"eelec_work 2: NaN in sss"
          if (isnan(ggg(1)).or.isnan(ggg(2)).or.isnan(ggg(3))) 
     &        print *,"eelec_work: NaN in ggg",i,j,ggg," aux",aux,
     &          " sss",sss," sssgrad",sssgrad," muier",muier,
     &          " mujer",mujer," mui",mu(:,i)," muj",mu(:,j),
     &          " xyzj",xyzj
#endif
c         write (iout,*) "ggg",ggg

          aux=eel_loc_ij_o*0.5d0*lipscale/faclipij
#ifdef NAN_DETECT
          if (isnan(aux)) print *,"NaN in lipid",i,j
#endif
          output.gel_loc_longx(j)=output.gel_loc_longx(j)+ggg(1)
          output.gel_loc_longy(j)=output.gel_loc_longy(j)+ggg(2)
          output.gel_loc_longz(j)=output.gel_loc_longz(j)+
     &                           +(ggg(3)+lipid_j_ssgrad*aux)
          d_gel_loc_longx=d_gel_loc_longx-ggg(1)
          d_gel_loc_longy=d_gel_loc_longy-ggg(2)
          d_gel_loc_longz=d_gel_loc_longz-
     &                     (ggg(3)-lipid_i_ssgrad*aux)
#ifdef NAN_DETECT
          if (isnan(output.gel_loc_longx(j)).or.
     &        isnan(output.gel_loc_longy(j)).or.
     &        isnan(output.gel_loc_longz(j)))print*,"NaN in output",i,j,
     &        output.gel_loc_longx(j),output.gel_loc_longy(j),
     &        output.gel_loc_longz(j) 
#endif
!       ENDIF !IF (wel_loc.gt.0.0d0)
!     ENDIF
#endif
      enddo ! do item=1,idx
#ifdef NAN_DETECT
      if (isnan(d_gel_loc_longx).or.isnan(d_gel_loc_longy).or.
     &  isnan(d_gel_loc_longz)) print *,"NaN in d_gel_loc",i,j,
     &  d_gel_loc_longx,d_gel_loc_longy,d_gel_loc_longz
#endif
      output.gvdwppx(i)=output.gvdwppx(i)+d_gvdwppx
      output.gvdwppy(i)=output.gvdwppy(i)+d_gvdwppy
      output.gvdwppz(i)=output.gvdwppz(i)+d_gvdwppz

      output.gelc_longx(i)=output.gelc_longx(i)+d_gelc_longx
      output.gelc_longy(i)=output.gelc_longy(i)+d_gelc_longy
      output.gelc_longz(i)=output.gelc_longz(i)+d_gelc_longz

      output.gelcx(i)=output.gelcx(i)+d_gelc(1)
      output.gelcy(i)=output.gelcy(i)+d_gelc(2)
      output.gelcz(i)=output.gelcz(i)+d_gelc(3)

      output.gel_loc_longx(i)=output.gel_loc_longx(i)+d_gel_loc_longx
      output.gel_loc_longy(i)=output.gel_loc_longy(i)+d_gel_loc_longy
      output.gel_loc_longz(i)=output.gel_loc_longz(i)+d_gel_loc_longz

      output.gel_locx(i)=output.gel_locx(i)+d_auxvec(1)
      output.gel_locy(i)=output.gel_locy(i)+d_auxvec(2)
      output.gel_locz(i)=output.gel_locz(i)+d_auxvec(3)

      i_value.ees=i_value.ees+d_ees
      i_value.evdw1=i_value.evdw1+d_evdw1
      i_value.eel_loc=i_value.eel_loc+d_eel_loc
      return
      end
