      subroutine EELECIJ(eelecij_work,num_items,offset,
     &                   threads_used,scal_el)
#ifdef _OPENMP
      use omp_lib
#endif
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.SPLITELE'
#ifdef SHIELD
      include 'COMMON.EELEC.SHIELD'
#else
      include 'COMMON.EELEC'
#endif
      include 'COMMON.LIPID'
      include 'COMMON.NEWBOX'
      integer num_items,threads_used,offset
      double precision xyzj(3),rij,scal_el
      integer my_thread,range_lo,range_hi,from,to
      integer lasti,lastj,i,j,item,seq_idx,nseq_idx
      double precision box(3),halfbox(3)
      record /eelecij_work_chunk/ seq_work
      record /eelecij_work_chunk/ nseq_work
      integer eelecij_work(num_items)
      record /eelec_thread_data/ th_data
      logical full
      double precision scalar

#ifdef _OPENMP
      threads_used=omp_get_max_threads()
#else
      threads_used=1
#endif
!$OMP PARALLEL
!$OMP& NUM_THREADS(threads_used) DEFAULT(SHARED)
!$OMP& PRIVATE(
!$OMP&   i,j,xyzj,rij,lasti,lastj,
!$OMP&   seq_work,seq_idx,nseq_work,nseq_idx,full,
!$OMP&   box,halfbox,
!$OMP&   my_thread,item,from,to,th_data
!$OMP& )
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif
      call eelec_fill_thread_data(th_data)

      call split_work_for_threads(from,to,1,num_items,
     &                            my_thread,threads_used)


      seq_idx=0
      nseq_idx=0
      lasti=0
      lastj=0
      box=boxsize
      halfbox=halfboxsize

      do item=from,to
        !i=eelecij_work(item).i
        !j=eelecij_work(item).j
        i=eelecij_work(item)
        j=i+offset
        LOG_STAT(300,1)
        !call wrapvec(cp(:,j)-cp(:,i),xyzj)
        call wrapvec2(cp(:,j)-cp(:,i),xyzj,halfbox,box)
        rij=scalar(xyzj,xyzj)
        if(rij.ge.r_cut_int_sq) cycle
        LOG_STAT(301,1)

        if(i.ne.lasti) then
          if(seq_idx.gt.0) then
            call EELEC_SEQ(seq_work,lasti,
     &                     seq_work.j(1),seq_work.j(seq_idx),
     &                     eelecij_value(my_thread),
     &                     eelecij_array(my_thread),
     &                     th_data,scal_el)
            LOG_STAT(302,seq_idx)
            seq_idx=0
          endif
          if(nseq_idx.gt.0) then
            call EELEC_NSEQ(nseq_work,lasti,
     &                      1,nseq_idx,
     &                      eelecij_value(my_thread),
     &                      eelecij_array(my_thread),
     &                      th_data,scal_el)
            LOG_STAT(303,nseq_idx)
            nseq_idx=0
          endif
          lasti=i
          lastj=-1
        endif

        if((j.eq.lastj+1).or.(seq_idx.eq.0)) then
          call eelec_queue_work(seq_work,seq_idx,i,j,
     &                          xyzj,rij,full)
          lastj=j
          if(full) then
            call EELEC_SEQ(seq_work,lasti,
     &                     seq_work.j(1),seq_work.j(seq_idx),
     &                     eelecij_value(my_thread),
     &                     eelecij_array(my_thread),
     &                     th_data,scal_el)
            LOG_STAT(302,seq_idx)
            seq_idx=0
            lastj=-1
          endif
        else
          if((seq_idx.lt.simd_seq_cutoff) .and.
     &       (nseq_idx+seq_idx.lt.eelec_buffer_size)) then
            LOG_STAT(304,seq_idx)
            call eelecij_move_work(seq_work,seq_idx,
     &                             nseq_work,nseq_idx)
          else
            call EELEC_SEQ(seq_work,lasti,
     &                     seq_work.j(1),seq_work.j(seq_idx),
     &                     eelecij_value(my_thread),
     &                     eelecij_array(my_thread),
     &                     th_data,scal_el)
            LOG_STAT(302,seq_idx)
            seq_idx=0
          endif
          call eelec_queue_work(nseq_work,nseq_idx,i,j,
     &                          xyzj,rij,full)
          lastj=j
          if(full) then
            call EELEC_NSEQ(nseq_work,lasti,
     &                      1,nseq_idx,
     &                      eelecij_value(my_thread),
     &                      eelecij_array(my_thread),
     &                      th_data,scal_el)
            LOG_STAT(303,nseq_idx)
            nseq_idx=0
            lastj=-1
          endif
        endif
      enddo

      if(seq_idx.gt.0) then
        call EELEC_SEQ(seq_work,lasti,
     &                 seq_work.j(1),seq_work.j(seq_idx),
     &                 eelecij_value(my_thread),
     &                 eelecij_array(my_thread),
     &                 th_data,scal_el)
        LOG_STAT(302,seq_idx)
      endif
      if(nseq_idx.gt.0) then
        call EELEC_NSEQ(nseq_work,lasti,
     &                  1,nseq_idx,
     &                  eelecij_value(my_thread),
     &                  eelecij_array(my_thread),
     &                  th_data,scal_el)
        LOG_STAT(303,nseq_idx)
      endif
!$OMP END PARALLEL
      return
      end
C-------------------------------------------------------------------------------
      subroutine EELECIJ2(threads_used)
#ifdef _OPENMP
      use omp_lib
#endif
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.SPLITELE'
#ifdef SHIELD
      include 'COMMON.EELEC.SHIELD'
#else
      include 'COMMON.EELEC'
#endif
      include 'COMMON.LIPID'
      include 'COMMON.NEWBOX'
      integer threads_used
      integer from_blk,to_blk,from_j,to_j
      double precision xyzj(3),rij
      integer my_thread,from,to
      integer lastj,i,j,ikont,jblock,item,seq_idx,nseq_idx
      integer from_ik,to_ik,first_blk,last_blk,first_j,last_j
      double precision box(3),halfbox(3)
      record /eelecij_work_chunk/ seq_work
      record /eelecij_work_chunk/ nseq_work
      record /eelec_thread_data/ th_data
      logical full,limited
      double precision scalar

      threads_used = pp_threads

!$OMP PARALLEL IF(threads_used.gt.1)
!$OMP& NUM_THREADS(threads_used) DEFAULT(SHARED)
!$OMP& PRIVATE(
!$OMP&   i,j,ikont,jblock,xyzj,rij,lastj,from_j,to_j,
!$OMP&   seq_work,seq_idx,nseq_work,nseq_idx,full,
!$OMP&   from_ik,to_ik,first_blk,last_blk,first_j,last_j,
!$OMP&   box,halfbox,
!$OMP&   my_thread,item,from,to,from_blk,to_blk,th_data
!$OMP& )
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif
      call eelec_fill_thread_data(th_data)

      seq_idx=0
      nseq_idx=0
      lastj=0

      from_ik=pp_from_ik(my_thread)
      to_ik=pp_to_ik(my_thread)
      first_blk=pp_first_blk(my_thread)
      last_blk=pp_last_blk(my_thread)
      first_j=pp_first_j(my_thread)
      last_j=pp_last_j(my_thread)
      box=boxsize
      halfbox=halfboxsize

      do ikont=from_ik,to_ik
        i=newcontlistppi(1,ikont)
        from_blk=newcontlistppi(2,ikont-1)+1
        to_blk=newcontlistppi(2,ikont)

        if(ikont.eq.from_ik) from_blk=first_blk
        if(ikont.eq.to_ik) to_blk=last_blk

        lastj=-1

        do jblock=from_blk,to_blk
          from_j=newcontlistppj(1,jblock)
          to_j=newcontlistppj(2,jblock)
          if((ikont.eq.from_ik).and.(jblock.eq.from_blk)) from_j=first_j
          if((ikont.eq.to_ik).and.(jblock.eq.to_blk)) to_j=last_j

          do j=from_j,to_j
            LOG_STAT(300,1)
            !call wrapvec(cp(:,j)-cp(:,i),xyzj)
            call wrapvec2(cp(:,j)-cp(:,i),xyzj,halfbox,box)
            rij=scalar(xyzj,xyzj)
            if(rij.ge.r_cut_int_sq) cycle
            LOG_STAT(301,1)

            if((j.eq.lastj+1).or.(seq_idx.eq.0)) then
              call eelec_queue_work(seq_work,seq_idx,i,j,
     &                              xyzj,rij,full)
              lastj=j
              if(full) then
                call EELEC_SEQ(seq_work,i,
     &                         seq_work.j(1),seq_work.j(seq_idx),
     &                         eelecij_value(my_thread),
     &                         eelecij_array(my_thread),
     &                         th_data,1.0d0)
                LOG_STAT(302,seq_idx)
                seq_idx=0
                lastj=-1
              endif
            else
              if((seq_idx.lt.simd_seq_cutoff) .and.
     &           (nseq_idx+seq_idx.lt.eelec_buffer_size)) then
                LOG_STAT(304,seq_idx)
                call eelecij_move_work(seq_work,seq_idx,
     &                                 nseq_work,nseq_idx)
              else
                call EELEC_SEQ(seq_work,i,
     &                         seq_work.j(1),seq_work.j(seq_idx),
     &                         eelecij_value(my_thread),
     &                         eelecij_array(my_thread),
     &                         th_data,1.0d0)
                LOG_STAT(302,seq_idx)
                seq_idx=0
              endif
              call eelec_queue_work(nseq_work,nseq_idx,
     &                              i,j,xyzj,rij,
     &                              full)
              lastj=j
              if(full) then
                call EELEC_NSEQ(nseq_work,i,
     &                          1,nseq_idx,
     &                          eelecij_value(my_thread),
     &                          eelecij_array(my_thread),
     &                          th_data,1.0d0)
                LOG_STAT(303,nseq_idx)
                nseq_idx=0
                lastj=-1
              endif
            endif
          enddo  ! j
        enddo  ! jblock

        if(seq_idx.gt.0) then
          call EELEC_SEQ(seq_work,i,
     &                   seq_work.j(1),seq_work.j(seq_idx),
     &                   eelecij_value(my_thread),
     &                   eelecij_array(my_thread),
     &                   th_data,1.0d0)
          LOG_STAT(302,seq_idx)
          seq_idx=0
        endif
        if(nseq_idx.gt.0) then
          call EELEC_NSEQ(nseq_work,i,
     &                    1,nseq_idx,
     &                    eelecij_value(my_thread),
     &                    eelecij_array(my_thread),
     &                    th_data,1.0d0)
          LOG_STAT(303,nseq_idx)
          nseq_idx=0
        endif
      enddo  ! ikont
!$OMP END PARALLEL

      return
      end
