      subroutine set_matrices
      use omp_lib
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include "mpif.h"
      include "COMMON.SETUP"
      integer IERR
      integer status(MPI_STATUS_SIZE)
#endif
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.CORRMAT'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      double precision auxvec(3),auxvec1(3),auxmat(2,2),mudertemp(3,3)
      double precision sint1,cost1,sint1sq,sint1cub,sint2,cost2
      double precision aux,aux1,aux2
      integer i,ii,iti,iti1,innt,inct,j,k,l

C
C Compute the virtual-bond-torsional-angle dependent quantities needed
C to calculate the el-loc multibody terms of various order.
C
c      write(iout,*) 'nphi=',nphi,nres
c      write(iout,*) "itype2loc",itype2loc
!$OMP PARALLEL DO DEFAULT(SHARED)
!$OMP& PRIVATE(k,l,ii,iti,iti1,innt,inct,
!$OMP&         sint1,cost1,sint1sq,sint1cub)
      do i=1,nres-1
        ii=ireschain(i)
c       write (iout,*) "i",i,i-2," ii",ii
        if (ii.eq.0) cycle
        innt=chain_border(1,ii)
        inct=chain_border(2,ii)
c       write (iout,*) "i",i,i-2," ii",ii," innt",innt," inct",inct
c       if (i.gt. nnt+2 .and. i.lt.nct+2) then 
        if (i.gt. innt .and. i.lt.inct) then 
          iti=itype2loc(itype(i))
        else
          iti=nloctyp
        endif
c       if (i.gt. iatel_s+1 .and. i.lt.iatel_e+4) then
        if (i.gt.innt-1 .and. i.lt.inct-1) then 
          iti1=itype2loc(itype(i+1))
        else
          iti1=nloctyp
        endif
c       write(iout,*),"i",i,i-2," iti",itype(i-2),iti,
c     &  " iti1",itype(i-1),iti1
c 11/8/2021 AL: Change to the derivatives in cos(theta), not in theta.
        cost1=costtab(i+1)
        sint1=sinttab(i+1)
        sint1sq=sint1*sint1
        sint1cub=sint1sq*sint1
c       write (iout,*) "bnew1",i,iti
c       write (iout,*) (bnew1(k,1,iti),k=1,3)
c       write (iout,*) (bnew1(k,2,iti),k=1,3)
c       write (iout,*) "bnew2",i,iti
c       write (iout,*) (bnew2(k,1,iti),k=1,3)
c       write (iout,*) (bnew2(k,2,iti),k=1,3)
        do k=1,2
          b1(k,i)=bnew1(1,k,iti)
     &      +(bnew1(2,k,iti)+bnew1(3,k,iti)*cost1)*cost1
          gtb1(k,i)=bnew1(2,k,iti)+2*bnew1(3,k,iti)*cost1
          b2(k,i)=bnew2(1,k,iti)
     &      +(bnew2(2,k,iti)+bnew2(3,k,iti)*cost1)*cost1
          gtb2(k,i)=bnew2(2,k,iti)+2*bnew2(3,k,iti)*cost1
        enddo
        do k=1,2
          do l=1,2
c            aux=eenew(1,l,k,iti)+eenew(2,l,k,iti)*cost1
c            EE(l,k,i)=sint1sq*aux
c            gtEE(l,k,i)=aux-2*cost1*eenew(2,l,k,iti)
            EE(l,k,i)=(eenew(1,l,k,iti)+eenew(2,l,k,iti)*cost1)*sint1
            gtEE(l,k,i)=eenew(2,l,k,iti)*sint1-
     &        (eenew(1,l,k,iti)+eenew(2,l,k,iti)*cost1)*cost1/sint1
          enddo
        enddo
        EE(1,1,i)=EE(1,1,i)+e0new(1,iti)*cost1/sint1
        EE(1,2,i)=EE(1,2,i)+(e0new(2,iti)+e0new(3,iti)*cost1)/sint1
        EE(2,1,i)=EE(2,1,i)+(e0new(2,iti)*cost1+e0new(3,iti))/sint1
        EE(2,2,i)=EE(2,2,i)-e0new(1,iti)/sint1
        gtEE(1,1,i)=gtEE(1,1,i)+e0new(1,iti)/sint1cub
        gtEE(1,2,i)=gtEE(1,2,i)+e0new(3,iti)/sint1+
     &     (e0new(2,iti)+e0new(3,iti)*cost1)*cost1/sint1cub
        gtEE(2,1,i)=gtEE(2,1,i)+e0new(2,iti)/sint1+
     &     (e0new(3,iti)+e0new(2,iti)*cost1)*cost1/sint1cub
        gtEE(2,2,i)=gtEE(2,2,i)-e0new(1,iti)*cost1/sint1cub
c        b1tilde(1,i-2)=b1(1,i-2)
c        b1tilde(2,i-2)=-b1(2,i-2)
c        b2tilde(1,i-2)=b2(1,i-2)
c        b2tilde(2,i-2)=-b2(2,i-2)
#ifdef DEBUG
        write (iout,*) 'i=',i,gtb1(2,i),gtb1(1,i)
        write(iout,*)  'b1=',(b1(k,i),k=1,2)
        write(iout,*)  'b2=',(b2(k,i),k=1,2)
        write (iout,*) 'theta=', theta(i)
#endif
      enddo ! i
      mu(:,:nres)=0.0d0
      !muder(:,:,:,:nres)=0.0d0
      muder(:,:,:,-1:nres+1)=0.0d0
c      write (iout,*) "dc_norm"
c      do i=1,nres
c         write (iout,*) i,dc_norm(:,i)
c      enddo
!$OMP PARALLEL DO DEFAULT(SHARED)
!$OMP& PRIVATE(j,k,cost1,cost2,sint1,sint2,aux,aux1,aux2,
!$OMP&         auxvec,auxvec1,mudertemp)
      do i=1,nres-1
c        if (itype(i-1).eq.ntyp1 .and. itype(i).eq.ntyp1) cycle
c        write (iout,*) "dipole i",i,itype(i),itype(i+1)
        if (iabs(itype(i)).ne.ntyp1.and.iabs(itype(i+1)).ne.ntyp1) then
          cost1=costtab(i+1)
          cost2=costtab(i+2)
          sint1=sinttab(i+1)
          sint2=sinttab(i+2)
c          write (iout,*) "i",i," uz_dc(:,i)",uz_dc(:,i),
c     &     " uz_dc(:,i-1)",uz_dc(:,i-1)
          mu(:,i)=b2(1,i)*dC_norm(:,i-1)+b1(1,i+1)*dC_norm(:,i+1)
     &            +(b2(1,i)*cost1+b1(1,i+1)*cost2)*dC_norm(:,i)
     &             -b2(2,i)*uz_dc(:,i-1)-b1(2,i+1)*uz_dc(:,i)
C Derivatives of mu(:,i) in dC(:,i-1)
          aux=vbld_inv(i)*b2(1,i)
          aux1=cost1*gtb2(1,i)+b2(1,i)
          aux2=gtb2(1,i)
c          write (iout,*) "aux",aux," aux1",aux1," aux2",aux2,
c     &      " gtb2",gtb2(1,i)
          auxvec=vbld_inv(i)*b2(2,i)*dC_norm(:,i-1)
          auxvec1=vbld_inv(i)*b2(2,i)*dC_norm(:,i)
c          write (iout,*) "auxvec",auxvec
          call mucrossgrad(auxvec,auxvec1,uz_dc(1,i-1),mudertemp(1,1))
          muder(:,:,1,i)=muder(:,:,1,i)-mudertemp(:,:)
c          write (iout,*) "i",i," muderz1",mudertemp(:,:)
          do j=1,3
            do k=1,3
              muder(k,j,1,i)=muder(k,j,1,i)-
     &         dC_norm(k,i-1)*dC_norm(j,i-1)*aux+
     &         dC_norm(k,i)*dcosttab(j,1,i+1)*aux1+
     &         dC_norm(k,i-1)*dcosttab(j,1,i+1)*aux2-
     &         gtb2(2,i)*uz_dc(k,i-1)*dcosttab(j,1,i+1)
            enddo
            muder(j,j,1,i)=muder(j,j,1,i)+aux
          enddo
C Derivatives of mu(:,i) in dC(:,i+1)
          aux=vbld_inv(i+2)*b1(1,i+1)
          aux1=cost2*gtb1(1,i+1)+b1(1,i+1)
          aux2=gtb1(1,i+1)
c          write (iout,*) "aux",aux," aux1",aux1," aux2",aux2,
c     &      " gtb2",gtb2(1,i)
          auxvec=-vbld_inv(i+2)*b1(2,i+1)*dC_norm(:,i+1)
          auxvec1=vbld_inv(i+2)*b1(2,i+1)*dC_norm(:,i)
c          write (iout,*) "auxvec",auxvec
          call mucrossgrad(auxvec,auxvec1,uz_dc(1,i),mudertemp(1,1))
          muder(:,:,3,i)=muder(:,:,3,i)+mudertemp(:,:)
c          write (iout,*) "i",i," muderz3",mudertemp(:,:)
c          write (iout,*) "aux",aux," aux1",aux1
c          muder(:,:,3,i)=-muder(:,:,3,i)
          do j=1,3
            do k=1,3
              muder(k,j,3,i)=muder(k,j,3,i)-
     &         dC_norm(k,i+1)*dC_norm(j,i+1)*aux+
     &         dC_norm(k,i)*dcosttab(j,2,i+2)*aux1+
     &         dC_norm(k,i+1)*dcosttab(j,2,i+2)*aux2-
     &         gtb1(2,i+1)*uz_dc(k,i)*dcosttab(j,2,i+2)
            enddo
            muder(j,j,3,i)=muder(j,j,3,i)+aux
          enddo
c Derivatives of mu(:,i) in dC(:,i)
          aux=vbld_inv(i+1)*(b2(1,i)*cost1+b1(1,i+1)*cost2)
          aux1=cost1*gtb2(1,i)+b2(1,i)
          aux2=cost2*gtb1(1,i+1)+b1(1,i+1)
c          write (iout,*) "aux",aux," aux1",aux1
          auxvec=-vbld_inv(i+1)*b2(2,i)*dC_norm(:,i)
          auxvec1=vbld_inv(i+1)*b2(2,i)*dC_norm(:,i-1)
          call mucrossgrad(auxvec,auxvec1,uz_dc(1,i-1),mudertemp(1,1))
c          write (iout,*) "i",i," muderz21",mudertemp(:,:)
          muder(:,:,2,i)=muder(:,:,2,i)+mudertemp(:,:)
          auxvec=vbld_inv(i+1)*b1(2,i+1)*dC_norm(:,i)
          auxvec1=vbld_inv(i+1)*b1(2,i+1)*dC_norm(:,i+1)
c          write (iout,*) "auxvec",auxvec
          call mucrossgrad(auxvec,auxvec1,uz_dc(1,i),mudertemp(1,1))
          muder(:,:,2,i)=muder(:,:,2,i)-mudertemp(:,:)
c          write (iout,*) "i",i," muderz22",mudertemp(:,:)
          do j=1,3
            do k=1,3
              muder(k,j,2,i)=muder(k,j,2,i)+
     &         gtb2(1,i)*dC_norm(k,i-1)*dcosttab(j,2,i+1)-
     &         dC_norm(k,i)*dC_norm(j,i)*aux+
     &         dC_norm(k,i)*dcosttab(j,2,i+1)*aux1+
     &         dC_norm(k,i)*dcosttab(j,1,i+2)*aux2+
     &         gtb1(1,i+1)*dC_norm(k,i+1)*dcosttab(j,1,i+2)-
     &         gtb2(2,i)*uz_dc(k,i-1)*dcosttab(j,2,i+1)-
     &         gtb1(2,i+1)*uz_dc(k,i)*dcosttab(j,1,i+2)
            enddo
            muder(j,j,2,i)=muder(j,j,2,i)+aux
          enddo
          Ug(1,1,i)=-cphsth1sth2tab(i+2)
          Ug(1,2,i)=-sphsth1sth2tab(i+2)
          Ug(2,1,i)=-sphsth1sth2tab(i+2)
          Ug(2,2,i)= cphsth1sth2tab(i+2)
          call matmat2(EE(1,1,i),Ug(1,1,i),EUg(1,1,i))
          call matmat2(gtEE(1,1,i),Ug(1,1,i),gtEUg(1,1,i))
        endif
      enddo
#ifdef DEBUG
      write (iout,*) "Vectors mu"
      do i=1,nres-1
        write (iout,'(2hmu,i3,3f8.1,12f10.5)') i,rad2deg*theta(i+2),
     &   rad2deg*theta(i+3),rad2deg*phi(i+3),mu(1,i),mu(2,i),mu(3,i),
     &       -b2(1,i),b2(2,i),b1(1,i+1),b1(2,i+1),
     &       dsqrt(b2(1,i)**2+b2(2,i)**2)
     &      +dsqrt(b1(1,i+1)**2+b1(2,i+1)**2),
     &      ((ee(l,k,i),l=1,2),k=1,2)
      enddo
#endif
#ifdef DEBUG
      write (iout,*) "Array MUDER"
      do i=1,nres-1
        write (iout,'(i5,3(3f10.5,5x))') 
     &    i,((muder(l,k,1,i),l=1,3),k=1,3)
        write (iout,'(5x,3(3f10.5,5x))') 
     &    ((muder(l,k,2,i),l=1,3),k=1,3)
        write (iout,'(5x,3(3f10.5,5x))') 
     &    ((muder(l,k,3,i),l=1,3),k=1,3)
      enddo
#endif
#ifdef DEBUG
      write (iout,*) "Arrays EE UG and EUG"
      do i=1,nres-1
        write (iout,'(i5,4f10.5,5x,4f10.5,5x,4f10.5)') i,
     &   ((ee(l,k,i),l=1,2),k=1,2),
     &   ((ug(l,k,i),l=1,2),k=1,2),
     &   ((eug(l,k,i),l=1,2),k=1,2)
      enddo
#endif
      return
      end
C-----------------------------------------------------------------------------
      subroutine mucrossgrad(u,v,uz,muder)
      implicit none
      double precision u(3),v(3),uz(3),muder(3,3)
c      write (2,*) "uz",uz
c      write (2,*) "u",u
c      write (2,*) "v",v
      muder(1,1)=      -u(1)*uz(1)
      muder(1,2)=  v(3)-u(2)*uz(1) 
      muder(1,3)= -v(2)-u(3)*uz(1) 
      muder(2,1)= -v(3)-u(1)*uz(2) 
      muder(2,2)=      -u(2)*uz(2)
      muder(2,3)=  v(1)-u(3)*uz(2) 
      muder(3,1)=  v(2)-u(1)*uz(3) 
      muder(3,2)= -v(1)-u(2)*uz(3) 
      muder(3,3)=      -u(3)*uz(3)
      return
      end
C-----------------------------------------------------------------------------
      subroutine vecpr(u,v,w)
      implicit real*8(a-h,o-z)
      dimension u(3),v(3),w(3)
      w(1)=u(2)*v(3)-u(3)*v(2)
      w(2)=-u(1)*v(3)+u(3)*v(1)
      w(3)=u(1)*v(2)-u(2)*v(1)
      return
      end
C-----------------------------------------------------------------------------
      subroutine unormderiv(u,ugrad,unorm,ungrad)
C This subroutine computes the derivatives of a normalized vector u, given
C the derivatives computed without normalization conditions, ugrad. Returns
C ungrad.
      implicit none
      double precision u(3),ugrad(3,3),unorm,ungrad(3,3)
      double precision vec(3)
      double precision scalar
      integer i,j
c      write (2,*) 'ugrad',ugrad
c      write (2,*) 'u',u
      do i=1,3
        vec(i)=scalar(ugrad(1,i),u(1))
      enddo
c      write (2,*) 'vec',vec
      do i=1,3
        do j=1,3
          ungrad(j,i)=(ugrad(j,i)-u(j)*vec(i))*unorm
        enddo
      enddo
c      write (2,*) 'ungrad',ungrad
      return
      end
