      subroutine Econstr_back
c     MD with umbrella_sampling using Wolyne's distance measure as a constraint
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.VAR'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
#ifndef LANG0
      include 'COMMON.LANGEVIN'
#else
#ifdef FIVEDIAG
      include 'COMMON.LANGEVIN.lang0.5diag'
#else
      include 'COMMON.LANGEVIN.lang0'
#endif
#endif
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.TIME1'
      integer i,j,ii,k
      double precision utheta_i,dtheta_i,ugamma_i,dgamma_i,dxx,dyy,dzz
      double precision pinorm
      Uconst_back=0.0d0
      do i=1,nres
        dutheta(i)=0.0d0
        dugamma(i)=0.0d0
        do j=1,3
          duscdiff(j,i)=0.0d0
          duscdiffx(j,i)=0.0d0
        enddo
      enddo
      do i=1,nfrag_back
        ii = ifrag_back(2,i,iset)-ifrag_back(1,i,iset)
c
c Deviations from theta angles
c
        utheta_i=0.0d0
        do j=ifrag_back(1,i,iset)+2,ifrag_back(2,i,iset)
          dtheta_i=theta(j)-thetaref(j)
          utheta_i=utheta_i+0.5d0*dtheta_i*dtheta_i
          dutheta(j-2)=dutheta(j-2)+wfrag_back(1,i,iset)*dtheta_i/(ii-1)
        enddo
        utheta(i)=utheta_i/(ii-1)
c
c Deviations from gamma angles
c
        ugamma_i=0.0d0
        do j=ifrag_back(1,i,iset)+3,ifrag_back(2,i,iset)
          dgamma_i=pinorm(phi(j)-phiref(j))
c          write (iout,*) j,phi(j),phi(j)-phiref(j)
          ugamma_i=ugamma_i+0.5d0*dgamma_i*dgamma_i
          dugamma(j-3)=dugamma(j-3)+wfrag_back(2,i,iset)*dgamma_i/(ii-2)
c          write (iout,*) i,j,dgamma_i,wfrag_back(2,i,iset),dugamma(j-3)
        enddo
        ugamma(i)=ugamma_i/(ii-2)
c
c Deviations from local SC geometry
c
        uscdiff(i)=0.0d0
        do j=ifrag_back(1,i,iset)+1,ifrag_back(2,i,iset)-1
          dxx=xxtab(j)-xxref(j)
          dyy=yytab(j)-yyref(j)
          dzz=zztab(j)-zzref(j)
          uscdiff(i)=uscdiff(i)+dxx*dxx+dyy*dyy+dzz*dzz
          do k=1,3
            duscdiff(k,j-1)=duscdiff(k,j-1)+wfrag_back(3,i,iset)*
     &       (dXX_C1tab(k,j)*dxx+dYY_C1tab(k,j)*dyy+dZZ_C1tab(k,j)*dzz)/
     &       (ii-1)
            duscdiff(k,j)=duscdiff(k,j)+wfrag_back(3,i,iset)*
     &       (dXX_Ctab(k,j)*dxx+dYY_Ctab(k,j)*dyy+dZZ_Ctab(k,j)*dzz)/
     &       (ii-1)
            duscdiffx(k,j)=duscdiffx(k,j)+wfrag_back(3,i,iset)*
     &     (dXX_XYZtab(k,j)*dxx+dYY_XYZtab(k,j)*dyy+dZZ_XYZtab(k,j)*dzz)
     &      /(ii-1)
          enddo
c          write (iout,'(i5,6f10.5)') j,xxtab(j),yytab(j),zztab(j),
c     &      xxref(j),yyref(j),zzref(j)
        enddo
        uscdiff(i)=0.5d0*uscdiff(i)/(ii-1)
c        write (iout,*) i," uscdiff",uscdiff(i)
c
c Put together deviations from local geometry
c
        Uconst_back=Uconst_back+wfrag_back(1,i,iset)*utheta(i)+
     &    wfrag_back(2,i,iset)*ugamma(i)+wfrag_back(3,i,iset)*uscdiff(i)
c        write(iout,*) "i",i," utheta",utheta(i)," ugamma",ugamma(i),
c     &   " uconst_back",uconst_back
        utheta(i)=dsqrt(utheta(i))
        ugamma(i)=dsqrt(ugamma(i))
        uscdiff(i)=dsqrt(uscdiff(i))
      enddo
      return
      end
