C************************************************************************
C                              AMBER                                   **
C                                                                      **
C                  Copyright (c) 1986, 1991, 1995                      **
C             Regents of the University of California                  **
C                       All Rights Reserved.                           ** 
C                                                                      **
C  This software provided pursuant to a license agreement containing   **
C  restrictions on its disclosure, duplication, and use. This software **
C  contains confidential and proprietary information, and may not be   **
C  extracted or distributed, in whole or in part, for any purpose      **
C  whatsoever, without the express written permission of the authors.  **
C  This notice, and the associated author list, must be attached to    **
C  all copies, or extracts, of this software. Any additional           **
C  restrictions set forth in the license agreement also apply to this  **
C  software.                                                           **
C************************************************************************
C
      SUBROUTINE AVEINT(XAVE,XAVE0,XAVEAVE,XNOW,TAU,DT,NAVINT,IPOWER,
     *              ITYPE,INCFLG,IFLAG,XAVER,DENOM)
C
C Subroutine AVErage INTernals.
C
C This routine evaluates and updates the integrals needed to perform 
C time-averaging
C
C Author: David A. Pearlman
C Date: 5/90
C
C Algorithm:
C     Internals are averaged using inverse weighting to the 
C IPOWER power (thus IPOWER = -1 gives straight linear weighting). In
C addition, an exponential decay function is included, so that the
C weighted average will continue to reflect the most recent values
C of the internals--even during long simulations.
C
C The formula for the time-averaged values is:
C
C                  t
C   rbar = 1/C * {int (exp(tp-t)/tau) r(tp)**-ipower dtp} **-1/ipower   (1)
C                  0
C
C where int = integral (from 0-> t)
C      rbar = average value of internal
C         t = current time
C       tau = exponential decay constant
C     r(tp) = value of internal at time tp
C    ipower = average is over internals to the inverse ipower.
C             Usually ipower = 3 for NOE distances, -1 for angles and
C             torsions
C         C = normalization integral.
C
C To minimize memory storage, we evaluate the integral as
C
C    t
C   int (exp(tp-t)/tau) r(tp)**-ipower dtp =
C    0
C
C                   t-dt
C      exp(-dt/tau) int (exp(tp-t)/tau) r(tp)**-ipower dtp +
C                    0
C
C                    t
C                   int (exp(tp-t)/tau) r(tp)**-ipower dtp
C                   t-dt
C
C INPUT:
C  XAVE(I)  : On input: XAVE(1) contains the value of the time-integral 
C                       shown above for the bounds 0->t-dt..
C                       XAVE(2) contains r(t-dt)**-ipower
C             On output (if IFLAG.NE.2)
C                       XAVE(1) contains the value of the time-integral
C                       shown above for the bounds 0->t.
C                       XAVE(2) contains r(t)**-ipower
C
C XAVE0(I)  : Same as XAVE(1), except that the integral stored does not
C             reflect exponential weighting (a real time-average).
C  XNOW     : Current value of the internal on this call.
C  TAU      : Characteristic time for the exponential decay.
C             If TAU >= 1.D+6, then the non-exponential-damped values
C             in XAVE0() will be used.
C  DT       : The moleular dynamics timestep.
C  NAVINT   : The current value of the internal is only stored every
C             NAVINT steps (typically 1).
C  IPOWER   : The exponent used in creating the weighted average. Standard
C             values would be 3 for distances (resulting in **-3 weighting)
C             and -1 for angles (resulting in **1/non-exponential weighting).
C  ITYPE    : = 1 for bonds; =2 for angles; =3 for torsions (cos(tau));
C             = 4 for torsions (sin(tau)).
C INCFLG    : Determines whether local saved pointers are updated
C             on this call.
C             INCFLG = 0 -- pointers are _not_ updated.
C             INCFLG = 1 -- pointers are updated.
C             Pointers should only be updated on the first call to AVEINT
C             for each restraint type (bond, angle, torsion) in any call
C             to NMRNRG.
C  IFLAG    : Determines behavior on this call.
C             IFLAG <= 1 -- Update the integral to reflect the value in XNOW,
C                           set XAVE(2) to XNOW, and return
C                           the calculated averaged value XAVE/DENOM.
C             IFLAG  = 2 -- Just return the calculated values XAVE/DENOM
C
C OUTPUT:
C  XAVER    : The calculated time-averaged value for the internal.
C  DENOM    : The value of the exponential weight-factor divisor integral
C
C LOCAL COMMON:
C  NSTEPS(4): The number of calls with IFLAG.LE.1 (i.e. calls where
C             the integral sum was updated)
C ICALLS(4) : Number of calls with IFLAG=0 or 1.
C
#ifdef DPREC
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#endif
      DIMENSION XAVE(2),XAVE0(2),XAVEAVE(2)
      include 'COMMON.AVNLOC'
C
C Initialize values on first call
C
      IF (IONCE.NE.4899) THEN
          DO 5 I = 1,4
              NSTEPS(I) = 0
              ICALLS(I) = 0
    5     CONTINUE
          IONCE = 4899
      END IF
C
C 4/2/2024 AL: Initialize XAVE_temp and XAVE0_temp in case of restart
C
      XAVE_temp=xave(1)
      XAVE0_temp=xave0(1)
C
C DTU is the time-step (modified to reflect NAVINT if it is not 1)
C
      DTU = DT * FLOAT(NAVINT)
C
C This section stores the value
C
      IF (IFLAG.LE.1) THEN
        ICALLS(ITYPE) = ICALLS(ITYPE) + INCFLG
C
        IF (MOD(ICALLS(ITYPE)-1,NAVINT).EQ.0) THEN
C        IF (MOD(ICALLS(ITYPE),NAVINT).EQ.0) THEN
          NSTEPS(ITYPE) = NSTEPS(ITYPE) + INCFLG
C
C Update the integral summation using Simpsons rule to calculate the
C integral over the last interval.
C
C On the first step, set the integral to zero.
C XAVE(1) stores the integral with exponential decay. XAVE0(1) stores
C the integral without the exponential decay weighting factor.
C
          XNOWP = XNOW**(-IPOWER)
          IF (NSTEPS(ITYPE).LE.1) THEN
             XAVE_temp = 0.0D0
             XAVE0_temp = 0.0D0
          ELSE
             XAVE_temp = EXP(-DTU/TAU)*XAVE(1) + 
     *                 (EXP(-DTU/TAU)*XAVE(2) + XNOWP) * (DTU/2.0D0)
             XAVE0_temp = XAVE0(1) + (XAVE(2) + XNOWP) * (DTU/2.0D0)
          END IF
        ELSE
C
C AL 4/2/2024: Latest value calculated to include in the current average 
C in order to get correct gradient when NAVINT.GT.1 but the average not updated.
C
          XNOWP = XNOW**(-IPOWER)
C
C AL 4/2/2024: When NAVINT.GT.1, XAVE(2) stores the sum of values being averaged
C corresponding to the current NSTEPS(ITYPE), when NAVINT.EQ.1 it is equal to
C the current value being averaged. 
C
          XAVEAVE(1)=XAVEAVE(1)+XNOWP
          XAVE_temp = EXP(-DTU/TAU)*XAVE(1) + 
     *              (EXP(-DTU/TAU)*XAVE(2) + XNOWP) * (DTU/2.0D0)
          XAVE0_temp = XAVE0(1) + (XAVE(2) + XNOWP) * (DTU/2.0D0)
        END IF
      END IF
C
C This section calculates the average:
C
C TP is the current time, modified to reflect NAVINT 
C
      TP = FLOAT(NSTEPS(ITYPE)-1)*DTU  
C
C On the first step, the current value is the average:
C
      IF (NSTEPS(ITYPE).LE.1) THEN
         XAVER = XNOW
         DENOM = 1.0D0
C         RETURN
      ELSE 
C
C AL 4/2/2024: Current average calculated taking into account the current
C value in order to get correct gradient when NAVINT.GT.1 (see above) 
C
         XPON = -1.0D0/FLOAT(IPOWER)
         IF (TAU.LT.1.D+6) THEN
            DENOM = TAU*(1.0D0 - EXP(-TP/TAU))
c            XAVER = SIGN((ABS(XAVE(1)/DENOM))**XPON,XAVE(1)/DENOM)
            XAVER = SIGN((ABS(XAVE_temp/DENOM))**XPON,XAVE_temp/DENOM)
         ELSE
            DENOM = TP
c            XAVER = SIGN((ABS(XAVE0(1)/DENOM))**XPON,XAVE0(1)/DENOM)
            XAVER = SIGN((ABS(XAVE0_temp/DENOM))**XPON,XAVE0_temp/DENOM)
         END IF
      END IF
C      IF (MOD(ICALLS(ITYPE)-1,NAVINT).EQ.0) THEN
c      write (2,*) "icalls",icalls(itype)," navint",navint," mod",
c     &  MOD(ICALLS(ITYPE),NAVINT)
      IF (IFLAG.LE.1 .AND. MOD(ICALLS(ITYPE),NAVINT).EQ.0) THEN
c        write (2,*) "AVEINT AVEAVE MOD"
C
C AL 4/2/2024: For NAVINT.GT.1, XNOWP at the end of the NSTEPS(ITYPE) period
C is the average value corresponding to the entire NSTEPS(ITYPE) period; 
C for NAVINT.EQ.1 it is the current value.
C
        XNOWP = (XAVEAVE(1)+XNOWP)/NAVINT
        IF (NSTEPS(1).LE.1) THEN
          XAVE(1)=0.0
          XAVE0(1)=0.0
        ELSE
          XAVE(1) = EXP(-DTU/TAU)*XAVE(1) + 
     *             (EXP(-DTU/TAU)*XAVE(2) + XNOWP) * (DTU/2.0D0)
          XAVE0(1) = XAVE0(1) + (XAVE(2) + XNOWP) * (DTU/2.0D0)
        ENDIF
        XAVE(2) = XNOWP
C
C AL 4/2/2024: Zero out XAVEAVE(1)
C
        XAVEAVE(1) = 0.0d0
      ENDIF
C
      RETURN
      END
