      subroutine vec_and_deriv
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.VECTORS'
      include 'COMMON.SETUP'
      include 'COMMON.TIME1'
      double precision uyder(3,3,2),uzder(3,3,2),vbld_inv_temp(2)
      double precision costh,fac,facy
      integer i,j,k,l
C Compute the local reference systems. For reference system (i), the
C X-axis points from CA(i) to CA(i+1), the Y axis is in the 
C CA(i)-CA(i+1)-CA(i+2) plane, and the Z axis is perpendicular to this plane.
c      write (iout,*) "VEC_AND_DERIV"
      uz_dc(:,0)=0.0d0
!$OMP PARALLEL DO DEFAULT(SHARED)
!$OMP& PRIVATE(uyder,uzder,costh,fac,facy,j,k,l)
      do i=1,nres-1
C Other residues
C Compute the Z-axis
        call vecpr(dc_norm(1,i),dc_norm(1,i+1),uz(1,i))
        costh=-costtab(i+2)
        fac=1.0d0/dsqrt(1.0d0-costh*costh)
        uz_dc(:,i)=uz(:,i)
        uz(:,i)=fac*uz(:,i)
C Compute the derivatives of uz
        uzder(1,1,1)= 0.0d0
        uzder(2,1,1)=-dc_norm(3,i+1)
        uzder(3,1,1)= dc_norm(2,i+1) 
        uzder(1,2,1)= dc_norm(3,i+1)
        uzder(2,2,1)= 0.0d0
        uzder(3,2,1)=-dc_norm(1,i+1)
        uzder(1,3,1)=-dc_norm(2,i+1)
        uzder(2,3,1)= dc_norm(1,i+1)
        uzder(3,3,1)= 0.0d0
        uzder(1,1,2)= 0.0d0
        uzder(2,1,2)= dc_norm(3,i)
        uzder(3,1,2)=-dc_norm(2,i) 
        uzder(1,2,2)=-dc_norm(3,i)
        uzder(2,2,2)= 0.0d0
        uzder(3,2,2)= dc_norm(1,i)
        uzder(1,3,2)= dc_norm(2,i)
        uzder(2,3,2)=-dc_norm(1,i)
        uzder(3,3,2)= 0.0d0
C Compute the Y-axis
        facy=fac
        do k=1,3
          uy(k,2,i)=facy*(dc_norm(k,i+1)-costh*dc_norm(k,i))
        enddo
C Compute the derivatives of uy
        do j=1,3
          do k=1,3
            uyder(k,j,1)=2*dc_norm(k,i+1)*dc_norm(j,i)
     &                    -dc_norm(k,i)*dc_norm(j,i+1)
            uyder(k,j,2)=-dc_norm(j,i)*dc_norm(k,i)
          enddo
          uyder(j,j,1)=uyder(j,j,1)-costh
          uyder(j,j,2)=1.0d0+uyder(j,j,2)
        enddo
        do j=1,2
          do k=1,3
            do l=1,3
              uygrad(l,k,j,2,i)=uyder(l,k,j)
              uzgrad(l,k,j,i)=uzder(l,k,j)
            enddo
          enddo
        enddo 
        call unormderiv(uy(1,2,i),uyder(1,1,1),facy,uygrad(1,1,1,2,i))
        call unormderiv(uy(1,2,i),uyder(1,1,2),facy,uygrad(1,1,2,2,i))
        call unormderiv(uz(1,i),uzder(1,1,1),fac,uzgrad(1,1,1,i))
        call unormderiv(uz(1,i),uzder(1,1,2),fac,uzgrad(1,1,2,i))
C The y axes of the system composed of the current and preceding dC
C vector
        costh=-costtab(i+1)
        fac=1.0d0/dsqrt(1.0d0-costh*costh)
        facy=fac
        do k=1,3
          uy(k,1,i)=fac*(dc_norm(k,i-1)-costh*dc_norm(k,i))
        enddo
C Compute the derivatives of uy
        do j=1,3
          do k=1,3
            uyder(k,j,2)=2*dc_norm(k,i-1)*dc_norm(j,i)
     &                    -dc_norm(k,i)*dc_norm(j,i-1)
            uyder(k,j,1)=-dc_norm(j,i)*dc_norm(k,i)
          enddo
          uyder(j,j,2)=uyder(j,j,2)-costh
          uyder(j,j,1)=1.0d0+uyder(j,j,1)
        enddo
#ifdef DEBUG
        write (iout,*) "i",i," uyder1"
        do j=1,3
          write (iout,'(i5,2(3f10.5,5x))') j,(uyder(j,k,1),k=1,3),
     &     (uyder(j,k,2),k=1,3)
        enddo
#endif
        do j=1,2
          do k=1,3
            do l=1,3
              uygrad(l,k,j,1,i)=uyder(l,k,j)
            enddo
          enddo
        enddo 
        call unormderiv(uy(1,1,i),uyder(1,1,1),facy,uygrad(1,1,1,1,i))
        call unormderiv(uy(1,1,i),uyder(1,1,2),facy,uygrad(1,1,2,1,i))
      enddo


!$OMP PARALLEL DO DEFAULT(SHARED) PRIVATE(vbld_inv_temp,j,k,l)
      do i=1,nres-1
        vbld_inv_temp(1)=vbld_inv(i)
        vbld_inv_temp(2)=vbld_inv(i+1)
        do j=1,2
          do k=1,3
            do l=1,3
              uygrad(l,k,j,1,i)=vbld_inv_temp(j)*uygrad(l,k,j,1,i)
            enddo
          enddo
        enddo
!     enddo
!     do i=1,nres-1
        vbld_inv_temp(1)=vbld_inv(i+1)
        vbld_inv_temp(2)=vbld_inv(i+2)
        do j=1,2
          do k=1,3
            do l=1,3
              uzgrad(l,k,j,i)=vbld_inv_temp(j)*uzgrad(l,k,j,i)
            enddo
          enddo
        enddo
!     enddo
!     do i=1,nres-1
!       vbld_inv_temp(1)=vbld_inv(i+1)
!       vbld_inv_temp(2)=vbld_inv(i+2)
        do j=1,2
          do k=1,3
            do l=1,3
              uygrad(l,k,j,2,i)=vbld_inv_temp(j)*uygrad(l,k,j,2,i)
            enddo
          enddo
        enddo
      enddo
#ifdef DEBUG
!     if (fg_rank.eq.0) then
        write (iout,*) "Arrays UY and UZ"
        do i=1,nres-1
          write (iout,*) "i",i
          do k=1,3
            write (iout,'(i5,2f10.5,5x,f10.5)') 
     &       k,uy(k,1,i),uy(k,2,i),uz(k,i)
          enddo
        enddo
        write (iout,*) "Array UYGRAD1"
        do i=1,nres-1
          write (iout,*) "i",i
          do k=1,3
            write (iout,'(i5,2(3f10.5,5x))') 
     &        k,((uygrad(k,l,j,1,i),l=1,3),j=1,2)
          enddo
        enddo
        write (iout,*) "Array UYGRAD2"
        do i=1,nres-1
          write (iout,*) "i",i
          do k=1,3
            write (iout,'(i5,2(3f10.5,5x))') 
     &        k,((uygrad(k,l,j,2,i),l=1,3),j=1,2)
          enddo
        enddo
        write (iout,*) "Array UZGRAD"
        do i=1,nres-1
          write (iout,*) "i",i
          do k=1,3
            write (iout,'(i5,2(3f10.5,5x))') 
     &        k,((uzgrad(k,l,j,i),l=1,3),j=1,2)
          enddo
        enddo
!     endif
#endif
      return
      end
