CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                              C
C                                U N R E S                                     C
C                                                                              C
C Program to carry out conformational search of proteins in an united-residue  C
C approximation.                                                               C
C                                                                              C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      implicit none
      include 'DIMENSIONS'


#ifdef MPI
      include 'mpif.h'
      include 'COMMON.SETUP'
#endif
      include 'COMMON.TIME1'
      include 'COMMON.LOCAL'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      include 'COMMON.GEO'
      include 'COMMON.HEADER'
      include 'COMMON.CONTROL'
c      include 'COMMON.CONTACTS'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.REMD'
      include 'COMMON.MD'
      include 'COMMON.SBRIDGE'
      include 'COMMON.MINIM'
      include 'COMMON.DERIV'
      include 'COMMON.TORSION'
      include 'COMMON.NEWBOX'
#ifdef SHIELD
      include 'COMMON.EELEC.SHIELD'
#else
      include 'COMMON.EELEC'
#endif
      include 'COMMON.ESCP'
      include 'COMMON.EGB'
      include 'COMMON.LIPID'
      include 'COMMON.GRID'
#ifdef SIMDSTAT
      include 'COMMON.SIMDSTAT'
#endif
      double precision hrtime,mintime,sectime
      character*64 text_mode_calc(-2:14) /'test',
     & 'SC rotamer distribution',
     & 'Energy evaluation or minimization',
     & 'Regularization of PDB structure',
     & 'Threading of a sequence on PDB structures',
     & 'Monte Carlo (with minimization) ',
     & 'Energy minimization of multiple conformations',
     & 'Checking energy gradient',
     & 'Entropic sampling Monte Carlo (with minimization)',
     & 'Energy map',
     & 'CSA calculations',
     & 'Not used 9',
     & 'Not used 10',
     & 'Soft regularization of PDB structure',
     & 'Mesoscopic molecular dynamics (MD) ',
     & 'Not used 13',
     & 'Replica exchange molecular dynamics (REMD)'/
      integer ilen,i
      external ilen
      integer ierr
#ifndef MPI
      double precision tcpu
#endif
!      do i=-ntyp1,ntyp1
!      print *,"TEST0",restyp(i),i,"one",onelet(i)
!
!      enddo

c      call memmon_print_usage()

      call init_task
#ifdef MPI
c      if (me.eq.king)
c     & write(iout,*)'### LAST MODIFIED  4/25/08 7:29PM by adam'
      if (me.eq.king) call cinfo
#else
c      write(iout,*)'### LAST MODIFIED  4/25/08 7:29PM by adam'
      call cinfo
#endif
C Read force field parameters and job setup data
      call readrtns
C
#ifdef DEBUG
      write (iout,*) "After readrtns"
      call flush(iout)
      call cartprint
      call intout
#endif

      call init_omp
      call init_grids
      call init_eelec

#ifdef MPI
      if (me.eq.king .or. .not. out1file) then
#endif
       write (iout,'(/2a/)')
     & text_mode_calc(modecalc)(:ilen(text_mode_calc(modecalc))),
     & ' calculation.'
       if (minim) write (iout,'(a)')
     &  'Conformations will be energy-minimized.'
       write (iout,'(80(1h*)/)')
       call flush(iout)
#ifdef MPI
      endif
#endif
C
      if (modecalc.eq.-2) then
c        call test
c        stop
      else if (modecalc.eq.-1) then
        write(iout,*) "call check_sc_map next"
        call check_bond
        stop
      endif
#ifdef MPI
      if (fg_rank.gt.0) then
C Fine-grain slaves just do energy and gradient components.
        call ergastulum ! slave workhouse in Latin
      else
#endif
      if (indpdb.eq.0 .and. .not.read_cart) call chainbuild
      if (indpdb.ne.0 .or. read_cart) then
        dc(1,0)=c(1,1)
        dc(2,0)=c(2,1)
        dc(3,0)=c(3,1)
      endif
      if (modecalc.eq.0) then
        write (iout,*) "Calling exec_eeval_or_minim"
        call exec_eeval_or_minim
      else if (modecalc.eq.1) then
        call exec_regularize
      else if (modecalc.eq.2) then
        call exec_thread
      else if (modecalc.eq.3 .or. modecalc .eq.6) then
        call exec_MC
      else if (modecalc.eq.4) then
        call exec_mult_eeval_or_minim
      else if (modecalc.eq.5) then
        call exec_checkgrad
      else if (ModeCalc.eq.7) then
        call exec_map
      else if (ModeCalc.eq.8) then
        call exec_CSA
      else if (modecalc.eq.11) then
        call exec_softreg
      else if (modecalc.eq.12) then
        call exec_MD
      else if (modecalc.eq.14) then
#ifdef MPI
        call exec_MREMD
#else
        write (iout,*) "Need a parallel version to run MREMD."
        stop
#endif
      else
        write (iout,'(a)') 'This calculation type is not supported',
     &   ModeCalc
      endif
#ifdef MPI
      endif
C Finish task.
      if (fg_rank.eq.0) call finish_task
c      call memmon_print_usage()
#ifdef TIMING
       call print_detailed_timing
#endif
      call MPI_Finalize(ierr)
#ifdef SIMDSTAT
      call simd_stat_report
#endif
#ifdef GRIDSTAT
      call grid_stat_report
#endif
      stop 'Bye Bye...'
#else
      call dajczas(tcpu(),hrtime,mintime,sectime)
#ifdef SIMDSTAT
      call simd_stat_report
#endif
      stop '********** Program terminated normally.'
#endif
      end
c--------------------------------------------------------------------------
      subroutine exec_MD
      implicit none
      double precision delta
      include 'DIMENSIONS'
#ifdef MPI
      include "mpif.h"
#endif
      include 'COMMON.SETUP'
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
c      if (me.eq.king .or. .not. out1file) then
c        write (iout,*) "Calling chainbuild"
c        call flush(iout)
c      endif
      call chainbuild
c      if (me.eq.king .or. .not. out1file) then
c        write (iout,*) "Calling MD"
c        call flush(iout)
c      endif
      call MD
#define CHECK_GRAD_AVE
#ifdef CHECK_GRAD_AVE
      write(iout,*),"Check ave gradient"
      icheckgrad=1
      aincr=1.0d-4
#define ZERO_WEIGHTS
#ifdef ZERO_WEIGHTS
      wsc=0.0d0
      wscp=0.0d0
      welec=0.0d0
      wcorr=0.0d0
      wcorr5=0.0d0
      wcorr6=0.0d0
      wel_loc=0.0d0
      wturn3=0.0d0
      wturn4=0.0d0
      wturn6=0.0d0
      wang=0.0d0
      wscloc=0.0d0
      wtor=0.0d0
      wtor_d=0.0d0
      wvdwpp=0.0d0
      wbond=0.0d0
#endif
#undef ZERO_WEIGHTS
      call exec_checkgrad
      write(iout,*)"End check ave gradient"
#endif
      return
      end
c---------------------------------------------------------------------------
#ifdef MPI
      subroutine exec_MREMD
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include "mpif.h"
#endif
      include 'COMMON.SETUP'
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.REMD'
      include 'COMMON.FFIELD'
      integer i
      if (me.eq.king .or. .not. out1file)
     &   write (iout,*) "Calling chainbuild"
      call chainbuild
      if (me.eq.king .or. .not. out1file)
     &   write (iout,*) "Calling REMD"
      if (remd_mlist) then
        call MREMD
      else
        do i=1,nrep
          remd_m(i)=1
        enddo
        call MREMD
      endif
#ifdef CHECK_MREMD_GRAD
      write(iout,*),"Check MREMD ave gradient"
      icheckgrad=1
      aincr=1.0d-4
#define ZERO_WEIGHTS
#ifdef ZERO_WEIGHTS
      wsc=0.0d0
      wscp=0.0d0
      welec=0.0d0
      wcorr=0.0d0
      wcorr5=0.0d0
      wcorr6=0.0d0
      wel_loc=0.0d0
      wturn3=0.0d0
      wturn4=0.0d0
      wturn6=0.0d0
      wang=0.0d0
      wscloc=0.0d0
      wtor=0.0d0
      wtor_d=0.0d0
      wvdwpp=0.0d0
      wbond=0.0d0
#endif
#undef ZERO_WEIGHTS
      call exec_checkgrad
      write(iout,*)"End check MREMD ave gradient"
#endif
      return
      end
#endif
c---------------------------------------------------------------------------
      subroutine exec_eeval_or_minim
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.SETUP'
      include 'COMMON.TIME1'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      include 'COMMON.GEO'
      include 'COMMON.HEADER'
      include 'COMMON.CONTROL'
c      include 'COMMON.CONTACTS'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.REMD'
      include 'COMMON.MD'
      include 'COMMON.SBRIDGE'
      include 'COMMON.SPLITELE'
      include 'COMMON.SAXS'
      include 'COMMON.NMR'
      integer i,it,icall,iretcode
      common /srutu/ icall
      integer nharp,iharp(4,(maxres+2)/3)
      integer nft_sc
#ifndef MPI
      double precision tcpu
#endif
c      logical fail,secondary_str /.true./
      logical fail,secondary_str /.false./
      double precision energy(0:n_ene),etot,etota
      double precision energy_long(0:n_ene),energy_short(0:n_ene)
      double precision rms,frac,frac_nn,co
      double precision varia(maxvar)
      double precision time00,time1,time_ene,evals
#ifdef LBFGS
      include 'COMMON.LBFGS'
#else
      integer nfun
#endif
      integer ilen
      common /execeevalorminimcommmon/ iharp,varia
      external ilen

      if (indpdb.eq.0 .and. .not.read_cart) call chainbuild
      if (indpdb.ne.0 .or. read_cart) then
      dc(1,0)=c(1,1)
      dc(2,0)=c(2,1)
      dc(3,0)=c(3,1)
      endif
      write (iout,*) "Energy evaluation/minimization"
      call chainbuild_cart
      write (iout,*) "Cartesian coords after chain rebuild"
      call cartprint
c      print *,'dc',dc(1,0),dc(2,0),dc(3,0)
      if (nran_start.gt.0) then
        write (iout,*)
     & "Chains will be regenerated starting from residue",nran_start
        do it=1,100
        call gen_rand_conf_mchain(nran_start,*10)
        write (iout,*) "Conformation successfully generated",it
        goto 11
   10   write (iout,*) "Problems with regenerating chains",it
        enddo
   11   continue
        write (iout,*) "Cartesian coords after chain rebuild"
        call cartprint
        call chainbuild_cart
        write (iout,*) "Cartesian coords after chainbuild_ecart"
        call cartprint
        call int_from_cart1(.false.)
        call intout
      endif
      if (split_ene) then
c       last_split=.false.
c       print *,"Processor",myrank," after chainbuild"
       icall=1
       call place_coords_in_box
       call list_update
c       call etotal_long(energy_long(0))
c       write (iout,*) "Printing long range energy"
c       call enerprint(energy_long(0))
       next_RESPA=.true.
       last_split=.true.
       call etotal_short(energy_short(0))
       write (iout,*) "Printing short range energy"
       call enerprint(energy_short(0))
       call etotal_long(energy_long(0))
       write (iout,*) "Printing long range energy"
       call enerprint(energy_long(0))
       do i=0,n_ene
         energy(i)=energy_long(i)+energy_short(i)
c         write (iout,*) i,energy_long(i),energy_short(i),energy(i)
       enddo
       write (iout,*) "Printing long+short range energy"
       call enerprint(energy(0))
      endif
#ifdef MPI
      time00=MPI_Wtime()
#else
      time00=tcpu()
#endif
c      write(iout,*)"before etotal"
c      call flush(iout)
#ifdef TYSIAK
      do itime_mat=0,1000
#endif
      call etotal(energy(0))
#ifdef TYSIAK
      enddo
#endif
c      write(iout,*)"after etotal"
c      call flush(iout)
#ifdef MPI
      time_ene=MPI_Wtime()-time00
#else
      time_ene=tcpu()-time00
#endif
#ifdef TIMING_ENE
      write (iout,*) "Time for interaction list",time_list
      write (iout,*) "Time for energy evaluation",time_enecalc
      write (iout,*) "Time for SCSC energy evaluation",time_evdw
      write (iout,*) "Time for SCp energy evaluation",time_escp
      write (iout,*) "Time for elec energy evaluation",time_eelec
#endif
      write (iout,*) "Time for energy evaluation+list",time_ene
c      print *,"after etotal"
      etota = energy(0)
      etot =etota
      call enerprint(energy(0))
      if (secondary_str) then
      call hairpin(.true.,nharp,iharp)
c        print *,'after hairpin'
      call secondary2(.true.)
      endif
c        print *,'after secondary'
      if (minim) then
crc overlap test
        if (indpdb.ne.0 .and. .not.dccart) then
          call bond_regular
          call chainbuild_extconf
          call etotal(energy(0))
          write (iout,*) "After bond regularization"
          call enerprint(energy(0))
        endif

        itime_mat=1 

        if (overlapsc) then 
          write (iout,*) 'Calling OVERLAP_SC'
          call overlap_sc(fail)
          write (iout,*) "After overlap_sc"
c        cartname=prefix(:ilen(prefix))//'.x'
c        potE=etot
c        call cartoutx(0.0d0)
        endif

        if (searchsc) then
          call sc_move(2,nres-1,10,1d10,nft_sc,etot)
          print *,'SC_move',nft_sc,etot
          write(iout,*) 'SC_move',nft_sc,etot
        endif

        if (dccart) then
          print *, 'Calling MINIM_DC'
#ifdef MPI
          time1=MPI_WTIME()
#else
          time1=tcpu()
#endif
          call minim_dc(etot,iretcode,nfun)
        else
          call geom_to_var(nvar,varia)
c          print *,'Calling MINIMIZE.'
#ifdef MPI
          time1=MPI_WTIME()
#else
          time1=tcpu()
#endif
          call minimize(etot,varia,iretcode,nfun)
        endif
#ifdef LBFGS
        print *,'LBFGS return code is',status,' eval ',nfun
#else
        print *,'SUMSL return code is',iretcode,' eval ',nfun
#endif
#ifdef MPI
        evals=nfun/(MPI_WTIME()-time1)
#else
        evals=nfun/(tcpu()-time1)
#endif
        print *,'# eval/s',evals
        print *,'refstr=',refstr
        if (secondary_str) then
        call hairpin(.false.,nharp,iharp)
c        print *,'after hairpin'
        call secondary2(.true.)
c        print *,'after secondary'
        endif
        call etotal(energy(0))
        etot = energy(0)
        call enerprint(energy(0))
        call intout
#ifdef LBFGS
          write (iout,'(a,a9)') 'LBFGS return code:',status
          write (iout,'(a,i20)') '# of energy evaluations:',nfun+1
          write (iout,'(a,f16.3)')'# of energy evaluations/sec:',evals
#else
          write (iout,'(a,i3)') 'SUMSL return code:',iretcode
          write (iout,'(a,i20)') '# of energy evaluations:',nfun+1
          write (iout,'(a,f16.3)')'# of energy evaluations/sec:',evals
#endif
      endif
      if (refstr) call rms_nac_nnc(rms,frac,frac_nn,co,.true.)
      if (out_int) call briefout(0,etot)
      if (out_cart) then
        cartname=prefix(:ilen(prefix))//'.x'
        potE=etot
        call cartoutx(0.0d0)
      endif
      if (outpdb) call pdbout(etot,titel(:50),ipdb)
      if (outmol2) call mol2out(etot,titel(:32))
      if (constr_dist.gt.0) call out_dist_viol
      if (nsaxs.gt.0) call out_saxs(energy(26))
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_regularize
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.SETUP'
      include 'COMMON.TIME1'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      include 'COMMON.GEO'
      include 'COMMON.HEADER'
      include 'COMMON.CONTROL'
c      include 'COMMON.CONTACTS'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.REMD'
      include 'COMMON.MD'
      include 'COMMON.SBRIDGE'
      double precision energy(0:n_ene)
      double precision etot,rms,frac,frac_nn,co
      integer iretcode
#ifdef LBFGS
      include 'COMMON.LBFGS'
#endif

      call gen_dist_constr
      call sc_conf
      call intout
      call regularize(nct-nnt+1,etot,rms,cref(1,nnt),iretcode)
      call etotal(energy(0))
      energy(0)=energy(0)-energy(14)
      etot=energy(0)
      call enerprint(energy(0))
      call intout
      call briefout(0,etot)
      if (outpdb) call pdbout(etot,titel(:50),ipdb)
      if (outmol2) call mol2out(etot,titel(:32))
      if (refstr) call rms_nac_nnc(rms,frac,frac_nn,co,.true.)
#ifdef LBFGS
      write (iout,'(a,a9)') 'LBFGS return code:',status
#else
      write (iout,'(a,i3)') 'SUMSL return code:',iretcode
#endif
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_thread
      implicit none
      include 'DIMENSIONS'
#ifdef MP
      include "mpif.h"
#endif
      include "COMMON.SETUP"
      call thread_seq
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_MC
      implicit none
      include 'DIMENSIONS'
      character*10 nodeinfo
      integer ipar
      double precision varia(maxvar)
      common /execmccommon/ varia
#ifdef MPI
      include "mpif.h"
#endif
      include "COMMON.SETUP"
      include 'COMMON.CONTROL'
      call mcm_setup
      if (minim) then
#ifdef MPI
        if (modecalc.eq.3) then
          call do_mcm(ipar)
        else
          call entmcm
        endif
#else
        if (modecalc.eq.3) then
          call do_mcm(ipar)
        else
          call entmcm
        endif
#endif
      else
        call monte_carlo
      endif
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_mult_eeval_or_minim
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
      integer muster(mpi_status_size)
      integer ierr,ierror
#endif
      include 'COMMON.SETUP'
      include 'COMMON.TIME1'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      include 'COMMON.GEO'
      include 'COMMON.HEADER'
      include 'COMMON.CONTROL'
c      include 'COMMON.CONTACTS'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.REMD'
      include 'COMMON.MD'
      include 'COMMON.SBRIDGE'
      double precision varia(maxvar)
      integer i,j,iconf,ind(6)
      integer n,it,man,nf_mcmf,nmin,imm,mm,nft
      double precision energy(0:max_ene),ene,etot,ene0
      double precision rms,frac,frac_nn,co
      double precision time
      logical eof
      integer iretcode,nfun
      eof=.false.
#ifdef MPI
      if(me.ne.king) then
        call minim_mcmf
        return
      endif

      close (intin)
      open(intin,file=intinname,status='old')
      write (istat,'(a5,20a12)')"#    ",
     &  (wname(print_order(i)),i=1,nprint_ene)
      if (refstr) then
        write (istat,'(a5,20a12)')"#    ",
     &   (ename(print_order(i)),i=1,nprint_ene),
     &   "ETOT total","RMSD","nat.contact","nnt.contact"
      else
        write (istat,'(a5,20a12)')"#    ",
     &    (ename(print_order(i)),i=1,nprint_ene),"ETOT total"
      endif

      if (.not.minim) then
        do while (.not. eof)
          if (read_cart) then
            read (intin,'(e15.10,e15.5)',end=1100,err=1100) time,ene
            call read_x(intin,*11)
#ifdef MPI
c Broadcast the order to compute internal coordinates to the slaves.
            if (nfgtasks.gt.1)
     &        call MPI_Bcast(6,1,MPI_INTEGER,king,FG_COMM,IERROR)
#endif
            call int_from_cart1(.false.)
          else
            read (intin,'(i5)',end=1100,err=1100) iconf
            call read_angles(intin,*11)
            call geom_to_var(nvar,varia)
            call chainbuild
          endif
          write (iout,'(a,i7)') 'Conformation #',iconf
          call etotal(energy(0))
          call briefout(iconf,energy(0))
          call enerprint(energy(0))
          etot=energy(0)
          if (refstr) then
            call rms_nac_nnc(rms,frac,frac_nn,co,.true.)
            write (istat,'(i5,20(f12.3))') iconf,
     &      (energy(print_order(i)),i=1,nprint_ene),etot,
     &       rms,frac,frac_nn,co
cjlee end
          else
            write (istat,'(i5,16(f12.3))') iconf,
     &     (energy(print_order(i)),i=1,nprint_ene),etot
          endif
        enddo
1100    continue
        goto 1101
      endif

      mm=0
      imm=0
      nft=0
      ene0=0.0d0
      n=0
      iconf=0
c      do n=1,nzsc
      do while (.not. eof)
        mm=mm+1
        if (mm.lt.nodes) then
          if (read_cart) then
            read (intin,'(e15.10,e15.5)',end=11,err=11) time,ene
            call read_x(intin,*11)
#ifdef MPI
c Broadcast the order to compute internal coordinates to the slaves.
            if (nfgtasks.gt.1)
     &        call MPI_Bcast(6,1,MPI_INTEGER,king,FG_COMM,IERROR)
#endif
            call int_from_cart1(.false.)
          else
            read (intin,'(i5)',end=11,err=11) iconf
            call read_angles(intin,*11)
            call geom_to_var(nvar,varia)
            call chainbuild
          endif
          write (iout,'(a,i7)') 'Conformation #',iconf
          n=n+1
         imm=imm+1
         ind(1)=1
         ind(2)=n
         ind(3)=0
         ind(4)=0
         ind(5)=0
         ind(6)=0
         ene0=0.0d0
         call mpi_send(ind,6,mpi_integer,mm,idint,CG_COMM,
     *                  ierr)
         call mpi_send(varia,nvar,mpi_double_precision,mm,
     *                  idreal,CG_COMM,ierr)
         call mpi_send(ene0,1,mpi_double_precision,mm,
     *                  idreal,CG_COMM,ierr)
c         print *,'task ',n,' sent to worker ',mm,nvar
        else
         call mpi_recv(ind,6,mpi_integer,mpi_any_source,idint,
     *                 CG_COMM,muster,ierr)
         man=muster(mpi_source)
c         print *,'receiving result from worker ',man,' (',iii1,iii,')'
         call mpi_recv(varia,nvar,mpi_double_precision,
     *               man,idreal,CG_COMM,muster,ierr)
         call mpi_recv(ene,1,
     *               mpi_double_precision,man,idreal,
     *               CG_COMM,muster,ierr)
         call mpi_recv(ene0,1,
     *               mpi_double_precision,man,idreal,
     *               CG_COMM,muster,ierr)
c         print *,'result received from worker ',man,' sending now'

          call var_to_geom(nvar,varia)
          call chainbuild
          call etotal(energy(0))
          iconf=ind(2)
          write (iout,*)
          write (iout,*)
          write (iout,'(a,2i7)') 'Conformation #',iconf,ind(5)

          etot=energy(0)
          call enerprint(energy(0))
          call briefout(it,etot)
c          if (minim) call briefout(it,etot)
          if (refstr) then
            call rms_nac_nnc(rms,frac,frac_nn,co,.true.)
            write (istat,'(i5,19(f12.3))') iconf,
     &     (energy(print_order(i)),i=1,nprint_ene),etot,
     &     rms,frac,frac_nn,co
          else
            write (istat,'(i5,15(f12.3))') iconf,
     &     (energy(print_order(i)),i=1,nprint_ene),etot
          endif

          imm=imm-1
          if (read_cart) then
            read (intin,'(e15.10,e15.5)',end=1101,err=1101) time,ene
            call read_x(intin,*11)
#ifdef MPI
c Broadcast the order to compute internal coordinates to the slaves.
            if (nfgtasks.gt.1)
     &        call MPI_Bcast(6,1,MPI_INTEGER,king,FG_COMM,IERROR)
#endif
            call int_from_cart1(.false.)
          else
            read (intin,'(i5)',end=1101,err=1101) iconf
            call read_angles(intin,*11)
            call geom_to_var(nvar,varia)
            call chainbuild
          endif
          n=n+1
          imm=imm+1
          ind(1)=1
          ind(2)=n
          ind(3)=0
          ind(4)=0
          ind(5)=0
          ind(6)=0
          call mpi_send(ind,6,mpi_integer,man,idint,CG_COMM,
     *                  ierr)
          call mpi_send(varia,nvar,mpi_double_precision,man,
     *                  idreal,CG_COMM,ierr)
          call mpi_send(ene0,1,mpi_double_precision,man,
     *                  idreal,CG_COMM,ierr)
          nf_mcmf=nf_mcmf+ind(4)
          nmin=nmin+1
        endif
      enddo
11    continue
      do j=1,imm
        call mpi_recv(ind,6,mpi_integer,mpi_any_source,idint,
     *               CG_COMM,muster,ierr)
        man=muster(mpi_source)
        call mpi_recv(varia,nvar,mpi_double_precision,
     *               man,idreal,CG_COMM,muster,ierr)
        call mpi_recv(ene,1,
     *               mpi_double_precision,man,idreal,
     *               CG_COMM,muster,ierr)
        call mpi_recv(ene0,1,
     *               mpi_double_precision,man,idreal,
     *               CG_COMM,muster,ierr)

        call var_to_geom(nvar,varia)
        call chainbuild
        call etotal(energy(0))
        iconf=ind(2)
        write (iout,*)
        write (iout,*)
        write (iout,'(a,2i7)') 'Conformation #',iconf,ind(5)

        etot=energy(0)
        call enerprint(energy(0))
        call briefout(it,etot)
        if (refstr) then
          call rms_nac_nnc(rms,frac,frac_nn,co,.true.)
          write (istat,'(i5,19(f12.3))') iconf,
     &   (energy(print_order(i)),i=1,nprint_ene),etot,
     &   rms,frac,frac_nn,co
        else
          write (istat,'(i5,15(f12.3))') iconf,
     &    (energy(print_order(i)),i=1,nprint_ene),etot
        endif
        nmin=nmin+1
      enddo
1101  continue
      do i=1, nodes-1
         ind(1)=0
         ind(2)=0
         ind(3)=0
         ind(4)=0
         ind(5)=0
         ind(6)=0
         call mpi_send(ind,6,mpi_integer,i,idint,CG_COMM,
     *                  ierr)
      enddo
#else
      close (intin)
      open(intin,file=intinname,status='old')
      write (istat,'(a5,20a12)')"#    ",
     &   (wname(print_order(i)),i=1,nprint_ene)
      write (istat,'("#    ",20(1pe12.4))')
     &   (weights(print_order(i)),i=1,nprint_ene)
      if (refstr) then
        write (istat,'(a5,20a12)')"#    ",
     &   (ename(print_order(i)),i=1,nprint_ene),
     &   "ETOT total","RMSD","nat.contact","nnt.contact"
      else
        write (istat,'(a5,14a12)')"#    ",
     &   (ename(print_order(i)),i=1,nprint_ene),"ETOT total"
      endif
      do while (.not. eof)
          if (read_cart) then
            read (intin,'(e15.10,e15.5)',end=11,err=11) time,ene
            call read_x(intin,*11)
#ifdef MPI
c Broadcast the order to compute internal coordinates to the slaves.
            if (nfgtasks.gt.1)
     &        call MPI_Bcast(6,1,MPI_INTEGER,king,FG_COMM,IERROR)
#endif
            call int_from_cart1(.false.)
          else
            read (intin,'(i5)',end=11,err=11) iconf
            call read_angles(intin,*11)
            call geom_to_var(nvar,varia)
            call chainbuild
          endif
        write (iout,'(a,i7)') 'Conformation #',iconf
        if (minim) call minimize(etot,varia,iretcode,nfun)
        call etotal(energy(0))

        etot=energy(0)
        call enerprint(energy(0))
        if (minim) call briefout(it,etot)
        if (refstr) then
          call rms_nac_nnc(rms,frac,frac_nn,co,.true.)
          write (istat,'(i5,18(f12.3))') iconf,
     &   (energy(print_order(i)),i=1,nprint_ene),
     &   etot,rms,frac,frac_nn,co
cjlee end
        else
          write (istat,'(i5,14(f12.3))') iconf,
     &   (energy(print_order(i)),i=1,nprint_ene),etot
        endif
      enddo
   11 continue
#endif
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_checkgrad
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.SETUP'
      include 'COMMON.TIME1'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      include 'COMMON.GEO'
      include 'COMMON.HEADER'
      include 'COMMON.CONTROL'
c      include 'COMMON.CONTACTS'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.REMD'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.SBRIDGE'
      integer icall
      common /srutu/ icall
      double precision energy(0:max_ene)
c      print *,"A TU?"
c      do i=2,nres
c        vbld(i)=vbld(i)+ran_number(-0.1d0,0.1d0)
c        if (itype(i).ne.10)
c     &      vbld(i+nres)=vbld(i+nres)+ran_number(-0.001d0,0.001d0)
c      enddo
      if (indpdb.eq.0) call chainbuild
c      do i=0,nres
c        do j=1,3
c          dc(j,i)=dc(j,i)+ran_number(-0.2d0,0.2d0)
c        enddo
c      enddo
c      do i=1,nres-1
c        if (itype(i).ne.10) then
c          do j=1,3
c            dc(j,i+nres)=dc(j,i+nres)+ran_number(-0.2d0,0.2d0)
c          enddo
c        endif
c      enddo
c      do j=1,3
c        dc(j,0)=ran_number(-0.2d0,0.2d0)
c      enddo
#ifdef UMB
      usampl=.true.
      scale_umb=.false.
#ifdef PMF
      adaptive=.true.
#endif
      totT=1.d0
      eq_time=0.0d0
      call read_fragments
      iset=1
      nperm=1
      print *, "AFTER read fragments"
           write (iout,*) "iset",iset
           if (loc_qlike) then
           write(iout,*) "fragment, weights, q0:"
           do i=1,nfrag_back
            write(iout,'(2i5,3(f8.1,f8.2))') ifrag_back(1,i,iset),
     &         ifrag_back(2,i,iset),
     &         wfrag_back(1,i,iset),qin_back(1,i,iset),
     &         wfrag_back(2,i,iset),qin_back(2,i,iset),
     &         wfrag_back(3,i,iset),qin_back(3,i,iset)
           enddo
           else
           write(iout,*) "fragment, weights:"
           do i=1,nfrag_back
            write(iout,'(2i5,3f8.1)') ifrag_back(1,i,iset),
     &         ifrag_back(2,i,iset),wfrag_back(1,i,iset),
     &         wfrag_back(2,i,iset),wfrag_back(3,i,iset)
           enddo
           endif
#ifdef PMF
      call read_REMDpar
      call PMFread
#endif
      call rescale_weights(t_bath)
      call chainbuild_cart
      print *,"chainbuild_cart"
      call cartprint
      print *,"After cartprint"
      call intout
      icall=1
      print *,"before ETOT"
      write (iout,*) "usampl",usampl
      call etotal(energy(0))
      etot = energy(0)
      call enerprint(energy(0))
      write (iout,*) "Uconst",Uconst," Uconst_back",uconst_back
      print *,'icheckgrad=',icheckgrad
#endif
          
      write(iout,*),"before checking gradient icheckgrad",icheckgrad
      goto (10,20,30) icheckgrad
  10  write(iout,*),"before call check_ecartint"
      call check_ecartint
!  10  call check_ecartint
      write(iout,*),"after check_ecartint"
      return
  20  write (iout,*)
     & "Checking the gradient of Cartesian coordinates disabled."
      return
  30  call check_eint
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_map
C Energy maps
      call map_read
      call map
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_CSA
      implicit none
#ifdef MPI
      include "mpif.h"
#endif
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
C Conformational Space Annealling programmed by Jooyoung Lee.
C This method works only with parallel machines!
#ifdef MPI
      call together
#else
      write (iout,*) "CSA works on parallel machines only"
#endif
      return
      end
c---------------------------------------------------------------------------
      subroutine exec_softreg
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      double precision energy(0:max_ene),etot
      double precision rms,frac,frac_nn,co
      call chainbuild
      call etotal(energy(0))
      call enerprint(energy(0))
      if (.not.lsecondary) then
        write(iout,*) 'Calling secondary structure recognition'
        call secondary2(.true.)
      else
        write(iout,*) 'Using secondary structure supplied in pdb'
      endif

      call softreg

      call etotal(energy(0))
      etot=energy(0)
      call enerprint(energy(0))
      call intout
      call briefout(0,etot)
      call secondary2(.true.)
      if (refstr) call rms_nac_nnc(rms,frac,frac_nn,co,.true.)
      return
      end

#ifdef SIMDSTAT
#include"simdstat.F"
#endif
