      subroutine simd_log_stat(id, value)
      implicit none
      include "COMMON.SIMDSTAT"
      integer id, value
      simd_stat_count(id) = simd_stat_count(id) + 1
      simd_stat_value(id) = simd_stat_value(id) + value
      end

      subroutine simd_avg_stat(stat,id)
      implicit none
      include "COMMON.SIMDSTAT"
      integer id
      character*13 stat
      write(*,*)stat,' count   ',simd_stat_count(id)
      write(*,*)stat,' avg length ',
     &          1.0d0*simd_stat_value(id)/simd_stat_count(id)
      end

      subroutine simd_fn_stat(fn,base)
      implicit none
      include "COMMON.SIMDSTAT"
      character*6 fn
      integer base
      integer*8 total,notcut

      total=simd_stat_count(base+0)
      notcut=simd_stat_count(base+1)
      write(*,*)fn,'cut count       ',total-notcut
      write(*,*)fn,'total count     ',total
      write(*,*)fn,'cut %              ',100d0*(total-notcut)/total

      call simd_avg_stat(fn//' seq   ',base+2)
      call simd_avg_stat(fn//' nseq  ',base+3)

      write(*,*)fn,'num migrations  ',simd_stat_count(base+4)
      write(*,*)fn,'count migrated  ',simd_stat_value(base+4)
      end

      subroutine simd_stat_report
      implicit none
      write(*,*)'SIMDSTAT ==================================='

      call simd_fn_stat('egb   ',200)
      call simd_fn_stat('eelec ',300)
      call simd_fn_stat('escp  ',400)
      call simd_avg_stat('escp  dropoff',411)
      call simd_avg_stat('escp  _14    ',412)

      end
