      subroutine seq2chains(nres,itype,nchain,chain_length,chain_border,
     &  ireschain)
c
c Split the total UNRES sequence, which has dummy residues separating
c the chains, into separate chains. The length of  chain ichain is
c contained in chain_length(ichain), the first and last non-dummy
c residues are in chain_border(1,ichain) and chain_border(2,ichain),
c respectively. The lengths pertain to non-dummy residues only.
c
      implicit none
      include 'DIMENSIONS'
      integer nres,itype(nres),nchain,chain_length(nres),
     &  chain_border(2,nres),ireschain(nres)
      integer ii,ichain,i,j
      logical new_chain
      ichain=1
      new_chain=.true.
      chain_length(ichain)=0
      ii=1
      do while (ii.lt.nres)
        if (itype(ii).eq.ntyp1) then
          if (.not.new_chain) then
            new_chain=.true.
            chain_border(2,ichain)=ii-1
            ichain=ichain+1
            chain_border(1,ichain)=ii+1
            chain_length(ichain)=0
          endif
        else
          if (new_chain) then
            chain_border(1,ichain)=ii
            new_chain=.false.
          endif
          chain_length(ichain)=chain_length(ichain)+1
        endif
        ii=ii+1
      enddo
      if (itype(nres).eq.ntyp1) then
        ii=ii-1
      else
        chain_length(ichain)=chain_length(ichain)+1
      endif
      if (chain_length(ichain).gt.0) then
        chain_border(2,ichain)=ii
        nchain=ichain
      else
        nchain=ichain-1
      endif
      ireschain=0
      do i=1,nchain
        do j=chain_border(1,i),chain_border(2,i)
          ireschain(j)=i
        enddo
      enddo
      return
      end
