      double precision function mygauss(x)
      double precision x,xx
c Bell-like function with shorter tail than Gussian, C2 class
      double precision a /0.12479628030882975000d0/,
     &                 b /-0.02020459191080933333d0/,
     &                 c /0.00193897131461287500d0/,
     &                 a1 /0.10424745713810881250d0/,
     &                 b1 /-0.02369260389502472656d0/,
     &                 c1 /0.00177694529212685400d0/
      if (x.lt.-1.0d0 .and. x.gt.-3.0d0) then
        xx=(x+3.0d0)**2
        mygauss=xx*xx*(a1+xx*(b1+c1*xx))
      else if (x.ge.-1.0d0 .and. x.le.1.0d0) then
        xx=x*x
        mygauss=1.0d0+xx*(-0.5d0+xx*(a+xx*(b+xx*c)))
      else if (x.gt.1.0d0 .and. x.lt.3.0d0) then
        xx=(x-3.0d0)**2
        mygauss=xx*xx*(a1+xx*(b1+c1*xx))
      else
        mygauss=0.0d0
      endif
      return
      end
c------------------------------------------------------------
      double precision function mygaussder(x)
      double precision x,xx
c Bell-like function with shorter tail than Gussian, C2 class
c      double precision a /0.12479628030882975000d0/,
c     &                 b /-0.02020459191080933333d0/,
c     &                 c /0.00193897131461287500d0/,
c     &                 a1 /0.10424745713810881250d0/,
c     &                 b1 /-0.02369260389502472656d0/,
c     &                 c1 /0.00177694529212685400d0/
      double precision a /0.49918512123531900000d0/,
     &                 b /-0.12122755146485599998d0/,
     &                 c /0.01551177051690300000d0/,
     &                 a1 /0.41698982855243525000d0/,
     &                 b1 /-0.14215562337014835936d0/,
     &                 c1 /0.01421556233701483200d0/
      if (x.lt.-1.0d0 .and. x.gt.-3.0d0) then
        xx=(x+3.0d0)**2
c        mygaussder=(x+3.0d0)*xx*(4.0d0*a1+xx*(6.0d0*b1+8.0d0*c1*xx))
        mygaussder=(x+3.0d0)*xx*(a1+xx*(b1+c1*xx))
      else if (x.ge.-1.0d0 .and. x.le.1.0d0) then
        xx=x*x
c        mygaussder=x*(-1.0d0+xx*(4.0d0*a+xx*(6.0d0*b+xx*8.0d0*c)))
        mygaussder=x*(-1.0d0+xx*(a+xx*(b+xx*c)))
      else if (x.gt.1.0d0 .and. x.lt.3.0d0) then
        xx=(x-3.0d0)**2
c        mygaussder=(x-3.0d0)*xx*(4.0d0*a1+xx*(6.0d0*b1+8.0d0*c1*xx))
        mygaussder=(x-3.0d0)*xx*(a1+xx*(b1+c1*xx))
      else
        mygaussder=0.0d0
      endif
      return
      end
