      subroutine make_inter_list(iat_s,iat_e,nint_gr,istart,iend,
     & c1,c2,ityp1,ityp2,itypint,g_list_start,g_list_end,newcontlisti,
     & newcontlistj,
     & positive_gridi,positive_gridj,gridcelli,gridrangej,griddataj)
      implicit none
      include "DIMENSIONS"
#ifdef MPI
      include 'mpif.h'
      include "COMMON.SETUP"
#endif
      include "COMMON.CONTROL"
      include "COMMON.CHAIN"
c     include "COMMON.INTERACT"
      include "COMMON.SPLITELE"
      include "COMMON.IOUNITS"
      include "COMMON.GRID"
      integer parallel_chunk_size
      parameter (parallel_chunk_size=16)
      integer iat_s,iat_e,nint_gr(maxres),istart(maxres,maxint_gr),
     & iend(maxres,maxint_gr),ityp1(maxres),ityp2(maxres),itypint,
     & g_list_start,g_list_end,newcontlisti(2,0:10*maxres),
     & newcontlistj(2,maxint_res*maxres)
      double precision c1(3,maxres),c2(3,maxres)
      double precision dist_init,dist_temp,r_cut_all,
     &                 r_cut_all2
      double precision xyzi(3),rij(3)
      double precision threshold
      integer contlisti(2,0:10*maxres),contlistj(2,maxint_res*maxres)
      integer listi(2,0:2*maxres),listj(2,maxint_res*maxres)
      integer liststart(0:2*maxres+1)
      integer ranges(2,maxres*maxint_gr)
      integer*8 ntotint
      integer i,j,k,l,itypi,itypj,subchap,xshift,yshift,zshift,iint,
     &        ilist_sc,g_ilist_sc,ii,jj,irowi,irowj,g_rowj
      integer cnt,rngcount,listbase,contbase
      integer displ(0:max_fg_procs),i_ilist_sc(0:max_fg_procs),ierr
      integer positive_gridi(grid_length)
      integer positive_gridj(grid_length)
      integer pgridi,pgridj,skipcount
      integer gridrangej(-2:max_grid_cells)
      integer griddataj(27*maxres)
      integer gridcelli(-1:maxres)
      integer r1lo,r1hi,r2lo,r2hi
      logical are_near,skip
      common /makelistcommon/ contlisti,contlistj,
     &                        listi,listj,liststart
      logical lprn /.false./
      character*4 textint(3) /'SCSC','SCp ','pp  '/

#ifdef DEBUG
      write (iout,*) "make_inter_list ",textint(itypint)," maxint_res",
     &  maxint_res
      write (iout,*) "iat_s",iat_s," iat_e",iat_e
#endif
      g_list_start=0
      g_list_end=0
      r_cut_all=r_cut_int+r_buff_list
      threshold=r_cut_all*r_cut_all
c     r_cut_all2=r_cut_all/dsqrt(2.0d0)
      irowi=0
      irowj=0
      ii=0

!$OMP PARALLEL DO DEFAULT(SHARED) SCHEDULE(DYNAMIC,parallel_chunk_size)
!$OMP& PRIVATE(dist_init,xyzi,rij,itypi,itypj,ranges,rngcount,listbase,
!$OMP&         jj,iint,j,pgridj,pgridi,skipcount,k,r1lo,r1hi,r2lo,r2hi,
!$OMP&         are_near,skip,l)
      do i=iat_s,iat_e
        listi(2,i-iat_s)=0
        !itypi=iabs(ityp1(i))
        itypi=ityp1(i)
        if (itypi.eq.ntyp1 .or. itypi.eq.0) cycle
        xyzi=c1(:,i)
        rngcount=0
        jj=-1
!       pgridi=positive_gridi(i*2)

        r1lo=istart(i,1)
        r1hi=iend(i,1)
        if(nint_gr(i).gt.1) then
          r2lo=istart(i,2)
          r2hi=iend(i,2)
        else
          r2lo=r1lo
          r2hi=r1hi
        endif


#ifdef GRIDSTAT
        !gridallcount=gridallcount+iend(i,iint)-istart(i,iint)+1
#endif
        k=gridcelli(i)
        if(k.lt.0) cycle
        do iint=gridrangej(k-1)+1,gridrangej(k)
          j=griddataj(iint)
          !skip=.true.
          !do l=1,nint_gr(i)
          !  if((istart(i,l).le.j).and.(j.le.iend(i,l))) then
          !    skip=.false.
          !    exit
          !  endif
          !enddo
          !if(skip) cycle
          if((j.lt.r1lo .or. j.gt.r1hi) .and.
     &       (j.lt.r2lo .or. j.gt.r2hi)) cycle
          itypj=iabs(ityp2(j))
          if (itypj.eq.ntyp1 .or. itypj.eq.0) then
            !TODO use skipcount
            !j=j+1
#ifdef GRIDSTAT
            gridtypecuts=gridtypecuts+1
#endif
            cycle
          endif
          !pgridj=positive_gridj(j*2)

          !if (pgridi.eq.pgridj) then
!          if (.false.) then
!            skipcount=min(positive_gridj(j*2+1),iend(i,iint)-j+1)
!            !write(*,*)'POS HIT',skipcount
!#ifdef GRIDSTAT
!            posgridhits=posgridhits+1
!            posgridjumps=posgridjumps+skipcount-1
!#endif
!
!          else
            skipcount=1
            call wrapvec(c2(:,j)-xyzi,rij)
            dist_init=sum(rij*rij)
            if (dist_init.gt.threshold) then
              j=j+1
              !write(*,*)'MISS SKIP'
#ifdef GRIDSTAT
              gridmiss=gridmiss+1
#endif
              cycle
            endif
            skipcount=1
#ifdef GRIDSTAT
            gridpass=gridpass+1
#endif
!          endif

          if (j.ne.jj) then
            rngcount=rngcount+1
            ranges(1,rngcount)=j
#ifdef DEBUG
            if (j.lt.jj) then
              print *,"j index decreased in make_inter_list_",
     &           textint(itypint)
#ifdef MPI
              call MPI_Abort(MPI_COMM_WORLD,ierr)
#else
              stop
#endif
            endif
#endif
          endif
          j=j+skipcount
          ranges(2,rngcount)=j-1
          jj=j
        enddo

        if (rngcount.eq.0) cycle

!$OMP ATOMIC CAPTURE
        listbase=irowj
        irowj=irowj+rngcount
!$OMP END ATOMIC

        listi(1,i-iat_s)=listbase+1
        listi(2,i-iat_s)=rngcount
        do j=1,rngcount
          listj(:,listbase+j)=ranges(:,j)
        enddo
      enddo   ! i

      irowi=0
      contlisti(:,0)=0
      liststart(0)=1
      do i=iat_s,iat_e
        cnt=listi(2,i-iat_s)
        liststart(i-iat_s+1)=liststart(i-iat_s)+cnt
        if(cnt.eq.0) cycle
        irowi=irowi+1
        contlisti(1,irowi)=i
        contlisti(2,irowi)=cnt
      enddo
      irowj=liststart(iat_e-iat_s+1)-1

!$OMP PARALLEL DO DEFAULT(SHARED) SCHEDULE(DYNAMIC,parallel_chunk_size)
!$OMP& PRIVATE(cnt,listbase,contbase,j)
      do i=iat_s,iat_e
        cnt=listi(2,i-iat_s)
        if(cnt.eq.0) cycle
        listbase=listi(1,i-iat_s)-1
        contbase=liststart(i-iat_s)-1
        do j=1,cnt
          contlistj(:,contbase+j)=listj(:,listbase+j)
        enddo
      enddo

      call list_merge(irowi,irowj,contlisti,contlistj)
#ifdef DEBUG
      write (iout,*) "before MPIREDUCE",irowi,irowj
      do i=1,irowi
        write (iout,*) i,contlisti(1,i),contlisti(2,i)
      enddo
      do i=1,irowj
        write (iout,*) i,contlistj(1,i),contlistj(2,i)
      enddo
#endif
      g_ilist_sc=irowi
      g_rowj=irowj
      do i=1,irowi
        newcontlisti(:,i)=contlisti(:,i)
      enddo
      ntotint=0
      do i=1,irowj
        newcontlistj(:,i)=contlistj(:,i)
        ntotint=ntotint+contlistj(2,i)-contlistj(1,i)+1
      enddo
#ifdef MPI
      if (fg_rank.eq.0.and.g_rowj.gt.maxres*maxint_res) then
        if ((me.eq.king.or.out1file).and.energy_dec) then
          write (iout,*) "Too many ",textint(itypint)," interactions",
     &    g_rowj," only",maxres*maxint_res," allowed."
          write (iout,*) "Reduce r_cut_int and resubmit"
          write (iout,*) "Specify a smaller r_cut_int and resubmit"
          call flush(iout)
        endif
        write(*,*)"Processor:",me,": Too many ",textint(itypint),
     &    " interactions",g_rowj," only",maxres*maxint_res," allowed."
          write (iout,*) "Reduce r_cut_int and resubmit"
          write (iout,*) "Specify a smaller r_cut_int and resubmit"
        call MPI_Abort(MPI_COMM_WORLD,ierr)
      endif
      if (fg_rank.eq.0 .and. (me.eq.king.or.out1file) .and. energy_dec)
     & write(iout,'(3a,i10,a,i4)')"Number of ",textint(itypint),
     & " interactions",ntotint," per residue on average",ntotint/nres
#else
      if (g_rowj.gt.maxres*maxint_res) then
        if (energy_dec) then
          write (iout,*) "Too many ",textint(itypint)," interactions",
     &    g_rowj," only",maxres*maxint_res," allowed."
          write (iout,*) "Reduce r_cut_int and resubmit"
          write (iout,*) "Specify a smaller r_cut_int and resubmit"
          call flush(iout)
        endif
        write (*,*) "Too many ",textint(itypint)," interactions",
     &    g_rowj," only",maxres*maxint_res," allowed."
          write (iout,*) "Reduce r_cut_int and resubmit"
          write (iout,*) "Specify a smaller r_cut_int and resubmit"
        stop
      endif
      if (energy_dec) write (iout,'(3a,i10,a,i4)')
     & "Number of ",textint(itypint)," interactions",
     & ntotint," per residue on average",ntotint/nres
#endif
#ifdef MPI
#ifdef DEBUG
      do i=1,irowi
        write (iout,*) i,newcontlisti(1,i),newcontlisti(2,i)
      enddo
      do i=1,irowj
        write (iout,*) i,newcontlistj(1,i),newcontlistj(2,i)
      enddo
#endif
      call block_partition(ntotint,irowi,newcontlisti,
     &   newcontlistj,g_list_start,g_list_end)
#else
      g_list_start=1
      g_list_end=irowi
#endif
#ifdef DEBUG
      write (iout,*) "g_list_start",g_list_start,
     &  "g_list_end",g_list_end
      write (iout,*) "newcontlisti"
      do i=g_list_start,g_list_end
        write (iout,*) i,newcontlisti(1,i),newcontlisti(2,i)
      enddo
      write (iout,*) "newcontlistj"
      do i=newcontlisti(2,g_list_start-1)+1,
     &  newcontlisti(2,g_list_end)
        write (iout,*) i,newcontlistj(1,i),newcontlistj(2,i)
      enddo
#endif
      return
      end
