#!/bin/sh
if [ ! -z "$CI_COMMIT_BRANCH" ] ; then
	BRANCH="$CI_COMMIT_BRANCH"
else
	BRANCH="$(git rev-parse --abbrev-ref HEAD)"
fi
if [ ! -z "$CI_COMMIT_SHA" ] ; then
	COMMIT="$CI_COMMIT_SHA"
else
	COMMIT="$(git rev-parse HEAD)"
fi
FLAGS=$(grep -h '^[A-Za-z_][A-Za-z0-9_]*\s*=' Makefile)
cat <<EOF
C DO NOT EDIT THIS FILE - IT HAS BEEN GENERATED
      subroutine cinfo
      include 'COMMON.IOUNITS'
      write(iout,*)'++++ Compile info ++++'
      write(iout,*)'Branch $BRANCH'
      write(iout,*)'Commit $COMMIT'
      write(iout,*)'compiled $(LC_TIME=en_US.utf-8 date "+%a %b %d %H:%M:%S %Y")'
      write(iout,*)'compiled by $(whoami | awk '{if(length($0)>38) print substr($0,1,38); else print $0}')'
      write(iout,*)'OS name:    $(uname -s | awk '{if(length($0)>38) print substr($0,1,38); else print $0}') '
      write(iout,*)'OS release: $(uname -r | awk '{if(length($0)>38) print substr($0,1,38); else print $0}')'
      write(iout,*)'OS version: $(uname -v | awk '{if(length($0)>38) print substr($0,1,38); else print $0}')'
      write(iout,*)'flags:'
EOF
grep -h '^[A-Za-z_][A-Za-z0-9_ :]*\s*=' Makefile \
	| awk -v len=50 '{ if(length($0) > len) print "      write(iout,*)'"'"'"substr($0,1,len-3)"'"...'"'"; else print "      write(iout,*)'"'"'"$0"'"'"'"}'
if [ -x git ] ; then
cat <<EOF
      write(iout,*)'modified files:'
EOF
	git diff --name-only HEAD \
		| awk -v len=48 '{ if(length($0) > len) print "      write(iout,*)'"'  "'"substr($0,1,len-3)"'"...'"'"; else print "      write(iout,*)'"'  "'"$0"'"'"'"}'
fi

cat <<EOF
      write(iout,*)'++++ End of compile info ++++'
      return
      end
EOF
