      subroutine list_merge(irowi,irowj,contlisti,contlistj)
      implicit none
      include "DIMENSIONS"
#ifdef MPI
      include 'mpif.h'
#endif
      include "COMMON.SETUP"
      include "COMMON.CONTROL"
      include "COMMON.CHAIN"
      include "COMMON.INTERACT"
      include "COMMON.SPLITELE"
      include "COMMON.IOUNITS"
#ifdef MPI
      integer stan(MPI_STATUS_SIZE)
      integer ierror
#endif
      integer irowi,irowj
      integer contlisti(2,0:10*maxres),contlistj(2,maxint_res*maxres)
      integer i,krok,iproc,iproc1,iblock,iblock_right,ind1,ind2
      integer contlisti_right(2,0:10*maxres),
     & contlistj_right(2,maxint_res*maxres),
     & irowi_right,irowj_right
      integer tag
      common /listmergecommon/ contlisti_right,contlistj_right
      krok=2
#ifdef DEBUG
      write (iout,*) "irowi",irowi
      write (iout,*) "irowj",irowj
      write (iout,*) "contlisti"
      do i=1,irowi
      write (iout,*) i,contlisti(1,i),contlisti(2,i)
      enddo
#endif
      contlisti(1,0)=0
      contlisti(2,0)=0
      do i=1,irowi
        contlisti(2,i)=contlisti(2,i-1)+contlisti(2,i)
      enddo
#ifdef DEBUG
      write (iout,*) "contlisti after summing"
      do i=1,irowi
      write (iout,*) i,contlisti(1,i),contlisti(2,i)
      enddo
      write (iout,*) "contlistj"
      do i=1,irowj
      write (iout,*) i,contlistj(1,i),contlistj(2,i)
      enddo
#endif
#ifdef MPI
      if (nfgtasks.eq.1) return
      do while (krok.le.nfgtasks .or. krok-nfgtasks.lt.krok/2)
c        write (iout,*) "krok",krok
        iproc=0
        do while (iproc+krok/2.le.nfgtasks-1)
          iproc1=iproc+krok/2
c          write (iout,*) "iproc",iproc," iproc1",iproc1,
c     &      " fg_rank",fg_rank
          if (fg_rank.eq.iproc .or. fg_rank.eq.iproc1) then
            tag = 121212+iproc
c            write (iout,*) "Before sendrecv 1"
c            call MPI_Sendrecv(irowi,1,MPI_INTEGER,iproc,MPI_ANY_TAG,
c     &        irowi_right,
c     &        1, MPI_INTEGER,iproc1,MPI_ANY_TAG, FG_COMM, stan,
c     &        ierror)
            if (fg_rank.eq.iproc1) then
c            write (iout,*) "Sending",fg_rank,iproc1
            call MPI_Send(irowi,1,MPI_INTEGER,iproc,tag,FG_COMM,ierror)
            if (irowi.eq.0) goto 10
            else
c            write (iout,*) "Receiving",fg_rank,iproc
            call MPI_recv(irowi_right,1,MPI_INTEGER,iproc1,tag,
     &        FG_COMM, stan,ierror)
            if (irowi_right.eq.0) goto 10
            endif
c            call flush(iout)
            tag = 121312+iproc
c            write (iout,*) "After sendrecv 1 irowi_right",irowi_right
            if (fg_rank.eq.iproc1) then
            call MPI_Send(contlisti(1,1),2*irowi,MPI_INTEGER,
     &           iproc,tag,FG_COMM,ierror)
            else
            call MPI_recv(contlisti_right(1,1),2*irowi_right,
     &           MPI_INTEGER,iproc1,tag,FG_COMM,stan,ierror)
            endif
c            call MPI_Sendrecv(contlisti(1,1),2*irowi,MPI_INTEGER,
c     &           iproc, tag,
c     &           contlisti_right(1,1),2*irowi_right, MPI_INTEGER,
c     &           iproc1, tag, FG_COMM, stan,ierror)
c            write (iout,*) "After sendrecv 2"
            tag = 121412+iproc
            if (fg_rank.eq.iproc1) then
            call MPI_Send(irowj,1,MPI_INTEGER,iproc,tag,FG_COMM,ierror)
            else
            call MPI_recv(irowj_right,1,MPI_INTEGER,iproc1,tag,FG_COMM,
     &           stan,ierror)
            endif
c            call MPI_Sendrecv(irowj,1,MPI_INTEGER,iproc,tag,irowj_right,
c     &        1, MPI_INTEGER,iproc1,tag, FG_COMM, stan,ierror)
c            write (iout,*) "After sendrecv 3"
            tag = 121512+iproc
            if (fg_rank.eq.iproc1) then
            call MPI_Send(contlistj(1,1),2*irowj,MPI_INTEGER,iproc,tag,
     &           FG_COMM,ierror)
            else
            call MPI_recv(contlistj_right(1,1),2*irowj_right,
     &           MPI_INTEGER,iproc1,tag,FG_COMM,stan,ierror)
            endif
c            call MPI_Sendrecv(contlistj(1,1),2*irowj,MPI_INTEGER,
c     &           iproc, tag,
c     &           contlistj_right(1,1),2*irowj_right, MPI_INTEGER,
c     &           iproc1, tag, FG_COMM, stan,ierror)
c            write (iout,*) "After sendrecv 4"
            if (fg_rank.eq.iproc) then
#ifdef DEBUG
            write (iout,*) "irowi",irowi," irowi_right",irowi_right
            write (iout,*) "irowj",irowj," irowj_right",irowj_right
            write (iout,*) "contlisti"
            do i=1,irowi
            write (iout,*) i,contlisti(1,i),contlisti(2,i)
            enddo
            write (iout,*) "contlistj"
            do i=1,irowj
            write (iout,*) i,contlistj(1,i),contlistj(2,i)
            enddo
            write (iout,*) "contlisti_right"
            do i=1,irowi_right
            write (iout,*) i,contlisti_right(1,i),contlisti_right(2,i)
            enddo
            write (iout,*) "contlistj_right"
            do i=1,irowj_right
            write (iout,*) i,contlistj_right(1,i),contlistj_right(2,i)
            enddo
#endif
            if (contlisti(1,irowi).lt.contlisti_right(1,1)) then
c              write (iout,*) "<"
              contlisti(:,irowi+1:irowi+irowi_right)=
     &          contlisti_right(:,1:irowi_right)
              contlisti(2,irowi+1:irowi+irowi_right)=
     &          contlisti_right(2,1:irowi_right)+contlisti(2,irowi)
              contlistj(:,irowj+1:irowj+irowj_right)=
     &          contlistj_right(:,:irowj_right)
              irowi=irowi+irowi_right
              irowj=irowj+irowj_right
            else if (contlisti(1,irowi).eq.contlisti_right(1,1)) then
c              write (iout,*) "=="
              iblock=contlisti(2,irowi)
              iblock_right=contlisti_right(2,1)
              if (contlistj_right(1,1).gt.contlistj(2,iblock)+1) then
                contlistj(:,iblock+1:iblock+iblock_right)=
     &            contlistj_right(:,:iblock_right)
                contlisti(1,irowi+1:irowi+irowi_right-1)=
     &            contlisti_right(1,2:irowi_right)
                contlisti(2,irowi+1:irowi+irowi_right-1)=
     &            contlisti_right(2,2:irowi_right)+contlisti(2,irowi)
                contlisti(2,irowi)=contlisti(2,irowi)
     &            +contlisti_right(2,1)
                ind1=iblock+iblock_right+1
                ind2=iblock+iblock_right+irowj_right
                contlistj(:,ind1:ind2)=
     &        contlistj_right(:,iblock_right+1:iblock_right+irowj_right)
                irowi=irowi+irowi_right-1
                irowj=irowj+irowj_right
              else if (contlistj(2,iblock)+1.eq.contlistj_right(1,1))
     &        then
                contlistj(2,iblock)=contlistj_right(2,1)
                contlistj(:,iblock+1:iblock+iblock_right-1)=
     &            contlistj_right(:,2:iblock_right)

                contlisti(:,irowi+1:irowi+irowi_right-1)=
     &            contlisti_right(:,2:irowi_right)
                contlisti(2,irowi+1:irowi+irowi_right-1)=
     &            contlisti(2,irowi+1:irowi+irowi_right-1)+
     &            contlisti(2,irowi)-1

                contlisti(2,irowi)=
     &            contlisti(2,irowi)+contlisti_right(2,1)-1


                ind1=iblock+iblock_right
                ind2=iblock+iblock_right+irowj_right-1
                contlistj(:,ind1:ind2)=
     &          contlistj_right(:,iblock_right+1:
     &            iblock_right+irowj_right-1)
                irowi=irowi+irowi_right-1
                irowj=irowj+irowj_right-1
              else
                write (iout,*) "FATAL ERROR (merge 1)!!!!!",
     &            irowi,irowj
                write (*,*)"Task",me," FATAL ERROR (merge 1)!!!!!",
     &            irowi,irowj
                call MPI_Abort(MPI_COMM_WORLD,Ierror)
              endif
            else
              write (iout,*) "FATAL ERROR (merge 2)!!!!!",
     &           irowi,irowj
              write (*,*) "Task",me," FATAL ERROR (merge 2)!!!!!",
     &           irowi,irowj
              call MPI_Abort(MPI_COMM_WORLD,Ierror)
            endif
            endif
          endif
   10     continue
          iproc=iproc+krok
        enddo
        krok=krok*2
      enddo
      call MPI_Bcast(irowi,1,MPI_INTEGER,king,FG_COMM,IERROR)
      call MPI_Bcast(irowj,1,MPI_INTEGER,king,FG_COMM,IERROR)
      call MPI_Bcast(contlisti(1,1),2*irowi,MPI_INTEGER,king,
     &  FG_COMM,IERROR)
      call MPI_Bcast(contlistj(1,1),2*irowj,MPI_INTEGER,king,
     &  FG_COMM,IERROR)
#ifdef DEBUG
      if (fg_rank.eq.0) then
      write (iout,*) "list_merge"
      do i=1,irowi
      write (iout,*) i,contlisti(1,i),contlisti(2,i)
      enddo
      do i=1,irowj
      write (iout,*) i,contlistj(1,i),contlistj(2,i)
      enddo
      endif
#endif
#endif
      return
      end
