C
C------------------------------------------------------------------------------
C
      double precision function alpha(c1,c2,c3)
c
c  Calculates the planar angle between atoms (i1), (i2), and (i3).
c
      implicit none
      double precision c1(3),c2(3),c3(3)
      double precision x12,x23,y12,y23,z12,z23,vnorm,wnorm,scalar,angle
      double precision arcos
      external arcos
      include 'COMMON.GEO'
      x12=c1(1)-c2(1)
      x23=c3(1)-c2(1)
      y12=c1(2)-c2(2)
      y23=c3(2)-c2(2)
      z12=c1(3)-c2(3)
      z23=c3(3)-c2(3)
      vnorm=dsqrt(x12*x12+y12*y12+z12*z12)
      wnorm=dsqrt(x23*x23+y23*y23+z23*z23)
      if ((vnorm.eq.0.0d0).or.(wnorm.eq.0.0d0)) then
      scalar=1.0d0
      else
      scalar=(x12*x23+y12*y23+z12*z23)/(vnorm*wnorm)
      endif
      alpha=arcos(scalar)
      return
      end

      double precision function cos_alpha(c1,c2,c3)
      implicit none
      double precision c1(3),c2(3),c3(3)
      double precision x12,x23,y12,y23,z12,z23,vnorm,wnorm,scalar,vwnorm
      include 'COMMON.GEO'
      x12=c1(1)-c2(1)
      x23=c3(1)-c2(1)
      y12=c1(2)-c2(2)
      y23=c3(2)-c2(2)
      z12=c1(3)-c2(3)
      z23=c3(3)-c2(3)
      vnorm=x12*x12+y12*y12+z12*z12
      wnorm=x23*x23+y23*y23+z23*z23
      vwnorm=vnorm*wnorm
      if (vwnorm.eq.0.0d0) then
        scalar=1.0d0
      else
        scalar=(x12*x23+y12*y23+z12*z23)/dsqrt(vwnorm)
      endif
      cos_alpha=scalar
      return
      end
C
C------------------------------------------------------------------------------
C
      double precision function beta(c1,c2,c3,c4)
c
c  Calculates the dihedral angle between atoms (i1), (i2), (i3) and (i4)
c
      implicit none
      double precision c1(3),c2(3),c3(3),c4(3)
      double precision x12,x23,x34,y12,y23,y34,z12,z23,z34,vnorm,wnorm,
     & vx,vy,vz,wx,wy,wz,tx,ty,tz,scalar,angle
      include 'COMMON.GEO'
      x12=c1(1)-c2(1)
      x23=c3(1)-c2(1)
      x34=c4(1)-c3(1)
      y12=c1(2)-c2(2)
      y23=c3(2)-c2(2)
      y34=c4(2)-c3(2)
      z12=c1(3)-c2(3)
      z23=c3(3)-c2(3)
      z34=c4(3)-c3(3)
cd    print '(2i3,3f10.5)',i1,i2,x12,y12,z12
cd    print '(2i3,3f10.5)',i2,i3,x23,y23,z23
cd    print '(2i3,3f10.5)',i3,i4,x34,y34,z34
      wx=-y23*z34+y34*z23
      wy=x23*z34-z23*x34
      wz=-x23*y34+y23*x34
      wnorm=dsqrt(wx*wx+wy*wy+wz*wz)
      vx=y12*z23-z12*y23
      vy=-x12*z23+z12*x23
      vz=x12*y23-y12*x23
      vnorm=dsqrt(vx*vx+vy*vy+vz*vz)
      if (vnorm.gt.1.0D-13 .and. wnorm.gt.1.0D-13) then
      scalar=(vx*wx+vy*wy+vz*wz)/(vnorm*wnorm)
      if (dabs(scalar).gt.1.0D0)
     &scalar=0.99999999999999D0*scalar/dabs(scalar)
      angle=dacos(scalar)
cd    print '(2i4,10f7.3)',i2,i3,vx,vy,vz,wx,wy,wz,vnorm,wnorm,
cd   &scalar,angle
      else
      angle=pi
      endif
c     if (angle.le.0.0D0) angle=pi+angle
      tx=vy*wz-vz*wy
      ty=-vx*wz+vz*wx
      tz=vx*wy-vy*wx
      scalar=tx*x23+ty*y23+tz*z23
      if (scalar.lt.0.0D0) angle=-angle
      beta=angle
      return
      end

      subroutine beta_2(c1,c2,c3,c4,angle,cos_angle)
c
c  Calculates the dihedral angle between atoms (i1), (i2), (i3) and (i4)
c
      implicit none
      double precision c1(3),c2(3),c3(3),c4(3)
      double precision x12,x23,x34,y12,y23,y34,z12,z23,z34,vnorm,wnorm,
     & vx,vy,vz,wx,wy,wz,tx,ty,tz,scalar,angle,cos_angle
      include 'COMMON.GEO'
      x12=c1(1)-c2(1)
      x23=c3(1)-c2(1)
      x34=c4(1)-c3(1)
      y12=c1(2)-c2(2)
      y23=c3(2)-c2(2)
      y34=c4(2)-c3(2)
      z12=c1(3)-c2(3)
      z23=c3(3)-c2(3)
      z34=c4(3)-c3(3)
      wx=-y23*z34+y34*z23
      wy=x23*z34-z23*x34
      wz=-x23*y34+y23*x34
      wnorm=dsqrt(wx*wx+wy*wy+wz*wz)
      vx=y12*z23-z12*y23
      vy=-x12*z23+z12*x23
      vz=x12*y23-y12*x23
      vnorm=dsqrt(vx*vx+vy*vy+vz*vz)
      if (vnorm.gt.1.0D-13 .and. wnorm.gt.1.0D-13) then
      scalar=(vx*wx+vy*wy+vz*wz)/(vnorm*wnorm)
      if (dabs(scalar).gt.1.0D0)
     &scalar=0.99999999999999D0*scalar/dabs(scalar)
      angle=dacos(scalar)
      cos_angle=scalar
cd    print '(2i4,10f7.3)',i2,i3,vx,vy,vz,wx,wy,wz,vnorm,wnorm,
cd   &scalar,angle
      else
      angle=pi
      cos_angle=-1.0d0
      endif
c     if (angle.le.0.0D0) angle=pi+angle
      tx=vy*wz-vz*wy
      ty=-vx*wz+vz*wx
      tz=vx*wy-vy*wx
      scalar=tx*x23+ty*y23+tz*z23
      if (scalar.lt.0.0D0) angle=-angle
      return
      end
C
C------------------------------------------------------------------------------
C
      double precision function dist(c1,c2)
c
c  Calculates the distance between atoms (i1) and (i2).
c
      implicit none
      double precision c1(3),c2(3)
      double precision x12,y12,z12
      x12=c1(1)-c2(1)
      y12=c1(2)-c2(2)
      z12=c1(3)-c2(3)
      dist=dsqrt(x12*x12+y12*y12+z12*z12)
      return
      end
C
C------------------------------------------------------------------------------
C
      double precision function dist_sq(c1,c2)
c
c  Calculates the square of distance between atoms (i1) and (i2).
c
      implicit none
      double precision c1(3),c2(3)
      double precision x12,y12,z12
      x12=c1(1)-c2(1)
      y12=c1(2)-c2(2)
      z12=c1(3)-c2(3)
      dist_sq=x12*x12+y12*y12+z12*z12
      return
      end
C
