      subroutine EGB_FN(evdw)
#ifdef _OPENMP
      use omp_lib
#endif
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Gay-Berne potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.SPLITELE'
      include 'COMMON.SBRIDGE'
      !include 'COMMON.EELEC'
      include 'COMMON.EGB'
      include 'COMMON.LIPID'
      include 'COMMON.NEWBOX'
      include 'COMMON.CONTROL'
      include 'COMMON.FFIELD'
#ifdef DEBUG
      logical lprn
#endif
      double precision evdw,evdwij,rij,xyzj(3),evdwij_przed_tri
      integer i,j,k,lastj,seq_idx,nseq_idx,ikont,jblock
      record /egb_work_chunk/ seq_work,nseq_work
      double precision scalar
      integer my_thread,threads_used
      integer from_blk,to_blk,from_j,to_j
      integer from_ik,to_ik,first_blk,last_blk,first_j,last_j
      double precision g,gg(3),ggx(3),dsci_inv
      double precision box(3),halfbox(3)
      logical full,limited

ccccc      energy_dec=.false.
C      print *,'Entering EGB nnt=',nnt,' nct=',nct,' expon=',expon

#ifdef DEBUG
      lprn=.false.
#endif
c     if (icall.eq.0) lprn=.false.
C the loop over all 27 posible neigbours (for xshift=0,yshift=0,zshift=0
C we have the original box)
c     do i=iatsc_s,iatsc_e

      threads_used=scsc_threads

!$OMP PARALLEL NUM_THREADS(threads_used) DEFAULT(SHARED)
!$OMP& PRIVATE(
!$OMP&   i,j,ikont,jblock,k,seq_work,nseq_work,seq_idx,nseq_idx,
!$OMP&   lastj,evdwij,evdwij_przed_tri,rij,xyzj,full,
!$OMP&   from_ik,to_ik,first_blk,last_blk,first_j,last_j,
!$OMP&   box,halfbox,
!$OMP&   my_thread,from_blk,to_blk,from_j,to_j
!$OMP& )
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif
      seq_idx=0
      nseq_idx=0

      from_ik=scsc_from_ik(my_thread)
      to_ik=scsc_to_ik(my_thread)
      first_blk=scsc_first_blk(my_thread)
      last_blk=scsc_last_blk(my_thread)
      first_j=scsc_first_j(my_thread)
      last_j=scsc_last_j(my_thread)

      box=boxsize
      halfbox=halfboxsize

      do ikont=from_ik,to_ik
        i=newcontlisti(1,ikont)
        from_blk=newcontlisti(2,ikont-1)+1
        to_blk=newcontlisti(2,ikont)

        if(ikont.eq.from_ik) from_blk=first_blk
        if(ikont.eq.to_ik) to_blk=last_blk

        lastj=-1

        do jblock=from_blk,to_blk
          from_j=newcontlistj(1,jblock)
          to_j=newcontlistj(2,jblock)
          if((ikont.eq.from_ik).and.(jblock.eq.from_blk)) from_j=first_j
          if((ikont.eq.to_ik).and.(jblock.eq.to_blk)) to_j=last_j

          do j=from_j,to_j
C define scaling factor for lipids

C           if (positi.le.0) positi=positi+boxzsize
C           print *,i
C first for peptide groups
c for each residue check if it is in lipid or lipid water border area
C
C Calculate SC interaction energy.
C
            IF (dyn_ss_mask(i).and.dyn_ss_mask(j)) THEN
c             write(iout,*) "PRZED ZWYKLE", evdwij
              call dyn_ssbond_ene(i,j,evdwij)
c             write(iout,*) "PO ZWYKLE", evdwij
c             call flush(iout)
c              write (iout,*) "gvdwx",i,j,gvdwx(:,j),gvdwx(:,j)
              !evdw=evdw+evdwij
              egb_accum(my_thread).evdw=egb_accum(my_thread).evdw+evdwij
#define DEBUG
#ifdef DEBUG
!              if (energy_dec) write (iout,'(a6,2i5,0pf7.3,a3)') 
!     &                        'evdw',i,j,evdwij,' ss'
              if (energy_dec)
     &        write(iout,'(a,2i4,f18.12)')'DD',i,j,evdwij*wsc

#endif
#define TRIPLE
#ifdef TRIPLE
C triple bond artifac removal
c             do k=j+1,iend(i,iint) 
              do k=j+1,nct
C search over all next residues
                if (dyn_ss_mask(k)) then
C check if they are cysteins
C                 write(iout,*) 'k=',k

c                 write(iout,*) "PRZED TRI", evdwij
                  evdwij_przed_tri=evdwij
                  call triple_ssbond_ene(i,j,k,evdwij)
c                 if(evdwij_przed_tri.ne.evdwij) then
c                   write (iout,*) "TRI:", evdwij, evdwij_przed_tri
c                 endif

c                 write(iout,*) "PO TRI", evdwij
C call the energy function that removes the artifical triple disulfide
C bond the soubroutine is located in ssMD.F
                  !evdw=evdw+evdwij             
                  egb_accum(my_thread).evdw=
     &                              egb_accum(my_thread).evdw+evdwij
#ifdef DEBUG
!                  if (energy_dec) write (iout,'(a6,2i5,0pf7.3,a3)')
!     &                        'evdw',i,j,evdwij,'tss'
                  if (energy_dec)
     &             write(iout,'(a,3i4,f18.12)')'ESSD3',i,j,k,evdwij*wsc
#endif
#undef DEBUG
                endif!dyn_ss_mask(k)
              enddo! k
#endif
            ELSE
#define EVDW
#ifdef EVDW
              LOG_STAT(200, 1)
              !call wrapvec(c_tobox(:,nres+j)-c_tobox(:,nres+i),xyzj)
              call wrapvec2(c_tobox(:,nres+j)-c_tobox(:,nres+i),xyzj,
     &                      halfbox,box)
              rij=scalar(xyzj,xyzj)
              if(rij.ge.r_cut_int_sq) cycle
              LOG_STAT(201, 1)

              if((j.ne.lastj+1).and.(seq_idx.gt.0)) then
                if((seq_idx.lt.simd_seq_cutoff) .and.
     &             (nseq_idx+seq_idx.lt.egb_buffer_size)) then
                  LOG_STAT(204, seq_idx)
                  call egb_move_work(seq_work,seq_idx,nseq_work,
     &                               nseq_idx)
                else
                  LOG_STAT(202, seq_idx)
                  call EGB_WORK_SEQ(seq_work,i,
     &                              seq_work.j(1),seq_work.j(seq_idx),
     &                              egb_accum(my_thread).evdw,
     &                              egb_result(:,my_thread))
                  seq_idx=0
                endif
                call egb_queue_work(nseq_work,nseq_idx,j,xyzj,rij,full)
                lastj=j
                if(full) then
                  LOG_STAT(203, nseq_idx)
                  call EGB_WORK_NSEQ(nseq_work,i,
     &                               1,nseq_idx,
     &                               egb_accum(my_thread).evdw,
     &                               egb_result(:,my_thread))
                  nseq_idx=0
                  lastj=-1
                endif
              else
                call egb_queue_work(seq_work,seq_idx,j,xyzj,rij,full)
                lastj=j
                if(full) then
                  LOG_STAT(202, seq_idx)
                  call EGB_WORK_SEQ(seq_work,i,
     &                              seq_work.j(1),seq_work.j(seq_idx),
     &                              egb_accum(my_thread).evdw,
     &                              egb_result(:,my_thread))
                  seq_idx=0
                  lastj=-1
                endif
              endif
#endif
            ENDIF  ! dyn_ss            
          enddo    ! j
        enddo      ! jblock

        if(seq_idx.gt.0) then
          LOG_STAT(202, seq_idx)
          call EGB_WORK_SEQ(seq_work,i,
     &                      seq_work.j(1),seq_work.j(seq_idx),
     &                      egb_accum(my_thread).evdw,
     &                      egb_result(:,my_thread))
          seq_idx=0
        endif
        if(nseq_idx.gt.0) then
          LOG_STAT(203, nseq_idx)
          call EGB_WORK_NSEQ(nseq_work,i,
     &                       1,nseq_idx,
     &                       egb_accum(my_thread).evdw,
     &                       egb_result(:,my_thread))
          nseq_idx=0
        endif
      enddo        ! i

!$OMP END PARALLEL
c      write (iout,*) "egb_t gvdwc, gvdwx"
c      do i=1,nres
c        write (iout,'(i3,3f10.5,5x,3f10.5,5x,f10.5)')
c     &   i,(gvdwx(j,i),j=1,3),(gvdwc(j,i),j=1,3)
c      enddo

!$OMP PARALLEL DO PRIVATE(g,gg,ggx,j,dsci_inv)
      do i=1,nres
        gg=0.0d0
        ggx=0.0d0
        g=0.0d0
        do j=1,threads_used
          gg=gg+egb_result(i,j).gvdwc
          egb_result(i,j).gvdwc=0.0d0
!       enddo
!       do j=1,threads_used
          ggx=ggx+egb_result(i,j).gvdwx
          egb_result(i,j).gvdwx=0.0d0
!       enddo
!       do j=1,threads_used
          g=g+egb_result(i,j).lip_delta
          egb_result(i,j).lip_delta=0.0d0
        enddo

        dsci_inv=vbld_inv(i+nres)
        if(dsci_inv.gt.1.0d20) then
          dsci_inv=0.0d0
        endif

        gg(3)=gg(3)+lipid_cache(nres+i).ssgrad*g
        gvdwc(:,i)=gvdwc(:,i)+gg
        gvdwx(:,i)=gvdwx(:,i)+gg+ggx*dsci_inv
      enddo
!$OMP END PARALLEL DO

      evdw=0.0D0
      do i=1,threads_used
        evdw=evdw+egb_accum(i).evdw
        egb_accum(i).evdw=0.0d0
      enddo

c      write (iout,*) "egb_tt gvdwc, gvdwx"
c      do i=1,nres
c        write (iout,'(i3,3f10.5,5x,3f10.5,5x,f10.5)')
c     &   i,(gvdwx(j,i),j=1,3),(gvdwc(j,i),j=1,3)
c      enddo
      return
      end
