      subroutine ebend_kcc(etheta)
C The rigorous attempt to derive energy function
      use omp_lib
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.TORCNSTR'
      include 'COMMON.CONTROL'
      double precision etheta,th_etheta(8,max_fg_threads)
      double precision aux
      double precision gnmr1,gnmr1prim
      logical lprn
      integer i,iti
      double precision costhet,thybt1(maxang_kcc),gradthybt1,
     & sumth1thyb
      double precision glocangdcm2(3,-1:maxres)
      common /ebendkccglocangdc/ glocangdcm2
      double precision scalar,tschebyshev,gradtschebyshev
      integer my_thread,threads_used,from,to,range_lo,range_hi
#if defined(DEBUG) || defined(ENERGY_DEC)
C Set lprn=.true. for debugging
      lprn=energy_dec
c     lprn=.true.
C      print *,"wchodze kcc"
      if (lprn) write (iout,*) "ebend_kcc tor_mode",tor_mode
c      write (iout,*) "ithet_start,ithet_end",ithet_start,ithet_end
#endif
      !etheta=0.0D0
      th_etheta=0.0d0
      !range_lo=ithet_start
      !range_hi=ithet_end
      threads_used=omp_get_max_threads()
!$OMP PARALLEL DEFAULT(SHARED) NUM_THREADS(threads_used)
!$OMP& PRIVATE(i,from,to,my_thread,iti,aux,
!$OMP&         costhet,thybt1,sumth1thyb,gradthybt1)
      my_thread=omp_get_thread_num()+1
      !from=range_lo+((range_hi-range_lo)/threads_used)*(my_thread-1)
      !to=range_lo+((range_hi-range_lo)/threads_used)*my_thread-1
      !if(my_thread.eq.threads_used) to=range_hi
      call split_work_for_threads(from,to,ithet_start,ithet_end,
     &                            my_thread,threads_used)
      !do i=ithet_start,ithet_end
      glocangdcm2(:,from-2:to-2)=0.0d0
      do i=from,to
c        print *,i,itype(i-1),itype(i),itype(i-2)
c        if ((itype(i-1).eq.ntyp1).or.itype(i-2).eq.ntyp1
c     &  .or.itype(i).eq.ntyp1) cycle
c 2/23/22 AL: prevent 0 or 180 deg involving dummy residues, which results 
c in esc instability. 
c        write (iout,*) i,itype(i-2),itype(i-1),itype(i)
        if (itype(i-1).eq.ntyp1) cycle
        iti=iabs(itortyp(itype(i-1)))
c        sinthet=dsin(theta(i))
c        costhet=dcos(theta(i))
        costhet=costtab(i)
#ifndef SC_END
        if (itype(i-2).eq.ntyp1 .or. itype(i).eq.ntyp1) then

        !etheta = etheta + 1.0d7*gnmr1(costhet,-0.9d0,0.9d0)
        th_etheta(1,my_thread) = th_etheta(1,my_thread)
     &                         + 1.0d7*gnmr1(costhet,-0.9d0,0.9d0)
        aux = 1.0d7*gnmr1prim(costhet,-0.9d0,0.9d0)
        !glocangdc(:,i-2)=glocangdc(:,i-2) + aux*dcosttab(:,1,i)
        glocangdcm2(:,i-2)=aux*dcosttab(:,1,i)
        glocangdc(:,i-1)=glocangdc(:,i-1) + aux*dcosttab(:,2,i)

#ifdef ENERGY_DEC
        if (lprn) 
     &  write (iout,'(2hD ,a3,i7,2i3," angle",f10.2," energy ",f10.5)') 
     &    restyp(itype(i-1)),i-1,itype(i-1),iti,dacos(costhet)*rad2deg,
     &    1.0d7*gnmr1(costhet,-0.9d0,0.9d0)
#endif

        else
#else
        if (itype(i-2).eq.ntyp1.or.itype(i).eq.ntyp1) cycle
#endif
        thybt1(:nbend_kcc_Tb(iti))=v1bend_chyb(1:nbend_kcc_Tb(iti),iti)
        sumth1thyb=v1bend_chyb(0,iti)+
     &    tschebyshev(1,nbend_kcc_Tb(iti),thybt1(1),costhet)

#ifdef ENERGY_DEC
        if (lprn) 
     &  write (iout,'(2hR ,a3,i7,2i3," angle",f10.2," ebend ",f10.5)') 
     &    restyp(itype(i-1)),i-1,itype(i-1),iti,dacos(costhet)*rad2deg,
     &    sumth1thyb
#endif
        gradthybt1=gradtschebyshev(0,nbend_kcc_Tb(iti)-1,thybt1(1),
     &                             costhet)
        !etheta=etheta+sumth1thyb
        th_etheta(1,my_thread)=th_etheta(1,my_thread)+sumth1thyb
C        print *,sumth1thyb,gradthybt1,sinthet*(-0.5d0)
c        gloc(nphi+i-2,icg)=gloc(nphi+i-2,icg)-wang*gradthybt1*sinthet
        !glocangdc(:,i-2)=glocangdc(:,i-2)+gradthybt1*dcosttab(:,1,i)
        glocangdcm2(:,i-2)=gradthybt1*dcosttab(:,1,i)
        glocangdc(:,i-1)=glocangdc(:,i-1)+gradthybt1*dcosttab(:,2,i)
#ifndef SC_END
        endif
#endif
      enddo

!$OMP BARRIER
      !do i=ithet_start-1,ithet_end
      do i=from,to
        glocangdc(:,i-1)=glocangdc(:,i-1)+glocangdcm2(:,i-1)
      enddo
!$OMP END PARALLEL

      i=ithet_start-1
      glocangdc(:,i-1)=glocangdc(:,i-1)+glocangdcm2(:,i-1)

      etheta=0
      do i=1,threads_used
        etheta=etheta+th_etheta(1,i)
      enddo
      if (energy_dec) write (iout,'(80(1h-))')
      return
      end
