      subroutine check_sc_distr
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.TIME1'
      include 'COMMON.INTERACT'
      include 'COMMON.NAMES'
      include 'COMMON.GEO'
      include 'COMMON.HEADER'
      include 'COMMON.CONTROL'
      logical fail
      double precision varia(maxvar)
      double precision hrtime,mintime,sectime
      parameter (MaxSample=10000000,delt=1.0D0/MaxSample)
      dimension prob(0:72,0:90)
      common /checkscdistrcommon/ varia

      dV=2.0D0*5.0D0*deg2rad*deg2rad
      print *,'dv=',dv
      do 10 it=1,1
        if (it.eq.10) goto 10
        open (20,file=restyp(it)//'_distr.sdc',status='unknown')
        call gen_side(it,90.0D0*deg2rad,al,om,fail)
        close (20)
        goto 10
        open (20,file=restyp(it)//'_distr1.sdc',status='unknown')
        do i=0,90
          do j=0,72
            prob(j,i)=0.0D0
          enddo
        enddo
        do isample=1,MaxSample
          call gen_side(it,90.0D0*deg2rad,al,om)
          indal=rad2deg*al/2
          indom=(rad2deg*om+180.0D0)/5
          prob(indom,indal)=prob(indom,indal)+delt
        enddo
        do i=45,90
          do j=0,72
            write (20,'(2f10.3,1pd15.5)') 2*i+0.0D0,5*j-180.0D0,
     &              prob(j,i)/dV
          enddo
        enddo
   10   continue
      return
      end
