      subroutine init_box
      implicit none
      include "DIMENSIONS"
      include "COMMON.CHAIN"
      include "COMMON.NEWBOX"
      boxsize(1) = boxxsize
      boxsize(2) = boxysize
      boxsize(3) = boxzsize
      iboxsize = 1.0d0 / boxsize
      halfboxsize = 0.5d0 * boxsize
      end subroutine init_box


      subroutine to_box2(pos, output)
      implicit none
      include 'COMMON.NEWBOX'
      double precision pos(3),output(3),scaled(3),wrapped(3)
      scaled=pos*iboxsize
      wrapped=scaled-floor(scaled)
      output=wrapped*boxsize
      return
      end


      subroutine wrapvec(vec,output)
      implicit none
      include 'COMMON.NEWBOX'
      double precision vec(3),output(3)
      output=vec
      where(output.gt.halfboxsize)
            output=output-boxsize
      end where
      where(vec.lt.-halfboxsize)
            output=output+boxsize
      end where
      return
      end


      subroutine wrapvec2(vec,output,halfbox,box)
      implicit none
      double precision vec(3),output(3)
      double precision halfbox(3),box(3)
        output=vec
      where(output.gt.halfbox)
        output=output-box
      end where
      where(vec.lt.-halfbox)
        output=output+box
      end where
      return
      end

