      double precision function rmscalc(ccc,cccref,ipermmin)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      double precision cccref(3,maxres2),creff(3,maxres2),
     &  ccc(3,maxres2),cc(3,maxres2)
      double precision przes(3),obrot(3,3)
      logical non_conv
      integer i,ii,j,ib,ichain,indchain,ichain1,ichain2,
     &  iperm,ipermmin
      double precision rms,rmsmin
      common /rmscalccommon/ creff,cc

C Loop over chain permutations
      rmsmin=1.0d10
      DO IPERM=1,NPERMCHAIN
      ii=0
      if (iz_sc.lt.2) then
        do ichain=1,nchain
          indchain=tabpermchain(ichain,iperm)
#ifdef DEBUG
          write (iout,*) "ichain",ichain," indchain",indchain
          write (iout,*) "chain_border",chain_border(1,ichain),
     &      chain_border(2,ichain)
#endif
          do i=1,chain_length(ichain)
c          do i=nstart_sup(ichain),nend_sup(ichain)
            ichain1=chain_border(1,ichain)+i-1
            ichain2=chain_border(1,indchain)+i-1
            if (ichain1.lt.nz_start .or. ichain1.gt.nz_end .or.
     &          ichain2.lt.nz_start .or. ichain2.gt.nz_end) cycle
            ii=ii+1
#ifdef DEBUG
            write (iout,*) "back",ii," ichain1",ichain1,
     &       " ichain2",ichain2," i",i,chain_border(1,ichain)+i-1
#endif
            do j=1,3
              cc(j,ii)=ccc(j,ichain2)
              creff(j,ii)=cccref(j,ichain1)
            enddo
#ifdef DEBUG
            write (iout,'(3f10.5,5x,3f10.5)')
     &       (cc(j,ii),j=1,3),(creff(j,ii),j=1,3)
#endif
          enddo
        enddo
      endif
      if (iz_sc.gt.0) then
        do ichain=1,nchain
          indchain=tabpermchain(ichain,iperm)
          do i=1,chain_length(ichain)
c          do i=nstart_sup(ichain),nend_sup(ichain)
            ichain1=chain_border(1,ichain)+i-1
            ichain2=chain_border(1,indchain)+i-1
            if (ichain1.lt.nz_start .or. ichain1.gt.nz_end .or.
     &          ichain2.lt.nz_start .or. ichain2.gt.nz_end) cycle
            if (itype(ichain1).ne.10) then
              ii=ii+1
#ifdef DEBUG
              write (iout,*) "side",ii," ichain1",ichain1,
     &         " ichain2",ichain2
#endif
              do j=1,3
                cc(j,ii)=ccc(j,ichain2+nres)
                creff(j,ii)=cccref(j,ichain1+nres)
              enddo
#ifdef DEBUG
              write (iout,'(3f10.5,5x,3f10.5)')
     &        (cc(j,ii),j=1,3),(creff(j,ii),j=1,3)
#endif
            endif
          enddo
        enddo
      endif
c      write (iout,*) "rmscalc: iprot",iprot," nsup",nsup(iprot)," ii",ii
      call fitsq(rms,cc(1,1),creff(1,1),ii,przes,obrot,non_conv)
      if (non_conv) then
        write (iout,*) 'Error: FITSQ non-convergent'
        rms=1.0d2
      else if (rms.lt.-1.0d-6) then
        print *,'Error: rms^2 = ',rms
        rms = 1.0d2
      else if (rms.ge.1.0d-6 .and. rms.lt.0) then
        rmscalc=0.0d0
      else
        rms = dsqrt(rms)
      endif
      if (rms.lt.rmsmin) then
        rmsmin=rms
        ipermmin=iperm
      endif
#ifdef DEBUG
      write (iout,*) "iperm",iperm," rms",rms
#endif
      ENDDO
      rmscalc=rmsmin
#ifdef DEBUG
      write (iout,*) "ipermmin",ipermmin," rmsmin",rmsmin
#endif
      return
      end
c------------------------------------------------------------------------
      double precision function rmscalc_thet(ttheta,theta_reff,
     &     iperm)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      integer iperm,k,ichain,indchain,kchain1,kchain2,nnnn
      double precision ttheta(maxres),theta_reff(maxres),rmsthet,dtheta
      rmsthet = 0.0d0
      nnnn=0
      do ichain=1,nchain
        indchain=tabpermchain(ichain,iperm)
c        write (iout,*) "ichain",ichain," iperm",iperm,
c     &    " indchain",indchain
c        call flush(iout)
        do k=3,chain_length(ichain)
          kchain1=chain_border(1,ichain)+k-1
          kchain2=chain_border(1,indchain)+k-1
          nnnn=nnnn+1
          dtheta = ttheta(kchain2)-theta_reff(kchain1)
c                write (iout,*) k,theta(k),theta_ref(k,iref,ib,iprot),
c     &            dtheta
          rmsthet = rmsthet+dtheta*dtheta
        enddo
      enddo
      nnnn=nnnn-1
      rmsthet=dsqrt(rmsthet/nnnn)
#ifdef DEBUG
      write (iout,*) "nnnn",nnnn," rmsthet",rmsthet
#endif
      rmscalc_thet=rmsthet
      return
      end
c------------------------------------------------------------------------
      double precision function rmscalc_phi(pphi,phi_reff,iperm)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      integer iperm,k,ichain,indchain,kchain1,kchain2,nnnn
      double precision pphi(maxres),phi_reff(maxres),rmsphi,dphi
      double precision pinorm
      rmsphi = 0.0d0
      nnnn=0
      do ichain=1,nchain
        indchain=tabpermchain(ichain,iperm)
        do k=4,chain_length(ichain)
          kchain1=chain_border(1,ichain)+k-1
          kchain2=chain_border(1,indchain)+k-1
          nnnn=nnnn+1
          dphi=pinorm(pphi(kchain2)-phi_reff(kchain1))
c         write (iout,*) k,phi(k),phi_ref(k,iref,ib,iprot),
c     &   pinorm(phi(k)-phi_ref(k,iref,ib,iprot))
          rmsphi = rmsphi + dphi*dphi
        enddo
      enddo
      nnnn=nnnn-1
      rmsphi=dsqrt(rmsphi/nnnn)
#ifdef DEBUG
      write (iout,*) "nnnn",nnnn," rmsphi",rmsphi
#endif
      rmscalc_phi=rmsphi
      return
      end
c------------------------------------------------------------------------
      double precision function rmscalc_side(xxtabb,yytabb,zztabb,
     & xxreff,yyreff,zzreff,iperm)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      integer iperm,k,ichain,indchain,kchain1,kchain2,nnnn
      double precision xxtabb(maxres),yytabb(maxres),zztabb(maxres),
     & xxreff(maxres),yyreff(maxres),zzreff(maxres),rmsside,
     & dxref,dyref,dzref
      rmsside = 0.0d0
      nnnn=0
      do ichain=1,nchain
        indchain=tabpermchain(ichain,iperm)
        do k=1,chain_length(ichain)
          kchain1=chain_border(1,ichain)+k-1
          kchain2=chain_border(1,indchain)+k-1
          if (itype(kchain1).eq.ntyp1) cycle
          nnnn=nnnn+1
          dxref = xxtabb(kchain2)-xxreff(kchain1)
          dyref = yytabb(kchain2)-yyreff(kchain1)
          dzref = zztabb(kchain2)-zzreff(kchain1)
          rmsside = rmsside + dxref*dxref+dyref*dyref+dzref*dzref
        enddo
      enddo
      rmsside=dsqrt(rmsside/nnnn)
#ifdef DEBUG
      write (iout,*) "nnnn",nnnn," rmsside",rmsside
#endif
      rmscalc_side=rmsside
      return
      end
