      subroutine out_saxs(Esaxs_constr)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.SAXS'
      include 'COMMON.FFIELD'
      character*128 cfname
      double precision Esaxs_constr
      integer k
      integer ilen
      external ilen
      cfname=prefix(:ilen(prefix))//'.saxs'
      open(ientout,file=cfname)
c      call e_saxs(Esaxs_constr)
      write (ientout,'(a,f10.5)') 
     & "#Comparison of calculated and exp SAXS profile, loglik:",
     & Esaxs_constr*wsaxs
      do k=1,nsaxs
        write (ientout,'(f8.4,2(1pe15.5))') distsaxs(k),
     &  Pcalc(k)/Cnorm,Psaxs(k)
      enddo
      close(ientout)
      return
      end 
c----------------------------------------------------------------------------
      subroutine out_dist_viol
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.NMR'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      character*128 cfname
      integer ilen
      external ilen
      integer nviolpeak,nviolpeak_gross,ip,j,ii,iti,jj,itj,iresi,iresj,
     & iviol,list_peak_viol(maxdim_nmr)
      character*4 resi,resj
      character*1 restr_viol(0:2) /' ','m','M'/
      logical viol_nmr,viol_nmr_gross
      double precision dd,rvec(3)
      if (constr_dist.eq.12) then
      nviolpeak=0
      nviolpeak_gross=0
      cfname=prefix(:ilen(prefix))//'.nmr'
      open(ientout,file=cfname)
      call nmr_hpos(.true.)
      do j=1,npeak
        viol_nmr=.true.
        viol_nmr_gross=.true.
        do ip=ipeak(1,j),ipeak(2,j)
          ii=ihpb_peak(1,ip)
          iti=ihpb_peak(2,ip)
          jj=jhpb_peak(1,ip)
          itj=jhpb_peak(2,ip)
          call hdist(ii,iti,jj,itj,dd,rvec)
          iresi=ii-nnt+1
          iresj=jj-nnt+1
          if (iti.eq.0) then
            iresi=iresi+1
            resi=restyp(itype(ii+1))
          else
            resi=restyp(itype(ii))
          endif
          if (itj.eq.0) then
            iresj=iresj+1
            resj=restyp(itype(jj+1))
          else
            resj=restyp(itype(jj))
          endif
          if (dd.le.dhpb1_peak(ip)) then
            iviol=0
          else if (dd.le.dhpb1_peak(ip)+2.0d0) then
            iviol=1
          else
            iviol=2
          endif
          write (ientout,'(2(a3,i5,1x),i5,2f8.2,2a6,2x,a1)') 
     &     resi,iresi,resj,iresj,num_peak(j),dd,dhpb1_peak(ip),
     &     proton1(ip),proton2(ip),restr_viol(iviol)
          if (dd.le.dhpb1_peak(ip)) then
            viol_nmr=.false.
            viol_nmr_gross=.false.
          else if (dd.le.dhpb1_peak(ip)+2.0d0) then
            viol_nmr_gross=.false.
          endif
        enddo
        write (ientout,*)
        if (viol_nmr) then
          nviolpeak=nviolpeak+1
          list_peak_viol(nviolpeak)=j
        endif
        if (viol_nmr_gross) then
          nviolpeak_gross=nviolpeak_gross+1
        endif
      enddo
      if (nviolpeak.gt.0) then
       write (iout,'(a,i5,2h (f6.2,2h%))')
     &  "Number of violated NMR restraints:",
     &  nviolpeak,100*(nviolpeak+0.)/npeak
       write (iout,'(a,i5,2h (f6.2,2h%))')
     &  "Number of grossly violated NMR restraints (upper_limit+2A):",
     &  nviolpeak_gross,100*(nviolpeak_gross+0.)/npeak
       write (iout,'(a)')"List of violated restraints:"
       write (iout,'(16i5)') (list_peak_viol(j),j=1,nviolpeak)
      endif
      close(ientout)
      endif
      return
      end

