      subroutine mytschebyshev1andgrad(n,y,yt,yy,yb,ybt)
      implicit none
      include "DIMENSIONS"
      integer i,m,n
      double precision y,yt,fy,fyt,yy(0:n),yb(0:n),ybt(0:n)
c First-kind Tschebyshev polynomial with argument (y) multiplied by
c sin(t1)sin(t2) (yt) and its derivative.
c Note that the first term is omitted
c m=0: the constant term is included
c m=1: the constant term is not included
      yy(0)=1.0d0
      yy(1)=y
      yb(0)=0.0d0
      yb(1)=1.0d0
      ybt(0)=0.0d0
      ybt(1)=0.0d0
      do i=2,n
        yy(i)=2*yy(1)*yy(i-1)-yy(i-2)*yt*yt
        yb(i)=2*yy(i-1)+2*yy(1)*yb(i-1)-yb(i-2)*yt*yt
        ybt(i)=2*yy(1)*ybt(i-1)-ybt(i-2)*yt*yt-2*yy(i-2)*yt
      enddo
c      fy=0.0d0
c      fyt=0.0d0
c      do i=m,n
c        fy=fy+x(i)*yb(i)
c        fyt=fyt+x(i)*ybt(i)
c      enddo
      return
      end
c---------------------------------------------------------------------------
      subroutine mytschebyshev2andgrad(n,y,yt,yy,yb,ybt)
      implicit none
      include "DIMENSIONS"
      integer i,m,n
      double precision y,yt,fy,fyt,yy(0:n),yb(0:n),ybt(0:n)
c Second-kind Tschebyshev polynomial with argument (y) multiplied by
c sin(t1)sin(t2) (yt) and its derivative.
c Note that the first term is omitted
c m=0: the constant term is included
c m=1: the constant term is not included
      yy(0)=1.0d0
      yy(1)=2*y
      yb(0)=0.0d0
      yb(1)=2.0d0
      ybt(0)=0.0d0
      ybt(1)=0.0d0
      do i=2,n
        yy(i)=yy(1)*yy(i-1)-yy(i-2)*yt*yt
        yb(i)=2*yy(i-1)+yy(1)*yb(i-1)-yb(i-2)*yt*yt
        ybt(i)=yy(1)*ybt(i-1)-ybt(i-2)*yt*yt-2*yy(i-2)*yt
      enddo
c      fy=0.0d0
c      fyt=0.0d0
c      do i=m,n
c        fy=fy+x(i)*yb(i)
c        fyt=fyt+x(i)*ybt(i)
c      enddo
      return
      end
