      subroutine calculate_lipid_layers
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.INTERACT'
      include 'COMMON.LIPID'
      integer i
!$OMP PARALLEL DO DEFAULT(NONE)
!$OMP& PRIVATE(i)
!$OMP& SHARED(nres,cp,lipid_cache)
      do i=1,nres
        call lipid_layer(cp(1,i),cp(2,i),cp(3,i),
     &                   lipid_cache(i).ss,lipid_cache(i).ssgrad)
      enddo
!$OMP END PARALLEL DO

!$OMP PARALLEL DO DEFAULT(NONE)
!$OMP& PRIVATE(i)
!$OMP& SHARED(nres,c_tobox,lipid_cache)
      do i=1,nres
        call lipid_layer(c_tobox(1,nres+i),
     &                   c_tobox(2,nres+i),
     &                   c_tobox(3,nres+i),
     &                   lipid_cache(nres+i).ss,
     &                   lipid_cache(nres+i).ssgrad)
      enddo
!$OMP END PARALLEL DO
      return
      end
