      subroutine intcartderiv
#ifdef _OPENMP
      use omp_lib
#endif
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.IOUNITS'
      include 'COMMON.LOCAL'
      include 'COMMON.SCCOR'
      double precision dcostheta(3,2,maxres),
     &                 dtri(3,3),
     &                 dcosalpha(3,3),dcosomega(3,3),dsinomega(3,3),
     &                 vo1(3),vo2(3),vo3(3),vp1(3),vp2(3),vp3(3)
      double precision tdcosomicron(3,2,2),tdomicron(3,2,2)
      double precision tdcosomicronp(3,2,2),tdomicronp(3,2,2)
      integer i,j
      double precision sing,cosg,sint,cost,sint1,cost1,sint2,cost2
      double precision sint_inv,sint1_inv,sint2_inv,cosg_inv,sing_inv
      double precision fac0,fac1,fac2,fac3,fac4,fac13,fac24
      double precision ctgt,ctgt1,scalp,pi34,pi4,mult
      double precision scalar
      integer threads_used,my_thread,range_lo,range_hi,from,to
      common /intcartderivcommon/ dcostheta
      double precision half_sqrt2
      parameter(half_sqrt2=0.5d0*dsqrt(2.0d0))
       
#if defined(MPI) && defined(PARINTDER)
      if (nfgtasks.gt.1 .and. me.eq.king)
     &  call MPI_Bcast(8,1,MPI_INTEGER,king,FG_COMM,IERROR)
#endif
      pi4 = 0.5d0*pipol
      pi34 = 3*pi4

c      write (iout,*) "iphi1_start",iphi1_start," iphi1_end",iphi1_end
      dtheta(:,:,1:2)=0.0d0
      dphi(:,:,1:3)=0.0d0
      !do i=1,nres
      !  do j=1,3
      !    dtheta(j,1,i)=0.0d0
      !    dtheta(j,2,i)=0.0d0
      !    dphi(j,1,i)=0.0d0
      !    dphi(j,2,i)=0.0d0
      !    dphi(j,3,i)=0.0d0
      !  enddo
      !enddo

!$OMP PARALLEL DO SIMD DEFAULT(SHARED)
!$OMP& PRIVATE(cost,sint,sint_inv,j)
c Derivatives of thetas
#if defined(MPI) && defined(PARINTDER)
c We need dtheta(:,:,i-1) to compute dphi(:,:,i)
      do i=max0(ithet_start-1,3),ithet_end
#else
      do i=3,nres
#endif
        !cost=dcos(theta(i))
        !sint=sqrt(1-cost*cost)
        cost=cos_theta(i)
        sint=sin_theta(i)
        sint_inv=1.0d0/sint
        dcostheta(:,1,i)=-(dc_norm(:,i-1)+cost*dc_norm(:,i-2))*
     &                    vbld_inv(i-1)
c        if (itype(i-1).ne.ntyp1)
        dtheta(:,1,i)=-dcostheta(:,1,i)*sint_inv
        dcostheta(:,2,i)=-(dc_norm(:,i-2)+cost*dc_norm(:,i-1))*
     &                    vbld_inv(i)
c        if (itype(i-1).ne.ntyp1)
        dtheta(:,2,i)=-dcostheta(:,2,i)*sint_inv
      enddo

c Derivatives of phi:
c If phi is 0 or 180 degrees, then the formulas
c have to be derived by power series expansion of the
c conventional formulas around 0 and 180.
!$OMP PARALLEL DO SIMD DEFAULT(SHARED)
!$OMP& PRIVATE(j,sint,sint1,sing,cost,cost1,cosg,vp1,vp2,vp3,mult,
!$OMP&         dtri,ctgt,ctgt1,fac0,fac1,fac2,fac3,fac4,fac13,fac24,
!$OMP&         scalp)
#ifdef PARINTDER
      do i=iphi1_start,iphi1_end
#else
      do i=4,nres
#endif
c        if (itype(i-2).eq.ntyp1.or. itype(i-1).eq.ntyp1
c     &      .or. itype(i).eq.ntyp1 .or. itype(i-3).eq.ntyp1) cycle
c the conventional case
        sint=sin_theta(i)
        sint1=sin_theta(i-1)
        !sint=dsin(theta(i))
        !sint1=dsin(theta(i-1))
        sing=dsin(phi(i))
        cost=cos_theta(i)
        cost1=cos_theta(i-1)
        !cost=dcos(theta(i))
        !cost1=dcos(theta(i-1))
        cosg=dcos(phi(i))
        fac0=1.0d0/(sint1*sint)
c    Obtaining the gamma derivatives from sine derivative                                
c       if (itype(i-1).ne.ntyp1 .and. itype(i-2).ne.ntyp1) then
        if (phi(i).gt.-pi4.and.phi(i).le.pi4.or.
     &     phi(i).gt.pi34.and.phi(i).le.pi.or.
     &     phi(i).ge.-pi.and.phi(i).le.-pi34) then
          call vecpr(dc_norm(1,i-1),dc_norm(1,i-2),vp1)
          call vecpr(dc_norm(1,i-3),dc_norm(1,i-1),vp2)
          call vecpr(dc_norm(1,i-3),dc_norm(1,i-2),vp3) 
          ctgt=cost/sint
          ctgt1=cost1/sint1
          mult=1.0d0/cosg
          dtri(:,1)=-sing*ctgt1*dtheta(:,1,i-1)
     &                -(fac0*vp1(:)+sing*dc_norm(:,i-3))*vbld_inv(i-2)
          dtri(:,2)=
     &                -sing*(ctgt1*dtheta(:,2,i-1)+ctgt*dtheta(:,1,i))
     &                -(fac0*vp2(:)+sing*dc_norm(:,i-2))*vbld_inv(i-1)
          dtri(:,3)=-sing*ctgt*dtheta(:,2,i)
     &                +(fac0*vp3(:)-sing*dc_norm(:,i-1))*vbld_inv(i)
c    &                +(fac0*vp3(:)-sing*dc_norm(:,i-1))*vbld_inv(i-1)
c Bug fixed 3/24/05 (AL)
c   Obtaining the gamma derivatives from cosine derivative
        else
          mult=-1.0d0/sing
          if(dabs(mult).gt.1e20) mult=sign(1e20,-sing)
          scalp=scalar(dc_norm(1,i-3),dc_norm(1,i-1))
          fac1=cost*fac0
          fac2=cost1*fac0
          fac3=cosg*cost1/(sint1*sint1)
          fac4=cosg*cost/(sint*sint)
          fac13=fac1+fac3
          fac24=fac2+fac4
          do j=1,3
            dtri(j,1)=fac13*dcostheta(j,1,i-1)
     &                  -fac0*(dc_norm(j,i-1)-scalp*dc_norm(j,i-3))
     &                       *vbld_inv(i-2)
            dtri(j,2)=fac13*dcostheta(j,2,i-1)
     &                  +fac24*dcostheta(j,1,i)
            dtri(j,3)=fac24*dcostheta(j,2,i)
     &                  -fac0*(dc_norm(j,i-3)-scalp*dc_norm(j,i-1))
     &                       *vbld_inv(i)
          enddo
        endif
        dphi(:,:,i)=mult*dtri(:,:)
      enddo

Calculate derivative of Tauangle

#if defined(MPI) && defined(PARINTDER)
c We need dtheta(:,:,i-1) to compute dphi(:,:,i)
      range_lo=max0(ithet_start-1,3)
      range_hi=ithet_end
      range_lo=min0(range_lo,itau_start)
      range_hi=max0(range_hi,itau_end)
#else
      range_lo=3
      range_hi=nres
#endif
#ifdef _OPENMP
      threads_used=omp_get_max_threads()
#else
      threads_used=1
#endif
!$OMP PARALLEL DEFAULT(SHARED)
!$OMP& PRIVATE(cost2,sint2,sint1_inv,sint2_inv,
!$OMP&         my_thread,from,to,
!$OMP&         i,j,sint,sint1,sing,cost,cost1,cosg,vp1,vp2,vp3,mult,
!$OMP&         dtri,ctgt,ctgt1,fac0,fac1,fac2,fac3,fac4,fac13,fac24,
!$OMP&         scalp,tdcosomicron,tdcosomicronp,tdomicron,tdomicronp)
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif

      !from=range_lo+((range_hi-range_lo)/threads_used)*(my_thread-1)
      !to=range_lo+((range_hi-range_lo)/threads_used)*my_thread-1
      !if(my_thread.eq.threads_used) to=range_hi
      call split_work_for_threads(from,to,range_lo,range_hi,
     &                            my_thread,threads_used)

      if(from.eq.range_lo) then
        tdcosomicronp=0.0d0
        tdomicronp=0.0d0
      else
        i=from-1
        cost1=cos_omicron(1,i)
        sint1=sin_omicron(1,i)
        !cost1=dcos(omicron(1,i))
        !sint1=sqrt(1-cost1*cost1)
        cost2=cos_omicron(2,i)
        sint2=sin_omicron(2,i)
        !cost2=dcos(omicron(2,i))
        !sint2=sqrt(1-cost2*cost2)
        sint1_inv=-1.0d0/sint1
        sint2_inv=-1.0d0/sint2
        tdcosomicronp(:,1,1)=-(dc_norm(:,i-1+nres)+
     &                   cost1*dc_norm(:,i-2))*vbld_inv(i-1)
        tdomicronp(:,1,1)=sint1_inv*tdcosomicronp(:,1,1)
        tdcosomicronp(:,1,2)=-(dc_norm(:,i-2)
     &                +cost1*(dc_norm(:,i-1+nres)))*vbld_inv(i-1+nres)
        tdomicronp(:,1,2)=sint1_inv*tdcosomicronp(:,1,2)
        tdcosomicronp(:,2,1)=-(-dc_norm(:,i-1+nres)
     &                      +cost2*dc_norm(:,i-1))*vbld_inv(i)
        tdomicronp(:,2,1)=sint2_inv*tdcosomicronp(:,2,1)
        tdcosomicronp(:,2,2)=
     &             -(dc_norm(:,i-1)+cost2*(-dc_norm(:,i-1+nres)))
     &              *vbld_inv(i-1+nres)
        tdomicronp(:,2,2)=sint2_inv*tdcosomicronp(:,2,2)
      endif

      do i=from,to

        !if ((itype(i-1).eq.10).or.(itype(i-1).eq.ntyp1)) cycle
        if ((itype(i-1).ne.10).and.(itype(i-1).ne.ntyp1)) then
          cost1=cos_omicron(1,i)
          sint1=sin_omicron(1,i)
          cost2=cos_omicron(2,i)
          sint2=sin_omicron(2,i)
          sint1_inv=-1.0d0/sint1
          sint2_inv=-1.0d0/sint2
CC Calculate derivative over first omicron (Cai-2,Cai-1,SCi-1) 
          tdcosomicron(:,1,1)=-(dc_norm(:,i-1+nres)+
     &                     cost1*dc_norm(:,i-2))*vbld_inv(i-1)
          tdomicron(:,1,1)=sint1_inv*tdcosomicron(:,1,1)
          tdcosomicron(:,1,2)=-(dc_norm(:,i-2)
     &                  +cost1*(dc_norm(:,i-1+nres)))*vbld_inv(i-1+nres)
          tdomicron(:,1,2)=sint1_inv*tdcosomicron(:,1,2)
CC Calculate derivative over second omicron Sci-1,Cai-1 Cai
          tdcosomicron(:,2,1)=-(-dc_norm(:,i-1+nres)
     &                        +cost2*dc_norm(:,i-1))*vbld_inv(i)
          tdomicron(:,2,1)=sint2_inv*tdcosomicron(:,2,1)
          tdcosomicron(:,2,2)=
     &               -(dc_norm(:,i-1)+cost2*(-dc_norm(:,i-1+nres)))
     &                *vbld_inv(i-1+nres)
          tdomicron(:,2,2)=sint2_inv*tdcosomicron(:,2,2)
        endif

        if ((itype(i-2).ne.ntyp1).and.(itype(i-2).ne.10)) then
c       if ((itype(i-2).eq.ntyp1).or.(itype(i-2).eq.10).or.
c     &     (itype(i-1).eq.ntyp1).or.(itype(i).eq.ntyp1)) cycle
cc dtauangle(j,intertyp,dervityp,residue number)
cc INTERTYP=1 SC...Ca...Ca..Ca
c the conventional case
          !sint=dsin(theta(i))
          !sint1=dsin(omicron(2,i-1))
          sint=sin_theta(i)
          sint1=sin_omicron(2,i-1)
          !sing=dsin(tauangle(1,i))
          sing=sin_tauangle1(i)
          !cost=dcos(theta(i))
          !cost1=dcos(omicron(2,i-1))
          cost=cos_theta(i)
          cost1=cos_omicron(2,i-1)
          !cosg=dcos(tauangle(1,i))
          cosg=cos_tauangle1(i)
          fac0=1.0d0/(sint1*sint)
c    Obtaining the gamma derivatives from sine derivative                                
!         if (tauangle(1,i).gt.-pi4.and.tauangle(1,i).le.pi4.or.
!    &       tauangle(1,i).gt.pi34.and.tauangle(1,i).le.pi.or.
!    &       tauangle(1,i).ge.-pi.and.tauangle(1,i).le.-pi34) then
          if (dabs(cosg).gt.half_sqrt2) then
            call vecpr(dc_norm(1,i-1),dc_norm(1,i-2),vp1)
            call vecpr(dc_norm(1,i-1),dc_norm(1,i-2+nres),vp2)    ! (-a x b) = b x a
            call vecpr(dc_norm(1,i-2),dc_norm(1,i-2+nres),vp3)
            ctgt=cost/sint
            ctgt1=cost1/sint1
            mult=1.0d0/cosg
            do j=1,3
              dtri(j,1)=-sing*ctgt1*tdomicronp(j,2,2)
     &                        -(fac0*vp1(j)-sing*(dc_norm(j,i-2+nres)))
     &                         *vbld_inv(i-2+nres)
              dtri(j,2)=
     &              -sing*(ctgt1*tdomicronp(j,2,1)+ctgt*dtheta(j,1,i))
     &              -(fac0*vp2(j)+sing*dc_norm(j,i-2))*vbld_inv(i-1)
              dtri(j,3)=-sing*ctgt*dtheta(j,2,i)
     &                    +(fac0*vp3(j)-sing*dc_norm(j,i-1))*vbld_inv(i)
            enddo
c   Obtaining the gamma derivatives from cosine derivative
          else
            mult=-1.0d0/sing
            if(dabs(mult).gt.1e20) mult=sign(1e20,-sing)
            scalp=-scalar(dc_norm(1,i-2+nres),dc_norm(1,i-1))
            fac1=cost*fac0
            fac2=cost1*fac0
            fac3=cosg*cost1/(sint1*sint1)
            fac4=cosg*cost/(sint*sint)
            fac13=fac1+fac3
            fac24=fac2+fac4
            do j=1,3
              dtri(j,1)=fac13*tdcosomicronp(j,2,2)
     &               -fac0*(dc_norm(j,i-1)+scalp*dc_norm(j,i-2+nres))
     &                    *vbld_inv(i-2+nres)
              dtri(j,2)=fac13*tdcosomicronp(j,2,1)
     &                 +fac24*dcostheta(j,1,i)
              dtri(j,3)=fac24*dcostheta(j,2,i)
     &               -fac0*(-dc_norm(j,i-2+nres)-scalp*dc_norm(j,i-1))
     &                    *vbld_inv(i)
            enddo
          endif
          dtauangle(:,1,1,i)=mult*dtri(:,1)
          dtauangle(:,1,2,i)=mult*dtri(:,2)
          dtauangle(:,1,3,i)=mult*dtri(:,3)
        endif

CC Second case Ca...Ca...Ca...SC
        if (i.gt.3) then
          if ((itype(i-1).ne.ntyp1).and.(itype(i-1).ne.10).and.
     &        (itype(i-2).ne.ntyp1).and.(itype(i-3).ne.ntyp1)) then
c the conventional case
            !sint=dsin(omicron(1,i))
            !sint1=dsin(theta(i-1))
            sint=sin_omicron(1,i)
            sint1=sin_theta(i-1)
            !sing=dsin(tauangle(2,i))
            sing=sin_tauangle2(i)
            !cost=dcos(omicron(1,i))
            !cost1=dcos(theta(i-1))
            cost=cos_omicron(1,i)
            cost1=cos_theta(i-1)
            !cosg=dcos(tauangle(2,i))
            cosg=cos_tauangle2(i)
            fac0=1.0d0/(sint1*sint)
!           if (tauangle(2,i).gt.-pi4.and.tauangle(2,i).le.pi4.or.
!    &         tauangle(2,i).gt.pi34.and.tauangle(2,i).le.pi.or.
!    &         tauangle(2,i).gt.-pi.and.tauangle(2,i).le.-pi34) then
            if (dabs(cosg).gt.half_sqrt2) then

              call vecpr(dc_norm(1,i-2),dc_norm(1,i-1+nres),vp1)
              call vecpr(dc_norm(1,i-3),dc_norm(1,i-1+nres),vp2)
              call vecpr(dc_norm(1,i-3),dc_norm(1,i-2),vp3)
              ctgt=cost/sint
              ctgt1=cost1/sint1
              mult=1.0d0/cosg
              do j=1,3
                dtri(j,1)=-sing*ctgt1*dtheta(j,1,i-1)
     &            +(fac0*vp1(j)-sing*dc_norm(j,i-3))*vbld_inv(i-2)
                dtri(j,2)=
     &            -sing*(ctgt1*dtheta(j,2,i-1)+ctgt*tdomicron(j,1,1))
     &            -(fac0*vp2(j)+sing*dc_norm(j,i-2))*vbld_inv(i-1)
                dtri(j,3)=-sing*ctgt*tdomicron(j,1,2)
     &                    +(fac0*vp3(j)-sing*dc_norm(j,i-1+nres))
     &                     *vbld_inv(i-1+nres)
              enddo
c   Obtaining the gamma derivatives from cosine derivative
            else
              mult=-1.0d0/sing
              if(dabs(mult).gt.1e20) mult=sign(1e20,-sing)
              scalp=scalar(dc_norm(1,i-3),dc_norm(1,i-1+nres))
              fac1=cost*fac0
              fac2=cost1*fac0
              fac3=cosg*cost1/(sint1*sint1)
              fac4=cosg*cost/(sint*sint)
              fac13=fac1+fac3
              fac24=fac2+fac4
              do j=1,3
                dtri(j,1)=fac13*dcostheta(j,1,i-1)
     &                  -fac0*(dc_norm(j,i-1+nres)-scalp*dc_norm(j,i-3))
     &                        *vbld_inv(i-2)
                dtri(j,2)=fac13*dcostheta(j,2,i-1)
     &                   +fac24*tdcosomicron(j,1,1)
                dtri(j,3)=fac24*tdcosomicron(j,1,2)
     &                  -fac0*(dc_norm(j,i-3)-scalp*dc_norm(j,i-1+nres))
     &                        *vbld_inv(i-1+nres)
              enddo
            endif                                    
            dtauangle(:,2,1,i)=mult*dtri(:,1)
            dtauangle(:,2,2,i)=mult*dtri(:,2)
            dtauangle(:,2,3,i)=mult*dtri(:,3)
          endif
        endif
!     enddo

CCC third case SC...Ca...Ca...SC
c the conventional case
        if ((itype(i-1).ne.ntyp1).and.(itype(i-1).ne.10) .and.
     &      (itype(i-2).ne.ntyp1).and.(itype(i-2).ne.10)) then
          !sint=dsin(omicron(1,i))
          !sint1=dsin(omicron(2,i-1))
          sint=sin_omicron(1,i)
          sint1=sin_omicron(2,i-1)
          !sing=dsin(tauangle(3,i))
          sing=sin_tauangle3(i)
          !cost=dcos(omicron(1,i))
          !cost1=dcos(omicron(2,i-1))
          cost=cos_omicron(1,i)
          cost1=cos_omicron(2,i-1)
          !cosg=dcos(tauangle(3,i))
          cosg=cos_tauangle3(i)
          fac0=1.0d0/(sint1*sint)
!         if (tauangle(3,i).gt.-pi4.and.tauangle(3,i).le.pi4.or.
!    &       tauangle(3,i).gt.pi34.and.tauangle(3,i).le.pi.or.
!    &       tauangle(3,i).ge.-pi.and.tauangle(3,i).le.-pi34) then
          if (dabs(cosg).gt.half_sqrt2) then

            call vecpr(dc_norm(1,i-1+nres),dc_norm(1,i-2),vp1)
            call vecpr(dc_norm(1,i-1+nres),dc_norm(1,i-2+nres),vp2)
            call vecpr(dc_norm(1,i-2),dc_norm(1,i-2+nres),vp3)
            ctgt=cost/sint
            ctgt1=cost1/sint1
            mult=1.0d0/cosg
            do j=1,3
              dtri(j,1)=-sing*ctgt1*tdomicronp(j,2,2)
     &        -(fac0*vp1(j)-sing*dc_norm(j,i-2+nres))*vbld_inv(i-2+nres)
              dtri(j,2)=
     &          -sing*(ctgt1*tdomicronp(j,2,1)+ctgt*tdomicron(j,1,1))
     &          -(fac0*vp2(j)+sing*dc_norm(j,i-2))*vbld_inv(i-1)
              dtri(j,3)=-sing*ctgt*tdomicron(j,1,2)
     &        +(fac0*vp3(j)-sing*dc_norm(j,i-1+nres))*vbld_inv(i-1+nres)
            enddo
c   Obtaining the gamma derivatives from cosine derivative
          else
            mult=-1.0d0/sing
            if(dabs(mult).gt.1e20) mult=sign(1e20,-sing)
            scalp=-scalar(dc_norm(1,i-2+nres),dc_norm(1,i-1+nres))
            fac1=cost*fac0
            fac2=cost1*fac0
            fac3=cosg*cost1/(sint1*sint1)
            fac4=cosg*cost/(sint*sint)
            fac13=fac1+fac3
            fac24=fac2+fac4
            do j=1,3
              dtri(j,1)=fac13*tdcosomicronp(j,2,2)
     &             -fac0*(dc_norm(j,i-1+nres)+scalp*dc_norm(j,i-2+nres))
     &                   *vbld_inv(i-2+nres)
              dtri(j,2)=fac13*tdcosomicronp(j,2,1)
     &                 +fac24*tdcosomicron(j,1,1)
              dtri(j,3)=fac24*tdcosomicron(j,1,2)
     &             +fac0*(dc_norm(j,i-2+nres)+scalp*dc_norm(j,i-1+nres))
     &                   *vbld_inv(i-1+nres)
            enddo
          endif
          dtauangle(:,3,1,i)=mult*dtri(:,1)
          dtauangle(:,3,2,i)=mult*dtri(:,2)
          dtauangle(:,3,3,i)=mult*dtri(:,3)
        endif
        tdcosomicronp=tdcosomicron
        tdomicronp=tdomicron
      enddo
!$OMP END PARALLEL

#ifdef CRYST_SC
c   Derivatives of side-chain angles alpha and omega
#if defined(MPI) && defined(PARINTDER)
        do i=ibond_start,ibond_end
#else
        do i=2,nres-1
#endif
          if(itype(i).ne.10 .and. itype(i).ne.ntyp1) then
             !fac5=1.0d0/dsqrt(2*(1+dcos(theta(i+1))))
             fac5=1.0d0/dsqrt(2*(1+cos_theta(i+1)))
             fac6=fac5/vbld(i)
             fac7=fac5*fac5
             fac8=fac5/vbld(i+1)
             fac9=fac5/vbld(i+nres)
             scala1=scalar(dc_norm(1,i-1),dc_norm(1,i+nres))
             scala2=scalar(dc_norm(1,i),dc_norm(1,i+nres))
             !cosa=dsqrt(0.5d0/(1.0d0+dcos(theta(i+1))))*(
             cosa=dsqrt(0.5d0/(1.0d0+cos_theta(i+1)))*(
     &                   scalar(dC_norm(1,i),dC_norm(1,i+nres))
     &                  -scalar(dC_norm(1,i-1),dC_norm(1,i+nres)))
             sina=sqrt(1-cosa*cosa)
             sino=dsin(omeg(i))
c             write (iout,*) "i",i," cosa",cosa," sina",sina," sino",sino
             do j=1,3
                dcosalpha(j,1)=fac6*(scala1*dc_norm(j,i-1)-
     &          dc_norm(j,i+nres))-cosa*fac7*dcostheta(j,1,i+1)
                dalpha(j,1,i)=-1/sina*dcosalpha(j,1)
                dcosalpha(j,2)=fac8*(dc_norm(j,i+nres)-
     &          scala2*dc_norm(j,i))-cosa*fac7*dcostheta(j,2,i+1)
                dalpha(j,2,i)=-1/sina*dcosalpha(j,2)
                dcosalpha(j,3)=(fac9*(dc_norm(j,i)-
     &          dc_norm(j,i-1))-(cosa*dc_norm(j,i+nres))/
     &          vbld(i+nres))
                dalpha(j,3,i)=-1/sina*dcosalpha(j,3)
            enddo
c obtaining the derivatives of omega from sines
            if(omeg(i).gt.-pi4.and.omeg(i).le.pi4.or.
     &         omeg(i).gt.pi34.and.omeg(i).le.pi.or.
     &         omeg(i).ge.-pi.and.omeg(i).le.-pi34) then
!              fac15=dcos(theta(i+1))/(dsin(theta(i+1))*
!    &         dsin(theta(i+1)))
               fac15=cos_theta(i+1)/(sin_theta(i+1)*
     &         sin_theta(i+1))
               fac16=dcos(alph(i))/(dsin(alph(i))*dsin(alph(i)))
               !fac17=1.0d0/(dsin(theta(i+1))*dsin(alph(i)))
               fac17=1.0d0/(sin_theta(i+1)*dsin(alph(i)))             
               call vecpr(dc_norm(1,i+nres),dc_norm(1,i),vo1)
               call vecpr(dc_norm(1,i+nres),dc_norm(1,i-1),vo2)
               call vecpr(dc_norm(1,i),dc_norm(1,i-1),vo3)
               coso_inv=1.0d0/dcos(omeg(i))
               do j=1,3
                 dsinomega(j,1)=sino*(fac15*dcostheta(j,1,i+1)
     &           +fac16*dcosalpha(j,1))-fac17/vbld(i)*vo1(j)-(
     &           sino*dc_norm(j,i-1))/vbld(i)
                 domega(j,1,i)=coso_inv*dsinomega(j,1)
                 dsinomega(j,2)=sino*(fac15*dcostheta(j,2,i+1)
     &           +fac16*dcosalpha(j,2))+fac17/vbld(i+1)*vo2(j)
     &           -sino*dc_norm(j,i)/vbld(i+1)
                 domega(j,2,i)=coso_inv*dsinomega(j,2)
                 dsinomega(j,3)=sino*fac16*dcosalpha(j,3)-
     &           fac17/vbld(i+nres)*vo3(j)-sino*dc_norm(j,i+nres)/
     &           vbld(i+nres)
                 domega(j,3,i)=coso_inv*dsinomega(j,3)
              enddo
           else
c   obtaining the derivatives of omega from cosines
             !fac10=sqrt(0.5d0*(1-dcos(theta(i+1))))
             fac10=sqrt(0.5d0*(1-cos_theta(i+1)))
             !fac11=sqrt(0.5d0*(1+dcos(theta(i+1))))
             fac11=sqrt(0.5d0*(1+cos_theta(i+1)))
             fac12=fac10*sina
             fac13=fac12*fac12
             fac14=sina*sina
             do j=1,3
                dcosomega(j,1)=(-(0.25d0*cosa/fac11*
     &          dcostheta(j,1,i+1)+fac11*dcosalpha(j,1))*fac12+
     &          (0.25d0/fac10*sina*dcostheta(j,1,i+1)+cosa/sina*
     &          fac10*dcosalpha(j,1))*(scala2-fac11*cosa))/fac13
                domega(j,1,i)=-1/sino*dcosomega(j,1)
                dcosomega(j,2)=(((dc_norm(j,i+nres)-scala2*
     &          dc_norm(j,i))/vbld(i+1)-0.25d0*cosa/fac11*
     &          dcostheta(j,2,i+1)-fac11*dcosalpha(j,2))*fac12+
     &          (scala2-fac11*cosa)*(0.25d0*sina/fac10*
     &          dcostheta(j,2,i+1)+fac10*cosa/sina*dcosalpha(j,2)
     &          ))/fac13
                domega(j,2,i)=-1/sino*dcosomega(j,2)
                dcosomega(j,3)=1/fac10*((1/vbld(i+nres)*(dc_norm(j,i)-
     &          scala2*dc_norm(j,i+nres))-fac11*dcosalpha(j,3))*sina+
     &          (scala2-fac11*cosa)*(cosa/sina*dcosalpha(j,3)))/fac14
                domega(j,3,i)=-1/sino*dcosomega(j,3)
            enddo
          endif
         else
           do j=1,3
             do k=1,3
               dalpha(k,j,i)=0.0d0
               domega(k,j,i)=0.0d0
             enddo
           enddo
         endif
       enddo
#endif

#if defined(MPI) && defined(PARINTDER)
      if (nfgtasks.gt.1) then
#ifdef DEBUG
cd      write (iout,*) "Gather dtheta"
cd      call flush(iout)
      write (iout,*) "dtheta before gather"
      do i=1,nres
        write (iout,'(i3,3(3f8.5,3x))') i,((dtheta(j,k,i),k=1,3),j=1,2)
      enddo
#endif
      call MPI_Gatherv(dtheta(1,1,ithet_start),ithet_count(fg_rank),
     &  MPI_THET,dtheta(1,1,1),ithet_count(0),ithet_displ(0),MPI_THET,
     &  king,FG_COMM,IERROR)
#ifdef DEBUG
cd      write (iout,*) "Gather dphi"
cd      call flush(iout)
      write (iout,*) "dphi before gather"
      do i=1,nres
        write (iout,'(i3,3(3f8.5,3x))') i,((dphi(j,k,i),k=1,3),j=1,3)
      enddo
#endif
      call MPI_Gatherv(dphi(1,1,iphi1_start),iphi1_count(fg_rank),
     &  MPI_GAM,dphi(1,1,1),iphi1_count(0),iphi1_displ(0),MPI_GAM,
     &  king,FG_COMM,IERROR)
cd      write (iout,*) "Gather dalpha"
cd      call flush(iout)
#ifdef CRYST_SC
      call MPI_Gatherv(dalpha(1,1,ibond_start),ibond_count(fg_rank),
     &  MPI_GAM,dalpha(1,1,1),ibond_count(0),ibond_displ(0),MPI_GAM,
     &  king,FG_COMM,IERROR)
cd      write (iout,*) "Gather domega"
cd      call flush(iout)
      call MPI_Gatherv(domega(1,1,ibond_start),ibond_count(fg_rank),
     &  MPI_GAM,domega(1,1,1),ibond_count(0),ibond_displ(0),MPI_GAM,
     &  king,FG_COMM,IERROR)
#endif
      endif
#endif
#ifdef DEBUG
      write (iout,*) "dtheta after gather"
      do i=1,nres
        write (iout,'(i3,3(3f8.5,3x))') i,((dtheta(j,k,i),j=1,3),k=1,2)
      enddo
      write (iout,*) "dphi after gather"
      do i=1,nres
        write (iout,'(i3,3(3f8.5,3x))') i,((dphi(j,k,i),j=1,3),k=1,3)
      enddo
      write (iout,*) "dalpha after gather"
      do i=1,nres
        write (iout,'(i3,3(3f8.5,3x))') i,((dalpha(j,k,i),j=1,3),k=1,3)
      enddo
      write (iout,*) "domega after gather"
      do i=1,nres
        write (iout,'(i3,3(3f8.5,3x))') i,((domega(j,k,i),j=1,3),k=1,3)
      enddo
      write (iout,*) "dtauangle after gather"
      do i=1,nres
        write (iout,'(i3,3(3f8.5,3x))') i,
     &         (((dtauangle(j,k,l,i),j=1,3),k=1,3),l=1,3)
      enddo
#endif
      return
      end

c------------------------------------------------------------
      subroutine checkintcartgrad
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.IOUNITS'
      include 'COMMON.SETUP'
      double precision dthetanum(3,2,maxres),dphinum(3,3,maxres)
     & ,dalphanum(3,3,maxres), domeganum(3,3,maxres)
      double precision theta_s(maxres),phi_s(maxres),alph_s(maxres),
     & omeg_s(maxres),dc_norm_s(3)
      double precision aincr /1.0d-5/
      common /checkintcartgradcommon/ dthetanum,dphinum,
     &                                dalphanum,domeganum,
     &                                theta_s,phi_s,alph_s

      do i=1,nres
        phi_s(i)=phi(i)
        theta_s(i)=theta(i)
        alph_s(i)=alph(i)
        omeg_s(i)=omeg(i)
      enddo
c Check theta gradient
      write (iout,*)
     & "Analytical (upper) and numerical (lower) gradient of theta"
      write (iout,*)
      do i=3,nres
        do j=1,3
          dcji=dc(j,i-2)
          dc(j,i-2)=dcji+aincr
          call chainbuild_cart
          call int_from_cart1(.false.)
          dthetanum(j,1,i)=(theta(i)-theta_s(i))/aincr
          dc(j,i-2)=dcji
          dcji=dc(j,i-1)
          dc(j,i-1)=dc(j,i-1)+aincr
          call chainbuild_cart
          dthetanum(j,2,i)=(theta(i)-theta_s(i))/aincr
          dc(j,i-1)=dcji
        enddo
        write (iout,'(i5,3f10.5,5x,3f10.5)') i,(dtheta(j,1,i),j=1,3),
     &    (dtheta(j,2,i),j=1,3)
        write (iout,'(5x,3f10.5,5x,3f10.5)') (dthetanum(j,1,i),j=1,3),
     &    (dthetanum(j,2,i),j=1,3)
        write (iout,'(5x,3f10.5,5x,3f10.5)')
     &    (dthetanum(j,1,i)/dtheta(j,1,i),j=1,3),
     &    (dthetanum(j,2,i)/dtheta(j,2,i),j=1,3)
        write (iout,*)
      enddo
c Check gamma gradient
      write (iout,*)
     & "Analytical (upper) and numerical (lower) gradient of gamma"
      do i=4,nres
        do j=1,3
          dcji=dc(j,i-3)
          dc(j,i-3)=dcji+aincr
          call chainbuild_cart
          dphinum(j,1,i)=(phi(i)-phi_s(i))/aincr
          dc(j,i-3)=dcji
          dcji=dc(j,i-2)
          dc(j,i-2)=dcji+aincr
          call chainbuild_cart
          dphinum(j,2,i)=(phi(i)-phi_s(i))/aincr
          dc(j,i-2)=dcji
          dcji=dc(j,i-1)
          dc(j,i-1)=dc(j,i-1)+aincr
          call chainbuild_cart
          dphinum(j,3,i)=(phi(i)-phi_s(i))/aincr
          dc(j,i-1)=dcji
        enddo
        write (iout,'(i5,3(3f10.5,5x))') i,(dphi(j,1,i),j=1,3),
     &    (dphi(j,2,i),j=1,3),(dphi(j,3,i),j=1,3)
        write (iout,'(5x,3(3f10.5,5x))') (dphinum(j,1,i),j=1,3),
     &    (dphinum(j,2,i),j=1,3),(dphinum(j,3,i),j=1,3)
        write (iout,'(5x,3(3f10.5,5x))')
     &    (dphinum(j,1,i)/dphi(j,1,i),j=1,3),
     &    (dphinum(j,2,i)/dphi(j,2,i),j=1,3),
     &    (dphinum(j,3,i)/dphi(j,3,i),j=1,3)
        write (iout,*)
      enddo
c Check alpha gradient
      write (iout,*)
     & "Analytical (upper) and numerical (lower) gradient of alpha"
      do i=2,nres-1
       if(itype(i).ne.10) then
            do j=1,3
              dcji=dc(j,i-1)
              dc(j,i-1)=dcji+aincr
              call chainbuild_cart
              dalphanum(j,1,i)=(alph(i)-alph_s(i))
     &        /aincr
              dc(j,i-1)=dcji
              dcji=dc(j,i)
              dc(j,i)=dcji+aincr
              call chainbuild_cart
              dalphanum(j,2,i)=(alph(i)-alph_s(i))
     &        /aincr
              dc(j,i)=dcji
              dcji=dc(j,i+nres)
              dc(j,i+nres)=dc(j,i+nres)+aincr
              call chainbuild_cart
              dalphanum(j,3,i)=(alph(i)-alph_s(i))
     &        /aincr
             dc(j,i+nres)=dcji
            enddo
          endif
        write (iout,'(i5,3(3f10.5,5x))') i,(dalpha(j,1,i),j=1,3),
     &    (dalpha(j,2,i),j=1,3),(dalpha(j,3,i),j=1,3)
        write (iout,'(5x,3(3f10.5,5x))') (dalphanum(j,1,i),j=1,3),
     &    (dalphanum(j,2,i),j=1,3),(dalphanum(j,3,i),j=1,3)
        write (iout,'(5x,3(3f10.5,5x))')
     &    (dalphanum(j,1,i)/dalpha(j,1,i),j=1,3),
     &    (dalphanum(j,2,i)/dalpha(j,2,i),j=1,3),
     &    (dalphanum(j,3,i)/dalpha(j,3,i),j=1,3)
        write (iout,*)
      enddo
c     Check omega gradient
      write (iout,*)
     & "Analytical (upper) and numerical (lower) gradient of omega"
      do i=2,nres-1
       if(itype(i).ne.10) then
            do j=1,3
              dcji=dc(j,i-1)
              dc(j,i-1)=dcji+aincr
              call chainbuild_cart
              domeganum(j,1,i)=(omeg(i)-omeg_s(i))
     &        /aincr
              dc(j,i-1)=dcji
              dcji=dc(j,i)
              dc(j,i)=dcji+aincr
              call chainbuild_cart
              domeganum(j,2,i)=(omeg(i)-omeg_s(i))
     &        /aincr
              dc(j,i)=dcji
              dcji=dc(j,i+nres)
              dc(j,i+nres)=dc(j,i+nres)+aincr
              call chainbuild_cart
              domeganum(j,3,i)=(omeg(i)-omeg_s(i))
     &        /aincr
             dc(j,i+nres)=dcji
            enddo
          endif
        write (iout,'(i5,3(3f10.5,5x))') i,(domega(j,1,i),j=1,3),
     &    (domega(j,2,i),j=1,3),(domega(j,3,i),j=1,3)
        write (iout,'(5x,3(3f10.5,5x))') (domeganum(j,1,i),j=1,3),
     &    (domeganum(j,2,i),j=1,3),(domeganum(j,3,i),j=1,3)
        write (iout,'(5x,3(3f10.5,5x))')
     &    (domeganum(j,1,i)/domega(j,1,i),j=1,3),
     &    (domeganum(j,2,i)/domega(j,2,i),j=1,3),
     &    (domeganum(j,3,i)/domega(j,3,i),j=1,3)
        write (iout,*)
      enddo
      return
      end

c------------------------------------------------------------
      subroutine chainbuild_cart
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.SETUP'
      include 'COMMON.CHAIN'
      include 'COMMON.LOCAL'
      include 'COMMON.TIME1'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.TORCNSTR'
      include 'COMMON.QRESTR'
      include 'COMMON.NMR'
#ifdef MPI
      if (nfgtasks.gt.1) then
c        write (iout,*) "BCAST in chainbuild_cart"
c        call flush(iout)
c Broadcast the order to build the chain and compute internal coordinates
c to the slaves. The slaves receive the order in ERGASTULUM.
        time00=MPI_Wtime()
c      write (iout,*) "CHAINBUILD_CART: DC before BCAST"
c      do i=0,nres
c        write (iout,'(i3,3f10.5,5x,3f10.5)') i,(dc(j,i),j=1,3),
c     &   (dc(j,i+nres),j=1,3)
c      enddo
        if (fg_rank.eq.0)
     &    call MPI_Bcast(7,1,MPI_INTEGER,king,FG_COMM,IERROR)
        time_bcast7=time_bcast7+MPI_Wtime()-time00
        time01=MPI_Wtime()
        call MPI_Bcast(dc(1,0),6*(nres+1),MPI_DOUBLE_PRECISION,
     &    king,FG_COMM,IERR)
c      write (iout,*) "CHAINBUILD_CART: DC after BCAST"
c      do i=0,nres
c        write (iout,'(i3,3f10.5,5x,3f10.5)') i,(dc(j,i),j=1,3),
c     &   (dc(j,i+nres),j=1,3)
c      enddo
c        write (iout,*) "End BCAST in chainbuild_cart"
c        call flush(iout)
        time_bcast=time_bcast+MPI_Wtime()-time00
        time_bcastc=time_bcastc+MPI_Wtime()-time01
      endif
#endif
      do j=1,3
        c(j,1)=dc(j,0)
c        c(j,1)=c(j,1)
      enddo
!TODO: PREFIX SUMS
      do i=2,nres
        do j=1,3
          c(j,i)=c(j,i-1)+dc(j,i-1)
        enddo
      enddo
!$OMP PARALLEL DO DEFAULT(SHARED) PRIVATE(j)
      do i=1,nres
        do j=1,3
          c(j,i+nres)=c(j,i)+dc(j,i+nres)
        enddo
      enddo
C      print *,'tutu'
c      write (iout,*) "CHAINBUILD_CART"
c      call cartprint
      if (ndih_constr.gt.0 .or. ntheta_constr.gt.0
     &  .or.  constr_homology.gt.0 .or. nfrag_back.gt.0 .or. npeak.gt.0)
     &  then
        call int_from_cart1(.false.)
      else
        call calc_bondvec
      endif
      return
      end
