#ifndef LBFGS
      subroutine gradient(n,x,nf,g,uiparm,urparm,ufparm)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.IOUNITS'
      integer n,nf
      double precision ufparm
      external ufparm
      integer uiparm(1)
      double precision urparm(1)
      double precision x(n),g(n)
      integer i,j,k,ind,ind1
      double precision f,gthetai,gphii,galphai,gomegai
c
c This subroutine calculates total internal coordinate gradient.
c Depending on the number of function evaluations, either whole energy
c is evaluated beforehand, Cartesian coordinates and their derivatives in
c internal coordinates are reevaluated or only the cartesian-in-internal
c coordinate derivatives are evaluated. The subroutine was designed to work
c with SUMSL.
c
c
      icg=mod(nf,2)+1

cd      print *,'grad',nf,icg
      if (nf-nfl+1) 20,30,40
   20 call func(n,x,nf,f,uiparm,urparm,ufparm)
c     write (iout,*) 'grad 20'
      if (nf.eq.0) return
      goto 40
   30 call var_to_geom(n,x)
      call chainbuild_extconf
c     write (iout,*) 'grad 30'
C
C Transform the gradient to the gradient in angles.
C
   40 call cart2intgrad(n,g)
C
C Add the components corresponding to local energy terms.
C
   10 continue
c Add the usampl contributions
      if (usampl) then
         do i=1,nres-3
           gloc(i,icg)=gloc(i,icg)+dugamma(i)
         enddo
         do i=1,nres-2
           gloc(nphi+i,icg)=gloc(nphi+i,icg)+dutheta(i)
         enddo
      endif
      do i=1,nvar
cd      write (iout,*) 'i=',i,'g=',g(i),' gloc=',gloc(i,icg)
        g(i)=g(i)+gloc(i,icg)
      enddo
C Uncomment following three lines for diagnostics.
cd    call intout
cd    call briefout(0,0.0d0)
cd    write (iout,'(i3,1pe15.5)') (k,g(k),k=1,n)
      return
      end
C-------------------------------------------------------------------------
      subroutine grad_restr(n,x,nf,g,uiparm,urparm,ufparm)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.IOUNITS'
      integer n,nf
      double precision ufparm
      external ufparm
      integer uiparm(1)
      double precision urparm(1)
      double precision x(maxvar),g(maxvar),gg(maxvar)
      integer i,j,k,ig,ind,ij,igall
      double precision f,gthetai,gphii,galphai,gomegai

      common /gradrestrcommon/ gg

      icg=mod(nf,2)+1
      if (nf-nfl+1) 20,30,40
   20 call func_restr(n,x,nf,f,uiparm,urparm,ufparm)
c     write (iout,*) 'grad 20'
      if (nf.eq.0) return
      goto 40
   30 continue
#ifdef OSF
c     Intercept NaNs in the coordinates
c      write(iout,*) (var(i),i=1,nvar)
      x_sum=0.D0
      do i=1,n
        x_sum=x_sum+x(i)
      enddo
      if (x_sum.ne.x_sum) then
        write(iout,*)" *** grad_restr : Found NaN in coordinates"
        call flush(iout)
        print *," *** grad_restr : Found NaN in coordinates"
        return
      endif
#endif
      call var_to_geom_restr(n,x)
      call chainbuild
C
C Evaluate the derivatives of virtual bond lengths and SC vectors in variables.
C
   40 call cart2intgrad(n,gg)
C
C Convert the Cartesian gradient into internal-coordinate gradient.
C

      ig=0
      ind=nres-2
      do i=2,nres-2
       IF (mask_phi(i+2).eq.1) THEN
        ig=ig+1
        g(ig)=gg(i-1)
       ENDIF
      enddo


      do i=1,nres-2
       IF (mask_theta(i+2).eq.1) THEN
        ig=ig+1
        g(ig)=gg(nphi+i)
       ENDIF
      enddo

      do i=2,nres-1
        if (itype(i).ne.10) then
         IF (mask_side(i).eq.1) THEN
          ig=ig+1
          g(ig)=gg(ialph(i,1))
         ENDIF
        endif
      enddo


      do i=2,nres-1
        if (itype(i).ne.10) then
         IF (mask_side(i).eq.1) THEN
          ig=ig+1
          g(ig)=gg(ialph(i,1)+nside)
         ENDIF
        endif
      enddo

C
C Add the components corresponding to local energy terms.
C

      ig=0
      igall=0
      do i=4,nres
        igall=igall+1
        if (mask_phi(i).eq.1) then
          ig=ig+1
          g(ig)=g(ig)+gloc(igall,icg)
        endif
      enddo

      do i=3,nres
        igall=igall+1
        if (mask_theta(i).eq.1) then
          ig=ig+1
          g(ig)=g(ig)+gloc(igall,icg)
        endif
      enddo

      do ij=1,2
      do i=2,nres-1
        if (itype(i).ne.10) then
          igall=igall+1
          if (mask_side(i).eq.1) then
            ig=ig+1
            g(ig)=g(ig)+gloc(igall,icg)
          endif
        endif
      enddo
      enddo

cd      do i=1,ig
cd        write (iout,'(a2,i5,a3,f25.8)') 'i=',i,' g=',g(i)
cd      enddo
      return
      end
#endif
C-------------------------------------------------------------------------
      subroutine cartgrad
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#else
      double precision tcpu
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.MD'
      include 'COMMON.NMR'
      include 'COMMON.TORCNSTR'
      include 'COMMON.QRESTR'
      include 'COMMON.IOUNITS'
      include 'COMMON.TIME1'
      integer i,j,kk
      double precision time00,time01
c
c This subrouting calculates total Cartesian coordinate gradient.
c The subroutine chainbuild_cart and energy MUST be called beforehand.
c
#ifdef TIMING
#ifdef MPI
      time00=MPI_Wtime()
#else
      time00=tcpu()
#endif
#endif
      icg=1
#ifdef DEBUG
      write (iout,*) "Before sum_gradient"
      do i=1,nres-1
        write (iout,*) i," gradc  ",(gradc(j,i,icg),j=1,3)
        write (iout,*) i," gradx  ",(gradx(j,i,icg),j=1,3)
      enddo
      write (iout,*) "gsaxsc, gsaxcx"
      do i=1,nres-1
        write (iout,*) i," gsaxsc  ",(gsaxsc(j,i),j=1,3)
        write (iout,*) i," gsaxsx  ",(gsaxsx(j,i),j=1,3)
      enddo
#endif
      call sum_gradient
#ifdef TIMING
#endif
#ifdef DEBUG
      write (iout,*) "After sum_gradient"
      do i=1,nres-1
        write (iout,*) i," gradc  ",(gradc(j,i,icg),j=1,3)
        write (iout,*) i," gradx  ",(gradx(j,i,icg),j=1,3)
      enddo
#endif
c If performing constraint dynamics, add the gradients of the constraint energy
      if(usampl.and.totT.gt.eq_time) then
#ifdef DEBUG
        write (iout,*) "dudconst, duscdiff, dugamma,dutheta"
        write (iout,*) "wumb",wumb
        do i=1,nct
          write (iout,'(i5,3f10.5,5x,3f10.5,5x,2f10.5)')
     &     i,(dudconst(j,i),j=1,3),(duscdiff(j,i),j=1,3),
     &     dugamma(i),dutheta(i)
        enddo
#endif

!$OMP PARALLEL DO PRIVATE(j) DEFAULT(SHARED)
        do i=1,nct
          do j=1,3
            gradc(j,i,icg)=gradc(j,i,icg)+
     &         wumb*(dudconst(j,i)+duscdiff(j,i))
            gradx(j,i,icg)=gradx(j,i,icg)+
     &         wumb*(dudxconst(j,i)+duscdiffx(j,i))
          enddo
        enddo

!$OMP PARALLEL DO DEFAULT(SHARED)
        do i=1,nres-3
          gloc(i,icg)=gloc(i,icg)+wumb*dugamma(i)
          gloc(nphi+i,icg)=gloc(nphi+i,icg)+wumb*dutheta(i)
        enddo

        do i=nres-2,nres-2
          gloc(nphi+i,icg)=gloc(nphi+i,icg)+wumb*dutheta(i)
        enddo
      endif

!$OMP PARALLEL DO PRIVATE(j) DEFAULT(SHARED)
      do i=0,nct
        do j=1,3
          gcart(j,i)=gradc(j,i,icg)
          gxcart(j,i)=gradx(j,i,icg)
        enddo
      enddo
#ifdef GRAD_NaN_CHECK
      do i=1,nres-1
      if (isnan(gcart(1,i))) then
        write (iout,*) "NaNs in gcart before int_to_cart"
      endif
      enddo
#endif
#ifdef DEBUG
      write (iout,*) "gcart, gxcart, gloc before int_to_cart"

      do i=0,nct
        if (i.eq.0) then
        write (iout,'(i5,2(3f10.5,5x),4f10.5)') i,(gcart(j,i),j=1,3),
     &    (gxcart(j,i),j=1,3)
        else if((itype(i).ne.10).and.(itype(i).ne.ntyp1)) then
        write (iout,'(i5,2(3f10.5,5x),4f10.5)') i,(gcart(j,i),j=1,3),
     &    (gxcart(j,i),j=1,3),gloc(i,icg),gloc(i+nphi,icg),
     &    gloc(ialph(i,1),icg),gloc(ialph(i,1)+nside,icg)
        else
        write (iout,'(i5,2(3f10.5,5x),4f10.5)') i,(gcart(j,i),j=1,3),
     &    (gxcart(j,i),j=1,3),gloc(i,icg),gloc(i+nphi,icg)
        endif
        call flush(iout)
      enddo
#endif
c
c Convert the internal-coordinate to Cartesian-coordinate gradient if needed.
c
      if (ndih_constr.gt.0 .or. ntheta_constr.gt.0
     & .or.  constr_homology.gt.0 .or. nfrag_back.gt.0 .or. npeak.gt.0) 
     & then
#ifdef TIMING
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
      call intcartderiv
#ifdef TIMING
#ifdef MPI
      time_intcartderiv=time_intcartderiv+MPI_Wtime()-time01
#else
      time_intcartderiv=time_intcartderiv+tcpu()-time01
#endif
#endif
cd      call checkintcartgrad
cd      write(iout,*) 'calling int_to_cart'
#ifdef TIMING
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
      call int_to_cart
#ifdef TIMING
#ifdef MPI
      time_inttocart=time_inttocart+MPI_Wtime()-time01
#else
      time_inttocart=time_inttocart+tcpu()-time01
#endif
#endif
#ifdef GRAD_NaN_CHECK
      do i=1,nres      
      if (isnan(gcart(1,i))) then
        write (iout,*) "NaNs in gcart after int_to_cart"
      endif
      enddo
#endif
#ifdef DEBUG
      write (iout,*) "gcart and gxcart after int_to_cart"
      do i=0,nres-1
        write (iout,'(i5,3f10.5,5x,3f10.5)') i,(gcart(j,i),j=1,3),
     &      (gxcart(j,i),j=1,3)
      enddo
#endif
#ifdef TIMING
#ifdef MPI
      time_cartgrad=time_cartgrad+MPI_Wtime()-time00
#else
      time_cartgrad=time_cartgrad+tcpu()-time00
#endif
#endif
      endif
      return
      end
c---------------------------------------------------------------------------
#ifdef FIVEDIAG
      subroutine grad_transform
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include 'mpif.h'
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.IOUNITS'
      include 'COMMON.TIME1'
      integer i,j,kk
#ifdef DEBUG
      write (iout,*)"Converting virtual-bond gradient to CA/SC gradient"
      write (iout,*) "dC/dX gradient"
      do i=0,nres
        write (iout,'(i5,3f10.5,5x,3f10.5)') i,(gcart(j,i),j=1,3),
     &      (gxcart(j,i),j=1,3)
      enddo
#endif
      do i=nres,1,-1
        do j=1,3
          gcart(j,i)=-gcart(j,i)+gcart(j,i-1)-gxcart(j,i)
!          gcart_new(j,i)=-gcart(j,i)+gcart(j,i-1)-gxcart(j,i)
        enddo
!        write (iout,'(i5,3f10.5,5x,3f10.5,5x,3f10.5)') i,(gcart(j,i),j=1,3), &
!            (gcart_new(j,i),j=1,3),(gxcart(j,i),j=1,3)
      enddo
! Correction: dummy residues
      do i=2,nres
        if (itype(i-1).eq.ntyp1 .and. itype(i).ne.ntyp1) then
          gcart(:,i)=gcart(:,i)+gcart(:,i-1)
        else if (itype(i-1).ne.ntyp1 .and. itype(i).eq.ntyp1) then
          gcart(:,i-1)=gcart(:,i-1)+gcart(:,i)
        endif
      enddo
c      if (nnt.gt.1) then
c        do j=1,3
c          gcart(j,nnt)=gcart(j,nnt)+gcart(j,1)
c        enddo
c      endif
c      if (nct.lt.nres) then
c        do j=1,3
c!          gcart_new(j,nct)=gcart_new(j,nct)+gcart_new(j,nres)
c          gcart(j,nct)=gcart(j,nct)+gcart(j,nres)
c        enddo
c      endif
#ifdef DEBUG
      write (iout,*) "CA/SC gradient"
      do i=1,nres
        write (iout,'(i5,3f10.5,5x,3f10.5)') i,(gcart(j,i),j=1,3),
     &      (gxcart(j,i),j=1,3)
      enddo
#endif
      return
      end
#endif
c-------------------------------------------------------------------------
      subroutine zero_array1(n,a)
      implicit none
      integer n,i
      double precision a(n)
      if(n.le.0) return
      do i=1,n
        a(i)=0.0d0
      enddo
      return
      end
c-------------------------------------------------------------------------
      subroutine zero_array(n,m,a)
      implicit none
      integer n,m
      double precision a(n,m)
      call zero_array1(n*m,a)
      return
      end
C-------------------------------------------------------------------------
      subroutine zerograd
      use omp_lib
      implicit none
#ifdef MPI
      include "mpif.h"
#endif
      include 'DIMENSIONS'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.MD'
      include 'COMMON.SCCOR'
#ifdef SHIELD
      include 'COMMON.SHIELD'
#endif
      include 'COMMON.TIME1'
      integer i,j,kk,intertyp,maxshieldlist
      integer from,from2,to,cnt,my_thread,threads_used,range_lo,range_hi
#ifdef TIMING
      double precision time00,tcpu
#ifdef MPI
      time00=MPI_Wtime()
#else
      time00=tcpu()
#endif
#endif
      maxshieldlist=0

      threads_used=omp_get_max_threads()
      !range_lo=-1
      !range_hi=nres

!$OMP PARALLEL DEFAULT(SHARED) NUM_THREADS(threads_used)
!$OMP& PRIVATE(my_thread,from,from2,to,cnt,i,j,kk,intertyp)
      my_thread=omp_get_thread_num()+1
      !from=range_lo+((range_hi-range_lo)/threads_used)*(my_thread-1)
      !to=range_lo+((range_hi-range_lo)/threads_used)*my_thread-1
      !if(my_thread.eq.threads_used) to=range_hi
      call split_work_for_threads(from,to,-1,nres,
     &                            my_thread,threads_used)

      cnt=to-from+1
C
C Initialize Cartesian-coordinate gradient
C
c      do i=-1,nres
c        do j=1,3
      call zero_array(3,cnt,gvdwx(1,from))
      call zero_array(3,cnt,gradx_scp(1,from))
      call zero_array(3,cnt,gvdwc(1,from))
      call zero_array(3,cnt,gvdwc_scp(1,from))
      call zero_array(3,cnt,gvdwc_scpp(1,from))
      call zero_array(3,cnt,gelc(1,from))  ! needed by eelecij_scale
      call zero_array(3,cnt,gloctordc(1,from))
      call zero_array(3,cnt,glocangdc(1,from))
#ifdef SHIELD
C below is zero grad for shielding in order: ees (p-p)
C ecorr4, eturn3, eturn4, eel_loc, c denotes calfa,x is side-chain
      call zero_array(3,cnt,gshieldx(1,from))
      call zero_array(3,cnt,gshieldc(1,from))
      call zero_array(3,cnt,gshieldc_loc(1,from))
      call zero_array(3,cnt,gshieldx_ec(1,from))
      call zero_array(3,cnt,gshieldc_ec(1,from))
      call zero_array(3,cnt,gshieldc_loc_ec(1,from))
      call zero_array(3,cnt,gshieldx_t3(1,from))
      call zero_array(3,cnt,gshieldc_t3(1,from))
      call zero_array(3,cnt,gshieldc_loc_t3(1,from))
      call zero_array(3,cnt,gshieldx_t4(1,from))
      call zero_array(3,cnt,gshieldc_t4(1,from))
      call zero_array(3,cnt,gshieldc_loc_t4(1,from))
      call zero_array(3,cnt,gshieldx_ll(1,from))
      call zero_array(3,cnt,gshieldc_ll(1,from))
      call zero_array(3,cnt,gshieldc_loc_ll(1,from))
C end of zero call zero_array(3,nres+2,grad) for shielding
#endif
      call zero_array(3,cnt,gelc_long(1,from))     ! eelecij_scale
      call zero_array(3,cnt,gradb(1,from))         ! only in ebond
      call zero_array(3,cnt,gradbx(1,from))        ! only in ebond
      call zero_array(3,cnt,gvdwpp(1,from))        ! eelecij_scale
      call zero_array(3,cnt,gel_loc(1,from))       ! eelecij_scale
      call zero_array(3,cnt,gel_loc_long(1,from))  ! eelecij_scale
c AL: Not sure if we can zeor the tables starting from "from"
      call zero_array(3,cnt,ghpbc(1,from))
      call zero_array(3,cnt,ghpbdc(1,from))
      call zero_array(3,cnt,ghpbx(1,from))
      call zero_array(3,cnt,gsaxsc(1,from))
      call zero_array(3,cnt,gsaxsx(1,from))
      call zero_array(3,cnt,ghpbc(1,from))
      ghpbdphi(:nres)=0.0d0
      call zero_array(3,cnt,gcorr3_turn(1,from))
      call zero_array(3,cnt,gcorr4_turn(1,from))
#ifdef FOURBODY
      !call zero_array(3,cnt,gcorr4_turn(1,from))
      call zero_array(3,cnt,gradcorr(1,from))
      call zero_array(3,cnt,gradcorr_long(1,from))
      call zero_array(3,cnt,gradcorr5_long(1,from))
      call zero_array(3,cnt,gradcorr6_long(1,from))
      call zero_array(3,cnt,gcorr6_turn_long(1,from))
      call zero_array(3,cnt,gradcorr5(1,from))
      call zero_array(3,cnt,gradcorr6(1,from))
      call zero_array(3,cnt,gcorr6_turn(1,from))
#endif
      call zero_array(3,cnt,gsccorc(1,from))
      call zero_array(3,cnt,gsccorx(1,from))
      call zero_array(3,cnt,gradc(1,from,icg))
      call zero_array(3,cnt,gradx(1,from,icg))
      call zero_array(3,cnt,gscloc(1,from))
      call zero_array(3,cnt,gsclocx(1,from))
      call zero_array(3,cnt,gliptranc(1,from))
      call zero_array(3,cnt,gliptranx(1,from))
      call zero_array(3,cnt,gradafm(1,from))
#ifdef SHIELD
      call zero_array(3,cnt,grad_shield(1,from))
#endif
      call zero_array(3,cnt,gg_tube(1,from))
      call zero_array(3,cnt,gg_tube_sc(1,from))
#ifdef SHIELD
C grad_shield_side is Cbeta sidechain gradient
      !do i=-1,nres
      do i=from,to
        do kk=1,maxshieldlist
          do j=1,3
            grad_shield_side(j,kk,i)=0.0d0
            grad_shield_loc(j,kk,i)=0.0d0
          enddo
        enddo
      enddo
#endif
C grad_shield_side_ca is Calfa sidechain gradient

C           grad_shield_side_ca(j,kk,i)=0.0d0
c          enddo
c          do intertyp=1,3
      call zero_array(3,cnt,gloc_sc(1,from,icg))
c          enddo
c        enddo
c      enddo
#ifndef DFA
c      do i=1,nres
c        do j=1,3
      from2=max0(1,from)
      cnt=to-from2+1
      call zero_array(3,cnt,gdfad(1,from2))
      call zero_array(3,cnt,gdfat(1,from2))
      call zero_array(3,cnt,gdfan(1,from2))
      call zero_array(3,cnt,gdfab(1,from2))
c        enddo
c      enddo
#endif
C
C Initialize the gradient of local energy terms.
C
      from2=max0(1,from)
      cnt=to-from2+1

      !do i=1,4*nres
      !  gloc(i,icg)=0.0D0
      !enddo
      call zero_array1(cnt,gloc(from2,icg))
      call zero_array1(cnt,gloc(from2+nres,icg))
      call zero_array1(cnt,gloc(from2+2*nres,icg))
      call zero_array1(cnt,gloc(from2+3*nres,icg))

      call zero_array1(cnt,gel_loc_loc(from2))  ! used by eelecij_scale
      call zero_array1(cnt,gel_loc_turn3(from2))
      call zero_array1(cnt,gel_loc_turn4(from2))
#ifdef FOURBODY
      call zero_array1(cnt,gcorr_loc(from2))
      call zero_array1(cnt,gcorr5_loc(from2))
      call zero_array1(cnt,gcorr6_loc(from2))
      call zero_array1(cnt,gel_loc_turn6(from2))
#endif
      call zero_array1(cnt,gsccor_loc(from2))
c initialize call zero_array(3,nres+2,gcart and gxcart
c      do i=0,nres
c        do j=1,3
!         call zero_array(3,nres+1,gcart(1,0))
!         call zero_array(3,nres+1,gxcart(1,0))
c        enddo
c      enddo
      from2=max0(0,from)
      cnt=to-from2+1
      call zero_array(3,cnt,gcart(1,from2))
      call zero_array(3,cnt,gxcart(1,from2))

!$OMP END PARALLEL

#ifdef TIMING
#ifdef MPI
      time_zerograd=time_zerograd+MPI_Wtime()-time00
#else
      time_zerograd=time_zerograd+tcpu()-time00
#endif
#endif
      return
      end
c-------------------------------------------------------------------------
      double precision function fdum()
      fdum=0.0D0
      return
      end
