      subroutine ESCP_WORK_NAME(chunk,i,from,to,output,accum)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.SPLITELE'
      include 'COMMON.TIME1'
      include 'COMMON.ESCP'
      integer from,to,i,j,seq,idx
      record /escp_work_chunk/ chunk
      record /escp_result_item/ output(-1:maxres)
      record /escp_accumulator/ accum
      double precision ggg(3),iacc(3)
      double precision xyzj(3),rij,rrij,fac,e1,e2
      double precision sqrtrij,sqrtrrij,gamm
      double precision evdwij,delta2,delta2_14
      iacc=0.0d0
      delta2=0.0d0
      delta2_14=0.0d0

#ifdef ESCP_WORK_WITH_14
!DIR$ LOOP COUNT(2)
#else
!DIR$ LOOP COUNT(64)
#endif
!$OMP SIMD REDUCTION(+:iacc,delta2,delta2_14) PRIVATE(
!$OMP&   j,idx,xyzj,ggg,rij,rrij,sqrtrij,sqrtrrij,
!$OMP&   sss,sssgrad,gamm,fac,e1,e2,evdwij
!$OMP& )
      do seq=from,to
        j=ESCP_MAP_J(seq)
        idx=ESCP_MAP_IDX(seq)
        xyzj(1)=chunk.x(idx)
        xyzj(2)=chunk.y(idx)
        xyzj(3)=chunk.z(idx)
        rij=chunk.r(idx)

        rrij=1.0d0/rij

#ifdef ESCP_WORK_WITH_DROPOFF
        sqrtrij=dsqrt(rij)
        sqrtrrij=1.0d0/(sqrtrij*expon)
        gamm=(sqrtrij-r_dropoff)*irlamb
        sss=1.0d0+gamm*gamm*(2*gamm-3.0d0)
        sssgrad=gamm*(6*gamm-6.0d0)*irlamb
        sssgrad=sssgrad*sqrtrrij
#else
        sss=1.0d0
        sssgrad=0.0d0
        !sqrtrrij=0.0d0
#endif

        ESCP_POW(rrij,fac)

        e2=fac*chunk.bad(idx)
        e1=fac*fac*chunk.aad(idx)

#ifdef ESCP_WORK_WITH_14
        !if (iabs(j-i) .le. 2) then
        e1=scal14*e1
        e2=scal14*e2
        evdwij=e1+e2
        delta2_14=delta2_14+evdwij*sss
        !endif
#else
        evdwij=e1+e2
#endif
        delta2=delta2+evdwij*sss
#ifdef DEBUG
        if (energy_dec) write (iout,'(a6,2i5,3f7.3,2i3,3e11.3)')
     &      'evdw2',i,j,1.0d0/dsqrt(rrij),sss,
     &     evdwij,itel(i),-1,fac,chunk.aad(idx)
     &     chunk.bad(idx)
#endif
C
C Calculate contributions to the gradient in the virtual-bond and SC vectors.
C
        fac=-(evdwij+e1)*rrij*sss
        fac=fac+(evdwij)*sssgrad
        !fac=fac+evdwij*sssgrad*sqrtrrij
        ggg=xyzj*fac
        iacc=iacc+ggg
        output(j).scp=output(j).scp+ggg
      enddo ! j
!$OMP END SIMD
#ifdef ESCP_WORK_WITH_14
      accum.evdw2_14=accum.evdw2_14+delta2_14
#endif
      output(i).scpp=output(i).scpp-iacc
      accum.evdw2=accum.evdw2+delta2
      return
      end

