#include"simdstat"

      subroutine ESCP_NAME(evdw2,evdw2_14)
#ifdef _OPENMP
      use omp_lib
#endif
C
C This subroutine calculates the excluded-volume interaction energy between
C peptide-group centers and side chains and its gradient in virtual-bond and
C side-chain vectors.
C
      implicit none
#ifdef MPI
      include 'mpif.h'
#endif
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.SPLITELE'
      include 'COMMON.TIME1'
      include 'COMMON.ESCP'
      include 'COMMON.OMP'
      include 'COMMON.NEWBOX'
      double precision xyzj(3),rij
      double precision dexpon,r_dropoff_sq
      double precision evdw2,evdw2_14,evdwij
      double precision box(3),halfbox(3)

      record /escp_work_chunk/ seq_work,nseq_work,droff_work,e14_work
      integer seq_idx,nseq_idx,droff_idx,e14_idx

      integer i,j,iteli,itypj,ikont,jkont,jblock,lastj
      logical full,limited
      integer threads_used,my_thread

      integer from_blk,to_blk,from_j,to_j
      integer from_ik,to_ik,first_blk,last_blk,first_j,last_j

      double precision scalar
#ifdef DEBUG
      if (energy_dec) write (iout,*) "escp:",r_cut_int,rlamb
#endif

      threads_used = scp_threads

!$OMP PARALLEL NUM_THREADS(threads_used) DEFAULT(SHARED)
!$OMP& FIRSTPRIVATE(threads_used)
!$OMP& PRIVATE(
!$OMP&   i,j,iteli,itypj,ikont,jkont,jblock,lastj,xyzj,rij,
!$OMP&   seq_work,nseq_work,droff_work,e14_work,full,r_dropoff_sq,
!$OMP&   seq_idx,nseq_idx,droff_idx,e14_idx,my_thread,
!$OMP&   box,halfbox,
!$OMP&   from_ik,to_ik,first_blk,last_blk,first_j,last_j,
!$OMP&   from_blk,to_blk,from_j,to_j
!$OMP& )
      r_dropoff_sq=r_dropoff*r_dropoff
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif

      lastj=0
      seq_idx=0
      nseq_idx=0
      droff_idx=0
      e14_idx=0

      from_ik=scp_from_ik(my_thread)
      to_ik=scp_to_ik(my_thread)
      first_blk=scp_first_blk(my_thread)
      last_blk=scp_last_blk(my_thread)
      first_j=scp_first_j(my_thread)
      last_j=scp_last_j(my_thread)

      box=boxsize
      halfbox=halfboxsize

      do ikont=from_ik,to_ik
        i=newcontlistscpi(1,ikont)
        from_blk=newcontlistscpi(2,ikont-1)+1
        to_blk=newcontlistscpi(2,ikont)

        if(ikont.eq.from_ik) from_blk=scp_first_blk(my_thread)
        if(ikont.eq.to_ik) to_blk=scp_last_blk(my_thread)

        lastj=-1

        iteli=itel(i)

        do jblock=from_blk,to_blk
          from_j=newcontlistscpj(1,jblock)
          to_j=newcontlistscpj(2,jblock)
          if((ikont.eq.from_ik).and.(jblock.eq.from_blk)) from_j=first_j
          if((ikont.eq.to_ik).and.(jblock.eq.to_blk)) to_j=last_j

          do j=from_j,to_j
C Uncomment following three lines for SC-p interactions
c       call wrapvec(c_tobox(:,nres+j)-cp(:,i), xyzj)
C Uncomment following three lines for Ca-p interactions

            LOG_STAT(400,1)

            !call wrapvec(c_tobox(:,j)-cp(:,i),xyzj)
            call wrapvec2(c_tobox(:,j)-cp(:,i),xyzj,halfbox,box)
            rij=scalar(xyzj,xyzj)
            if(rij.ge.r_cut_int_sq) cycle

            LOG_STAT(401,1)

            !itypj=iabs(itype(j))
            itypj=abs_itype(j)

            if(iabs(j-i).le.2) then           ! _14 path
              call escp_queue_work(e14_work,e14_idx,j,xyzj,rij,
     &                             aad(itypj,iteli),bad(itypj,iteli),
     &                             full)
            else if(rij.gt.r_dropoff_sq) then ! path with dropoff
              call escp_queue_work(droff_work,droff_idx,j,xyzj,rij,
     &                             aad(itypj,iteli),bad(itypj,iteli),
     &                             full)
              if(full) then
                call ESCP_WORK_DROPOFF(droff_work,i,1,droff_idx,
     &                                 escp_result(:,my_thread),
     &                                 escp_accum(my_thread))
                LOG_STAT(411,droff_idx)
                droff_idx=0
              endif
            else                              ! no dropoff, no _14
#ifdef ESCP_WITH_SEQ
              if((j.eq.lastj+1).or.(seq_idx.eq.0)) then
                call escp_queue_work(seq_work,seq_idx,j,xyzj,rij,
     &                               aad(itypj,iteli),bad(itypj,iteli),
     &                               full)
                lastj=j
                if(full) then
!DIR$ NOINLINE
                  call ESCP_WORK_SEQ(seq_work,i,
     &                               seq_work.j(1),seq_work.j(seq_idx),
     &                               escp_result(:,my_thread),
     &                               escp_accum(my_thread))
                  LOG_STAT(402,seq_idx)
                  seq_idx=0
                  lastj=-1
                endif
              else
                if((seq_idx.lt.simd_seq_cutoff) .and.
     &             (nseq_idx+seq_idx.lt.escp_buffer_size)) then
                  LOG_STAT(404,seq_idx)
                  call escp_move_work(seq_work,seq_idx,
     &                                nseq_work,nseq_idx)
                else
!DIR$ NOINLINE
                  call ESCP_WORK_SEQ(seq_work,i,
     &                               seq_work.j(1),seq_work.j(seq_idx),
     &                               escp_result(:,my_thread),
     &                               escp_accum(my_thread))
                  LOG_STAT(402,seq_idx)
                  seq_idx=0
                endif
#endif
                call escp_queue_work(nseq_work,nseq_idx,j,xyzj,rij,
     &                               aad(itypj,iteli),bad(itypj,iteli),
     &                               full)
                lastj=j
                if(full) then
                  call ESCP_WORK_NSEQ(nseq_work,i,1,nseq_idx,
     &                                escp_result(:,my_thread),
     &                                escp_accum(my_thread))
                  LOG_STAT(403,nseq_idx)
                  nseq_idx=0
                  lastj=-1
                endif
#ifdef ESCP_WITH_SEQ
              endif
#endif
            endif
          enddo
        enddo

        if(e14_idx.gt.0) then
          call ESCP_WORK_14(e14_work,i,1,e14_idx,
     &                      escp_result(:,my_thread),
     &                      escp_accum(my_thread))
          e14_idx=0
          LOG_STAT(412,e14_idx)
        endif
        if(droff_idx.gt.0) then
          call ESCP_WORK_DROPOFF(droff_work,i,1,droff_idx,
     &                           escp_result(:,my_thread),
     &                           escp_accum(my_thread))
          droff_idx=0
          LOG_STAT(411,droff_idx)
        endif
#ifdef ESCP_WITH_SEQ
        if(seq_idx.gt.0) then
!DIR$ NOINLINE
          call ESCP_WORK_SEQ(seq_work,i,
     &                       seq_work.j(1),seq_work.j(seq_idx),
     &                       escp_result(:,my_thread),
     &                       escp_accum(my_thread))
          seq_idx=0
          LOG_STAT(402,seq_idx)
        endif
#endif
        if(nseq_idx.gt.0) then
          call ESCP_WORK_NSEQ(nseq_work,i,1,nseq_idx,
     &                        escp_result(:,my_thread),
     &                        escp_accum(my_thread))
          nseq_idx=0
          LOG_STAT(403,nseq_idx)
        endif
      enddo  ! ikont
!$OMP END PARALLEL

      call sum_escp_values(evdw2,evdw2_14,threads_used)
      dexpon=expon
      call sum_escp_arrays(threads_used,dexpon)
      ! all below moved to sum_escp_arrays
      !gvdwc_scp(:,1:nct)=gvdwc_scp(:,1:nct)*dexpon
      !gvdwc_scpp(:,1:nct)=gvdwc_scpp(:,1:nct)*dexpon
      !gradx_scp(:,1:nct)=gradx_scp(:,1:nct)*dexpon
C******************************************************************************
C
C                              N O T E !!!
C
C To save time the factor EXPON has been extracted from ALL components
C of GVDWC and GRADX. Remember to multiply them by this factor before further 
C use!
C
C******************************************************************************
      return
      end
#ifdef ESCP_WITH_SEQ
#define ESCP_WORK_NAME ESCP_WORK_SEQ
#define ESCP_MAP_J(seq)   seq
#define ESCP_MAP_IDX(seq) seq-chunk.j(1)+1
#define ESCP_FIX_SUM_DELTA2
#include"escp_work.F"
#undef ESCP_FIX_SUM_DELTA2
#undef ESCP_MAP_IDX(seq)
#undef ESCP_MAP_J(seq)
#undef ESCP_WORK_NAME
#endif

#define ESCP_WORK_NAME ESCP_WORK_NSEQ
#define ESCP_MAP_J(seq)  chunk.j(seq)
#define ESCP_MAP_IDX(seq) seq
#include"escp_work.F"
#undef ESCP_MAP_IDX(seq)
#undef ESCP_MAP_J(seq)
#undef ESCP_WORK_NAME

#define ESCP_WORK_NAME ESCP_WORK_DROPOFF
#define ESCP_WORK_WITH_DROPOFF
#define ESCP_MAP_J(seq)  chunk.j(seq)
#define ESCP_MAP_IDX(seq) seq
#include"escp_work.F"
#undef ESCP_MAP_IDX(seq)
#undef ESCP_MAP_J(seq)
#undef ESCP_WORK_WITH_DROPOFF
#undef ESCP_WORK_NAME

#define ESCP_WORK_NAME ESCP_WORK_14
#define ESCP_WORK_WITH_14
#define ESCP_MAP_J(seq)  chunk.j(seq)
#define ESCP_MAP_IDX(seq) seq
#include"escp_work.F"
#undef ESCP_MAP_IDX(seq)
#undef ESCP_MAP_J(seq)
#undef ESCP_WORK_WITH_14
#undef ESCP_WORK_NAME
