      subroutine escp(evdw2,evdw2_14)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.INTERACT'
      double precision evdw2,evdw2_14
      if(expon2.eq.3)then
        call escp_3(evdw2,evdw2_14)
      else
        call escp_n(evdw2,evdw2_14)
      endif
      return
      end
C-------------------------------------------------------------------------------
      subroutine clear_escp_values(num_threads)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.ESCP'
      integer i,num_threads
      do i=1,num_threads
        escp_accum(i).evdw2=0.0d0
        escp_accum(i).evdw2_14=0.0d0
      enddo
      return
      end
C-------------------------------------------------------------------------------
      subroutine sum_escp_values(evdw2,evdw2_14,num_threads)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.ESCP'
      double precision evdw2,evdw2_14
      integer i,num_threads
      evdw2=0.0d0
      evdw2_14=0.0d0
      do i=1,num_threads
        evdw2=evdw2+escp_accum(i).evdw2
        evdw2_14=evdw2_14+escp_accum(i).evdw2_14
        escp_accum(i).evdw2=0.0d0
        escp_accum(i).evdw2_14=0.0d0
      enddo
      return
      end
C-------------------------------------------------------------------------------
      subroutine clear_escp_arrays(num_threads)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.ESCP'
      integer i,j,num_threads
      do i=1,num_threads
        do j=-1,maxres
          escp_result(j,i).scp=0.0d0
          escp_result(j,i).scpp=0.0d0
        enddo
      enddo
      return
      end
C-------------------------------------------------------------------------------
      subroutine sum_escp_arrays(num_threads,dexpon)
#ifdef _OPENMP
      use omp_lib
#endif
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.ESCP'
      integer i,j,num_threads,my_thread,from,to,threads_used
      double precision ggg(3)
      double precision dexpon

#ifdef _OPENMP
      threads_used=omp_get_max_threads()
#else
      threads_used=1
#endif

      do i=1,num_threads
        do j=-1,0
          escp_result(j,i).scp=0.0d0
          escp_result(j,i).scpp=0.0d0
        enddo
      enddo

!$OMP PARALLEL NUM_THREADS(threads_used) DEFAULT(SHARED)
!$OMP& PRIVATE(from,to,i,j,my_thread,ggg)
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif

      !from=1+((nct-1)/threads_used)*(my_thread-1)
      !to=1+((nct-1)/threads_used)*my_thread-1
      !if(my_thread.eq.threads_used) to=nct
      call split_work_for_threads(from,to,1,nct,my_thread,threads_used)

      do j=from,to
        ggg=0.0d0
        do i=1,num_threads
          ggg=ggg+escp_result(j,i).scp
          escp_result(j,i).scp=0.0d0
        enddo
        gvdwc_scp(:,j)=ggg*dexpon
      enddo

      do j=from,to
        ggg=0.0d0
        do i=1,num_threads
          ggg=ggg+escp_result(j,i).scpp
          escp_result(j,i).scpp=0.0d0
        enddo
        gvdwc_scpp(:,j)=ggg*dexpon
      enddo

      do j=from,to
        gradx_scp(:,j)=gradx_scp(:,j)*dexpon
      enddo
!$OMP END PARALLEL
      return
      end
C-------------------------------------------------------------------------------
      subroutine escp_queue_work(chunk,idx,j,xyzj,rij,aad,bad,full)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.ESCP'
      integer idx,j
      double precision xyzj(3),rij,aad,bad
      logical full
      record /escp_work_chunk/ chunk
      idx=idx+1
      chunk.j(idx)=j
      chunk.x(idx)=xyzj(1)
      chunk.y(idx)=xyzj(2)
      chunk.z(idx)=xyzj(3)
      chunk.r(idx)=rij
      chunk.aad(idx)=aad
      chunk.bad(idx)=bad
      full=idx.eq.escp_buffer_size
      return
      end
C-----------------------------------------------------------------------------
      subroutine escp_move_work(from,from_idx,to,to_idx)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.ESCP'
      integer from_idx,to_idx,idx
      record /escp_work_chunk/ from,to
      do idx=1,from_idx
        to_idx=to_idx+1
        to.j(to_idx)=from.j(idx)
        to.x(to_idx)=from.x(idx)
        to.y(to_idx)=from.y(idx)
        to.z(to_idx)=from.z(idx)
        to.r(to_idx)=from.r(idx)
        to.aad(to_idx)=from.aad(idx)
        to.bad(to_idx)=from.bad(idx)
      enddo
      from_idx=0
      return
      end
C-------------------------------------------------------------------------------
!     subroutine escp_add_result(i,output,accum,iaccum,delta2)
!     implicit none
!     include 'DIMENSIONS'
!     include 'COMMON.ESCP'
!     integer i
!     record /escp_result_item/ output(-1:maxres)
!     record /escp_accumulator/ accum
!     double precision iaccum(3),delta2,delta2_14
!     output(i).scpp=output(i).scpp-iaccum
!     accum.evdw2=accum.evdw2+delta2
!     return
!     end
C-------------------------------------------------------------------------------
!     subroutine escp_add_result_14(i,output,accum,iaccum,
!    &                              delta2,delta2_14)
!     implicit none
!     include 'DIMENSIONS'
!     include 'COMMON.ESCP'
!     integer i
!     record /escp_result_item/ output(-1:maxres)
!     record /escp_accumulator/ accum
!     double precision iaccum(3),delta2,delta2_14
!     output(i).scpp=output(i).scpp-iaccum
!     accum.evdw2=accum.evdw2+delta2
!     accum.evdw2_14=accum.evdw2_14+delta2_14
!     return
!     end
C----------------------------------------------------------------------
#define ESCP_NAME            escp_3
#define ESCP_WORK_SEQ        escp_3_do_work_seq
#define ESCP_WORK_NSEQ       escp_3_do_work_nonseq
#define ESCP_WORK_14         escp_3_do_work_14
#define ESCP_WORK_DROPOFF    escp_3_do_work_dropoff
#define ESCP_POW(x,o)        o=x*x*x
#include"escp_t.F"
#undef ESCP_WORK_DROPOFF
#undef ESCP_WORK_14
#undef ESCP_WORK_NSEQ
#undef ESCP_WORK_SEQ
#undef ESCP_NAME
#undef ESCP_POW

#define ESCP_NAME            escp_n
#define ESCP_WORK_SEQ        escp_n_do_work_seq
#define ESCP_WORK_NSEQ       escp_n_do_work_nonseq
#define ESCP_WORK_14         escp_n_do_work_14
#define ESCP_WORK_DROPOFF    escp_n_do_work_dropoff
#define ESCP_POW(x,o)        o=x**expon2
#include"escp_t.F"
#undef ESCP_WORK_DROPOFF
#undef ESCP_WORK_14
#undef ESCP_WORK_NSEQ
#undef ESCP_WORK_SEQ
#undef ESCP_NAME
#undef ESCP_POW
