      subroutine e_saxs(Esaxs_constr)
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include "mpif.h"
      include "COMMON.SETUP"
      integer IERR
#endif
      include 'COMMON.SBRIDGE'
      include 'COMMON.CHAIN'
      include 'COMMON.GEO'
      include 'COMMON.DERIV'
      include 'COMMON.LOCAL'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
c      include 'COMMON.MD'
#ifdef LANG0
#ifdef FIVEDIAG
      include 'COMMON.LANGEVIN.lang0.5diag'
#else
      include 'COMMON.LANGEVIN.lang0'
#endif
#else
      include 'COMMON.LANGEVIN'
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.SAXS'
      include 'COMMON.NAMES'
      include 'COMMON.TIME1'
      include 'COMMON.FFIELD'
c
      double precision Esaxs_constr
      integer i,iint,j,k,l,ii,jj,inii,injj
      double precision PgradC(maxSAXS,3,maxres),
     &  PgradX(maxSAXS,3,maxres)
#ifdef MPI
      double precision PgradC_(maxSAXS,3,maxres),
     &  PgradX_(maxSAXS,3,maxres),Pcalc_(maxSAXS)
#endif
      double precision dk,dijCACA,dijCASC,dijSCCA,dijSCSC,dij,dij0,
     & sigma2CACA,sigma2CASC,sigma2SCCA,sigma2SCSC,expCACA,expCASC,
     & expSCCA,expSCSC,CASCgrad,SCCAgrad,SCSCgrad,aux,auxC,auxC1,
     & auxX,auxX1,CACAgrad,CACAgrad1,sigmaCACA,threesig
      double precision sss2,ssgrad2,rrr,sscalgrad2,sscale2
      double precision dist,mygauss,mygaussder
      external dist
      integer llicz,lllicz
      double precision time01,tcpu
      integer nei(maxres),inei(100,maxres)
      double precision rnei(maxres),rneiprim(maxres),
     & rnei_tot_prim,radtab(maxres),radtabprim(100,maxres),
     & dnei_inv(100,maxres)
c      double precision rnei_min_bound /4.0d0/,rnei_max_bound /10.0d0/,
c      double precision rnei_min_bound /0.0d0/,rnei_max_bound /15.0d0/,
c     & rnei_mid_bound
      double precision x,xx,xprim,diffd
      double precision fcont,fprimcont
c      double precision sigmamin /0.0d0/,sigmamax /4.5d0/
c  SAXS restraint penalty function
      rnei_mid_bound=(rnei_min_bound+rnei_max_bound)/2
#ifdef DEBUG
      write(iout,*) "------- SAXS penalty function start -------"
      write (iout,*) "nsaxs",nsaxs
      write (iout,*) "Esaxs: iatsc_s",iatsc_s," iatsc_e",iatsc_e
      write (iout,*) "Psaxs"
      do i=1,nsaxs
        write (iout,'(i5,e15.5)') i, Psaxs(i)
      enddo
#endif
#ifdef TIMING
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
      Esaxs_constr = 0.0d0
      do k=1,nsaxs
        Pcalc(k)=0.0d0
        do j=1,nres
          do l=1,3
            PgradC(k,l,j)=0.0d0
            PgradX(k,l,j)=0.0d0
          enddo
        enddo
      enddo
c      lllicz=0
c 7/11/2020 Adam: determine the neighbors 
      do i=nnt,nct
        rnei(i)=0.0d0
        nei(i)=0
        rnei_tot_prim=0.0d0
        do j=1,100
          inei(j,i)=0
          rneiprim(j)=0.0d0
        enddo
        if (itype(i).eq.ntyp1) cycle
        do j=nnt,nct
          if (j.eq.i. or. itype(j).eq.ntyp1) cycle
          dij=dist(c(1,i),c(1,j))
          dij0=0.5d0*(restok(itype(i))+restok(itype(j)))+1.0d0
          call gcont(dij,dij0,1.0d0,0.1d0,fcont,fprimcont)
          rnei(i)=rnei(i)+fcont
          if (fcont.gt.0.0d0) then
            nei(i)=nei(i)+1
            inei(nei(i),i)=j
            rneiprim(nei(i))=fprimcont
            dnei_inv(nei(i),i)=1.0d0/dij
          endif
        enddo
        x=2*(rnei(i)-rnei_mid_bound)/(rnei_max_bound-rnei_min_bound)
        if (x.gt.0.0d0) then
          call Gbounds(x,xx,xprim,1.0d-2)
        else
          call Gbounds(-x,xx,xprim,1.0d-2)
          xx=-xx  
        endif 
c        write (iout,*) "rnei",rnei(i)," x",x," xx",xx
        rnei(i)=rnei_mid_bound+(rnei_max_bound-rnei_min_bound)*xx/2
        radtab(i)=restok(itype(i))/scal_rad
     &    +sigmamax-(sigmamax-sigmamin)*(xx+1.0d0)/2
        do j=1,nei(i)
          radtabprim(j,i)=-(sigmamax-sigmamin)/
     &        (rnei_max_bound-rnei_min_bound)*xprim*rneiprim(j)
        enddo 
#ifdef DEBUG
        write (iout,'(a3,i6,f8.3,f8.3,f8.3)') 
     &    restyp(itype(i)),i,rnei(i),restok(itype(i)),radtab(i)
        write (iout,'(i4,5x,20i4)') nei(i),(inei(j,i),j=1,nei(i))
        write (iout,'(10f8.5)') (rneiprim(j),j=1,nei(i))
        write (iout,'(10f8.5)') (radtabprim(j,i),j=1,nei(i))
#endif
      enddo
      do i=iatsc_s,iatsc_e
       if (itype(i).eq.ntyp1) cycle
       do iint=1,nint_gr(i)
         do j=istart(i,iint),iend(i,iint)
           if (itype(j).eq.ntyp1) cycle
           dijCACA=dist(c(1,i),c(1,j))
           sigma2CACA=4*dijCACA**2/(radtab(i)+radtab(j))**2
c           write (iout,*) "scal_rad",scal_rad," restok",restok(itype(j))
c     &       ,restok(itype(i)),"sigma",1.0d0/dsqrt(sigma2CACA)
           IF (saxs_cutoff.eq.0.0d0) THEN
           do k=1,nsaxs
             dk = distsaxs(k)
             diffd = dlog(dijCACA)-dlog(dk)
             expCACA = dexp(-0.5d0*sigma2CACA*diffd**2)
             Pcalc(k) = Pcalc(k)+expCACA
             CACAgrad = sigma2CACA*diffd*(diffd+1.0d0)/dijCACA*expCACA
             CACAgrad1 = -sigma2CACA/(radtab(i)+radtab(j))
     &        *diffd*diffd*expCACA
c             CACAgrad1=0.0d0
             do l=1,3
               aux = CACAgrad*(C(l,j)-C(l,i))/dijCACA
               PgradC(k,l,i) = PgradC(k,l,i)-aux
               PgradC(k,l,j) = PgradC(k,l,j)+aux
             enddo ! l
             do ii=1,nei(i)
               inii=inei(ii,i)
c               aux=CACAgrad1*radtabprim(ii,i)/dist(c(1,i),c(1,inii))
               aux=CACAgrad1*radtabprim(ii,i)*dnei_inv(ii,i)
c               write (iout,*) "ii",i,j,k,ii,inii,
c     &            dist(c(1,i),c(1,inii)),aux
               do l=1,3
                 PgradC(k,l,i)=PgradC(k,l,i)-aux*(C(l,inii)-C(l,i))
                PgradC(k,l,inii)=PgradC(k,l,inii)+aux*(C(l,inii)-C(l,i))
               enddo
             enddo
             do jj=1,nei(j)
               injj=inei(jj,j)
c               aux=CACAgrad1*radtabprim(jj,j)/dist(c(1,j),c(1,injj))
               aux=CACAgrad1*radtabprim(jj,j)*dnei_inv(jj,j)
c               write (iout,*) "jj",i,j,k,jj,injj,dist(c(1,i),
c     &            c(1,injj()),aux
               do l=1,3
                 PgradC(k,l,j)=PgradC(k,l,j)-aux*(C(l,injj)-C(l,j))
                PgradC(k,l,injj)=PgradC(k,l,injj)+aux*(C(l,injj)-C(l,j))
               enddo
             enddo
           enddo ! k
           ELSE
           rrr = saxs_cutoff*(restok(itype(i))+restok(itype(j)))/2
           do k=1,nsaxs
             dk = distsaxs(k)
             diffd = dlog(dijCACA)-dlog(dk)
c             write (2,*) "ijk",i,j,k
             sss2 = sscale2(dijCACA,rrr,dk,0.3d0)
             if (sss2.eq.0.0d0) cycle
             ssgrad2 = sscalgrad2(dijCACA,rrr,dk,0.3d0)
             if (energy_dec) write(iout,'(a4,3i5,8f10.4)') 
     &          'saxs',i,j,k,dijCACA,restok(itype(i)),restok(itype(j)),
     &          1.0d0/dsqrt(sigma2CACA),rrr,dk,sss2,ssgrad2
             expCACA = dexp(-0.5d0*sigma2CACA*diffd**2)*sss2
             Pcalc(k) = Pcalc(k)+expCACA
#ifdef DEBUG
             write(iout,*) "i j k Pcalc",i,j,Pcalc(k)
#endif
             CACAgrad = sigma2CACA*diffd*(diffd+1.0d0)/dijCACA*expCACA
     &            -ssgrad2*expCACA/sss2
             CACAgrad1 = -sigma2CACA/(radtab(i)+radtab(j))
     &        *diffd*diffd*expCACA
             do l=1,3
c CA CA 
               aux = CACAgrad*(C(l,j)-C(l,i))/dijCACA
               PgradC(k,l,i) = PgradC(k,l,i)-aux
               PgradC(k,l,j) = PgradC(k,l,j)+aux
             enddo ! l
             do ii=1,nei(i)
               inii=inei(ii,i)
c               aux=CACAgrad1*radtabprim(ii,i)/dist(c(1,i),c(1,inii))
               aux=CACAgrad1*radtabprim(ii,i)*dnei_inv(ii,i)
c               write (iout,*) "ii",i,j,k,ii,inii,
c     &           dist(c(1,i),c(1,inii)),aux
               do l=1,3
                 PgradC(k,l,i)=PgradC(k,l,i)-aux*(C(l,inii)-C(l,i))
                PgradC(k,l,inii)=PgradC(k,l,inii)+aux*(C(l,inii)-C(l,i))
               enddo
             enddo
             do jj=1,nei(j)
               injj=inei(jj,j)
c               aux=CACAgrad1*radtabprim(jj,j)/dist(c(1,j),c(1,injj))
               aux=CACAgrad1*radtabprim(jj,j)*dnei_inv(jj,j)
c               write (iout,*) "jj",i,j,k,jj,injj,
c     &          dist(c(1,i),c(1,injj)),aux
               do l=1,3
                 PgradC(k,l,j)=PgradC(k,l,j)-aux*(C(l,injj)-C(l,j))
                PgradC(k,l,injj)=PgradC(k,l,injj)+aux*(C(l,injj)-C(l,j))
               enddo
             enddo
           enddo ! k
           ENDIF
         enddo ! j
       enddo ! iint
      enddo ! i
c#ifdef TIMING
c      time_SAXS=time_SAXS+MPI_Wtime()-time01
c#endif
c      write (iout,*) "lllicz",lllicz
c#ifdef TIMING
c      time01=MPI_Wtime()
c#endif
#ifdef MPI
      if (nfgtasks.gt.1) then 
       call MPI_AllReduce(Pcalc(1),Pcalc_(1),nsaxs,MPI_DOUBLE_PRECISION,
     &    MPI_SUM,FG_COMM,IERR)
c        if (fg_rank.eq.king) then
          do k=1,nsaxs
            Pcalc(k) = Pcalc_(k)
          enddo
c        endif
c        call MPI_AllReduce(PgradC(k,1,1),PgradC_(k,1,1),3*maxsaxs*nres,
c     &    MPI_DOUBLE_PRECISION,MPI_SUM,FG_COMM,IERR)
c        if (fg_rank.eq.king) then
c          do i=1,nres
c            do l=1,3
c              do k=1,nsaxs
c                PgradC(k,l,i) = PgradC_(k,l,i)
c              enddo
c            enddo
c          enddo
c        endif
#ifdef ALLSAXS
c        call MPI_AllReduce(PgradX(k,1,1),PgradX_(k,1,1),3*maxsaxs*nres,
c     &    MPI_DOUBLE_PRECISION,MPI_SUM,FG_COMM,IERR)
c        if (fg_rank.eq.king) then
c          do i=1,nres
c            do l=1,3
c              do k=1,nsaxs
c                PgradX(k,l,i) = PgradX_(k,l,i)
c              enddo
c            enddo
c          enddo
c        endif
#endif
      endif
#endif
      Cnorm = 0.0d0
      do k=1,nsaxs
        Cnorm = Cnorm + Pcalc(k)
      enddo
#ifdef MPI
      if (fg_rank.eq.king) then
#endif
#ifdef DEBUG
      write (iout,*) "Comparison of calculated and exp SAXS profile."
      do k=1,nsaxs
        write (iout,'(f8.4,2f15.8)') distsaxs(k),Pcalc(k)/Cnorm,Psaxs(k)
      enddo
#endif
      Esaxs_constr = dlog(Cnorm)-wsaxs0
      do k=1,nsaxs
        if (Pcalc(k).gt.0.0d0) 
     &  Esaxs_constr = Esaxs_constr - Psaxs(k)*dlog(Pcalc(k)) 
#ifdef DEBUG
        write (iout,*) "k",k," Esaxs_constr",Esaxs_constr
#endif
      enddo
#ifdef DEBUG
      write (iout,*) "Cnorm",Cnorm," Esaxs_constr",Esaxs_constr
#endif
#ifdef MPI
      endif
#endif
      gsaxsC=0.0d0
      gsaxsX=0.0d0
      do i=nnt,nct
        do l=1,3
          auxC=0.0d0
          auxC1=0.0d0
          auxX=0.0d0
          auxX1=0.d0 
          do k=1,nsaxs
            if (Pcalc(k).gt.0) 
     &      auxC  = auxC +Psaxs(k)*PgradC(k,l,i)/Pcalc(k)
            auxC1 = auxC1+PgradC(k,l,i)
#ifdef ALLSAXS
            auxX  = auxX +Psaxs(k)*PgradX(k,l,i)/Pcalc(k)
            auxX1 = auxX1+PgradX(k,l,i)
#endif
          enddo
          gsaxsC(l,i) = auxC - auxC1/Cnorm
#ifdef ALLSAXS
          gsaxsX(l,i) = auxX - auxX1/Cnorm
#endif
c          write (iout,*) "l i",l,i," gradC",wsaxs*(auxC - auxC1/Cnorm),
c     *     " gradX",wsaxs*(auxX - auxX1/Cnorm)
c          write (iout,*) "l i",l,i," gradC",wsaxs*gsaxsC(l,i),
c     *     " gradX",wsaxs*gsaxsX(l,i)
        enddo
      enddo
#ifdef TIMING
#ifdef MPI
      time_SAXS=time_SAXS+MPI_Wtime()-time01
#else
       time_SAXS=time_SAXS+tcpu()
#endif
#endif
#ifdef DEBUG
      write (iout,*) "gsaxsc"
      do i=nnt,nct
        write (iout,'(i5,3e15.5)') i,(gsaxsc(j,i),j=1,3)
      enddo
#endif
#ifdef MPI
c      endif
#endif
      return
      end
c----------------------------------------------------------------------------
      subroutine e_saxsC(Esaxs_constr)
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include "mpif.h"
      include "COMMON.SETUP"
      integer IERR
#endif
      include 'COMMON.SBRIDGE'
      include 'COMMON.CHAIN'
      include 'COMMON.GEO'
      include 'COMMON.DERIV'
      include 'COMMON.LOCAL'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
c      include 'COMMON.MD'
#ifdef LANG0
#ifdef FIVEDIAG
      include 'COMMON.LANGEVIN.lang0.5diag'
#else
      include 'COMMON.LANGEVIN.lang0'
#endif
#else
      include 'COMMON.LANGEVIN'
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.SAXS'
      include 'COMMON.NAMES'
      include 'COMMON.TIME1'
      include 'COMMON.FFIELD'
c
      double precision Esaxs_constr
      integer i,iint,j,k,l
      double precision PgradC(3,maxres),PgradX(3,maxres),logPtot
#ifdef MPI
      double precision gsaxsc_(3,maxres),gsaxsx_(3,maxres),logPtot_
#endif
      double precision dk,dijCASPH,dijSCSPH,
     & sigma2CA,sigma2SC,expCASPH,expSCSPH,
     & CASPHgrad,SCSPHgrad,aux,auxC,auxC1,
     & auxX,auxX1,PcalcC
c  SAXS restraint penalty function
#ifdef DEBUG
      write(iout,*) "------- SAXS penalty function start -------"
      write (iout,*) "nsaxs",nsaxs

      do i=nnt,nct
        print *,MyRank,"C",i,(C(j,i),j=1,3)
      enddo
      do i=nnt,nct
        print *,MyRank,"CSaxs",i,(Csaxs(j,i),j=1,3)
      enddo
#endif
      Esaxs_constr = 0.0d0
      logPtot=0.0d0
      do j=isaxs_start,isaxs_end
        PcalcC=0.0d0
        do i=1,nres
          do l=1,3
            PgradC(l,i)=0.0d0
            PgradX(l,i)=0.0d0
          enddo
        enddo
        do i=nnt,nct
          if (itype(i).eq.ntyp1) cycle
          dijCASPH=0.0d0
          dijSCSPH=0.0d0
          do l=1,3
            dijCASPH=dijCASPH+(C(l,i)-Csaxs(l,j))**2
          enddo
          if (itype(i).ne.10) then
          do l=1,3
            dijSCSPH=dijSCSPH+(C(l,i+nres)-Csaxs(l,j))**2
          enddo
          endif
          sigma2CA=2.0d0/pstok**2
          sigma2SC=4.0d0/restok(itype(i))**2
          expCASPH = dexp(-0.5d0*sigma2CA*dijCASPH)
          expSCSPH = dexp(-0.5d0*sigma2SC*dijSCSPH)
          PcalcC = PcalcC+expCASPH+expSCSPH
#ifdef DEBUG
          write(*,*) "processor i j PcalcC",
     &       MyRank,i,j,dijCASPH,dijSCSPH, PcalcC
#endif
          CASPHgrad = sigma2CA*expCASPH
          SCSPHgrad = sigma2SC*expSCSPH
          do l=1,3
            aux = (C(l,i+nres)-Csaxs(l,j))*SCSPHgrad
            PgradX(l,i) = PgradX(l,i) + aux
            PgradC(l,i) = PgradC(l,i)+(C(l,i)-Csaxs(l,j))*CASPHgrad+aux
          enddo ! l
        enddo ! i
        do i=nnt,nct
          do l=1,3
            gsaxsc(l,i)=gsaxsc(l,i)+PgradC(l,i)/PcalcC
            gsaxsx(l,i)=gsaxsx(l,i)+PgradX(l,i)/PcalcC
          enddo
        enddo
        logPtot = logPtot - dlog(PcalcC) 
c        print *,"me",me,MyRank," j",j," logPcalcC",-dlog(PcalcC),
c     &    " logPtot",logPtot
      enddo ! j
#ifdef MPI
      if (nfgtasks.gt.1) then 
c        write (iout,*) "logPtot before reduction",logPtot
        call MPI_Reduce(logPtot,logPtot_,1,MPI_DOUBLE_PRECISION,
     &    MPI_SUM,king,FG_COMM,IERR)
        logPtot = logPtot_
c        write (iout,*) "logPtot after reduction",logPtot
        call MPI_Reduce(gsaxsC(1,1),gsaxsC_(1,1),3*nres,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERR)
        if (fg_rank.eq.king) then
          do i=1,nres
            do l=1,3
              gsaxsC(l,i) = gsaxsC_(l,i)
            enddo
          enddo
        endif
        call MPI_Reduce(gsaxsX(1,1),gsaxsX_(1,1),3*nres,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERR)
        if (fg_rank.eq.king) then
          do i=1,nres
            do l=1,3
              gsaxsX(l,i) = gsaxsX_(l,i)
            enddo
          enddo
        endif
      endif
#endif
      Esaxs_constr = logPtot
      return
      end
c----------------------------------------------------------------------------
      double precision function sscale2(r,r_cut,r0,rlamb)
      implicit none
      double precision r,gamm,r_cut,r0,rlamb,rr
      rr = dabs(r-r0)
c      write (2,*) "r",r," r_cut",r_cut," r0",r0," rlamb",rlamb
c      write (2,*) "rr",rr
      if(rr.lt.r_cut-rlamb) then
        sscale2=1.0d0
      else if(rr.le.r_cut.and.rr.ge.r_cut-rlamb) then
        gamm=(rr-(r_cut-rlamb))/rlamb
        sscale2=1.0d0+gamm*gamm*(2*gamm-3.0d0)
      else
        sscale2=0d0
      endif
      return
      end
C-----------------------------------------------------------------------
      double precision function sscalgrad2(r,r_cut,r0,rlamb)
      implicit none
      double precision r,gamm,r_cut,r0,rlamb,rr
      rr = dabs(r-r0)
      if(rr.lt.r_cut-rlamb) then
        sscalgrad2=0.0d0
      else if(rr.le.r_cut.and.rr.ge.r_cut-rlamb) then
        gamm=(rr-(r_cut-rlamb))/rlamb
        if (r.ge.r0) then
          sscalgrad2=gamm*(6*gamm-6.0d0)/rlamb
        else
          sscalgrad2=-gamm*(6*gamm-6.0d0)/rlamb
        endif
      else
        sscalgrad2=0.0d0
      endif
      return
      end

