      subroutine etotal(energia)
#ifdef _OPENMP
      use omp_lib
#endif
      use grid_arrays
      implicit none
      include 'DIMENSIONS'
#ifndef ISNAN
      external proc_proc
#ifdef WINPGI
cMS$ATTRIBUTES C ::  proc_proc
#endif
#endif
#ifdef MPI
      include "mpif.h"
      double precision weights_(n_ene)
      integer ierror,ierr
#else
      double precision tcpu
#endif
      double precision time00
      include 'COMMON.SETUP'
      include 'COMMON.IOUNITS'
      double precision energia(0:n_ene)
      include 'COMMON.LOCAL'
      include 'COMMON.FFIELD'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.SBRIDGE'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
c      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      include 'COMMON.CONTROL'
      include 'COMMON.TIME1'
      include 'COMMON.SPLITELE'
      include 'COMMON.TORCNSTR'
      include 'COMMON.SAXS'
      include 'COMMON.MD'
      include 'COMMON.ESCP'
      include 'COMMON.EGB'
      include 'COMMON.EELEC'
      include 'COMMON.GRID'
      include 'COMMON.OMP'
      include 'COMMON.NMR'
      double precision evdw,evdw1,evdw2,evdw2_14,ees,eel_loc,
     & eello_turn3,eello_turn4,edfadis,estr,ehpb,ebe,ethetacnstr,
     & escloc,etors,edihcnstr,etors_d,esccor,ecorr,ecorr5,ecorr6,eturn6,
     & eliptran,Eafmforce,Etube,
     & esaxs_constr,ehomology_constr,edfator,edfanei,edfabet
      integer n_corr,n_corr1
      integer max_threads
      logical limit_threads,need_lists
      double precision time01,time02
      character*20 czasy2
#ifdef MPI
c      print*,"ETOTAL Processor",fg_rank," absolute rank",myrank,
c     & " nfgtasks",nfgtasks
c-----------------
c        time02=MPI_Wtime()
!        CALL EXECUTE_COMMAND_LINE("date +%s%N",cmdmsg=czasy2)
c----------------
!        print *,"time diff processor",fg_rank
      if (nfgtasks.gt.1) then
        time00=MPI_Wtime()
C FG slaves call the following matching MPI_Bcast in ERGASTULUM
        if (fg_rank.eq.0) then
          call MPI_Bcast(0,1,MPI_INTEGER,king,FG_COMM,IERROR)
c          print *,"Processor",myrank," BROADCAST iorder"
C FG master sets up the WEIGHTS_ array which will be broadcast to the
C FG slaves as WEIGHTS array.
          weights_(1)=wsc
          weights_(2)=wscp
          weights_(3)=welec
          weights_(4)=wcorr
          weights_(5)=wcorr5
          weights_(6)=wcorr6
          weights_(7)=wel_loc
          weights_(8)=wturn3
          weights_(9)=wturn4
          weights_(10)=wturn6
          weights_(11)=wang
          weights_(12)=wscloc
          weights_(13)=wtor
          weights_(14)=wtor_d
          weights_(15)=wstrain
          weights_(16)=wvdwpp
          weights_(17)=wbond
          weights_(18)=scal14
          weights_(21)=wsccor
          weights_(22)=wliptran
          weights_(25)=wtube
          weights_(26)=wsaxs
          weights_(28)=wdfa_dist
          weights_(29)=wdfa_tor
          weights_(30)=wdfa_nei
          weights_(31)=wdfa_beta
C FG Master broadcasts the WEIGHTS_ array
          call MPI_Bcast(weights_(1),n_ene,
     &        MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
        else
C FG slaves receive the WEIGHTS array
          call MPI_Bcast(weights(1),n_ene,
     &        MPI_DOUBLE_PRECISION,king,FG_COMM,IERROR)
          wsc=weights(1)
          wscp=weights(2)
          welec=weights(3)
          wcorr=weights(4)
          wcorr5=weights(5)
          wcorr6=weights(6)
          wel_loc=weights(7)
          wturn3=weights(8)
          wturn4=weights(9)
          wturn6=weights(10)
          wang=weights(11)
          wscloc=weights(12)
          wtor=weights(13)
          wtor_d=weights(14)
          wstrain=weights(15)
          wvdwpp=weights(16)
          wbond=weights(17)
          scal14=weights(18)
          wsccor=weights(21)
          wliptran=weights(22)
          wtube=weights(25)
          wsaxs=weights(26)
          wdfa_dist=weights(28)
          wdfa_tor=weights(29)
          wdfa_nei=weights(30)
          wdfa_beta=weights(31)
        endif
        time_Bcast=time_Bcast+MPI_Wtime()-time00
        time_Bcastw=time_Bcastw+MPI_Wtime()-time00
c        call chainbuild_cart
      endif
      call zerograd
      if (nfgtasks.gt.1) then
        call MPI_Bcast(itime_mat,1,MPI_INTEGER,king,FG_COMM,IERROR)
        call MPI_Bcast(atimeave,1,MPI_INTEGER,king,FG_COMM,IERROR)
      endif
#else
      call zerograd
c      if (modecalc.eq.12.or.modecalc.eq.14) then
c        call int_from_cart1(.false.)
c      endif
#endif
c      write (iout,*) "itime_mat",itime_mat," imatupdate",imatupdate
      call place_coords_in_box
c      evdw=0.0d0
c      goto 107
      call check_list_needed(itime_mat,imatupdate,need_lists)
      !if (mod(itime_mat,imatupdate).eq.0) then
      if (need_lists) then
#ifdef TIMING_ENE
#ifdef MPI
        time01=MPI_Wtime()
#else
        time01=tcpu()
#endif
#endif
        call calculate_grids

        call make_inter_list(iatscp_s,iatscp_e,nscp_gr,iscpstart,
     &   iscpend,
     &   cp(1,1),c_tobox(1,1),abs_itel,abs_itype,2,
     &   g_listscp_start,g_listscp_end,newcontlistscpi,
     &   newcontlistscpj,positive_sc,positive_p,
     &   gridcellsc,dgridrangep,griddatap)
c        call make_SCp_inter_list
c        write (iout,*) "Finished make_SCp_inter_list"
c        call flush(iout)
        call make_inter_list(iatsc_s,iatsc_e,nint_gr,istart,iend,
     &   c_tobox(1,nres+1),c_tobox(1,nres+1),abs_itype,abs_itype,1,
     &   g_listscsc_start,g_listscsc_end,newcontlisti,newcontlistj,
     &   positive_pn,positive_pn,
     &   gridcellpn,dgridrangepn,griddatapn)
c        call make_SCSC_inter_list
c        write (iout,*) "Finished make_SCSC_inter_list"
c        call flush(iout)
        call make_inter_list(iatel_s,iatel_e,nint_gr_el,ielstart,ielend,
     &   cp(1,1),cp(1,1),abs_itel,abs_itel,3,
     &   g_listpp_start,g_listpp_end,newcontlistppi,newcontlistppj,
     &   positive_sc,positive_sc,
     &   gridcellsc,dgridrangesc,griddatasc)
c        call make_pp_inter_list
c        write (iout,*) "Finished make_pp_inter_list"
c        call flush(iout)
c        call make_pp_vdw_inter_list
c        write (iout,*) "Finished make_pp_vdw_inter_list"
c        call flush(iout)

#ifdef _OPENMP
      max_threads=omp_get_max_threads()
#else
      max_threads=1
#endif
      scp_threads=max_threads
      call split_list_for_threads(scp_from_ik,scp_to_ik,
     &                            scp_first_blk,scp_last_blk,
     &                            scp_first_j,scp_last_j,
     &                            max_fg_threads,scp_threads,
     &                            g_listscp_start,g_listscp_end,
     &                            newcontlistscpi,10*maxres,
     &                            newcontlistscpj,maxint_res*maxres,
     &                            0,scp_limit_threads)

      scsc_threads=max_threads
      call split_list_for_threads(scsc_from_ik,scsc_to_ik,
     &                            scsc_first_blk,scsc_last_blk,
     &                            scsc_first_j,scsc_last_j,
     &                            max_fg_threads,scsc_threads,
     &                            g_listscsc_start,g_listscsc_end,
     &                            newcontlisti,10*maxres,
     &                            newcontlistj,maxint_res*maxres,
     &                            0,scsc_limit_threads)
!    &                            2*max_threads,scsc_limit_threads)

      pp_threads=max_threads
      call split_list_for_threads(pp_from_ik,pp_to_ik,
     &                            pp_first_blk,pp_last_blk,
     &                            pp_first_j,pp_last_j,
     &                            max_fg_threads,pp_threads,
     &                            g_listpp_start,g_listpp_end,
     &                            newcontlistppi,10*maxres,
     &                            newcontlistppj,maxint_res*maxres,
     &                            0,pp_limit_threads)
!    &                            4*max_threads,pp_limit_threads)


#ifdef TIMING_ENE
#ifdef MPI
        time_list=time_list+MPI_Wtime()-time01
#else
        time_list=tcpu()-time01
#endif
c        write (iout,*) "time_list",time_list
#endif
      endif
c      print *,'Processor',myrank,' calling etotal ipot=',ipot
c      print *,'Processor',myrank,' nnt=',nnt,' nct=',nct
#ifdef TIMING
#ifdef MPI
      time00=MPI_Wtime()
#else
      time00=tcpu()
#endif
#endif

#ifndef DFA
      edfadis=0.0d0
      edfator=0.0d0
      edfanei=0.0d0
      edfabet=0.0d0
#endif
C
C Compute the side-chain and electrostatic interaction energy
C
C      print *,ipot
#ifdef TIMING_ENE
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
      call calculate_lipid_layers
      !call update_lipaq

      goto (101,102,103,104,105,106) ipot
C Lennard-Jones potential.
  101 call elj(evdw)
cd    print '(a)','Exit ELJ'
      goto 107
C Lennard-Jones-Kihara potential (shifted).
  102 call eljk(evdw)
      goto 107
C Berne-Pechukas potential (dilated LJ, angular dependence).
  103 call ebp(evdw)
      goto 107
C Gay-Berne potential (shifted LJ, angular dependence).
  104 call egb(evdw)
C      print *,"bylem w egb"
      goto 107
C Gay-Berne-Vorobjev potential (shifted LJ, angular dependence).
  105 call egbv(evdw)
      goto 107
C Soft-sphere potential
  106 call e_softsphere(evdw)
C
C Calculate electrostatic (H-bonding) energy of the main chain.
C
  107 continue
#ifdef TIMING_ENE
#ifdef MPI
      time_evdw=time_evdw+MPI_Wtime()-time01
#else
      time_evdw=tcpu()
#endif
#endif
#ifdef DFA
C     BARTEK for dfa test!
c      print *,"Processors",MyRank," wdfa",wdfa_dist
      if (wdfa_dist.gt.0) then
        call edfad(edfadis)
c        print *,"Processors",MyRank," edfadis",edfadis
      else
        edfadis=0
      endif
c      print*, 'edfad is finished!', edfadis
      if (wdfa_tor.gt.0) then
        call edfat(edfator)
      else
        edfator=0
      endif
c      print*, 'edfat is finished!', edfator
      if (wdfa_nei.gt.0) then
        call edfan(edfanei)
      else
        edfanei=0
      endif
c      print*, 'edfan is finished!', edfanei
      if (wdfa_beta.gt.0) then
        call edfab(edfabet)
      else
        edfabet=0
      endif
#endif
#ifdef TIMING
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
      call loc_prep
#ifdef TIMING
#ifdef MPI
      time_loc=time_loc+MPI_Wtime()-time01
      time01=MPI_Wtime()
#else
      time_loc=time_loc+tcpu()-time01
      time01=tcpu()
#endif
#endif
      call vec_and_deriv
#ifdef TIMING
#ifdef MPI
      time_vec=time_vec+MPI_Wtime()-time01
#else
      time_vec=time_vec+tcpu()-time01
#endif
#endif
#ifdef TIMING_ENE
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
#ifdef SHIELD
C Introduction of shielding effect first for each peptide group
C the shielding factor is set this factor is describing how each
C peptide group is shielded by side-chains
C the matrix - shield_fac(i) the i index describe the ith between i and i+1
C      write (iout,*) "shield_mode",shield_mode
      if (shield_mode.eq.1) then
       call set_shield_fac
      else if  (shield_mode.eq.2) then
       call set_shield_fac2
      endif
#endif
c      print *,"Processor",myrank," left VEC_AND_DERIV"
      if (ipot.lt.6) then
#ifdef SPLITELE
         if (welec.gt.0d0.or.wvdwpp.gt.0d0.or.wel_loc.gt.0d0.or.
     &       wturn3.gt.0d0.or.wturn4.gt.0d0 .or. wcorr.gt.0.0d0
     &       .or. wcorr4.gt.0.0d0 .or. wcorr5.gt.0.d0
     &       .or. wcorr6.gt.0.0d0 .or. wturn6.gt.0.0d0 ) then
#else
         if (welec.gt.0d0.or.wel_loc.gt.0d0.or.
     &       wturn3.gt.0d0.or.wturn4.gt.0d0 .or. wcorr.gt.0.0d0
     &       .or. wcorr4.gt.0.0d0 .or. wcorr5.gt.0.d0
     &       .or. wcorr6.gt.0.0d0 .or. wturn6.gt.0.0d0 ) then
#endif
            call eelec(ees,evdw1,eel_loc,eello_turn3,eello_turn4)
         else
            ees=0.0d0
            evdw1=0.0d0
            eel_loc=0.0d0
            eello_turn3=0.0d0
            eello_turn4=0.0d0
         endif
      else
        write (iout,*) "Soft-spheer ELEC potential"
c        call eelec_soft_sphere(ees,evdw1,eel_loc,eello_turn3,
c     &   eello_turn4)
      endif
#ifdef TIMING_ENE
#ifdef MPI
      time_eelec=time_eelec+MPI_Wtime()-time01
#else
      time_eelec=time_eelec+tcpu()-time01
#endif
#endif
c#ifdef TIMING
c      time_enecalc=time_enecalc+MPI_Wtime()-time00
c#endif
c      print *,"Processor",myrank," computed UELEC"
C
C Calculate excluded-volume interaction energy between peptide groups
C and side chains.
C
#ifdef TIMING_ENE
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
      if (ipot.lt.6) then
       if(wscp.gt.0d0) then
        call escp(evdw2,evdw2_14)
       else
        evdw2=0
        evdw2_14=0
       endif
      else
c        write (iout,*) "Soft-sphere SCP potential"
        call escp_soft_sphere(evdw2,evdw2_14)
      endif
#ifdef TIMING_ENE
#ifdef MPI
      time_escp=time_escp+MPI_Wtime()-time01
#else
      time_escp=time_escp+tcpu()-time01
#endif
#endif
c
c Calculate the bond-stretching energy
c
      call ebond(estr)
C
C Calculate the disulfide-bridge and other energy and the contributions
C from other distance constraints.
cd      write (iout,*) 'Calling EHPB'
cd      write (iout,*) "Calling edis: energy_p_new_barrier"
      call edis(ehpb)
cd      write (iout,*) 'EHPB exitted succesfully.'
cd      call flush(iout)
C
C Calculate the virtual-bond-angle energy.
C
      if (wang.gt.0d0) then
       if (tor_mode.eq.0) then
         call ebend(ebe)
       else
C ebend kcc is Kubo cumulant clustered rigorous attemp to derive the
C energy function
         call ebend_kcc(ebe)
       endif
      else
        ebe=0.0d0
      endif
      ethetacnstr=0.0d0
      if (with_theta_constr) call etheta_constr(ethetacnstr)
c      print *,"Processor",myrank," computed UB"
C
C Calculate the SC local energy.
C
C      print *,"TU DOCHODZE?"
      call esc(escloc)
c      print *,"Processor",myrank," computed USC"
C
C Calculate the virtual-bond torsional energy.
C
cd    print *,'nterm=',nterm
C      print *,"tor",tor_mode
      if (wtor.gt.0.0d0) then
         if (tor_mode.eq.0) then
           call etor(etors)
         else
C etor kcc is Kubo cumulant clustered rigorous attemp to derive the
C energy function
           call etor_kcc(etors)
         endif
      else
        etors=0.0d0
      endif
      edihcnstr=0.0d0
      if (ndih_constr.gt.0) call etor_constr(edihcnstr)
c      print *,"Processor",myrank," computed Utor"
      if (constr_homology.ge.1) then
        call e_modeller(ehomology_constr)
c        print *,'iset=',iset,'me=',me,ehomology_constr,
c     &  'Processor',fg_rank,' CG group',kolor,
c     &  ' absolute rank',MyRank
      else
        ehomology_constr=0.0d0
      endif
C
C 6/23/01 Calculate double-torsional energy
C
      if ((wtor_d.gt.0.0d0).and.(tor_mode.eq.0)) then
        call etor_d(etors_d)
      else
        etors_d=0
      endif
c      print *,"Processor",myrank," computed Utord"
C
C 21/5/07 Calculate local sicdechain correlation energy
C
      if (wsccor.gt.0.0d0) then
        call eback_sc_corr(esccor)
      else
        esccor=0.0d0
      endif
      ecorr=0.0d0
      ecorr5=0.0d0
      ecorr6=0.0d0
      eturn6=0.0d0
c      print *,"Processor",myrank," computed Ucorr"
c      write (iout,*) "nsaxs",nsaxs," saxs_mode",saxs_mode
      if (nsaxs.gt.0 .and. saxs_mode.eq.0) then
        call e_saxs(Esaxs_constr)
c        write (iout,*) "From Esaxs: Esaxs_constr",Esaxs_constr
      else if (nsaxs.gt.0 .and. saxs_mode.gt.0) then
        call e_saxsC(Esaxs_constr)
c        write (iout,*) "From EsaxsC: Esaxs_constr",Esaxs_constr
      else
        Esaxs_constr = 0.0d0
      endif
C
C If performing constraint dynamics, call the constraint energy
C  after the equilibration time
c      if(usampl.and.totT.gt.eq_time) then
c      write (iout,*) "usampl",usampl
      if(usampl) then
         call EconstrQ
         if (loc_qlike) then
           call Econstr_back_qlike
         else
           call Econstr_back
         endif
      else
         Uconst=0.0d0
         Uconst_back=0.0d0
      endif
C 01/27/2015 added by adasko
C the energy component below is energy transfer into lipid environment
C based on partition function
C      print *,"przed lipidami"
      if (wliptran.gt.0) then
        call Eliptransfer(eliptran)
      else
        eliptran=0.0d0
      endif
C      print *,"za lipidami"
      if (AFMlog.gt.0) then
        call AFMforce(Eafmforce)
      else if (selfguide.gt.0) then
        call AFMvel(Eafmforce)
      else
        Eafmforce=0.0d0
      endif
      if (TUBElog.eq.1) then
C      print *,"just before call"
        call calctube(Etube)
      elseif (TUBElog.eq.2) then
        call calctube2(Etube)
      else
        Etube=0.0d0
      endif

#ifdef TIMING
#ifdef MPI
      time_enecalc=time_enecalc+MPI_Wtime()-time00
#else
      time_enecalc=time_enecalc+tcpu()-time00
#endif
#endif
c      print *,"Processor",myrank," computed Uconstr"
#ifdef TIMING
#ifdef MPI
      time00=MPI_Wtime()
#else
      time00=tcpu()
#endif
#endif
c
C Sum the energies
C
      energia(1)=evdw
#ifdef SCP14
      energia(2)=evdw2-evdw2_14
      energia(18)=evdw2_14
#else
      energia(2)=evdw2
      energia(18)=0.0d0
#endif
#ifdef SPLITELE
      energia(3)=ees
      energia(16)=evdw1
#else
      energia(3)=ees+evdw1
      energia(16)=0.0d0
#endif
      energia(4)=ecorr
      energia(5)=ecorr5
      energia(6)=ecorr6
      energia(7)=eel_loc
      energia(8)=eello_turn3
      energia(9)=eello_turn4
      energia(10)=eturn6
      energia(11)=ebe
      energia(12)=escloc
      energia(13)=etors
      energia(14)=etors_d
      energia(15)=ehpb
      energia(19)=edihcnstr
      energia(17)=estr
      energia(20)=Uconst+Uconst_back
      energia(21)=esccor
      energia(22)=eliptran
      energia(23)=Eafmforce
      energia(24)=ethetacnstr
      energia(25)=Etube
      energia(26)=Esaxs_constr
      energia(27)=ehomology_constr
      energia(28)=edfadis
      energia(29)=edfator
      energia(30)=edfanei
      energia(31)=edfabet
c      write (iout,*) "esaxs_constr",energia(26)
c    Here are the energies showed per procesor if the are more processors
c    per molecule then we sum it up in sum_energy subroutine
c      print *," Processor",myrank," calls SUM_ENERGY"
      call sum_energy(energia,.true.)
c      write (iout,*) "After sum_energy: esaxs_constr",energia(26)
      if (dyn_ss) call dyn_set_nss
c      print *," Processor",myrank," left SUM_ENERGY"
#ifdef TIMING
#ifdef MPI
      time_sumene=time_sumene+MPI_Wtime()-time00
#else
      time_sumene=time_sumene+tcpu()-time00
#endif
#endif
c---------------------
c#ifdef MPI
c      time_enecalc=time_enecalc+MPI_Wtime()-time02
c#else
c      time_enecalc=time_enecalc+tcpu()-time02
c#endif
c--------------------
      return
      end
c-------------------------------------------------------------------------------
      subroutine sum_energy(energia,reduce)
      implicit none
      include 'DIMENSIONS'
#ifndef ISNAN
      external proc_proc
#ifdef WINPGI
cMS$ATTRIBUTES C ::  proc_proc
#endif
#endif
#ifdef MPI
      include "mpif.h"
      integer ierr
      double precision time00
#endif
      include 'COMMON.SETUP'
      include 'COMMON.IOUNITS'
      double precision energia(0:n_ene),enebuff(0:n_ene+1)
      include 'COMMON.FFIELD'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.SBRIDGE'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.CONTROL'
      include 'COMMON.TIME1'
      logical reduce
      integer i
      double precision evdw,evdw1,evdw2,evdw2_14,ees,eel_loc,
     & eello_turn3,eello_turn4,edfadis,estr,ehpb,ebe,ethetacnstr,
     & escloc,etors,edihcnstr,etors_d,esccor,ecorr,ecorr5,ecorr6,eturn6,
     & eliptran,Eafmforce,Etube,
     & esaxs_constr,ehomology_constr,edfator,edfanei,edfabet
      double precision Uconst,etot
#ifdef MPI
      if (nfgtasks.gt.1 .and. reduce) then
#ifdef DEBUG
        write (iout,*) "energies before REDUCE"
        call enerprint(energia)
        call flush(iout)
#endif
        do i=0,n_ene
          enebuff(i)=energia(i)
        enddo
        time00=MPI_Wtime()
        call MPI_Barrier(FG_COMM,IERR)
        time_barrier_e=time_barrier_e+MPI_Wtime()-time00
        time00=MPI_Wtime()
        call MPI_Reduce(enebuff(0),energia(0),n_ene+1,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERR)
#ifdef DEBUG
        write (iout,*) "energies after REDUCE"
        call enerprint(energia)
        call flush(iout)
#endif
        time_Reduce=time_Reduce+MPI_Wtime()-time00
      endif
      if (fg_rank.eq.0) then
#endif
      evdw=energia(1)
#ifdef SCP14
      evdw2=energia(2)+energia(18)
      evdw2_14=energia(18)
#else
      evdw2=energia(2)
#endif
#ifdef SPLITELE
      ees=energia(3)
      evdw1=energia(16)
#else
      ees=energia(3)
      evdw1=0.0d0
#endif
      ecorr=energia(4)
      ecorr5=energia(5)
      ecorr6=energia(6)
      eel_loc=energia(7)
      eello_turn3=energia(8)
      eello_turn4=energia(9)
      eturn6=energia(10)
      ebe=energia(11)
      escloc=energia(12)
      etors=energia(13)
      etors_d=energia(14)
      ehpb=energia(15)
      edihcnstr=energia(19)
      estr=energia(17)
      Uconst=energia(20)
      esccor=energia(21)
      eliptran=energia(22)
      Eafmforce=energia(23)
      ethetacnstr=energia(24)
      Etube=energia(25)
      esaxs_constr=energia(26)
      ehomology_constr=energia(27)
      edfadis=energia(28)
      edfator=energia(29)
      edfanei=energia(30)
      edfabet=energia(31)
#ifdef SPLITELE
      etot=wsc*evdw+wscp*evdw2+welec*ees+wvdwpp*evdw1
     & +wang*ebe+wtor*etors+wscloc*escloc
     & +wstrain*ehpb+wcorr*ecorr+wcorr5*ecorr5
     & +wcorr6*ecorr6+wturn4*eello_turn4+wturn3*eello_turn3
     & +wturn6*eturn6+wel_loc*eel_loc+edihcnstr+wtor_d*etors_d
     & +wbond*estr+wumb*Uconst+wsccor*esccor+wliptran*eliptran+Eafmforce
     & +ethetacnstr+wtube*Etube+wsaxs*esaxs_constr+ehomology_constr
     & +wdfa_dist*edfadis+wdfa_tor*edfator+wdfa_nei*edfanei
     & +wdfa_beta*edfabet
#else
      etot=wsc*evdw+wscp*evdw2+welec*(ees+evdw1)
     & +wang*ebe+wtor*etors+wscloc*escloc
     & +wstrain*ehpb+wcorr*ecorr+wcorr5*ecorr5
     & +wcorr6*ecorr6+wturn4*eello_turn4+wturn3*eello_turn3
     & +wturn6*eturn6+wel_loc*eel_loc+edihcnstr+wtor_d*etors_d
     & +wbond*estr+wumb*Uconst+wsccor*esccor+wliptran*eliptran
     & +Eafmforce
     & +ethetacnstr+wtube*Etube+wsaxs*esaxs_constr+ehomology_constr
     & +wdfa_dist*edfadis+wdfa_tor*edfator+wdfa_nei*edfanei
     & +wdfa_beta*edfabet
#endif
      energia(0)=etot
c detecting NaNQ
#ifdef ISNAN
#ifdef AIX
      if (isnan(etot).ne.0) energia(0)=1.0d+99
#else
      if (isnan(etot)) energia(0)=1.0d+99
#endif
#else
      i=0
#ifdef WINPGI
      idumm=proc_proc(etot,i)
#else
      call proc_proc(etot,i)
#endif
      if(i.eq.1)energia(0)=1.0d+99
#endif
#ifdef MPI
      endif
#endif
      return
      end
c-------------------------------------------------------------------------------
      subroutine fmadd1(cnt,trg,a,src)
      implicit none
      integer i,cnt
      double precision a
      double precision trg(1:cnt)
      double precision src(1:cnt)
      if(a.ne.0.0d0) then
        do i=1,cnt
          trg(i)=trg(i)+a*src(i)
        enddo
      endif
      return
      end
c-------------------------------------------------------------------------------
      subroutine fmadd3(cnt,trg,a,src)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.DERIV'
      integer cnt
      double precision a
      double precision trg(3,1:cnt)
      double precision src(3,1:cnt)
      call fmadd1(cnt*3,trg(1,1),a,src(1,1))
      return
      end
c-------------------------------------------------------------------------------
      subroutine fmadd1pair(cnt,trg,a,src1,src2)
      implicit none
      integer i,cnt
      double precision a
      double precision trg(1:cnt)
      double precision src1(1:cnt)
      double precision src2(1:cnt)
      if(a.ne.0.0d0) then
        do i=1,cnt
          trg(i)=trg(i)+a*(src1(i)+src2(i))
        enddo
      endif
      return
      end
c-------------------------------------------------------------------------------
      subroutine fmadd3pair(cnt,trg,a,src1,src2)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.DERIV'
      integer cnt
      double precision a
      double precision trg(3,1:cnt)
      double precision src1(3,1:cnt)
      double precision src2(3,1:cnt)
      call fmadd1pair(cnt*3,trg(1,1),a,src1(1,1),src2(1,1))
      return
      end
c-------------------------------------------------------------------------------
      subroutine sum_gradient
#ifdef _OPENMP
      use omp_lib
#endif
      implicit none
      include 'DIMENSIONS'
#ifndef ISNAN
      external proc_proc
#ifdef WINPGI
cMS$ATTRIBUTES C ::  proc_proc
#endif
#endif
#ifdef MPI
      include 'mpif.h'
      integer ierror,ierr
#else
      double precision tcpu
#endif
      double precision time00,time01
      double precision gradbufc(3,-1:maxres),gradbufx(3,-1:maxres),
     &                 glocbuf(4*maxres),gradbufc_sum(3,-1:maxres),
     &                 gloc_scbuf(3,-1:maxres)
      include 'COMMON.SETUP'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.SBRIDGE'
      include 'COMMON.CHAIN'
      include 'COMMON.VAR'
      include 'COMMON.CONTROL'
      include 'COMMON.TIME1'
      include 'COMMON.MAXGRAD'
      include 'COMMON.SCCOR'
c      include 'COMMON.MD'
      include 'COMMON.QRESTR'
      !include 'COMMON.LOCAL'
      integer i,j,k
      integer range_lo,range_hi,from,from2,to,my_thread,threads_used
      double precision scalar
      double precision gvdwc_norm,gvdwc_scp_norm,gelc_norm,gvdwpp_norm,
     &gradb_norm,ghpbc_norm,gradcorr_norm,gel_loc_norm,gcorr3_turn_norm,
     &gcorr4_turn_norm,gradcorr5_norm,gradcorr6_norm,
     &gcorr6_turn_norm,gsccorrc_norm,gscloc_norm,gvdwx_norm,
     &gradx_scp_norm,ghpbx_norm,gradxorr_norm,gsccorrx_norm,
     &gsclocx_norm
      common /sumgradientcommon/ gradbufc,gradbufx,glocbuf,
     &                           gradbufc_sum,gloc_scbuf
#ifdef TIMING
#ifdef MPI
      time01=MPI_Wtime()
#else
      time01=tcpu()
#endif
#endif
      gradbufc(:,nct+1:nres)=0.0d0
      gradbufx(:,nct+1:nres)=0.0d0
      gradbufc_sum(:,nct+1:nres)=0.0d0
      gloc_scbuf(:,nct+1:nres)=0.0d0
#ifdef DEBUG
      write (iout,*) "sum_gradient gvdwc, gvdwx"
      do i=1,nres
        write (iout,'(i3,3f10.5,5x,3f10.5,5x,f10.5)')
     &   i,(gvdwx(j,i),j=1,3),(gvdwc(j,i),j=1,3)
      enddo
      call flush(iout)
      write (iout,*) "sum_gradient gelc, gelc_long"
      do i=1,nres
        write (iout,'(i3,3f10.5,5x,3f10.5,5x,f10.5)') 
     &   i,(gelc(j,i),j=1,3),(gelc_long(j,i),j=1,3)
      enddo
      call flush(iout)
      write (iout,*) "sum_gradient gel_loc, gel_loc_long"
      do i=1,nres
        write (iout,'(i3,3f10.5,5x,3f10.5,5x,f10.5)') 
     &   i,(gel_loc(j,i),j=1,3),(gel_loc_long(j,i),j=1,3)
      enddo
      call flush(iout)
      write (iout,*) "sum_gradient gvdwpp"
      do i=1,nres
        write (iout,'(i3,3f10.5,5x,3f10.5,5x,f10.5)') 
     &   i,(gvdwpp(j,i),j=1,3)
      enddo
      call flush(iout)
#endif
#ifdef DEBUG
      write (iout,*) "sum_gradient gsaxsc, gsaxsx"
      do i=0,nres
        write (iout,'(i3,3e15.5,5x,3e15.5)')
     &        i,(gsaxsc(j,i),j=1,3),(gsaxsx(j,i),j=1,3)
      enddo
      call flush(iout)
#endif

      !range_lo=0
      !range_hi=nct
#ifdef _OPENMP
      threads_used=omp_get_max_threads()
#else
      threads_used=1
#endif
c      if (threads_used.eq.0)print *,"1 MyRank threads_used",threads_used

#ifdef MPI
C FG slaves call the following matching MPI_Bcast in ERGASTULUM
      if (nfgtasks.gt.1 .and. fg_rank.eq.0)
     &  call MPI_Bcast(1,1,MPI_INTEGER,king,FG_COMM,IERROR)
#endif
C
C 9/29/08 AL Transform parts of gradients in site coordinates to the gradient
C            in virtual-bond-vector coordinates
C
#ifdef DEBUG
c      write (iout,*) "gel_loc gel_loc_long and gel_loc_loc"
c      do i=1,nres-1
c        write (iout,'(i5,3f10.5,2x,3f10.5,2x,f10.5)')
c     &   i,(gel_loc(j,i),j=1,3),(gel_loc_long(j,i),j=1,3),gel_loc_loc(i)
c      enddo
c      write (iout,*) "gel_loc_tur3 gel_loc_turn4"
c      do i=1,nres-1
c        write (iout,'(i5,3f10.5,2x,f10.5)')
c     &  i,(gcorr4_turn(j,i),j=1,3),gel_loc_turn4(i)
c      enddo
      write (iout,*) "gradcorr5 gradcorr5_long gradcorr5_loc"
      do i=1,nres
        write (iout,'(i3,3f10.5,5x,3f10.5,5x,f10.5)')
     &   i,(gradcorr5(j,i),j=1,3),(gradcorr5_long(j,i),j=1,3),
     &   g_corr5_loc(i)
      enddo
      call flush(iout)
#endif
#ifdef DEBUG
      write (iout,*) "gsaxsc"
      do i=1,nres
        write (iout,'(i3,3f10.5)') i,(wsaxs*gsaxsc(j,i),j=1,3)
      enddo
      call flush(iout)
#endif

!$OMP PARALLEL NUM_THREADS(threads_used) DEFAULT(SHARED)
!$OMP& PRIVATE(k,from,from2,to,my_thread)
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif
#ifdef GRAD_NAN_CHECK
      do i=1,nres
      if (isnan(gvdwc(1,i))) write(*,*) MyRank," NaN in gvdwc",i
      if (isnan(gvdwc_scpp(1,i)))write(*,*)MyRank," NaN in gvdwc_scpp",i
      if (isnan(gelc_long(1,i))) write(*,*) MyRank," NaN in gelc_long",i
      if (isnan(gvdwpp(1,i))) write(*,*) MyRank," NaN in gvdwpp",i
      if (isnan(gradb(1,i))) write(*,*) MyRank," NaN in gradb",i
      if (isnan(gel_loc_long(1,i))) write(*,*) 
     & MyRank," NaN in gel_loc_long",i
      if (isnan(gradcorr_long(1,i)))write(*,*)
     & MyRank,"NaN in gradcorr_long",i
      if (isnan(gradcorr_long(1,i)))write(*,*)
     & MyRank," NaN in gradcorr_long",i
      if (isnan(gradcorr5_long(1,i)))write(*,*)
     & MyRank," NaN in gradcorr5_long",i
      if (isnan(gradcorr6_long(1,i)))write(*,*)
     & MyRank," NaN in gradcorr6_long",i
      if (isnan(gcorr6_turn_long(1,i)))write(*,*)
     & MyRank," NaN in gcorr6_turn_long",i
      if (isnan(ghpbc(1,2))) write(*,*)MyRank," NaN in ghpbc",i
      if (isnan(gliptranc(1,i)))write(*,*)
     & MyRank," NaN in gliptranc",i
      if (isnan(gradafm(1,i)))write(*,*) MyRank," NaN in gradafm",i
      if (isnan(gg_tube(1,i)))write(*,*) MyRank," NaN in gg_tube",i
      if (isnan(gsaxsc(1,i)))write(*,*) MyRank," NaN in gsaxsc",i
      if (isnan(gdfad(1,i)))write(*,*) MyRank," NaN in gdfad",i
      if (isnan(gdfat(1,i)))write(*,*) MyRank," NaN in gdfat",i
      if (isnan(gdfan(1,i)))write(*,*) MyRank," NaN in gdfan",i
      if (isnan(gdfab(1,i)))write(*,*) MyRank," NaN in gdfab",i
      enddo
#endif
      !from=range_lo+((range_hi-range_lo)/threads_used)*(my_thread-1)
      !to=range_lo+((range_hi-range_lo)/threads_used)*my_thread-1
      !if(my_thread.eq.threads_used) to=range_hi
      call split_work_for_threads(from,to,0,nct,my_thread,threads_used)
c      if (to.eq.0 .or. to.gt.maxres)print *,"31 MyRank",MyRank," to",to

      k=to-from+1
c      if (k.eq.0)print *,"31 MyRank",MyRank," k",k

      gradbufc(:,from:to)=0.0d0
      call fmadd3(k,gradbufc(1,from),wsc,gvdwc(1,from))
      call fmadd3pair(k,gradbufc(1,from),wscp,
     &                gvdwc_scp(1,from),gvdwc_scpp(1,from))
      call fmadd3(k,gradbufc(1,from),welec,gelc_long(1,from))
#ifdef SPLITELE
      call fmadd3(k,gradbufc(1,from),wvdwpp,gvdwpp(1,from))
#else
      call fmadd3(k,gradbufc(1,from),wbond,gradb(1,from))
#endif
      call fmadd3(k,gradbufc(1,from),wel_loc,gel_loc_long(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr,gradcorr_long(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr5,gradcorr5_long(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr6,gradcorr6_long(1,from))
      call fmadd3(k,gradbufc(1,from),wturn6,gcorr6_turn_long(1,from))
      call fmadd3(k,gradbufc(1,from),wstrain,ghpbc(1,from))
      call fmadd3(k,gradbufc(1,from),wliptran,gliptranc(1,from))
      call fmadd3(k,gradbufc(1,from),1.0d0,gradafm(1,from))
#ifdef SHIELD
      call fmadd3(k,gradbufc(1,from),welec,gshieldc(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr,gshieldc_ec(1,from))
#ifdef SPLITELE
      call fmadd3(k,gradbufc(1,from),wturn3,gshieldc_t3(1,from))
#endif
      call fmadd3(k,gradbufc(1,from),wturn4,gshieldc_t4(1,from))
      call fmadd3(k,gradbufc(1,from),wel_loc,gshieldc_ll(1,from))
#endif
      call fmadd3(k,gradbufc(1,from),wtube,gg_tube(1,from))
      call fmadd3(k,gradbufc(1,from),wsaxs,gsaxsc(1,from))
c      from2=max(from2,1)
      from2=max(from,1)
      k=to-from2+1
      call fmadd3(k,gradbufc(1,from2),wdfa_dist,gdfad(1,from2))
      call fmadd3(k,gradbufc(1,from2),wdfa_tor,gdfat(1,from2))
      call fmadd3(k,gradbufc(1,from2),wdfa_nei,gdfan(1,from2))
      call fmadd3(k,gradbufc(1,from2),wdfa_beta,gdfab(1,from2))
#ifdef GRAD_NAN_CHECK
      do i=from2,to
      if (isnan(gradbufc(1,i))) write(*,*)MyRank," NaNs in gradbufc-1",i
      enddo
#endif
      gradbufc_sum(:,from:to)=gradbufc(:,from:to)
!$OMP END PARALLEL
      do i=nct+1,nres
        gradbufc_sum(:,i)=gradbufc(:,i)
        gradbufc(:,i)=0.0d0
      enddo
c      if (k.le.0 .or. to.le.0 .or. from2.eq.0) 
c     &  print *,"314 MyRank",MyRank," k",k," from",from,
c     & " from2",from2," to",to

#ifdef DEBUG
      write (iout,*) "gradc from gradbufc"
      do i=1,nres
        write (iout,'(i3,3f10.5)') i,(gradc(j,i,icg),j=1,3)
      enddo
      call flush(iout)
#endif
!!#ifdef MPI
!!      if (nfgtasks.gt.1) then
!!        time00=MPI_Wtime()
!!#ifdef DEBUG
!!        write (iout,*) "gradbufc before allreduce"
!!        do i=1,nres
!!          write (iout,'(i3,3f10.5)') i,(gradbufc(j,i),j=1,3)
!!        enddo
!!        call flush(iout)
!!#endif
!!      do i=0,nres
!!        do j=1,3
!!          gradbufc_sum(j,i)=gradbufc(j,i)
!!        enddo
!!      enddo
!!c      call MPI_AllReduce(gradbufc(1,1),gradbufc_sum(1,1),3*nres,
!!c     &    MPI_DOUBLE_PRECISION,MPI_SUM,FG_COMM,IERR)
!!c      time_reduce=time_reduce+MPI_Wtime()-time00
!!#ifdef DEBUG
!!c       write (iout,*) "gradbufc_sum after allreduce"
!!c       do i=1,nres
!!c         write (iout,'(i3,3f10.5)') i,(gradbufc_sum(j,i),j=1,3)
!!c       enddo
!!c       call flush(iout)
!!#endif
!!#ifdef TIMING
!!c       time_allreduce=time_allreduce+MPI_Wtime()-time00
!!#endif
!!c      do i=nnt,nres
!!      do i=0,nres
!!        do k=1,3
!!          gradbufc(k,i)=0.0d0
!!        enddo
!!      enddo
!!c#ifdef DEBUG
!!c       write (iout,*) "igrad_start",igrad_start," igrad_end",igrad_end
!!c       write (iout,*) (i," jgrad_start",jgrad_start(i),
!!c     &                  " jgrad_end  ",jgrad_end(i),
!!c     &                  i=igrad_start,igrad_end)
!!c#endif
!!c
!!c Obsolete and inefficient code; we can make the effort O(n) and, therefore,
!!c do not parallelize this part.
!!c
!!c      do i=igrad_start,igrad_end
!!c        do j=jgrad_start(i),jgrad_end(i)
!!c          do k=1,3
!!c            gradbufc(k,i)=gradbufc(k,i)+gradbufc_sum(k,j)
!!c          enddo
!!c        enddo
!!c      enddo
!!      do j=1,3
!!        gradbufc(j,nres-1)=gradbufc_sum(j,nres)
!!      enddo
!!c      do i=nres-2,-1,-1
!!      do i=nres-2,0,-1
!!        do j=1,3
!!          gradbufc(j,i)=gradbufc(j,i+1)+gradbufc_sum(j,i+1)
!!        enddo
!!      enddo
!!      else
!!#endif
#ifdef DEBUG
        write (iout,*) "gradbufc"
        do i=0,nres
          write (iout,'(i3,3f10.5)') i,(gradbufc(j,i),j=1,3)
        enddo
        call flush(iout)
#endif
c      do i=-1,nres
      !do i=0,nres   !moved to previous OMP block
      !  do j=1,3
      !    gradbufc_sum(j,i)=gradbufc(j,i)
      !    gradbufc(j,i)=0.0d0
      !  enddo
      !enddo
c      if (k.le.0) print *,"410 MyRank",MyRank," k",k," from",from,
c     & " from2",from2," to",to
      gradbufc(:,nres)=0.0d0
      gradbufc(:,nres-1)=gradbufc_sum(:,nres)
c      do i=nres-2,-1,-1
      do i=nres-2,0,-1
        gradbufc(:,i)=gradbufc(:,i+1)+gradbufc_sum(:,i+1)
      enddo
c      if (k.le.0) print *,"41 MyRank",MyRank," k",k," from",from,
c     & " from2",from2," to",to
c      if (k.le.0)print *,"41 MyRank",MyRank," k",k
#ifdef GRAD_NAN_CHECK
      do i=1,2*nres
        if (isnan(gradbufc(1,i))) then
          write (*,*) MyRank," NaNs in gradbufc 0"
          write (*,*) MyRank," gradbufc_sum"
          print '(i5,3f10.5)',i,(gradbufc_sum(j,i),j=1,3)
        endif
      enddo
#endif
!       call suffix_sum3(gradbufc(1,0),gradbufc_sum(1,0),0,nres-2,
!    &                   omp_get_max_threads())
c      do i=nnt,nres-1
c        do k=1,3
c          gradbufc(k,i)=0.0d0
c        enddo
c        do j=i+1,nres
c          do k=1,3
c            gradbufc(k,i)=gradbufc(k,i)+gradbufc(k,j)
c          enddo
c        enddo
c      enddo
!!#ifdef MPI
!!      endif
!!#endif
#ifdef DEBUG
      write (iout,*) "gradbufc after summing"
      do i=1,nres
        write (iout,'(i3,3f10.5)') i,(gradbufc(j,i),j=1,3)
      enddo
      call flush(iout)
#endif
      gradbufc(:,nres)=0.0d0
      gradc(:,-1,icg)=0.0d0
      gradc(:,nct+1:nres+1,icg)=0.0d0
      gradx(:,-1,icg)=0.0d0
      gradx(:,nct+1:nres+1,icg)=0.0d0
!$OMP PARALLEL NUM_THREADS(threads_used) DEFAULT(SHARED)
!$OMP& PRIVATE(k,from,from2,to,my_thread)
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif
      !from=range_lo+((range_hi-range_lo)/threads_used)*(my_thread-1)
      !to=range_lo+((range_hi-range_lo)/threads_used)*my_thread-1
      !if(my_thread.eq.threads_used) to=range_hi
      call split_work_for_threads(from,to,0,nct,my_thread,threads_used)
      k=to-from+1

      gradc(:,from:to,icg)=gradbufc(:,from:to)
      gradbufc(:,from:to)=0.0d0
      call fmadd3(k,gradc(1,from,icg),wang,glocangdc(1,from))
      call fmadd3(k,gradc(1,from,icg),wtor,gloctordc(1,from))
      call fmadd3(k,gradc(1,from,icg),welec,gelc(1,from))
      call fmadd3(k,gradc(1,from,icg),wel_loc,gel_loc(1,from))
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wscp,gvdwc_scpp(1,from))
      call fmadd3(k,gradbufc(1,from),wscp,gvdwc_scpp(1,from))
!      call fmadd3(k,gradc(1,from,icg),0.5d0*welec,gelc_long(1,from))
      call fmadd3(k,gradbufc(1,from),welec,gelc_long(1,from))
#ifdef SPLITELE
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wvdwpp,gvdwpp(1,from))
      call fmadd3(k,gradbufc(1,from),wvdwpp,gvdwpp(1,from))
#endif
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wel_loc,
!     &            gel_loc_long(1,from))
      call fmadd3(k,gradbufc(1,from),wel_loc,gel_loc_long(1,from))
#ifdef SPLITELE
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wcorr,
!     &            gradcorr_long(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr,gradcorr_long(1,from))
#else
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wcorr,gcorr_long(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr,gcorr_long(1,from))
#endif
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wcorr5,
!     &            gradcorr5_long(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr5,gradcorr5_long(1,from))
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wcorr6,
!     &            gradcorr6_long(1,from))
      call fmadd3(k,gradbufc(1,from),wcorr6,gradcorr6_long(1,from))
!      call fmadd3(k,gradc(1,from,icg),0.5d0*wturn6,
!     &            gcorr6_turn_long(1,from))
      call fmadd3(k,gradbufc(1,from),wturn6,gcorr6_turn(1,from))

      call fmadd3(k,gradc(1,from,icg),0.5d0,gradbufc(1,from))

      call fmadd3(k,gradc(1,from,icg),wbond,gradb(1,from))
      call fmadd3(k,gradc(1,from,icg),wcorr,gradcorr(1,from))
      call fmadd3(k,gradc(1,from,icg),wturn3,gcorr3_turn(1,from))
      call fmadd3(k,gradc(1,from,icg),wturn4,gcorr4_turn(1,from))
      call fmadd3(k,gradc(1,from,icg),wcorr5,gradcorr5(1,from))
      call fmadd3(k,gradc(1,from,icg),wcorr6,gradcorr6(1,from))
      call fmadd3(k,gradc(1,from,icg),wturn6,gcorr6_turn(1,from))
      call fmadd3(k,gradc(1,from,icg),wsccor,gsccorc(1,from))
      call fmadd3(k,gradc(1,from,icg),wscloc,gscloc(1,from))
      call fmadd3(k,gradc(1,from,icg),wstrain,ghpbdc(1,from))
      call fmadd3(k,gradc(1,from,icg),wliptran,gliptranc(1,from))
      call fmadd3(k,gradc(1,from,icg),1.0d0,gradafm(1,from))
#ifdef SHIELD
      call fmadd3(k,gradc(1,from,icg),welec,gshieldc(1,from))
      call fmadd3(k,gradc(1,from,icg),welec,gshieldc_loc(1,from))
      call fmadd3(k,gradc(1,from,icg),wcorr,gshieldc_ec(1,from))
      call fmadd3(k,gradc(1,from,icg),wcorr,gshieldc_loc_ec(1,from))
      call fmadd3(k,gradc(1,from,icg),wturn3,gshieldc_t3(1,from))
      call fmadd3(k,gradc(1,from,icg),wturn3,gshieldc_loc_t3(1,from))
      call fmadd3(k,gradc(1,from,icg),wturn4,gshieldc_t4(1,from))
      call fmadd3(k,gradc(1,from,icg),wturn4,gshieldc_loc_t4(1,from))
      call fmadd3(k,gradc(1,from,icg),wel_loc,gshieldc_ll(1,from))
      call fmadd3(k,gradc(1,from,icg),wel_loc,gshieldc_loc_ll(1,from))
#endif
      call fmadd3(k,gradc(1,from,icg),wtube,gg_tube(1,from))

      gradx(:,from:to,icg)=0.0d0
      call fmadd3(k,gradx(1,from,icg),wsc,gvdwx(1,from))
      call fmadd3(k,gradx(1,from,icg),wscp,gradx_scp(1,from))
      call fmadd3(k,gradx(1,from,icg),wbond,gradbx(1,from))
      call fmadd3(k,gradx(1,from,icg),wstrain,ghpbx(1,from))
      call fmadd3(k,gradx(1,from,icg),wcorr,gradxorr(1,from))
      call fmadd3(k,gradx(1,from,icg),wsccor,gsccorx(1,from))
      call fmadd3(k,gradx(1,from,icg),wscloc,gsclocx(1,from))
      call fmadd3(k,gradx(1,from,icg),wliptran,gliptranx(1,from))
#ifdef SHIELD
      call fmadd3(k,gradx(1,from,icg),welec,gshieldx(1,from))
      call fmadd3(k,gradx(1,from,icg),wcorr,gshieldx_ec(1,from))
      call fmadd3(k,gradx(1,from,icg),wturn3,gshieldx_t3(1,from))
      call fmadd3(k,gradx(1,from,icg),wturn4,gshieldx_t4(1,from))
      call fmadd3(k,gradx(1,from,icg),wel_loc,gshieldx_ll(1,from))
#endif
      call fmadd3(k,gradx(1,from,icg),wtube,gg_tube_sc(1,from))
      call fmadd3(k,gradx(1,from,icg),wsaxs,gsaxsx(1,from))
!$OMP END PARALLEL

      if (constr_homology.gt.0) then
!$OMP PARALLEL DO DEFAULT(SHARED) PRIVATE(j)
        do i=1,nct
          do j=1,3
            gradc(j,i,icg)=gradc(j,i,icg)+duscdiff(j,i)
            gradx(j,i,icg)=gradx(j,i,icg)+duscdiffx(j,i)
          enddo
        enddo
      endif
#ifdef DEBUG
      write (iout,*) "gradc gradx gloc after adding"
      write (iout,'(i5,3f10.5,5x,3f10.5,5x,f10.5)')
     &   i,(gradc(j,0,icg),j=1,3),(gradx(j,0,icg),j=1,3)
      do i=1,nres
        write (iout,'(i5,3f10.5,5x,3f10.5,5x,f10.5)')
     &   i,(gradc(j,i,icg),j=1,3),(gradx(j,i,icg),j=1,3),gloc(i,icg)
      enddo
      write (iout,*) "gloc before adding corr"
      do i=1,4*nres
        write (iout,*) i,gloc(i,icg)
      enddo
#endif
c
c      range_lo=1
c      range_hi=nres-3
c!$OMP PARALLEL NUM_THREADS(threads_used) DEFAULT(SHARED)
c!$OMP& PRIVATE(from,to,my_thread)
c AL 7/23/22 NMR anguular contribution
c#ifdef _OPENMP
c      my_thread=omp_get_thread_num()+1
c#else
c      my_thread=1
c#endif
c      from=range_lo+((range_hi-range_lo)/threads_used)*(my_thread-1)
c      to=range_lo+((range_hi-range_lo)/threads_used)*my_thread-1
c      if(my_thread.eq.threads_used) to=range_hi
c
c      call fmadd1(to-from+1,gloc(from,icg),wcorr,gcorr_loc(from))
c      call fmadd1(to-from+1,gloc(from,icg),wcorr5,g_corr5_loc(from))
c      call fmadd1(to-from+1,gloc(from,icg),wcorr6,g_corr6_loc(from))
c      call fmadd1(to-from+1,gloc(from,icg),wturn4,gel_loc_turn4(from))
c      call fmadd1(to-from+1,gloc(from,icg),wturn3,gel_loc_turn3(from))
c      call fmadd1(to-from+1,gloc(from,icg),wturn6,gel_loc_turn6(from))
c      call fmadd1(to-from+1,gloc(from,icg),wel_loc,gel_loc_loc(from))
c      call fmadd1(to-from+1,gloc(from,icg),wstrain,ghpbdphi(from))
c!$OMP END PARALLEL
#ifdef GRAD_NAN_CHECK
      if (isnan(ghpbdphi(4)))  write (*,*) MyRank," NaNs in ghpbdphi"
#endif
      do i=1,nres-3
         gloc(i,icg)=gloc(i,icg)+wstrain*ghpbdphi(i)
      enddo
c
#ifdef DEBUG
      write (iout,*) "gloc after adding corr"
      do i=1,4*nres
        write (iout,*) i,gloc(i,icg)
      enddo
#endif
#ifdef MPI
      if (nfgtasks.gt.1) then
!$OMP PARALLEL DO DEFAULT(SHARED)
        do i=0,nres
          gradbufc(:,i)=gradc(:,i,icg)
          gradbufx(:,i)=gradx(:,i,icg)
        enddo
!$OMP PARALLEL DO DEFAULT(SHARED)
        do i=1,4*nres
          glocbuf(i)=gloc(i,icg)
        enddo
c#define DEBUG
#ifdef DEBUG
        write (iout,*) "gloc_sc before reduce"
        do i=1,nres
          do j=1,1
            write (iout,*) i,j,gloc_sc(j,i,icg)
          enddo
        enddo
#endif
c#undef DEBUG
!$OMP PARALLEL DO DEFAULT(SHARED)
        do i=1,nres
          gloc_scbuf(:,i)=gloc_sc(:,i,icg)
        enddo

        time00=MPI_Wtime()
        call MPI_Barrier(FG_COMM,IERR)
        time_barrier_g=time_barrier_g+MPI_Wtime()-time00
        time00=MPI_Wtime()
        call MPI_Reduce(gradbufc(1,0),gradc(1,0,icg),3*(nres+1),
     &    MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERR)
        call MPI_Reduce(gradbufx(1,0),gradx(1,0,icg),3*(nres+1),
     &    MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERR)
        call MPI_Reduce(glocbuf(1),gloc(1,icg),4*nres,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERR)
        time_reduce=time_reduce+MPI_Wtime()-time00
        call MPI_Reduce(gloc_scbuf(1,1),gloc_sc(1,1,icg),3*nres,
     &    MPI_DOUBLE_PRECISION,MPI_SUM,king,FG_COMM,IERR)
        time_reduce=time_reduce+MPI_Wtime()-time00
#ifdef DEBUG
        write (iout,*) "gradc after reduce"
        do i=0,nres
          do j=1,3
            write (iout,*) i,j,gradc(j,i,icg)
          enddo
        enddo
        write (iout,*) "gloc_sc after reduce"
        do i=1,nres
          do j=1,1
            write (iout,*) i,j,gloc_sc(j,i,icg)
          enddo
        enddo
        write (iout,*) "gloc after reduce"
        do i=1,4*nres
          write (iout,*) i,gloc(i,icg)
        enddo
#endif
      endif
#endif
      if (gnorm_check) then
c
c Compute the maximum elements of the gradient
c
        gvdwc_max=0.0d0
        gvdwc_scp_max=0.0d0
        gelc_max=0.0d0
        gvdwpp_max=0.0d0
        gradb_max=0.0d0
        ghpbc_max=0.0d0
        gradcorr_max=0.0d0
        gel_loc_max=0.0d0
        gcorr3_turn_max=0.0d0
        gcorr4_turn_max=0.0d0
        gradcorr5_max=0.0d0
        gradcorr6_max=0.0d0
        gcorr6_turn_max=0.0d0
        gsccorrc_max=0.0d0
        gscloc_max=0.0d0
        gvdwx_max=0.0d0
        gradx_scp_max=0.0d0
        ghpbx_max=0.0d0
        gradxorr_max=0.0d0
        gsccorrx_max=0.0d0
        gsclocx_max=0.0d0
        do i=1,nct
          gvdwc_norm=dsqrt(scalar(gvdwc(1,i),gvdwc(1,i)))
          if (gvdwc_norm.gt.gvdwc_max) gvdwc_max=gvdwc_norm
          gvdwc_scp_norm=dsqrt(scalar(gvdwc_scp(1,i),gvdwc_scp(1,i)))
          if (gvdwc_scp_norm.gt.gvdwc_scp_max)
     &     gvdwc_scp_max=gvdwc_scp_norm
          gelc_norm=dsqrt(scalar(gelc(1,i),gelc(1,i)))
          if (gelc_norm.gt.gelc_max) gelc_max=gelc_norm
          gvdwpp_norm=dsqrt(scalar(gvdwpp(1,i),gvdwpp(1,i)))
          if (gvdwpp_norm.gt.gvdwpp_max) gvdwpp_max=gvdwpp_norm
          gradb_norm=dsqrt(scalar(gradb(1,i),gradb(1,i)))
          if (gradb_norm.gt.gradb_max) gradb_max=gradb_norm
          ghpbc_norm=dsqrt(scalar(ghpbc(1,i),ghpbc(1,i)))
          if (ghpbc_norm.gt.ghpbc_max) ghpbc_max=ghpbc_norm
          gradcorr_norm=dsqrt(scalar(gradcorr(1,i),gradcorr(1,i)))
          if (gradcorr_norm.gt.gradcorr_max) gradcorr_max=gradcorr_norm
          gel_loc_norm=dsqrt(scalar(gel_loc(1,i),gel_loc(1,i)))
          if (gel_loc_norm.gt.gel_loc_max) gel_loc_max=gel_loc_norm
          gcorr3_turn_norm=dsqrt(scalar(gcorr3_turn(1,i),
     &      gcorr3_turn(1,i)))
          if (gcorr3_turn_norm.gt.gcorr3_turn_max)
     &      gcorr3_turn_max=gcorr3_turn_norm
          gcorr4_turn_norm=dsqrt(scalar(gcorr4_turn(1,i),
     &      gcorr4_turn(1,i)))
          if (gcorr4_turn_norm.gt.gcorr4_turn_max)
     &      gcorr4_turn_max=gcorr4_turn_norm
          gradcorr5_norm=dsqrt(scalar(gradcorr5(1,i),gradcorr5(1,i)))
          if (gradcorr5_norm.gt.gradcorr5_max)
     &      gradcorr5_max=gradcorr5_norm
          gradcorr6_norm=dsqrt(scalar(gradcorr6(1,i),gradcorr6(1,i)))
          if (gradcorr6_norm.gt.gradcorr6_max)
     &           gradcorr6_max=gradcorr6_norm
          gcorr6_turn_norm=dsqrt(scalar(gcorr6_turn(1,i),
     &      gcorr6_turn(1,i)))
          if (gcorr6_turn_norm.gt.gcorr6_turn_max)
     &      gcorr6_turn_max=gcorr6_turn_norm
          gsccorrc_norm=dsqrt(scalar(gsccorc(1,i),gsccorc(1,i)))
          if (gsccorrc_norm.gt.gsccorrc_max) gsccorrc_max=gsccorrc_norm
          gscloc_norm=dsqrt(scalar(gscloc(1,i),gscloc(1,i)))
          if (gscloc_norm.gt.gscloc_max) gscloc_max=gscloc_norm
          gvdwx_norm=dsqrt(scalar(gvdwx(1,i),gvdwx(1,i)))
          if (gvdwx_norm.gt.gvdwx_max) gvdwx_max=gvdwx_norm
          gradx_scp_norm=dsqrt(scalar(gradx_scp(1,i),gradx_scp(1,i)))
          if (gradx_scp_norm.gt.gradx_scp_max)
     &      gradx_scp_max=gradx_scp_norm
          ghpbx_norm=dsqrt(scalar(ghpbx(1,i),ghpbx(1,i)))
          if (ghpbx_norm.gt.ghpbx_max) ghpbx_max=ghpbx_norm
          gradxorr_norm=dsqrt(scalar(gradxorr(1,i),gradxorr(1,i)))
          if (gradxorr_norm.gt.gradxorr_max) gradxorr_max=gradxorr_norm
          gsccorrx_norm=dsqrt(scalar(gsccorx(1,i),gsccorx(1,i)))
          if (gsccorrx_norm.gt.gsccorrx_max) gsccorrx_max=gsccorrx_norm
          gsclocx_norm=dsqrt(scalar(gsclocx(1,i),gsclocx(1,i)))
          if (gsclocx_norm.gt.gsclocx_max) gsclocx_max=gsclocx_norm
        enddo
        if (gradout) then
#if (defined AIX || defined CRAY)
          open(istat,file=statname,position="append")
#else
          open(istat,file=statname,access="append")
#endif
          write (istat,'(1h#,21f10.2)') gvdwc_max,gvdwc_scp_max,
     &      gelc_max,gvdwpp_max,gradb_max,ghpbc_max,
     &      gradcorr_max,gel_loc_max,gcorr3_turn_max,gcorr4_turn_max,
     &      gradcorr5_max,gradcorr6_max,gcorr6_turn_max,gsccorrc_max,
     &      gscloc_max,gvdwx_max,gradx_scp_max,ghpbx_max,gradxorr_max,
     &      gsccorrx_max,gsclocx_max
          close(istat)
          if (gvdwc_max.gt.1.0d4) then
            write (iout,*) "gvdwc gvdwx gradb gradbx"
            do i=nnt,nct
              write(iout,'(i5,4(3f10.2,5x))') i,(gvdwc(j,i),gvdwx(j,i),
     &          gradb(j,i),gradbx(j,i),j=1,3)
            enddo
            call pdbout(0.0d0,'cipiszcze',iout)
            call flush(iout)
          endif
        endif
      endif
#ifdef DEBUG
      write (iout,*) "gradc gradx gloc"
      do i=1,nres
        write (iout,'(i5,3f10.5,5x,3f10.5,5x,f10.5)')
     &   i,(gradc(j,i,icg),j=1,3),(gradx(j,i,icg),j=1,3),gloc(i,icg)
      enddo
#endif
#ifdef TIMING
#ifdef MPI
      time_sumgradient=time_sumgradient+MPI_Wtime()-time01
#else
      time_sumgradient=time_sumgradient+tcpu()-time01
#endif
#endif
      return
      end
c-------------------------------------------------------------------------------
      subroutine rescale_weights(t_bath)
      implicit none
#ifdef MPI
      include 'mpif.h'
      integer ierror
#endif
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.SBRIDGE'
      include 'COMMON.CONTROL'
      double precision t_bath
      double precision facT,facT2,facT3,facT4,facT5
      double precision kfac /2.4d0/
      double precision x,x2,x3,x4,x5,licznik /1.12692801104297249644/
c      facT=temp0/t_bath
c      facT=2*temp0/(t_bath+temp0)
      if (rescale_mode.eq.0) then
        facT=1.0d0
        facT2=1.0d0
        facT3=1.0d0
        facT4=1.0d0
        facT5=1.0d0
      else if (rescale_mode.eq.1) then
        facT=kfac/(kfac-1.0d0+t_bath/temp0)
        facT2=kfac**2/(kfac**2-1.0d0+(t_bath/temp0)**2)
        facT3=kfac**3/(kfac**3-1.0d0+(t_bath/temp0)**3)
        facT4=kfac**4/(kfac**4-1.0d0+(t_bath/temp0)**4)
        facT5=kfac**5/(kfac**5-1.0d0+(t_bath/temp0)**5)
      else if (rescale_mode.eq.2) then
        x=t_bath/temp0
        x2=x*x
        x3=x2*x
        x4=x3*x
        x5=x4*x
        facT=licznik/dlog(dexp(x)+dexp(-x))
        facT2=licznik/dlog(dexp(x2)+dexp(-x2))
        facT3=licznik/dlog(dexp(x3)+dexp(-x3))
        facT4=licznik/dlog(dexp(x4)+dexp(-x4))
        facT5=licznik/dlog(dexp(x5)+dexp(-x5))
      else
        write (iout,*) "Wrong RESCALE_MODE",rescale_mode
        write (*,*) "Wrong RESCALE_MODE",rescale_mode
#ifdef MPI
       call MPI_Finalize(MPI_COMM_WORLD,IERROR)
#endif
       stop 555
      endif
#ifdef SHIELD
      if (shield_mode.gt.0) then
       wscp=weights(2)*fact
       wsc=weights(1)*fact
       wvdwpp=weights(16)*fact
      endif
#endif
      welec=weights(3)*fact
      wcorr=weights(4)*fact3
      wcorr5=weights(5)*fact4
      wcorr6=weights(6)*fact5
      wel_loc=weights(7)*fact2
      wturn3=weights(8)*fact2
      wturn4=weights(9)*fact3
      wturn6=weights(10)*fact5
      wtor=weights(13)*fact
      wtor_d=weights(14)*fact2
      wsccor=weights(21)*fact
      if (scale_umb) wumb=t_bath/temp0
c      write (iout,*) "scale_umb",scale_umb
c      write (iout,*) "t_bath",t_bath," temp0",temp0," wumb",wumb

      return
      end
C------------------------------------------------------------------------
      subroutine enerprint(energia)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.SBRIDGE'
      include 'COMMON.QRESTR'
      double precision energia(0:n_ene)
      double precision evdw,evdw1,evdw2,evdw2_14,ees,eel_loc,
     & eello_turn3,eello_turn4,edfadis,estr,ehpb,ebe,ethetacnstr,
     & escloc,etors,edihcnstr,etors_d,esccor,ecorr,ecorr5,ecorr6,
     & eello_turn6,
     & eliptran,Eafmforce,Etube,
     & esaxs,ehomology_constr,edfator,edfanei,edfabet,etot
      etot=energia(0)
      evdw=energia(1)
      evdw2=energia(2)
#ifdef SCP14
      evdw2=energia(2)+energia(18)
#else
      evdw2=energia(2)
#endif
      ees=energia(3)
#ifdef SPLITELE
      evdw1=energia(16)
#endif
      ecorr=energia(4)
      ecorr5=energia(5)
      ecorr6=energia(6)
      eel_loc=energia(7)
      eello_turn3=energia(8)
      eello_turn4=energia(9)
      eello_turn6=energia(10)
      ebe=energia(11)
      escloc=energia(12)
      etors=energia(13)
      etors_d=energia(14)
      ehpb=energia(15)
      edihcnstr=energia(19)
      estr=energia(17)
      Uconst=energia(20)
      esccor=energia(21)
      eliptran=energia(22)
      Eafmforce=energia(23)
      ethetacnstr=energia(24)
      etube=energia(25)
      esaxs=energia(26)
      ehomology_constr=energia(27)
C     Bartek
      edfadis = energia(28)
      edfator = energia(29)
      edfanei = energia(30)
      edfabet = energia(31)
#ifdef SPLITELE
      write (iout,10) evdw,wsc,evdw2,wscp,ees,welec,evdw1,wvdwpp,
     &  estr,wbond,ebe,wang,
     &  escloc,wscloc,etors,wtor,etors_d,wtor_d,ehpb,wstrain,
     &  eel_loc,wel_loc,eello_turn3,wturn3,
     &  eello_turn4,wturn4,
     &  esccor,wsccor,edihcnstr,
     &  ethetacnstr,ebr*nss,Uconst,wumb,eliptran,wliptran,Eafmforce,
     &  etube,wtube,esaxs,wsaxs,ehomology_constr,
     &  edfadis,wdfa_dist,edfator,wdfa_tor,edfanei,wdfa_nei,
     &  edfabet,wdfa_beta,
     &  etot
   10 format (/'Virtual-chain energies:'//
     & 'EVDW=  ',1pE16.6,' WEIGHT=',1pE16.6,' (SC-SC)'/
     & 'EVDW2= ',1pE16.6,' WEIGHT=',1pE16.6,' (SC-p)'/
     & 'EES=   ',1pE16.6,' WEIGHT=',1pE16.6,' (p-p)'/
     & 'EVDWPP=',1pE16.6,' WEIGHT=',1pE16.6,' (p-p VDW)'/
     & 'ESTR=  ',1pE16.6,' WEIGHT=',1pE16.6,' (stretching)'/
     & 'EBE=   ',1pE16.6,' WEIGHT=',1pE16.6,' (bending)'/
     & 'ESC=   ',1pE16.6,' WEIGHT=',1pE16.6,' (SC local)'/
     & 'ETORS= ',1pE16.6,' WEIGHT=',1pE16.6,' (torsional)'/
     & 'ETORSD=',1pE16.6,' WEIGHT=',1pE16.6,' (double torsional)'/
     & 'EHBP=  ',1pE16.6,' WEIGHT=',1pE16.6,
     & ' (SS bridges & dist. cnstr.)'/
     & 'EELLO= ',1pE16.6,' WEIGHT=',1pE16.6,' (electrostatic-local)'/
     & 'ETURN3=',1pE16.6,' WEIGHT=',1pE16.6,' (turns, 3rd order)'/
     & 'ETURN4=',1pE16.6,' WEIGHT=',1pE16.6,' (turns, 4th order)'/
     & 'ESCCOR=',1pE16.6,' WEIGHT=',1pE16.6,' (backbone-rotamer corr)'/
     & 'EDIHC= ',1pE16.6,' (virtual-bond dihedral angle restraints)'/
     & 'ETHETC=',1pE16.6,' (virtual-bond angle restraints)'/
     & 'ESS=   ',1pE16.6,' (disulfide-bridge intrinsic energy)'/
     & 'UCONST=',1pE16.6,' WEIGHT=',1pE16.6' (umbrella restraints)'/
     & 'ELT=   ',1pE16.6,' WEIGHT=',1pE16.6,' (Lipid transfer)'/
     & 'EAFM=  ',1pE16.6,' (atomic-force microscopy)'/
     & 'ETUBE= ',1pE16.6,' WEIGHT=',1pE16.6,' (tube confinment)'/
     & 'E_SAXS=',1pE16.6,' WEIGHT=',1pE16.6,' (SAXS restraints)'/
     & 'H_CONS=',1pE16.6,' (Homology model constraints energy)'/
     & 'EDFAD= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA distance energy)'/
     & 'EDFAT= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA torsion energy)'/
     & 'EDFAN= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA NCa energy)'/
     & 'EDFAB= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA Beta energy)'/
     & 'ETOT=  ',1pE16.6,' (total)')

#else
      write (iout,10) evdw,wsc,evdw2,wscp,ees,welec,
     &  estr,wbond,ebe,wang,
     &  escloc,wscloc,etors,wtor,etors_d,wtor_d,ehpb,wstrain,
     &  eel_loc,wel_loc,eello_turn3,wturn3,
     &  eello_turn4,wturn4,
     &  esccor,wsccor,edihcnstr,
     &  ethetacnstr,ebr*nss,Uconst,wumb,eliptran,wliptran,Eafmforc,
     &  etube,wtube,esaxs,wsaxs,ehomology_constr,
     &  edfadis,wdfa_dist,edfator,wdfa_tor,edfanei,wdfa_nei,
     &  edfabet,wdfa_beta,
     &  etot
   10 format (/'Virtual-chain energies:'//
     & 'EVDW=  ',1pE16.6,' WEIGHT=',1pE16.6,' (SC-SC)'/
     & 'EVDW2= ',1pE16.6,' WEIGHT=',1pE16.6,' (SC-p)'/
     & 'EES=   ',1pE16.6,' WEIGHT=',1pE16.6,' (p-p)'/
     & 'ESTR=  ',1pE16.6,' WEIGHT=',1pE16.6,' (stretching)'/
     & 'EBE=   ',1pE16.6,' WEIGHT=',1pE16.6,' (bending)'/
     & 'ESC=   ',1pE16.6,' WEIGHT=',1pE16.6,' (SC local)'/
     & 'ETORS= ',1pE16.6,' WEIGHT=',1pE16.6,' (torsional)'/
     & 'ETORSD=',1pE16.6,' WEIGHT=',1pE16.6,' (double torsional)'/
     & 'EHBP=  ',1pE16.6,' WEIGHT=',1pE16.6,
     & ' (SS bridges & dist. restr.)'/
     & 'EELLO= ',1pE16.6,' WEIGHT=',1pE16.6,' (electrostatic-local)'/
     & 'ETURN3=',1pE16.6,' WEIGHT=',1pE16.6,' (turns, 3rd order)'/
     & 'ETURN4=',1pE16.6,' WEIGHT=',1pE16.6,' (turns, 4th order)'/
     & 'ESCCOR=',1pE16.6,' WEIGHT=',1pE16.6,' (backbone-rotamer corr)'/
     & 'EDIHC= ',1pE16.6,' (virtual-bond dihedral angle restraints)'/
     & 'ETHETC=',1pE16.6,' (virtual-bond angle restraints)'/
     & 'ESS=   ',1pE16.6,' (disulfide-bridge intrinsic energy)'/
     & 'UCONST=',1pE16.6,' WEIGHT=',1pE16.6' (umbrella restraints)'/
     & 'ELT=   ',1pE16.6,' WEIGHT=',1pE16.6,' (Lipid transfer)'/
     & 'EAFM=  ',1pE16.6,' (atomic-force microscopy)'/
     & 'ETUBE= ',1pE16.6,' WEIGHT=',1pE16.6,' (tube confinment)'/
     & 'E_SAXS=',1pE16.6,' WEIGHT=',1pE16.6,' (SAXS restraints)'/
     & 'H_CONS=',1pE16.6,' (Homology model constraints energy)'/
     & 'EDFAD= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA distance energy)'/
     & 'EDFAT= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA torsion energy)'/
     & 'EDFAN= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA NCa energy)'/
     & 'EDFAB= ',1pE16.6,' WEIGHT=',1pE16.6,' (DFA Beta energy)'/
     & 'ETOT=  ',1pE16.6,' (total)')
#endif
      return
      end
C-----------------------------------------------------------------------
      subroutine elj(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the LJ potential of interaction.
C
      implicit none
      double precision accur
      include 'DIMENSIONS'
      parameter (accur=1.0d-10)
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.TORSION'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include 'COMMON.SPLITELE'
      double precision gg(3)
      double precision evdw,evdwij
      integer i,j,k,itypi,itypj,itypi1,num_conti,iint,ikont,jblock
      double precision xi,yi,zi,xj,yj,zj,rij,eps0ij,fac,e1,e2,rrij,
     & sigij,r0ij,rcut,sqrij,sss1,sssgrad1
      double precision fcont,fprimcont
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision gg_lipi(3),gg_lipj(3)
      double precision boxshift
      external boxshift
c      write(iout,*)'Entering ELJ nnt=',nnt,' nct=',nct,' expon=',expon
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start,g_listscsc_end
        i=newcontlisti(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
C Change 12/1/95
        num_conti=0
C
C Calculate SC interaction energy.
C
c        do iint=1,nint_gr(i)
cd        write (iout,*) 'i=',i,' iint=',iint,' istart=',istart(i,iint),
cd   &                  'iend=',iend(i,iint)
c          do j=istart(i,iint),iend(i,iint)
         do jblock=newcontlisti(2,ikont-1)+1,newcontlisti(2,ikont)
         do j=newcontlistj(1,jblock),newcontlistj(2,jblock)
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
C Change 12/1/95 to calculate four-body interactions
            rij=xj*xj+yj*yj+zj*zj
            rrij=1.0D0/rij
            sqrij=dsqrt(rij)
            sss1=sscale(sqrij,r_cut_int)
            if (sss1.eq.0.0d0) cycle
            sssgrad1=sscagrad(sqrij,r_cut_int)

c           write (iout,*)'i=',i,' j=',j,' itypi=',itypi,' itypj=',itypj
            eps0ij=eps(itypi,itypj)
            fac=rrij**expon2
            faclip=fac
C have you changed here?
            e1=fac*fac*aa
            e2=fac*bb
            evdwij=e1+e2
cd          sigm=dabs(aa(itypi,itypj)/bb(itypi,itypj))**(1.0D0/6.0D0)
cd          epsi=bb(itypi,itypj)**2/aa(itypi,itypj)
cd          write (iout,'(2(a3,i3,2x),6(1pd12.4)/2(3(1pd12.4),5x)/)')
cd   &        restyp(itypi),i,restyp(itypj),j,a(itypi,itypj),
cd   &        bb(itypi,itypj),1.0D0/dsqrt(rrij),evdwij,epsi,sigm,
cd   &        (c(k,i),k=1,3),(c(k,j),k=1,3)
            evdw=evdw+sss1*evdwij
C
C Calculate the components of the gradient in DC and X
C
            fac=-rrij*(e1+evdwij)*sss1
     &          +evdwij*sssgrad1/sqrij/expon
            gg(1)=xj*fac
            gg(2)=yj*fac
            gg(3)=zj*fac
            gg_lipi(3)=(sss1/2.0d0*(faclip*faclip*
     &         (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &        +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj))))/expon
            gg_lipj(3)=ssgradlipj*gg_lipi(3)
            gg_lipi(3)=gg_lipi(3)*ssgradlipi
            do k=1,3
              gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
              gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
              gvdwc(k,i)=gvdwc(k,i)-gg(k)+gg_lipi(k)
              gvdwc(k,j)=gvdwc(k,j)+gg(k)+gg_lipj(k)
            enddo
cgrad            do k=i,j-1
cgrad              do l=1,3
cgrad                gvdwc(l,k)=gvdwc(l,k)+gg(l)
cgrad              enddo
cgrad            enddo
C
          enddo      ! j
        enddo        ! iint
      enddo          ! i
      do i=1,nct
        do j=1,3
          gvdwc(j,i)=expon*gvdwc(j,i)
          gvdwx(j,i)=expon*gvdwx(j,i)
        enddo
      enddo
C******************************************************************************
C
C                              N O T E !!!
C
C To save time, the factor of EXPON has been extracted from ALL components
C of GVDWC and GRADX. Remember to multiply them by this factor before further
C use!
C
C******************************************************************************
      return
      end
C-----------------------------------------------------------------------------
      subroutine eljk(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the LJK potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.SPLITELE'
      double precision gg(3)
      double precision evdw,evdwij
      integer i,j,k,itypi,itypj,itypi1,iint,ikont,jblock
      double precision xi,yi,zi,xj,yj,zj,rij,eps0ij,fac,e1,e2,rrij,
     & fac_augm,e_augm,r_inv_ij,r_shift_inv,sss1,sssgrad1
      logical scheck
      double precision boxshift
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision gg_lipi(3),gg_lipj(3)
      double precision sscale,sscagrad,sscagradlip,sscalelip
c     print *,'Entering ELJK nnt=',nnt,' nct=',nct,' expon=',expon
      evdw=0.0D0
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start,g_listscsc_end
        i=newcontlisti(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
C
C Calculate SC interaction energy.
C
c        do iint=1,nint_gr(i)
c          do j=istart(i,iint),iend(i,iint)
         do jblock=newcontlisti(2,ikont-1)+1,newcontlisti(2,ikont)
         do j=newcontlistj(1,jblock),newcontlistj(2,jblock)
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
            fac_augm=rrij**expon
            e_augm=augm(itypi,itypj)*fac_augm
            r_inv_ij=dsqrt(rrij)
            rij=1.0D0/r_inv_ij
            sss1=sscale(rij,r_cut_int)
            if (sss1.eq.0.0d0) cycle
            sssgrad1=sscagrad(rij,r_cut_int)
            r_shift_inv=1.0D0/(rij+r0(itypi,itypj)-sigma(itypi,itypj))
            fac=r_shift_inv**expon
            faclip=fac
C have you changed here?
            e1=fac*fac*aa
            e2=fac*bb
            evdwij=e_augm+e1+e2
cd          sigm=dabs(aa(itypi,itypj)/bb(itypi,itypj))**(1.0D0/6.0D0)
cd          epsi=bb(itypi,itypj)**2/aa(itypi,itypj)
cd          write (iout,'(2(a3,i3,2x),8(1pd12.4)/2(3(1pd12.4),5x)/)')
cd   &        restyp(itypi),i,restyp(itypj),j,aa(itypi,itypj),
cd   &        bb(itypi,itypj),augm(itypi,itypj),epsi,sigm,
cd   &        sigma(itypi,itypj),1.0D0/dsqrt(rrij),evdwij,
cd   &        (c(k,i),k=1,3),(c(k,j),k=1,3)
            evdw=evdw+evdwij*sss1
C
C Calculate the components of the gradient in DC and X
C
            fac=-2.0D0*rrij*e_augm-r_inv_ij*r_shift_inv*(e1+e1+e2)
     &          +evdwij*sssgrad1*r_inv_ij/expon
            gg(1)=xj*fac
            gg(2)=yj*fac
            gg(3)=zj*fac
            gg_lipi(3)=(sss1/2.0d0*(faclip*faclip*
     &         (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &        +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj))))/expon
            gg_lipj(3)=ssgradlipj*gg_lipi(3)
            gg_lipi(3)=gg_lipi(3)*ssgradlipi
            do k=1,3
              gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
              gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
              gvdwc(k,i)=gvdwc(k,i)-gg(k)+gg_lipi(k)
              gvdwc(k,j)=gvdwc(k,j)+gg(k)+gg_lipj(k)
            enddo
cgrad            do k=i,j-1
cgrad              do l=1,3
cgrad                gvdwc(l,k)=gvdwc(l,k)+gg(l)
cgrad              enddo
cgrad            enddo
          enddo      ! j
        enddo        ! iint
      enddo          ! i
      do i=1,nct
        do j=1,3
          gvdwc(j,i)=expon*gvdwc(j,i)
          gvdwx(j,i)=expon*gvdwx(j,i)
        enddo
      enddo
      return
      end
C-----------------------------------------------------------------------------
      subroutine ebp(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Berne-Pechukas potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.SPLITELE'
      integer icall
      common /srutu/ icall
      double precision evdw
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,xi,yi,zi,
     & sss1,sssgrad1
      double precision fracinbuf,sslipi,sslipj,ssgradlipj,ssgradlipi,
     & faclip
      double precision sscale,sscagrad,sscagradlip,sscalelip
      double precision boxshift
c     double precision rrsave(maxdim)
      logical lprn
      evdw=0.0D0
c     print *,'Entering EBP nnt=',nnt,' nct=',nct,' expon=',expon
      gg_lipi=0.0d0
      gg_lipj=0.0d0
c     if (icall.eq.0) then
c       lprn=.true.
c     else
        lprn=.false.
c     endif
      ind=0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start,g_listscsc_end
        i=newcontlisti(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
C
C Calculate SC interaction energy.
C
c        do iint=1,nint_gr(i)
c          do j=istart(i,iint),iend(i,iint)
         do jblock=newcontlisti(2,ikont-1)+1,newcontlisti(2,ikont)
         do j=newcontlistj(1,jblock),newcontlistj(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
C For diagnostics only!!!
c           chi1=0.0D0
c           chi2=0.0D0
c           chi12=0.0D0
c           chip1=0.0D0
c           chip2=0.0D0
c           chip12=0.0D0
c           alf1=0.0D0
c           alf2=0.0D0
c           alf12=0.0D0
            xj=c(1,nres+j)
            yj=c(2,nres+j)
            zj=c(3,nres+j)
            call to_box(xj,yj,zj)
            call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
            aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &        +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
            xj=boxshift(xj-xi,boxxsize)
            yj=boxshift(yj-yi,boxysize)
            zj=boxshift(zj-zi,boxzsize)
            dxj=dc_norm(1,nres+j)
            dyj=dc_norm(2,nres+j)
            dzj=dc_norm(3,nres+j)
            rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
cd          if (icall.eq.0) then
cd            rrsave(ind)=rrij
cd          else
cd            rrij=rrsave(ind)
cd          endif
            rij=dsqrt(rrij)
            sss1=sscale(1.0d0/rij,r_cut_int)
            if (sss1.eq.0.0d0) cycle
            sssgrad1=sscagrad(1.0d0/rij,r_cut_int)
C Calculate the angle-dependent terms of energy & contributions to derivatives.
            call sc_angular
C Calculate whole angle-dependent part of epsilon and contributions
C to its derivatives
C have you changed here?
            fac=(rrij*sigsq)**expon2
            faclip=fac
            e1=fac*fac*aa
            e2=fac*bb
            evdwij=eps1*eps2rt*eps3rt*(e1+e2)
            eps2der=evdwij*eps3rt
            eps3der=evdwij*eps2rt
            evdwij=evdwij*eps2rt*eps3rt
            evdw=evdw+sss1*evdwij
            if (lprn) then
            sigm=dabs(aa/bb)**(1.0D0/6.0D0)
            epsi=bb**2/aa
cd            write (iout,'(2(a3,i3,2x),15(0pf7.3))')
cd     &        restyp(itypi),i,restyp(itypj),j,
cd     &        epsi,sigm,chi1,chi2,chip1,chip2,
cd     &        eps1,eps2rt**2,eps3rt**2,1.0D0/dsqrt(sigsq),
cd     &        om1,om2,om12,1.0D0/dsqrt(rrij),
cd     &        evdwij
            endif
C Calculate gradient components.
            e1=e1*eps1*eps2rt**2*eps3rt**2
            fac=-expon*(e1+evdwij)
            sigder=fac/sigsq
            fac=rrij*fac
     &          +evdwij*sssgrad1/sss1*rij
C Calculate radial part of the gradient
            gg(1)=xj*fac
            gg(2)=yj*fac
            gg(3)=zj*fac
            gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &        *(eps3rt*eps3rt)*sss1/2.0d0*(faclip*faclip*
     &         (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &        +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
            gg_lipj(3)=ssgradlipj*gg_lipi(3)
            gg_lipi(3)=gg_lipi(3)*ssgradlipi
C Calculate the angular part of the gradient and sum add the contributions
C to the appropriate components of the Cartesian gradient.
            call sc_grad
          enddo      ! j
        enddo        ! iint
      enddo          ! i
c     stop
      return
      end
C-----------------------------------------------------------------------------
      subroutine egbv(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the Gay-Berne-Vorobjev potential of interaction.
C
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.SPLITELE'
      double precision boxshift
      integer icall
      common /srutu/ icall
      logical lprn
      double precision evdw
      integer itypi,itypj,itypi1,iint,ind,ikont,jblock
      double precision eps0ij,epsi,sigm,fac,e1,e2,rrij,r0ij,
     & xi,yi,zi,fac_augm,e_augm
      double precision fracinbuf,sslipi,evdwij_przed_tri,sig0ij,
     & sslipj,ssgradlipj,ssgradlipi,sig,rij_shift,faclip,sssgrad1
      double precision dist,sscale,sscagrad,sscagradlip,sscalelip
      evdw=0.0D0
c     print *,'Entering EGB nnt=',nnt,' nct=',nct,' expon=',expon
      gg_lipi=0.0d0
      gg_lipj=0.0d0
      lprn=.false.
c     if (icall.eq.0) lprn=.true.
      ind=0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start,g_listscsc_end
        i=newcontlisti(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
C define scaling factor for lipids

C        if (positi.le.0) positi=positi+boxzsize
C        print *,i
C first for peptide groups
c for each residue check if it is in lipid or lipid water border area
        call lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
        dxi=dc_norm(1,nres+i)
        dyi=dc_norm(2,nres+i)
        dzi=dc_norm(3,nres+i)
c        dsci_inv=dsc_inv(itypi)
        dsci_inv=vbld_inv(i+nres)
C
C Calculate SC interaction energy.
C
c        do iint=1,nint_gr(i)
c          do j=istart(i,iint),iend(i,iint)
         do jblock=newcontlisti(2,ikont-1)+1,newcontlisti(2,ikont)
         do j=newcontlistj(1,jblock),newcontlistj(2,jblock)
            ind=ind+1
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
c            dscj_inv=dsc_inv(itypj)
            dscj_inv=vbld_inv(j+nres)
            sig0ij=sigma(itypi,itypj)
            r0ij=r0(itypi,itypj)
            chi1=chi(itypi,itypj)
            chi2=chi(itypj,itypi)
            chi12=chi1*chi2
            chip1=chip(itypi)
            chip2=chip(itypj)
            chip12=chip1*chip2
            alf1=alp(itypi)
            alf2=alp(itypj)
            alf12=0.5D0*(alf1+alf2)
C For diagnostics only!!!
c           chi1=0.0D0
c           chi2=0.0D0
c           chi12=0.0D0
c           chip1=0.0D0
c           chip2=0.0D0
c           chip12=0.0D0
c           alf1=0.0D0
c           alf2=0.0D0
c           alf12=0.0D0
           xj=c(1,nres+j)
           yj=c(2,nres+j)
           zj=c(3,nres+j)
           call to_box(xj,yj,zj)
           call lipid_layer(xj,yj,zj,sslipj,ssgradlipj)
           aa=aa_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &       +aa_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
           bb=bb_lip(itypi,itypj)*(sslipi+sslipj)/2.0d0
     &       +bb_aq(itypi,itypj)*(2.0d0-sslipi-sslipj)/2.0d0
C      if (aa.ne.aa_aq(itypi,itypj)) write(63,'2e10.5')
C     &(aa-aa_aq(itypi,itypj)),(bb-bb_aq(itypi,itypj))
C      write(iout,*) "tu,", i,j,aa,bb,aa_lip(itypi,itypj),sslipi,sslipj
           xj=boxshift(xj-xi,boxxsize)
           yj=boxshift(yj-yi,boxysize)
           zj=boxshift(zj-zi,boxzsize)
           dxj=dc_norm(1,nres+j)
           dyj=dc_norm(2,nres+j)
           dzj=dc_norm(3,nres+j)
           rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
           rij=dsqrt(rrij)
           sss=sscale(1.0d0/rij,r_cut_int)
           if (sss.eq.0.0d0) cycle
           sssgrad=sscagrad(1.0d0/rij,r_cut_int)
C Calculate angle-dependent terms of energy and contributions to their
C derivatives.
           call sc_angular
           sigsq=1.0D0/sigsq
           sig=sig0ij*dsqrt(sigsq)
           rij_shift=1.0D0/rij-sig+r0ij
C I hate to put IF's in the loops, but here don't have another choice!!!!
           if (rij_shift.le.0.0D0) then
             evdw=1.0D20
             return
           endif
           sigder=-sig*sigsq
c---------------------------------------------------------------
           rij_shift=1.0D0/rij_shift
           fac=rij_shift**expon
           faclip=fac
           e1=fac*fac*aa
           e2=fac*bb
           evdwij=eps1*eps2rt*eps3rt*(e1+e2)
           eps2der=evdwij*eps3rt
           eps3der=evdwij*eps2rt
           fac_augm=rrij**expon
           e_augm=augm(itypi,itypj)*fac_augm
           evdwij=evdwij*eps2rt*eps3rt
           evdw=evdw+evdwij+e_augm
           if (lprn) then
             sigm=dabs(aa/bb)**(1.0D0/6.0D0)
             epsi=bb**2/aa
             write (iout,'(2(a3,i3,2x),17(0pf7.3))')
     &        restyp(itypi),i,restyp(itypj),j,
     &        epsi,sigm,sig,(augm(itypi,itypj)/epsi)**(1.0D0/12.0D0),
     &        chi1,chi2,chip1,chip2,
     &        eps1,eps2rt**2,eps3rt**2,
     &        om1,om2,om12,1.0D0/rij,1.0D0/rij_shift,
     &        evdwij+e_augm
           endif
C Calculate gradient components.
           e1=e1*eps1*eps2rt**2*eps3rt**2
           fac=-expon*(e1+evdwij)*rij_shift
           sigder=fac*sigder
           fac=rij*fac-2*expon*rrij*e_augm
           fac=fac+(evdwij+e_augm)*sssgrad/sss*rij
C Calculate the radial part of the gradient
           gg_lipi(3)=eps1*(eps2rt*eps2rt)
     &       *(eps3rt*eps3rt)*sss/2.0d0*(faclip*faclip*
     &       (aa_lip(itypi,itypj)-aa_aq(itypi,itypj))
     &       +faclip*(bb_lip(itypi,itypj)-bb_aq(itypi,itypj)))
           gg_lipj(3)=ssgradlipj*gg_lipi(3)
           gg_lipi(3)=gg_lipi(3)*ssgradlipi
           gg(1)=xj*fac
           gg(2)=yj*fac
           gg(3)=zj*fac
C Calculate angular part of the gradient.
c            call sc_grad_scale(sss)
           call sc_grad
          enddo      ! j
        enddo        ! iint
      enddo          ! i
      end
C-----------------------------------------------------------------------------
      subroutine sc_angular
C Calculate eps1,eps2,eps3,sigma, and parts of their derivatives in om1,om2,
C om12. Called by ebp, egb, and egbv.
      implicit none
      include 'COMMON.CALC'
      include 'COMMON.IOUNITS'
      erij(1)=xj*rij
      erij(2)=yj*rij
      erij(3)=zj*rij
      om1=dxi*erij(1)+dyi*erij(2)+dzi*erij(3)
      om2=dxj*erij(1)+dyj*erij(2)+dzj*erij(3)
      om12=dxi*dxj+dyi*dyj+dzi*dzj
      chiom12=chi12*om12
C Calculate eps1(om12) and its derivative in om12
      faceps1=1.0D0-om12*chiom12
      faceps1_inv=1.0D0/faceps1
      eps1=dsqrt(faceps1_inv)
C Following variable is eps1*deps1/dom12
      eps1_om12=faceps1_inv*chiom12
c diagnostics only
c      faceps1_inv=om12
c      eps1=om12
c      eps1_om12=1.0d0
c      write (iout,*) "om12",om12," eps1",eps1
C Calculate sigma(om1,om2,om12) and the derivatives of sigma**2 in om1,om2,
C and om12.
      om1om2=om1*om2
      chiom1=chi1*om1
      chiom2=chi2*om2
      facsig=om1*chiom1+om2*chiom2-2.0D0*om1om2*chiom12
      sigsq=1.0D0-facsig*faceps1_inv
      sigsq_om1=(chiom1-chiom12*om2)*faceps1_inv
      sigsq_om2=(chiom2-chiom12*om1)*faceps1_inv
      sigsq_om12=-chi12*(om1om2*faceps1-om12*facsig)*faceps1_inv**2
c diagnostics only
c      sigsq=1.0d0
c      sigsq_om1=0.0d0
c      sigsq_om2=0.0d0
c      sigsq_om12=0.0d0
c      write (iout,*) "chiom1",chiom1," chiom2",chiom2," chiom12",chiom12
c      write (iout,*) "faceps1",faceps1," faceps1_inv",faceps1_inv,
c     &    " eps1",eps1
C Calculate eps2 and its derivatives in om1, om2, and om12.
      chipom1=chip1*om1
      chipom2=chip2*om2
      chipom12=chip12*om12
      facp=1.0D0-om12*chipom12
      facp_inv=1.0D0/facp
      facp1=om1*chipom1+om2*chipom2-2.0D0*om1om2*chipom12
c      write (iout,*) "chipom1",chipom1," chipom2",chipom2,
c     &  " chipom12",chipom12," facp",facp," facp_inv",facp_inv
C Following variable is the square root of eps2
      eps2rt=1.0D0-facp1*facp_inv
C Following three variables are the derivatives of the square root of eps
C in om1, om2, and om12.
      eps2rt_om1=-4.0D0*(chipom1-chipom12*om2)*facp_inv
      eps2rt_om2=-4.0D0*(chipom2-chipom12*om1)*facp_inv
      eps2rt_om12=4.0D0*chip12*(om1om2*facp-om12*facp1)*facp_inv**2
C Evaluate the "asymmetric" factor in the VDW constant, eps3
      eps3rt=1.0D0-alf1*om1+alf2*om2-alf12*om12
c      write (iout,*) "eps2rt",eps2rt," eps3rt",eps3rt
c      write (iout,*) "eps2rt_om1",eps2rt_om1," eps2rt_om2",eps2rt_om2,
c     &  " eps2rt_om12",eps2rt_om12
C Calculate whole angle-dependent part of epsilon and contributions
C to its derivatives
      return
      end
C----------------------------------------------------------------------------
      subroutine sc_grad
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.CALC'
      include 'COMMON.IOUNITS'
      double precision dcosom1(3),dcosom2(3)
cc      print *,'sss=',sss
      eom1=eps2der*eps2rt_om1-2.0D0*alf1*eps3der+sigder*sigsq_om1
      eom2=eps2der*eps2rt_om2+2.0D0*alf2*eps3der+sigder*sigsq_om2
      eom12=evdwij*eps1_om12+eps2der*eps2rt_om12
     &     -2.0D0*alf12*eps3der+sigder*sigsq_om12
c diagnostics only
c      eom1=0.0d0
c      eom2=0.0d0
c      eom12=evdwij*eps1_om12
c end diagnostics
c      write (iout,*) "eps2der",eps2der," eps3der",eps3der,
c     &  " sigder",sigder
c      write (iout,*) "eps1_om12",eps1_om12," eps2rt_om12",eps2rt_om12
c      write (iout,*) "eom1",eom1," eom2",eom2," eom12",eom12
      do k=1,3
        dcosom1(k)=rij*(dc_norm(k,nres+i)-om1*erij(k))
        dcosom2(k)=rij*(dc_norm(k,nres+j)-om2*erij(k))
      enddo
      do k=1,3
        gg(k)=(gg(k)+eom1*dcosom1(k)+eom2*dcosom2(k))*sss
      enddo
c      write (iout,*) "gg",(gg(k),k=1,3)
      do k=1,3
        gvdwx(k,i)=gvdwx(k,i)-gg(k)+gg_lipi(k)
     &            +(eom12*(dc_norm(k,nres+j)-om12*dc_norm(k,nres+i))
     &            +eom1*(erij(k)-om1*dc_norm(k,nres+i)))*dsci_inv*sss
        gvdwx(k,j)=gvdwx(k,j)+gg(k)+gg_lipj(k)
     &            +(eom12*(dc_norm(k,nres+i)-om12*dc_norm(k,nres+j))
     &            +eom2*(erij(k)-om2*dc_norm(k,nres+j)))*dscj_inv*sss
c        write (iout,*)(eom12*(dc_norm(k,nres+j)-om12*dc_norm(k,nres+i))
c     &            +eom1*(erij(k)-om1*dc_norm(k,nres+i)))*dsci_inv
c        write (iout,*)(eom12*(dc_norm(k,nres+i)-om12*dc_norm(k,nres+j))
c     &            +eom2*(erij(k)-om2*dc_norm(k,nres+j)))*dscj_inv
      enddo
C
C Calculate the components of the gradient in DC and X
C
cgrad      do k=i,j-1
cgrad        do l=1,3
cgrad          gvdwc(l,k)=gvdwc(l,k)+gg(l)
cgrad        enddo
cgrad      enddo
      do l=1,3
        gvdwc(l,i)=gvdwc(l,i)-gg(l)+gg_lipi(l)
        gvdwc(l,j)=gvdwc(l,j)+gg(l)+gg_lipj(l)
      enddo
      return
      end
C-----------------------------------------------------------------------
      subroutine e_softsphere(evdw)
C
C This subroutine calculates the interaction energy of nonbonded side chains
C assuming the LJ potential of interaction.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      parameter (accur=1.0d-10)
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.TORSION'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
c      include 'COMMON.CONTACTS'
      dimension gg(3)
      double precision boxshift
cd    print *,'Entering Esoft_sphere nnt=',nnt,' nct=',nct
      evdw=0.0D0
c      do i=iatsc_s,iatsc_e
      do ikont=g_listscsc_start,g_listscsc_end
        i=newcontlisti(1,ikont)
        itypi=iabs(itype(i))
c        if (itypi.eq.ntyp1) cycle
        itypi1=iabs(itype(i+1))
        xi=c(1,nres+i)
        yi=c(2,nres+i)
        zi=c(3,nres+i)
        call to_box(xi,yi,zi)
C
C Calculate SC interaction energy.
C
c        do iint=1,nint_gr(i)
cd        write (iout,*) 'i=',i,' iint=',iint,' istart=',istart(i,iint),
cd   &                  'iend=',iend(i,iint)
c          do j=istart(i,iint),iend(i,iint)
         do jblock=newcontlisti(2,ikont-1)+1,newcontlisti(2,ikont)
         do j=newcontlistj(1,jblock),newcontlistj(2,jblock)
            itypj=iabs(itype(j))
c            if (itypj.eq.ntyp1) cycle
            xj=boxshift(c(1,nres+j)-xi,boxxsize)
            yj=boxshift(c(2,nres+j)-yi,boxysize)
            zj=boxshift(c(3,nres+j)-zi,boxzsize)
            rij=xj*xj+yj*yj+zj*zj
c           write (iout,*)'i=',i,' j=',j,' itypi=',itypi,' itypj=',itypj
            r0ij=r0(itypi,itypj)
            r0ijsq=r0ij*r0ij
c            print *,i,j,r0ij,dsqrt(rij)
            if (rij.lt.r0ijsq) then
              evdwij=0.25d0*(rij-r0ijsq)**2
              fac=rij-r0ijsq
            else
              evdwij=0.0d0
              fac=0.0d0
            endif
            evdw=evdw+evdwij
C
C Calculate the components of the gradient in DC and X
C
            gg(1)=xj*fac
            gg(2)=yj*fac
            gg(3)=zj*fac
            do k=1,3
              gvdwx(k,i)=gvdwx(k,i)-gg(k)
              gvdwx(k,j)=gvdwx(k,j)+gg(k)
              gvdwc(k,i)=gvdwc(k,i)-gg(k)
              gvdwc(k,j)=gvdwc(k,j)+gg(k)
            enddo
cgrad            do k=i,j-1
cgrad              do l=1,3
cgrad                gvdwc(l,k)=gvdwc(l,k)+gg(l)
cgrad              enddo
cgrad            enddo
          enddo ! j
        enddo ! iint
      enddo ! i
      return
      end
C--------------------------------------------------------------------------
      subroutine eelec_soft_sphere(ees,evdw1,eel_loc,eello_turn3,
     &              eello_turn4)
C
C Soft-sphere potential of p-p interaction
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
c      include 'COMMON.CONTACTS'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      dimension ggg(3)
      double precision boxshift
C      write(iout,*) 'In EELEC_soft_sphere'
      ees=0.0D0
      evdw1=0.0D0
      eel_loc=0.0d0
      eello_turn3=0.0d0
      eello_turn4=0.0d0
      ind=0
      do ikont=g_listpp_start,g_listpp_end
c      do i=iatel_s,iatel_e
        i=newcontlistppi(1,ikont)
c        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1) cycle
        dxi=dc(1,i)
        dyi=dc(2,i)
        dzi=dc(3,i)
        xmedi=c(1,i)+0.5d0*dxi
        ymedi=c(2,i)+0.5d0*dyi
        zmedi=c(3,i)+0.5d0*dzi
        call to_box(xmedi,ymedi,zmedi)
        num_conti=0
c        write (iout,*) 'i',i,' ielstart',ielstart(i),' ielend',ielend(i)
c        do j=ielstart(i),ielend(i)
        do jblock=newcontlistppi(2,ikont-1)+1,newcontlistppi(2,ikont)
         do j=newcontlistppj(1,jblock),newcontlistppj(2,jblock)
c          if (itype(j).eq.ntyp1 .or. itype(j+1).eq.ntyp1) cycle
          ind=ind+1
          iteli=itel(i)
          itelj=itel(j)
          if (j.eq.i+2 .and. itelj.eq.2) iteli=2
          r0ij=rpp(iteli,itelj)
          r0ijsq=r0ij*r0ij
          dxj=dc(1,j)
          dyj=dc(2,j)
          dzj=dc(3,j)
          xj=c(1,j)+0.5D0*dxj
          yj=c(2,j)+0.5D0*dyj
          zj=c(3,j)+0.5D0*dzj
          call to_box(xj,yj,zj)
          xj=boxshift(xj-xmedi,boxxsize)
          yj=boxshift(yj-ymedi,boxysize)
          zj=boxshift(zj-zmedi,boxzsize)
          rij=xj*xj+yj*yj+zj*zj
            sss=sscale(sqrt(rij),r_cut_int)
            sssgrad=sscagrad(sqrt(rij),r_cut_int)
          if (rij.lt.r0ijsq) then
            evdw1ij=0.25d0*(rij-r0ijsq)**2
            fac=rij-r0ijsq
          else
            evdw1ij=0.0d0
            fac=0.0d0
          endif
          evdw1=evdw1+evdw1ij*sss
C
C Calculate contributions to the Cartesian gradient.
C
          ggg(1)=fac*xj*sssgrad
          ggg(2)=fac*yj*sssgrad
          ggg(3)=fac*zj*sssgrad
          do k=1,3
            gvdwpp(k,i)=gvdwpp(k,i)-ggg(k)
            gvdwpp(k,j)=gvdwpp(k,j)+ggg(k)
          enddo
*
* Loop over residues i+1 thru j-1.
*
cgrad          do k=i+1,j-1
cgrad            do l=1,3
cgrad              gelc(l,k)=gelc(l,k)+ggg(l)
cgrad            enddo
cgrad          enddo
        enddo ! j
       enddo ! jblock
      enddo   ! ikont
cgrad      do i=nnt,nct-1
cgrad        do k=1,3
cgrad          gelc(k,i)=gelc(k,i)+0.5d0*gelc(k,i)
cgrad        enddo
cgrad        do j=i+1,nct-1
cgrad          do k=1,3
cgrad            gelc(k,i)=gelc(k,i)+gelc(k,j)
cgrad          enddo
cgrad        enddo
cgrad      enddo
      return
      end
C-----------------------------------------------------------------------------
      subroutine escp_soft_sphere(evdw2,evdw2_14)
C
C This subroutine calculates the excluded-volume interaction energy between
C peptide-group centers and side chains and its gradient in virtual-bond and
C side-chain vectors.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.FFIELD'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      dimension ggg(3)
      double precision boxshift
      evdw2=0.0D0
      evdw2_14=0.0d0
      r0_scp=4.5d0
cd    print '(a)','Enter ESCP'
cd    write (iout,*) 'iatscp_s=',iatscp_s,' iatscp_e=',iatscp_e
c      do i=iatscp_s,iatscp_e
      do ikont=g_listscp_start,g_listscp_end
        i=newcontlistscpi(1,ikont)
        do jblock=newcontlistscpi(2,ikont-1)+1,newcontlistscpi(2,ikont)
        do j=newcontlistscpj(1,jblock),newcontlistscpj(2,jblock)
c        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1) cycle
        iteli=itel(i)
        xi=0.5D0*(c(1,i)+c(1,i+1))
        yi=0.5D0*(c(2,i)+c(2,i+1))
        zi=0.5D0*(c(3,i)+c(3,i+1))
c        do iint=1,nscp_gr(i)

c        do j=iscpstart(i,iint),iscpend(i,iint)
c          if (itype(j).eq.ntyp1) cycle
          itypj=iabs(itype(j))
C Uncomment following three lines for SC-p interactions
c         xj=c(1,nres+j)-xi
c         yj=c(2,nres+j)-yi
c         zj=c(3,nres+j)-zi
C Uncomment following three lines for Ca-p interactions
          xj=c(1,j)
          yj=c(2,j)
          zj=c(3,j)
          call to_box(xj,yj,zj)
          xj=boxshift(xj-xi,boxxsize)
          yj=boxshift(yj-yi,boxysize)
          zj=boxshift(zj-zi,boxzsize)
C          xj=xj-xi
C          yj=yj-yi
C          zj=zj-zi
          rij=xj*xj+yj*yj+zj*zj

          r0ij=r0_scp
          r0ijsq=r0ij*r0ij
          if (rij.lt.r0ijsq) then
            evdwij=0.25d0*(rij-r0ijsq)**2
            fac=rij-r0ijsq
          else
            evdwij=0.0d0
            fac=0.0d0
          endif
          evdw2=evdw2+evdwij
C
C Calculate contributions to the gradient in the virtual-bond and SC vectors.
C
          ggg(1)=xj*fac
          ggg(2)=yj*fac
          ggg(3)=zj*fac
          do k=1,3
            gvdwc_scpp(k,i)=gvdwc_scpp(k,i)-ggg(k)
            gvdwc_scp(k,j)=gvdwc_scp(k,j)+ggg(k)
          enddo ! k
        enddo ! j
        enddo ! jblock
      enddo ! ikont
      return
      end
C--------------------------------------------------------------------------
      subroutine ssbond_ene(i,j,eij)
C
C Calculate the distance and angle dependent SS-bond potential energy
C using a free-energy function derived based on RHF/6-31G** ab initio
C calculations of diethyl disulfide.
C
C A. Liwo and U. Kozlowska, 11/24/03
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.LOCAL'
      include 'COMMON.INTERACT'
      include 'COMMON.VAR'
      include 'COMMON.IOUNITS'
      double precision erij(3),dcosom1(3),dcosom2(3),gg(3)
      itypi=iabs(itype(i))
      xi=c(1,nres+i)
      yi=c(2,nres+i)
      zi=c(3,nres+i)
      dxi=dc_norm(1,nres+i)
      dyi=dc_norm(2,nres+i)
      dzi=dc_norm(3,nres+i)
c      dsci_inv=dsc_inv(itypi)
      dsci_inv=vbld_inv(nres+i)
      itypj=iabs(itype(j))
c      dscj_inv=dsc_inv(itypj)
      dscj_inv=vbld_inv(nres+j)
      xj=c(1,nres+j)-xi
      yj=c(2,nres+j)-yi
      zj=c(3,nres+j)-zi
      dxj=dc_norm(1,nres+j)
      dyj=dc_norm(2,nres+j)
      dzj=dc_norm(3,nres+j)
      rrij=1.0D0/(xj*xj+yj*yj+zj*zj)
      rij=dsqrt(rrij)
      erij(1)=xj*rij
      erij(2)=yj*rij
      erij(3)=zj*rij
      om1=dxi*erij(1)+dyi*erij(2)+dzi*erij(3)
      om2=dxj*erij(1)+dyj*erij(2)+dzj*erij(3)
      om12=dxi*dxj+dyi*dyj+dzi*dzj
      do k=1,3
        dcosom1(k)=rij*(dc_norm(k,nres+i)-om1*erij(k))
        dcosom2(k)=rij*(dc_norm(k,nres+j)-om2*erij(k))
      enddo
      rij=1.0d0/rij
      deltad=rij-d0cm
      deltat1=1.0d0-om1
      deltat2=1.0d0+om2
      deltat12=om2-om1+2.0d0
      cosphi=om12-om1*om2
      eij=akcm*deltad*deltad+akth*(deltat1*deltat1+deltat2*deltat2)
     &  +akct*deltad*deltat12
     &  +v1ss*cosphi+v2ss*cosphi*cosphi+v3ss*cosphi*cosphi*cosphi+ebr
c      write(iout,*) i,j,"rij",rij,"d0cm",d0cm," akcm",akcm," akth",akth,
c     &  " akct",akct," deltad",deltad," deltat",deltat1,deltat2,
c     &  " deltat12",deltat12," eij",eij
      ed=2*akcm*deltad+akct*deltat12
      pom1=akct*deltad
      pom2=v1ss+2*v2ss*cosphi+3*v3ss*cosphi*cosphi
      eom1=-2*akth*deltat1-pom1-om2*pom2
      eom2= 2*akth*deltat2+pom1-om1*pom2
      eom12=pom2
      do k=1,3
        ggk=ed*erij(k)+eom1*dcosom1(k)+eom2*dcosom2(k)
        ghpbx(k,i)=ghpbx(k,i)-ggk
     &            +(eom12*(dc_norm(k,nres+j)-om12*dc_norm(k,nres+i))
     &            +eom1*(erij(k)-om1*dc_norm(k,nres+i)))*dsci_inv
        ghpbx(k,j)=ghpbx(k,j)+ggk
     &            +(eom12*(dc_norm(k,nres+i)-om12*dc_norm(k,nres+j))
     &            +eom2*(erij(k)-om2*dc_norm(k,nres+j)))*dscj_inv
        ghpbc(k,i)=ghpbc(k,i)-ggk
        ghpbc(k,j)=ghpbc(k,j)+ggk
      enddo
C
C Calculate the components of the gradient in DC and X
C
cgrad      do k=i,j-1
cgrad        do l=1,3
cgrad          ghpbc(l,k)=ghpbc(l,k)+gg(l)
cgrad        enddo
cgrad      enddo
      return
      end
C--------------------------------------------------------------------------
      subroutine ebond(estr)
#ifdef _OPENMP
      use omp_lib
#endif
c
c Evaluate the energy of stretching of the CA-CA and CA-SC virtual bonds
c
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.LOCAL'
      include 'COMMON.GEO'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.FFIELD'
      include 'COMMON.CONTROL'
      include 'COMMON.SETUP'
      double precision u(3),ud(3)
      double precision estr
      double precision estr1,diff,uprod,uprod1,uprod2,usumsqder,usum
      double precision fac,iusum
      double precision th_estr(8,max_fg_threads)
      integer i,j,k,iti,nbi,my_thread,threads_used,from,to
#ifdef ENERGY_DEC
      if (energy_dec) write (iout,*) "ebond"
#endif
      estr=0.0d0
      estr1=0.0d0
      th_estr=0.0d0

      threads_used=omp_get_max_threads()

!$OMP PARALLEL DEFAULT(SHARED) PRIVATE(i,diff,fac,j,my_thread,from,to)
      !do i=ibondp_start,ibondp_end
      my_thread=omp_get_thread_num()+1
      call split_work_for_threads(from,to,ibondp_start,ibondp_end,
     &                            my_thread,threads_used)
      do i=from,to
c  3/4/2020 Adam: removed dummy bond graient if Calpha and SC coords are
c      used
#ifdef FIVEDIAG
        if (itype(i-1).eq.ntyp1 .or. itype(i).eq.ntyp1) cycle
          diff = vbld(i)-vbldp0
#else
        if (itype(i-1).eq.ntyp1 .and. itype(i).eq.ntyp1) cycle
c          estr1=estr1+gnmr1(vbld(i),-1.0d0,distchainmax)
c          do j=1,3
c          gradb(j,i-1)=gnmr1prim(vbld(i),-1.0d0,distchainmax)
c     &      *dc(j,i-1)/vbld(i)
c          enddo
c          if (energy_dec) write(iout,*)
c     &       "estr1",i,gnmr1(vbld(i),-1.0d0,distchainmax)
c        else
C       Checking if it involves dummy (NH3+ or COO-) group
        if (itype(i-1).eq.ntyp1 .or. itype(i).eq.ntyp1) then
C YES   vbldpDUM is the equlibrium length of spring for Dummy atom
          diff = vbld(i)-vbldpDUM
#ifdef ENERGY_DEC
          if (energy_dec) write(iout,*) "dum_bond",i,diff
#endif
        else
C NO    vbldp0 is the equlibrium length of spring for peptide group
          diff = vbld(i)-vbldp0
        endif
#endif
#ifdef ENERGY_DEC
        if (energy_dec) write (iout,'(a3,i6,3(a,f10.5))') 
     &   restyp(itype(i)),i," estr bb",AKP*diff*diff," blength",vbld(i),
     &   " diff",diff
#endif
        !estr=estr+diff*diff
        !my_thread=omp_get_thread_num()+1
        th_estr(1,my_thread)=th_estr(1,my_thread)+diff*diff
        !fac=AKP*diff*vbld_inv(i)
        fac=AKP*diff
        do j=1,3
          !gradb(j,i-1)=AKP*diff*dc(j,i-1)/vbld(i)
          !gradb(j,i-1)=AKP*diff*dc(j,i-1)*vbld_inv(i)
          !gradb(j,i-1)=dc(j,i-1)*fac
          gradb(j,i-1)=fac*dc_norm(j,i-1)
        enddo
c        write (iout,'(i5,3f10.5)') i,(gradb(j,i-1),j=1,3)
c        endif
      enddo
!$OMP END PARALLEL

      !estr=0.5d0*AKP*estr+estr1
      estr=0.0d0
      do i=1,threads_used
        !th_estr(1,i)=0.5d0*AKP*th_estr(1,i)
        estr=estr+th_estr(1,i)
      enddo
      estr=0.5d0*AKP*estr+estr1
      th_estr=0.0d0
c
c 09/18/07 AL: multimodal bond potential based on AM1 CA-SC PMF's included
c
!$OMP PARALLEL DEFAULT(SHARED)
!$OMP& PRIVATE(i,j,k,iti,nbi,diff,ud,u,uprod,usum,usumsqder,
!$OMP&         uprod1,uprod2,iusum,fac,my_thread,from,to)
      !do i=ibond_start,ibond_end
      my_thread=omp_get_thread_num()+1
      call split_work_for_threads(from,to,ibond_start,ibond_end,
     &                            my_thread,threads_used)
      do i=from,to
        iti=iabs(itype(i))
        if (iti.ne.10 .and. iti.ne.ntyp1) then
          nbi=nbondterm(iti)
          if (nbi.eq.1) then
            diff=vbld(i+nres)-vbldsc0(1,iti)
#ifdef ENERGY_DEC
            if (energy_dec)  write (iout,'(a3,i6,i3,3(a,f10.5))') 
     &      restyp(iti),i,nbi," estr sc",AKSC(1,iti)*diff*diff,
     &        " blength",vbld(i+nres)," diff",diff
#endif
            !estr=estr+0.5d0*AKSC(1,iti)*diff*diff
            my_thread=omp_get_thread_num()+1
            th_estr(1,my_thread)=th_estr(1,my_thread)
     &                          +0.5d0*AKSC(1,iti)*diff*diff
            !fac=AKSC(1,iti)*diff*vbld_inv(i+nres)
            fac=AKSC(1,iti)*diff
            do j=1,3
              !gradbx(j,i)=AKSC(1,iti)*diff*dc(j,i+nres)/vbld(i+nres)
              !gradbx(j,i)=dc(j,i+nres)*fac
              gradbx(j,i)=fac*dc_norm(j,i+nres)
            enddo
          else
            do j=1,nbi
              diff=vbld(i+nres)-vbldsc0(j,iti)
              ud(j)=aksc(j,iti)*diff
              u(j)=abond0(j,iti)+0.5d0*ud(j)*diff
            enddo
            uprod=u(1)
            do j=2,nbi
              uprod=uprod*u(j)
            enddo
            usum=0.0d0
            usumsqder=0.0d0
            do j=1,nbi
              uprod1=1.0d0
              uprod2=1.0d0
              do k=1,nbi
                if (k.ne.j) then
                  uprod1=uprod1*u(k)
                  uprod2=uprod2*u(k)*u(k)
                endif
              enddo
              usum=usum+uprod1
              usumsqder=usumsqder+ud(j)*uprod2
            enddo
#ifdef ENERGY_DEC
            if (energy_dec) 
     &       write (iout,'(a3,i6,i3,2(a,f10.5),a,20f10.5)')
     &         restyp(iti),i,nbi," blength",vbld(i+nres)," estr sc",
     &         uprod/usum," diff",(vbld(i+nres)-vbldsc0(j,iti),j=1,nbi)
#endif
            !estr=estr+uprod/usum
            !iusum=1.0d0/usum
            my_thread=omp_get_thread_num()+1
            !th_estr(1,my_thread)=th_estr(1,my_thread)+uprod*iusum
            th_estr(1,my_thread)=th_estr(1,my_thread)+uprod/usum
            !fac=usumsqder*iusum*iusum*vbld_inv(i+nres)
            fac=usumsqder/(usum*usum)
            do j=1,3
              !gradbx(j,i)=usumsqder/(usum*usum)*dc(j,i+nres)/vbld(i+nres)
              !gradbx(j,i)=dc(j,i+nres)*fac
              gradbx(j,i)=fac*dc_norm(j,i+nres)
            enddo
          endif
        endif
      enddo
!$OMP END PARALLEL

      !estr=0.0d0
      do i=1,threads_used
        !estr1=estr1+th_estr(1,i)
        estr=estr+th_estr(1,i)
      enddo
      !estr=estr+estr1
#ifdef ENERGY_DEC
      if (energy_dec) write (iout,'(80(1h-))')
#endif
      return
      end
#ifdef CRYST_THETA
C--------------------------------------------------------------------------
      subroutine ebend(etheta)
C
C Evaluate the virtual-bond-angle energy given the virtual-bond dihedral
C angles gamma and its derivatives in consecutive thetas and gammas.
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.LOCAL'
      include 'COMMON.GEO'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.FFIELD'
      include 'COMMON.CONTROL'
      include 'COMMON.TORCNSTR'
      common /calcthet/ term1,term2,termm,diffak,ratak,
     & ak,aktc,termpre,termexp,sigc,sig0i,time11,time12,sigcsq,
     & delthe0,sig0inv,sigtc,sigsqtc,delthec,it
      double precision y(2),z(2)
      delta=0.02d0*pi
c      time11=dexp(-2*time)
c      time12=1.0d0
      etheta=0.0D0
c     write (*,'(a,i2)') 'EBEND ICG=',icg
      do i=ithet_start,ithet_end
        if ((itype(i-1).eq.ntyp1).or.itype(i-2).eq.ntyp1
     &  .or.itype(i).eq.ntyp1) cycle
C Zero the energy function and its derivative at 0 or pi.
        call splinthet(theta(i),0.5d0*delta,ss,ssd)
        it=itype(i-1)
        ichir1=isign(1,itype(i-2))
        ichir2=isign(1,itype(i))
         if (itype(i-2).eq.10) ichir1=isign(1,itype(i-1))
         if (itype(i).eq.10) ichir2=isign(1,itype(i-1))
         if (itype(i-1).eq.10) then
          itype1=isign(10,itype(i-2))
          ichir11=isign(1,itype(i-2))
          ichir12=isign(1,itype(i-2))
          itype2=isign(10,itype(i))
          ichir21=isign(1,itype(i))
          ichir22=isign(1,itype(i))
         endif

        if (i.gt.3 .and. itype(i-3).ne.ntyp1) then
#ifdef OSF
          phii=phi(i)
          if (phii.ne.phii) phii=150.0
#else
          phii=phi(i)
#endif
          y(1)=dcos(phii)
          y(2)=dsin(phii)
        else
          y(1)=0.0D0
          y(2)=0.0D0
        endif
        if (i.lt.nres .and. itype(i+1).ne.ntyp1) then
#ifdef OSF
          phii1=phi(i+1)
          if (phii1.ne.phii1) phii1=150.0
          phii1=pinorm(phii1)
          z(1)=cos(phii1)
#else
          phii1=phi(i+1)
#endif
          z(1)=dcos(phii1)
          z(2)=dsin(phii1)
        else
          z(1)=0.0D0
          z(2)=0.0D0
        endif
C Calculate the "mean" value of theta from the part of the distribution
C dependent on the adjacent virtual-bond-valence angles (gamma1 & gamma2).
C In following comments this theta will be referred to as t_c.
        thet_pred_mean=0.0d0
        do k=1,2
            athetk=athet(k,it,ichir1,ichir2)
            bthetk=bthet(k,it,ichir1,ichir2)
          if (it.eq.10) then
             athetk=athet(k,itype1,ichir11,ichir12)
             bthetk=bthet(k,itype2,ichir21,ichir22)
          endif
         thet_pred_mean=thet_pred_mean+athetk*y(k)+bthetk*z(k)
c         write(iout,*) 'Error tu', y(k),z(k)
        enddo
        dthett=thet_pred_mean*ssd
        thet_pred_mean=thet_pred_mean*ss+a0thet(it)
C Derivatives of the "mean" values in gamma1 and gamma2.
        dthetg1=(-athet(1,it,ichir1,ichir2)*y(2)
     &+athet(2,it,ichir1,ichir2)*y(1))*ss
         dthetg2=(-bthet(1,it,ichir1,ichir2)*z(2)
     &          +bthet(2,it,ichir1,ichir2)*z(1))*ss
         if (it.eq.10) then
      dthetg1=(-athet(1,itype1,ichir11,ichir12)*y(2)
     &+athet(2,itype1,ichir11,ichir12)*y(1))*ss
        dthetg2=(-bthet(1,itype2,ichir21,ichir22)*z(2)
     &         +bthet(2,itype2,ichir21,ichir22)*z(1))*ss
         endif
        if (theta(i).gt.pi-delta) then
          call theteng(pi-delta,thet_pred_mean,theta0(it),f0,fprim0,
     &         E_tc0)
          call mixder(pi-delta,thet_pred_mean,theta0(it),fprim_tc0)
          call theteng(pi,thet_pred_mean,theta0(it),f1,fprim1,E_tc1)
          call spline1(theta(i),pi-delta,delta,f0,f1,fprim0,ethetai,
     &        E_theta)
          call spline2(theta(i),pi-delta,delta,E_tc0,E_tc1,fprim_tc0,
     &        E_tc)
        else if (theta(i).lt.delta) then
          call theteng(delta,thet_pred_mean,theta0(it),f0,fprim0,E_tc0)
          call theteng(0.0d0,thet_pred_mean,theta0(it),f1,fprim1,E_tc1)
          call spline1(theta(i),delta,-delta,f0,f1,fprim0,ethetai,
     &        E_theta)
          call mixder(delta,thet_pred_mean,theta0(it),fprim_tc0)
          call spline2(theta(i),delta,-delta,E_tc0,E_tc1,fprim_tc0,
     &        E_tc)
        else
          call theteng(theta(i),thet_pred_mean,theta0(it),ethetai,
     &        E_theta,E_tc)
        endif
        etheta=etheta+ethetai
#ifdef ENERGY_DEC
        if (energy_dec) write (iout,'(a6,i5,0pf7.3,f7.3,i5)')
     &      'ebend',i,ethetai,theta(i),itype(i)
#endif
        if (i.gt.3) gloc(i-3,icg)=gloc(i-3,icg)+wang*E_tc*dthetg1
        if (i.lt.nres) gloc(i-2,icg)=gloc(i-2,icg)+wang*E_tc*dthetg2
        gloc(nphi+i-2,icg)=wang*(E_theta+E_tc*dthett)+gloc(nphi+i-2,icg)
      enddo

C Ufff.... We've done all this!!!
      return
      end
C---------------------------------------------------------------------------
      subroutine theteng(thetai,thet_pred_mean,theta0i,ethetai,E_theta,
     &     E_tc)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.LOCAL'
      include 'COMMON.IOUNITS'
      common /calcthet/ term1,term2,termm,diffak,ratak,
     & ak,aktc,termpre,termexp,sigc,sig0i,time11,time12,sigcsq,
     & delthe0,sig0inv,sigtc,sigsqtc,delthec,it
C Calculate the contributions to both Gaussian lobes.
C 6/6/97 - Deform the Gaussians using the factor of 1/(1+time)
C The "polynomial part" of the "standard deviation" of this part of
C the distributioni.
ccc        write (iout,*) thetai,thet_pred_mean
        sig=polthet(3,it)
        do j=2,0,-1
          sig=sig*thet_pred_mean+polthet(j,it)
        enddo
C Derivative of the "interior part" of the "standard deviation of the"
C gamma-dependent Gaussian lobe in t_c.
        sigtc=3*polthet(3,it)
        do j=2,1,-1
          sigtc=sigtc*thet_pred_mean+j*polthet(j,it)
        enddo
        sigtc=sig*sigtc
C Set the parameters of both Gaussian lobes of the distribution.
C "Standard deviation" of the gamma-dependent Gaussian lobe (sigtc)
        fac=sig*sig+sigc0(it)
        sigcsq=fac+fac
        sigc=1.0D0/sigcsq
C Following variable (sigsqtc) is -(1/2)d[sigma(t_c)**(-2))]/dt_c
        sigsqtc=-4.0D0*sigcsq*sigtc
c       print *,i,sig,sigtc,sigsqtc
C Following variable (sigtc) is d[sigma(t_c)]/dt_c
        sigtc=-sigtc/(fac*fac)
C Following variable is sigma(t_c)**(-2)
        sigcsq=sigcsq*sigcsq
        sig0i=sig0(it)
        sig0inv=1.0D0/sig0i**2
        delthec=thetai-thet_pred_mean
        delthe0=thetai-theta0i
        term1=-0.5D0*sigcsq*delthec*delthec
        term2=-0.5D0*sig0inv*delthe0*delthe0
C        write (iout,*)'term1',term1,term2,sigcsq,delthec,sig0inv,delthe0
C Following fuzzy logic is to avoid underflows in dexp and subsequent INFs and
C NaNs in taking the logarithm. We extract the largest exponent which is added
C to the energy (this being the log of the distribution) at the end of energy
C term evaluation for this virtual-bond angle.
        if (term1.gt.term2) then
          termm=term1
          term2=dexp(term2-termm)
          term1=1.0d0
        else
          termm=term2
          term1=dexp(term1-termm)
          term2=1.0d0
        endif
C The ratio between the gamma-independent and gamma-dependent lobes of
C the distribution is a Gaussian function of thet_pred_mean too.
        diffak=gthet(2,it)-thet_pred_mean
        ratak=diffak/gthet(3,it)**2
        ak=dexp(gthet(1,it)-0.5D0*diffak*ratak)
C Let's differentiate it in thet_pred_mean NOW.
        aktc=ak*ratak
C Now put together the distribution terms to make complete distribution.
        termexp=term1+ak*term2
        termpre=sigc+ak*sig0i
C Contribution of the bending energy from this theta is just the -log of
C the sum of the contributions from the two lobes and the pre-exponential
C factor. Simple enough, isn't it?
        ethetai=(-dlog(termexp)-termm+dlog(termpre))
C       write (iout,*) 'termexp',termexp,termm,termpre,i
C NOW the derivatives!!!
C 6/6/97 Take into account the deformation.
        E_theta=(delthec*sigcsq*term1
     &       +ak*delthe0*sig0inv*term2)/termexp
        E_tc=((sigtc+aktc*sig0i)/termpre
     &      -((delthec*sigcsq+delthec*delthec*sigsqtc)*term1+
     &       aktc*term2)/termexp)
      return
      end
c-----------------------------------------------------------------------------
      subroutine mixder(thetai,thet_pred_mean,theta0i,E_tc_t)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.LOCAL'
      include 'COMMON.IOUNITS'
      common /calcthet/ term1,term2,termm,diffak,ratak,
     & ak,aktc,termpre,termexp,sigc,sig0i,time11,time12,sigcsq,
     & delthe0,sig0inv,sigtc,sigsqtc,delthec,it
      delthec=thetai-thet_pred_mean
      delthe0=thetai-theta0i
C "Thank you" to MAPLE (probably spared one day of hand-differentiation).
      t3 = thetai-thet_pred_mean
      t6 = t3**2
      t9 = term1
      t12 = t3*sigcsq
      t14 = t12+t6*sigsqtc
      t16 = 1.0d0
      t21 = thetai-theta0i
      t23 = t21**2
      t26 = term2
      t27 = t21*t26
      t32 = termexp
      t40 = t32**2
      E_tc_t = -((sigcsq+2.D0*t3*sigsqtc)*t9-t14*sigcsq*t3*t16*t9
     & -aktc*sig0inv*t27)/t32+(t14*t9+aktc*t26)/t40
     & *(-t12*t9-ak*sig0inv*t27)
      return
      end
#else
C--------------------------------------------------------------------------
      subroutine ebend(etheta)
C
C Evaluate the virtual-bond-angle energy given the virtual-bond dihedral
C angles gamma and its derivatives in consecutive thetas and gammas.
C ab initio-derived potentials from
c Kozlowska et al., J. Phys.: Condens. Matter 19 (2007) 285203
C
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.LOCAL'
      include 'COMMON.GEO'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.FFIELD'
      include 'COMMON.CONTROL'
      include 'COMMON.TORCNSTR'
      double precision coskt(mmaxtheterm),sinkt(mmaxtheterm),
     & cosph1(maxsingle),sinph1(maxsingle),cosph2(maxsingle),
     & sinph2(maxsingle),cosph1ph2(maxdouble,maxdouble),
     & sinph1ph2(maxdouble,maxdouble)
      logical lprn /.false./, lprn1 /.false./
      etheta=0.0D0
      do i=ithet_start,ithet_end
c        print *,i,itype(i-1),itype(i),itype(i-2)
        if ((itype(i-1).eq.ntyp1).or.itype(i-2).eq.ntyp1
     &  .or.itype(i).eq.ntyp1) cycle
C        print *,i,theta(i)
        if (iabs(itype(i+1)).eq.20) iblock=2
        if (iabs(itype(i+1)).ne.20) iblock=1
        dethetai=0.0d0
        dephii=0.0d0
        dephii1=0.0d0
        theti2=0.5d0*theta(i)
        ityp2=ithetyp((itype(i-1)))
        do k=1,nntheterm
          coskt(k)=dcos(k*theti2)
          sinkt(k)=dsin(k*theti2)
        enddo
C        print *,ethetai
        if (i.gt.3 .and. itype(i-3).ne.ntyp1) then
#ifdef OSF
          phii=phi(i)
          if (phii.ne.phii) phii=150.0
#else
          phii=phi(i)
#endif
          ityp1=ithetyp((itype(i-2)))
C propagation of chirality for glycine type
          do k=1,nsingle
            cosph1(k)=dcos(k*phii)
            sinph1(k)=dsin(k*phii)
          enddo
        else
          phii=0.0d0
          do k=1,nsingle
          ityp1=ithetyp((itype(i-2)))
            cosph1(k)=0.0d0
            sinph1(k)=0.0d0
          enddo
        endif
        if (i.lt.nres .and. itype(i+1).ne.ntyp1) then
#ifdef OSF
          phii1=phi(i+1)
          if (phii1.ne.phii1) phii1=150.0
          phii1=pinorm(phii1)
#else
          phii1=phi(i+1)
#endif
          ityp3=ithetyp((itype(i)))
          do k=1,nsingle
            cosph2(k)=dcos(k*phii1)
            sinph2(k)=dsin(k*phii1)
          enddo
        else
          phii1=0.0d0
          ityp3=ithetyp((itype(i)))
          do k=1,nsingle
            cosph2(k)=0.0d0
            sinph2(k)=0.0d0
          enddo
        endif
        ethetai=aa0thet(ityp1,ityp2,ityp3,iblock)
        do k=1,ndouble
          do l=1,k-1
            ccl=cosph1(l)*cosph2(k-l)
            ssl=sinph1(l)*sinph2(k-l)
            scl=sinph1(l)*cosph2(k-l)
            csl=cosph1(l)*sinph2(k-l)
            cosph1ph2(l,k)=ccl-ssl
            cosph1ph2(k,l)=ccl+ssl
            sinph1ph2(l,k)=scl+csl
            sinph1ph2(k,l)=scl-csl
          enddo
        enddo
        if (lprn) then
        write (iout,*) "i",i," ityp1",ityp1," ityp2",ityp2,
     &    " ityp3",ityp3," theti2",theti2," phii",phii," phii1",phii1
        write (iout,*) "coskt and sinkt"
        do k=1,nntheterm
          write (iout,*) k,coskt(k),sinkt(k)
        enddo
        endif
        do k=1,ntheterm
          ethetai=ethetai+aathet(k,ityp1,ityp2,ityp3,iblock)*sinkt(k)
          dethetai=dethetai+0.5d0*k*aathet(k,ityp1,ityp2,ityp3,iblock)
     &      *coskt(k)
          if (lprn)
     &    write (iout,*) "k",k,"
     &     aathet",aathet(k,ityp1,ityp2,ityp3,iblock),
     &     " ethetai",ethetai
        enddo
        if (lprn) then
        write (iout,*) "cosph and sinph"
        do k=1,nsingle
          write (iout,*) k,cosph1(k),sinph1(k),cosph2(k),sinph2(k)
        enddo
        write (iout,*) "cosph1ph2 and sinph2ph2"
        do k=2,ndouble
          do l=1,k-1
            write (iout,*) l,k,cosph1ph2(l,k),cosph1ph2(k,l),
     &         sinph1ph2(l,k),sinph1ph2(k,l)
          enddo
        enddo
        write(iout,*) "ethetai",ethetai
        endif
C       print *,ethetai
        do m=1,ntheterm2
          do k=1,nsingle
            aux=bbthet(k,m,ityp1,ityp2,ityp3,iblock)*cosph1(k)
     &         +ccthet(k,m,ityp1,ityp2,ityp3,iblock)*sinph1(k)
     &         +ddthet(k,m,ityp1,ityp2,ityp3,iblock)*cosph2(k)
     &         +eethet(k,m,ityp1,ityp2,ityp3,iblock)*sinph2(k)
            ethetai=ethetai+sinkt(m)*aux
            dethetai=dethetai+0.5d0*m*aux*coskt(m)
            dephii=dephii+k*sinkt(m)*(
     &          ccthet(k,m,ityp1,ityp2,ityp3,iblock)*cosph1(k)-
     &          bbthet(k,m,ityp1,ityp2,ityp3,iblock)*sinph1(k))
            dephii1=dephii1+k*sinkt(m)*(
     &          eethet(k,m,ityp1,ityp2,ityp3,iblock)*cosph2(k)-
     &          ddthet(k,m,ityp1,ityp2,ityp3,iblock)*sinph2(k))
            if (lprn)
     &      write (iout,*) "m",m," k",k," bbthet",
     &         bbthet(k,m,ityp1,ityp2,ityp3,iblock)," ccthet",
     &         ccthet(k,m,ityp1,ityp2,ityp3,iblock)," ddthet",
     &         ddthet(k,m,ityp1,ityp2,ityp3,iblock)," eethet",
     &         eethet(k,m,ityp1,ityp2,ityp3,iblock)," ethetai",ethetai
C        print *,"tu",cosph1(k),sinph1(k),cosph2(k),sinph2(k)
          enddo
        enddo
C        print *,"cosph1", (cosph1(k), k=1,nsingle)
C        print *,"cosph2", (cosph2(k), k=1,nsingle)
C        print *,"sinph1", (sinph1(k), k=1,nsingle)
C        print *,"sinph2", (sinph2(k), k=1,nsingle)
        if (lprn)
     &  write(iout,*) "ethetai",ethetai
C        print *,"tu",cosph1(k),sinph1(k),cosph2(k),sinph2(k)
        do m=1,ntheterm3
          do k=2,ndouble
            do l=1,k-1
              aux=ffthet(l,k,m,ityp1,ityp2,ityp3,iblock)*cosph1ph2(l,k)+
     &            ffthet(k,l,m,ityp1,ityp2,ityp3,iblock)*cosph1ph2(k,l)+
     &            ggthet(l,k,m,ityp1,ityp2,ityp3,iblock)*sinph1ph2(l,k)+
     &            ggthet(k,l,m,ityp1,ityp2,ityp3,iblock)*sinph1ph2(k,l)
              ethetai=ethetai+sinkt(m)*aux
              dethetai=dethetai+0.5d0*m*coskt(m)*aux
              dephii=dephii+l*sinkt(m)*(
     &           -ffthet(l,k,m,ityp1,ityp2,ityp3,iblock)*sinph1ph2(l,k)-
     &            ffthet(k,l,m,ityp1,ityp2,ityp3,iblock)*sinph1ph2(k,l)+
     &            ggthet(l,k,m,ityp1,ityp2,ityp3,iblock)*cosph1ph2(l,k)+
     &            ggthet(k,l,m,ityp1,ityp2,ityp3,iblock)*cosph1ph2(k,l))
              dephii1=dephii1+(k-l)*sinkt(m)*(
     &           -ffthet(l,k,m,ityp1,ityp2,ityp3,iblock)*sinph1ph2(l,k)+
     &            ffthet(k,l,m,ityp1,ityp2,ityp3,iblock)*sinph1ph2(k,l)+
     &            ggthet(l,k,m,ityp1,ityp2,ityp3,iblock)*cosph1ph2(l,k)-
     &            ggthet(k,l,m,ityp1,ityp2,ityp3,iblock)*cosph1ph2(k,l))
              if (lprn) then
              write (iout,*) "m",m," k",k," l",l," ffthet",
     &            ffthet(l,k,m,ityp1,ityp2,ityp3,iblock),
     &            ffthet(k,l,m,ityp1,ityp2,ityp3,iblock)," ggthet",
     &            ggthet(l,k,m,ityp1,ityp2,ityp3,iblock),
     &            ggthet(k,l,m,ityp1,ityp2,ityp3,iblock),
     &            " ethetai",ethetai
              write (iout,*) cosph1ph2(l,k)*sinkt(m),
     &            cosph1ph2(k,l)*sinkt(m),
     &            sinph1ph2(l,k)*sinkt(m),sinph1ph2(k,l)*sinkt(m)
              endif
            enddo
          enddo
        enddo
10      continue
c        lprn1=.true.
C        print *,ethetai
        if (lprn1)
     &    write (iout,'(i2,3f8.1,9h ethetai ,f10.5)')
     &   i,theta(i)*rad2deg,phii*rad2deg,
     &   phii1*rad2deg,ethetai
c        lprn1=.false.
        etheta=etheta+ethetai
        if (i.gt.3) gloc(i-3,icg)=gloc(i-3,icg)+wang*dephii
        if (i.lt.nres) gloc(i-2,icg)=gloc(i-2,icg)+wang*dephii1
        gloc(nphi+i-2,icg)=gloc(nphi+i-2,icg)+wang*dethetai
      enddo

      return
      end
#endif
#ifdef CRYST_SC
c-----------------------------------------------------------------------------
      subroutine esc(escloc)
C Calculate the local energy of a side chain and its derivatives in the
C corresponding virtual-bond valence angles THETA and the spherical angles
C ALPHA and OMEGA.
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.VAR'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.FFIELD'
      include 'COMMON.CONTROL'
      double precision x(3),dersc(3),xemp(3),dersc0(3),dersc1(3),
     &     ddersc0(3),ddummy(3),xtemp(3),temp(3)
      common /sccalc/ time11,time12,time112,theti,it,nlobit
      delta=0.02d0*pi
      escloc=0.0D0
c     write (iout,'(a)') 'ESC'
      do i=loc_start,loc_end
        it=itype(i)
        if (it.eq.ntyp1) cycle
        if (it.eq.10) goto 1
        nlobit=nlob(iabs(it))
c       print *,'i=',i,' it=',it,' nlobit=',nlobit
c       write (iout,*) 'i=',i,' ssa=',ssa,' ssad=',ssad
        theti=theta(i+1)-pipol
        x(1)=dtan(theti)
        x(2)=alph(i)
        x(3)=omeg(i)

        if (x(2).gt.pi-delta) then
          xtemp(1)=x(1)
          xtemp(2)=pi-delta
          xtemp(3)=x(3)
          call enesc(xtemp,escloci0,dersc0,ddersc0,.true.)
          xtemp(2)=pi
          call enesc(xtemp,escloci1,dersc1,ddummy,.false.)
          call spline1(x(2),pi-delta,delta,escloci0,escloci1,dersc0(2),
     &        escloci,dersc(2))
          call spline2(x(2),pi-delta,delta,dersc0(1),dersc1(1),
     &        ddersc0(1),dersc(1))
          call spline2(x(2),pi-delta,delta,dersc0(3),dersc1(3),
     &        ddersc0(3),dersc(3))
          xtemp(2)=pi-delta
          call enesc_bound(xtemp,esclocbi0,dersc0,dersc12,.true.)
          xtemp(2)=pi
          call enesc_bound(xtemp,esclocbi1,dersc1,chuju,.false.)
          call spline1(x(2),pi-delta,delta,esclocbi0,esclocbi1,
     &            dersc0(2),esclocbi,dersc02)
          call spline2(x(2),pi-delta,delta,dersc0(1),dersc1(1),
     &            dersc12,dersc01)
          call splinthet(x(2),0.5d0*delta,ss,ssd)
          dersc0(1)=dersc01
          dersc0(2)=dersc02
          dersc0(3)=0.0d0
          do k=1,3
            dersc(k)=ss*dersc(k)+(1.0d0-ss)*dersc0(k)
          enddo
          dersc(2)=dersc(2)+ssd*(escloci-esclocbi)
c         write (iout,*) 'i=',i,x(2)*rad2deg,escloci0,escloci,
c    &             esclocbi,ss,ssd
          escloci=ss*escloci+(1.0d0-ss)*esclocbi
c         escloci=esclocbi
c         write (iout,*) escloci
        else if (x(2).lt.delta) then
          xtemp(1)=x(1)
          xtemp(2)=delta
          xtemp(3)=x(3)
          call enesc(xtemp,escloci0,dersc0,ddersc0,.true.)
          xtemp(2)=0.0d0
          call enesc(xtemp,escloci1,dersc1,ddummy,.false.)
          call spline1(x(2),delta,-delta,escloci0,escloci1,dersc0(2),
     &        escloci,dersc(2))
          call spline2(x(2),delta,-delta,dersc0(1),dersc1(1),
     &        ddersc0(1),dersc(1))
          call spline2(x(2),delta,-delta,dersc0(3),dersc1(3),
     &        ddersc0(3),dersc(3))
          xtemp(2)=delta
          call enesc_bound(xtemp,esclocbi0,dersc0,dersc12,.true.)
          xtemp(2)=0.0d0
          call enesc_bound(xtemp,esclocbi1,dersc1,chuju,.false.)
          call spline1(x(2),delta,-delta,esclocbi0,esclocbi1,
     &            dersc0(2),esclocbi,dersc02)
          call spline2(x(2),delta,-delta,dersc0(1),dersc1(1),
     &            dersc12,dersc01)
          dersc0(1)=dersc01
          dersc0(2)=dersc02
          dersc0(3)=0.0d0
          call splinthet(x(2),0.5d0*delta,ss,ssd)
          do k=1,3
            dersc(k)=ss*dersc(k)+(1.0d0-ss)*dersc0(k)
          enddo
          dersc(2)=dersc(2)+ssd*(escloci-esclocbi)
c         write (iout,*) 'i=',i,x(2)*rad2deg,escloci0,escloci,
c    &             esclocbi,ss,ssd
          escloci=ss*escloci+(1.0d0-ss)*esclocbi
c         write (iout,*) escloci
        else
          call enesc(x,escloci,dersc,ddummy,.false.)
        endif

        escloc=escloc+escloci
#ifdef ENERGY_DEC
        if (energy_dec) write (iout,'(a6,i5,0pf7.3)')
     &     'escloc',i,escloci
#endif
c       write (iout,*) 'i=',i,' escloci=',escloci,' dersc=',dersc

        gloc(nphi+i-1,icg)=gloc(nphi+i-1,icg)+
     &   wscloc*dersc(1)
        gloc(ialph(i,1),icg)=wscloc*dersc(2)
        gloc(ialph(i,1)+nside,icg)=wscloc*dersc(3)
    1   continue
      enddo
      return
      end
C---------------------------------------------------------------------------
      subroutine enesc(x,escloci,dersc,ddersc,mixed)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.IOUNITS'
      common /sccalc/ time11,time12,time112,theti,it,nlobit
      double precision x(3),z(3),Ax(3,maxlob,-1:1),dersc(3),ddersc(3)
      double precision contr(maxlob,-1:1)
      logical mixed
c       write (iout,*) 'it=',it,' nlobit=',nlobit
        escloc_i=0.0D0
        do j=1,3
          dersc(j)=0.0D0
          if (mixed) ddersc(j)=0.0d0
        enddo
        x3=x(3)

C Because of periodicity of the dependence of the SC energy in omega we have
C to add up the contributions from x(3)-2*pi, x(3), and x(3+2*pi).
C To avoid underflows, first compute & store the exponents.

        do iii=-1,1

          x(3)=x3+iii*dwapi

          do j=1,nlobit
            do k=1,3
              z(k)=x(k)-censc(k,j,it)
            enddo
            do k=1,3
              Axk=0.0D0
              do l=1,3
                Axk=Axk+gaussc(l,k,j,it)*z(l)
              enddo
              Ax(k,j,iii)=Axk
            enddo
            expfac=0.0D0
            do k=1,3
              expfac=expfac+Ax(k,j,iii)*z(k)
            enddo
            contr(j,iii)=expfac
          enddo ! j

        enddo ! iii

        x(3)=x3
C As in the case of ebend, we want to avoid underflows in exponentiation and
C subsequent NaNs and INFs in energy calculation.
C Find the largest exponent
        emin=contr(1,-1)
        do iii=-1,1
          do j=1,nlobit
            if (emin.gt.contr(j,iii)) emin=contr(j,iii)
          enddo
        enddo
        emin=0.5D0*emin
cd      print *,'it=',it,' emin=',emin

C Compute the contribution to SC energy and derivatives
        do iii=-1,1

          do j=1,nlobit
#ifdef OSF
            adexp=bsc(j,iabs(it))-0.5D0*contr(j,iii)+emin
            if(adexp.ne.adexp) adexp=1.0
            expfac=dexp(adexp)
#else
            expfac=dexp(bsc(j,iabs(it))-0.5D0*contr(j,iii)+emin)
#endif
cd          print *,'j=',j,' expfac=',expfac
            escloc_i=escloc_i+expfac
            do k=1,3
              dersc(k)=dersc(k)+Ax(k,j,iii)*expfac
            enddo
            if (mixed) then
              do k=1,3,2
                ddersc(k)=ddersc(k)+(-Ax(2,j,iii)*Ax(k,j,iii)
     &            +gaussc(k,2,j,it))*expfac
              enddo
            endif
          enddo

        enddo ! iii

        dersc(1)=dersc(1)/cos(theti)**2
        ddersc(1)=ddersc(1)/cos(theti)**2
        ddersc(3)=ddersc(3)

        escloci=-(dlog(escloc_i)-emin)
        do j=1,3
          dersc(j)=dersc(j)/escloc_i
        enddo
        if (mixed) then
          do j=1,3,2
            ddersc(j)=(ddersc(j)/escloc_i+dersc(2)*dersc(j))
          enddo
        endif
      return
      end
C------------------------------------------------------------------------------
      subroutine enesc_bound(x,escloci,dersc,dersc12,mixed)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.IOUNITS'
      common /sccalc/ time11,time12,time112,theti,it,nlobit
      double precision x(3),z(3),Ax(3,maxlob),dersc(3)
      double precision contr(maxlob)
      logical mixed

      escloc_i=0.0D0

      do j=1,3
        dersc(j)=0.0D0
      enddo

      do j=1,nlobit
        do k=1,2
          z(k)=x(k)-censc(k,j,it)
        enddo
        z(3)=dwapi
        do k=1,3
          Axk=0.0D0
          do l=1,3
            Axk=Axk+gaussc(l,k,j,it)*z(l)
          enddo
          Ax(k,j)=Axk
        enddo
        expfac=0.0D0
        do k=1,3
          expfac=expfac+Ax(k,j)*z(k)
        enddo
        contr(j)=expfac
      enddo ! j

C As in the case of ebend, we want to avoid underflows in exponentiation and
C subsequent NaNs and INFs in energy calculation.
C Find the largest exponent
      emin=contr(1)
      do j=1,nlobit
        if (emin.gt.contr(j)) emin=contr(j)
      enddo
      emin=0.5D0*emin

C Compute the contribution to SC energy and derivatives

      dersc12=0.0d0
      do j=1,nlobit
        expfac=dexp(bsc(j,iabs(it))-0.5D0*contr(j)+emin)
        escloc_i=escloc_i+expfac
        do k=1,2
          dersc(k)=dersc(k)+Ax(k,j)*expfac
        enddo
        if (mixed) dersc12=dersc12+(-Ax(2,j)*Ax(1,j)
     &            +gaussc(1,2,j,it))*expfac
        dersc(3)=0.0d0
      enddo

      dersc(1)=dersc(1)/cos(theti)**2
      dersc12=dersc12/cos(theti)**2
      escloci=-(dlog(escloc_i)-emin)
      do j=1,2
        dersc(j)=dersc(j)/escloc_i
      enddo
      if (mixed) dersc12=(dersc12/escloc_i+dersc(2)*dersc(1))
      return
      end
#else
c----------------------------------------------------------------------------------
      subroutine esc(escloc)
C Calculate the local energy of a side chain and its derivatives in the
C corresponding virtual-bond valence angles THETA and the spherical angles
C ALPHA and OMEGA derived from AM1 all-atom calculations.
C added by Urszula Kozlowska. 07/11/2007
C
      use omp_lib
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.VAR'
      include 'COMMON.SCROT'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.IOUNITS'
      include 'COMMON.NAMES'
      include 'COMMON.FFIELD'
      include 'COMMON.CONTROL'
      include 'COMMON.VECTORS'
      double precision x_prime(3),y_prime(3),z_prime(3)
     &    , sumene,dsc_i,dp2_i,x(65),
     &     xx,yy,zz,sumene1,sumene2,sumene3,sumene4,s1,s1_6,s2,s2_6,
     &    de_dxx,de_dyy,de_dzz,de_dt
      double precision
     & dXX_Ci1(3),dYY_Ci1(3),dZZ_Ci1(3),dXX_Ci(3),
     & dYY_Ci(3),dZZ_Ci(3),dXX_XYZ(3),dYY_XYZ(3),dZZ_XYZ(3),
     & dt_dCi(3),dt_dCi1(3)
      integer i,j,k,it,nlobit,my_thread,threads_used,from,to
      double precision sinfac,cosfac,sinfac2,cosfac2
      double precision cossc,cossc1,sinfac2yy,cosfac2xx
      double precision delta,escloc
      double precision dscp1,dscp2,pom_s1,pom_s16,pom_s2,pom_s26
      double precision pom_dx,pom_dy,pom_dt1,pom_dt2,pom,pom1,pom2
      double precision sumene1x,sumene2x,sumene3x,sumene4x
      double precision sumene1y,sumene2y,sumene3y,sumene4y
      double precision time11,time12,time112,theti
      double precision xx2,yy2,zz2,xx3,yy3,zz3,dscp1_6,dscp2_6
      double precision itypesign,invsint
      double precision th_gsclocm1(3,-1:maxres)
      double precision th_escloc(max_fg_threads),sum_escloc
      integer iti
      common /sccalc/ time11,time12,time112,theti,it,nlobit
      common /esccommon/ th_gsclocm1
      double precision gradene
      double precision scalar,tschebyshev,gradtschebyshev
      !delta=0.02d0*pi
      escloc=0.0d0
      th_escloc=0.0d0
 
      gscloc(:,-1:loc_start-1)=0.0d0
      gscloc(:,loc_end+1:nres)=0.0d0
      gsclocx(:,-1:loc_start-1)=0.0d0
      gsclocx(:,loc_end+1:nres)=0.0d0
      if (nnt.eq.nct) return    
#ifdef _OPENMP
      threads_used=omp_get_max_threads()
#else
      threads_used=1
#endif
!$OMP PARALLEL DEFAULT(SHARED) PRIVATE(
!$OMP&   my_thread,from,to,i,j,k,iti,itypesign,invsint,
!$OMP&   pom_s1,pom_s16,pom_s2,pom_s26,pom_dx,pom_dy,pom_dt1,pom_dt2,
!$OMP&   pom,pom1,pom2,dscp1,dscp2,dscp1_6,dscp2_6,
!$OMP&   xx,yy,zz,xx2,yy2,zz2,xx3,yy3,zz3,x_prime,y_prime,z_prime,
!$OMP&   dsc_i,dp2_i,x,s1,s1_6,s2,s2_6,de_dxx,de_dyy,de_dzz,de_dt,
!$OMP&   dXX_Ci1,dYY_Ci1,dZZ_Ci1,dXX_Ci,dYY_Ci,dZZ_Ci,
!$OMP&   dXX_XYZ,dYY_XYZ,dZZ_XYZ,dt_dCi,dt_dCi1,
!$OMP&   sinfac,cosfac,sinfac2,cosfac2,
!$OMP&   cossc,cossc1,sinfac2yy,cosfac2xx,
!$OMP&   sumene1,sumene2,sumene3,sumene4,
!$OMP&   sumene1x,sumene2x,sumene3x,sumene4x,
!$OMP&   sumene1y,sumene2y,sumene3y,sumene4y,sumene,sum_escloc
!$OMP& )
#ifdef _OPENMP
      my_thread=omp_get_thread_num()+1
#else
      my_thread=1
#endif
!     threads_used=1
!     my_thread=1
      !from=loc_start+((loc_end-loc_start)/threads_used)*(my_thread-1)
      !to=loc_start+((loc_end-loc_start)/threads_used)*my_thread-1
      !if(my_thread.eq.threads_used) to=loc_end
      call split_work_for_threads(from,to,loc_start,loc_end,
     &                            my_thread,threads_used)
#ifdef ENERGY_DEC
      if (energy_dec) write (iout,*) "esc"
#endif
      delta=0.02d0*pi
      sum_escloc=0.0d0
c AL 3/30/2022 single-residue chain does not have sidechain rotamers
      !do i=loc_start,loc_end
      do i=from,to
        gscloc(:,i)=0.0d0
        gsclocx(:,i)=0.0d0
        th_gsclocm1(:,i-1)=0.0d0
        iti=iabs(itype(i))
        if (iti.eq.ntyp1 .or. iti.eq.10) cycle
c AL 3/30/2022 handle the cases of an isolated-residue chain
        if (i.eq.nnt .and. itype(i+1).eq.ntyp1) cycle
        if (i.eq.nct .and. itype(i-1).eq.ntyp1) cycle 
!       costtab(i+1) =dcos(theta(i+1))
!       sinttab(i+1) =dsqrt(1-costtab(i+1)*costtab(i+1))

        ! already calculated in loc_precalc
        !cost2tab(i+1)=dsqrt(0.5d0*(1.0d0+costtab(i+1)))
        !sint2tab(i+1)=dsqrt(0.5d0*(1.0d0-costtab(i+1)))
#ifdef SC_END
        if (i.eq.nct .or. itype(i+1).eq.ntyp1) then
c AL 3/30/2022 handle a sidechain of a loose C-end
          cossc1=scalar(dc_norm(1,i-1),dc_norm(1,i+nres))
          sumene=arotam_end(0,1,iti)+
     &      tschebyshev(1,nterm_scend(1,iti),arotam_end(1,1,iti),cossc1)
          sum_escloc=sum_escloc+sumene
          gradene=gradtschebyshev(0,nterm_scend(1,iti)-1,
     &       arotam_end(1,1,iti),cossc1)
          th_gsclocm1(:,i-1)=th_gsclocm1(:,i-1)+
     &      vbld_inv(i)*(dC_norm(:,i+nres)-dC_norm(:,i-1)
     &       *cossc1)*gradene
          gsclocx(:,i)=gsclocx(:,i)+vbld_inv(i+nres)*
     &       (dC_norm(:,i-1)-dC_norm(:,i+nres)*cossc1)*gradene
#ifdef ENERGY_DEC
          if (energy_dec) write (2,'(2hC  ,a3,i6,2(a,f10.5))') 
     &     restyp(iti),i," angle",rad2deg*dacos(cossc1)," escloc",sumene
#endif
        else if (i.eq.nnt .or. itype(i-1).eq.ntyp1) then
c AL 3/30/2022 handle a sidechain of a loose N-end
          cossc=scalar(dc_norm(1,i),dc_norm(1,i+nres))
          sumene=arotam_end(0,2,iti)+
     &      tschebyshev(1,nterm_scend(2,iti),arotam_end(1,2,iti),cossc)
          sum_escloc=sum_escloc+sumene
          gradene=gradtschebyshev(0,nterm_scend(2,iti)-1,
     &       arotam_end(1,2,iti),cossc)
          gscloc(:,i)=gscloc(:,i)+
     &       vbld_inv(i+1)*(dC_norm(:,i+nres)-dC_norm(:,i)
     &       *cossc)*gradene
          gsclocx(:,i)=gsclocx(:,i)+vbld_inv(i+nres)*
     &       (dC_norm(:,i)-dC_norm(:,i+nres)*cossc)*gradene
#ifdef ENERGY_DEC
          if (energy_dec) write (2,'(2hN  ,a3,i6,2(a,f10.5))') 
     &     restyp(iti),i," angle",rad2deg*dacos(cossc)," escloc",sumene
#endif
        else
#endif
        cosfac2=0.5d0/(1.0d0+costtab(i+1))
        cosfac=dsqrt(cosfac2)
        sinfac2=0.5d0/(1.0d0-costtab(i+1))
        !if(dabs(sinfac2).gt.1.0d0) write(*,*)'i',i,sinfac2
        sinfac=dsqrt(sinfac2)
        !iti=iabs(itype(i))
        !if (iti.eq.10) goto 1
        itypesign=dsign(1.0d0,dfloat(itype(i)))
c
C  Compute the axes of tghe local cartesian coordinates system; store in
c   x_prime, y_prime and z_prime
c
        !do j=1,3
        !  x_prime(j) = 0.00
        !  y_prime(j) = 0.00
        !  z_prime(j) = 0.00
        !enddo
C        write(2,*) "dc_norm", dc_norm(1,i+nres),dc_norm(2,i+nres),
C     &   dc_norm(3,i+nres)
        !do j = 1,3
        !  x_prime(j) = (dc_norm(j,i) - dc_norm(j,i-1))*cosfac
        !  y_prime(j) = (dc_norm(j,i) + dc_norm(j,i-1))*sinfac
        !enddo
        !do j = 1,3
        !  z_prime(j) = -uz(j,i-1)*dsign(1.0d0,dfloat(itype(i)))
        !enddo
        x_prime = (dc_norm(:,i) - dc_norm(:,i-1))*cosfac
        y_prime = (dc_norm(:,i) + dc_norm(:,i-1))*sinfac
        z_prime = -uz(:,i-1)*itypesign
c       write (2,*) "i",i
c       write (2,*) "x_prime",(x_prime(j),j=1,3)
c       write (2,*) "y_prime",(y_prime(j),j=1,3)
c       write (2,*) "z_prime",(z_prime(j),j=1,3)
c       write (2,*) "xx",scalar(x_prime(1),x_prime(1)),
c      & " xy",scalar(x_prime(1),y_prime(1)),
c      & " xz",scalar(x_prime(1),z_prime(1)),
c      & " yy",scalar(y_prime(1),y_prime(1)),
c      & " yz",scalar(y_prime(1),z_prime(1)),
c      & " zz",scalar(z_prime(1),z_prime(1))
c
C Transform the unit vector of the ith side-chain centroid, dC_norm(*,i),
C to local coordinate system. Store in xx, yy, zz.
c
        !xx=0.0d0
        !yy=0.0d0
        !zz=0.0d0
        !do j = 1,3
        !  xx = xx + x_prime(j)*dc_norm(j,i+nres)
        !  yy = yy + y_prime(j)*dc_norm(j,i+nres)
        !  zz = zz + z_prime(j)*dc_norm(j,i+nres)
        !enddo
        xx = scalar(x_prime(:),dc_norm(:,i+nres)) ! scalar here
        yy = scalar(y_prime(:),dc_norm(:,i+nres)) ! breaks
        zz = scalar(z_prime(:),dc_norm(:,i+nres))

        xxtab(i)=xx
        yytab(i)=yy
        zztab(i)=zz
C
C Compute the energy of the ith side cbain
C
c        write (2,*) "xx",xx," yy",yy," zz",zz
        !iti=iabs(itype(i))
        !do j = 1,65
        !  x(j) = sc_parmin(j,iti)
        !enddo
        x(1:65) = sc_parmin(1:65,iti) 
#ifdef CHECK_COORD
Cc diagnostics - remove later
        xx1 = dcos(alph(2))
        yy1 = dsin(alph(2))*dcos(omeg(2))
        zz1 = -dsign(1.0,dfloat(itype(i)))*dsin(alph(2))*dsin(omeg(2))
        write(2,'(3f8.1,3f9.3,1x,3f9.3)')
     &    alph(2)*rad2deg,omeg(2)*rad2deg,theta(3)*rad2deg,xx,yy,zz,
     &    xx1,yy1,zz1
C,"  --- ", xx_w,yy_w,zz_w
c end diagnostics
#endif
        xx2=xx*xx
        xx3=xx*xx*xx
        yy2=yy*yy
        yy3=yy*yy*yy
        zz2=zz*zz
        zz3=zz*zz*zz

        sumene1= x(1)+  x(2)*xx+  x(3)*yy+  x(4)*zz+  x(5)*xx2
     &         + x(6)*yy2+  x(7)*zz2+  x(8)*xx*zz+  x(9)*xx*yy
     &         + x(10)*yy*zz
        sumene2= x(11) + x(12)*xx + x(13)*yy + x(14)*zz + x(15)*xx2
     &         + x(16)*yy2 + x(17)*zz2 + x(18)*xx*zz + x(19)*xx*yy
     &         + x(20)*yy*zz
        sumene3= x(21) +x(22)*xx +x(23)*yy +x(24)*zz +x(25)*xx2
     &         + x(26)*yy2 +x(27)*zz2 +x(28)*xx*zz +x(29)*xx*yy
     &         + x(30)*yy*zz +x(31)*xx3 +x(32)*yy3 +x(33)*zz3
     &         + x(34)*(xx2)*yy +x(35)*(xx2)*zz +x(36)*(yy2)*xx
     &         + x(37)*(yy2)*zz +x(38)*(zz2)*xx +x(39)*(zz2)*yy
     &         + x(40)*xx*yy*zz
        sumene4= x(41) +x(42)*xx +x(43)*yy +x(44)*zz +x(45)*xx2
     &         + x(46)*yy2 +x(47)*zz2 +x(48)*xx*zz +x(49)*xx*yy
     &         + x(50)*yy*zz +x(51)*xx3 +x(52)*yy3 +x(53)*zz3
     &         + x(54)*(xx2)*yy +x(55)*(xx2)*zz +x(56)*(yy2)*xx
     &         + x(57)*(yy2)*zz +x(58)*(zz2)*xx +x(59)*(zz2)*yy
     &         + x(60)*xx*yy*zz
        dsc_i = 0.743d0+x(61)
        dp2_i = 1.9d0+x(62)
!       dscp1=dsqrt(dsc_i**2+dp2_i**2-2*dsc_i*dp2_i
!    &          *(xx*cost2tab(i+1)+yy*sint2tab(i+1)))
!       dscp2=dsqrt(dsc_i**2+dp2_i**2-2*dsc_i*dp2_i
!    &          *(xx*cost2tab(i+1)-yy*sint2tab(i+1)))
        pom=dsc_i*dsc_i+dp2_i*dp2_i
        pom1=2.0d0*dsc_i*dp2_i
        dscp1=dsqrt(pom-pom1*(xx*cost2tab(i+1)+yy*sint2tab(i+1)))
        dscp2=dsqrt(pom-pom1*(xx*cost2tab(i+1)-yy*sint2tab(i+1)))
        dscp1_6=dscp1*dscp1*dscp1*dscp1*dscp1*dscp1
        !dscp1_6=dscp1*dscp1*dscp1
        !dscp1_6=dscp1_6*dscp1_6
        dscp2_6=dscp2*dscp2*dscp2*dscp2*dscp2*dscp2
        !dscp2_6=dscp2*dscp2*dscp2
        !dscp2_6=dscp2_6*dscp2_6
        s1=(1.0d0+x(63))/(0.1d0 + dscp1)
        s1_6=(1.0d0+x(64))/(0.1d0 + dscp1_6)
        s2=(1.0d0+x(65))/(0.1d0 + dscp2)
        s2_6=(1.0d0+x(65))/(0.1d0 + dscp2_6)
        sumene = ( sumene3*sint2tab(i+1) + sumene1)*(s1+s1_6)
     & + (sumene4*cost2tab(i+1) +sumene2)*(s2+s2_6)
c       write(2,'(i2," sumene",7f9.3)') i,sumene1,sumene2,sumene3,
c    &   sumene4,
c    &   dscp1,dscp2,sumene
c       sumene = enesc(x,xx,yy,zz,cost2tab(i+1),sint2tab(i+1))
        !escloc = escloc + sumene
        sum_escloc = sum_escloc + sumene
#ifdef ENERGY_DEC
        if (energy_dec) write (2,'(2hR ,a3,i6,4(a,f10.5))')restyp(it),i,
     &   " zz",zz," xx",xx," yy",yy," escloc",sumene
#endif
#ifdef DEBUG
       include "escdiag.f"
#endif
C
C Compute the gradient of esc
C
c        zz=zz*dsign(1.0,dfloat(itype(i)))
        pom_s1=(1.0d0+x(63))/(0.1d0 + dscp1)**2
        pom_s16=6.0d0*(1.0d0+x(64))/(0.1d0 + dscp1_6)**2
        pom_s2=(1.0d0+x(65))/(0.1d0 + dscp2)**2
        pom_s26=6.0d0*(1.0d0+x(65))/(0.1d0 + dscp2_6)**2
        pom_dx=dsc_i*dp2_i*cost2tab(i+1)
        pom_dy=dsc_i*dp2_i*sint2tab(i+1)
        pom_dt1=-0.5d0*dsc_i*dp2_i*(xx*sint2tab(i+1)-yy*cost2tab(i+1))
        pom_dt2=-0.5d0*dsc_i*dp2_i*(xx*sint2tab(i+1)+yy*cost2tab(i+1))
        pom1=(sumene3*sint2tab(i+1)+sumene1)
     &     *(pom_s1/dscp1+pom_s16*(dscp1*dscp1*dscp1*dscp1))
        pom2=(sumene4*cost2tab(i+1)+sumene2)
     &     *(pom_s2/dscp2+pom_s26*(dscp2*dscp2*dscp2*dscp2))
        sumene1x=x(2)+2*x(5)*xx+x(8)*zz+ x(9)*yy
        sumene3x=x(22)+2*x(25)*xx+x(28)*zz+x(29)*yy+3*x(31)*xx2
     &  +2*x(34)*xx*yy +2*x(35)*xx*zz +x(36)*(yy2) +x(38)*(zz2)
     &  +x(40)*yy*zz
        sumene2x=x(12)+2*x(15)*xx+x(18)*zz+ x(19)*yy
        sumene4x=x(42)+2*x(45)*xx +x(48)*zz +x(49)*yy +3*x(51)*xx2
     &  +2*x(54)*xx*yy+2*x(55)*xx*zz+x(56)*(yy2)+x(58)*(zz2)
     &  +x(60)*yy*zz
        de_dxx =(sumene1x+sumene3x*sint2tab(i+1))*(s1+s1_6)
     &        +(sumene2x+sumene4x*cost2tab(i+1))*(s2+s2_6)
     &        +(pom1+pom2)*pom_dx
#ifdef DEBUG
        write(2,*), "de_dxx = ", de_dxx,de_dxx_num,itype(i)
#endif
C
        sumene1y=x(3) + 2*x(6)*yy + x(9)*xx + x(10)*zz
        sumene3y=x(23) +2*x(26)*yy +x(29)*xx +x(30)*zz +3*x(32)*yy2
     &          +x(34)*(xx2) +2*x(36)*yy*xx +2*x(37)*yy*zz +x(39)*(zz2)
     &          +x(40)*xx*zz
        sumene2y=x(13) + 2*x(16)*yy + x(19)*xx + x(20)*zz
        sumene4y=x(43)+2*x(46)*yy+x(49)*xx +x(50)*zz
     &          +3*x(52)*yy2+x(54)*xx2+2*x(56)*yy*xx +2*x(57)*yy*zz
     &          +x(59)*zz2 +x(60)*xx*zz
        de_dyy=(sumene1y+sumene3y*sint2tab(i+1))*(s1+s1_6)
     &        +(sumene2y+sumene4y*cost2tab(i+1))*(s2+s2_6)
     &        +(pom1-pom2)*pom_dy
#ifdef DEBUG
        write(2,*), "de_dyy = ", de_dyy,de_dyy_num,itype(i)
#endif
C
        de_dzz=(x(24) +2*x(27)*zz +x(28)*xx +x(30)*yy
     &        +3*x(33)*zz2 +x(35)*xx2 +x(37)*yy2 +2*x(38)*zz*xx
     &        +2*x(39)*zz*yy +x(40)*xx*yy)*sint2tab(i+1)*(s1+s1_6)
     &        +(x(4) + 2*x(7)*zz+  x(8)*xx + x(10)*yy)*(s1+s1_6)
     &        +(x(44)+2*x(47)*zz +x(48)*xx   +x(50)*yy  +3*x(53)*zz2
     &        +x(55)*xx2 +x(57)*(yy2)+2*x(58)*zz*xx +2*x(59)*zz*yy
     &        +x(60)*xx*yy)*cost2tab(i+1)*(s2+s2_6)
     &        + ( x(14) + 2*x(17)*zz+  x(18)*xx + x(20)*yy)*(s2+s2_6)
#ifdef DEBUG
        write(2,*), "de_dzz = ", de_dzz,de_dzz_num,itype(i)
#endif
C
        de_dt=0.5d0*sumene3*cost2tab(i+1)*(s1+s1_6)
     &       -0.5d0*sumene4*sint2tab(i+1)*(s2+s2_6)
     &       +pom1*pom_dt1+pom2*pom_dt2
#ifdef DEBUG
        write(2,*), "de_dt = ", de_dt,de_dt_num,itype(i)
#endif
c#undef DEBUG
c
C

        cossc=scalar(dc_norm(:,i),dc_norm(:,i+nres))
        cossc1=scalar(dc_norm(:,i-1),dc_norm(:,i+nres))
        cosfac2xx=cosfac2*xx
        sinfac2yy=sinfac2*yy

        dt_dCi=-(dc_norm(:,i-1)+costtab(i+1)*dc_norm(:,i))*vbld_inv(i+1)
        dt_dCi1=-(dc_norm(:,i)+costtab(i+1)*dc_norm(:,i-1))*vbld_inv(i)
        do k = 1,3
!         dt_dCi(k) = -(dc_norm(k,i-1)+costtab(i+1)*dc_norm(k,i))*
!    &       vbld_inv(i+1)
!         dt_dCi1(k)= -(dc_norm(k,i)+costtab(i+1)*dc_norm(k,i-1))*
!    &       vbld_inv(i)
          pom=(dC_norm(k,i+nres)-cossc*dC_norm(k,i))*vbld_inv(i+1)
          pom1=(dC_norm(k,i+nres)-cossc1*dC_norm(k,i-1))*vbld_inv(i)
c         write (iout,*) "i",i," k",k," pom",pom," pom1",pom1,
c    &     " dt_dCi",dt_dCi(k)," dt_dCi1",dt_dCi1(k)
c         write (iout,*) "dC_norm",(dC_norm(j,i),j=1,3),
c    &    (dC_norm(j,i-1),j=1,3)," vbld_inv",vbld_inv(i+1),vbld_inv(i)
          dXX_Ci(k)=pom*cosfac-dt_dCi(k)*cosfac2xx
          dXX_Ci1(k)=-pom1*cosfac-dt_dCi1(k)*cosfac2xx
          dYY_Ci(k)=pom*sinfac+dt_dCi(k)*sinfac2yy
          dYY_Ci1(k)=pom1*sinfac+dt_dCi1(k)*sinfac2yy
!          dZZ_Ci1(k)=0.0d0
!          dZZ_Ci(k)=0.0d0
!          do j=1,3
!!           dZZ_Ci(k)=dZZ_Ci(k)-uzgrad(j,k,2,i-1)
!!    &               *dsign(1.0d0,dfloat(itype(i)))*dC_norm(j,i+nres)
!!           dZZ_Ci1(k)=dZZ_Ci1(k)-uzgrad(j,k,1,i-1)
!!    &                *dsign(1.0d0,dfloat(itype(i)))*dC_norm(j,i+nres)
!            dZZ_Ci(k)=dZZ_Ci(k)-uzgrad(j,k,2,i-1)
!     &               *itypesign*dC_norm(j,i+nres)
!            dZZ_Ci1(k)=dZZ_Ci1(k)-uzgrad(j,k,1,i-1)
!     &                *itypesign*dC_norm(j,i+nres)
!          enddo
          dZZ_Ci(k)=            ! scalar breaks here
     &      -itypesign*scalar(uzgrad(:,k,2,i-1),dC_norm(:,i+nres))
          dZZ_Ci1(k)=
     &      -itypesign*scalar(uzgrad(:,k,1,i-1),dC_norm(:,i+nres))

          dXX_XYZ(k)=vbld_inv(i+nres)*(x_prime(k)-xx*dC_norm(k,i+nres))
          dYY_XYZ(k)=vbld_inv(i+nres)*(y_prime(k)-yy*dC_norm(k,i+nres))
          dZZ_XYZ(k)=vbld_inv(i+nres)*(z_prime(k)-zz*dC_norm(k,i+nres))

          dt_dCi(k) = -dt_dCi(k)/sinttab(i+1)
          dt_dCi1(k)= -dt_dCi1(k)/sinttab(i+1)
        enddo

        !dXX_XYZ=vbld_inv(i+nres)*(x_prime-xx*dC_norm(:,i+nres))
        !dYY_XYZ=vbld_inv(i+nres)*(y_prime-yy*dC_norm(:,i+nres))
        !dZZ_XYZ=vbld_inv(i+nres)*(z_prime-zz*dC_norm(:,i+nres))

        !!! sinttab can be near or equal 0
        !invsint=-1.0d0/sinttab(i+1)
        !dt_dCi=dt_dCi*invsint
        !dt_dCi1=dt_dCi1*invsint

        dXX_Ctab(:,i)=dXX_Ci
        dXX_C1tab(:,i)=dXX_Ci1
        dYY_Ctab(:,i)=dYY_Ci
        dYY_C1tab(:,i)=dYY_Ci1
        dZZ_Ctab(:,i)=dZZ_Ci
        dZZ_C1tab(:,i)=dZZ_Ci1
        dXX_XYZtab(:,i)=dXX_XYZ
        dYY_XYZtab(:,i)=dYY_XYZ
        dZZ_XYZtab(:,i)=dZZ_XYZ

!       do k=1,3
!         dXX_Ctab(k,i)=dXX_Ci(k)
!         dXX_C1tab(k,i)=dXX_Ci1(k)
!         dYY_Ctab(k,i)=dYY_Ci(k)
!         dYY_C1tab(k,i)=dYY_Ci1(k)
!         dZZ_Ctab(k,i)=dZZ_Ci(k)
!         dZZ_C1tab(k,i)=dZZ_Ci1(k)
!         dXX_XYZtab(k,i)=dXX_XYZ(k)
!         dYY_XYZtab(k,i)=dYY_XYZ(k)
!         dZZ_XYZtab(k,i)=dZZ_XYZ(k)
!       enddo

c       do k = 1,3
c         write (iout,*) "k",k," dxx_ci1",dxx_ci1(k)," dyy_ci1",
c    &      dyy_ci1(k)," dzz_ci1",dzz_ci1(k)
c         write (iout,*) "k",k," dxx_ci",dxx_ci(k)," dyy_ci",
c    &      dyy_ci(k)," dzz_ci",dzz_ci(k)
c         write (iout,*) "k",k," dt_dci",dt_dci(k)," dt_dci",
c    &      dt_dci(k)
c         write (iout,*) "k",k," dxx_XYZ",dxx_XYZ(k)," dyy_XYZ",
c    &      dyy_XYZ(k)," dzz_XYZ",dzz_XYZ(k)
!         gscloc(k,i-1)=gscloc(k,i-1)+de_dxx*dxx_ci1(k)
!    &     +de_dyy*dyy_ci1(k)+de_dzz*dzz_ci1(k)+de_dt*dt_dCi1(k)
!         gscloc(k,i)=gscloc(k,i)+de_dxx*dxx_Ci(k)
!    &     +de_dyy*dyy_Ci(k)+de_dzz*dzz_Ci(k)+de_dt*dt_dCi(k)
!         gsclocx(k,i)=                 de_dxx*dxx_XYZ(k)
!    &     +de_dyy*dyy_XYZ(k)+de_dzz*dzz_XYZ(k)
c       enddo

!       write(*,'(i4,3f22.16)')i,de_dxx,de_dyy,de_dzz
!       write(*,'(a,3f22.16)')'xc1 ',dxx_ci1
!       write(*,'(a,3f22.16)')'yc1 ',dyy_ci1
!       write(*,'(a,3f22.16)')'zc1 ',dzz_ci1
!       write(*,'(a,3f22.16)')'tc1 ',dt_dCi1
!       write(*,'(a,3f22.16)')'xci ',dxx_ci
!       write(*,'(a,3f22.16)')'yci ',dyy_ci
!       write(*,'(a,3f22.16)')'zci ',dzz_ci
!       write(*,'(a,3f22.16)')'tci ',dt_dCi
!       write(*,'(a,3f22.16)')'X   ',dxx_XYZ
!       write(*,'(a,3f22.16)')'Y   ',dyy_XYZ
!       write(*,'(a,3f22.16)')'Z   ',dzz_XYZ
        th_gsclocm1(:,i-1)=de_dxx*dxx_ci1
     &             +de_dyy*dyy_ci1+de_dzz*dzz_ci1+de_dt*dt_dCi1
        gscloc(:,i)=de_dxx*dxx_Ci
     &             +de_dyy*dyy_Ci+de_dzz*dzz_Ci+de_dt*dt_dCi
        gsclocx(:,i)=de_dxx*dxx_XYZ+de_dyy*dyy_XYZ+de_dzz*dzz_XYZ

c       write(iout,*) "ENERGY GRAD = ", (gscloc(k,i-1),k=1,3),
c    &   (gscloc(k,i),k=1,3),(gsclocx(k,i),k=1,3)

C to check gradient call subroutine check_grad

!    1  continue
#ifdef SC_END
      endif
#endif
      enddo
      th_escloc(my_thread)=sum_escloc
!$OMP END PARALLEL

      escloc=sum(th_escloc(1:threads_used))

      gscloc(:,loc_start-1)=th_gsclocm1(:,loc_start-1)
!$OMP PARALLEL DO SIMD DEFAULT(SHARED)
      do i=loc_start,loc_end
        !if (itype(i).eq.ntyp1) cycle
        !it=iabs(itype(i))
        !if (it.eq.10) cycle
        gscloc(:,i)=th_gsclocm1(:,i)+gscloc(:,i)
      enddo
#ifdef ENERGY_DEC
      if (energy_dec) write (iout,'(80(1h-))')
#endif
      return
      end
c------------------------------------------------------------------------------
      double precision function enesc(x,xx,yy,zz,cost2,sint2)
      implicit none
      double precision x(65),xx,yy,zz,cost2,sint2,sumene1,sumene2,
     & sumene3,sumene4,sumene,dsc_i,dp2_i,dscp1,dscp2,s1,s1_6,s2,s2_6
      sumene1= x(1)+  x(2)*xx+  x(3)*yy+  x(4)*zz+  x(5)*xx**2
     &   + x(6)*yy**2+  x(7)*zz**2+  x(8)*xx*zz+  x(9)*xx*yy
     &   + x(10)*yy*zz
      sumene2=  x(11) + x(12)*xx + x(13)*yy + x(14)*zz + x(15)*xx**2
     & + x(16)*yy**2 + x(17)*zz**2 + x(18)*xx*zz + x(19)*xx*yy
     & + x(20)*yy*zz
      sumene3=  x(21) +x(22)*xx +x(23)*yy +x(24)*zz +x(25)*xx**2
     &  +x(26)*yy**2 +x(27)*zz**2 +x(28)*xx*zz +x(29)*xx*yy
     &  +x(30)*yy*zz +x(31)*xx**3 +x(32)*yy**3 +x(33)*zz**3
     &  +x(34)*(xx**2)*yy +x(35)*(xx**2)*zz +x(36)*(yy**2)*xx
     &  +x(37)*(yy**2)*zz +x(38)*(zz**2)*xx +x(39)*(zz**2)*yy
     &  +x(40)*xx*yy*zz
      sumene4= x(41) +x(42)*xx +x(43)*yy +x(44)*zz +x(45)*xx**2
     &  +x(46)*yy**2 +x(47)*zz**2 +x(48)*xx*zz +x(49)*xx*yy
     &  +x(50)*yy*zz +x(51)*xx**3 +x(52)*yy**3 +x(53)*zz**3
     &  +x(54)*(xx**2)*yy +x(55)*(xx**2)*zz +x(56)*(yy**2)*xx
     &  +x(57)*(yy**2)*zz +x(58)*(zz**2)*xx +x(59)*(zz**2)*yy
     &  +x(60)*xx*yy*zz
      dsc_i   = 0.743d0+x(61)
      dp2_i   = 1.9d0+x(62)
      dscp1=dsqrt(dsc_i**2+dp2_i**2-2*dsc_i*dp2_i
     &          *(xx*cost2+yy*sint2))
      dscp2=dsqrt(dsc_i**2+dp2_i**2-2*dsc_i*dp2_i
     &          *(xx*cost2-yy*sint2))
      s1=(1+x(63))/(0.1d0 + dscp1)
      s1_6=(1+x(64))/(0.1d0 + dscp1**6)
      s2=(1+x(65))/(0.1d0 + dscp2)
      s2_6=(1+x(65))/(0.1d0 + dscp2**6)
      sumene = ( sumene3*sint2 + sumene1)*(s1+s1_6)
     & + (sumene4*cost2 +sumene2)*(s2+s2_6)
      enesc=sumene
      return
      end
#endif
c------------------------------------------------------------------------------
      subroutine gcont(rij,r0ij,eps0ij,delta,fcont,fprimcont)
C
C This procedure calculates two-body contact function g(rij) and its derivative:
C
C           eps0ij                                     !       x < -1
C g(rij) =  esp0ij*(-0.9375*x+0.625*x**3-0.1875*x**5)  ! -1 =< x =< 1
C            0                                         !       x > 1
C
C where x=(rij-r0ij)/delta
C
C rij - interbody distance, r0ij - contact distance, eps0ij - contact energy
C
      implicit none
      double precision rij,r0ij,eps0ij,fcont,fprimcont
      double precision x,x2,x4,delta
c     delta=0.02D0*r0ij
c      delta=0.2D0*r0ij
      x=(rij-r0ij)/delta
      if (x.lt.-1.0D0) then
        fcont=eps0ij
        fprimcont=0.0D0
      else if (x.le.1.0D0) then
        x2=x*x
        x4=x2*x2
        fcont=eps0ij*(x*(-0.9375D0+0.6250D0*x2-0.1875D0*x4)+0.5D0)
        fprimcont=eps0ij * (-0.9375D0+1.8750D0*x2-0.9375D0*x4)/delta
      else
        fcont=0.0D0
        fprimcont=0.0D0
      endif
      return
      end
c------------------------------------------------------------------------------
      subroutine splinthet(theti,delta,ss,ssder)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      thetup=pi-delta
      thetlow=delta
      if (theti.gt.pipol) then
        call gcont(theti,thetup,1.0d0,delta,ss,ssder)
      else
        call gcont(-theti,-thetlow,1.0d0,delta,ss,ssder)
        ssder=-ssder
      endif
      return
      end
c------------------------------------------------------------------------------
      subroutine spline1(x,x0,delta,f0,f1,fprim0,f,fprim)
      implicit none
      double precision x,x0,delta,f0,f1,fprim0,f,fprim
      double precision ksi,ksi2,ksi3,a1,a2,a3
      a1=fprim0*delta/(f1-f0)
      a2=3.0d0-2.0d0*a1
      a3=a1-2.0d0
      ksi=(x-x0)/delta
      ksi2=ksi*ksi
      ksi3=ksi2*ksi
      f=f0+(f1-f0)*ksi*(a1+ksi*(a2+a3*ksi))
      fprim=(f1-f0)/delta*(a1+ksi*(2*a2+3*ksi*a3))
      return
      end
c------------------------------------------------------------------------------
      subroutine spline2(x,x0,delta,f0x,f1x,fprim0x,fx)
      implicit none
      double precision x,x0,delta,f0x,f1x,fprim0x,fx
      double precision ksi,ksi2,ksi3,a1,a2,a3
      ksi=(x-x0)/delta
      ksi2=ksi*ksi
      ksi3=ksi2*ksi
      a1=fprim0x*delta
      a2=3*(f1x-f0x)-2*fprim0x*delta
      a3=fprim0x*delta-2*(f1x-f0x)
      fx=f0x+a1*ksi+a2*ksi2+a3*ksi3
      return
      end
C-----------------------------------------------------------------------------
#ifdef CRYST_TOR
C-----------------------------------------------------------------------------
      subroutine etor(etors)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.TORCNSTR'
      include 'COMMON.CONTROL'
      logical lprn
C Set lprn=.true. for debugging
      lprn=.false.
c      lprn=.true.
      etors=0.0D0
      do i=iphi_start,iphi_end
      etors_ii=0.0D0
        if (itype(i-2).eq.ntyp1.or. itype(i-1).eq.ntyp1
     &      .or. itype(i).eq.ntyp1 .or. itype(i-3).eq.ntyp1) cycle
        itori=itortyp(itype(i-2))
        itori1=itortyp(itype(i-1))
        phii=phi(i)
        gloci=0.0D0
C Proline-Proline pair is a special case...
        if (itori.eq.3 .and. itori1.eq.3) then
          if (phii.gt.-dwapi3) then
            cosphi=dcos(3*phii)
            fac=1.0D0/(1.0D0-cosphi)
            etorsi=v1(1,3,3)*fac
            etorsi=etorsi+etorsi
            etors=etors+etorsi-v1(1,3,3)
#ifdef ENERGY_DEC
            if (energy_dec) etors_ii=etors_ii+etorsi-v1(1,3,3)
#endif
            gloci=gloci-3*fac*etorsi*dsin(3*phii)
          endif
          do j=1,3
            v1ij=v1(j+1,itori,itori1)
            v2ij=v2(j+1,itori,itori1)
            cosphi=dcos(j*phii)
            sinphi=dsin(j*phii)
            etors=etors+v1ij*cosphi+v2ij*sinphi+dabs(v1ij)+dabs(v2ij)
#ifdef ENERGY_DEC
            if (energy_dec) etors_ii=etors_ii+
     &                              v2ij*sinphi+dabs(v1ij)+dabs(v2ij)
#endif
            gloci=gloci+j*(v2ij*cosphi-v1ij*sinphi)
          enddo
        else
          do j=1,nterm_old
            v1ij=v1(j,itori,itori1)
            v2ij=v2(j,itori,itori1)
            cosphi=dcos(j*phii)
            sinphi=dsin(j*phii)
            etors=etors+v1ij*cosphi+v2ij*sinphi+dabs(v1ij)+dabs(v2ij)
#ifdef ENERGY_DEC
            if (energy_dec) etors_ii=etors_ii+
     &                  v1ij*cosphi+v2ij*sinphi+dabs(v1ij)+dabs(v2ij)
#endif
            gloci=gloci+j*(v2ij*cosphi-v1ij*sinphi)
          enddo
        endif
#ifdef ENERGY_DEC
        if (energy_dec) write (iout,'(a6,i5,0pf7.3)')
             'etor',i,etors_ii
#endif
        if (lprn)
     &  write (iout,'(2(a3,2x,i3,2x),2i3,6f8.3/26x,6f8.3/)')
     &  restyp(itype(i-2)),i-2,restyp(itype(i-1)),i-1,itori,itori1,
     &  (v1(j,itori,itori1),j=1,6),(v2(j,itori,itori1),j=1,6)
        gloc(i-3,icg)=gloc(i-3,icg)+wtor*gloci
c       write (iout,*) 'i=',i,' gloc=',gloc(i-3,icg)
      enddo
      return
      end
c------------------------------------------------------------------------------
      subroutine etor_d(etors_d)
      etors_d=0.0d0
      return
      end
c----------------------------------------------------------------------------
c LICZENIE WIEZOW Z ROWNANIA ENERGII MODELLERA
      subroutine e_modeller(ehomology_constr)
      ehomology_constr=0.0d0
      write (iout,*) "!!!!!UWAGA, JESTEM W DZIWNEJ PETLI, TEST!!!!!"
      return
      end
C !!!!!!!! NIE CZYTANE !!!!!!!!!!!

c------------------------------------------------------------------------------
      subroutine etor_d(etors_d)
      etors_d=0.0d0
      return
      end
c----------------------------------------------------------------------------
#else
      subroutine etor(etors)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.TORCNSTR'
      include 'COMMON.CONTROL'
      logical lprn
C Set lprn=.true. for debugging
      lprn=.false.
c     lprn=.true.
      etors=0.0D0
      do i=iphi_start,iphi_end
C ANY TWO ARE DUMMY ATOMS in row CYCLE
c        if (((itype(i-3).eq.ntyp1).and.(itype(i-2).eq.ntyp1)).or.
c     &      ((itype(i-2).eq.ntyp1).and.(itype(i-1).eq.ntyp1))  .or.
c     &      ((itype(i-1).eq.ntyp1).and.(itype(i).eq.ntyp1))) cycle
        if (itype(i-2).eq.ntyp1.or. itype(i-1).eq.ntyp1
     &      .or. itype(i).eq.ntyp1 .or. itype(i-3).eq.ntyp1) cycle
C In current verion the ALL DUMMY ATOM POTENTIALS ARE OFF
C For introducing the NH3+ and COO- group please check the etor_d for reference
C and guidance
        etors_ii=0.0D0
         if (iabs(itype(i)).eq.20) then
         iblock=2
         else
         iblock=1
         endif
        itori=itortyp(itype(i-2))
        itori1=itortyp(itype(i-1))
        phii=phi(i)
        gloci=0.0D0
C Regular cosine and sine terms
        do j=1,nterm(itori,itori1,iblock)
          v1ij=v1(j,itori,itori1,iblock)
          v2ij=v2(j,itori,itori1,iblock)
          cosphi=dcos(j*phii)
          sinphi=dsin(j*phii)
          etors=etors+v1ij*cosphi+v2ij*sinphi
#ifdef ENERGY_DEC
          if (energy_dec) etors_ii=etors_ii+
     &                v1ij*cosphi+v2ij*sinphi
#endif
          gloci=gloci+j*(v2ij*cosphi-v1ij*sinphi)
        enddo
C Lorentz terms
C                         v1
C  E = SUM ----------------------------------- - v1
C          [v2 cos(phi/2)+v3 sin(phi/2)]^2 + 1
C
        cosphi=dcos(0.5d0*phii)
        sinphi=dsin(0.5d0*phii)
        do j=1,nlor(itori,itori1,iblock)
          vl1ij=vlor1(j,itori,itori1)
          vl2ij=vlor2(j,itori,itori1)
          vl3ij=vlor3(j,itori,itori1)
          pom=vl2ij*cosphi+vl3ij*sinphi
          pom1=1.0d0/(pom*pom+1.0d0)
          etors=etors+vl1ij*pom1
#ifdef ENERGY_DEC
          if (energy_dec) etors_ii=etors_ii+
     &                vl1ij*pom1
#endif
          pom=-pom*pom1*pom1
          gloci=gloci+vl1ij*(vl3ij*cosphi-vl2ij*sinphi)*pom
        enddo
C Subtract the constant term
        etors=etors-v0(itori,itori1,iblock)
#ifdef ENERGY_DEC
          if (energy_dec) write (iout,'(a6,i5,0pf7.3)')
     &         'etor',i,etors_ii-v0(itori,itori1,iblock)
#endif
        if (lprn)
     &  write (iout,'(2(a3,2x,i3,2x),2i3,6f8.3/26x,6f8.3/)')
     &  restyp(itype(i-2)),i-2,restyp(itype(i-1)),i-1,itori,itori1,
     &  (v1(j,itori,itori1,iblock),j=1,6),
     &  (v2(j,itori,itori1,iblock),j=1,6)
        gloc(i-3,icg)=gloc(i-3,icg)+wtor*gloci
c       write (iout,*) 'i=',i,' gloc=',gloc(i-3,icg)
      enddo
      return
      end
c----------------------------------------------------------------------------
      subroutine etor_d(etors_d)
C 6/23/01 Compute double torsional energy
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.VAR'
      include 'COMMON.GEO'
      include 'COMMON.LOCAL'
      include 'COMMON.TORSION'
      include 'COMMON.INTERACT'
      include 'COMMON.DERIV'
      include 'COMMON.CHAIN'
      include 'COMMON.NAMES'
      include 'COMMON.IOUNITS'
      include 'COMMON.FFIELD'
      include 'COMMON.TORCNSTR'
      logical lprn
C Set lprn=.true. for debugging
      lprn=.false.
c     lprn=.true.
      etors_d=0.0D0
c      write(iout,*) "a tu??"
      do i=iphid_start,iphid_end
C ANY TWO ARE DUMMY ATOMS in row CYCLE
C        if (((itype(i-3).eq.ntyp1).and.(itype(i-2).eq.ntyp1)).or.
C     &      ((itype(i-2).eq.ntyp1).and.(itype(i-1).eq.ntyp1)).or.
C     &      ((itype(i-1).eq.ntyp1).and.(itype(i).eq.ntyp1))  .or.
C     &      ((itype(i).eq.ntyp1).and.(itype(i+1).eq.ntyp1))) cycle
         if ((itype(i-2).eq.ntyp1).or.itype(i-3).eq.ntyp1.or.
     &  (itype(i-1).eq.ntyp1).or.(itype(i).eq.ntyp1).or.
     &  (itype(i+1).eq.ntyp1)) cycle
C In current verion the ALL DUMMY ATOM POTENTIALS ARE OFF
        itori=itortyp(itype(i-2))
        itori1=itortyp(itype(i-1))
        itori2=itortyp(itype(i))
        phii=phi(i)
        phii1=phi(i+1)
        gloci1=0.0D0
        gloci2=0.0D0
        iblock=1
        if (iabs(itype(i+1)).eq.20) iblock=2
C Iblock=2 Proline type
C ADASKO: WHEN PARAMETERS FOR THIS TYPE OF BLOCKING GROUP IS READY UNCOMMENT
C CHECK WEATHER THERE IS NECCESITY FOR iblock=3 for COO-
C        if (itype(i+1).eq.ntyp1) iblock=3
C The problem of NH3+ group can be resolved by adding new parameters please note if there
C IS or IS NOT need for this
C IF Yes uncomment below and add to parmread.F appropriate changes and to v1cij and so on
C        is (itype(i-3).eq.ntyp1) ntblock=2
C        ntblock is N-terminal blocking group

C Regular cosine and sine terms
        do j=1,ntermd_1(itori,itori1,itori2,iblock)
C Example of changes for NH3+ blocking group
C       do j=1,ntermd_1(itori,itori1,itori2,iblock,ntblock)
C          v1cij=v1c(1,j,itori,itori1,itori2,iblock,ntblock)
          v1cij=v1c(1,j,itori,itori1,itori2,iblock)
          v1sij=v1s(1,j,itori,itori1,itori2,iblock)
          v2cij=v1c(2,j,itori,itori1,itori2,iblock)
          v2sij=v1s(2,j,itori,itori1,itori2,iblock)
          cosphi1=dcos(j*phii)
          sinphi1=dsin(j*phii)
          cosphi2=dcos(j*phii1)
          sinphi2=dsin(j*phii1)
          etors_d=etors_d+v1cij*cosphi1+v1sij*sinphi1+
     &     v2cij*cosphi2+v2sij*sinphi2
          gloci1=gloci1+j*(v1sij*cosphi1-v1cij*sinphi1)
          gloci2=gloci2+j*(v2sij*cosphi2-v2cij*sinphi2)
        enddo
        do k=2,ntermd_2(itori,itori1,itori2,iblock)
          do l=1,k-1
            v1cdij = v2c(k,l,itori,itori1,itori2,iblock)
            v2cdij = v2c(l,k,itori,itori1,itori2,iblock)
            v1sdij = v2s(k,l,itori,itori1,itori2,iblock)
            v2sdij = v2s(l,k,itori,itori1,itori2,iblock)
            cosphi1p2=dcos(l*phii+(k-l)*phii1)
            cosphi1m2=dcos(l*phii-(k-l)*phii1)
            sinphi1p2=dsin(l*phii+(k-l)*phii1)
            sinphi1m2=dsin(l*phii-(k-l)*phii1)
            etors_d=etors_d+v1cdij*cosphi1p2+v2cdij*cosphi1m2+
     &        v1sdij*sinphi1p2+v2sdij*sinphi1m2
            gloci1=gloci1+l*(v1sdij*cosphi1p2+v2sdij*cosphi1m2
     &        -v1cdij*sinphi1p2-v2cdij*sinphi1m2)
            gloci2=gloci2+(k-l)*(v1sdij*cosphi1p2-v2sdij*cosphi1m2
     &        -v1cdij*sinphi1p2+v2cdij*sinphi1m2)
          enddo
        enddo
        gloc(i-3,icg)=gloc(i-3,icg)+wtor_d*gloci1
        gloc(i-2,icg)=gloc(i-2,icg)+wtor_d*gloci2
      enddo
      return
      end
#endif
crc-------------------------------------------------
      SUBROUTINE MATVEC2(A1,V1,V2)
#ifdef CRAY
!DIR$ INLINEALWAYS MATVEC2
#endif
#ifndef OSF
cDEC$ ATTRIBUTES FORCEINLINE::MATVEC2
#endif
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      DIMENSION A1(2,2),V1(2),V2(2)
c      DO 1 I=1,2
c        VI=0.0
c        DO 3 K=1,2
c    3     VI=VI+A1(I,K)*V1(K)
c        Vaux(I)=VI
c    1 CONTINUE

      vaux1=a1(1,1)*v1(1)+a1(1,2)*v1(2)
      vaux2=a1(2,1)*v1(1)+a1(2,2)*v1(2)

      v2(1)=vaux1
      v2(2)=vaux2
      END
C---------------------------------------
      SUBROUTINE MATMAT2(A1,A2,A3)
#ifndef OSF
cDEC$ ATTRIBUTES FORCEINLINE::MATMAT2
#endif
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      DIMENSION A1(2,2),A2(2,2),A3(2,2)
c      DIMENSION AI3(2,2)
c        DO  J=1,2
c          A3IJ=0.0
c          DO K=1,2
c           A3IJ=A3IJ+A1(I,K)*A2(K,J)
c          enddo
c          A3(I,J)=A3IJ
c       enddo
c      enddo

      ai3_11=a1(1,1)*a2(1,1)+a1(1,2)*a2(2,1)
      ai3_12=a1(1,1)*a2(1,2)+a1(1,2)*a2(2,2)
      ai3_21=a1(2,1)*a2(1,1)+a1(2,2)*a2(2,1)
      ai3_22=a1(2,1)*a2(1,2)+a1(2,2)*a2(2,2)

      A3(1,1)=AI3_11
      A3(2,1)=AI3_21
      A3(1,2)=AI3_12
      A3(2,2)=AI3_22
      END

c-------------------------------------------------------------------------
      double precision function scalar2(u,v)
#ifdef CRAY
!DIR$ INLINEALWAYS scalar2
#endif
      implicit none
      double precision u(2),v(2)
      double precision sc
      integer i
      scalar2=u(1)*v(1)+u(2)*v(2)
      return
      end

C-----------------------------------------------------------------------------

      subroutine transpose2(a,at)
#ifdef CRAY
!DIR$ INLINEALWAYS transpose2
#endif
#ifndef OSF
cDEC$ ATTRIBUTES FORCEINLINE::transpose2
#endif
      implicit none
      double precision a(2,2),at(2,2)
      at(1,1)=a(1,1)
      at(1,2)=a(2,1)
      at(2,1)=a(1,2)
      at(2,2)=a(2,2)
      return
      end
c--------------------------------------------------------------------------
      subroutine transpose(n,a,at)
      implicit none
      integer n,i,j
      double precision a(n,n),at(n,n)
      do i=1,n
        do j=1,n
          at(j,i)=a(i,j)
        enddo
      enddo
      return
      end
C---------------------------------------------------------------------------
      subroutine prodmat3(a1,a2,kk,transp,prod)
#ifdef CRAY
!DIR$ INLINEALWAYS prodmat3
#endif
#ifndef OSF
cDEC$ ATTRIBUTES FORCEINLINE::prodmat3
#endif
      implicit none
      integer i,j
      double precision a1(2,2),a2(2,2),a2t(2,2),kk(2,2),prod(2,2)
      logical transp
crc      double precision auxmat(2,2),prod_(2,2)

      if (transp) then
crc        call transpose2(kk(1,1),auxmat(1,1))
crc        call matmat2(a1(1,1),auxmat(1,1),auxmat(1,1))
crc        call matmat2(auxmat(1,1),a2(1,1),prod_(1,1))

           prod(1,1)=(a1(1,1)*kk(1,1)+a1(1,2)*kk(1,2))*a2(1,1)
     & +(a1(1,1)*kk(2,1)+a1(1,2)*kk(2,2))*a2(2,1)
           prod(1,2)=(a1(1,1)*kk(1,1)+a1(1,2)*kk(1,2))*a2(1,2)
     & +(a1(1,1)*kk(2,1)+a1(1,2)*kk(2,2))*a2(2,2)
           prod(2,1)=(a1(2,1)*kk(1,1)+a1(2,2)*kk(1,2))*a2(1,1)
     & +(a1(2,1)*kk(2,1)+a1(2,2)*kk(2,2))*a2(2,1)
           prod(2,2)=(a1(2,1)*kk(1,1)+a1(2,2)*kk(1,2))*a2(1,2)
     & +(a1(2,1)*kk(2,1)+a1(2,2)*kk(2,2))*a2(2,2)

      else
crc        call matmat2(a1(1,1),kk(1,1),auxmat(1,1))
crc        call matmat2(auxmat(1,1),a2(1,1),prod_(1,1))

           prod(1,1)=(a1(1,1)*kk(1,1)+a1(1,2)*kk(2,1))*a2(1,1)
     &  +(a1(1,1)*kk(1,2)+a1(1,2)*kk(2,2))*a2(2,1)
           prod(1,2)=(a1(1,1)*kk(1,1)+a1(1,2)*kk(2,1))*a2(1,2)
     &  +(a1(1,1)*kk(1,2)+a1(1,2)*kk(2,2))*a2(2,2)
           prod(2,1)=(a1(2,1)*kk(1,1)+a1(2,2)*kk(2,1))*a2(1,1)
     &  +(a1(2,1)*kk(1,2)+a1(2,2)*kk(2,2))*a2(2,1)
           prod(2,2)=(a1(2,1)*kk(1,1)+a1(2,2)*kk(2,1))*a2(1,2)
     &  +(a1(2,1)*kk(1,2)+a1(2,2)*kk(2,2))*a2(2,2)

      endif
c      call transpose2(a2(1,1),a2t(1,1))

crc      print *,transp
crc      print *,((prod_(i,j),i=1,2),j=1,2)
crc      print *,((prod(i,j),i=1,2),j=1,2)

      return
      end
CCC----------------------------------------------
      subroutine Eliptransfer(eliptran)
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.CONTROL'
      include 'COMMON.SPLITELE'
      include 'COMMON.SBRIDGE'
C this is done by Adasko
C      print *,"wchodze"
C structure of box:
C      water
C--bordliptop-- buffore starts
C--bufliptop--- here true lipid starts
C      lipid
C--buflipbot--- lipid ends buffore starts
C--bordlipbot--buffore ends
c      call cartprint
      eliptran=0.0
      do i=ilip_start,ilip_end
C       do i=1,1
        if (itype(i).eq.ntyp1) cycle

        positi=(mod(((c(3,i)+c(3,i+1))/2.0d0),boxzsize))
        if (positi.le.0.0) positi=positi+boxzsize
C        print *,i
C first for peptide groups
c for each residue check if it is in lipid or lipid water border area
       if ((positi.gt.bordlipbot)
     &.and.(positi.lt.bordliptop)) then
C the energy transfer exist
        if (positi.lt.buflipbot) then
C what fraction I am in
         fracinbuf=1.0d0-
     &        ((positi-bordlipbot)/lipbufthick)
C lipbufthick is thickenes of lipid buffore
         sslip=sscalelip(fracinbuf)
         ssgradlip=-sscagradlip(fracinbuf)/lipbufthick
         eliptran=eliptran+sslip*pepliptran
         gliptranc(3,i)=gliptranc(3,i)+ssgradlip*pepliptran/2.0d0
         gliptranc(3,i-1)=gliptranc(3,i-1)+ssgradlip*pepliptran/2.0d0
C         gliptranc(3,i-2)=gliptranc(3,i)+ssgradlip*pepliptran

C        print *,"doing sccale for lower part"
C         print *,i,sslip,fracinbuf,ssgradlip
        elseif (positi.gt.bufliptop) then
         fracinbuf=1.0d0-((bordliptop-positi)/lipbufthick)
         sslip=sscalelip(fracinbuf)
         ssgradlip=sscagradlip(fracinbuf)/lipbufthick
         eliptran=eliptran+sslip*pepliptran
         gliptranc(3,i)=gliptranc(3,i)+ssgradlip*pepliptran/2.0d0
         gliptranc(3,i-1)=gliptranc(3,i-1)+ssgradlip*pepliptran/2.0d0
C         gliptranc(3,i-2)=gliptranc(3,i)+ssgradlip*pepliptran
C          print *, "doing sscalefor top part"
C         print *,i,sslip,fracinbuf,ssgradlip
        else
         eliptran=eliptran+pepliptran
C         print *,"I am in true lipid"
        endif
C       else
C       eliptran=elpitran+0.0 ! I am in water
       endif
       enddo
C       print *, "nic nie bylo w lipidzie?"
C now multiply all by the peptide group transfer factor
C       eliptran=eliptran*pepliptran
C now the same for side chains
CV       do i=1,1
       do i=ilip_start,ilip_end
        if (itype(i).eq.ntyp1) cycle
        positi=(mod(c(3,i+nres),boxzsize))
        if (positi.le.0) positi=positi+boxzsize
c        write(iout,*) "i",i," positi",positi,bordlipbot,buflipbot,
c     &   bordliptop
C       print *,mod(c(3,i+nres),boxzsize),bordlipbot,bordliptop
c for each residue check if it is in lipid or lipid water border area
C       respos=mod(c(3,i+nres),boxzsize)
C       print *,positi,bordlipbot,buflipbot
       if ((positi.gt.bordlipbot)
     & .and.(positi.lt.bordliptop)) then
C the energy transfer exist
        if (positi.lt.buflipbot) then
         fracinbuf=1.0d0-
     &     ((positi-bordlipbot)/lipbufthick)
c         write (iout,*) "i",i,itype(i)," fracinbuf",fracinbuf
c         write (iout,*) "i",i," liptranene",liptranene(itype(i))
C lipbufthick is thickenes of lipid buffore
         sslip=sscalelip(fracinbuf)
         ssgradlip=-sscagradlip(fracinbuf)/lipbufthick
         eliptran=eliptran+sslip*liptranene(itype(i))
         gliptranx(3,i)=gliptranx(3,i)
     &+ssgradlip*liptranene(itype(i))
         gliptranc(3,i-1)= gliptranc(3,i-1)
     &+ssgradlip*liptranene(itype(i))
C         print *,"doing sccale for lower part"
        elseif (positi.gt.bufliptop) then
         fracinbuf=1.0d0-
     &((bordliptop-positi)/lipbufthick)
         sslip=sscalelip(fracinbuf)
         ssgradlip=sscagradlip(fracinbuf)/lipbufthick
         eliptran=eliptran+sslip*liptranene(itype(i))
         gliptranx(3,i)=gliptranx(3,i)
     &+ssgradlip*liptranene(itype(i))
         gliptranc(3,i-1)= gliptranc(3,i-1)
     &+ssgradlip*liptranene(itype(i))
C          print *, "doing sscalefor top part",sslip,fracinbuf
        else
         eliptran=eliptran+liptranene(itype(i))
C         print *,"I am in true lipid"
        endif
        endif ! if in lipid or buffor
C       else
C       eliptran=elpitran+0.0 ! I am in water
       enddo
       return
       end
C---------------------------------------------------------
C AFM soubroutine for constant force
       subroutine AFMforce(Eafmforce)
       implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.CONTROL'
      include 'COMMON.SPLITELE'
      include 'COMMON.SBRIDGE'
      real*8 diffafm(3)
      dist=0.0d0
      Eafmforce=0.0d0
      do i=1,3
      diffafm(i)=c(i,afmend)-c(i,afmbeg)
      dist=dist+diffafm(i)**2
      enddo
      dist=dsqrt(dist)
      Eafmforce=-forceAFMconst*(dist-distafminit)
      do i=1,3
      gradafm(i,afmend-1)=-forceAFMconst*diffafm(i)/dist
      gradafm(i,afmbeg-1)=forceAFMconst*diffafm(i)/dist
      enddo
C      print *,'AFM',Eafmforce
      return
      end
C---------------------------------------------------------
C AFM subroutine with pseudoconstant velocity
       subroutine AFMvel(Eafmforce)
       implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.CONTROL'
      include 'COMMON.SPLITELE'
      include 'COMMON.SBRIDGE'
      real*8 diffafm(3)
C Only for check grad COMMENT if not used for checkgrad
C      totT=3.0d0
C--------------------------------------------------------
C      print *,"wchodze"
      dist=0.0d0
      Eafmforce=0.0d0
      do i=1,3
      diffafm(i)=c(i,afmend)-c(i,afmbeg)
      dist=dist+diffafm(i)**2
      enddo
      dist=dsqrt(dist)
      Eafmforce=0.5d0*forceAFMconst
     & *(distafminit+totTafm*velAFMconst-dist)**2
C      Eafmforce=-forceAFMconst*(dist-distafminit)
      do i=1,3
      gradafm(i,afmend-1)=-forceAFMconst*
     &(distafminit+totTafm*velAFMconst-dist)
     &*diffafm(i)/dist
      gradafm(i,afmbeg-1)=forceAFMconst*
     &(distafminit+totTafm*velAFMconst-dist)
     &*diffafm(i)/dist
      enddo
C      print *,'AFM',Eafmforce,totTafm*velAFMconst,dist
      return
      end
#ifdef SHIELD
C-----------------------------------------------------------
C first for shielding is setting of function of side-chains
       subroutine set_shield_fac
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.IOUNITS'
      include 'COMMON.SHIELD'
      include 'COMMON.INTERACT'
C this is the squar root 77 devided by 81 the epislion in lipid (in protein)
      double precision div77_81/0.974996043d0/,
     &div4_81/0.2222222222d0/,sh_frac_dist_grad(3)

C the vector between center of side_chain and peptide group
       double precision pep_side(3),long,side_calf(3),
     &pept_group(3),costhet_grad(3),cosphi_grad_long(3),
     &cosphi_grad_loc(3),pep_side_norm(3),side_calf_norm(3)
C the line belowe needs to be changed for FGPROC>1
      do i=1,nres-1
      if ((itype(i).eq.ntyp1).and.itype(i+1).eq.ntyp1) cycle
      ishield_list(i)=0
Cif there two consequtive dummy atoms there is no peptide group between them
C the line below has to be changed for FGPROC>1
      VolumeTotal=0.0
      do k=1,nres
       if ((itype(k).eq.ntyp1).or.(itype(k).eq.10)) cycle
       dist_pep_side=0.0
       dist_side_calf=0.0
       do j=1,3
C first lets set vector conecting the ithe side-chain with kth side-chain
      pep_side(j)=c(j,k+nres)-(c(j,i)+c(j,i+1))/2.0d0
C      pep_side(j)=2.0d0
C and vector conecting the side-chain with its proper calfa
      side_calf(j)=c(j,k+nres)-c(j,k)
C      side_calf(j)=2.0d0
      pept_group(j)=c(j,i)-c(j,i+1)
C lets have their lenght
      dist_pep_side=pep_side(j)**2+dist_pep_side
      dist_side_calf=dist_side_calf+side_calf(j)**2
      dist_pept_group=dist_pept_group+pept_group(j)**2
      enddo
       dist_pep_side=dsqrt(dist_pep_side)
       dist_pept_group=dsqrt(dist_pept_group)
       dist_side_calf=dsqrt(dist_side_calf)
      do j=1,3
        pep_side_norm(j)=pep_side(j)/dist_pep_side
        side_calf_norm(j)=dist_side_calf
      enddo
C now sscale fraction
       sh_frac_dist=-(dist_pep_side-rpp(1,1)-buff_shield)/buff_shield
C       print *,buff_shield,"buff"
C now sscale
        if (sh_frac_dist.le.0.0) cycle
C If we reach here it means that this side chain reaches the shielding sphere
C Lets add him to the list for gradient
        ishield_list(i)=ishield_list(i)+1
C ishield_list is a list of non 0 side-chain that contribute to factor gradient
C this list is essential otherwise problem would be O3
        shield_list(ishield_list(i),i)=k
C Lets have the sscale value
        if (sh_frac_dist.gt.1.0) then
         scale_fac_dist=1.0d0
         do j=1,3
         sh_frac_dist_grad(j)=0.0d0
         enddo
        else
         scale_fac_dist=-sh_frac_dist*sh_frac_dist
     &                   *(2.0*sh_frac_dist-3.0d0)
         fac_help_scale=6.0*(sh_frac_dist-sh_frac_dist**2)
     &                  /dist_pep_side/buff_shield*0.5
C remember for the final gradient multiply sh_frac_dist_grad(j)
C for side_chain by factor -2 !
         do j=1,3
         sh_frac_dist_grad(j)=fac_help_scale*pep_side(j)
C         print *,"jestem",scale_fac_dist,fac_help_scale,
C     &                    sh_frac_dist_grad(j)
         enddo
        endif
C        if ((i.eq.3).and.(k.eq.2)) then
C        print *,i,sh_frac_dist,dist_pep,fac_help_scale,scale_fac_dist
C     & ,"TU"
C        endif

C this is what is now we have the distance scaling now volume...
      short=short_r_sidechain(itype(k))
      long=long_r_sidechain(itype(k))
      costhet=1.0d0/dsqrt(1.0+short**2/dist_pep_side**2)
C now costhet_grad
C       costhet=0.0d0
       costhet_fac=costhet**3*short**2*(-0.5)/dist_pep_side**4
C       costhet_fac=0.0d0
       do j=1,3
         costhet_grad(j)=costhet_fac*pep_side(j)
       enddo
C remember for the final gradient multiply costhet_grad(j)
C for side_chain by factor -2 !
C fac alfa is angle between CB_k,CA_k, CA_i,CA_i+1
C pep_side0pept_group is vector multiplication
      pep_side0pept_group=0.0
      do j=1,3
      pep_side0pept_group=pep_side0pept_group+pep_side(j)*side_calf(j)
      enddo
      cosalfa=(pep_side0pept_group/
     & (dist_pep_side*dist_side_calf))
      fac_alfa_sin=1.0-cosalfa**2
      fac_alfa_sin=dsqrt(fac_alfa_sin)
      rkprim=fac_alfa_sin*(long-short)+short
C now costhet_grad
       cosphi=1.0d0/dsqrt(1.0+rkprim**2/dist_pep_side**2)
       cosphi_fac=cosphi**3*rkprim**2*(-0.5)/dist_pep_side**4

       do j=1,3
         cosphi_grad_long(j)=cosphi_fac*pep_side(j)
     &+cosphi**3*0.5/dist_pep_side**2*(-rkprim)
     &*(long-short)/fac_alfa_sin*cosalfa/
     &((dist_pep_side*dist_side_calf))*
     &((side_calf(j))-cosalfa*
     &((pep_side(j)/dist_pep_side)*dist_side_calf))

        cosphi_grad_loc(j)=cosphi**3*0.5/dist_pep_side**2*(-rkprim)
     &*(long-short)/fac_alfa_sin*cosalfa
     &/((dist_pep_side*dist_side_calf))*
     &(pep_side(j)-
     &cosalfa*side_calf(j)/dist_side_calf*dist_pep_side)
       enddo

      VofOverlap=VSolvSphere/2.0d0*(1.0-costhet)*(1.0-cosphi)
     &                    /VSolvSphere_div
     &                    *wshield
C now the gradient...
C grad_shield is gradient of Calfa for peptide groups
C      write(iout,*) "shield_compon",i,k,VSolvSphere,scale_fac_dist,
C     &               costhet,cosphi
C       write(iout,*) "cosphi_compon",i,k,pep_side0pept_group,
C     & dist_pep_side,dist_side_calf,c(1,k+nres),c(1,k),itype(k)
      do j=1,3
      grad_shield(j,i)=grad_shield(j,i)
C gradient po skalowaniu
     &                +(sh_frac_dist_grad(j)
C  gradient po costhet
     &-scale_fac_dist*costhet_grad(j)/(1.0-costhet)
     &-scale_fac_dist*(cosphi_grad_long(j))
     &/(1.0-cosphi) )*div77_81
     &*VofOverlap
C grad_shield_side is Cbeta sidechain gradient
      grad_shield_side(j,ishield_list(i),i)=
     &        (sh_frac_dist_grad(j)*(-2.0d0)
     &       +scale_fac_dist*costhet_grad(j)*2.0d0/(1.0-costhet)
     &       +scale_fac_dist*(cosphi_grad_long(j))
     &        *2.0d0/(1.0-cosphi))
     &        *div77_81*VofOverlap

       grad_shield_loc(j,ishield_list(i),i)=
     &   scale_fac_dist*cosphi_grad_loc(j)
     &        *2.0d0/(1.0-cosphi)
     &        *div77_81*VofOverlap
      enddo
      VolumeTotal=VolumeTotal+VofOverlap*scale_fac_dist
      enddo
      fac_shield(i)=VolumeTotal*div77_81+div4_81
c      write(2,*) "TOTAL VOLUME",i,VolumeTotal,fac_shield(i)
      enddo
      return
      end
#endif
C--------------------------------------------------------------------------
      double precision function tschebyshev(m,n,x,y)
      implicit none
      include "DIMENSIONS"
      integer i,m,m2,n
      double precision x(n),y,aux
      double precision ypp,yp,yi,y2
!     double precision x(n),y,yy(0:maxvar),aux
!     double precision yy(0:maxvar)
c Tschebyshev polynomial. Note that the first term is omitted
c m=0: the constant term is included
c m=1: the constant term is not included
!     yy(0)=1.0d0
!     yy(1)=y
!     do i=2,n
!       yy(i)=2*yy(1)*yy(i-1)-yy(i-2)
!     enddo
!     aux=0.0d0
!     do i=m,n
!       aux=aux+x(i)*yy(i)
!     enddo
!     yy(0)=1.0d0
!     yy(1)=y
c      write (2,*) "tschebyshev m",m," n",n," x",x," y",y
      y2=2.0d0*y
      ypp=1.0d0
      yp=y
      aux=0.0d0
      !if (m.le.0) aux=aux+x(0)*ypp  ! out-of table access for m.eq.0 @x
      if (m.le.1) aux=aux+x(1)*yp
      m2=m
      if (m2.lt.2) m2=2
      do i=2,m-1
        yi=y2*yp-ypp
        ypp=yp
        yp=yi
      enddo
      do i=m2,n
        yi=y2*yp-ypp
        aux=aux+x(i)*yi
        ypp=yp
        yp=yi
      enddo
      tschebyshev=aux
      return
      end
C--------------------------------------------------------------------------
      double precision function gradtschebyshev(m,n,x,y)
      implicit none
      include "DIMENSIONS"
      integer i,m,n,m2
      double precision x(n+1),y,aux
      double precision ypp,yp,yi,y2
      !double precision x(n+1),y,yy(0:maxvar),aux
c Tschebyshev polynomial. Note that the first term is omitted
c m=0: the constant term is included
c m=1: the constant term is not included
!      yy(0)=1.0d0
!      yy(1)=2.0d0*y
!      do i=2,n
!        yy(i)=2*y*yy(i-1)-yy(i-2)
!      enddo
!      aux=0.0d0
!      do i=m,n
!        aux=aux+x(i+1)*yy(i)*(i+1)
!C        print *, x(i+1),yy(i),i
!      enddo
      y2=2.0d0*y
      ypp=1.0d0
      yp=y2
      aux=0.0d0
      if (m.le.0) aux=aux+x(1)*ypp*1.0d0
      if (m.le.1) aux=aux+x(2)*yp*2.0d0
      m2=m
      if (m2.lt.2) m2=2
      do i=2,m-1
        yi=y2*yp-ypp
        ypp=yp
        yp=yi
      enddo
      do i=m2,n
        yi=y2*yp-ypp
        aux=aux+x(i+1)*yi*(i+1)
        ypp=yp
        yp=yi
      enddo
      gradtschebyshev=aux
      return
      end
#ifdef SHIELD
C------------------------------------------------------------------------
C first for shielding is setting of function of side-chains
       subroutine set_shield_fac2
      implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.IOUNITS'
      include 'COMMON.SHIELD'
      include 'COMMON.INTERACT'
C this is the squar root 77 devided by 81 the epislion in lipid (in protein)
      double precision div77_81/0.974996043d0/,
     &div4_81/0.2222222222d0/,sh_frac_dist_grad(3)

C the vector between center of side_chain and peptide group
       double precision pep_side(3),long,side_calf(3),
     &pept_group(3),costhet_grad(3),cosphi_grad_long(3),
     &cosphi_grad_loc(3),pep_side_norm(3),side_calf_norm(3)
C the line belowe needs to be changed for FGPROC>1
      do i=1,nres-1
      if ((itype(i).eq.ntyp1).and.itype(i+1).eq.ntyp1) cycle
      ishield_list(i)=0
Cif there two consequtive dummy atoms there is no peptide group between them
C the line below has to be changed for FGPROC>1
      VolumeTotal=0.0
      do k=1,nres
       if ((itype(k).eq.ntyp1).or.(itype(k).eq.10)) cycle
       dist_pep_side=0.0
       dist_side_calf=0.0
       do j=1,3
C first lets set vector conecting the ithe side-chain with kth side-chain
      pep_side(j)=c(j,k+nres)-(c(j,i)+c(j,i+1))/2.0d0
C      pep_side(j)=2.0d0
C and vector conecting the side-chain with its proper calfa
      side_calf(j)=c(j,k+nres)-c(j,k)
C      side_calf(j)=2.0d0
      pept_group(j)=c(j,i)-c(j,i+1)
C lets have their lenght
      dist_pep_side=pep_side(j)**2+dist_pep_side
      dist_side_calf=dist_side_calf+side_calf(j)**2
      dist_pept_group=dist_pept_group+pept_group(j)**2
      enddo
       dist_pep_side=dsqrt(dist_pep_side)
       dist_pept_group=dsqrt(dist_pept_group)
       dist_side_calf=dsqrt(dist_side_calf)
      do j=1,3
        pep_side_norm(j)=pep_side(j)/dist_pep_side
        side_calf_norm(j)=dist_side_calf
      enddo
C now sscale fraction
       sh_frac_dist=-(dist_pep_side-rpp(1,1)-buff_shield)/buff_shield
C       print *,buff_shield,"buff"
C now sscale
        if (sh_frac_dist.le.0.0) cycle
C If we reach here it means that this side chain reaches the shielding sphere
C Lets add him to the list for gradient
        ishield_list(i)=ishield_list(i)+1
C ishield_list is a list of non 0 side-chain that contribute to factor gradient
C this list is essential otherwise problem would be O3
        shield_list(ishield_list(i),i)=k
C Lets have the sscale value
        if (sh_frac_dist.gt.1.0) then
         scale_fac_dist=1.0d0
         do j=1,3
         sh_frac_dist_grad(j)=0.0d0
         enddo
        else
         scale_fac_dist=-sh_frac_dist*sh_frac_dist
     &                   *(2.0d0*sh_frac_dist-3.0d0)
         fac_help_scale=6.0d0*(sh_frac_dist-sh_frac_dist**2)
     &                  /dist_pep_side/buff_shield*0.5d0
C remember for the final gradient multiply sh_frac_dist_grad(j)
C for side_chain by factor -2 !
         do j=1,3
         sh_frac_dist_grad(j)=fac_help_scale*pep_side(j)
C         sh_frac_dist_grad(j)=0.0d0
C         scale_fac_dist=1.0d0
C         print *,"jestem",scale_fac_dist,fac_help_scale,
C     &                    sh_frac_dist_grad(j)
         enddo
        endif
C this is what is now we have the distance scaling now volume...
      short=short_r_sidechain(itype(k))
      long=long_r_sidechain(itype(k))
      costhet=1.0d0/dsqrt(1.0d0+short**2/dist_pep_side**2)
      sinthet=short/dist_pep_side*costhet
C now costhet_grad
C       costhet=0.6d0
C       sinthet=0.8
       costhet_fac=costhet**3*short**2*(-0.5d0)/dist_pep_side**4
C       sinthet_fac=costhet**2*0.5d0*(short**3/dist_pep_side**4*costhet
C     &             -short/dist_pep_side**2/costhet)
C       costhet_fac=0.0d0
       do j=1,3
         costhet_grad(j)=costhet_fac*pep_side(j)
       enddo
C remember for the final gradient multiply costhet_grad(j)
C for side_chain by factor -2 !
C fac alfa is angle between CB_k,CA_k, CA_i,CA_i+1
C pep_side0pept_group is vector multiplication
      pep_side0pept_group=0.0d0
      do j=1,3
      pep_side0pept_group=pep_side0pept_group+pep_side(j)*side_calf(j)
      enddo
      cosalfa=(pep_side0pept_group/
     & (dist_pep_side*dist_side_calf))
      fac_alfa_sin=1.0d0-cosalfa**2
      fac_alfa_sin=dsqrt(fac_alfa_sin)
      rkprim=fac_alfa_sin*(long-short)+short
C      rkprim=short

C now costhet_grad
       cosphi=1.0d0/dsqrt(1.0d0+rkprim**2/dist_pep_side**2)
C       cosphi=0.6
       cosphi_fac=cosphi**3*rkprim**2*(-0.5d0)/dist_pep_side**4
       sinphi=rkprim/dist_pep_side/dsqrt(1.0d0+rkprim**2/
     &      dist_pep_side**2)
C       sinphi=0.8
       do j=1,3
         cosphi_grad_long(j)=cosphi_fac*pep_side(j)
     &+cosphi**3*0.5d0/dist_pep_side**2*(-rkprim)
     &*(long-short)/fac_alfa_sin*cosalfa/
     &((dist_pep_side*dist_side_calf))*
     &((side_calf(j))-cosalfa*
     &((pep_side(j)/dist_pep_side)*dist_side_calf))
C       cosphi_grad_long(j)=0.0d0
        cosphi_grad_loc(j)=cosphi**3*0.5d0/dist_pep_side**2*(-rkprim)
     &*(long-short)/fac_alfa_sin*cosalfa
     &/((dist_pep_side*dist_side_calf))*
     &(pep_side(j)-
     &cosalfa*side_calf(j)/dist_side_calf*dist_pep_side)
C       cosphi_grad_loc(j)=0.0d0
       enddo
C      print *,sinphi,sinthet
c      write (iout,*) "VSolvSphere",VSolvSphere," VSolvSphere_div",
c     &  VSolvSphere_div," sinphi",sinphi," sinthet",sinthet
      VofOverlap=VSolvSphere/2.0d0*(1.0d0-dsqrt(1.0d0-sinphi*sinthet))
     &                    /VSolvSphere_div
C     &                    *wshield
C now the gradient...
      do j=1,3
      grad_shield(j,i)=grad_shield(j,i)
C gradient po skalowaniu
     &                +(sh_frac_dist_grad(j)*VofOverlap
C  gradient po costhet
     &       +scale_fac_dist*VSolvSphere/VSolvSphere_div/4.0d0*
     &(1.0d0/(-dsqrt(1.0d0-sinphi*sinthet))*(
     &       sinphi/sinthet*costhet*costhet_grad(j)
     &      +sinthet/sinphi*cosphi*cosphi_grad_long(j)))
     & )*wshield
C grad_shield_side is Cbeta sidechain gradient
      grad_shield_side(j,ishield_list(i),i)=
     &        (sh_frac_dist_grad(j)*(-2.0d0)
     &        *VofOverlap
     &       -scale_fac_dist*VSolvSphere/VSolvSphere_div/2.0d0*
     &(1.0d0/(-dsqrt(1.0d0-sinphi*sinthet))*(
     &       sinphi/sinthet*costhet*costhet_grad(j)
     &      +sinthet/sinphi*cosphi*cosphi_grad_long(j)))
     &       )*wshield

       grad_shield_loc(j,ishield_list(i),i)=
     &       scale_fac_dist*VSolvSphere/VSolvSphere_div/2.0d0*
     &(1.0d0/(dsqrt(1.0d0-sinphi*sinthet))*(
     &       sinthet/sinphi*cosphi*cosphi_grad_loc(j)
     &        ))
     &        *wshield
      enddo
c      write (iout,*) "VofOverlap",VofOverlap," scale_fac_dist",
c     & scale_fac_dist
      VolumeTotal=VolumeTotal+VofOverlap*scale_fac_dist
      enddo
      fac_shield(i)=VolumeTotal*wshield+(1.0d0-wshield)
c      write(2,*) "TOTAL VOLUME",i,VolumeTotal,fac_shield(i),
c     &  " wshield",wshield
c      write(2,*) "TU",rpp(1,1),short,long,buff_shield
      enddo
      return
      end
#endif
C-----------------------------------------------------------------------
C-----------------------------------------------------------
C This subroutine is to mimic the histone like structure but as well can be
C utilizet to nanostructures (infinit) small modification has to be used to
C make it finite (z gradient at the ends has to be changes as well as the x,y
C gradient has to be modified at the ends
C The energy function is Kihara potential
C E=4esp*((sigma/(r-r0))^12 - (sigma/(r-r0))^6)
C 4eps is depth of well sigma is r_minimum r is distance from center of tube
C and r0 is the excluded size of nanotube (can be set to 0 if we want just a
C simple Kihara potential
      subroutine calctube(Etube)
       implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.CONTROL'
      include 'COMMON.SPLITELE'
      include 'COMMON.SBRIDGE'
      double precision tub_r,vectube(3),enetube(maxres*2)
      common /calctubecommon/ enetube
      Etube=0.0d0
      do i=1,2*nres
        enetube(i)=0.0d0
      enddo
C first we calculate the distance from tube center
C first sugare-phosphate group for NARES this would be peptide group
C for UNRES
      do i=1,nres
C lets ommit dummy atoms for now
       if ((itype(i).eq.ntyp1).or.(itype(i+1).eq.ntyp1)) cycle
C now calculate distance from center of tube and direction vectors
      vectube(1)=mod((c(1,i)+c(1,i+1))/2.0d0,boxxsize)
          if (vectube(1).lt.0) vectube(1)=vectube(1)+boxxsize
      vectube(2)=mod((c(2,i)+c(2,i+1))/2.0d0,boxxsize)
          if (vectube(2).lt.0) vectube(2)=vectube(2)+boxxsize
      vectube(1)=vectube(1)-tubecenter(1)
      vectube(2)=vectube(2)-tubecenter(2)

C      print *,"x",(c(1,i)+c(1,i+1))/2.0d0,tubecenter(1)
C      print *,"y",(c(2,i)+c(2,i+1))/2.0d0,tubecenter(2)

C as the tube is infinity we do not calculate the Z-vector use of Z
C as chosen axis
      vectube(3)=0.0d0
C now calculte the distance
       tub_r=dsqrt(vectube(1)**2+vectube(2)**2+vectube(3)**2)
C now normalize vector
      vectube(1)=vectube(1)/tub_r
      vectube(2)=vectube(2)/tub_r
C calculte rdiffrence between r and r0
      rdiff=tub_r-tubeR0
C and its 6 power
      rdiff6=rdiff**6.0d0
C for vectorization reasons we will sumup at the end to avoid depenence of previous
       enetube(i)=pep_aa_tube/rdiff6**2.0d0-pep_bb_tube/rdiff6
C       write(iout,*) "TU13",i,rdiff6,enetube(i)
C       print *,rdiff,rdiff6,pep_aa_tube
C pep_aa_tube and pep_bb_tube are precomputed values A=4eps*sigma^12 B=4eps*sigma^6
C now we calculate gradient
       fac=(-12.0d0*pep_aa_tube/rdiff6+
     &       6.0d0*pep_bb_tube)/rdiff6/rdiff
C       write(iout,'(a5,i4,f12.1,3f12.5)') "TU13",i,rdiff6,enetube(i),
C     &rdiff,fac

C now direction of gg_tube vector
        do j=1,3
        gg_tube(j,i-1)=gg_tube(j,i-1)+vectube(j)*fac/2.0d0
        gg_tube(j,i)=gg_tube(j,i)+vectube(j)*fac/2.0d0
        enddo
        enddo
C basically thats all code now we split for side-chains (REMEMBER to sum up at the END)
        do i=1,nres
C Lets not jump over memory as we use many times iti
         iti=itype(i)
C lets ommit dummy atoms for now
         if ((iti.eq.ntyp1)
C in UNRES uncomment the line below as GLY has no side-chain...
C      .or.(iti.eq.10)
     &   ) cycle
          vectube(1)=c(1,i+nres)
          vectube(1)=mod(vectube(1),boxxsize)
          if (vectube(1).lt.0) vectube(1)=vectube(1)+boxxsize
          vectube(2)=c(2,i+nres)
          vectube(2)=mod(vectube(2),boxxsize)
          if (vectube(2).lt.0) vectube(2)=vectube(2)+boxxsize

      vectube(1)=vectube(1)-tubecenter(1)
      vectube(2)=vectube(2)-tubecenter(2)

C as the tube is infinity we do not calculate the Z-vector use of Z
C as chosen axis
      vectube(3)=0.0d0
C now calculte the distance
       tub_r=dsqrt(vectube(1)**2+vectube(2)**2+vectube(3)**2)
C now normalize vector
      vectube(1)=vectube(1)/tub_r
      vectube(2)=vectube(2)/tub_r
C calculte rdiffrence between r and r0
      rdiff=tub_r-tubeR0
C and its 6 power
      rdiff6=rdiff**6.0d0
C for vectorization reasons we will sumup at the end to avoid depenence of previous
       sc_aa_tube=sc_aa_tube_par(iti)
       sc_bb_tube=sc_bb_tube_par(iti)
       enetube(i+nres)=sc_aa_tube/rdiff6**2.0d0-sc_bb_tube/rdiff6
C pep_aa_tube and pep_bb_tube are precomputed values A=4eps*sigma^12 B=4eps*sigma^6
C now we calculate gradient
       fac=-12.0d0*sc_aa_tube/rdiff6**2.0d0/rdiff+
     &       6.0d0*sc_bb_tube/rdiff6/rdiff
C now direction of gg_tube vector
         do j=1,3
          gg_tube_SC(j,i)=gg_tube_SC(j,i)+vectube(j)*fac
          gg_tube(j,i-1)=gg_tube(j,i-1)+vectube(j)*fac
         enddo
        enddo
        do i=1,2*nres
          Etube=Etube+enetube(i)
        enddo
C        print *,"ETUBE", etube
        return
        end
C TO DO 1) add to total energy
C       2) add to gradient summation
C       3) add reading parameters (AND of course oppening of PARAM file)
C       4) add reading the center of tube
C       5) add COMMONs
C       6) add to zerograd

C-----------------------------------------------------------------------
C-----------------------------------------------------------
C This subroutine is to mimic the histone like structure but as well can be
C utilizet to nanostructures (infinit) small modification has to be used to
C make it finite (z gradient at the ends has to be changes as well as the x,y
C gradient has to be modified at the ends
C The energy function is Kihara potential
C E=4esp*((sigma/(r-r0))^12 - (sigma/(r-r0))^6)
C 4eps is depth of well sigma is r_minimum r is distance from center of tube
C and r0 is the excluded size of nanotube (can be set to 0 if we want just a
C simple Kihara potential
      subroutine calctube2(Etube)
       implicit real*8 (a-h,o-z)
      include 'DIMENSIONS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.NAMES'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CALC'
      include 'COMMON.CONTROL'
      include 'COMMON.SPLITELE'
      include 'COMMON.SBRIDGE'
      double precision tub_r,vectube(3),enetube(maxres*2)
      common /calctubecommon/ enetube
      Etube=0.0d0
      do i=1,2*nres
        enetube(i)=0.0d0
      enddo
C first we calculate the distance from tube center
C first sugare-phosphate group for NARES this would be peptide group
C for UNRES
      do i=1,nres
C lets ommit dummy atoms for now
       if ((itype(i).eq.ntyp1).or.(itype(i+1).eq.ntyp1)) cycle
C now calculate distance from center of tube and direction vectors
      vectube(1)=mod((c(1,i)+c(1,i+1))/2.0d0,boxxsize)
          if (vectube(1).lt.0) vectube(1)=vectube(1)+boxxsize
      vectube(2)=mod((c(2,i)+c(2,i+1))/2.0d0,boxxsize)
          if (vectube(2).lt.0) vectube(2)=vectube(2)+boxxsize
      vectube(1)=vectube(1)-tubecenter(1)
      vectube(2)=vectube(2)-tubecenter(2)

C      print *,"x",(c(1,i)+c(1,i+1))/2.0d0,tubecenter(1)
C      print *,"y",(c(2,i)+c(2,i+1))/2.0d0,tubecenter(2)

C as the tube is infinity we do not calculate the Z-vector use of Z
C as chosen axis
      vectube(3)=0.0d0
C now calculte the distance
       tub_r=dsqrt(vectube(1)**2+vectube(2)**2+vectube(3)**2)
C now normalize vector
      vectube(1)=vectube(1)/tub_r
      vectube(2)=vectube(2)/tub_r
C calculte rdiffrence between r and r0
      rdiff=tub_r-tubeR0
C and its 6 power
      rdiff6=rdiff**6.0d0
C for vectorization reasons we will sumup at the end to avoid depenence of previous
       enetube(i)=pep_aa_tube/rdiff6**2.0d0-pep_bb_tube/rdiff6
C       write(iout,*) "TU13",i,rdiff6,enetube(i)
C       print *,rdiff,rdiff6,pep_aa_tube
C pep_aa_tube and pep_bb_tube are precomputed values A=4eps*sigma^12 B=4eps*sigma^6
C now we calculate gradient
       fac=(-12.0d0*pep_aa_tube/rdiff6+
     &       6.0d0*pep_bb_tube)/rdiff6/rdiff
C       write(iout,'(a5,i4,f12.1,3f12.5)') "TU13",i,rdiff6,enetube(i),
C     &rdiff,fac

C now direction of gg_tube vector
        do j=1,3
        gg_tube(j,i-1)=gg_tube(j,i-1)+vectube(j)*fac/2.0d0
        gg_tube(j,i)=gg_tube(j,i)+vectube(j)*fac/2.0d0
        enddo
        enddo
C basically thats all code now we split for side-chains (REMEMBER to sum up at the END)
        do i=1,nres
C Lets not jump over memory as we use many times iti
         iti=itype(i)
C lets ommit dummy atoms for now
         if ((iti.eq.ntyp1)
C in UNRES uncomment the line below as GLY has no side-chain...
     &      .or.(iti.eq.10)
     &   ) cycle
          vectube(1)=c(1,i+nres)
          vectube(1)=mod(vectube(1),boxxsize)
          if (vectube(1).lt.0) vectube(1)=vectube(1)+boxxsize
          vectube(2)=c(2,i+nres)
          vectube(2)=mod(vectube(2),boxxsize)
          if (vectube(2).lt.0) vectube(2)=vectube(2)+boxxsize

      vectube(1)=vectube(1)-tubecenter(1)
      vectube(2)=vectube(2)-tubecenter(2)
C THIS FRAGMENT MAKES TUBE FINITE
        positi=(mod(c(3,i+nres),boxzsize))
        if (positi.le.0) positi=positi+boxzsize
C       print *,mod(c(3,i+nres),boxzsize),bordlipbot,bordliptop
c for each residue check if it is in lipid or lipid water border area
C       respos=mod(c(3,i+nres),boxzsize)
       print *,positi,bordtubebot,buftubebot,bordtubetop
       if ((positi.gt.bordtubebot)
     & .and.(positi.lt.bordtubetop)) then
C the energy transfer exist
        if (positi.lt.buftubebot) then
         fracinbuf=1.0d0-
     &     ((positi-bordtubebot)/tubebufthick)
C lipbufthick is thickenes of lipid buffore
         sstube=sscalelip(fracinbuf)
         ssgradtube=-sscagradlip(fracinbuf)/tubebufthick
         print *,ssgradtube, sstube,tubetranene(itype(i))
         enetube(i+nres)=enetube(i+nres)+sstube*tubetranene(itype(i))
         gg_tube_SC(3,i)=gg_tube_SC(3,i)
     &+ssgradtube*tubetranene(itype(i))
         gg_tube(3,i-1)= gg_tube(3,i-1)
     &+ssgradtube*tubetranene(itype(i))
C         print *,"doing sccale for lower part"
        elseif (positi.gt.buftubetop) then
         fracinbuf=1.0d0-
     &((bordtubetop-positi)/tubebufthick)
         sstube=sscalelip(fracinbuf)
         ssgradtube=sscagradlip(fracinbuf)/tubebufthick
         enetube(i+nres)=enetube(i+nres)+sstube*tubetranene(itype(i))
C         gg_tube_SC(3,i)=gg_tube_SC(3,i)
C     &+ssgradtube*tubetranene(itype(i))
C         gg_tube(3,i-1)= gg_tube(3,i-1)
C     &+ssgradtube*tubetranene(itype(i))
C          print *, "doing sscalefor top part",sslip,fracinbuf
        else
         sstube=1.0d0
         ssgradtube=0.0d0
         enetube(i+nres)=enetube(i+nres)+sstube*tubetranene(itype(i))
C         print *,"I am in true lipid"
        endif
        else
C          sstube=0.0d0
C          ssgradtube=0.0d0
        cycle
        endif ! if in lipid or buffor
CEND OF FINITE FRAGMENT
C as the tube is infinity we do not calculate the Z-vector use of Z
C as chosen axis
      vectube(3)=0.0d0
C now calculte the distance
       tub_r=dsqrt(vectube(1)**2+vectube(2)**2+vectube(3)**2)
C now normalize vector
      vectube(1)=vectube(1)/tub_r
      vectube(2)=vectube(2)/tub_r
C calculte rdiffrence between r and r0
      rdiff=tub_r-tubeR0
C and its 6 power
      rdiff6=rdiff**6.0d0
C for vectorization reasons we will sumup at the end to avoid depenence of previous
       sc_aa_tube=sc_aa_tube_par(iti)
       sc_bb_tube=sc_bb_tube_par(iti)
       enetube(i+nres)=(sc_aa_tube/rdiff6**2.0d0-sc_bb_tube/rdiff6)
     &                 *sstube+enetube(i+nres)
C pep_aa_tube and pep_bb_tube are precomputed values A=4eps*sigma^12 B=4eps*sigma^6
C now we calculate gradient
       fac=(-12.0d0*sc_aa_tube/rdiff6**2.0d0/rdiff+
     &       6.0d0*sc_bb_tube/rdiff6/rdiff)*sstube
C now direction of gg_tube vector
         do j=1,3
          gg_tube_SC(j,i)=gg_tube_SC(j,i)+vectube(j)*fac
          gg_tube(j,i-1)=gg_tube(j,i-1)+vectube(j)*fac
         enddo
         gg_tube_SC(3,i)=gg_tube_SC(3,i)
     &+ssgradtube*enetube(i+nres)/sstube
         gg_tube(3,i-1)= gg_tube(3,i-1)
     &+ssgradtube*enetube(i+nres)/sstube

        enddo
        do i=1,2*nres
          Etube=Etube+enetube(i)
        enddo
C        print *,"ETUBE", etube
        return
        end
C TO DO 1) add to total energy
C       2) add to gradient summation
C       3) add reading parameters (AND of course oppening of PARAM file)
C       4) add reading the center of tube
C       5) add COMMONs
C       6) add to zerograd
c----------------------------------------------------------------------------
      double precision function boxshift(x,boxsize)
      implicit none
      double precision x,boxsize
      double precision xtemp
      xtemp=dmod(x,boxsize)
      if (dabs(xtemp-boxsize).lt.dabs(xtemp)) then
        boxshift=xtemp-boxsize
      else if (dabs(xtemp+boxsize).lt.dabs(xtemp)) then
        boxshift=xtemp+boxsize
      else
        boxshift=xtemp
      endif
      return
      end
c--------------------------------------------------------------------------
      subroutine closest_img(xi,yi,zi,xj,yj,zj)
      include 'DIMENSIONS'
      include 'COMMON.CHAIN'
      integer xshift,yshift,zshift,subchap
      double precision dist_init,xj_safe,yj_safe,zj_safe,
     & xj_temp,yj_temp,zj_temp,dist_temp
      xj_safe=xj
      yj_safe=yj
      zj_safe=zj
      dist_init=(xj-xi)**2+(yj-yi)**2+(zj-zi)**2
      subchap=0
      do xshift=-1,1
        do yshift=-1,1
          do zshift=-1,1
            xj=xj_safe+xshift*boxxsize
            yj=yj_safe+yshift*boxysize
            zj=zj_safe+zshift*boxzsize
            dist_temp=(xj-xi)**2+(yj-yi)**2+(zj-zi)**2
            if(dist_temp.lt.dist_init) then
              dist_init=dist_temp
              xj_temp=xj
              yj_temp=yj
              zj_temp=zj
              subchap=1
            endif
          enddo
        enddo
      enddo
      if (subchap.eq.1) then
        xj=xj_temp-xi
        yj=yj_temp-yi
        zj=zj_temp-zi
      else
        xj=xj_safe-xi
        yj=yj_safe-yi
        zj=zj_safe-zi
      endif
      return
      end
c--------------------------------------------------------------------------
      subroutine to_box(xi,yi,zi)
      implicit none
      include 'COMMON.NEWBOX'
      double precision xi,yi,zi
      double precision pos(3),scaled(3),wrapped(3)
      pos(1)=xi
      pos(2)=yi
      pos(3)=zi
      scaled=pos*iboxsize
      wrapped=scaled-floor(scaled)
      pos=wrapped*boxsize
      xi=pos(1)
      yi=pos(2)
      zi=pos(3)
      return
      end
c--------------------------------------------------------------------------
      subroutine lipid_layer(xi,yi,zi,sslipi,ssgradlipi)
      implicit none
      include 'DIMENSIONS'
      include 'COMMON.IOUNITS'
      include 'COMMON.CHAIN'
      double precision xi,yi,zi,sslipi,ssgradlipi
      double precision fracinbuf
      double precision sscalelip,sscagradlip
#ifdef DEBUG
      write (iout,*) "bordlipbot",bordlipbot," bordliptop",bordliptop
      write (iout,*) "buflipbot",buflipbot," lipbufthick",lipbufthick
      write (iout,*) "xi yi zi",xi,yi,zi
#endif
      if ((zi.gt.bordlipbot).and.(zi.lt.bordliptop)) then
C the energy transfer exist
        if (zi.lt.buflipbot) then
C what fraction I am in
          fracinbuf=1.0d0-((zi-bordlipbot)/lipbufthick)
C lipbufthick is thickenes of lipid buffore
          sslipi=sscalelip(fracinbuf)
          ssgradlipi=-sscagradlip(fracinbuf)/lipbufthick
        elseif (zi.gt.bufliptop) then
          fracinbuf=1.0d0-((bordliptop-zi)/lipbufthick)
          sslipi=sscalelip(fracinbuf)
          ssgradlipi=sscagradlip(fracinbuf)/lipbufthick
        else
          sslipi=1.0d0
          ssgradlipi=0.0
        endif
      else
        sslipi=0.0d0
        ssgradlipi=0.0
      endif
#ifdef DEBUG
      write (iout,*) "sslipi",sslipi," ssgradlipi",ssgradlipi
#endif
      return
      end
