      subroutine eelec_scale_save(evdw1)
C
C This subroutine calculates the average interaction energy and its gradient
C in the virtual-bond vectors between non-adjacent peptide groups, based on 
C the potential described in Liwo et al., Protein Sci., 1993, 2, 1715. 
C The potential depends both on the distance of peptide-group centers and on 
C the orientation of the CA-CA virtual bonds.
C 
      implicit real*8 (a-h,o-z)
#ifdef MPI
      include 'mpif.h'
#else
      double precision tcpu
#endif
      include 'DIMENSIONS'
      include 'COMMON.CONTROL'
      include 'COMMON.SETUP'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.CORRMAT'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      include 'COMMON.TIME1'
#ifdef SHIELD
      include 'COMMON.SHIELD'
#endif
      include 'COMMON.SPLITELE'
      include 'COMMON.LOCEL'
      include 'COMMON.LIPCALC'
      include 'COMMON.SCALESAVE'
      integer ikont,jblock
      dimension ggg(3),gggp(3),gggm(3),erij(3),dcosb(3),dcosg(3),
     &          erder(3,3),uryg(3,3),urzg(3,3),vryg(3,3),vrzg(3,3)
      double precision muij(4)
c 4/26/02 - AL scaling factor for 1,4 repulsive VDW interactions
#ifdef MOMENT
      double precision scal_el /1.0d0/
#else
      double precision scal_el /0.5d0/
#endif
      integer*1 doturn(maxres)
      common /eelecscalecommon/doturn
C 12/13/98 
C 13-go grudnia roku pamietnego... 
      logical tail_agg
      evdwpp_save=0.0d0
      ees_save=0.0d0
      eel_loc_save=0.0d0
      eello_turn3_save=0.0d0
      eello_turn4_save=0.0d0
      call zero_array(3,nres+2,gelc_save(1,-1))
      call zero_array(3,nres+2,gelc_long_save(1,-1))
      call zero_array(3,nres+2,gel_loc_save(1,-1))
      call zero_array(3,nres+2,gel_loc_long_save(1,-1))
      call zero_array(3,nres+2,gvdwpp_save(1,-1))
      if (icheckgrad.eq.1) then
        do i=1,nres-1
          fac=1.0d0/dsqrt(scalar(dc(1,i),dc(1,i)))
          do k=1,3
            dc_norm(k,i)=dc(k,i)*fac
          enddo
c          write (iout,*) 'i',i,' fac',fac
        enddo
      endif
      if (wel_loc.gt.0.0d0 .or. wcorr4.gt.0.0d0 .or. wcorr5.gt.0.0d0 
     &    .or. wcorr6.gt.0.0d0 .or. wturn3.gt.0.0d0 .or. 
     &    wturn4.gt.0.0d0 .or. wturn6.gt.0.0d0) then
c        call vec_and_deriv
#ifdef TIMING
#ifdef MPI
        time01=MPI_Wtime()
#else
        time01=tcpu()
#endif
#endif
        call set_matrices
#ifdef TIMING
#ifdef MPI
        time_mat=time_mat+MPI_Wtime()-time01
#else
        time_mat=time_mat+tcpu()-time01
#endif
#endif
      endif
      t_eelecij=0.0d0
      ees=0.0D0
      evdw1=0.0D0
      eel_loc=0.0d0 
      eello_turn3=0.0d0
      eello_turn4=0.0d0
      ind=0
cd      print '(a)','Enter EELEC_scale_save'
cd      write (iout,*) 'iatel_s=',iatel_s,' iatel_e=',iatel_e
c
c
c 9/27/08 AL Split the interaction loop to ensure load balancing of turn terms
C
C Loop over i,i+2 and i,i+3 pairs of the peptide groups
C
      tail_agg=(wturn3.gt.0.0d0)
      do i=iturn3_start,iturn3_end
        if (itype(i).eq.ntyp1.or. itype(i+1).eq.ntyp1
     &  .or. itype(i+2).eq.ntyp1 .or. itype(i+3).eq.ntyp1
     &   ) cycle
c        call eelecij_scale_save(i,i+2,evdw1,tail_agg)
c        if (tail_agg) call eturn3(i,eello_turn3)
        call eelecij_scale_save(i,i+2,evdw1)
        if (tail_agg) doturn(i)=or(doturn(i),1)
      enddo
      do i=iturn4_start,iturn4_end
        if (itype(i).eq.ntyp1 .or. itype(i+1).eq.ntyp1
     &    .or. itype(i+3).eq.ntyp1
     &    .or. itype(i+4).eq.ntyp1
     &    ) cycle
        tail_agg=(wturn4.gt.0.0d0 .and. itype(i+2).ne.ntyp1)
c        call eelecij_scale_save(i,i+3,evdw1,tail_agg)
c        if (tail_agg) call eturn4(i,eello_turn4)
        call eelecij_scale_save(i,i+3,evdw1)
        if (tail_agg) doturn(i)=or(doturn(i),2)
      enddo   ! i
      call calculate_turns(doturn,eello_turn3,eello_turn4)
c
c Loop over all pairs of interacting peptide groups except i,i+2 and i,i+3
c
      if (energy_dec)
     & write(iout,*) "g_listpp_start,g_listpp_end",
     & g_listpp_start,g_listpp_end
      do ikont=g_listpp_start,g_listpp_end
        i=newcontlistppi(1,ikont)
        do jblock=newcontlistppi(2,ikont-1)+1,newcontlistppi(2,ikont)
        do j=newcontlistppj(1,jblock),newcontlistppj(2,jblock)
c          call eelecij_scale_save(i,j,evdw1,tail_agg)
          call eelecij_scale_save(i,j,evdw1)
        enddo ! j
        enddo ! jblock
      enddo   ! ikont

c      write (iout,*) "evdwpp_save",evdwpp_save
      eello_turn3_save=eello_turn3
      eello_turn4_save=eello_turn4
      eello_turn3=0.0d0
      eello_turn4=0.0d0
      gcorr3_turn_save(:,:nres)=gcorr3_turn(:,:nres)
      gcorr4_turn_save(:,:nres)=gcorr4_turn(:,:nres)
      call zero_array(3,nres+2,gcorr3_turn(1,-1))
      call zero_array(3,nres+2,gcorr4_turn(1,-1))
c      print *,"Processor",fg_rank," evdw1",evdw1
      return
      end
C-------------------------------------------------------------------------------
      subroutine eelecij_scale_save(i,j,evdw1)
      implicit none
      include 'DIMENSIONS'
#ifdef MPI
      include "mpif.h"
#endif
      include 'COMMON.CONTROL'
      include 'COMMON.IOUNITS'
      include 'COMMON.GEO'
      include 'COMMON.VAR'
      include 'COMMON.LOCAL'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.INTERACT'
      include 'COMMON.CORRMAT'
      include 'COMMON.TORSION'
      include 'COMMON.VECTORS'
      include 'COMMON.FFIELD'
      include 'COMMON.TIME1'
#ifdef SHIELD
      include 'COMMON.SHIELD'
#endif
      include 'COMMON.SPLITELE'
      include 'COMMON.LOCEL'
      include 'COMMON.LIPCALC'
      include 'COMMON.SCALESAVE'
      integer xshift,yshift,zshift
      double precision muimuj,muier,mujer,xyzj(3),auxvec(3)
      logical tail_agg
      double precision ggg(3),gggp(3),gggm(3),erij(3),dcosb(3),dcosg(3)
      integer k,i,j,iteli,itelj,kkk,l,kkll,m,isubchap,ind,itypi,itypj
#ifdef SHIELD
      integer ilist,iresshield
      double precision rlocshield
#endif
      double precision ael6i,rrmij,rmij,r0ij,fcont,fprimcont,ees0tmp
      double precision ees,evdw1,eel_loc,aaa,bbb,ael3i
      double precision rij,r3ij,r6ij,cosa,cosb,cosg,fac,ev1,ev2,fac3,
     &  fac4,
     &  evdwij,el1,el2,eesij,facvdw,facel,fac1,ecosa,
     &  ecosb,ecosg,
     &  eel_loc_ij,eel_loc_ij_1,cosa4,wij,cosbg1,cosbg2,
     &  ecosa1,ecosb1,ecosg1,ecosa2,ecosb2,ecosg2,ecosap,ecosbp,
     &  ecosgp,ecosam,ecosbm,ecosgm,ghalf,geel_loc_ij,geel_loc_ji,
     &  facvdw_save
      double precision aux
      double precision sss1,sssgrad1
      double precision sscale,sscagrad
      double precision scalar
      double precision boxshift
      double precision faclipij2
c 4/26/02 - AL scaling factor for 1,4 repulsive VDW interactions
#ifdef MOMENT
      double precision scal_el /1.0d0/
#else
      double precision scal_el /0.5d0/
#endif
C 12/13/98 
C 13-go grudnia roku pamietnego... 
c          time00=MPI_Wtime()
cd      write (iout,*) "eelecij",i,j
C      print *,"WCHODZE2"
      call wrapvec(cp(:,j)-cp(:,i), xyzj)
      rij=scalar(xyzj,xyzj)
      if(rij.ge.r_cut_int_sq) return

      iteli=itel(i)
      itelj=itel(j)
      if (j.eq.i+2 .and. itelj.eq.2) iteli=2
      aaa=app(iteli,itelj)
      bbb=bpp(iteli,itelj)
      ael6i=ael6(iteli,itelj)
      ael3i=ael3(iteli,itelj) 
      call lipid_layer(cp(1,i),cp(2,i),cp(3,i),sslipi,ssgradlipi)
      call lipid_layer(cp(1,j),cp(2,j),cp(3,j),sslipj,ssgradlipj)
      faclipij=(sslipi+sslipj)/2.0d0*lipscale+1.0d0
      faclipij2=(sslipi+sslipj)/2.0d0*lipscale**2+1.0d0
      rrmij=1.0D0/rij
      rij=dsqrt(rij)
      rmij=1.0D0/rij
      r3ij=rrmij*rmij
      r6ij=r3ij*r3ij  
c For extracting the short-range part of Evdwpp
      sss1=sscale(rij,r_cut_int)
      sss=sscale(rij/rpp(iteli,itelj),r_cut_respa)
      sssgrad=sscagrad(rij/rpp(iteli,itelj),r_cut_respa)
      sssgrad1=sscagrad(rij,r_cut_int)
c      cosa=dx_normi*dx_normj+dy_normi*dy_normj+dz_normi*dz_normj
c      cosb=(xj*dx_normi+yj*dy_normi+zj*dz_normi)*rmij
c      cosg=(xj*dx_normj+yj*dy_normj+zj*dz_normj)*rmij
      cosa=scalar(dc_norm(:,i),dc_norm(:,j))
      cosb=scalar(xyzj,dc_norm(:,i))*rmij
      cosg=scalar(xyzj,dc_norm(:,j))*rmij
      fac=cosa-3.0D0*cosb*cosg
c 1/03/22 AL: don't compute short-range VDW pp energy
      ev1=aaa*r6ij*r6ij !to move
      if (j.eq.i+2) ev1=scal_el*ev1 ! to move
      ev2=bbb*r6ij ! to move
      evdwij=ev1+ev2 ! to move
      facvdw_save=-6*rrmij*(ev1+evdwij)*sss1
      facvdw=facvdw_save*sss
      if (sss.lt.1.0d0) then
c long-range interactions
c 4/26/02 - AL scaling down 1,4 repulsive VDW interactions ! to move
        evdwpp_save=evdwpp_save+evdwij*(1.0d0-sss)*sss1
     &    *faclipij2 ! to move
c        facvdw_save=-6*rrmij*(ev1+evdwij)*(1.0d0-sss)*sss1
        facvdw_save=facvdw_save-facvdw
      endif
      if (sss.gt.0.0d0) then
c short-range interactions
        evdw1=evdw1+evdwij*sss*sss1*faclipij2 ! to move
c        facvdw=-6*rrmij*(ev1+evdwij)*sss*sss1
      endif ! to move
      fac3=ael6i*r6ij
      fac4=ael3i*r3ij
#ifdef SHIELD
      if (shield_mode.eq.0) then
        fac_shield(i)=1.0
        fac_shield(j)=1.0
      endif
#endif
      el1=fac3*(4.0D0+fac*fac-3.0D0*(cosb*cosb+cosg*cosg))
      el2=fac4*fac       
#ifdef SHIELD
      el1=el1*fac_shield(i)**2*fac_shield(j)**2
      el2=el2*fac_shield(i)**2*fac_shield(j)**2
#endif
      eesij=el1+el2
C 12/26/95 - for the evaluation of multi-body H-bonding interactions
c      ees0ij=4.0D0+fac*fac-3.0D0*(cosb*cosb+cosg*cosg)
      ees_save=ees_save+eesij*sss1*faclipij2
cd          write(iout,'(2(2i3,2x),7(1pd12.4)/2(3(1pd12.4),5x)/)')
cd     &      iteli,i,itelj,j,aaa,bbb,ael6i,ael3i,
cd     &      1.0D0/dsqrt(rrmij),evdwij,eesij,
cd     &      xmedi,ymedi,zmedi,xj,yj,zj

#ifdef SHIELD
      if (energy_dec) then 
        write (iout,'(a6,2i5,0pf7.3,2i5,e11.3,5f10.5)')
     & 'evdw11',i,j,evdwij,iteli,itelj,aaa,sss,sss1,sssgrad,
     &  sssgrad1,rij
        write (iout,'(a6,2i5,0pf7.3,6f8.5)') 'ees',i,j,eesij,
     &  fac_shield(i),fac_shield(j),sslipi,sslipj,faclipij,faclipij2
      endif
#else
      if (energy_dec) then 
        write (iout,'(a6,2i5,0pf7.3,2i5,e11.3,5f10.5)')
     & 'evdw11',i,j,evdwij,iteli,itelj,aaa,sss,sss1,sssgrad,
     &  sssgrad1,rij
        write (iout,'(a6,2i5,0pf7.3,6f8.5)') 'ees',i,j,eesij,
     &  sslipi,sslipj,faclipij,faclipij2
      endif
#endif
C
C Calculate contributions to the Cartesian gradient.
C
      facel=-3*rrmij*(el1+eesij)*sss1
      fac1=fac
      call scalevec(xyzj,rmij,erij)
*
* Radial derivatives. First process both termini of the fragment (i,j)
*
      aux=(facel+sssgrad1*eesij*rmij)*faclipij2
      call scalevec(xyzj,aux,ggg)
#ifdef SHIELD
      if ((fac_shield(i).gt.0).and.(fac_shield(j).gt.0).and.
     &  (shield_mode.gt.0)) then
C          print *,i,j     
        do ilist=1,ishield_list(i)
          iresshield=shield_list(ilist,i)
          do k=1,3
           rlocshield=grad_shield_side(k,ilist,i)*eesij*sss1
     &      /fac_shield(i)*2.0*sss1
           gshieldx(k,iresshield)=gshieldx(k,iresshield)+
     &              rlocshield
     &     +grad_shield_loc(k,ilist,i)*eesij*sss1/fac_shield(i)*2.0
     &      *sss1
            gshieldc(k,iresshield-1)=gshieldc(k,iresshield-1)+rlocshield
          enddo
        enddo
        do ilist=1,ishield_list(j)
          iresshield=shield_list(ilist,j)
          do k=1,3
           rlocshield=grad_shield_side(k,ilist,j)*eesij/fac_shield(j)
     &     *2.0*sss1
           gshieldx(k,iresshield)=gshieldx(k,iresshield)+
     &        rlocshield
     &        +grad_shield_loc(k,ilist,j)*eesij/fac_shield(j)*2.0*sss1
           gshieldc(k,iresshield-1)=gshieldc(k,iresshield-1)+rlocshield
          enddo
        enddo

        do k=1,3
           gshieldc(k,i)=gshieldc(k,i)+
     &             grad_shield(k,i)*eesij/fac_shield(i)*2.0*sss1
           gshieldc(k,j)=gshieldc(k,j)+
     &             grad_shield(k,j)*eesij/fac_shield(j)*2.0*sss1
           gshieldc(k,i-1)=gshieldc(k,i-1)+
     &             grad_shield(k,i)*eesij/fac_shield(i)*2.0*sss1
           gshieldc(k,j-1)=gshieldc(k,j-1)+
     &             grad_shield(k,j)*eesij/fac_shield(j)*2.0*sss1

        enddo
      endif
#endif
c 9/28/08 AL Gradient compotents will be summed only at the end
      do k=1,3
        gelc_long_save(k,j)=gelc_long_save(k,j)+ggg(k)
        gelc_long_save(k,i)=gelc_long_save(k,i)-ggg(k)
      enddo
      gelc_long_save(3,j)=gelc_long_save(3,j)+
     &  ssgradlipj*eesij/2.0d0*lipscale**2*sss1
      gelc_long_save(3,i)=gelc_long_save(3,i)+
     &  ssgradlipi*eesij/2.0d0*lipscale**2*sss1
c      gelc_long(3,i)=gelc_long(3,i)+
c        ssgradlipi*eesij/2.0d0*lipscale**2*sss1
c
c 3/1/22 AL: Long-range vdw contributions to gradient.
c
      if (sss.lt.1.0d0) then

        facvdw_save=(facvdw_save+
     &  (-sss1*sssgrad/rpp(iteli,itelj)+(1.0d0-sss)*sssgrad1)*rmij*
     &  evdwij)*faclipij2
        ggg(1)=facvdw_save*xyzj(1)
        ggg(2)=facvdw_save*xyzj(2)
        ggg(3)=facvdw_save*xyzj(3)
c 9/28/08 AL Gradient compotents will be summed only at the end
        do k=1,3
          gvdwpp_save(k,j)=gvdwpp_save(k,j)+ggg(k)
          gvdwpp_save(k,i)=gvdwpp_save(k,i)-ggg(k)
        enddo
!C Lipidic part for scaling weight
        gvdwpp_save(3,j)=gvdwpp_save(3,j)+
     &    sss1*(1.0d0-sss)*ssgradlipj*evdwij/2.0d0*lipscale**2
        gvdwpp_save(3,i)=gvdwpp_save(3,i)+
     &    sss1*(1.0d0-sss)*ssgradlipi*evdwij/2.0d0*lipscale**2

      endif
      if (sss.gt.0.0d0) then

c short-range contributons
        facvdw=(facvdw+
     &  (sss1*sssgrad/rpp(iteli,itelj)+sss*sssgrad1)*rmij*evdwij)
     &   *faclipij2
        ggg(1)=facvdw*xyzj(1)
        ggg(2)=facvdw*xyzj(2)
        ggg(3)=facvdw*xyzj(3)
c 9/28/08 AL Gradient components will be summed only at the end
        do k=1,3
          gvdwpp(k,j)=gvdwpp(k,j)+ggg(k)
          gvdwpp(k,i)=gvdwpp(k,i)-ggg(k)
        enddo
!C Lipidic part for scaling weight
        gvdwpp(3,j)=gvdwpp(3,j)+
     &    sss1*sss*ssgradlipj*evdwij/2.0d0*lipscale**2
        gvdwpp(3,i)=gvdwpp(3,i)+
     &    sss1*sss*ssgradlipi*evdwij/2.0d0*lipscale**2

      endif
*
* Angular part
*          
      ecosa=2.0D0*fac3*fac1+fac4
      fac4=-3.0D0*fac4
      fac3=-6.0D0*fac3
      ecosb=(fac3*(fac1*cosg+cosb)+cosg*fac4)
      ecosg=(fac3*(fac1*cosb+cosg)+cosb*fac4)
      do k=1,3
        dcosb(k)=rmij*(dc_norm(k,i)-erij(k)*cosb)
        dcosg(k)=rmij*(dc_norm(k,j)-erij(k)*cosg)
      enddo
      do k=1,3
        ggg(k)=(ecosb*dcosb(k)+ecosg*dcosg(k))*sss1
     &  *faclipij2
#ifdef SHIELD
     &      *fac_shield(i)**2*fac_shield(j)**2
#endif
c     &  *((sslipi+sslipj)/2.0d0*lipscale**2+1.0d0)

      enddo
      do k=1,3
        gelc_save(k,i)=gelc_save(k,i)
     &           +((ecosa*(dc_norm(k,j)-cosa*dc_norm(k,i))
     &           +ecosb*(erij(k)-cosb*dc_norm(k,i)))*vbld_inv(i+1))*sss1
     &       *faclipij2
#ifdef SHIELD
     &      *fac_shield(i)**2*fac_shield(j)**2
#endif
c     &       *((sslipi+sslipj)/2.0d0*lipscale**2+1.0d0)

        gelc_save(k,j)=gelc_save(k,j)
     &           +((ecosa*(dc_norm(k,i)-cosa*dc_norm(k,j))
     &           +ecosg*(erij(k)-cosg*dc_norm(k,j)))*vbld_inv(j+1))*sss1
     &       *faclipij2
#ifdef SHIELD
     &      *fac_shield(i)**2*fac_shield(j)**2
#endif
c     &       *((sslipi+sslipj)/2.0d0*lipscale**2+1.0d0)
        gelc_long_save(k,j)=gelc_long_save(k,j)+ggg(k)
        gelc_long_save(k,i)=gelc_long_save(k,i)-ggg(k)
      enddo
      IF (wel_loc.gt.0.0d0 .or. wturn3.gt.0.0d0 .and. j.eq.i+2
     &    .or. wturn4.gt.0.0d0 .and. j.eq.i+3) THEN
C
C 9/25/99 Mixed third-order local-electrostatic terms. The local-interaction 
C   energy of a peptide unit is assumed in the form of a second-order 
C   Fourier series in the angles lambda1 and lambda2 (see Nishikawa et al.
C   Macromolecules, 1974, 7, 797-806 for definition). This correlation terms
C   are computed for EVERY pair of non-contiguous peptide groups.
C
c 12/21/21 AL Formulas for derivatives changed to reduce the number of
C   operations and to eliminate explicit angles. This source code is now
C   good only for scale-consistent variant of UNRES. For previous
C   verions of UNRES use old source code.
        j1=j+1
        j2=j-1
        fac=dsqrt(-ael6i)*r3ij
        IF (wel_loc.gt.0.0d0) THEN
          muimuj=scalar(mu(1,i),mu(1,j))
          muier=scalar(mu(1,i),erij(1))
          mujer=scalar(mu(1,j),erij(1))
C Contribution to the local-electrostatic energy coming from the i-j
C pair
          eel_loc_ij=fac*(muimuj-3*muier*mujer)
#ifdef DEBUG
          write (iout,*) "ij",i,j," eel_loc_ij",eel_loc_ij,
     &     " wel_loc",wel_loc
#endif
#ifdef SHIELD
          if (shield_mode.eq.0) then 
            fac_shield(i)=1.0
            fac_shield(j)=1.0
            fsi=1.0
            fsj=1.0
            fsij=1.0
C          else
C            fac_shield(i)=0.4
C            fac_shield(j)=0.6
          endif
#endif
          eel_loc_ij=eel_loc_ij
     &    *sss1*faclipij
c AL 9/22/2022 eel_loc_ij_1 introduced for better numerical stability
          eel_loc_ij_1=eel_loc_ij
     &    *faclipij
#ifdef SHIELD
     &    *fsij
#endif
c          if (energy_dec) write (iout,'(a6,2i5,0pf7.3)')
c     &            'eelloc',i,j,eel_loc_ij
C Now derivative over eel_loc
#ifdef SHIELD
          if ((fsi.gt.0).and.(fsj.gt.0).and.(shield_mode.gt.0)) then
C          print *,i,j     
            do ilist=1,ishield_list(i)
              iresshield=shield_list(ilist,i)
              do k=1,3
                rlocshield=grad_shield_side(k,ilist,i)*eel_loc_ij
     &                                          /fsi
C     &      *2.0
                gshieldx_ll(k,iresshield)=gshieldx_ll(k,iresshield)+
     &              rlocshield
     &             +grad_shield_loc(k,ilist,i)*eel_loc_ij/fsi
                gshieldc_ll(k,iresshield-1)=gshieldc_ll(k,iresshield-1)
     &           +rlocshield
              enddo
            enddo
            do ilist=1,ishield_list(j)
              iresshield=shield_list(ilist,j)
              do k=1,3
                rlocshield=grad_shield_side(k,ilist,j)*eel_loc_ij
     &                                       /fsj
C     &     *2.0
                gshieldx_ll(k,iresshield)=gshieldx_ll(k,iresshield)+
     &              rlocshield
     &             +grad_shield_loc(k,ilist,j)*eel_loc_ij/fsj
                gshieldc_ll(k,iresshield-1)=gshieldc_ll(k,iresshield-1)
     &             +rlocshield

              enddo
            enddo

            do k=1,3
              gshieldc_ll(k,i)=gshieldc_ll(k,i)+
     &              grad_shield(k,i)*eel_loc_ij/fsi
              gshieldc_ll(k,j)=gshieldc_ll(k,j)+
     &              grad_shield(k,j)*eel_loc_ij/fsj
              gshieldc_ll(k,i-1)=gshieldc_ll(k,i-1)+
     &              grad_shield(k,i)*eel_loc_ij/fsi
              gshieldc_ll(k,j-1)=gshieldc_ll(k,j-1)+
     &              grad_shield(k,j)*eel_loc_ij/fsj
            enddo
          endif !if(shield_mode.gt.0)
#endif

c          write (iout,*) 'i',i,' j',j,itype(i),itype(j),
c     &                     ' eel_loc_ij',eel_loc_ij
C          write(iout,*) 'muije=',i,j,muij(1),muij(2),muij(3),muij(4)
C Calculate patrial derivative for theta angle
          auxvec=fac*(mu(:,j)-3*mujer*erij)
     &         *sss1*faclipij
#ifdef SHIELD
     &         *fsij
#endif
c          write(iout,*) "auxvec j",auxvec
          do k=1,3
            do l=1,3
              gel_loc_save(l,i+k-2)=gel_loc_save(l,i+k-2)+
     &         scalar(muder(1,l,k,i),auxvec)
            enddo
          enddo
          auxvec=fac*(mu(:,i)-3*muier*erij)
     &         *sss1*faclipij
#ifdef SHIELD
     &         *fsij
#endif
c          write(iout,*) "auxvec j",auxvec
          do k=1,3
            do l=1,3
c              write (iout,*) "j",j," k",k," l",l
c              write (iout,*) "muder",muder(:,l,k,j)
c              write (iout,*) "auxvec",auxvec
c              write (iout,*) "g",scalar(muder(1,l,k,j),auxvec)
              gel_loc_save(l,j+k-2)=gel_loc_save(l,j+k-2)+
     &         scalar(muder(1,l,k,j),auxvec)
            enddo
          enddo
cd          write (iout,*) 'i',i,' j',j,' eel_loc_ij',eel_loc_ij

          if (energy_dec) write (iout,'(a6,2i5,0pf7.3)')
     &            'eelloc',i,j,eel_loc_ij
          eel_loc_save=eel_loc_save+eel_loc_ij
C------------------------------------to
C Derivatives of eelloc3 in peptide-group coordinates
c AL 9/22/2022 changed for better numerical stability
c          aux=eel_loc_ij/sss1*sssgrad1*rmij
          aux=eel_loc_ij_1*sssgrad1*rmij
          call scalevec(xyzj,aux,ggg)
          ggg=ggg-3*rmij*(eel_loc_ij*erij
     &       +fac*sss1*(muier*mu(:,j)+mujer*mu(:,i)-2*muier*mujer*erij))
     &       *faclipij
#ifdef SHIELD
     &       *fsij
#endif
c          write (iout,*) "ggg",ggg
          call offsetvecs(gel_loc_long_save(:,j),gel_loc_long_save(:,i),
     &         ggg)
          gel_loc_long_save(3,j)=gel_loc_long_save(3,j)+
     &      ssgradlipj*eel_loc_ij/2.0d0*lipscale/faclipij

          gel_loc_long_save(3,i)=gel_loc_long_save(3,i)+
     &      ssgradlipi*eel_loc_ij/2.0d0*lipscale/faclipij

        ENDIF !IF (wel_loc.gt.0.0d0)
C Calculate the quantites needed for eello3/eello4
c        if (tail_agg) then
c          call calculate_aggij(i,j,fac,rrmij,rmij,xyzj,erij)
c        endif
      ENDIF
c          t_eelecij=t_eelecij+MPI_Wtime()-time00
      return
      end
