      subroutine edis(ehpb)
C 
C Evaluate bridge-strain energy and its gradient in virtual-bond and SC vectors.
C
c      implicit real*8 (a-h,o-z)
      implicit none
#ifdef MPI
      include 'mpif.h'
#endif
      include 'DIMENSIONS'
      include 'COMMON.SETUP'
      include 'COMMON.VECTORS'
      include 'COMMON.SBRIDGE'
      include 'COMMON.NMR'
      include 'COMMON.CHAIN'
      include 'COMMON.DERIV'
      include 'COMMON.VAR'
      include 'COMMON.INTERACT'
      include 'COMMON.IOUNITS'
      include 'COMMON.CONTROL'
      include 'COMMON.TIME1'
      include 'COMMON.MD'
      include 'COMMON.NAMES'
      include 'COMMON.AVNLOC'
      include 'COMMON.RESTARTED'
      double precision ehpb
      double precision ggg(3),ggg_peak(3,1000)
      double precision rvec(3)
      double precision ddtab(200)
      integer isortkey(200)
      double precision add_border,slopefac
      integer i,j,k,l,ii,iii,jj,jjj,iti,itj,ip,iip
      integer icount,iatom
      double precision dd,ehpbi,ehpb_peak,eij,expdis,xdis,rdis,aux,waga,
     & fac,ecoor
      double precision tcpu,dist,gnmr1,gnmr1prim,rlornmr1,rlornmr1prim,
     & rlornmr2,rlornmr2prim,gamber,gamberprim
      double precision time00,time01
      double precision dnow
      double precision denom,dravdr,dravdr_max
      integer INCFLG
      double precision r0HH /2.0d0/
      double precision epsHH /0.01d0/
      double precision ehpbprim
      double precision scaltau,scal_force_temp
      icount=0
#ifdef TIMING_ENE
#ifdef MPI
      time00=MPI_Wtime()
#else
      time00=tcpu()
#endif
#endif
      ehpb=0.0D0
      do i=1,3
       ggg(i)=0.0d0
      enddo
c 8/21/18 AL: added explicit restraints on reference coords
c      write (iout,*) "restr_on_coord",restr_on_coord
      if (restr_on_coord) then

      do i=nnt,nct
        ecoor=0.0d0
        if (itype(i).eq.ntyp1) cycle
        do j=1,3
          ecoor=ecoor+(c(j,i)-cref(j,i))**2
          ghpbc(j,i)=ghpbc(j,i)+bfac(i)*(c(j,i)-cref(j,i))
        enddo
        if (itype(i).ne.10) then
          do j=1,3
            ecoor=ecoor+(c(j,i+nres)-cref(j,i+nres))**2
            ghpbx(j,i)=ghpbx(j,i)+bfac(i)*(c(j,i+nres)-cref(j,i+nres))
          enddo
        endif
        if (energy_dec) write (iout,*) 
     &     "i",i," bfac",bfac(i)," ecoor",ecoor
        ehpb=ehpb+0.5d0*bfac(i)*ecoor
      enddo

      endif
C      write (iout,*) ,"link_end",link_end,constr_dist
cd      write(iout,*)'edis: nhpb=',nhpb,' fbr=',fbr
c      write(iout,*)'link_start=',link_start,' link_end=',link_end,
c     &  " constr_dist",constr_dist," link_start_peak",link_start_peak,
c     &  " link_end_peak",link_end_peak

c------------------------------------------------------------------
c EL      for NMR restraints
c      write (iout,*) "itype1",nnt,nct
      if (link_end.eq.0.and.link_end_peak.eq.0) return
      if (constr_dist.eq.12) then
c Calculate positions of all protons for all residues
#ifdef TIMING_ENE
#ifdef MPI
        time01=MPI_Wtime()
#else
        time01=tcpu()
#endif
#endif
        call nmr_hpos(.false.)
#ifdef TIMING_ENE
#ifdef MPI
        time_nmr_hpos=time_nmr_hpos+MPI_Wtime()-time01
#else
        time_nmr_hpos=time_nmr_hpos+tcpu()-time01
#endif
#endif
      endif
c      write (iout,*) "itype2",nnt,nct
      add_border=dexp(-scal_peak)
      INCFLG=1
c      write (iout,*) "atimeave",atimeave
      if (atimeave.gt.0) then
        call force_scale(1)
#ifdef DEBUG
        write (iout,*) "nsteps",nsteps(1),"tau_temp",tau_temp(1),
     &  " scaling",scal_force(1)
#endif
      endif
      dravdr_max=0.0d0
      do i=link_start_peak,link_end_peak
        ehpb_peak=0.0d0
#ifdef DEBUG
        write(iout,*)"i",i," link_end_peak",link_end_peak," ipeak",
     &   ipeak(1,i),ipeak(2,i)," restarted ",restarted
#endif
        if (ipeak(1,i).eq.ipeak(2,i)) then
c Non-ambiguous peak
          ip = ipeak(1,i)
          ii=ihpb_peak(1,ip)
          jj=jhpb_peak(1,ip)
          iti=ihpb_peak(2,ip)
          itj=jhpb_peak(2,ip)
          call hdist(ii,iti,jj,itj,dd,ggg(1))
c
c Prevent protons from clashing add LJ potential to ehpb 25/10/2023
c
c           ehpb=ehpb+epsHH*((r0HH/dd)**12-2*(r0HH/dd)**6)
c           ehpb=ehpb+epsHH*(r0HH/dd)**12
c Calculate derivative of LJ potential      
c           ehpbprim=-12*epsHH*((r0HH/dd)**12-(r0HH/dd)**6)/dd**2
c           ehpbprim=-12*epsHH*(r0HH/dd)**12/dd**2
c          ehpbprim=0.0d0
c--------------Print out pdb file if dd smaller than 1
          if (dd.lt.1.0d0 ) then
            write (iout,*) 
     &        "nsteps(1)",nsteps(1)," ii",ii," jj",jj," dd",dd
#ifdef PrintPDB
            call pdbout(0.0d0,'BAD COORDS NMR',iout)
            write(iout,'(a)') "REMARK reconstructed proton positions"
            iatom=0
            do k=nnt+1,nct
              iatom=iatom+1
              write (iout,'(4hATOM,i7,2x,a3,1x,a3,2x,i4,4x,3f8.3)')
     &              iatom,"CA",restyp(itype(k)),k-nnt+1,(c(j,k),j=1,3)
              iatom=iatom+1
              write (iout,'(4hATOM,i7,2x,a3,1x,a3,2x,i4,4x,3f8.3)')
     &          iatom,"H",restyp(itype(k)),k-nnt+1,(hpos(j,k-1,0),j=1,3)
              iatom=iatom+1
              write (iout,'(4hATOM,i7,2x,a3,1x,a3,2x,i4,4x,3f8.3)')
     &          iatom,"HA",restyp(itype(k)),k-nnt+1,(hpos(j,k,1),j=1,3)
              iatom=iatom+1
              write (iout,'(4hATOM,i7,2x,a3,1x,a3,2x,i4,4x,3f8.3)')
     &          iatom,"HB",restyp(itype(k)),k-nnt+1,(hpos(j,k,2),j=1,3)
            enddo
#endif
          endif 
          if (atimeave.gt.0) then
            dnow=dd
#ifdef DEBUG
c          write (iout,'(a3,i3,2f13.10,2f17.14)'),"before",i,dnow,
c     &    dd,dnmr_xave(1,i), dnmr_xave(2,i)
c          write (iout,'(a3,i3,2f15.5)'),"before",i,dnow,
     
#endif
c
c---------------Call AVEINT subroutine from AMBER---------------------
c          call AVEINT(dnmr_xave(1,ip),dnmr_xave0(ip),dnow,TAU,d_time0,
c     &         NAVINT,3,1,INCFLG,1,dd,DENOM) 
c     &       INCFLG
c          write (iout,*) "nsteps",nsteps," TAU_temp",TAU_temp
#ifdef TEST
            write (iout,*) "Calling old AVEINT"
            if (restarted) then
c Calculate the averages from restart information
              call AVEINT(dnmr_xave(1,ip),dnmr_xave0(ip),
     &         dnow,TAU,
     &         d_time0,NAVINT,3,1,INCFLG,2,dd,DENOM) 
            else
c Update the averages
              call AVEINT(dnmr_xave(1,ip),dnmr_xave0(ip),
     &         dnow,TAU,
     &         d_time0,NAVINT,3,1,INCFLG,1,dd,DENOM) 
            endif
#else
            if (restarted) then
c Calculate the averages from restart information
              call AVEINT(dnmr_xave(1,ip),dnmr_xave0(ip),
     &         dnmr_xaveave(ip),dnow,TAU,
c     &         d_time0,NAVINT,3,1,INCFLG,1,dd,DENOM) 
     &         d_time0,NAVINT,3,1,INCFLG,2,dd,DENOM) 
            else
c Update the averages
              call AVEINT(dnmr_xave(1,ip),dnmr_xave0(ip),
     &         dnmr_xaveave(ip),dnow,TAU,
     &         d_time0,NAVINT,3,1,INCFLG,1,dd,DENOM) 
            endif
#endif
c--------------Calcualte derivative factors of time-ave--------------
c----------F=∂E/∂x=(∂E/∂r̄)(∂r̄/∂r(t))(∂r(t)/∂x)
            if (icalls(1).le.navint) then
              DRAVDR=1.0d0
            else if (ider_ave(1).eq.1) then
              DRAVDR=0.5d0
            else 
              DRAVDR=0.5d0*(dd/dnow)**4*NAVINT*d_time0/DENOM
              if (.not.nonscal_ave_grad) then
c
c Scaling factor of the forces
c
                dravdr = dravdr*scal_force(1)
                if (dravdr.gt.dravdr_max) dravdr_max=dravdr
              endif
            endif
c
            INCFLG=0
#ifdef DEBUG
            write (iout,*) "icalls",icalls," ntwe",ntwe
            if (mod(icalls(1),ntwe).eq.0) then
              write (iout,'(a3,2i10,i5,2f10.5,3f17.14,e20.10,f10.5)')
     &        "co",icalls(1),nsteps(1),ip,dnow,
     &        dd,dnmr_xave(1,ip),dnmr_xave(2,ip),dnmr_xave0(ip),
     &        dnmr_xaveave(ip),DENOM 
              write (iout,'(i5,3(1x,a,f10.5))') i,"dd/dnow",dd/dnow,
     &       "d_time0/DENOM",d_time0/DENOM,"dravdr",dravdr
            endif
c          if (mod(nsteps(1),ntwe).eq.0) then
c          write (iout,'(a3,i3,2f13.10,3f17.14)'),"co",i,dnow,
c     &    dd,dnmr_xave(1,i), dnmr_xave(2,i), DENOM 
c           write (iout,'(a3,1x,i8,1x,3(i2,1x),6(f10.6,1x),1x,i5)'),
c     &      "nmr",nsteps(1),i,ii,jj,
c     &      dnow,dd,dhpb_peak(ip),dhpb1_peak(ip),DENOM,DRAVDR,NAVINT
c          endif
#endif
c          elseif (atimeave.eq.0) then
           
c           write (iout,'(a3,1x,3(i2,1x),3(f10.6,1x))'),
c     &      "nmr",i,ii,jj,
c     &      dd,dhpb_peak(ip),dhpb1_peak(ip)
            
          endif
c---DRAVDR=((dd/dnow)*(1+IPOWER))*d_time0/DENOM---IPOWER=3 for NOE distance
#define NOWAFUNKCJA
c#define NOWYLORENZ
c#define AMBER
#if defined(STARAFUNKCJA)
          if (slope_peak.eq.0.0d0) then
           aux=rlornmr1(dd,dhpb_peak(ip),dhpb1_peak(ip),forcon_peak(ip))
          else
           aux=rlornmr2(dd,dhpb_peak(ip),dhpb1_peak(ip),forcon_peak(ip),
     &      slope_peak)
          endif
          if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
c          write (*,'(a,i2,1x,a6,5i5,6f15.6)') "Proecessor",fg_rank,
c     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
c     &      forcon_peak(ip),fordepth_peak(ip),aux
          if (slope_peak.eq.0.0d0) then
            fac=rlornmr1prim(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &        forcon_peak(ip))
          else
            fac=rlornmr2prim(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &        forcon_peak(ip),slope_peak)
          endif
#elif defined (NOWAFUNKCJA)
          if (slope_peak.eq.0.0d0) then
            call sub_rlornmr1(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &       forcon_peak(ip),aux,fac)
          else
            call sub_rlornmr3(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &        forcon_peak(ip),slope_peak,aux,fac)
          endif
          if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
#elif defined (NOWYLORENZ)
          if (slope_peak.eq.0.0d0) then
            call sub_rlor2nmr1(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &       forcon_peak(ip),aux,fac)
          else
            call sub_rlor2nmr3(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &        forcon_peak(ip),slope_peak,aux,fac)
          endif
          if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
#elif defined (AMBER)
          aux=gamber(dd,dhpb2_peak(ip),dhpb_peak(ip),dhpb1_peak(ip),
     &        dhpb3_peak(ip),
     &        forcon_peak(ip),fordepth_peak(ip))
          fac=gamberprim(dd,dhpb2_peak(ip),dhpb_peak(ip),dhpb1_peak(ip),
     &        dhpb3_peak(ip),
     &        forcon_peak(ip),fordepth_peak(ip))
#ifdef DEBUG
          write(iout,'(a4,i3,1x,9(a7,f12.4,1x))') "ip",ip," dd",dd,
     &        " d1",dhpb2_peak(ip),
     &        " d2",dhpb_peak(ip)," d3",dhpb1_peak(ip),
     &        " d4",dhpb3_peak(ip)," k2",forcon_peak(ip),
     &        " k3",fordepth_peak(ip)," penalty",aux," grad",fac
#endif
#else
          if (slope_peak.eq.0.0d0) then
            call gcont(dd,dhpb1_peak(ip)+0.5d0*forcon_peak(ip),
     &       -1.0d0,forcon_peak(ip),aux,fac)
            aux=aux+1.0d0
          else
            call gcont(dd,dhpb1_peak(ip)+0.5d0*forcon_peak(ip),
     &       -1.0d0,forcon_peak(ip),aux,fac)
            aux=aux+1.0d0
            if (aux.eq.0.0d0) then
              fac=0.0d0
            else 
              slopefac=1.0d0+slope_peak*(dd-dhpb1_peak(ip))
              fac=fac*slopefac+aux*slope_peak
              aux=aux*slopefac
            endif
          endif
          if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
#endif
#ifdef AMBER
#ifdef SCALE_ERESTR
          if (atimeave.gt.0) then
            ehpb=ehpb+aux*scal_force(1)
          else
            ehpb=ehpb+aux
          endif
#else
          ehpb=ehpb+aux
#endif
          if (atimeave.gt.0) then
            fac=fac/dnow*DRAVDR
          else
            fac=fac/dd
          endif
#else
#ifdef SCALE_ERESTR
          if (atimeave.gt.0) then
            ehpb=ehpb+fordepth_peak(ipeak(1,i))*aux
     &      *scal_force(1)
          else
            ehpb=ehpb+fordepth_peak(ipeak(1,i))*aux
          endif
#else
          ehpb=ehpb+fordepth_peak(ipeak(1,i))*aux
#endif
          if (atimeave.gt.0) then
c            fac=fordepth_peak(ipeak(1,i))*fac/dnow*DRAVDR
            fac=fordepth_peak(ipeak(1,i))*fac*DRAVDR
          else
c            fac=fordepth_peak(ipeak(1,i))*fac/dd
            fac=fordepth_peak(ipeak(1,i))*fac
          endif
#endif
c--------------------time-averaged modifed for fac---------------------
c          if(atimeave.gt.0) fac=fordepth_peak(ipeak(1,i))*fac/dd
c          should modified above line (190) or not?
c          write (iout,*) "fac",fac," DRAVDR",DRAVDR
c-------------adding gradient for LJ potential------Adam-Co25/10/2023--
c          fac = fac + ehpbprim
c---------------------------------------------------------------------
          do j=1,3
            ggg(j)=fac*ggg(j)
          enddo
          if (iti.gt.2) then
            do j=1,3
              ghpbx(j,ii)=ghpbx(j,ii)-ggg(j)*protpos(iti,itype(ii))
            enddo
          endif
          if (itj.gt.2) then
            do j=1,3
              ghpbx(j,jj)=ghpbx(j,jj)+ggg(j)*protpos(itj,itype(jj))
            enddo
          endif
          do k=1,3
            ghpbc(k,jj)=ghpbc(k,jj)+ggg(k)
            ghpbc(k,ii)=ghpbc(k,ii)-ggg(k)
          enddo
          if (iti.le.2) then
            do k=1,3
              do l=1,3
                ghpbdc(k,ii-1)=ghpbdc(k,ii-1)-dhpos_dc(l,k,1,ii,iti)
     &               *ggg(l)
                ghpbdc(k,ii)=ghpbdc(k,ii)-dhpos_dc(l,k,2,ii,iti)*ggg(l)
                ghpbdc(k,ii+1)=ghpbdc(k,ii+1)-dhpos_dc(l,k,3,ii,iti)
     &               *ggg(l)
              enddo
            enddo
          endif
          if (itj.le.2) then
            do k=1,3
              do l=1,3
                ghpbdc(k,jj-1)=ghpbdc(k,jj-1)+dhpos_dc(l,k,1,jj,itj)
     &                *ggg(l)
                ghpbdc(k,jj)=ghpbdc(k,jj)+dhpos_dc(l,k,2,jj,itj)*ggg(l)
                ghpbdc(k,jj+1)=ghpbdc(k,jj+1)+dhpos_dc(l,k,3,jj,itj)
     &                *ggg(l)
              enddo
            enddo
          endif
          if (iti.eq.0) then
            do k=1,3
              ghpbdphi(ii-1)=ghpbdphi(ii-1)-
     &          dhpos_gamma(k,ii,iti)*ggg(k)
            enddo
          endif
          if (itj.eq.0) then
            do k=1,3
              ghpbdphi(jj-1)=ghpbdphi(jj-1)+
     &          dhpos_gamma(k,jj,itj)*ggg(k)
            enddo
          endif
        else
c Ambiguous peak
c#ifdef SORT
C calculate & sort distances
c        do ip=ipeak(1,i),ipeak(2,i)
c          ii=ihpb_peak(1,ip)
c          jj=jhpb_peak(1,ip)
c          iti=ihpb_peak(2,ip)
c          itj=jhpb_peak(2,ip)
c          iip=ip-ipeak(1,i)+1
c          call hdist(ii,iti,jj,itj,ddtab(iip),ggg_peak(1,iip))
c        enddo
c        nnpeak=ipeak(2,i)-ipeak(1,i)+1
c        call sort2(nnpeak,ddtab,isortkey)
c        if (ddtab(1).gt.7.0d0) then
c#endif
        do ip=ipeak(1,i),ipeak(2,i)
c          icount=icount+1
          ii=ihpb_peak(1,ip)
          jj=jhpb_peak(1,ip)
          iti=ihpb_peak(2,ip)
          itj=jhpb_peak(2,ip)
c          write (iout,*) "i",i," ip",ip," ii",ii," jj",jj," iti",iti,
c     &     " itj",itj
c          dd=dist(ii,jj)
c          write (iout,*) "dd",dd
          iip=ip-ipeak(1,i)+1
c          print *,"Processor",fg_rank," dc",ii,dc(:,ii-1),dc(:,ii),
c     &      dc(:,ii+1)
c          write(*,*) dc_norm(:,ii-1),uy(:,ii),uz(:,ii+1)
c          write(*,*) dc_norm(:,jj-1),uy(:,jj),uz(:,jj+1)
c          write(*,*) "phi",ii,phi(ii+2)
c          write(*,*) "phi",jj,phi(jj+2)
c          write(*,*) "costtab",ii,costtab(ii+1),costtab(ii+2)
c          write(*,*) "costtab",jj,costtab(jj+1),costtab(jj+2)
c          print *,"Processor",fg_rank," dc",jj,dc(:,jj-1),dc(:,jj),
c     &      dc(:,jj+1)
          call hdist(ii,iti,jj,itj,dd,ggg_peak(1,iip))
c          do j=1,3
c            rvec(j)=hpos(j,jj,itj)-hpos(j,ii,iti)
c          enddo
c          dd=dsqrt(rvec(1)*rvec(1)+rvec(2)*rvec(2)+rvec(3)*rvec(3))
c          ggg_peak(:,iip)=rvec
          if (atimeave.gt.0) then
            dnow=dd
#ifdef DEBUG
            write (iout,'(a3,i3,2f14.10,2f17.14)'),"before",i,dnow,
     &      dd,dnmr_xave(1,ip), dnmr_xave(2,ip)
#endif
            if (restarted) then
c Calculate the averages from restart informaton
              call AVEINT(dnmr_xave(1,ip),dnmr_xave0(ip),
     &         dnmr_xaveave(ip),dnow,TAU,
     &         d_time0,NAVINT,3,1,INCFLG,2,dd,DENOM) 
            else
c Update the averages
              call AVEINT(dnmr_xave(1,ip),dnmr_xave0(ip),
     &         dnmr_xaveave(ip),dnow,TAU,
     &         d_time0,NAVINT,3,1,INCFLG,1,dd,DENOM)
            endif
#ifdef DEBUG
            write (iout,'(a3,i3,2f14.10,2f17.14)'),"after",i,dnow,
     &      dd,dnmr_xave(1,ip), dnmr_xave(2,ip)
#endif
            if (icalls(1).lt.navint) then
              DRAVDR=1.0d0
            else if (ider_ave(1).eq.1) then
              DRAVDR=0.5d0
            else 
              DRAVDR=0.5d0*(dd/dnow)**4*NAVINT*d_time0/DENOM
              if (.not.nonscal_ave_grad) then
c
c Scaling factor of the forces
c
                dravdr = dravdr*scal_force(1)
                if (dravdr.gt.dravdr_max) dravdr_max=dravdr
              endif
            endif
c          DRAVDR=0.5d0*(dd/dnow)**4*d_time0/DENOM
            INCFLG=0
          endif
#define NOWAFUNKCJA
#if defined(STARAFUNKCJA)
          if (slope_peak.eq.0.0d0) then
           aux=rlornmr1(dd,dhpb_peak(ip),dhpb1_peak(ip),forcon_peak(ip))
          else
           aux=rlornmr2(dd,dhpb_peak(ip),dhpb1_peak(ip),forcon_peak(ip),
     &      slope_peak)
          endif
          if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
c          write (*,'(a,i2,1x,a6,5i5,6f15.6)') "Proecessor",fg_rank,
c     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
c     &      forcon_peak(ip),fordepth_peak(ip),aux
          aux=dexp(-scal_peak*aux)
          ehpb_peak=ehpb_peak+aux
          if (slope_peak.eq.0.0d0) then
            fac=rlornmr1prim(dd,dhpb_peak(ip),dhpb1_peak(ip),
c     &        forcon_peak(ip))*aux/dd
     &        forcon_peak(ip))*aux
          else
            fac=rlornmr2prim(dd,dhpb_peak(ip),dhpb1_peak(ip),
c     &        forcon_peak(ip),slope_peak)*aux/dd
     &        forcon_peak(ip),slope_peak)*aux
          endif
#elif defined (NOWAFUNKCJA)
          if (slope_peak.eq.0.0d0) then
            call sub_rlornmr1(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &       forcon_peak(ip),aux,fac)
          else
            call sub_rlornmr3(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &        forcon_peak(ip),slope_peak,aux,fac)
          endif
          if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
          aux=dexp(-scal_peak*aux)
          if (aux.eq.0.0d0) then
            aux=add_border
            fac=0.0d0
          else
            if (atimeave.gt.0) then
c              fac=fac*aux/dnow*DRAVDR
              fac=fac*aux*DRAVDR
            else
c              fac=fac*aux/dd
              fac=fac*aux
            endif
            ehpb_peak=ehpb_peak+aux
          endif
#elif defined (NOWYLORENZ)
          if (slope_peak.eq.0.0d0) then
            call sub_rlor2nmr1(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &       forcon_peak(ip),aux,fac)
          else
            call sub_rlor2nmr3(dd,dhpb_peak(ip),dhpb1_peak(ip),
     &        forcon_peak(ip),slope_peak,aux,fac)
          endif
          if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
          aux=dexp(-scal_peak*aux)
          if (aux.eq.0.0d0) then
            aux=add_border
            fac=0.0d0
          else
            if (atimeave.gt.0) then
c              fac=fac*aux/dnow*DRAVDR
              fac=fac*aux*DRAVDR
            else
c              fac=fac*aux/dd
              fac=fac*aux
            endif
            ehpb_peak=ehpb_peak+aux
          endif
#elif defined (AMBER)
          aux=gamber(dd,dhpb2_peak(ip),dhpb_peak(ip),dhpb1_peak(ip),
     &        dhpb3_peak(ip),
     &        forcon_peak(ip),fordepth_peak(ip))
          aux=dexp(-scal_peak*aux)
          ehpb_peak=ehpb_peak+aux
          fac=gamberprim(dd,dhpb2_peak(ip),dhpb_peak(ip),dhpb1_peak(ip),
     &        dhpb3_peak(ip),forcon_peak(ip),fordepth_peak(ip))
          if (atimeave.gt.0) then
c            fac=fac*aux/dnow*DRAVDR
            fac=fac*aux*DRAVDR
          else
c            fac=fac*aux/dd
            fac=fac*aux
          endif
#else
          if (slope_peak.eq.0.0d0) then
            call gcont(dd,dhpb1_peak(ip)+0.5d0*forcon_peak(ip),
     &       -1.0d0,forcon_peak(ip),aux,fac)
            aux=aux+1.0d0
            if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
            if (aux.eq.1.0d0) then
              aux=add_border
              fac=0.0d0
            else if (aux.eq.0.0d0) then
              aux=1.0d0
              fac=0.0d0
            else 
              aux=dexp(-scal_peak*aux)
              if (atimeave.gt.0) then
c                fac=fac*aux/dnow*DRAVDR
                fac=fac*aux*DRAVDR
              else
c                fac=fac*aux/dd
                fac=fac*dd
              endif
            endif
          else
            call gcont(dd,dhpb1_peak(ip)+0.5d0*forcon_peak(ip),
     &       -1.0d0,forcon_peak(ip),aux,fac)
            aux=aux+1.0d0
            if (energy_dec) write (iout,'(a6,5i5,6f10.3)')
     &      "edisL",i,ii,iti,jj,itj,dd,dhpb_peak(ip),dhpb1_peak(ip),
     &      forcon_peak(ip),fordepth_peak(ip),aux
            if (aux.eq.0.0d0) then
              aux=1.0d0
              fac=0.0d0
            else 
              slopefac=1.0d0+slope_peak*(dd-dhpb1_peak(ip))
              fac=fac*slopefac+aux*slope_peak
              aux=dexp(-scal_peak*aux*slopefac)
              if (atimeave.gt.0) then
!                fac=fac*aux/dnow*DRAVDR
                fac=fac*aux*DRAVDR
              else
!                fac=fac*aux/dd
                fac=fac*aux
              endif
          endif
            endif
          endif
          ehpb_peak=ehpb_peak+aux
#endif
          do j=1,3
            ggg_peak(j,iip)=fac*ggg_peak(j,iip)
          enddo
        enddo
        if (energy_dec)
     &  write (iout,*) "ehpb_peak",
     & -fordepth_peak(ipeak(1,i))*dlog(ehpb_peak)/scal_peak,
     &  " scal_peak",scal_peak
c        write (*,*) "Processor",fg_rank," ehpb_peak",
c     & -fordepth_peak(ipeak(1,i))*dlog(ehpb_peak)/scal_peak,
c     &  " scal_peak",scal_peak
#ifdef SCALE_ERESTR
        if (atimeave.gt.0) then
          ehpb=ehpb-fordepth_peak(ipeak(1,i))*dlog(ehpb_peak)/scal_peak*
     &      scal_force(1)
        else
          ehpb=ehpb-fordepth_peak(ipeak(1,i))*dlog(ehpb_peak)/scal_peak
        endif
#else
        ehpb=ehpb-fordepth_peak(ipeak(1,i))*dlog(ehpb_peak)/scal_peak
#endif
        fac=fordepth_peak(ipeak(1,i))/ehpb_peak
        do ip=ipeak(1,i),ipeak(2,i)
          iip=ip-ipeak(1,i)+1
          if (ggg_peak(1,iip).eq.0.0d0.and.ggg_peak(2,iip).eq.0.0d0
     &      .and.ggg_peak(3,iip).eq.0.0d0) cycle
          do j=1,3
            ggg(j)=fac*ggg_peak(j,iip)
          enddo
          ii=ihpb_peak(1,ip)
          jj=jhpb_peak(1,ip)
          iti=ihpb_peak(2,ip)
          itj=jhpb_peak(2,ip)
C iii and jjj point to the residues for which the distance is assigned.
c          if (ii.gt.nres) then
c            iii=ii-nres
c            jjj=jj-nres 
c          else
c            iii=ii
c            jjj=jj
c          endif
c Derivatives of NMR restraint contributions in 
          if (iti.gt.2) then
            do j=1,3
              ghpbx(j,ii)=ghpbx(j,ii)-ggg(j)*protpos(iti,itype(ii))
            enddo
          endif
          if (itj.gt.2) then
            do j=1,3
              ghpbx(j,jj)=ghpbx(j,jj)+ggg(j)*protpos(itj,itype(jj))
            enddo
          endif
          do k=1,3
            ghpbc(k,jj)=ghpbc(k,jj)+ggg(k)
            ghpbc(k,ii)=ghpbc(k,ii)-ggg(k)
          enddo
C Derivatives in dC
#ifdef DEBUG
          write (iout,*) "ggg",(ggg(l),l=1,3)
          write (iout,*) "ii",ii," iti",iti
          do l=1,3
            write(iout,'(i5,3f10.5,5x,3f10.5,5x,3f10.3)') l,
     &       (dhpos_dc(l,k,1,ii,iti),k=1,3),
     &       (dhpos_dc(l,k,2,ii,iti),k=1,3)
c     &       (dhpos_dc(l,k,3,i,ntypProt),k=1,3)
          enddo
          write (iout,*) "jj",jj," itj",itj
          do l=1,3
            write(iout,'(i5,3f10.5,5x,3f10.5,5x,3f10.3)') l,
     &       (dhpos_dc(l,k,1,jj,itj),k=1,3),
     &       (dhpos_dc(l,k,2,jj,itj),k=1,3)
c     &       (dhpos_dc(l,k,3,i,ntypProt),k=1,3)
          enddo
#endif
c          write (*,*) "ggg",(ggg(l),l=1,3)
c          write (*,*) "ii",ii," iti",iti
c          do l=1,3
c            write(*,'(i5,3f10.5,5x,3f10.5,5x,3f10.3)') l,
c     &       (dhpos_dc(l,k,1,ii,iti),k=1,3),
c     &       (dhpos_dc(l,k,2,ii,iti),k=1,3)
c          enddo
c          write (*,*) "jj",jj," itj",itj
c          do l=1,3
c            write(*,'(i5,3f10.5,5x,3f10.5,5x,3f10.3)') l,
c     &       (dhpos_dc(l,k,1,jj,itj),k=1,3),
c     &       (dhpos_dc(l,k,2,jj,itj),k=1,3)
c          enddo
          if (iti.le.2) then
            do k=1,3
              do l=1,3 
                ghpbdc(k,ii-1)=ghpbdc(k,ii-1)-dhpos_dc(l,k,1,ii,iti)
     &               *ggg(l)
                ghpbdc(k,ii)=ghpbdc(k,ii)-dhpos_dc(l,k,2,ii,iti)*ggg(l)
                ghpbdc(k,ii+1)=ghpbdc(k,ii+1)-dhpos_dc(l,k,3,ii,iti)
     &               *ggg(l)
              enddo
            enddo
          endif
          if (itj.le.2) then
            do k=1,3
              do l=1,3 
                ghpbdc(k,jj-1)=ghpbdc(k,jj-1)+dhpos_dc(l,k,1,jj,itj)
     &                *ggg(l)
                ghpbdc(k,jj)=ghpbdc(k,jj)+dhpos_dc(l,k,2,jj,itj)*ggg(l)
                ghpbdc(k,jj+1)=ghpbdc(k,jj+1)+dhpos_dc(l,k,3,jj,itj)
     &                *ggg(l)
              enddo
            enddo
          endif
          if (iti.eq.0) then
            do k=1,3
              ghpbdphi(ii-1)=ghpbdphi(ii-1)-
     &          dhpos_gamma(k,ii,iti)*ggg(k)
            enddo
          endif
          if (itj.eq.0) then
            do k=1,3
              ghpbdphi(jj-1)=ghpbdphi(jj-1)+
     &          dhpos_gamma(k,jj,itj)*ggg(k)
            enddo
          endif
        enddo

        endif

      enddo
c      do i=1,nres
c        do j=1,3
c          ghpbc(j,i)=ghpbc(j,i)*0.5d0
c        enddo
c      enddo
c      do i=1,nres
c        do j=1,3
c          ghpbx(j,i)=ghpbx(j,i)*0.5d0
c        enddo
c      enddo
c      do i=0,nres
c        do j=1,3
c          ghpbdc(j,i)=ghpbdc(j,i)*0.5d0
c        enddo
c      enddo
c      do i=1,nres
c        ghpbdphi(i)=ghpbdphi(i)*0.5d0
c      enddo
      if (ider_ave(1).ne.1 .and. dravdr_limit.gt.0.0d0) then
#ifdef DEBUG
      write (iout,*) "dravdr_max=",dravdr_max
#endif
        if (dravdr_max.gt.dravdr_limit) then
          scal_force_temp=dravdr_limit/dravdr_max
#ifdef DEBUG
          write(iout,*)nsteps(1)," Average distance forces re-rescaled",
     &    dravdr_max,dravdr_limit,scal_force_temp
#endif
          ghpbc(:,:nres)=ghpbc(:,:nres)*scal_force_temp
          ghpbx(:,:nres)=ghpbx(:,:nres)*scal_force_temp
          ghpbdc(:,:nres)=ghpbdc(:,:nres)*scal_force_temp
          ghpbdphi(:nres)=ghpbdphi(:nres)*scal_force_temp
        endif
      endif
#ifdef DEBUG
      write (iout,*) "ghpbc, ghpbdc and ghpbdphi arrays"
      do i=1,nres
        write (iout,'(i5,3e15.5,5x,3e15.5,5x,e15.5)') 
     &   i,(ghpbc(j,i),j=1,3),(ghpbdc(j,i),j=1,3),ghpbdphi(i)
      enddo
#endif
c      write (iout,*) "link_start",link_start," link_end",link_end
      do i=link_start,link_end
C If ihpb(i) and jhpb(i) > NRES, this is a SC-SC distance, otherwise a
C CA-CA distance used in regularization of structure.
        ii=ihpb(i)
        jj=jhpb(i)
C iii and jjj point to the residues for which the distance is assigned.
        if (ii.gt.nres) then
          iii=ii-nres
        else
          iii=ii
        endif
        if (jj.gt.nres) then
          jjj=jj-nres 
        else
          jjj=jj
        endif
c        write (iout,*) "i",i," ii",ii," iii",iii," jj",jj," jjj",jjj,
c     &    dhpb(i),dhpb1(i),forcon(i)
C 24/11/03 AL: SS bridges handled separately because of introducing a specific
C    distance and angle dependent SS bond potential.
C        if (ii.gt.nres .and. iabs(itype(iii)).eq.1 .and.
C     & iabs(itype(jjj)).eq.1) then
cmc        if (ii.gt.nres .and. itype(iii).eq.1 .and. itype(jjj).eq.1) then
C 18/07/06 MC: Use the convention that the first nss pairs are SS bonds
        if (.not.dyn_ss .and. i.le.nss) then
C 15/02/13 CC dynamic SSbond - additional check
          if (ii.gt.nres .and. iabs(itype(iii)).eq.1 .and.
     &        iabs(itype(jjj)).eq.1) then
           call ssbond_ene(iii,jjj,eij)
           ehpb=ehpb+eij
         endif
cd          write (iout,*) "eij",eij
cd   &   ' waga=',waga,' fac=',fac
!        else if (ii.gt.nres .and. jj.gt.nres) then
        else
C Calculate the distance between the two points and its difference from the
C target distance.
          dd=dist(c(1,ii),c(1,jj))
          if (irestr_type(i).eq.11) then
            if (slope.eq.0.0d0) then
              ehpbi=fordepth(i)!**4.0d0
     &           *rlornmr1(dd,dhpb(i),dhpb1(i),forcon(i))
              fac=fordepth(i)!**4.0d0
     &           *rlornmr1prim(dd,dhpb(i),dhpb1(i),forcon(i))/dd
            else
              ehpbi=fordepth(i)!**4.0d0
     &           *rlornmr2(dd,dhpb(i),dhpb1(i),forcon(i),slope)
              fac=fordepth(i)!**4.0d0
     &           *rlornmr2prim(dd,dhpb(i),dhpb1(i),forcon(i),slope)/dd
            endif
            ehpb=ehpb+ehpbi
            if (energy_dec) write (iout,'(a6,2i5,6f10.3,i5)')
     &        "edisL",ii,jj,dd,dhpb(i),dhpb1(i),forcon(i),fordepth(i),
     &        ehpbi,irestr_type(i)
          else if (irestr_type(i).eq.10) then
c AL 6//19/2018 cross-link restraints
            xdis = 0.5d0*(dd/forcon(i))**2
            expdis = dexp(-xdis)
c            aux=(dhpb(i)+dhpb1(i)*xdis)*expdis+fordepth(i)
            aux=(dhpb(i)+dhpb1(i)*xdis*xdis)*expdis+fordepth(i)
c            write (iout,*)"HERE: xdis",xdis," expdis",expdis," aux",aux,
c     &          " wboltzd",wboltzd
            ehpb=ehpb-wboltzd*xlscore(i)*dlog(aux)
c            fac=-wboltzd*(dhpb1(i)*(1.0d0-xdis)-dhpb(i))
            fac=-wboltzd*xlscore(i)*(dhpb1(i)*(2.0d0-xdis)*xdis-dhpb(i))
     &           *expdis/(aux*forcon(i)**2)
            if (energy_dec) write(iout,'(a6,2i5,8f15.8,i5)') 
     &        "edisX",ii,jj,dd,dhpb(i),dhpb1(i),forcon(i),fordepth(i),
     &        xlscore(i),wboltzd,-wboltzd*xlscore(i)*dlog(aux),
     &       irestr_type(i)
          else if (irestr_type(i).eq.13) then
c            write (iout,*) "edis:",i,ihpb(i),jhpb(i),irestr_type(i)
            call Xlinkene(ihpb(i),jhpb(i),ibecarb(i),irestr_type(i),eij)
            ehpb=ehpb+eij
          else if (irestr_type(i).eq.2) then
c Quartic restraints
c-------------------21/3/2023---Co implemented amber well potential-----
            ehpbi=forcon(i)*gnmr1(dd,dhpb(i),dhpb1(i))
            fac=forcon(i)*gnmr1prim(dd,dhpb(i),dhpb1(i))/dd
            ehpb=ehpb+ehpbi
            if (energy_dec) write(iout,'(a6,2i5,5f10.3,i5)') 
     &      "edisQ",ii,jj,dd,dhpb(i),dhpb1(i),forcon(i),ehpbi
          else
c Quadratic restraints
            rdis=dd-dhpb(i)
C Get the force constant corresponding to this distance.
            waga=forcon(i)
C Calculate the contribution to energy.
            ehpb=ehpb+0.5d0*waga*rdis*rdis
            if (energy_dec) write(iout,'(a6,2i5,5f10.3,i5)') 
     &      "edisS",ii,jj,dd,dhpb(i),dhpb1(i),forcon(i),
     &       0.5d0*waga*rdis*rdis,irestr_type(i)
C
C Evaluate gradient.
C
            fac=waga*rdis/dd
          endif
c Calculate Cartesian gradient
          do j=1,3
            ggg(j)=fac*(c(j,jj)-c(j,ii))
          enddo
cd      print '(i3,3(1pe14.5))',i,(ggg(j),j=1,3)
C If this is a SC-SC distance, we need to calculate the contributions to the
C Cartesian gradient in the SC vectors (ghpbx).
          if (iii.lt.ii) then
            do j=1,3
              ghpbx(j,iii)=ghpbx(j,iii)-ggg(j)
            enddo
          endif
          if (jjj.lt.jj) then
            do j=1,3
              ghpbx(j,jjj)=ghpbx(j,jjj)+ggg(j)
            enddo
          endif
          do k=1,3
            ghpbc(k,jjj)=ghpbc(k,jjj)+ggg(k)
            ghpbc(k,iii)=ghpbc(k,iii)-ggg(k)
          enddo
        endif
      enddo
c      write (iout,*) "ehpb",ehpb
#ifdef TIMING_ENE
#ifdef MPI
      time_edis=time_edis+MPI_Wtime()-time00
#else 
      time_edis=time_edis+tcpu()-time00
#endif
#endif
c      write(2,*) "icount",icount
      return
      end
c----------------------------------------------------------------------------
      double precision function scaltau(tau,ndiv_tau,idiv_tau)
      integer nstep,ndiv_tau,idiv_tau
      double precision tau
      double precision scal_tau
      if (idiv_tau.gt.ndiv_tau) then
        scal_tau=1.0d0
      else
        scal_tau=idiv_tau/(ndiv_tau+0.0d0) 
      endif
      scaltau=scal_tau
      return
      end
c----------------------------------------------------------------------------
      subroutine force_scale(itrestr)
      implicit none
      integer itrestr
      include "DIMENSIONS"
      include "COMMON.MD"
      include "COMMON.NMR"
      include "COMMON.AVNLOC"
      include "COMMON.RESTARTED"
      include "COMMON.IOUNITS"
      double precision scal_fac
      double precision scaltau
      external scaltau
      if (ider_ave(itrestr).eq.1 .or. nonscal_ave_grad) then 
        scal_force(itrestr)=1.0
      else 
c
c Scaling tau
c
        if (nsteps(itrestr).eq.0) then
          scal_force(itrestr)=1.0
          idiv_tau(itrestr)=0
c          idiv_tau(itrestr)=1
c          icalls(itrestr)=1
        endif
c        if (mod(nsteps(itrestr),it_interval).eq.0) then
#ifdef DEBUG
        write (iout,*) "itrestr",itrestr," navint",navint,
     &   " idivtau",idiv_tau(itrestr)," ndiv_tau",ndiv_tau,
     &   " icalls",icalls(itrestr)
        write (iout,*) mod(nsteps(itrestr),it_interval),
     &   mod(icalls(itrestr),navint)
#endif
        if (mod(nsteps(itrestr),it_interval).eq.0 .and.
     &    (navint.eq.1 .or. mod(icalls(itrestr),navint).eq.1)) then
c          write (iout,*) "Inside if"
c          call flush(iout)
c          write (iout,*) "scal_fac",scal_fac
          if (idiv_tau(itrestr).gt.1) 
     &      scal_force(itrestr)=tau_temp(itrestr)/(d_time0*NAVINT)
     &       *(1.0d0-exp(-1.0d0))
          if (scal_force(itrestr).lt.1.0d0) scal_force(itrestr)=1.0d0
          idiv_tau(itrestr)=idiv_tau(itrestr)+1
          scal_fac = scaltau(tau,ndiv_tau,idiv_tau(itrestr)-1)
          tau_temp(itrestr) = tau*scal_fac
#ifdef DEBUG
          write(iout,"(3(a,1x,i10),1x,2(a,f12.5,1x))")
     &    "nsteps",nsteps(itrestr)," icalls",icalls(itrestr),
     &    " idiv_tau",idiv_tau(itrestr),
     &    " scal_fac",scal_fac,
     &    " tau_temp",tau_temp(itrestr)," scal_force",
     &     scal_force(itrestr)
c          write (iout,*) "NAVINT",navint
#endif
        endif
      endif
      return
      end
